﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="ZamestnanciNaUkolech.aspx.cs" Inherits="KSPortal.ZakSpec.UkolyOdmeny.ZamestnanciNaUkolech" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <script type="text/javascript" id="telerikClientEvents1">
//<![CDATA[
    function VyplatitOdm(args) {
        if (args) {
            var button = $get("<%=TRadButton2.ClientID %>");
            button.click(true);
        }
	}
//]]>
</script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy runat="server" ID="RAMP">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRCB_ukoly">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TDL_ukol" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid1" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRadGrid">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRadButton1">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRCB_ukoly" />
                    <telerik:AjaxUpdatedControl ControlID="TDL_ukol" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid1" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRadButton2">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRCB_ukoly" />
                    <telerik:AjaxUpdatedControl ControlID="TDL_ukol" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid1" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <asp:ObjectDataSource ID="ODS_ukoly" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="CiselnikUkolu" TypeName="KSProgram.ZakSpec.UkolyOdmeny">
        <SelectParameters>
            <asp:Parameter DefaultValue="" Name="id_ukolu" Type="Int32" />
            <asp:Parameter DefaultValue="false" Name="zustatky_na_odbor" Type="Boolean" />
            <asp:Parameter DefaultValue="true" Name="zustatky_na_ukol" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <kspwc:TRadComboBox ID="TRCB_ukoly" runat="server" DataSourceID="ODS_ukoly" DataTextField="nazev_rcb"
        DataValueField="id"  DropDownWidth="700px" MaxHeight="400px"
        HighlightTemplatedItems="true" Width="700px" Height="400px" AutoPostBack="True"
        OnSelectedIndexChanged="TRCB_ukoly_SelectedIndexChanged" OnDataBound="TRCB_ukoly_DataBound">
        <HeaderTemplate>
            <table>
                <tr>
                    <td style="width: 30px">
                        Id
                    </td>
                    <td style="width: 440px">
                        [%Název%]
                    </td>
                    <td style="width: 65px" align="right">
                        [%K rozdělení%]
                    </td>
                    <td style="width: 65px" align="right">
                        [%K vyplacení%]
                    </td>
                    <td style="width: 65px" align="right">
                        [%Odměna%]
                    </td>
                    <td style="width: 35px" align="right">
                        [%Cílový%]
                    </td>
                </tr>
            </table>
        </HeaderTemplate>
        <ItemTemplate>
            <table>
                <tr>
                    <td style="width: 30px">
                        <%# DataBinder.Eval(Container.DataItem, "id") %>
                    </td>
                    <td style="width: 440px">
                        <%# DataBinder.Eval(Container.DataItem, "nazev") %>
                    </td>
                    <td style="width: 65px" align="right">
                        <%# DataBinder.Eval(Container.DataItem, "k_rozdeleni", "{0:#,##0}")%>
                    </td>
                    <td style="width: 65px" align="right">
                        <%# DataBinder.Eval(Container.DataItem, "k_vyplaceni", "{0:#,##0}")%>
                    </td>
                    <td style="width: 65px" align="right">
                        <%# DataBinder.Eval(Container.DataItem, "kc_odm", "{0:#,##0}")%>
                    </td>
                    <td style="width: 35px" align="right">
                        <kspwc:TCheckBox ID="TCheckBox1" runat="server" Checked='<%# Eval("ind_cilodm") %>'
                            Enabled="False" />
                    </td>
                </tr>
            </table>
        </ItemTemplate>
    </kspwc:TRadComboBox>
    <br />
    <br />
    <asp:ObjectDataSource ID="ODS_ukol" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="CiselnikUkolu" TypeName="KSProgram.ZakSpec.UkolyOdmeny">
        <SelectParameters>
            <asp:ControlParameter ControlID="TRCB_ukoly" DefaultValue="-1" Name="id_ukolu" PropertyName="SelectedValue"
                Type="Int32" />
            <asp:Parameter DefaultValue="false" Name="zustatky_na_odbor" Type="Boolean" />
            <asp:Parameter DefaultValue="true" Name="zustatky_na_ukol" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <kspwc:TDataList ID="TDL_ukol" runat="server" DataSourceID="ODS_ukol" BorderStyle="None" CssClass="ksprvek"
        OnItemDataBound="TDL_ItemDataBound" OnItemCreated="TDL_ukol_ItemCreated">
        <ItemTemplate>
            <table>
                <tr>
                    <td>
                        [%Limit%]
                    </td>
                    <td>
                        <telerik:RadNumericTextBox ID="NTB_limit" Type="Number" runat="server" DataType="System.Decimal"
                            ReadOnly="True" DbValue='<%# Eval("kc_odm") %>' DbValueFactor="1">
                            <NumberFormat AllowRounding="false" DecimalDigits="0" />
                        </telerik:RadNumericTextBox>
                    </td>
                </tr>
                <tr>
                    <td>
                        [%Zbývá k rozdělení%]
                    </td>
                    <td>
                        <telerik:RadNumericTextBox ID="NTB_k_rozdeleni" ButtonsPosition="Right" Type="Number"
                            runat="server" DataType="System.Decimal" ReadOnly="True" DbValue='<%# Eval("k_rozdeleni") %>'>
                            <NumberFormat AllowRounding="false" DecimalDigits="0" />
                        </telerik:RadNumericTextBox>
                    </td>
                </tr>
                <tr>
                    <td>
                        [%Zbývá k vyplacení%]
                    </td>
                    <td>
                        <telerik:RadNumericTextBox ID="NTB_k_vyplaceni" ButtonsPosition="Right" Type="Number"
                            runat="server" DataType="System.Decimal" ReadOnly="True" DbValue='<%# Eval("k_vyplaceni") %>'>
                            <NumberFormat AllowRounding="false" DecimalDigits="0" />
                        </telerik:RadNumericTextBox>
                    </td>
                </tr>
                <tr>
                    <td>
                        <telerik:RadButton ID="RB_cil" runat="server" ToggleType="CheckBox" ButtonType="ToggleButton"
                            AutoPostBack="False" Enabled="False" Checked='<%# Eval("ind_cilodm") %>' >
                            <ToggleStates>
                                <telerik:RadButtonToggleState Text="[%Cílová odměna%]"></telerik:RadButtonToggleState>
                                <telerik:RadButtonToggleState Text="[%Mimořádná odměna%]"></telerik:RadButtonToggleState>
                            </ToggleStates>
                        </telerik:RadButton>
                    </td>
                    <td>
                        <telerik:RadButton ID="RB_cast" runat="server" ToggleType="CheckBox" ButtonType="ToggleButton"
                            AutoPostBack="false" Enabled="False" Checked='<%# Eval("ind_castec") %>'>
                            <ToggleStates>
                                <telerik:RadButtonToggleState Text="[%Částečné plnění%]"></telerik:RadButtonToggleState>
                                <telerik:RadButtonToggleState Text="[%Celé plnění%]"></telerik:RadButtonToggleState>
                            </ToggleStates>
                        </telerik:RadButton>
                    </td>
                </tr>
            </table>
        </ItemTemplate>
    </kspwc:TDataList>
    <br />
    <kspwc:TRadGrid ID="TRadGrid1" runat="server" AllowPaging="True" AllowSorting="True"
        AutoGenerateColumns="False" OnNeedDataSource="TRadGrid1_NeedDataSource" 
        OnItemDataBound="TRadGrid1_ItemDataBound" ShowGroupPanel="True" 
        PageSize="50"  AutoFilterControlWidth="False">
        <ClientSettings AllowColumnHide="True" AllowColumnsReorder="True" 
            ReorderColumnsOnClient="True" AllowDragToGroup="True">
        </ClientSettings>
        <ExportSettings>
            <Pdf PageWidth="">
            </Pdf>
        </ExportSettings>
        <GroupingSettings ShowUnGroupButton="True" />
        <MasterTableView DataKeyNames="id,os_cislo,cislo_pom,obd_vyplaty,schvaleno,kc_odm,kc_vyplaceni" Caption="[%Zaměstananci na úkolu%]"
            EnableHeaderContextMenu="True" EnableGroupsExpandAll="True" HierarchyLoadMode="Conditional"
            AllowMultiColumnSorting="True" GroupLoadMode="Client" CommandItemDisplay="Top">
            <Columns>
                <telerik:GridNumericColumn DataField="id" DataType="System.Int32" DecimalDigits="0"
                    FilterControlAltText="Filter id column" HeaderText="Id" UniqueName="id" 
                    FilterControlWidth="50px">
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="os_cislo" DataType="System.Decimal" DecimalDigits="0"
                    FilterControlAltText="Filter os_cislo column" 
                    HeaderText="[%Osobní číslo%]" UniqueName="os_cislo" FilterControlWidth="50px">
                    <HeaderStyle HorizontalAlign="Right" />
                    <ItemStyle HorizontalAlign="Right" />
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="cislo_pom" DataType="System.Int16" DecimalDigits="0"
                    FilterControlAltText="Filter cislo_pom column" HeaderText="[%Č. pom.%]" 
                    UniqueName="cislo_pom" FilterControlWidth="50px">
                </telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="kmen_str" FilterControlAltText="Filter kmen_str column"
                    HeaderText="[%Kmen. stř.%]" UniqueName="kmen_str" 
                    FilterControlWidth="50px">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="prijmeni" FilterControlAltText="Filter prijmeni column"
                    HeaderText="[%Příjmení%]" UniqueName="prijmeni" FilterControlWidth="70px">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="jmeno" FilterControlAltText="Filter jmeno column"
                    HeaderText="[%Jméno%]" UniqueName="jmeno" FilterControlWidth="70px">
                </telerik:GridBoundColumn>
                <telerik:GridTemplateColumn DataField="prihlasen" DataType="System.Boolean" FilterControlAltText="Filter prihlasen column"
                    HeaderText="[%Zařazen%]" UniqueName="prihlasen" GroupByExpression="Group By prihlasen"
                    SortExpression="prihlasen">
                    <ItemTemplate>
                        <telerik:RadButton ID="RB_prihlasen" runat="server" ToggleType="CheckBox" Checked='<%# Eval("prihlasen") %>'
                            CommandArgument='<%# Eval("os_cislo") %>' OnToggleStateChanged="RB_prihlasen_ToggleStateChanged">
                            <ToggleStates>
                                <telerik:RadButtonToggleState Text="[%Je zařazen%]" PrimaryIconCssClass="fi fi-checkbox"
                                    Value="True"></telerik:RadButtonToggleState>
                                <telerik:RadButtonToggleState Text="[%Není zařazen%]" PrimaryIconCssClass="fi fi-square"
                                    Value="False"></telerik:RadButtonToggleState>
                            </ToggleStates>
                        </telerik:RadButton>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn DataField="kc_odm" DataType="System.Decimal" FilterControlAltText="Filter kc_odm column"
                    HeaderText="[%Celková odměna%]" UniqueName="kc_odm" GroupByExpression="Group By kc_odm"
                    SortExpression="kc_odm">
                    <ItemTemplate>
                        <telerik:RadNumericTextBox ID="RNTB_kc_odm" runat="server" DbValue='<%# Bind("kc_odm") %>'
                            DbValueFactor="1" Enabled='<%# Eval("prihlasen") %>' 
                            Type="Number" Width="100px" DataType="System.Decimal" OnTextChanged="RNTB_kc_odm_TextChanged"
                            AutoPostBack="True" ShowSpinButtons="True" MinValue="0">
                            <IncrementSettings Step="1000" />
                            <NumberFormat DecimalDigits="0"/>
                        </telerik:RadNumericTextBox>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Right" />
                </telerik:GridTemplateColumn>
                <telerik:GridNumericColumn DataField="kc_vyplaceni" DataType="System.Decimal" DecimalDigits="0"
                    FilterControlAltText="Filter kc_vyplaceni column" HeaderText="[%Vyplaceno%]"
                    UniqueName="kc_vyplaceni" DataFormatString="{0:n2}" 
                    FilterControlWidth="70px">
                    <ItemStyle HorizontalAlign="Right" />
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="zbyva_vyplatit" DataType="System.Decimal" DecimalDigits="0"
                    FilterControlAltText="Filter zbyva_vyplatit column" HeaderText="[%Zbývá vyplatit%]"
                    UniqueName="zbyva_vyplatit" DataFormatString="{0:#,##0}" 
                    FilterControlWidth="70px">
                    <ItemStyle HorizontalAlign="Right" />
                </telerik:GridNumericColumn>
                <telerik:GridTemplateColumn DataField="kc_posledni" DataType="System.Decimal" FilterControlAltText="Filter kc_posledni column"
                    HeaderText="[%K výplatě%]" UniqueName="kc_posledni" GroupByExpression="Group By kc_posledni"
                    SortExpression="kc_posledni" FilterControlWidth="70px">
                    <ItemTemplate>
                        <telerik:RadNumericTextBox ID="RNTB_kc_posledni" runat="server" DbValue='<%# Bind("kc_posledni") %>'
                            DbValueFactor="1" Enabled='<%# Eval("prihlasen") %>' 
                            Type="Number" Width="100px" DataType="System.Decimal" OnTextChanged="RNTB_kc_posledni_TextChanged"
                            AutoPostBack="True" ShowSpinButtons="True" MinValue="0">
                            <IncrementSettings Step="1000" />
                            <NumberFormat DecimalDigits="0"/>
                        </telerik:RadNumericTextBox>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Right" />
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn DataField="obd_vyplaty" DataType="System.DateTime" FilterControlAltText="Filter obd_vyplaty column"
                    HeaderText="[%Obdobi výplaty%]" UniqueName="obd_vyplaty" GroupByExpression="Group By obd_vyplaty"
                    SortExpression="obd_vyplaty" FilterControlWidth="70px">
                    <ItemTemplate>
                        <kspwc:TRadMonthYearPicker ID="TRadMonthYearPicker1" runat="server" Culture="cs-CZ"
                            DbSelectedDate='<%# Bind("obd_vyplaty") %>' Enabled='<%# Eval("prihlasen") %>'
                            HiddenInputTitleAttibute="Visually hidden input created for functionality purposes."
                             OnSelectedDateChanged="TRadMonthYearPicker1_SelectedDateChanged"
                            AutoPostBack="True" Width="120px">
                        </kspwc:TRadMonthYearPicker>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridDateTimeColumn DataField="schvaleno" DataFormatString="{0:d.M.yyyy}"
                    DataType="System.DateTime" FilterControlAltText="Filter schvaleno column" FilterControlWidth="100px"
                    FilterDateFormat="{0:d.M.yyyy}" HeaderText="[%Schváleno%]" ReadOnly="True" UniqueName="schvaleno">
                </telerik:GridDateTimeColumn>
                <telerik:GridTemplateColumn FilterControlAltText="Filter PrintColumn column" UniqueName="PrintColumn"
                    Groupable="False" AllowFiltering="False" AllowSorting="False">
                    <ItemTemplate>
                        <telerik:RadButton ID="RB_print" runat="server" OnClick="RB_print_Click" Text="[%Zadávací list%]">
                            <Icon PrimaryIconCssClass="fi fi-print" PrimaryIconLeft="4" PrimaryIconTop="3"></Icon>
                        </telerik:RadButton>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridRowIndicatorColumn></telerik:GridRowIndicatorColumn>
            </Columns>
            <CommandItemTemplate>
                <table>
                    <tr>
                        <%--<td>
                            <kspwc:TRadButton ID="TRB_ch" runat="server" OnCheckedChanged="TRB_ch_CheckedChanged"
                                Text="[%Filtr%]" ToggleType="CheckBox">
                            </kspwc:TRadButton>
                        </td>
                        <td>
                            <kspwc:TRadButton ID="TRB_rebind" runat="server" Text="[%Obnovit%]" CommandName="RebindGrid">
                                <Icon PrimaryIconCssClass="rbRefresh" PrimaryIconLeft="4" PrimaryIconTop="3"></Icon>
                            </kspwc:TRadButton>
                        </td>--%>
                        <%--<td>
                            <kspwc:ExportGridButton ID="ExportGridButton1" runat="server" />
                        </td>--%>
                        <kspwc:GridCommandItemControl runat="server" ID="GCIC">
                            <ExportButton runat="server" Visible="false" />
                        </kspwc:GridCommandItemControl>
                    </tr>
                </table>
            </CommandItemTemplate>
        </MasterTableView>
    </kspwc:TRadGrid>
    <br />
    <%--<kspwc:TRadButton ID="TRadButton1" runat="server" OnClick="TRadButton1_Click" OnLoad="TRadButton1_Load"
        Text="[%Vyplatit%]" ConfirmText="[%Opravdu chcete vyplatit odměny?%]" ConfirmTitle="[%Vyplacení odměn%]">
    </kspwc:TRadButton>--%>
    <kspwc:TRadButton ID="TRadButton1" runat="server" OnClick="TRadButton1_Click" OnLoad="TRadButton1_Load"
        Text="[%Vyplatit%]" ConfirmTitle="[%Vyplacení odměn%]">
    </kspwc:TRadButton>
     <kspwc:TRadButton ID="TRadButton2" runat="server" OnClick="TRadButton2_Click" CssClass="hidden">
    </kspwc:TRadButton>
</asp:Content>
