﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="PredpisySestava.aspx.cs" Inherits="KSPortal.ZakSpec.PredpisySestava" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="../Controls/VyhledaniZam.ascx" TagName="VyhlZam" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <style type="text/css">
    .rcbTemplate {
    padding: 10px 10px 10px 100px !important;
    border: 0 !important;
    border-bottom: 1px solid #cccccc !important;
    *zoom: 1;
}
.rcbTemplate:after {
    content: "";
    height: 0;
    clear: both;
    display: block;
}
    .rcbTemplate .imageWrap {
        margin: 0 0 0 -85px;
        float: left;
    }
 
    .rcbTemplate .imageWrap img 
    {        
        border-radius: 5px;
        border: 1px solid #ccc; 
        max-width:58px;
        max-height:58px;    
    }
 
 
    .rcbTemplate .personDetails {
        margin: 0;
        padding: 0;
        list-style: none;
    }
 
 
    .rcbTemplate .name {
        font-weight: bold;
    }
    .rcbTemplate .misto {
        font-size: small;
    }
    .rcbTemplate .os_cislo {
        font-weight: bold;
    }
  </style>

    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TGridView1">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TGridView1" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
     <asp:Label runat="server" ID="lab_nadpis" Text="[%Prohlášení - předpisy a normy%]" CssClass="nadpis1"></asp:Label>
    <table>
        <tr>
            <td>                
                <uc1:VyhlZam runat="server" ID="VyhlZam" Prava="false"></uc1:VyhlZam>               
                <kspwc:TRadButton runat="server" ID="lb_generovat" Text="[%Generovat požadavek pro vybraného zaměstnance%]" OnClick="lb_generovat_Click" >
                </kspwc:TRadButton>
            </td>
        </tr>
        <tr>
            <td>
                <kspwc:TRadGrid ID="TGridView1" runat="server" ShowTitleRow="True" 
                                AllowPaging="True" AllowMultiRowSelection="True"
                                AllowSorting="True" AutoGenerateColumns="False"
                                OnNeedDataSource="TGridView1_NeedDataSource" 
                                 ShowFooter="true" 
                                PageSize="50" >
                                <PagerStyle Mode="NextPrevNumericAndAdvanced" PageSizes="50,100,150"></PagerStyle>
                                <ExportSettings HideStructureColumns="true" OpenInNewWindow="true">
                                </ExportSettings>
                                <MasterTableView CommandItemDisplay="Top" Caption="" DataKeyNames="os_cislo">
                                    <CommandItemSettings ShowExportToExcelButton="true" ShowAddNewRecordButton="false">
                                    </CommandItemSettings>
                                    <ColumnGroups>
                                        <telerik:GridColumnGroup HeaderText="Soudní a trestní řízení" Name="soud" HeaderStyle-HorizontalAlign="Center"></telerik:GridColumnGroup>
                                        <telerik:GridColumnGroup HeaderText="Střet zájmů" Name="stred_zajmu" HeaderStyle-HorizontalAlign="Center"></telerik:GridColumnGroup>
                                        <telerik:GridColumnGroup HeaderText="Finanční závazky" Name="fin_zavazky" HeaderStyle-HorizontalAlign="Center"></telerik:GridColumnGroup>
                                    </ColumnGroups>
                                    <Columns>                                 
                                        <telerik:GridBoundColumn DataField="os_cislo" SortExpression="os_cislo" HeaderText="[%Os. číslo%]" >
                                            <ItemStyle HorizontalAlign="Right" />
                                            <HeaderStyle HorizontalAlign="Right" />
                                        </telerik:GridBoundColumn>                                       
                                        <telerik:GridBoundColumn DataField="prijmeni" SortExpression="prijmeni" HeaderText="[%Příjmení%]" />
                                        <telerik:GridBoundColumn DataField="jmeno" SortExpression="jmeno" HeaderText="[%Jméno%]" />                                       
                                        <telerik:GridBoundColumn DataField="kmen_str" SortExpression="kmen_str" HeaderText="[%Kmen. stř.%]" />
                                         <telerik:GridBoundColumn DataField="id_poz" SortExpression="id_poz" HeaderText="[%Id požadavku%]" />
                                        <telerik:GridBoundColumn DataField="stav" SortExpression="stav" HeaderText="[%Stav%]" >
                                             <FilterTemplate>
                            <telerik:RadComboBox  ID="RadComboBoxStav" DataSourceID="ds_stavy" DataTextField="text_stavu"
                                DataValueField="text_stavu" Width="200px" AppendDataBoundItems="true" SelectedValue='<%# ((GridItem)Container).OwnerTableView.GetColumn("stav").CurrentFilterValue %>'
                                runat="server" OnClientSelectedIndexChanged="StavIndexChanged">
                                <Items>
                                    <telerik:RadComboBoxItem Text="[Vše]" />
                                </Items>
                            </telerik:RadComboBox>
                            <telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
                                <script type="text/javascript">
                                    function StavIndexChanged(sender, args) {
                                        var tableView = $find("<%# ((GridItem)Container).OwnerTableView.ClientID %>");
                                    tableView.filter("stav", args.get_item().get_value(), "EqualTo");
                                }
                                </script>
                            </telerik:RadScriptBlock>
                        </FilterTemplate>
                                        </telerik:GridBoundColumn>                                        
                                        <telerik:GridBoundColumn DataField="datum" SortExpression="stav" HeaderText="[%Ze dne%]" DataFormatString="{0:d}" />

                                        <telerik:GridCheckBoxColumn  DataField="CheckBox_soud" SortExpression="CheckBox_soud" HeaderText="[%Soud%]" ColumnGroupName="soud" />
                                        <telerik:GridCheckBoxColumn DataField="CheckBox_soud2" SortExpression="CheckBox_soud2" HeaderText="[%Trestní%]"  ColumnGroupName="soud" />

                                        <telerik:GridCheckBoxColumn DataField="CheckBox_stred_zajmu" SortExpression="CheckBox_stred_zajmu" HeaderText="[%Příbuzný%]" ColumnGroupName="stred_zajmu" />
                                        <telerik:GridCheckBoxColumn DataField="CheckBox_stred_zajmu2" SortExpression="CheckBox_stred_zajmu2" HeaderText="[%Příbuzní dodavatel%]"  ColumnGroupName="stred_zajmu"  />
                                        <telerik:GridCheckBoxColumn DataField="CheckBox_stred_zajmu3" SortExpression="CheckBox_stred_zajmu3" HeaderText="[%Vedlejší činnost%]"  ColumnGroupName="stred_zajmu" />
                                        <telerik:GridCheckBoxColumn DataField="CheckBox_stred_zajmu4" SortExpression="CheckBox_stred_zajmu4" HeaderText="[%Statutár%]"  ColumnGroupName="stred_zajmu" />                                       
                                        <telerik:GridCheckBoxColumn DataField="CheckBox_stred_zajmu5" SortExpression="CheckBox_stred_zajmu5" HeaderText="[%Vztah s bankou%]"  ColumnGroupName="stred_zajmu" />
                                        <telerik:GridCheckBoxColumn DataField="CheckBox_stred_zajmu6" SortExpression="CheckBox_stred_zajmu6" HeaderText="[%Politika%]"  ColumnGroupName="stred_zajmu" />

                                        <telerik:GridCheckBoxColumn DataField="CheckBox_fin_zavazky" SortExpression="CheckBox_fin_zavazky" HeaderText="[%Závazek v prodlení%]"   ColumnGroupName="fin_zavazky" />
                                        <telerik:GridCheckBoxColumn DataField="CheckBox_fin_zavazky2" SortExpression="CheckBox_fin_zavazky2" HeaderText="[%Exekuce/Insolvence%]"  ColumnGroupName="fin_zavazky" />
                                        
                                    </Columns>
                                    
                                    <CommandItemTemplate>
                                        <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server">
                                            <ExportButton ID="ExportButton1" runat="server" ShowExportToExcelHtmlItem="false" ShowExportToExcelBIFFItem="true"/>
                                        </kspwc:GridCommandItemControl>
                                    </CommandItemTemplate>
                                </MasterTableView>
                            </kspwc:TRadGrid>
            </td>
        </tr>
    </table>
    <asp:ObjectDataSource ID="ds_stavy" runat="server" SelectMethod="StavyAll" TypeName="KSPortal.ZakSpec.PredpisySestava"  >
       <%--<SelectParameters>
              <asp:Parameter DefaultValue="" Name="typ" Type="String" />
       </SelectParameters>--%>
    </asp:ObjectDataSource>
</asp:Content>
