﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="PrirazovaniSablon.aspx.cs" Inherits="KSPortal.ZakSpec.OdmenyPtacek.PrirazovaniSablon" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <%-- <link rel="stylesheet" href="../../kendo/styles/kendo.common.min.css" />
    <link rel="stylesheet" href="../../kendo/styles/kendo.default-main.css" />--%>
<%--    <link rel="stylesheet" href="../../styles/kendo.default.mobile.min.css" />--%>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="grid_prirazeni">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="grid_prirazeni" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

    <style type="text/css">
         #ctl00_HlavniOblast_RW_sablony_C_TRadGrid_sablony_ctl00 .rgCaption,
         #RadWindowWrapper_ctl00_HlavniOblast_rw_polozky .rgCaption,
         #ctl00_HlavniOblast_RW_sablony_C .rgCaption
        {
            display:none;
        }
        #ctl00_HlavniOblast_RW_sablony_C_TRadGrid_sablony_ctl00 .gridWidth 
        {
            width:150px !important;
        }
        .command{
            margin:10px;  
            text-align:right;
        }
        .comm{
           /* width:50% !important;
            float:left;
            text-align:center;  
               */
           padding:5px;
        }
        #RadWindowWrapper_ctl00_HlavniOblast_rw_polozky .rgDataDiv
        {
            overflow-x: hidden !important;
        }
          .popisek{
              width:150px;
              padding:3px;
          }
          .hodnota{
              padding:3px;
          }
          #editaceform{
              padding-top:10px;
              padding-bottom:10px;
          }
          .sablspan:hover
          {
              background-color:gray;
              color:white;
              cursor:pointer;
          }
          .sablspan
          {
              min-width:80px !important;
              display:inline-block;
              white-space:nowrap;
          }
    </style>
    
     <telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
         <script src="../../kendo/js/kendo.all.min.js" type="text/javascript"></script>
    <script type="text/javascript">
        var sablona_id_pracmist=0;
        var sablona_rok=0;
        var sablona_mes = 0;
        var sablona_edited_item_index = 0;
        var nazev_mista = "";
        var sablona_nazev_mista = "";
        var sablona_cely_nazev = "";

        var sablonaIdPm = "";
        var sablonaKey = "";

        var sablona_polozka = "";

        function rb_add_OnClientClicked(sender, args) {            
            var arr = sender.get_commandArgument().split("|");
            sablona_id_pracmist = arr[0];
            sablona_rok = arr[1];
            sablona_mes = arr[2];
            sablona_edited_item_index = arr[3];
            nazev_mista = arr[4];

            var mtb = $find("<%= grid_prirazeni.ClientID %>").get_masterTableView();
            mtb.clearSelectedItems();
            mtb.selectItem(sablona_edited_item_index);           

            retrieveSablonyGrid();
        }

        function retrieveSablonyGrid() {
            getSablonyData();
        }
        function getSablonyData() {
            var grid = $find("<%= TRadGrid_sablony.ClientID %>");
            if (grid) {
                var tableView = grid.get_masterTableView();
                if (tableView != null) {
                    PageMethods.GetSablony(sablona_id_pracmist, sablona_rok, sablona_mes, updateSablonyGrid, onPageMethodError);
                }
            }
        }
        function updateSablonyGrid(result) {
            var tableView = $find("<%= TRadGrid_sablony.ClientID %>").get_masterTableView();
            tableView.set_dataSource(result.Data);
            tableView.dataBind();           
            var dtItems = tableView.get_dataItems();
            for (var i = 0; i < result.Data.length; i++) {
                var checkBox = dtItems[i].findElement("check_box");
                if (checkBox != null) {
                    checkBox.checked = result.Data[i].Zatrzeno;
                }
            }
            var wnd = $find("<%= RW_sablony.ClientID %>");
            if (wnd.isClosed())
                wnd.show();
          
        }
        function cb_zrusit_OnClientClicked(sender, args) {          
            $find("<%= RW_sablony.ClientID %>").close();              
        }

        function cb_zrusit2_OnClientClicked(sender, args) {
            $find("<%= rw_polozky.ClientID %>").close();
        }

        function cb_ok_OnClientClicked(sender, args) {           
            var masterTable=$find("<%= TRadGrid_sablony.ClientID %>").get_masterTableView();
            var selectedSablony = "";
            var dataItems = masterTable.get_dataItems();
            for (var i = 0; i < dataItems.length; i++) {             
                var checkBox = dataItems[i].findElement("check_box");                
                if (checkBox.checked) {
                    selectedSablony += dataItems[i].getDataKeyValue("SablonaKey") + ",";
                }                
            }
            PageMethods.UlozSablony(sablona_id_pracmist, sablona_rok, sablona_mes, selectedSablony, updateSablonyGridRow, onPageMethodError);
        }
        function updateSablonyGridRow(args) {           
            $find("<%= RW_sablony.ClientID %>").close();
            var masterTable = $find("<%= grid_prirazeni.ClientID %>").get_masterTableView();
            var item = masterTable.get_dataItems()[sablona_edited_item_index];
            var ele = item.get_element();
            for (var i = 1; i <= 13; i++) {               
                var span = ele.getElementsByClassName("d_Sablona_" + i.toString())[0];
                span.innerHTML = "";                
                span.removeAttribute('sablonakey');
                span.removeAttribute('idpm');
            }

            if (args.Data != null) {
                for (var i = 0; i < args.Data.length; i++) {                   
                    var span = ele.getElementsByClassName("d_Sablona_" + (i + 1).toString())[0];
                    span.innerHTML = args.Data[i].SablonaNazev;
                    span.setAttribute('sablonakey', args.Data[i].SablonaKey);
                    span.setAttribute('idpm', sablona_id_pracmist);
                }
            }
        }        

        function OnClientBeforeShow(sender, args) {
            document.getElementById("div_nadpis").innerHTML = nazev_mista;          
        }

        function rw_polozky_OnClientBeforeShow(sender, args) {            
         
        }
        function rw_polozky_OnClientShow(sender, args) {            
           
        }

        function nastavNadpis() {
            //setTimeout(document.getElementById("div_nadpis_polozky").innerHTML = sablona_cely_nazev + "  " + sablona_nazev_mista, 200);
            document.getElementById("div_nadpis_polozky").innerHTML = sablona_cely_nazev + "  " + sablona_nazev_mista;
        }

        function retrieveSablonaDetailGrid() {
            getSablonaDetailData(sablonaIdPm, sablonaKey);           
            var wnd = $find("<%= rw_polozky.ClientID %>");
            if (wnd.isClosed()) {
                wnd.show();
                rw_polozky_OnClientResizeEnd();
            }
        }

        function getSablonaDetailData(idpm, sablonaKey) {
            var grid = $find("<%= grid_detail.ClientID %>");
            if (grid) {
                var tableView = grid.get_masterTableView();
                if (tableView != null) {                   
                    PageMethods.GetSablonaDetail(idpm, sablonaKey, updateSablonaDetailGrid, onPageMethodError);
                }
            }
        }
        function updateSablonaDetailGrid(result) {            
            var tableView = $find("<%= grid_detail.ClientID %>").get_masterTableView();            
            tableView.set_dataSource(result.Data);
            tableView.dataBind();                
        }      

        function rb_ok2_OnClientClicked(sender, args) {          
        }

        var oldPageLoad1 = !oldPageLoad1 ? KSMaster.onPageLoad : oldPageLoad1;
        KSMaster.onPageLoad = function () {
            oldPageLoad1.apply();             
            $(".sablspan").dblclick(function () {               
                sablonaKey = $(this).attr("sablonakey");
                sablonaIdPm = $(this).attr("idpm");              
               
                sablona_cely_nazev = this.innerHTML;
                if (sablonaKey != undefined && sablonaKey !== "" && sablonaIdPm != undefined && sablonaIdPm !== "") {
                    var masterView = $find("<%= grid_prirazeni.ClientID %>").get_masterTableView();
                    var selRow = masterView.get_selectedItems();                   
                    if (selRow.length > 0) {
                        sablona_nazev_mista = masterView.getCellByColumnUniqueName(selRow[0], "col_nazev_pm").innerHTML;
                    }
                    retrieveSablonaDetailGrid();
                    nastavNadpis();
                }
            });

            $('#rb_zavrit').click(function () {
                cb_zrusit2_OnClientClicked(this);
            })
        };
        KSMaster.onPageLoad.prototype = oldPageLoad1.prototype;
      
        function dblRowClick(sender, args) {          
            sablona_polozka=args.getDataKeyValue("Polozka");
            $find("<%= rw_edit.ClientID %>").show();          
            var height = 330;
            if (sablonaIdPm > 0)
                height = 280;
            $find("<%= rw_edit.ClientID %>").setSize(600, height);
        }

        function rw_edit_OnClientBeforeShow(sender, args) {
            PageMethods.GetPolozkaSablony(sablonaIdPm, sablonaKey, sablona_polozka, updateEditForm, onPageMethodError);
        }

        function updateEditForm(args) {
            kendoForm(args.Data[0]);
        }

        function kendoForm(d) {
            $('#editaceform').append($('<form id="editaceforminner" >').html(''));
            var frmData = {};
            var itms = [];
            frmData = {
                Polozka: d["Polozka"],
            };
            itms.push({
                field: "Polozka",
                label: "Identifikace položky:",
                editor: "TextBox",
                editorOptions: {
                    readonly: true
                }
            });

            if (sablonaIdPm > 0) {
                frmData.Popisek = d["Popisek"];
                itms.push({
                    field: "Popisek",
                    label: "Popisek:",
                    editor: "TextBox",
                    editorOptions: {
                        readonly: true
                    }
                });

                frmData.Editovatelnost = d["Editovatelnost"];
                itms.push({
                    field: "Editovatelnost",
                    label: "Editovatelný:",
                    editor: "CheckBox",
                    editorOptions: {
                        enabled: d["IsEditovatelnostSettable"]
                    }
                });

                frmData.Visible = d["Visible"];
                itms.push({
                    field: "Visible",
                    label: "Zobrazení:",
                    editor: "CheckBox",
                    editorOptions: {
                        enabled: d["IsVisibleSettable"]
                    }
                });

            }
            else {
                frmData.PopisekDefault = d["PopisekDefault"];
                itms.push({
                    field: "PopisekDefault",
                    label: "Popisek systémový:",
                    editor: "TextBox",
                    editorOptions: {
                        readonly: true
                    }
                });

                frmData.PopisekApp = d["PopisekApp"];
                itms.push({
                    field: "PopisekApp",
                    label: "Popisek uživatelský:",
                    editor: "TextBox",
                    //editorOptions: {
                    //    enabled: false
                    //}
                });
            }

            if (!(sablonaIdPm > 0)) {

                frmData.WidthDefault = d["WidthDefault"];
                itms.push({
                    field: "WidthDefault",
                        editor: "TextBox",
                            label: "Šířka systémová:",
                                editorOptions: {
                        readonly: true
                    }
                });

                frmData.WidthApp = d["WidthApp"];
                itms.push({
                    field: "WidthApp",
                    editor: "NumericTextBox",
                    label: "Šířka uživatelská:",                   
                    decimals: 0,
                    editorOptions: {
                        enabled: d["IsWidthSettable"],
                        format: "n0"
                    }
                });

                frmData.Zapocet1 = d["Zapocet1"];
                itms.push({
                    field: "Zapocet1",
                    editor: "CheckBox",
                    label: "Započet garance:",                   
                    editorOptions: {
                        enabled: true                        
                    }
                });
            }

            var par = {
                orientation: "horizontal",
                buttonsTemplate: '<button class="k-button k-primary" id="b_save_polozku" k-form-submit" type="submit" >Uložit</button><button class="k-button k-form-clear">Zavřít</button>',
                
                formData: frmData,
                items: itms,

                //validateField: function (e) {
                //    validationSuccess.html("");
                //},
                submit: function (e) {                    
                    e.preventDefault();
                    var frm = $("#editaceforminner");
                    //var pol = frm.find("#Polozka").val();

                    var edit = null;
                    var visible = null;
                   
                    if (sablonaIdPm > 0) {
                        if ($("#Editovatelnost").kendoCheckBox().data("kendoCheckBox").options.enabled)
                            edit = $("#Editovatelnost").kendoCheckBox().data("kendoCheckBox").check();
                        if ($("#Visible").kendoCheckBox().data("kendoCheckBox").options.enabled)
                            visible = $("#Visible").kendoCheckBox().data("kendoCheckBox").check();                        

                        PageMethods.UlozPolozkuPM(sablonaIdPm, sablonaKey, sablona_polozka, edit, visible, updateDetailGrid, onPageMethodError);
                    }
                    else {                       
                        var pop_uziv = null
                        if (!frm.find("#PopisekApp").readOnly)
                            pop_uziv = frm.find("#PopisekApp").val();

                        var sirka = null;
                        if (!frm.find("#WidthApp").readOnly)
                            sirka = frm.find("#WidthApp").val();

                        var zapocet1 = null;
                        if (!frm.find("#Zapocet1").readOnly)
                            zapocet1 = $("#Zapocet1").kendoCheckBox().data("kendoCheckBox").check();

                        PageMethods.UlozPolozku(sablonaKey, sablona_polozka, pop_uziv, sirka, zapocet1, updateDetailGrid);
                    }
                    //validationSuccess.html("<div class='k-messagebox k-messagebox-success'>Form data is valid!</div>");

                },
                clear: function (ev) {
                    $find("<%= rw_edit.ClientID %>").close()
                }
            };

            $("#editaceforminner").kendoForm(par);            
        }

        function rw_edit_OnClientClose(sender, args) {
          
        }

        function rw_edit_OnClientBeforeClose(sender, args) {
            $("#editaceforminner").getKendoForm().clear();
            $("#editaceforminner").unbind();
            $("#editaceforminner").getKendoForm().destroy();
            $("#editaceforminner").empty();
            $("#editaceforminner").remove();
        }

        function grid_detail_OnDataBound(sender, args) {
            var mtv = $find("<%= grid_detail.ClientID %>").get_masterTableView();
            var columns = mtv.get_columns();

            for (var i = 0; i < columns.length; i++) {
                if (i > 1) {
                    mtv.showColumn(i);
                    if (sablonaIdPm > 0) {
                        if (columns[i].get_uniqueName() == "col_PopisekSystemovy" ||
                            columns[i].get_uniqueName() == "col_PopisekUzivatelsky" ||
                            columns[i].get_uniqueName() == "col_SirkaApp" ||
                            columns[i].get_uniqueName() == "col_SirkaSystemova" ||
                            columns[i].get_uniqueName() == "col_Zapocet1")
                            mtv.hideColumn(i);
                    }
                    else {
                        if (columns[i].get_uniqueName() == "col_Zobraz" ||
                            columns[i].get_uniqueName() == "col_Popisek")                           
                            mtv.hideColumn(i);
                    }
                }
            }
        }

        function updateDetailGrid(data) {          
            var tableView = $find("<%= grid_detail.ClientID %>").get_masterTableView();
            var dataItems = tableView.get_dataItems();
            for (var i = 0; i < dataItems.length; i++) {
                if (dataItems[i].get_cell("col_Polozka").innerHTML == data.Data.Polozka) {                   
                    if (data.Data.PopisekApp != null)
                        dataItems[i].get_cell("col_PopisekUzivatelsky").innerHTML = data.Data.PopisekApp;
                    if (data.Data.WidthApp != null)
                        dataItems[i].get_cell("col_SirkaApp").innerHTML = data.Data.WidthApp;
                  
                    var cz = dataItems[i].get_cell("col_Zapocet1");
                    var carrz = cz.getElementsByTagName('input');
                    if (carrz.length > 0) {
                        carrz[0].checked = data.Data.Zapocet1;
                    }                 

                    if (data.Data.Editovatelnost != null) {
                        var cell=dataItems[i].get_cell("col_Editace");
                        var carr = cell.getElementsByTagName('input');
                        if (carr.length > 0) {
                            carr[0].checked = data.Data.Editovatelnost;
                        }
                    }
                    
                    if (data.Data.Visible != null) {
                        var cell = dataItems[i].get_cell("col_Zobraz");
                        var carr = cell.getElementsByTagName('input');
                        if (carr.length > 0) {
                            carr[0].checked = data.Data.Visible;
                        }
                    }

                    break;
                }  
            }

            $find("<%= rw_edit.ClientID %>").close();
        }

        function onPageMethodError(err) {
            if (err) {
                var title = err.get_exceptionType();
                var text = err.get_message();
                if (title)
                    KSMaster.showError(text, title);
            }
        }

        function grid_vychozi_OnRowDblClick(sender, args) {
            $find("<%= grid_prirazeni.ClientID %>").clearSelectedItems();
            sablona_nazev_mista = "výchozí nastavení";
            nastavNadpis();
        }

        function rw_polozky_OnClientResizeEnd(sender, args) {
            var wnd=$find("<%= rw_polozky.ClientID %>");
             var grid=$find("<%= grid_detail.ClientID %>");           
            var wndBounds = wnd.getWindowBounds();
            var grid = $find("<%= grid_detail.ClientID %>");
            grid.get_element().style.height = wndBounds.height - 100 + "px";
            grid.repaint();         
        }
        

    </script>
</telerik:RadScriptBlock>
    <div style="padding-bottom:40px;">
    <asp:Label runat="server" ID="Label1" CssClass="nadpis1" Text="[%Výchozí nastavení šablon%]" ></asp:Label>      
     <kspwc:TRadGrid ID="grid_vychozi" runat="server" AllowPaging="False" Width="100%" NotifikaceDisable="false" OnNeedDataSource="grid_vychozi_NeedDataSource" 
          AllowRowSelection="False" AllowMultiRowSelection="False" AllowSorting="false" >              
     <MasterTableView  AutoGenerateColumns="False" CssClass="nocaption" CommandItemDisplay="None" AllowPaging="false" ShowHeader="false"  >                                              
                        <Columns>                           
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.1%]" UniqueName="col_sablona_1" SortExpression="Sablona1" DataField="Sablona1" DataType="System.String"  ReadOnly="true" >
                                 <ItemTemplate>
                                     <span class="d_Sablona_1 sablspan"  id="d_Sablona_1" sablonakey='<%# Eval("SablonaKey1") %>' idpm="0"  ><%# Eval("Sablona1") %></span>                                  
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn> 
                            <telerik:GridTemplateColumn HeaderText="[%Šablona č.2%]" UniqueName="col_sablona_2" SortExpression="Sablona2" DataField="Sablona2" DataType="System.String"  ReadOnly="true" >  
                                 <ItemTemplate>
                                     <span class="d_Sablona_2 sablspan"  id="d_Sablona_2" sablonakey='<%# Eval("SablonaKey2") %>' idpm="0"><%# Eval("Sablona2") %>  </span>                                      
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn> 
                            <telerik:GridTemplateColumn HeaderText="[%Šablona č.3%]" UniqueName="col_sablona_3" SortExpression="Sablona3" DataField="Sablona3" DataType="System.String"  ReadOnly="true" >    
                                 <ItemTemplate>
                                     <span class="d_Sablona_3 sablspan"  id="d_Sablona_3" sablonakey='<%# Eval("SablonaKey3") %>' idpm="0"><%# Eval("Sablona3") %></span>                                
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn> 
                            <telerik:GridTemplateColumn HeaderText="[%Šablona č.4%]" UniqueName="col_sablona_4" SortExpression="Sablona4" DataField="Sablona4" DataType="System.String"  ReadOnly="true" > 
                                 <ItemTemplate>
                                     <span class="d_Sablona_4 sablspan"  id="d_Sablona_4" sablonakey='<%# Eval("SablonaKey4") %>' idpm="0"><%# Eval("Sablona4") %></span>                                    
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn> 
                            <telerik:GridTemplateColumn HeaderText="[%Šablona č.5%]" UniqueName="col_sablona_5" SortExpression="Sablona5" DataField="Sablona5" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_5 sablspan" id="d_Sablona_5" sablonakey='<%# Eval("SablonaKey5") %>' idpm="0"><%# Eval("Sablona5") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>          
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.6%]" UniqueName="col_sablona_6" SortExpression="Sablona6" DataField="Sablona6" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_6 sablspan" id="d_Sablona_6" sablonakey='<%# Eval("SablonaKey6") %>' idpm="0"><%# Eval("Sablona6") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.7%]" UniqueName="col_sablona_7" SortExpression="Sablona7" DataField="Sablona7" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_7 sablspan" id="d_Sablona_7" sablonakey='<%# Eval("SablonaKey7") %>' idpm="0"><%# Eval("Sablona7") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.8%]" UniqueName="col_sablona_8" SortExpression="Sablona8" DataField="Sablona8" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_8 sablspan" id="d_Sablona_8" sablonakey='<%# Eval("SablonaKey8") %>' idpm="0"><%# Eval("Sablona8") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.9%]" UniqueName="col_sablona_9" SortExpression="Sablona9" DataField="Sablona9" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_9 sablspan" id="d_Sablona_9" sablonakey='<%# Eval("SablonaKey9") %>' idpm="0"><%# Eval("Sablona9") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.10%]" UniqueName="col_sablona_10" SortExpression="Sablona10" DataField="Sablona10" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_10 sablspan" id="d_Sablona_10" sablonakey='<%# Eval("SablonaKey10") %>' idpm="0"><%# Eval("Sablona10") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.11%]" UniqueName="col_sablona_11" SortExpression="Sablona11" DataField="Sablona11" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_11 sablspan" id="d_Sablona_11" sablonakey='<%# Eval("SablonaKey11") %>' idpm="0"><%# Eval("Sablona11") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.12%]" UniqueName="col_sablona_12" SortExpression="Sablona12" DataField="Sablona12" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_12 sablspan" id="d_Sablona_12" sablonakey='<%# Eval("SablonaKey12") %>' idpm="0"><%# Eval("Sablona12") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.13%]" UniqueName="col_sablona_13" SortExpression="Sablona13" DataField="Sablona13" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_13 sablspan" id="d_Sablona_13" sablonakey='<%# Eval("SablonaKey13") %>' idpm="0"><%# Eval("Sablona13") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>      

                        </Columns>                          
                    </MasterTableView>  
         <ClientSettings>
             <ClientEvents OnRowDblClick="grid_vychozi_OnRowDblClick" />
         </ClientSettings>
                </kspwc:TRadGrid>

   </div>


    <asp:Label runat="server" ID="lab_nadpis" CssClass="nadpis1" Text="[%Přiřazování šablon pracovním pozicím / místům%]" ></asp:Label>
    <div>
      <kspwc:TRadComboBox runat="server" ID="rcm_filtr" EmptyMessage="Výběr pracovní pozice / místa" OnSelectedIndexChanged="rcm_filtr_SelectedIndexChanged" AutoPostBack="true" Width="300" >
            <Items>
                 <telerik:RadComboBoxItem Text="Pracovní pozice" Value="2" Selected="true" />
                <telerik:RadComboBoxItem Text="Pracovní místa" Value="3" />
            </Items>
        </kspwc:TRadComboBox>
        </div>
     <kspwc:TRadGrid ID="grid_prirazeni" runat="server" AllowPaging="False" Width="100%" NotifikaceDisable="false" OnNeedDataSource="grid_prirazeni_NeedDataSource" 
         OnItemDataBound="grid_prirazeni_ItemDataBound" AllowRowSelection="True" AllowMultiRowSelection="False" AllowSorting="true" AllowFilteringByColumn="true" >   
                     <ClientSettings EnableAlternatingItems="true"  EnableRowHoverStyle="true" Selecting-AllowRowSelect="true"  >
</ClientSettings>                       
     <MasterTableView  AutoGenerateColumns="False" DataKeyNames="Id,NazevPM" CssClass="nocaption" CommandItemDisplay="Top" AllowPaging="true"  >                                              
                        <Columns> 
                            <telerik:GridClientSelectColumn Display="false" ></telerik:GridClientSelectColumn>
                             <telerik:GridBoundColumn HeaderText="[%Číslo PM%]" UniqueName="col_cislo" SortExpression="Cislo" DataField="Cislo" DataType="System.String" ReadOnly="true" >                                                                                                         
                            </telerik:GridBoundColumn>            
                            <telerik:GridBoundColumn HeaderText="[%Název PM%]" UniqueName="col_nazev_pm" SortExpression="NazevPM" DataField="NazevPM" DataType="System.String"  ReadOnly="true" >                                                                                                         
                            </telerik:GridBoundColumn> 

                           <telerik:GridTemplateColumn HeaderText="[%Přidat%]" UniqueName="col_pridat" Exportable="false">
                               <ItemTemplate>
                                   <telerik:RadButton RenderMode="Classic" ID="rb_add" runat="server" Text="[%Přidat šablonu%]" OnClientClicked="rb_add_OnClientClicked" AutoPostBack="false">
                                    <Icon PrimaryIconCssClass="rbAdd"></Icon>
                                </telerik:RadButton>
                               </ItemTemplate>
                           </telerik:GridTemplateColumn>
                         
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.1%]" UniqueName="col_sablona_1" SortExpression="Sablona1" DataField="Sablona1" DataType="System.String"  ReadOnly="true" AllowFiltering="true" >
                                 <ItemTemplate>
                                     <span class="d_Sablona_1 sablspan"  id="d_Sablona_1" sablonakey='<%# Eval("SablonaKey1") %>' idpm='<%# Eval("Id") %>'  ><%# Eval("Sablona1") %></span>                                  
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn> 
                            <telerik:GridTemplateColumn HeaderText="[%Šablona č.2%]" UniqueName="col_sablona_2" SortExpression="Sablona2" DataField="Sablona2" DataType="System.String"  ReadOnly="true" >  
                                 <ItemTemplate>
                                     <span class="d_Sablona_2 sablspan"  id="d_Sablona_2" sablonakey='<%# Eval("SablonaKey2") %>' idpm='<%# Eval("Id") %>'><%# Eval("Sablona2") %>  </span>                                      
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn> 
                            <telerik:GridTemplateColumn HeaderText="[%Šablona č.3%]" UniqueName="col_sablona_3" SortExpression="Sablona3" DataField="Sablona3" DataType="System.String"  ReadOnly="true" >    
                                 <ItemTemplate>
                                     <span class="d_Sablona_3 sablspan"  id="d_Sablona_3" sablonakey='<%# Eval("SablonaKey3") %>' idpm='<%# Eval("Id") %>'><%# Eval("Sablona3") %></span>                                
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn> 
                            <telerik:GridTemplateColumn HeaderText="[%Šablona č.4%]" UniqueName="col_sablona_4" SortExpression="Sablona4" DataField="Sablona4" DataType="System.String"  ReadOnly="true" > 
                                 <ItemTemplate>
                                     <span class="d_Sablona_4 sablspan"  id="d_Sablona_4" sablonakey='<%# Eval("SablonaKey4") %>' idpm='<%# Eval("Id") %>'><%# Eval("Sablona4") %></span>                                    
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn> 
                            <telerik:GridTemplateColumn HeaderText="[%Šablona č.5%]" UniqueName="col_sablona_5" SortExpression="Sablona5" DataField="Sablona5" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_5 sablspan" id="d_Sablona_5" sablonakey='<%# Eval("SablonaKey5") %>' idpm='<%# Eval("Id") %>'><%# Eval("Sablona5") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>          
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.6%]" UniqueName="col_sablona_6" SortExpression="Sablona6" DataField="Sablona6" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_6 sablspan" id="d_Sablona_6" sablonakey='<%# Eval("SablonaKey6") %>' idpm='<%# Eval("Id") %>'><%# Eval("Sablona6") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.7%]" UniqueName="col_sablona_7" SortExpression="Sablona7" DataField="Sablona7" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_7 sablspan" id="d_Sablona_7" sablonakey='<%# Eval("SablonaKey7") %>' idpm='<%# Eval("Id") %>'><%# Eval("Sablona7") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.8%]" UniqueName="col_sablona_8" SortExpression="Sablona8" DataField="Sablona8" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_8 sablspan" id="d_Sablona_8" sablonakey='<%# Eval("SablonaKey8") %>' idpm='<%# Eval("Id") %>'><%# Eval("Sablona8") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.9%]" UniqueName="col_sablona_9" SortExpression="Sablona9" DataField="Sablona9" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_9 sablspan" id="d_Sablona_9" sablonakey='<%# Eval("SablonaKey9") %>' idpm='<%# Eval("Id") %>'><%# Eval("Sablona9") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.10%]" UniqueName="col_sablona_10" SortExpression="Sablona10" DataField="Sablona10" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_10 sablspan" id="d_Sablona_10" sablonakey='<%# Eval("SablonaKey10") %>' idpm='<%# Eval("Id") %>'><%# Eval("Sablona10") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.11%]" UniqueName="col_sablona_11" SortExpression="Sablona11" DataField="Sablona11" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_11 sablspan" id="d_Sablona_11" sablonakey='<%# Eval("SablonaKey11") %>' idpm='<%# Eval("Id") %>'><%# Eval("Sablona11") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.12%]" UniqueName="col_sablona_12" SortExpression="Sablona12" DataField="Sablona12" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_12 sablspan" id="d_Sablona_12" sablonakey='<%# Eval("SablonaKey12") %>' idpm='<%# Eval("Id") %>'><%# Eval("Sablona12") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       
                             <telerik:GridTemplateColumn HeaderText="[%Šablona č.13%]" UniqueName="col_sablona_13" SortExpression="Sablona13" DataField="Sablona13" DataType="System.String"  ReadOnly="true" >
                                <ItemTemplate>
                                     <span class="d_Sablona_13 sablspan" id="d_Sablona_13" sablonakey='<%# Eval("SablonaKey13") %>' idpm='<%# Eval("Id") %>'><%# Eval("Sablona13") %></span>                                     
                                 </ItemTemplate>
                            </telerik:GridTemplateColumn>       

                        </Columns>
                        <CommandItemTemplate>
                            <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server">
                                <ExportButton ID="ExportButton1" runat="server" ShowExportToExcelHtmlItem="false" ShowExportToExcelBIFFItem="true"/>
                                <PrimiPodrizeniButton ID="PrimiPodrizeniButton1" runat="server" Visible="false">
                                </PrimiPodrizeniButton>
                                <BezMESButton ID="BezMESButton1" runat="server" Visible="false">
                                </BezMESButton>
                            </kspwc:GridCommandItemControl>
                        </CommandItemTemplate>
                    <PagerStyle Mode="NextPrevAndNumeric"  PageSizes="{10, 20, 50, 100}" />
                    </MasterTableView>         
                </kspwc:TRadGrid>

    <telerik:RadWindowManager runat="server" ID="rw_manager" >
        <Windows>       
     <telerik:RadWindow style="z-index:1001 !important;overflow:hidden !important;" runat="server" ID="RW_sablony" Title="Výběr šablon" AutoSizeBehaviors="Height" AutoSize="true" Width="330" 
         Behaviors="Move" KeepInScreenBounds="True" Modal="True" VisibleStatusbar="False" OnClientBeforeShow="OnClientBeforeShow"  >
        <ContentTemplate>
            <div style="width:300px !important; overflow:hidden;">
                <div id="div_nadpis" class="nadpis1" style="margin-top:10px">
                   
                </div>
                <kspwc:TRadGrid CaptionVisible="false" ID="TRadGrid_sablony" runat="server" ShowGroupPanel="False" AllowPaging="false" EnableViewState="false" 
                                        AllowSorting="false" AutoGenerateColumns="false"  ShowFooter="false" MasterTableView-AllowPaging="false"  PageSize="20">                    
                                    <MasterTableView ClientDataKeyNames="SablonaKey" Caption="" CommandItemDisplay="None" Width="280"  CommandItemSettings-ShowRefreshButton="false" CommandItemSettings-ShowAddNewRecordButton="false" ShowGroupFooter="false" ShowHeader="False" AllowFilteringByColumn="false">                  
                                        <Columns>   
                                            <telerik:GridTemplateColumn HeaderStyle-Width="20" ItemStyle-Width="20" UniqueName="col_checkbox">
                                                <ItemTemplate>                                             
                                                    <asp:CheckBox runat="server" ID="check_box"  />
                                                </ItemTemplate>
                                            </telerik:GridTemplateColumn>
                                            <telerik:GridBoundColumn DataType="System.String" DataField="SablonaNazev">   
                                                <ItemStyle Wrap="false" Width="260" />
                                            </telerik:GridBoundColumn>                                                                
                                        </Columns>                                       
                                    </MasterTableView>                 
                                    <ClientSettings >
                                        <ClientEvents OnCommand="function(){}" />                                                   
                                    </ClientSettings>
                    </kspwc:TRadGrid> 
                    <div  style="width:100% !important; height:30px; margin-top:35px; text-align:right;">
                        <span class="comm" >
                            <telerik:RadButton runat="server" ID="cb_zrusit" Text="[%Zrušit%]" AutoPostBack="false" CssClass="k-button" OnClientClicked="cb_zrusit_OnClientClicked"></telerik:RadButton>
                        </span>
                        <span class="comm" >
                            <telerik:RadButton runat="server" ID="cb_ok" Text="[%Uložit%]" Primary="true" CssClass="k-button k-primary" AutoPostBack="false" OnClientClicked="cb_ok_OnClientClicked" ></telerik:RadButton>
                        </span>
                    </div>
            </div>
        </ContentTemplate>
    </telerik:RadWindow>

     <telerik:RadWindow style="z-index:1001 !important;overflow:hidden !important;" runat="server" ID="rw_polozky" Title="Nastavení položek" AutoSizeBehaviors="Default" MinWidth="900" MinHeight="500" AutoSize="true" DestroyOnClose="true"  
         Behaviors="Close,Maximize,Minimize,Resize,Move" KeepInScreenBounds="True" Modal="True" VisibleStatusbar="False" OnClientBeforeShow="rw_polozky_OnClientBeforeShow" OnClientShow="rw_polozky_OnClientShow" OnClientResizeEnd="rw_polozky_OnClientResizeEnd"  >
        <ContentTemplate>
            <div style="width:100%; height:100%;" id="div_grid_polozky">
                <div id="div_nadpis_polozky" class="nadpis1" style="margin-top:10px">                   
                </div>
                <kspwc:TRadGrid CaptionVisible="false" ID="grid_detail" runat="server" ShowGroupPanel="False" AllowPaging="false" EnableViewState="false" OnInit="grid_detail_Init"
                                        AllowSorting="false" AutoGenerateColumns="false" ShowHeader="true"  ShowFooter="false" AllowMultiRowEdit="false"  Height="100%"  >                    
                                    <MasterTableView EditMode="PopUp"  CommandItemDisplay="None"  CommandItemSettings-ShowRefreshButton="false" CommandItemSettings-ShowAddNewRecordButton="false"
                                        ShowGroupFooter="false"  AllowFilteringByColumn="false" AllowAutomaticUpdates="false" ClientDataKeyNames="Polozka"   >                                                 
                                        <Columns>                                             
                                            <telerik:GridRowIndicatorColumn Visible="false"></telerik:GridRowIndicatorColumn>
                                            <telerik:GridClientSelectColumn Display="false" ></telerik:GridClientSelectColumn>
                                            <telerik:GridBoundColumn DataType="System.String" DataField="Polozka" ReadOnly="true" HeaderText="Id položky" UniqueName="col_Polozka">   
                                                <ItemStyle  Width="140"/>
                                                <HeaderStyle Width="140" />
                                            </telerik:GridBoundColumn>   
                                            <telerik:GridBoundColumn DataType="System.String" DataField="PopisekDefault" ReadOnly="true" HeaderText="Popisek systémový" UniqueName="col_PopisekSystemovy">  
                                                   <ItemStyle  Width="140"/>
                                                <HeaderStyle Width="140" />
                                            </telerik:GridBoundColumn>   
                                                
                                            <telerik:GridBoundColumn  DataField="PopisekApp"  HeaderText="Popisek uživatelský" UniqueName="col_PopisekUzivatelsky" DataType="System.String">   
                                                   <ItemStyle  Width="140"/>
                                                <HeaderStyle Width="140" />
                                            </telerik:GridBoundColumn>         
                                            
                                             <telerik:GridBoundColumn  DataField="Popisek"  HeaderText="Popisek" UniqueName="col_Popisek" DataType="System.String">   
                                                   <ItemStyle  Width="140"/>
                                                <HeaderStyle Width="140" />
                                            </telerik:GridBoundColumn>          
                                            
                                           <telerik:GridCheckBoxColumn DataType="System.Boolean" DataField="Editovatelnost" HeaderText="Edit" UniqueName="col_Editace" > 
                                               <ItemStyle  Width="50"/>
                                                <HeaderStyle Width="50" />
                                            </telerik:GridCheckBoxColumn>   
                                             <telerik:GridCheckBoxColumn DataType="System.Boolean" DataField="Visible" HeaderText="Zobrazení" UniqueName="col_Zobraz" > 
                                                 <ItemStyle  Width="50"/>
                                                <HeaderStyle Width="50" />
                                            </telerik:GridCheckBoxColumn>   

                                            <telerik:GridBoundColumn DataType="System.Int32" DataField="WidthDefault" ReadOnly="true" HeaderText="Šířka systémová" UniqueName="col_SirkaSystemova"> 
                                                <ItemStyle  Width="50" HorizontalAlign="Right"/>
                                                <HeaderStyle Width="50" />
                                            </telerik:GridBoundColumn>   
                                            <telerik:GridNumericColumn DataField="WidthApp" HeaderText="Šířka uživatelská" UniqueName="col_SirkaApp">
                                                 <ItemStyle  Width="50" HorizontalAlign="Right"/>
                                                <HeaderStyle Width="50" />
                                            </telerik:GridNumericColumn>      
                                            <telerik:GridCheckBoxColumn DataField="Zapocet1" HeaderText="Zápočet garance" UniqueName="col_Zapocet1">
                                                 <ItemStyle  Width="50" HorizontalAlign="Right"/>
                                                <HeaderStyle Width="50" />
                                            </telerik:GridCheckBoxColumn>       
                                        </Columns>                                       
                                    </MasterTableView>                 
                                    <ClientSettings AllowKeyboardNavigation="true" Selecting-AllowRowSelect="true">                                      
                                        <%-- OnCommand="function(){}"--%>
                                        <%--<ClientEvents OnDataBinding="function(){}" /> --%>
                                       <%-- <DataBinding Location="../../PrivateWebServices/AutoCompleteService.asmx" SelectMethod="GetPolozkySablony" />--%>
                                      
                                        <ClientEvents OnRowDblClick="dblRowClick" OnDataBound="grid_detail_OnDataBound" />
                                         <Scrolling AllowScroll="True" UseStaticHeaders="true" />
                                    </ClientSettings>
                    </kspwc:TRadGrid> 
                   <%-- <div  style="width:100% !important; height:30px; margin-top:35px; text-align:right;">
                        <span class="comm" >                         
                            <button class="k-button k-form-clear" id="rb_zavrit">[%Zavřít%]</button>
                        </span>                      
                   </div>--%>
            </div>
        </ContentTemplate>
    </telerik:RadWindow>
           <%--  MinHeight="600"--%>
    <telerik:RadWindow style="z-index:1002 !important;overflow:hidden !important;" VisibleStatusbar="false" runat="server" ID="rw_edit" Title="Nastavení položky" MinWidth="600" MinHeight="400" AutoSizeBehaviors="Default"  AutoSize="true" DestroyOnClose="true" 
         Behaviors="Close,Move"
         OnClientBeforeShow="rw_edit_OnClientBeforeShow" OnClientClose="rw_edit_OnClientClose" OnClientBeforeClose ="rw_edit_OnClientBeforeClose" >
        <ContentTemplate>

           <div id="editaceform"></div>

        </ContentTemplate>
    </telerik:RadWindow>
             </Windows>
    </telerik:RadWindowManager>

</asp:Content>
