﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="PravaRole.aspx.cs" Inherits="KSPortal.Obecne.PravaRole" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <asp:ObjectDataSource ID="ODS_Role" runat="server" 
        OldValuesParameterFormatString="original_{0}" SelectMethod="GetAllRoles" 
        TypeName="KSProgram.Prava.PravaAkce" DeleteMethod="DeleteRole" 
        InsertMethod="CreateRole" UpdateMethod="UpdateRole">
        <DeleteParameters>
            <asp:Parameter Name="roleName" Type="String" />
        </DeleteParameters>
        <InsertParameters>
            <asp:Parameter Name="roleName" Type="String" />
            <asp:Parameter Name="zastup" Type="Boolean" />
        </InsertParameters>
        <UpdateParameters>
            <asp:Parameter Name="original_roleName" Type="String" />
            <asp:Parameter Name="roleName" Type="String" />
            <asp:Parameter Name="zastup" Type="Boolean" />
        </UpdateParameters>
    </asp:ObjectDataSource>
    <kspwc:TRadGrid ID="RadGridRole" runat="server" AllowAutomaticInserts="True" 
        AutoGenerateColumns="False"  AllowAutomaticDeletes="True"
        AllowAutomaticUpdates="True" DataSourceID="ODS_Role" AllowFilteringByColumn="true" AllowSorting="true"
        onprerender="RadGridRole_PreRender" >
        <MasterTableView EnableHeaderContextFilterMenu="false" EnableHeaderContextMenu="false"
            CommandItemDisplay="Top" DataSourceID="ODS_Role" DataKeyNames="roleName" Caption="[%Role%]" >
            <CommandItemSettings AddNewRecordText="[%Vložit nový%]" />
            <Columns>
                <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn">
                </telerik:GridEditCommandColumn>
                <telerik:GridNumericColumn DataField="roleId" FilterControlAltText="Filter roleId column"
                    UniqueName="roleId" HeaderText="[%ID%]" ReadOnly="True">
                </telerik:GridNumericColumn>
               <%-- <telerik:GridBoundColumn DataField="roleName" FilterControlAltText="Filter roleName column"
                     MaxLength="50">
                    <ColumnValidationSettings EnableRequiredFieldValidation="true"  >
                    <RequiredFieldValidator ForeColor="Red" Text="[%Povinná položka%]"></RequiredFieldValidator>
                    </ColumnValidationSettings>
                </telerik:GridBoundColumn>--%>
                <telerik:GridTemplateColumn DataField="roleName" HeaderText="[%Název%]" UniqueName="roleName"  FilterControlAltText="Filter roleName column" >
                    <ItemTemplate>
                        <asp:Label runat="server" id="lab_nazev"  Text='<%# Bind("roleName") %>'></asp:Label>
                    </ItemTemplate>
                    <InsertItemTemplate>
                        <telerik:RadTextBox runat="server" id="txt_nazev_i"  MaxLength="50" Text='<%# Bind("roleName") %>'> </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="validace" ControlToValidate="txt_nazev_i" Display="Dynamic" ></kspwc:TextValidator>
                        <asp:CustomValidator runat="server" ID="TextValidator1" ControlToValidate="txt_nazev_i"  Display="Dynamic" OnServerValidate="TextValidator1_ServerValidate" ErrorMessage="[%Použity neplatné znaky%]"></asp:CustomValidator>
                        <kspwc:TRequiredValidator runat="server" ID="val_required" ControlToValidate="txt_nazev_i" Display="Dynamic" ></kspwc:TRequiredValidator>
                    </InsertItemTemplate>
                    <EditItemTemplate>
                        <telerik:RadTextBox runat="server" id="txt_nazev"  MaxLength="50" Text='<%# Bind("roleName") %>'> </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="validace" ControlToValidate="txt_nazev" Display="Dynamic" ></kspwc:TextValidator>
                        <kspwc:TRequiredValidator runat="server" ID="val_required" ControlToValidate="txt_nazev" Display="Dynamic" ></kspwc:TRequiredValidator>
                        <asp:CustomValidator runat="server" ID="TextValidator1" ControlToValidate="txt_nazev" Display="Dynamic"  OnServerValidate="TextValidator1_ServerValidate" ErrorMessage="[%Použity neplatné znaky%]"></asp:CustomValidator>
                    </EditItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridCheckBoxColumn HeaderText="[%Zástup%]" DataField="zastup" UniqueName="uniq_zastup" ></telerik:GridCheckBoxColumn>
                <telerik:GridButtonColumn Text="Delete" CommandName="Delete" ButtonType="ImageButton" />
            </Columns>
            <EditFormSettings>
                <EditColumn FilterControlAltText="Filter EditCommandColumn1 column" UniqueName="EditCommandColumn1" ButtonType="ImageButton">
                </EditColumn>
            </EditFormSettings>
        </MasterTableView>
    </kspwc:TRadGrid>
</asp:Content>
