﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Obecne_Parametry"
    CodeBehind="Parametry.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="cc1" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content2" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        .ksBrakeWord {
            word-break: break-word;
        }

        .hodnotaWidth {
            min-width: 200px;
            width: 300px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="RadGridParametry">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadGridParametry"
                        UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RCB_Podniky">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadGridParametry"
                        UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <div id="Div_Podniky" runat="server" class="ksprvek" style="padding: 20px;" visible="false">
        <label>[%Výběr podniku%]:</label>
        <kspwc:TRadComboBox runat="server" ID="RCB_Podniky" AutoPostBack="true" Width="500px" OnSelectedIndexChanged="RCB_Podniky_SelectedIndexChanged"></kspwc:TRadComboBox>
    </div>
    <kspwc:TRadGrid ID="RadGridParametry" runat="server" AllowAutomaticUpdates="True" OnUpdateCommand="RadGridParametry_EditCommand" OnItemCreated="RadGridParametry_ItemCreated" OnItemDataBound="RadGridParametry_ItemDataBound"
        AllowSorting="True" AutoGenerateColumns="False" OnNeedDataSource="RadGridParametry_NeedDataSource" CssClass="rgMultiHeader ksprvek"
        GroupPanelPosition="Top"
        ShowGroupPanel="True">
        <GroupingSettings ShowUnGroupButton="True" />
        <ExportSettings>
            <Pdf PageWidth="">
            </Pdf>
        </ExportSettings>
        <ClientSettings AllowDragToGroup="True">
        </ClientSettings>
        <MasterTableView DataKeyNames="nazev,hodnota,type,definice" EditMode="InPlace"
            GroupLoadMode="Client" Caption="[%Parametry%]">
            <Columns>
                <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn">
                </telerik:GridEditCommandColumn>
                <telerik:GridBoundColumn DataField="skupina" FilterControlAltText="Filter skupina column"
                    HeaderText="[%Skupina%]" ReadOnly="True" UniqueName="skupina">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="separovatelny" HeaderText="[%Více IČ%]" ReadOnly="True" UniqueName="separovatelny" Visible="false" ItemStyle-HorizontalAlign="Center" HeaderStyle-Width="65">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="nazev" FilterControlAltText="Filter nazev column"
                    HeaderText="[%Název%]" ReadOnly="True" UniqueName="nazev"
                    Groupable="False">
                </telerik:GridBoundColumn>
                <telerik:GridTemplateColumn DataField="hodnota" HeaderStyle-CssClass="hodnotaWidth" FilterControlAltText="Filter hodnota column"
                    HeaderText="[%Hodnota%]" UniqueName="hodnota" Groupable="False">
                    <ItemTemplate>
                        <asp:Label ID="L_hodnota" runat="server" CssClass="ksBrakeWord" Text='<%# Eval("hodnota") %>'></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                    </EditItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridBoundColumn DataField="popis" FilterControlAltText="Filter popis column"
                    HeaderText="[%Popis%]" ReadOnly="True" UniqueName="popis"
                    Groupable="False">
                </telerik:GridBoundColumn>
            </Columns>
            <GroupByExpressions>
                <telerik:GridGroupByExpression>
                    <SelectFields>
                        <telerik:GridGroupByField FieldAlias="skupina" FieldName="skupina"
                            HeaderText="[%Skupina%]" />
                    </SelectFields>
                    <GroupByFields>
                        <telerik:GridGroupByField FieldAlias="skupina" FieldName="skupina"
                            FormatString="" HeaderText="[%Skupina%]" />
                    </GroupByFields>
                </telerik:GridGroupByExpression>
            </GroupByExpressions>
            <EditFormSettings>
                <EditColumn ButtonType="ImageButton" />
            </EditFormSettings>
        </MasterTableView>
    </kspwc:TRadGrid>
</asp:Content>
