﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="HodnoceniStav.aspx.cs" Inherits="KSPortal.Sestavy.HodnoceniStav" %>
<%@ Register assembly="Telerik.Web.UI" namespace="Telerik.Web.UI" tagprefix="telerik" %>
<%@ Register assembly="WebControls" namespace="KSProgram.WebControls.SimpleDataSource" tagprefix="cc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        .RadGrid .rgMasterTable td.rgFilterClass {
            background-color: #eee;
            border-bottom-color: #eee;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRadGrid1">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid1" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <telerik:RadPersistenceManagerProxy ID="RadPersistenceManagerProxy1" runat="server">
        <PersistenceSettings>
            <telerik:PersistenceSetting ControlID="TRadGrid1" />
        </PersistenceSettings>
    </telerik:RadPersistenceManagerProxy>
    <%--<span class="nadpis1">[%Přehled hodnocení%]</span>--%>
    <asp:ObjectDataSource ID="ODS_stavy" runat="server" OldValuesParameterFormatString="original_{0}" SelectMethod="Cislenik_Stavu" TypeName="KSProgram.Hodnoceni.Hodnoceni"></asp:ObjectDataSource>

    <cc1:SimpleDataSource ID="SDS_cisla" runat="server" SelectCommand="SELECT cislo, nazev, obdobi_od FROM hz_akce_plan ORDER BY obdobi_od DESC">
    </cc1:SimpleDataSource>

    <kspwc:TRadGrid ID="TRadGrid1" runat="server" AllowPaging="True" AllowSorting="True" OnNeedDataSource="TRadGrid1_NeedDataSource" ShowGroupPanel="True" AutoGenerateColumns="False"
        AutoFilterWidth="false" AutoFilterControlWidth="false" EnableHeaderContextMenu="true" FilterType="Classic" EnableLinqExpressions="false" OnCustomAggregate="TRadGrid1_CustomAggregate"
        EnableHeaderContextFilterMenu="true" EnableHeaderContextAggregatesMenu="False" OnItemDataBound="TRadGrid1_ItemDataBound" MasterTableView-Caption="[%Přehled hodnocení%]" >
        <GroupingSettings CaseSensitive="False" CollapseAllTooltip="Collapse all groups" ShowUnGroupButton="True"></GroupingSettings>
        <ClientSettings AllowDragToGroup="True">
        </ClientSettings>
        <MasterTableView CommandItemDisplay="Top" EnableGroupsExpandAll="True" EnableHeaderContextAggregatesMenu="true" ShowFooter="true">
            <PagerStyle PageSizes="5,10,30,50,100,300,500" />
            <GroupByExpressions>
                <telerik:GridGroupByExpression>
                    <SelectFields>
                        <telerik:GridGroupByField FieldName="cislo" HeaderText="[%Číslo akce%]" />
                        <telerik:GridGroupByField FieldName="nazev" HeaderText="[%Název%]"/>
                    </SelectFields>
                    <GroupByFields>
                        <telerik:GridGroupByField FieldName="obdobi_od" SortOrder="Descending" HeaderText="[%Období od%]" />
                        <telerik:GridGroupByField FieldName="cislo" HeaderText="[%Hodnotící akce%]" />
                    </GroupByFields>
                </telerik:GridGroupByExpression>
            </GroupByExpressions>
            <Columns>
                <telerik:GridNumericColumn DataField="os_cislo" DataType="System.Decimal" DecimalDigits="0" FilterControlAltText="Filter os_cislo column" HeaderText="[%Os. číslo%]" UniqueName="os_cislo" ColumnGroupName="hodn" FilterControlWidth="60">
                </telerik:GridNumericColumn>     
                <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo" ColumnGroupName="hodn"></kspwc:GridFotoZamColumn>
                <telerik:GridBoundColumn DataField="jmeno" FilterControlAltText="Filter jmeno column" HeaderText="[%Jméno%]" UniqueName="jmeno" ColumnGroupName="hodn">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="stav" FilterControlAltText="Filter stav column" HeaderText="[%Stav%]" UniqueName="stav" ColumnGroupName="hodn" FooterAggregateFormatString="{0}" Aggregate="Custom">
                    <FilterTemplate>
                        <kspwc:TRadComboBox ID="TRCB_stav" runat="server" DropDownAutoWidth="Enabled"
                            Width="100" DataSourceID="ODS_stavy" DataTextField="Value" DataValueField="Key" OnDataBound="TRCB_stav_DataBound" OnItemDataBound="TRCB_stav_ItemDataBound"
                            CheckBoxes="True" EnableCheckAllItemsCheckBox="True" OnClientDropDownClosing="TRCB_stav_DropDownClosing" OnClientItemChecked="TRCB_stav_ClientItemChecked"
                            OnClientKeyPressing="TRCB_stav_ClientKeyPressing" OnClientCheckAllChecked="TRCB_stav_ClientItemChecked">
                        </kspwc:TRadComboBox>
                        <telerik:RadScriptBlock ID="RadScriptBlock66" runat="server">
                            <script type="text/javascript" id="telerikClientEvents3">
                                function TRCB_stav_DropDownClosing(sender, args) {
                                    var tableView = $find("<%# ((GridItem)Container).OwnerTableView.ClientID %>");
                                    var valuech = "";
                                    var itemsch = sender.get_checkedItems();
                                    if (itemsch.length == 0) {
                                        valuech = "";
                                    }
                                    else {
                                        for (var i in itemsch) {
                                            valuech += itemsch[i].get_value() + ",";
                                        }
                                    }
                                    valuech = valuech.length > 0 ? valuech.substring(0, valuech.length - 1) : valuech;
                                    tableView.filter("stav", valuech, "EqualTo");
                                }
                                function TRCB_stav_ClientItemChecked(sender, args) {
                                    var input = sender.get_inputDomElement();
                                    input.focus();
                                }
                                function TRCB_stav_ClientKeyPressing(sender, args) {
                                    if (args.get_domEvent().keyCode == 13) {
                                        var TRCB_stav = $find('<%# ((GridItem)Container).FindControl("TRCB_stav").ClientID %>');
                                        TRCB_stav.hideDropDown();
                                    }
                                }
                            </script>
                            </telerik:RadScriptBlock>
                        </FilterTemplate>
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="stredisko" FilterControlAltText="Filter stredisko column" HeaderText="[%Kmen. stř.%]" UniqueName="stredisko" ColumnGroupName="hodn" FilterControlWidth="60" Display="false">
                </telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="cislo_pom" DataType="System.Int16" DecimalDigits="0" FilterControlAltText="Filter cislo_pom column" HeaderText="[%Číslo pom.%]" UniqueName="cislo_pom" ColumnGroupName="hodn" FilterControlWidth="30">
                </telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="prac_str" FilterControlAltText="Filter prac_str column" HeaderText="[%Prac. stř.%]" UniqueName="prac_str" ColumnGroupName="hodn" FilterControlWidth="60">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="jmeno_hodn" FilterControlAltText="Filter jmeno_hodn column" HeaderText="[%Jméno%]" UniqueName="jmeno_hodn" ColumnGroupName="titel">
                </telerik:GridBoundColumn>
                <telerik:GridDateTimeColumn DataField="datum" DataType="System.DateTime" FilterControlAltText="Filter datum column" HeaderText="[%Datum hodnocení%]" UniqueName="datum" DataFormatString="{0:d}" ColumnGroupName="titel" FilterControlWidth="90">
                </telerik:GridDateTimeColumn>
                <telerik:GridBoundColumn FilterCheckListEnableLoadOnDemand="false" DataField="cislo" FilterControlAltText="Filter cislo column" HeaderText="[%Číslo%]" UniqueName="cislo" ColumnGroupName="akce">
                    <FilterTemplate>
                        <kspwc:TRadComboBox ID="TRCB_cislo" runat="server" DropDownAutoWidth="Enabled" OnItemDataBound="TRCB_cislo_ItemDataBound"
                            Width="100" DataSourceID="SDS_cisla" DataValueField="cislo" OnDataBound="TRCB_cislo_DataBound"
                            CheckBoxes="True" EnableCheckAllItemsCheckBox="True" OnClientDropDownClosing="TRCB_cislo_DropDownClosing" OnClientItemChecked="TRCB_cislo_ClientItemChecked"
                            OnClientKeyPressing="TRCB_cislo_ClientKeyPressing" OnClientCheckAllChecked="TRCB_cislo_ClientItemChecked">
                        </kspwc:TRadComboBox>
                        <telerik:RadScriptBlock ID="RadScriptBlock67" runat="server">
                            <script type="text/javascript" id="telerikClientEvents3">
                                function TRCB_cislo_DropDownClosing(sender, args) {
                                    var tableView = $find("<%# ((GridItem)Container).OwnerTableView.ClientID %>");
                                    var valuech = "";
                                    var itemsch = sender.get_checkedItems();
                                    if (itemsch.length == 0) {
                                        valuech = "";
                                    }
                                    else {
                                        for (var i in itemsch) {
                                            valuech += itemsch[i].get_value() + ",";
                                        }
                                    }
                                    valuech = valuech.length > 0 ? valuech.substring(0, valuech.length - 1) : valuech;
                                    tableView.filter("cislo", valuech, "EqualTo");
                                }
                                function TRCB_cislo_ClientItemChecked(sender, args) {
                                    var input = sender.get_inputDomElement();
                                    input.focus();
                                }
                                function TRCB_cislo_ClientKeyPressing(sender, args) {
                                    if (args.get_domEvent().keyCode == 13) {
                                        var TRCB_cislo = $find('<%# ((GridItem)Container).FindControl("TRCB_cislo").ClientID %>');
                                        TRCB_cislo.hideDropDown();
                                    }
                                }
                                </script>
                            </telerik:RadScriptBlock>
                        </FilterTemplate>
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="nazev" FilterControlAltText="Filter nazev column" HeaderText="[%Název%]" UniqueName="nazev" ColumnGroupName="akce" Display="false">
                </telerik:GridBoundColumn>
                <telerik:GridDateTimeColumn DataField="obdobi_od" DataType="System.DateTime" FilterControlAltText="Filter obdobi_od column" HeaderText="[%Období od%]" UniqueName="obdobi_od" DataFormatString="{0:d}" ColumnGroupName="akce" FilterControlWidth="90">
                </telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn DataField="obdobi_do" DataType="System.DateTime" FilterControlAltText="Filter obdobi_od column" HeaderText="[%Období do%]" UniqueName="obdobi_do" DataFormatString="{0:d}" ColumnGroupName="akce" FilterControlWidth="90" Display="false">
                </telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn DataField="termin_od" DataType="System.DateTime" FilterControlAltText="Filter termin_od column" HeaderText="[%Termín od%]" UniqueName="termin_od" DataFormatString="{0:d}" ColumnGroupName="akce" FilterControlWidth="90" Display="false">
                </telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn DataField="termin_do" DataType="System.DateTime" FilterControlAltText="Filter termin_do column" HeaderText="[%Termín do%]" UniqueName="termin_do" DataFormatString="{0:d}" ColumnGroupName="akce" FilterControlWidth="90">
                </telerik:GridDateTimeColumn>
            </Columns>
            <ColumnGroups>
                <telerik:GridColumnGroup HeaderText="[%Hodnotící akce%]" Name="akce"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup HeaderText="[%Hodnocení%]" Name="hodn"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup HeaderText="[%Hodnotitel%]" Name="titel"></telerik:GridColumnGroup>
            </ColumnGroups>
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl runat="server" ID="GCIC">
                    <ClearFiltrButton runat="server" ID="GCIC_ClearFilter" OnClick="GCIC_ClearFilter_Click"></ClearFiltrButton>
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
        </MasterTableView>
    </kspwc:TRadGrid>
</asp:Content>
