﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="d4.aspx.cs" Inherits="KSPortal.Dochazka.d4" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="kswc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

 
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server" class="master-table-td">
     <script src= "../kendo/js/kendo.all.min.js" type="text/javascript"></script>
    <script src="../kendo/js/cultures/kendo.culture.cs-CZ.min.js" type="text/javascript" ></script>
    <link rel="stylesheet" href="../kendo/styles/kendo.common.min.css" />
    <link rel="stylesheet" href="../kendo/styles/kendo.default-main.css" />   

    <script type="text/javascript">  
        kendo.culture('<%= System.Globalization.CultureInfo.CurrentUICulture.Name %>');

        const pars = new Object();
        pars.rok = 0;
        pars.mes = 0;
        pars.cis_dne = -1;
        pars.fedit = false;       

        var d4_mesData = {};
        var d4_sumy = {};       
        var d4_pruchody = [];
        var d4_kody = [];       
        var d4_window_edit = {};
        var d4_window_NPedit = {};
        var d4_window_Rizikoedit = {};
        var d4_editModel = {};
        var d4_editModelNP = {};
        var d4_editModelRiziko = {};
        var d4_rekapitulace = [];
        var d4_pp = {};
        var d4_index = -1;
        var d4_poslDenPM = false;
        var d4_vlozeni_data = {};

        var d4_wnd_zu = {};
        var d4_wnd_zu_nahled = {};
        
        var d4_pan_zmena_stavu = false;
        var d4_window_pr = {};
        var d4_rozdel_prescasy = [];
        var d4_pr_sumy = {};
        var d4_rozdel_svatek = [];
        var d4_sv_sumy = {};
        var selectedPruchod = {};
        var d4_error = {};
        var d4_UI = {};
        var d4_chyby = [];
        var d4_ta_pozn = {};
        var d4_tooltip = {};
        var d4_uzavreneObdobi = false;
        var d4_pdabs = false;
        var d4_zkrac_uvazek = false;
        var d4_narizeny_prescas = true;  
        var d4_RizikoPorizovani_Visible = false;
        var d4_RizikoPorizovani_Editable = false;

        function NabidkaObdobi_OnDateSelected(sender, args) {
            
            var selectedDate = sender.get_selectedDate();
            pars.rok = (selectedDate.getFullYear());
            pars.mes = (selectedDate.getMonth() + 1);           
            getGridData();
        }

        function getGridData() {           
            var os_cislo = KSMaster.HF_sel_os_cislo.value;            
            var cislo_pom = KSMaster.HF_sel_cislo_pom.value;
            //loadPan(true);
            PageMethods.GetData(os_cislo, cislo_pom, pars.rok, pars.mes, false, updateGrid, onPageMethodError);            
        }

        function getDataVolen() {           
            var os_cislo = KSMaster.HF_sel_os_cislo.value;
            var cislo_pom = KSMaster.HF_sel_cislo_pom.value;           
            PageMethods.GetDataVolen(os_cislo, cislo_pom, pars.rok, pars.mes, createVolna, onPageMethodError);
        }      

        function updateGrid(data) {          
            d4_mesData = data.Data;
            d4_sumy = data.Sumy;
            d4_kody = data.Kody;
            d4_zkrac_uvazek = data.ZkracenyUvazek;
            d4_narizeny_prescas = data.UI.NarizenyPrescasVisible;          
            d4_UI = data.UI;                // PMEJ 22.09.2025 - přesunuto sem, aby bylo nastavení UI dostupné pro další funkce
            createGrid();            
            d4_rekapitulace = data.Rekapitulace;
            d4_chyby = data.Chyby;
            d4_poslDenPM = data.PoslDenPredchMes;
            d4_vlozeni_data = data.NabidkaVlozeniPoslOdchodu;
            createRekap();
            createChyby();            
            createStyles();
            var rows = $(".k-grid-content").find('tr');
            for (var i = 0; i < d4_mesData.length; i++) {                           
                if (d4_mesData[i].Oznaceno == false) {
                    addButton(rows[i], !d4_mesData[i].Oznaceno);
                }
            }

            d4_rozdel_prescasy = data.PrescasyNabidkaKProplaceni;
            d4_rozdel_prescasy_narizeny = data.NarizenyNabidkaKProplaceni;
            d4_pr_sumy = data.PrescasySumy;
           
            d4_pr_priplatky = data.RekapitulacePriplatku;
            d4_rozdel_svatek = data.SvatkyNabidkaKProplaceni;            
            d4_sv_sumy = data.SvatkySumy;          
            //d4_UI = data.UI;              // PMEJ 22.09.2025 - Přesunuto výše
            d4_uzavreneObdobi = data.UzavreneObdobi;            

            prescasyRekap();
            svatkyRekap();
            priplatkyRekap(data.SlouceniVikendovychPriplatku);

            var os_cislo = KSMaster.HF_sel_os_cislo.value;
            var cislo_pom = KSMaster.HF_sel_cislo_pom.value;

            PageMethods.GetPozadavekDochazka(os_cislo, cislo_pom, pars.rok, pars.mes, schvalovaniNastav, onPageMethodError);

            getDataVolen();
            preparePoznEl();
            //_createBarevne();
            //loadPan(false);
        }

        function loadPoznamku(rok, mes, cd) {
            var d = [];
            var item = { "os_cislo": KSMaster.HF_sel_os_cislo.value }; d.push(item);
            item = { "cislo_pom": KSMaster.HF_sel_cislo_pom.value }; d.push(item);
            item = { "rok": rok }; d.push(item);
            item = { "mes": mes }; d.push(item);
            item = { "cis_dne": cd }; d.push(item);
            var data_send = JSON.stringify(d);
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/Dochazka/d4.aspx/GetPozn",
                data: "{data:'" + data_send + "'}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(xhr.status);
                    alert(xhr.responseText);
                    alert(thrownError);
                },
                success: function (msg) {
                    pozn = msg.d;
                }
            });
            return pozn;
        }

        function vytvorWndPozn() {            
            var wnd = $("#wnd_poznamka").kendoWindow({
                height: 300,
                width: 500,
                visible: false,
                appendTo: "#div_pozn",
                open: function (e) {
                    this.center();
                    setTimeout(() => {
                        $("#txt_poznamka").focus();
                    }, 300);
                },
                close: function (e) {
                    $("#txt_poznamka").val("");                    
                }
            }).data("kendoWindow");

            return wnd;
        }

        function preparePoznEl()
        {
            $('.pozn-ikona, .pozn-ikona-empty').unbind("click");
            $('.pozn-ikona, .pozn-ikona-empty').bind("click", function (e) {
                
                var id = $(e.currentTarget).parent().attr("id");
                pars.cis_dne = id.substring(5);
                //var wnd = vytvorWndPozn();               
                var wnd = $("#wnd_poznamka").data("kendoWindow");
                wnd.open();
                wnd.title(cPr("Poznámka") + ": " + d4_mesData[pars.cis_dne - 1].NDne);

                var pozn = "";               
                pozn = loadPoznamku(pars.rok, pars.mes, pars.cis_dne);              
                d4_ta_pozn.value(pozn);
                $("#btnUlozitPozn").unbind("click");
                $("#btnZrusitPozn").unbind("click");
                $("#btnUlozitPozn").kendoButton({
                    click: onUlozitPozn
                });

                $("#btnZrusitPozn").kendoButton({
                    click: onZrusitPozn
                });
            });
        }

        function priplatkyRekap(svp) {          
            PriplHodnota("pr_nocni", 1);
            PriplHodnota("pr_odpoledni", 2);
            PriplHodnota("pr_svatek", 3);           
            if (svp) {
                PriplHodnota("pr_vikendy", 6);
                $(".ks-vikend-jednotlivy").html("");
            }
            else {
                PriplHodnota("pr_sobota", 4);
                PriplHodnota("pr_nedele", 5);
                $(".ks-vikend-suma").html("");
            }
        }
        function PriplHodnota(elId, typ) {
            var cas = "00:00";
            var it = d4_pr_priplatky.find(aa => aa.Typ == typ);
            if (it != undefined)
                cas = it.DobaFormat;
            $("#" + elId).text(cas);
        }

        function prescasyRekap() {                           
            $("#pr_presuvazek").text(d4_pr_sumy.CasPresUvazek);
            $("#lab_saldo_k_datu").text(d4_pr_sumy.SaldoKDatu.CisloDne + ".");
            $("#pr_saldo_k_datu").text(d4_pr_sumy.SaldoKDatu.CasSaldo);
            $("#pr_saldo_k_datu_info").empty();
            $('.ks-saldo-ke-dni').show();
            if (d4_pr_sumy.SaldoKDatu.PrevodDostupny == 2) {               
                $('#pr_saldo_k_datu_info').prepend('<span class="ks-pr-info1" title="' + cPr("Převod z min. měsíce dočasně nedostupný") + '" ><i class="fi fi-exclamation" style="font-size: 15px;" ></i ></span>');
            }
            else if (d4_pr_sumy.SaldoKDatu.PrevodDostupny == 1) {
                $('.ks-saldo-ke-dni').hide();
            }

            $("#tr_prescas_rozdel").hide();

            if (d4_zkrac_uvazek)
                $("#tr_prescas_rozdel2").hide();
            else
                $("#tr_prescas_rozdel2").show();

            // PMEJ 18.09.2025 - Zobrazení řádku pro rozdělení nařízených přesčasů pouze pokud je tato funkce povolena v nastavení UI.
            // Pro zákazníka PSP
            if (d4_UI.NarizenyPrescasRozsirenyVisible)
            {
                $("#tr_prescas_rozdel_nar_prescas").show();                         // Celkem, převedeno, k proplacení, zbývá - Nařízený přesčas
                $("#tr_prescas_rozdel_nar_prescas_rocni").show();                   // roční - Nařízený přesčas
                $("[id$='Label16']").hide();                                        // Název "nařízený" přesčas
                $("#pr_narizeny").hide();                                           // "nařízený" přesčas - data
                $("[id$='Label17']").hide();                                        // prázdné pole.
                $("[id$='lab_prescas']").text(cPr("Napracováno"));                  // Změna textace

                // Prozatím nechám vžy zobrazeno
                //if (d4_pr_sumy.NarizenyZbyva < 0)
                //    $("#butt_presc_narizeny").hide();
                //else
                //    $("#butt_presc_narizeny").show();
                $("#butt_presc_narizeny").show();

            }
            else    // Případně vracím do původního stavu
            {                                                 
                $("#tr_prescas_rozdel_nar_prescas").hide();
                $("#tr_prescas_rozdel_nar_prescas_rocni").hide();
                $("[id$='Label16']").show();
                $("#pr_narizeny").show();
                $("[id$='Label17']").show();
                $("[id$='lab_prescas']").text(cPr("Přesčas za NV"));
            }
            
            $("#tr_presuvazek").hide();

            $("#pr_r_limit").text(d4_pr_sumy.CasLimitRok);
            $("#pr_r_celkem").text(d4_pr_sumy.CasSumaZaRok);
            $("#pr_r_prevedeno").text(d4_pr_sumy.CasPrevedenoRocni);
            $("#pr_r_zbyva").text(d4_pr_sumy.CasZbytekLimituRok);
            $("#precerp_rocni_limit").empty();
            if (d4_pr_sumy.DelkaZbytekLimituRok < 0) {
                $("#precerp_rocni_limit").append('<span class="ks-pr-chyba ks-pr-chyba4"></span>');
                $('.ks-pr-chyba4').prepend('<span title="' + cPr("Přečerpaný roční limit přesčasů") + '" ><i class="fi fi-exclamation" style="font-size: 15px;" ></i ></span>');
            }
            
            if (d4_UI.RozdeleniPrescasuVisible) {
                $("#tr_presuvazek").show();
                $("#tr_prescas_rozdel").show();
                $("#pr_celkem").text(d4_pr_sumy.Cas);
                $("#pr_prevedeno_celkem").text(d4_pr_sumy.CasPrevedeno);
                $("#pr_k_proplac").text(d4_pr_sumy.CasKProplaceni);
                $("#pr_k_zbyva").text(d4_pr_sumy.CasZbyva);

                if (d4_narizeny_prescas)
                    $("#pr_narizeny").text(d4_pr_sumy.CasNarizeny);
                $("#pr_limit_neplacenych").text(d4_pr_sumy.CasLimitNeplacenych);
                $("#pr_limit_neplacenych_zbytek").text(d4_pr_sumy.CasZbytekLimitNeplacenych);                

                //$("#pr_r_limit").text(d4_pr_sumy.CasLimitRok);             
                //$("#pr_r_celkem").text(d4_pr_sumy.CasSumaZaRok);
                //$("#pr_r_prevedeno").text(d4_pr_sumy.CasPrevedenoRocni);                
                //$("#pr_r_zbyva").text(d4_pr_sumy.CasZbytekLimituRok);
                //$("#precerp_rocni_limit").empty();
                //if (d4_pr_sumy.DelkaZbytekLimituRok < 0) {                    
                //    $("#precerp_rocni_limit").append('<span class="ks-pr-chyba ks-pr-chyba4"></span>');
                //    $('.ks-pr-chyba4').prepend('<span title="' + cPr("Přečerpaný roční limit přesčasů") + '" ><i class="fi fi-exclamation" style="font-size: 15px;" ></i ></span>');
                //}
                if (d4_pr_sumy.DelkaZbyva < 0)
                    $("#butt_presc").hide();
                else
                    $("#butt_presc").show();
               
                $("#pr_nabizet_hodiny").empty();
                if (d4_pr_sumy.NabizetVseKProplaceni)                   
                    $("#pr_nabizet_hodiny").append('<i class="fi-bolt-auto automaticke-predvyplneni"></i>');
                else                   
                    $("#pr_nabizet_hodiny").append('<i class="fi-picking pro-rucni-editaci"></i>');

                $("#pr_rozdeleno").empty();
                if (d4_pr_sumy.RucneVybranoKProplaceni)
                    $("#pr_rozdeleno").append('<i class="fi-picking rucne-rozdeleno"></i >');
                else
                    $("#pr_rozdeleno").append('<i class="fi-bolt-auto automaticky-rozdeleno"></i >');
            }

            // PMEJ 23.09.2025 - Rozšířený nařízený přesčas
            if (d4_UI.RozdeleniPrescasuVisible) {
                $("#pr_narizeny_celkem").text(d4_pr_sumy.NarizenyCelkemCas);
                $("#pr_narizeny_prevedeno").text(d4_pr_sumy.NarizenyPrevedenoCas);
                $("#pr_narizeny_proplac").text(d4_pr_sumy.NarizenyKProplaceniCas);
                $("#pr_narizeny_zbyva").text(d4_pr_sumy.NarizenyZbyvaCas);
                $("#pr_narizeny_rocni_celkem").text(d4_pr_sumy.NarizenySumaZaRokCas);
                $("#pr_narizeny_rocni_prevedeno").text(d4_pr_sumy.NarizenyPrevedenoRocniCas);
            }
        }

        function svatkyRekap() {
            $("#tr_svatek_rozdel").hide();
            if (d4_UI.RozdeleniSvatkuVisible) {
                $("#tr_svatek_rozdel").show();
                $("#sv_celkem").text(d4_sv_sumy.Cas);
                $("#sv_prevedeno_celkem").text(d4_sv_sumy.CasPrevedeno);
                $("#sv_k_proplac").text(d4_sv_sumy.CasKProplaceni);
                $("#sv_k_zbyva").text(d4_sv_sumy.CasZbyva);
            }           
        }
       
        function schvalovaniNastav(d) {
            $("#wnd_zu").data("kendoWindow").close();
            $("#wnd_zu_nahled").data("kendoWindow").close();

            if (d.ValidationError) {
                radalert(d.ValidationErrorText);
                return;
            }           
            d4_pp = {}
            pars.fedit = d.EditForm;
            d4_pan_zmena_stavu = d.PanelZmenaStavu;           
            d4_RizikoPorizovani_Editable = d.RizikoPorizovani_Editable;            

            if (!pars.fedit || d4_uzavreneObdobi) {               
                $('.ks-pr_zu-btn').hide();
            }
            else
                $('.ks-pr_zu-btn').show();

            if (d.IdPoz == 0) {
                $("#tab_schvalovani").hide();
                return;
            }
            else
                $("#tab_schvalovani").show();

            if (d4_pan_zmena_stavu)
                $("#div_schvalovani").show();
            else
                $("#div_schvalovani").hide();

          
            var div = $("#btn_schvalovani");
            var sp_pop = $("#akt_stav_text");
            sp_pop.empty();
            div.empty();

            d.Stavy.forEach(aa => {
                if (aa.Item1.length > 0) {
                    $(div).append('<button class="k-button" id="btnStav_' + aa.Item1 + '" value="' + aa.Item1 + '">' + aa.Item2 + '</button>');                  
                    $('#btnStav_' + aa.Item1).data("kendoButton");
                    $('#btnStav_' + aa.Item1).bind("click", function (e) {
                        e.preventDefault();
                        onZmenaStavu(d.OsCislo, d.CisloPom, d.IdPoz, aa.Item1);
                    });                   
                }
            });
            sp_pop.text(d.AktStavText);           
        }       

        function onZmenaStavu(os_cislo, cislo_pom, poz, stav) {                             
            d4_pp.os_cislo = os_cislo;
            d4_pp.cislo_pom = cislo_pom;
            d4_pp.poz = poz;
            d4_pp.stav = stav;
            radconfirm(cPr('Opravdu si přejete změnit stav požadavku?'), onZmenaStavuP, 330, 150, null, cPr('Změna stavu požadavku'));                          
        }

        function onZmenaStavuP(args) {
            if (args)
                PageMethods.ZmenaStavu(d4_pp.os_cislo, d4_pp.cislo_pom, pars.rok, pars.mes, d4_pp.poz, d4_pp.stav, schvalovaniNastav, onPageMethodError);
        }   


        function addButton(row, prep) {               
            if (prep) {
                var f = $(row).find(".ks-cell-pruchody").find('.ks-insert-btn');
                if (f == null || f == undefined || f.length==0) {
                    $(row).find(".ks-cell-pruchody").append('<button class="k-button ks-vlozit ks-insert-btn" id="btnAdd"></button>');
                    $(row).find(".ks-cell-pruchody").find(".ks-insert-btn").kendoButton({
                        icon: "add",
                        click: onVlozit
                    });
                }
            }
            else {
                $(row).find(".ks-cell-pruchody").find('.ks-vlozit').remove();               
            }
        }

        function allowEdit() {
            if (!pars.fedit) {
                KSMaster.Notifikace(cPr("Docházku nelze editovat z důvodu stavu požadavku"));
                return false;
            }
            else if (d4_uzavreneObdobi) {
                KSMaster.Notifikace(cPr("Docházku nelze editovat z důvodu uzavřeného docházkového období"));
                return false;
            }
            return true;
        }

        function onVlozit(val) {           
            if (allowEdit())
                onInsert(val);
        }
        function onPageMethodError(err) {
            if (err) {
                var title = err.get_exceptionType();
                var text = err.get_message();
                if (title)
                    KSMaster.showError(text, title);
            }
        }

        function templatePruchodyT(data) {            
            if (data.PruchodyTerminaly != null && data.PruchodyTerminaly.length>0) 
                return '<span class="tooltip"><i class="tt-child fi fi-square-terminal" style="font-size: 15px;" data-cdne="' + data.CDne + '" ></i></span>';
                           
            return "";
        }       

        function templatePruchody(data) {           
            var pr = "";           
            if (data.Pruchody != null) {
                for (var i = 0; i < data.Pruchody.length; i++) {
                   pr+= onePruchod(data.CDne, data.Pruchody[i], i, data.Pruchody);
                }               
            }
            return '<div>' + pr + '</div>';           
        }

        function templatePruchodyVykaz(data) {            
            var pr = "";
            if (data.IntervalyProZobrazeni != null) {
                for (var i = 0; i < data.IntervalyProZobrazeni.length; i++) {
                    pr += onePruchodVykaz(data.CDne, data.IntervalyProZobrazeni[i], i, data.IntervalyProZobrazeni);
                }
            }
            return '<div>' + pr + '</div>';
        }
     
        function tydenniSumaTemplate(data) {           
            var pr = "";
            if (data.ZkraceneUvazkyTydenni != null) {
                pr = tydenniSumy(data, data.ZkraceneUvazkyTydenni, false);
            }
            return pr;
        }

        function tydenniSumaFooterTemplate(data) {
            var pr = "";           
            if (d4_sumy.ZkraceneUvazkyTydenniSuma != null) {
                pr = tydenniSumy(data, d4_sumy.ZkraceneUvazkyTydenniSuma, true);
            }
            return pr;
        }

        function tydenniSumy(d, data, footer) {                     
            var pr = '<span class="ks-time">' + data.VykazanoWithLabel + '</span>' +
                '<span class="ks-time">' + data.RozdilWithLabel + '</span>' +
                '<span class="ks-time">' + data.NadFondWithLabel + '</span>' +
                '<span class="ks-time">' + data.PrescasWithLabel + '</span>';
            if (!footer) {                
                let p = (data.Prijato == "00:00" ? "x" : "p");
                let o = (data.Odvedeno == "00:00" ? "x" : "o");
                pr += '<span><span class="ks-time" data-zu="' + p + '" data-tyden="' + data.Tyden + '" data-tydenoddo="' + data.TydenOdDo + '">' + data.PrijatoWithLabel + '</span>  </span>';
                //if (pars.fedit && !d4_uzavreneObdobi)                
                pr += '<div><button class="ks-pr_zu-btn" id="editZkrPrevedeno" data-tyden="' + data.Tyden + '" data-maxcas="' + data.KPrevodu + '" ></button > ';
                pr += '<span class="ks-time" data-zu="' + o + '" data-tyden="' + data.Tyden + '" data-tydenoddo="' + data.TydenOdDo +'" >' + data.OdvedenoWithLabel + '</span ></div> ';
            }
            else
                pr += '<span class="ks-time">' + data.PrijatoWithLabel + '</span>' +
                    '<span class="ks-time">' + data.OdvedenoWithLabel + '</span>'; 

            return '<div class="ks-tydenni-sumy">' + pr + '</div>';
        }

        function templateNarPrescas(data) {        
            if (data.NarizenyPrescas != null && data.NarizenyPrescas != undefined) {
                var div = '<div class="ks-npr" >';
                if (data.NarizenyPrescasChyba != null) {
                    div += '<span class="ks-pr-chyba' + (data.NarizenyPrescasChyba != null ? " ks-pr-chyba3" : "") + '"></span>';
                }
                div += '<span class="ks-npr-hodnota">' + data.NarizenyPrescas + '</span>';
                div += '<span class="ks-command">' +
                    '<button class="ks-deleteNP-btn" id="deleteNPButton data-cdne="' + data.CDne + '"></button> ' +
                    '<button class="ks-upravitNP-btn" id="editNPButton data-cdne="' + data.CDne + '" ></button > ' +
                    '</span>';
                div += '</div> ';
            }
            else
                div = '<div class="ks-npr" />';
            return div;
        }

        function templateRiziko(data) {
            if (data.Riziko != null && data.Riziko != undefined) {               
                var div = '<div class="ks-npr" >';
                if (data.RizikoChyba != null) {
                    div += '<span class="ks-pr-chyba' + (data.RizikoChyba != null ? " ks-pr-chyba14" : "") + '"></span>';
                }               
                div += '<span class="ks-npr-hodnota">' + data.Riziko + '</span>';
                div += '<span class="ks-command">' +
                    '<button class="ks-deleteRiziko-btn" id="deleteRizikoButton data-cdne="' + data.CDne + '"></button> ' +
                    '<button class="ks-upravitRiziko-btn" id="editRizikoButton data-cdne="' + data.CDne + '" ></button > ' +
                    '</span>';

                if (data.RizikoZapocteneSmenyDec != null && data.RizikoZapocteneSmenyDec != undefined && data.RizikoZapocteneSmenyDec >0)
                    div += '<div><span class="ks-riziko-zapoc">' + data.RizikoZapoctenoSmeny + '</span></div>';

                div += '</div> ';
            }
            else
                div = '<div class="ks-npr" />';
            return div;
        }
        function templateRizikoFooter(data) {           
            let c = "";
            let c2 = "";
            if (d4_sumy.RizikoZapocteneSmenyDec >= 3) { 
                c = "<span class='ks-riziko-splneno'></span>";
                c2 = "<span class='ks-riziko-splneno-empty'></span>";
            }
            let div = '<div><span class="ks-npr-hodnota">' + d4_sumy.Riziko + '</span>'+c2+'</div>';
            div += '<div><span class="ks-riziko-zapoc">' + d4_sumy.RizikoZapoctenoSmeny + '</span>'+c+'</div>';
            return div;
        }

        function onePruchod(cDne, item, index, arr) {            
            var chyba = "";
            if (item.TypChyby == 1 )
                chyba=" ks-pr-chyba1";
            else if (item.TypChyby == 2)
                chyba = " ks-pr-chyba2";
            else if (item.TypChyby == 10001)
                chyba = " ks-pr-chyba10001";
            else if (item.TypChyby == 12) //chyba Nesouhlasí se skutečně odpracovanou dobou
                chyba=" ks-pr-chyba12";

            var c_podtr = "";
            if (item.Operace == "r")
                c_podtr=" ks-podtr"

            var div = '<div class="ks-pruchod"  data-Kod="' + item.Kod + '" data-Id="' + item.Id + '" data-cas="' + item.Time + '">' +
                '<span class="ks-pr-chyba' + chyba + '"></span>' +
                '<span class="ks-kod-nazev ks-kod-' + item.Kod + c_podtr + '">' + item.KodZkratka + '</span>' +
                '<span class="ks-time ks-kod-' + item.Kod + c_podtr + '">' + item.Time + '</span>';
            if (item.Editable) {
                div += '<span class="ks-command">' +
                    '<button class="ks-delete-btn" id="deleteButton' + cDne + '"></button> ' +
                    '<button class="ks-upravit-btn" id="editButton' + cDne + '"></button>' +
                    '</span>';
            }
            div +='</div> ';           
            return div;
        }

        function onDeleteZUV(e) {
            var tyden = $(e.currentTarget).data("tyden");
            var zu = $(e.currentTarget).data("zu");
            var tydenoddo = $(e.currentTarget).data("tydenoddo");
            radconfirm(cPr("Opravdu si přejete smazat záznam o zkráceném úvazku pro týden ") + tydenoddo + "?", onDeleteZUVP.bind(this, tyden, zu), 350, 150, null, cPr("Smazání zkráceného úvazku"));
        }

        function onDeleteZUVP(tyden, zu, args) {           
            if (args) {
                PageMethods.DeleteZUV(pars.rok, pars.mes, tyden, zu, function (data) {
                    if (data.ValidationError) {
                        radalert(data.ValidationErrorText);
                        return;
                    }
                    getGridData();
                }, onPageMethodError);
            }
        }
        
        /**
        * Vygeneruje HTML pro jeden záznam čistého výkazu průchodů.
        * 
        * @param {number} cDne - Pořadové číslo dne v měsíci.
        * @param {object} item - Objekt s údaji o průchodu (začátek, konec, chybové stavy).
        * @param {number} index - Index v poli záznamů.
        * @param {Array} arr - Pole všech záznamů pro daný den.
        * @returns {string} HTML reprezentace jednoho průchodu pro čistý výkaz.
        * 
        * Poznámky:
        * - Pokud je TypChyby == 11, přidá se vizuální indikátor chyby.
        * - Výpis je ve formátu: [Kód začátku] [čas od-do], případně chyba.
        * - Pokud je KodStart == 5212, je zde ponechán debugger pro ladění.
        * - Vzhled a formátování bylo změněno (viz komentář PMEJ 15.09.2025).
        */
        function onePruchodVykaz(cDne, item, index, arr) {
            var chyba = "";
            if (item.TypChyby == 11)
                chyba = " ks-pr-chyba11";           
            
            var div = '<div class="ks-pruchod-c" >' +
                // PMEJ 15.09.2025 - Změna vzhledu formátování výpisu čistého výkazu.
                //'<span class="ks-kod-nazev ks-kod-' + item.KodStart + ' title="' + item.KodStartCelyNazev + '">' + item.KodStartNazev + '</span>' +
                //'<span class="ks-time ks-kod-' + item.KodStart + '">' + item.StartTime + '</span>' +
                //'<span class="ks-kod-nazev ks-kod-' + item.KodKonec + '" title="' + item.KodKonecCelyNazev + '">' + item.KodKonecNazev + '</span>' +
                //'<span class="ks-time ks-kod-' + item.KodKonec + '">' + item.EndTime + '</span>';
                //'<span class="ks-time ks-kod-' + item.KodStart + '">' + item.EndTime + '</span>';

                '<span class="ks-kod-nazev ks-kod-' + item.KodStart + ' title="' + item.KodStartCelyNazev + '">' + item.KodStartNazev + '</span>' +
                '<span class="ks-time ks-kod-' + item.KodStart + '">' + item.StartTime + " - " + item.EndTime + '</span>'

            if (chyba != "")
                div+='<span class="ks-pr-chyba' + chyba + '"></span>';

            div+='</div> ';
            return div;
        }

        function templateZamknuto(data) {
            var r = '<input class="ks-checkbox" type="checkbox" id="z_' + data.CDne + '"/>' +
                '<span id="pozn_' + data.CDne + '" class="ks-i-container">';           
            if (data.PozVyp)
                r += '<i class="fi-memo-circle-check pozn-ikona" ></i>';
            else
                r+='<i class="fi-memo pozn-ikona-empty"></i>';
            r +="</span> "
            return r;
        }      

        function createGrid() {
            $("#grid").kendoGrid({
                dataSource: {
                    data: d4_mesData
                },               
                sortable: false,
                pageable: false,
                height:550,
                //width:1575,
                //width:1695,
                //width: (d4_zkrac_uvazek ? 1695 : 1575),
                //width: 1575,
                width: 1585,
                fixedWidth: false,                
                dataBound: function (e) {                                   
                    var rows = e.sender.tbody.children();
                    for (var j = 0; j < rows.length; j++) {
                        var row = $(rows[j]);
                        var dataItem = e.sender.dataItem(row);
                        var vikend = dataItem.get("Vikend");
                        if (vikend == true) row.addClass("ks-vikend");
                        var rozdil = dataItem.get("Rozdil");
                        if (rozdil.substring(0, 1) == "-") {
                            var columnIndex = this.wrapper.find(".k-grid-header [data-field=" + "Rozdil" + "]").index();
                            var cell = row.children().eq(columnIndex);
                            cell.addClass("ks-zaporny-rozdil");
                        }

                        // PMEJ 18.09.2025 - Označení rozdílu PSP jako červený, pokud je v záporné hodnotě
                        var rozdil = dataItem.get("RozdilBezNarizPrescas");
                        if (rozdil.substring(0, 1) == "-") {
                            var columnIndex = this.wrapper.find(".k-grid-header [data-field=" + "RozdilBezNarizPrescas" + "]").index();
                            var cell = row.children().eq(columnIndex);
                            cell.addClass("ks-zaporny-rozdil");
                        }   

                        var msvch = dataItem.get("MezismenneVolnoChyba");
                        if (msvch != null && msvch != "") {
                            var columnIndex = this.wrapper.find(".k-grid-header [data-field=VolnoPredSmenou]").index();
                            var cell = row.children().eq(columnIndex);
                            cell.addClass("ks-zaporny-rozdil");
                        }
                    }

                    $(".ks-delete-btn").kendoButton({
                        icon: "delete",                        
                        click: onDelete
                    });

                    $(".ks-upravit-btn").kendoButton({
                        icon: "edit",                       
                        click: onEdit
                    });

                    $(".ks-upravitNP-btn").kendoButton({
                        icon: "edit",
                        click: onEditNP
                    });

                    $(".ks-deleteNP-btn").kendoButton({
                        icon: "delete",
                        click: onDeleteNP
                    });
                   
                    $(".ks-upravitRiziko-btn").kendoButton({
                        icon: "edit",
                        click: onEditRiziko
                    });

                    $(".ks-deleteRiziko-btn").kendoButton({
                        icon: "delete",
                        click: onDeleteRiziko
                    });                    

                    $(".ks-pr_zu-btn").kendoButton({
                        icon: "edit",
                        click: onOdveztPZU
                    });                    

                    $(".ks-command").hide();

                    $(".ks-pruchod, .ks-npr").hover(
                        function () {                           
                            var index = $(this).closest("tr").index();                           
                            if (!d4_mesData[index].Oznaceno) {                              
                                $(this).find(".ks-command").show();
                                $(this).addClass("ks-vyzn-border");
                            }
                        },
                        function () {
                            $(this).find(".ks-command").hide();
                            $(this).removeClass("ks-vyzn-border");
                        }
                    );
                    $('.ks-pr-chyba1').prepend('<span title="' + cPr("Opakovaný průchod") + '" ><i class="fi fi-exclamation" style="font-size: 15px;" ></i ></span>');
                    $('.ks-pr-chyba2').prepend('<span title="' + cPr("Vykázáno více než 20 hodin") + '" ><i class="fi fi-exclamation" style="font-size: 15px;" ></i ></span>');
                    $('.ks-pr-chyba3').prepend('<span title="' + cPr("Přečerpaný nařízený přesčas") + '" ><i class="fi fi-exclamation" style="font-size: 15px;" ></i ></span>');
                    $('.ks-pr-chyba11').prepend('<span title="' + cPr("Nesouhlasí půldenní výkaz") + '" ><i class="fi fi-exclamation" style="font-size: 15px;" ></i ></span>');
                    $('.ks-pr-chyba12').prepend('<span title="' + cPr("Nesouhlasí se skutečně odpracovanou dobou") + '" ><i class="fi fi-exclamation" style="font-size: 15px;" ></i ></span>');
                    $('.ks-pr-chyba14').prepend('<span title="' + cPr("Hodiny v riziku jsou větší než odprac. doba") + '" ><i class="fi fi-exclamation" style="font-size: 15px;" ></i ></span>');
                    $('.ks-pr-chyba10001').prepend('<span title="' + cPr("Spolu s absencí vykázáno více než fond") + '" ><i class="fi fi-exclamation" style="font-size: 15px;" ></i ></span>');
                    $('.ks-riziko-splneno').prepend('<span title="' + cPr("Splněny 3 směny práce v R3") + '" ><i class="fi fi-check" style="font-size: 15px;" ></i></span>');
                  
                    /*$('.ks-pr-info_wrapper').prepend('<span class="ks-pr-info1" title="' + cPr("Převod z min. měsíce dočasně nedostupný") + '" ><i class="fi fi-exclamation" style="font-size: 15px;" ></i ></span>');*/
                },
                schema: {
                    model: {
                        fields: {
                            NDne: { type: "string" },
                            Smena: { type: "string" },                          
                            Odprac: { type: "string" },
                            Absence: { type: "string" },
                            Fond: { type: "string" },
                            Rozdil: { type: "string" },
                            ZkraceneUvazkyTydenni: {type: "string"},
                            PrestavkyRucniIGenerovane: { type: "string" },
                            Odpoledni: { type: "string" },
                            Nocni: { type: "string" },
                            Pohotovost: { type: "string" },
                            Stravenky: { type: "number" },
                            Riziko: {type: "string"}
                        }
                    }
                },
                columns: [
                  {
                    template: templateZamknuto,
                    title: cPr("Kontrola"),
                        width: "80px",
                        headerAttributes: {
                            title: cPr("Kontrola")
                        }
                  },
                  {
                      field: "NDne",
                      title: cPr("Den"),
                      width: "80px",
                      headerAttributes: {
                          title: cPr("Den")
                      }
                    },
                    /*
                   {
                       field: "Smena",
                       title: "Sm.",
                       width: "40px"                       
                    },*/
                    {
                        template: templatePruchodyT,
                        title: "",//cPr("Terminál"),
                        width: "35px",
                        attributes: {
                            "class": "ks-cell-pruchody-t"
                        },
                        headerAttributes: {
                            "class": "ks-cell-pruchody-t"
                        }
                    },
                    {
                        template: templatePruchody,                     
                        title: cPr("Průchody"),
                        width: "160px",
                        attributes: {
                            "class": "ks-cell-pruchody"                          
                        },
                        headerAttributes: {
                            "class": "border-left-no",
                            title: cPr("Průchody")
                        }
                    },
                    {
                        template: templatePruchodyVykaz,
                        title: cPr("Čistý výkaz"),
                        width: "185px",
                        attributes: {
                            "class": "ks-cell-pruchody-c",
                            style: "text-align:left"
                        },
                        headerAttributes: {
                            title: cPr("Čistý výkaz")
                        }
                    },                   
                    {
                        field: "Odprac",
                        title: cPr("Odprac."),
                        width: "80px",
                        footerTemplate: d4_sumy.Odprac,
                        headerAttributes: {
                            title: cPr("Odpracováno")
                        }
                    },                   
                    {
                        template: templateNarPrescas,
                        title: cPr("Nařízený přesčas"),
                        width: "120px",
                        hidden: !d4_narizeny_prescas,
                        footerTemplate: d4_sumy.NarizenyPrescas,
                        headerAttributes: {
                            title: cPr("Nařízený přesčas")
                        }
                    },                 
                    {
                        field: "Absence",
                        title: cPr("Absence"),
                        width: "80px",
                        footerTemplate: d4_sumy.Absence,
                        headerAttributes: {
                            title: cPr("Absence")
                        }
                    }, {
                        field: "Fond",
                        title: cPr("Fond"),
                        width: "80px",
                        footerTemplate: d4_sumy.Fond,
                        headerAttributes: {
                            title: cPr("Fond")
                        }
                    }, {
                        field: "Rozdil",
                        title: cPr("Rozdíl"),
                        width: "80px",
                        hidden: d4_UI.NarizenyPrescasRozsirenyVisible,      // Na základě nastavení UI se zobrazuje jeden ze dvou sloupců
                        footerTemplate: d4_sumy.Rozdil,                     // - buď Rozdíl, nebo Rozdíl PSP
                        headerAttributes: {
                            title: cPr("Rozdíl")
                        }
                    }, {    // PMEJ 22.09.2025 - Přidán nový sloupec pro zobrazení rozdílu PSP bez nařízených přesčasů
                        field: "RozdilBezNarizPrescas",
                        title: cPr("Rozdíl"),
                        width: "100px",
                        hidden: !d4_UI.NarizenyPrescasRozsirenyVisible,        // Na základě nastavení UI se zobrazuje jeden ze dvou sloupců
                        footerTemplate: d4_sumy.RozdilBezNarizPrescas,         // - buď Rozdíl, nebo Rozdíl PSP
                        headerAttributes: {
                            title: cPr("Rozdíl")
                        }
                    },{
                        field: "ZkraceneUvazkyTydenni",
                        title: cPr("Týden"),
                        width: "130px",//120
                        hidden: !d4_zkrac_uvazek,
                        template: tydenniSumaTemplate,
                        footerTemplate: tydenniSumaFooterTemplate,
                        headerAttributes: {
                            title: cPr("Týden")
                        }
                    },
                    {
                        field: "PrestavkyRucniIGenerovane",
                        title: cPr("Přestávka"),
                        width: "80px",
                        footerTemplate: d4_sumy.PrestavkyRucniIGenerovane,
                        headerAttributes: {
                            title: cPr("Přestávka")
                        }
                    },{
                        field: "Odpoledni",
                        title: cPr("Odpolední"),
                        width: "80px",
                        footerTemplate: d4_sumy.Odpoledni,
                        headerAttributes: {
                            title: cPr("Odpolední")
                        }
                    }, {
                        field: "Nocni",
                        title: cPr("Noční"),
                        width: "80px",
                        footerTemplate: d4_sumy.Nocni,
                        headerAttributes: {
                            title: cPr("Noční")
                        }
                    }, {
                        field: "Pohotovost",
                        title: cPr("Pohotovost"),
                        width: "80px",
                        footerTemplate: d4_sumy.Pohotovost,
                        headerAttributes: {
                            title: cPr("Pohotovost")
                        }
                    },
                    {
                        field: "Stravenky",
                        title: cPr("Stravenky"),
                        width: "80px",
                        footerTemplate: d4_sumy.Stravenky.toString(),
                        headerAttributes: {
                            title: cPr("Stravenky")
                        }
                    },
                    {
                        field: "VolnoPredSmenou",
                        title: cPr("Mezisměnné volno"),
                        width: "80px",
                        headerAttributes: {
                            title: cPr("Mezisměnné volno")
                        }                       
                    },                   
                    {
                        template: templateRiziko,
                        title: "R3",
                        width: "120px",
                        hidden: !d4_UI.RizikoPorizovaniEnabled,                       
                        footerTemplate: templateRizikoFooter,
                        headerAttributes: {
                            title: "R3"
                        }
                    },     
                ]
            });

            var boxy = $('.ks-checkbox').kendoCheckBox({
                change: checkBoxChange
            });
            for (var i = 0; i < boxy.length; i++) {
                boxy[i].checked = d4_mesData[i].Oznaceno;               
            }
        }

        function checkBoxChange(e) {           
            var por = e.sender.element[0].id.slice(2);
            var oc = KSMaster.HF_sel_os_cislo.value;
            var cp = KSMaster.HF_sel_cislo_pom.value;           
            PageMethods.SaveOznaceni(oc, cp, pars.rok, pars.mes, por, e.checked, afterCheckeBoxSaved, onPageMethodError);
        }

        function afterCheckeBoxSaved(data) {
            var data = data.split("|");
            var den = parseInt(data[0]);
            var checked = data[1];
            d4_mesData[den - 1].Oznaceno = (checked.toLowerCase() == "true");
            var row = $("#grid").find('tr')[parseInt(den)];
            addButton(row, !d4_mesData[den - 1].Oznaceno);
        }

        function showEditPruchody(e) {
            e.preventDefault();
          
            var dataItem = this.dataItem($(e.currentTarget).closest("tr"));
            pars.cis_dne = dataItem.get("CDne");
            d4_pruchody = dataItem.get("PruchodyJednotlive");
            d4_wndEditPruchodu.content(d4_detailsTemplate(dataItem));
            d4_wndEditPruchodu.center().open();
        }

        var d4_detailsTemplate, d4_wndEditPruchodu;

        function NextMonth(e, button) {
            var monthyearPicker = getMYPicker(button);
            var selectedDate = monthyearPicker.get_selectedDate();
            if (selectedDate == null) {
                return false;
            }
            var year = (selectedDate.getFullYear());
            var month = (selectedDate.getMonth() + 1);
            var date = selectedDate.getDate();
            monthyearPicker.set_selectedDate(new Date(year, month, date));
        }

        function PrevMonth(e, button) {            
            var monthyearPicker = getMYPicker(button);
            var selectedDate = monthyearPicker.get_selectedDate();
            if (selectedDate == null) {
                return false;
            }
            var year = (selectedDate.getFullYear());
            var month = (selectedDate.getMonth() - 1);
            var date = selectedDate.getDate();
            monthyearPicker.set_selectedDate(new Date(year, month, date));
        }

        function getMYPicker(button) {           
            return $find("<%=NabidkaObdobi.ClientID %>");
        }

        //function _createBarevne() {
        //    debugger;
        //    var gr = $("#grid");
        //    var width = gr.outerWidth();
        //    var height = gr.outerHeight();
        //    var position = gr.position();
        //    var table = $('<table>');
        //    d4_mesData.forEach(aa => {
        //        var row = $('<tr>');
        //        var cell = $('<td>').text(aa.NDne);

        //        row.append(cell);


        //        cell = $('<td>');
        //        row.append(cell);
        //        table.append(row);
        //    })
        //    debugger;
        //    gr.css({
        //        //'position': 'absolute !important;',
        //        //'top': position.top + 'px  !important;',
        //        //'left': position.left + 'px  !important;',
        //        'width': "1400" + "px  !important;",
        //        'height': "550" + "px  !important;"
        //    });
        //    $('body').append(table);
        //}

        //function loadPan(show) {
        //    setTimeout(() => {
        //        var loader = $("#loader").data("kendoLoader");
        //        debugger;
        //        if (show)
        //            loader.show();
        //        else
        //            loader.hide();
        //    });
        //}

        // -----------------------------------------------------------
        // Klávesové zkratky pro rychlé vkládání průchodů do docházky
        // -----------------------------------------------------------
        // Ctrl+O: Otevře formulář pro vložení odchodu na aktuální den,
        //         předvyplní kód odchodu a čas odchodu dle d4_vlozeni_data.
        //         Čas je automaticky převeden do formátu dle aktuální kultury
        //         (např. 14:00 pro cs-CZ, 02:00 PM pro en-US).
        //
        // Ctrl+P: Otevře formulář pro vložení příchodu na aktuální den,
        //         předvyplní kód příchodu dle d4_vlozeni_data.
        //
        // Použití:
        //  - Zajistí rychlé zadání docházkových údajů bez nutnosti myši.
        //  - Zohledňuje jazykové nastavení uživatele.
        document.addEventListener('keydown', function (event) {           
            if (event.ctrlKey && event.key.toLowerCase() === 'o') {
                event.preventDefault();
                var den = new Date().getDate();
                const rok = new Date().getFullYear();
                const mesic = new Date().getMonth() + 1;               
                if (rok != pars.rok || mesic != pars.mes) {
                    radalert(cPr("Pro vložení odchodu pomocí klávesové zkratky Ctrl+o musí být vybrán aktuální měsíc a rok."));
                    return;
                }

                var row = $("#grid").find('tr.k-master-row')[parseInt(den) - 1];
                var btn = $(row).find(".ks-insert-btn");
                if (btn.length == 0) return;
                btn.click();
                $("#dd_kod_konec").data("kendoDropDownList").value(d4_vlozeni_data.KodOdchod.toString());
                // PMEJ 28.08.2025 - Přidáno formátování času podle nastavené kendo.culture
                //$("#casDoPicker").data("kendoTimePicker").value(d4_vlozeni_data.CasOdchodu);
                var casOdch = formatTimeForCulture(d4_vlozeni_data.CasOdchodu);
                $("#casDoPicker").data("kendoTimePicker").value(casOdch);
                setTimeout(() => {
                    $("#casDoPicker").focus();
                }, 300);
                console.log('Klávesová zkratka Ctrl+o byla zachycena!');
            }
            else if (event.ctrlKey && event.key.toLowerCase() === 'p') {
                event.preventDefault();
                var den = new Date().getDate();
                const rok = new Date().getFullYear(); 
                const mesic = new Date().getMonth() + 1;
                if (rok != pars.rok || mesic != pars.mes) {
                    radalert(cPr("Pro vložení příchodu pomocí klávesové zkratky Ctrl+p musí být vybrán aktuální měsíc a rok."));
                    return;
                }
                var row = $("#grid").find('tr.k-master-row')[parseInt(den) - 1];
                var btn = $(row).find(".ks-insert-btn");
                if (btn.length == 0) return;
                btn.click();
                $("#dd_kod_start").data("kendoDropDownList").value(d4_vlozeni_data.KodPrichod.toString());              
                console.log('Klávesová zkratka Ctrl+p byla zachycena!');
            }           
        });       

        // -----------------------------------------------------------
        // formatTimeForCulture
        // Pomocná funkce pro převod času do formátu dle aktuální kultury.
        // Pokud je kultura en-US, převádí čas do 12h formátu s AM/PM,
        // jinak ponechá 24h formát.
        // -----------------------------------------------------------
        function formatTimeForCulture(val) {
            if (!val) return val;
            var culture = kendo.culture().name;
            var date = kendo.parseDate(val, "HH:mm");
            if (!date) return val;
            return kendo.toString(date, (culture === "en-US") ? "hh:mm tt" : "HH:mm");
        }

        Sys.Application.add_load(function () {
            //$("#loader").kendoLoader({
            //    visible: false,                
            //    size: 'md'
            //});
            setTimeout(() => {
                var vr = document.getElementById("<%=NabidkaObdobi.ClientID %>").control;
                var selectedDate = vr.get_selectedDate();
                if (selectedDate != null) {
                    pars.rok = selectedDate.getFullYear();
                    pars.mes = (selectedDate.getMonth() + 1);
                    getGridData();
                }
            });

            d4_wndEditPruchodu = $("#details")
                .kendoWindow({
                    title: "Editace průchodů",
                    modal: true,
                    visible: false,
                    resizable: false,
                    width: 850,
                    height: 800,
                    open: onOpen                    
                }).data("kendoWindow");

            d4_detailsTemplate = kendo.template($("#template_edit_window").html());         
         
            d4_window_edit = $("#wnd").kendoWindow({
                height: 400,
                width: 500,
                visible: false,               
                appendTo: "#aspnetForm",
                open: function (e) {
                    this.center();                   
                },
                close: function (e) {                   
                    var f=$("#edit_wrapper");
                    if (f != undefined)
                        f.empty();
                    showErrMes("");
                }
            }).data("kendoWindow");

            d4_window_edit.one("close", function () {
                showErrMes("");
                $("#insertForm").empty();
                obnovGrid();               
            });           

            d4_wnd_zu = $("#wnd_zu").kendoWindow({
                height: 220,
                width: 500,
                visible: false,
                appendTo: "#aspnetForm",
                open: function (e) {
                    this.center();                   
                    let max = $("#wnd_zu").data("max_cas");
                    let arr = max.split(":");
                    let picker = $("#zuTimePicker").data("kendoTimePicker");                                
                    picker.value(max);
                    setTimeout(()=>this.wrapper.css("z-index", "300 !important"), 1000);
                }               
            }).data("kendoWindow");

            d4_wnd_zu_nahled = $("#wnd_zu_nahled").kendoWindow({
                height: 300,
                width: 400,
                visible: false,
                appendTo: "#aspnetForm",
                open: function (e) {
                    this.center(); 
                    $("#btnZunZrusit").unbind();
                    $("#btnZunZrusit").kendoButton({
                        click: function (e) { d4_wnd_zu_nahled.close()},
                        width: 40,
                        height: 40
                    });

                    PageMethods.GetZUTydenNahled(KSMaster.HF_sel_os_cislo.value,
                        KSMaster.HF_sel_cislo_pom.value,                                              
                        pars.rok,
                        pars.mes,
                        $("#wnd_zu_nahled").data("tyden_z"),
                        $("#wnd_zu_nahled").data("tyden_zdroj"),                       
                        function (data) {                          
                            var ds = $("#grid_zu_prevody").data("kendoGrid").dataSource;
                            ds.data(data);
                        },
                        onPageMethodError);                    
                },
                close: function (e) {                             
                    showErrMes("");
                }
            }).data("kendoWindow");

            $(document).on("mouseenter", "span[data-zu='o'], span[data-zu='p']", function (e) {               
                var z = e.currentTarget.dataset.zu;
                var tyden = e.currentTarget.dataset.tyden;
                var tyden_od_do = e.currentTarget.dataset.tydenoddo;

                $("#wnd_zu_nahled").data("tyden_zdroj", tyden);
                $("#wnd_zu_nahled").data("tyden_z", z);
                $("#wnd_zu_nahled").data("tyden_oddo", tyden_od_do);

                d4_wnd_zu_nahled.open();
            });

            var ds_zu_prevody = new kendo.data.DataSource({
                batch: false,
                pageSize: 20,
                schema: {
                    model: {
                        fields: {
                            TydenPrijemShort: { type: "string" },
                            TydenVydejShort: { type: "string" },
                            Cas: { type: "string" }
                        }
                    }
                }
            });
            $("#grid_zu_prevody").kendoGrid({
                dataSource: ds_zu_prevody,
                navigatable: true,
                pageable: false,
                width: "100%",
                height: "100%",
                columns: [
                    {
                        field: "TydenPrijemShort", title: "Do týdne", width:"200px"
                    },
                    {
                        field: "TydenVydejShort", title: "Z týdne", width: "200px"
                    },
                    {
                        field: "Cas", title: "Čas", width: "100px"
                    },
                    {
                        command: [
                            {
                                name: "destroy",                               
                                text: "",
                                iconClass: "fi-trash"                                
                            }
                        ],
                        title: "&nbsp;",
                        width: "40px"
                    }                   
                ],
                editable: {
                    confirmation: false,                   
                },
                remove: function (e) {                  
                            let prizn = $("#wnd_zu_nahled").data("tyden_z");
                            let tyden = $("#wnd_zu_nahled").data("tyden_zdroj");
                            PageMethods.DeleteZUP(KSMaster.HF_sel_os_cislo.value, KSMaster.HF_sel_cislo_pom.value, prizn, tyden, e.model.Id, function () { $("#wnd_zu_nahled").data("kendoWindow").close(); getGridData(); }, function (err) { onPageMethodError(err); });
                },      
                dataBound: function (e) {
                    if (!d4_zkrac_uvazek) return;
                    if (this?._data?.length == 0) return;

                    var showCommands = pars.fedit && !d4_uzavreneObdobi;                   
                   
                    let z = $("#wnd_zu_nahled").data("tyden_z");
                    let zdroj = $("#wnd_zu_nahled").data("tyden_oddo");
                    if (showCommands)
                        this.showColumn(3);
                     else
                        this.hideColumn(3);

                    let hCol = "";
                    let sCol = "";
                    let title = "";
                    if (z == "p") {
                        hCol = "TydenPrijemShort";
                        sCol = "TydenVydejShort";
                        title = "Převod do týdne " + zdroj;                      
                    }
                    else if (z == "o") {
                        hCol = "TydenVydejShort";
                        sCol = "TydenPrijemShort"
                        title = cPr("Převod z týdne")+" " + zdroj;                       
                    }
                    $("#wnd_zu_nahled").data("kendoWindow").title(title);
                    this.hideColumn(hCol);
                    this.showColumn(sCol);
                }
            });   
            let gr = $("#grid_zu_prevody");
            gr.find(".k-grid-content").css("overflow-y", "hidden");         

            $("#weekSelector").kendoComboBox({
                dataTextField: "Item1",
                dataValueField: "Item2",
                placeholder: "Výběr týdne",
                clearButton: false,
                filter: "none",
                change: function (e) {
                    var selectedWeek = this.value();
                    if (selectedWeek == undefined) {
                        radalert("Není vybrán žádný týden, nelze pokračovat", 0, 0, "", null, null);
                        return;
                    }                    
                }
            });

            $("#zuTimePicker").kendoTimePicker({
                dateInput: true,
                format: "HH:mm"
            });

            $("#butt_presc").kendoButton({
                click: onRozdPresc,              
                //imageUrl: "../images/edit.png",
                width: 30,
                height:30
            });

            $("#butt_presc_narizeny").kendoButton({
                click: onRozdPrescNarizeny,
                //imageUrl: "../images/edit.png",
                width: 30,
                height: 30
            });

            $("#butt_svatek").kendoButton({
                click: onRozdSvatek,
                //imageUrl: "../images/edit.png",
                width: 30,
                height: 30
            });

            $("#btnReload").kendoButton({
                click: onReload,
                width: 30,
                height: 30
            });

            $("#wnd_prescasy").kendoWindow({
                height: 500,
                width: 500,
                visible: false,
                resizable: false,
                minHeight: 500,
                //title: cPr("Rozdělení přesčasů"),
                //appendTo: "#aspnetForm",
                appendTo: "#prwnddiv",
                open: function (e) {
                    this.center();
                },
                close: function (e) {                   
                }
            }).data("kendoWindow");

            ////////////////////////////////////////////////////
            d4_window_NPedit = $("#wnd_editnp").kendoWindow({
                height: 260,
                width: 500,
                visible: false,
                appendTo: "#aspnetForm",
                open: function (e) {
                    this.center();
                },
                close: function (e) {
                    var f = $("#edit_npwrapper");
                    if (f != undefined)
                        f.empty();
                    showErrMes("");
                }
            }).data("kendoWindow");

            d4_window_Rizikoedit = $("#wnd_editriziko").kendoWindow({
                height: 300,
                width: 400,
                visible: false,
                appendTo: "#aspnetForm",
                open: function (e) {
                    this.center();
                },
                close: function (e) {
                    var f = $("#edit_rizikowrapper");
                    if (f != undefined)
                        f.empty();
                    showErrMes("");
                }
            }).data("kendoWindow");

            vytvorWndPozn();

            $("#pr_hod").kendoNumericTextBox({
                decimals: 0,
                spinners: false,
                format: "n0",
                value: ""
            });

            $("#pr_min").kendoNumericTextBox({
                decimals: 0,
                spinners: false,
                format: "n0",
                value: "",
                max: 59
            });            

            $(".ks-pr-chyba2").kendoButton({                
                imageUrl: "../images/edit.png",
                width: 10,
                height: 10
            });           

            $("#grid").kendoTooltip({
                autoHide: false,
                filter: "i.tt-child",
                content: kendo.template($("#prTemplate").html()),
                width: 300,                  
            position: "top"                
            });
           
            d4_tooltip=$("#grid").kendoTooltip({
                autoHide: true,
                filter: "i.pozn-ikona",               
                content: function (e) {                 
                    var cd = $(e.target).parent()[0].id.substring(5);
                    return loadPoznamku(pars.rok, pars.mes, cd);
                },
                width: 300,
                height: 200,
                position: "top"               
            }).data("kendoTooltip");
            

            $("#rekap_prescasu").kendoTooltip({
                filter: "i.pro-rucni-editaci",
                autoHide: true,
                content: cPr("Prosím ručně editovat")               
            });
            $("#rekap_prescasu").kendoTooltip({
                filter: "i.rucne-rozdeleno",
                autoHide: true,
                content: cPr("Ručně editováno")
            });            

            $("#rekap_prescasu").kendoTooltip({
                //filter: "i.fi-bolt-auto",
                filter: "i.automaticke-predvyplneni",
                autoHide: true,
                content: cPr("Automatické předvyplnění, lze ručně upravit")
            });

            $("#rekap_prescasu").kendoTooltip({
                filter: "i.automaticky-rozdeleno",
                autoHide: true,
                content: cPr("Automaticky předvyplněno")
            });

            d4_ta_pozn=$("#txt_poznamka").kendoTextArea({
                rows: 5,
                cols: 60,
                maxLength: 200               
            })
            .data('kendoTextArea');
               
            $("#grid").find("i.tt-child").click(false);
        }); 

        // PMEJ 26.09.2025 - Zapoznámkováno, duplicitní funkce
        //function onUlozitPr() {            
        //    if (!allowEdit()) return;
        //    var os_cislo = KSMaster.HF_sel_os_cislo.value;
        //    var cislo_pom = KSMaster.HF_sel_cislo_pom.value;
        //    var hod = $("#pr_hod").val();
        //    var min = $("#pr_min").val();
        //    PageMethods.UlozPrescasy(os_cislo, cislo_pom, pars.rok, pars.mes, d4_rozdel_prescasy, hod, min, obnovPrescasy, onPageMethodError);
        //}

        function onUlozitPozn() {           
            if (!allowEdit()) return;
            var val = $("#txt_poznamka").val();
            PageMethods.SavePoznamku(KSMaster.HF_sel_os_cislo.value, KSMaster.HF_sel_cislo_pom.value, pars.rok, pars.mes, pars.cis_dne, val, afterUlozPozn, onPageMethodError);
        }

        function afterUlozPozn(data) {
            var arr = data.split("|");
            var i = $($("#pozn_" + arr[0]).children()[0]);
            i.removeClass();
            var nclass = "";
            if (arr[1].length > 0)              
                nclass = "pozn-ikona fi-memo-circle-check";
            else
                nclass = "pozn-ikona-empty fi-memo";           
            i.addClass(nclass);           
            $("#wnd_poznamka").data("kendoWindow").close();

            d4_tooltip.refresh();
        }

        function onZrusitPozn() {           
            $("#wnd_poznamka").data("kendoWindow").close();
        }

        var d4_detailsTemplate, d4_wndEditPruchodu;

        function NextMonth(e, button) {
            var monthyearPicker = getMYPicker(button);
            var selectedDate = monthyearPicker.get_selectedDate();
            if (selectedDate == null) {
                 return false;
             }
            var year = (selectedDate.getFullYear());
            var month = (selectedDate.getMonth() + 1);
            var date = selectedDate.getDate();
            monthyearPicker.set_selectedDate(new Date(year, month, date));
         }

        function PrevMonth(e, button) {
             var monthyearPicker = getMYPicker(button);
            var selectedDate = monthyearPicker.get_selectedDate();
            if (selectedDate == null) {
                 return false;
             }
            var year = (selectedDate.getFullYear());
            var month = (selectedDate.getMonth() - 1);
            var date = selectedDate.getDate();
            monthyearPicker.set_selectedDate(new Date(year, month, date));
         }

        function getMYPicker(button) {
             return $find("<%=NabidkaObdobi.ClientID %>");
        }

        function onReload(sender, a) {
            sender.event.preventDefault();
            obnovGrid();
        }

         function onRozdPresc(e) {                         
             var wn = $("#wnd_prescasy").data("kendoWindow");
             wn.open();            
             wn.title(cPr("Práce přesčas"));            
             $("#prescasy_wrapper").append('<div id="grPrescasy" ></div>');
             $("#grPrescasy").kendoGrid({                
                 dataSource: d4_rozdel_prescasy,                
                 groupable: false,
                 sortable: false,
                 pageable: false,
                 height: 300,
                 columns: [{
                     field: "Datum",
                     title: cPr("Datum"),
                     format: "{0:d}",
                     width: 100,                   
                     attributes: {
                         "class": "ks-datum-polozka"
                     }
                 }, {
                     field: "PracStr",
                     title: cPr("Prac. stř."),
                     width: 100,
                     attributes: {
                         "class": "ks-cell-polozka"
                     }
                 }, {
                     field: "Cas",
                     title: cPr("Čas"),
                     //footerTemplate: d4_pr_sumy.Cas,
                     footerTemplate: d4_pr_sumy.CasSOdectemLimitu,
                     width: 100,
                     attributes: {
                         "class": "ks-cas-polozka"
                     }
                 }, {
                     field: "CasKProplaceni",
                     title: cPr("K proplacení"),
                     width: 100,
                     footerTemplate: d4_pr_sumy.CasKProplaceni,
                     attributes: {
                         "class": "ks-cas-polozka"
                     }
                 }
                 ]
             });
             $("#btnUlozitPr").unbind("click");
             $("#btnZrusitPr").unbind("click");
             $("#btnUlozitPr").kendoButton({
                 click: onUlozitPr                
             });            


             $("#btnZrusitPr").kendoButton({
                 click: onZrusitPr
             });

             enterBound("pr_hod", onUlozitPr);
             enterBound("pr_min", onUlozitPr);
        }


        function onRozdPrescNarizeny(e) {
            var wn = $("#wnd_prescasy").data("kendoWindow");
            wn.open();
            wn.title(cPr("Práce přesčas"));
            $("#prescasy_wrapper").append('<div id="grPrescasy" ></div>');
            $("#grPrescasy").kendoGrid({
                dataSource: d4_rozdel_prescasy_narizeny,
                groupable: false,
                sortable: false,
                pageable: false,
                height: 300,
                columns: [{
                    field: "Datum",
                    title: cPr("Datum"),
                    format: "{0:d}",
                    width: 100,
                    attributes: {
                        "class": "ks-datum-polozka"
                    }
                }, {
                    field: "PracStr",
                    title: cPr("Prac. stř."),
                    width: 100,
                    attributes: {
                        "class": "ks-cell-polozka"
                    }
                }, {
                    field: "Cas",
                    title: cPr("Čas"),
                    footerTemplate: d4_pr_sumy.NarizenySOdectemLimituCas,
                    width: 100,
                    attributes: {
                        "class": "ks-cas-polozka"
                    }
                }, {
                    field: "CasKProplaceni",
                    title: cPr("K proplacení"),
                    width: 100,
                    footerTemplate: d4_pr_sumy.NarizenyKProplaceniCas,
                    attributes: {
                        "class": "ks-cas-polozka"
                    }
                }
                ]
            });
            $("#btnUlozitPr").unbind("click");
            $("#btnZrusitPr").unbind("click");
            $("#btnUlozitPr").kendoButton({
                click: onUlozitPrNarizeny
            });


            $("#btnZrusitPr").kendoButton({
                click: onZrusitPr
            });

            enterBound("pr_hod", onUlozitPrNarizeny);
            enterBound("pr_min", onUlozitPrNarizeny);
        }       

         function onZrusitPr() {
             var numtext = $("#pr_hod").data("kendoNumericTextBox");
             numtext.value(null);

             numtext = $("#pr_min").data("kendoNumericTextBox");
             numtext.value(null);

             $("#wnd_prescasy").data("kendoWindow").close();
         }

         function onUlozitPr() {             
             if (!allowEdit()) return;
             var os_cislo = KSMaster.HF_sel_os_cislo.value;
             var cislo_pom = KSMaster.HF_sel_cislo_pom.value;
             var hod = $("#pr_hod").val();
             var min = $("#pr_min").val();            

             PageMethods.UlozPrescasy(os_cislo, cislo_pom, pars.rok, pars.mes, d4_rozdel_prescasy, hod, min, obnovPrescasy, onPageMethodError);
        }

        function onUlozitPrNarizeny() {
            if (!allowEdit()) return;
            var os_cislo = KSMaster.HF_sel_os_cislo.value;
            var cislo_pom = KSMaster.HF_sel_cislo_pom.value;
            var hod = $("#pr_hod").val();
            var min = $("#pr_min").val();

            PageMethods.UlozPrescasyNarizeneRozs(os_cislo, cislo_pom, pars.rok, pars.mes, d4_rozdel_prescasy_narizeny, hod, min, obnovPrescasy, onPageMethodError);
        }

         function obnovPrescasy() {
             obnovGrid();
             onZrusitPr();
         }

         function onRozdSvatek(e) {                        
             var wn=$("#wnd_prescasy").data("kendoWindow");
             wn.open();
             wn.title(cPr("Práce ve svátek"));
             $("#prescasy_wrapper").append('<div id="grPrescasy" ></div>');
             $("#grPrescasy").kendoGrid({                 
                 dataSource: d4_rozdel_svatek,
                 groupable: false,
                 sortable: false,
                 pageable: false,
                 height: 300,
                 columns: [{
                     field: "Datum",
                     title: cPr("Datum"),
                     format: "{0:d}",
                     width: 100,
                     attributes: {
                         "class": "ks-datum-polozka"
                     }
                 }, {
                     field: "PracStr",
                     title: cPr("Prac. stř."),
                     width: 100,
                     attributes: {
                         "class": "ks-cell-polozka"
                     }
                 }, {
                     field: "Cas",
                     title: cPr("Čas"),
                     footerTemplate: d4_sv_sumy.Cas,
                     width: 100,
                     attributes: {
                         "class": "ks-cas-polozka"
                     }
                 }, {
                     field: "CasKProplaceni",
                     title: cPr("K proplacení"),
                     width: 100,
                     footerTemplate: d4_sv_sumy.CasKProplaceni,
                     attributes: {
                         "class": "ks-cas-polozka"
                     }
                 }
                 ]
             });
             $("#btnUlozitPr").unbind("click");
             $("#btnZrusitPr").unbind("click");
             $("#btnUlozitPr").kendoButton({
                 click: onUlozitSv
             });

             $("#btnZrusitPr").kendoButton({
                 click: onZrusitPr
             });

             enterBound("pr_hod", onUlozitSv);
             enterBound("pr_min", onUlozitSv);
         }

         function onUlozitSv() {             
             if (!allowEdit()) return;
             var os_cislo = KSMaster.HF_sel_os_cislo.value;
             var cislo_pom = KSMaster.HF_sel_cislo_pom.value;
             var hod = $("#pr_hod").val();
             var min = $("#pr_min").val();            
             PageMethods.UlozSvatek(os_cislo, cislo_pom, pars.rok, pars.mes, d4_rozdel_svatek, hod, min, obnovSvatek, onPageMethodError);
         }

         function obnovSvatek() {
             obnovGrid();
             onZrusitPr();
         }

         function createStyles() {
             $("#style_kody").remove();
            var style = document.createElement("style");
            style.type = "text/css";
            style.id = "style_kody";           
            var cssCode = "";            
            d4_kody.forEach(aa => {
                if (aa.BarvaBack != "" && aa.BarvaBack != null) {                   
                    cssCode += '.ks-kod-' + aa.Vyr_kod + ' { background-color:#' + aa.BarvaBack + ';color:' + getColor('#' + aa.BarvaBack, (aa.BarvaFore!=null ? '#' + aa.BarvaFore : null)) + ';border-radius: 3px; }';
                }
            });
             if (cssCode != "")
                 cssCode += ".ks-kod-0{background-color: #117406;color:" + getColor('#117406', null) + ";border-radius: 3px;}";
            
            // Nastavení obsahu nového stylu
            if (style.styleSheet) {
                // Pro Internet Explorer
                style.styleSheet.cssText = cssCode;
            } else {
                // Pro ostatní prohlížeče
                style.appendChild(document.createTextNode(cssCode));
            }

            // Přidání nového stylu do hlavičky dokumentu
            document.head.appendChild(style);
         }

         function invertColor(hex) {
             // Remove the hash if it's there
             hex = hex.replace(/^#/, '');

             // Parse the hex value to RGB
             var bigint = parseInt(hex, 16);
             var r = (bigint >> 16) & 255;
             var g = (bigint >> 8) & 255;
             var b = bigint & 255;

             // Invert the RGB values
             r = 255 - r;
             g = 255 - g;
             b = 255 - b;

             // Convert the RGB back to hex
             var invertedHex = ((r << 16) | (g << 8) | b).toString(16).padStart(6, '0');

             return '#' + invertedHex;
         }

         function getColor(backColor, foreColor) {
             if (foreColor != null && foreColor != undefined && foreColor!="#")
                 return foreColor;
             return invertColor(backColor);
         }
        
        function onDelete(e) {            
            if (!allowEdit()) return;

            var id = e.sender.element[0].id;
            var div = $(e.sender.element[0]).parent().closest('.ks-pruchod');
            var id = $(div).attr("data-id");
            var kod = $(div).attr("data-kod");
            selectedPruchod.id = id;
            selectedPruchod.kod = kod;                
            var index = $(e.sender.element[0]).closest("tr").index();
            pars.cis_dne = d4_mesData[index].CDne;
            var os_cislo = KSMaster.HF_sel_os_cislo.value;
            var cislo_pom = KSMaster.HF_sel_cislo_pom.value;               
            var data = JSON.stringify(selectedPruchod);
            Validace(os_cislo, cislo_pom, pars.rok, pars.mes, pars.cis_dne, data, "D");               
            if (d4_error.IsValid) {
                radconfirm(cPr('Opravdu si přejete smazat záznam') + '? ', deleteFn, 330, 150, null, cPr('Mazání záznamu'));
            }
            else {
                radalert(d4_error.ErrorMessage);
            }            
         }

         function showErrMes(err) {
             $("#err_mess").text(err);
         }

         function showErrMesNP(err) {
             $("#err_npmess").text(err);
         }

        function deleteFn(args) {
            if (args == true) {
                var os_cislo = KSMaster.HF_sel_os_cislo.value;
                var cislo_pom = KSMaster.HF_sel_cislo_pom.value;               
                var data = JSON.stringify(selectedPruchod);
                PageMethods.DeleteData(os_cislo, cislo_pom, pars.rok, pars.mes, pars.cis_dne, data, obnovGridPoDelete, onPageMethodError);
            }
        }

         function deleteNPFn(args) {
             if (args) {
                 var os_cislo = KSMaster.HF_sel_os_cislo.value;
                 var cislo_pom = KSMaster.HF_sel_cislo_pom.value;
                 PageMethods.DeleteNPData(os_cislo, cislo_pom, pars.rok, pars.mes, pars.cis_dne, obnovGridPoDelete, onPageMethodError);
             }
         }

        function obnovGrid() {
            getGridData();
        }

         function obnovGridPoDelete() {
             KSMaster.NotifikaceInfoMazani();
             obnovGrid();
         }
         function uprCas(val) {            
             if (val == "" || val == null) return val;
             if (kendo.culture().name == "en-US") {
                 var arr = val.split(":");
                 var hours = parseInt(arr[0]);                 
                 var post = "";
                 if (hours > 12) {
                     hours -= 12;
                     post = "PM";
                 }
                 else
                     post = "AM";
                 return ("0" + hours.toString()).slice(-2) + ":" + arr[1] + " " + post;
             }
             return val;
         }
        function onEdit(e) {                  
            if (!allowEdit()) return;

            var index = $(e.sender.element[0]).closest("tr").index();
            pars.cis_dne = d4_mesData[index].CDne;            
            var div = $(e.sender.element[0]).parent().closest('.ks-pruchod');           
            var cas=$(div).attr("data-cas");           
            d4_editModel.id = $(div).attr("data-id");
            d4_editModel.cas = uprCas(cas);
            d4_editModel.kod = $(div).attr("data-kod");

            $("#editForm").empty();

            $("#wnd").data("kendoWindow").open();
            $("#wnd").data("kendoWindow").title(cPr("Editace průchodu") + ": " + d4_mesData[pars.cis_dne - 1].NDne);

            $("#edit_wrapper").append('<div id="editForm"></div>');

            $("#wnd").data("kendoWindow").setOptions({
                height: 300
            });
            
            $("#editForm").kendoForm({
                orientation: "horizontal",
                buttonsTemplate: '',
                formData: d4_editModel,
                items: [{
                    label: "",
                    items: [
                        {
                            id: "combo_edit", field: "kod", editor: "DropDownList", label: "", validation: { required: true },
                            editorOptions: {
                                placeholder: "Výběr docházkového kódu",
                                dataTextField: "Nazev",
                                dataValueField: "Vyr_kod",
                                filter: "contains",
                                dataSource: d4_kody.filter(aa => aa.Nabizet == true)                                
                            }
                        },
                        {                            
                            field: "cas",
                            editor: "TimePicker",
                            label: "",
                            format: "HH:mm",
                            placeholder: "HH:mm",
                            //culture: "cs-CZ",
                            id: "casPicker_edit",
                            width: "200",
                            editorOptions: {
                                dateInput: true
                            },
                            validation: { required: true }
                        }]
                }],
                validateField: function (e) {
                    //validationSuccess.html("");
                },
                submit: function (e) {
                    e.preventDefault();
                    //validationSuccess.html("<div class='k-messagebox k-messagebox-success'>Form data is valid!</div>");
                },
                clear: function (ev) {
                    // validationSuccess.html("");
                }
            });

            $("#wnd").resize();            
            enterBound("casPicker_edit", onUlozit);
            btnBind();

            $("#combo_edit").data("kendoDropDownList").bind("select", function (e) { $("#casPicker_edit").focus();});
         }

         function onEditNP(e) {             
             if (!allowEdit()) return;
             var index = $(e.sender.element[0]).closest("tr").index();
             pars.cis_dne = d4_mesData[index].CDne;            

             d4_editModelNP.cas = d4_mesData[index].NarizenyPrescas;
             d4_editModelNP.cas_max = d4_mesData[index].Rozdil;

             $("#editForm").empty();

             showErrMesNP("");
             $("#wnd_editnp").data("kendoWindow").open();
             $("#wnd_editnp").data("kendoWindow").title(cPr("Editace nařízeného přesčasu") + ": " + d4_mesData[pars.cis_dne - 1].NDne);

             $("#edit_npwrapper").append('<div id="editNPForm"></div>');

             $("#wnd").data("kendoWindow").setOptions({
                 height: 300
             });

             $("#editNPForm").kendoForm({
                 orientation: "horizontal",
                 buttonsTemplate: '',
                 formData: d4_editModelNP,
                 items: [{
                     label: "",
                     items: [                       
                         {
                             field: "cas",
                             editor: "TimePicker",
                             label: "",
                             format: "HH:mm",
                             placeholder: "HH:mm",                            
                             id: "casPicker_npedit",                             
                             width: "200",                            
                             editorOptions: {
                                 dateInput: true
                             },
                             validation: { required: true }
                         }]
                 }],
                 validateField: function (e) {
                     debugger;
                     //validationSuccess.html("");
                 },
                 submit: function (e) {
                     e.preventDefault();
                     //validationSuccess.html("<div class='k-messagebox k-messagebox-success'>Form data is valid!</div>");
                 },
                 clear: function (ev) {
                     // validationSuccess.html("");
                 }
             });             
            
             $("#wnd_editnp").resize();

             btnNPBind();
             enterBound("casPicker_npedit", onNPUlozit);
         }

         function onDeleteNP(e) {
             var index = $(e.sender.element[0]).closest("tr").index();
             pars.cis_dne = d4_mesData[index].CDne;
             
             if (!allowEdit()) return;
            radconfirm(cPr('Opravdu si přejete smazat záznam') + '? ', deleteNPFn, 330, 150, null, cPr('Mazání nařízeného přesčasu'));               
        }

        function onDeleteRiziko(e) {
            var index = $(e.sender.element[0]).closest("tr").index();
            pars.cis_dne = d4_mesData[index].CDne;

            if (!d4_RizikoPorizovani_Editable) return;
            radconfirm(cPr('Opravdu si přejete smazat záznam') + '? ', deleteRizikoFn, 330, 150, null, cPr('Mazání rizika'));
        }

        function deleteRizikoFn(args) {
            if (args) {
                var os_cislo = KSMaster.HF_sel_os_cislo.value;
                var cislo_pom = KSMaster.HF_sel_cislo_pom.value;
                PageMethods.DeleteRizikoData(os_cislo, cislo_pom, pars.rok, pars.mes, pars.cis_dne, obnovGridPoDelete, onPageMethodError);
            }
        }

        ///////////////////////////////////////////
        function onEditRiziko(e) {           
            if (!d4_RizikoPorizovani_Editable) return;
            var index = $(e.sender.element[0]).closest("tr").index();
            pars.cis_dne = d4_mesData[index].CDne;

            d4_editModelRiziko.cas = d4_mesData[index].Riziko;
            d4_editModelRiziko.cas_max = d4_mesData[index].FondProR3;
            d4_editModelRiziko.dat_od = new Date(pars.rok, pars.mes - 1, pars.cis_dne);
            d4_editModelRiziko.dat_do = new Date(pars.rok, pars.mes - 1, pars.cis_dne);

            $("#editForm").empty();

            showErrMesNP("");
            $("#wnd_editriziko").data("kendoWindow").open();
            $("#wnd_editriziko").data("kendoWindow").title(cPr("Editace rizika") + ": " + d4_mesData[pars.cis_dne - 1].NDne);

            $("#edit_rizikowrapper").append('<div id="editRizikoForm"></div>');

            $("#wnd").data("kendoWindow").setOptions({
                height: 300
            });

            $("#editRizikoForm").kendoForm({
                orientation: "horizontal",
                buttonsTemplate: '',
                formData: d4_editModelRiziko,
                items: [{
                    label: "",
                    items: [
                        {
                            field: "cas",
                            editor: "TimePicker",
                            label: "",
                            format: "HH:mm",
                            placeholder: "HH:mm",
                            id: "casPicker_rizikoedit",
                            width: "200",
                            editorOptions: {
                                dateInput: true
                            },
                            
                            validation: { required: true }
                        },
                        {
                            field: "dat_od",
                            editor: "DatePicker",
                            label: "",                            
                            id: "datOdPicker_rizikoedit",                            
                            editorOptions: {
                                dateInput: true,
                                min: new Date(pars.rok, pars.mes - 1, 1),
                                max: new Date(pars.rok, pars.mes, 0)
                            },
                           
                            validation: { required: true }
                        },
                        {
                            field: "dat_do",
                            editor: "DatePicker",
                            label: "",                           
                            id: "datDoPicker_rizikoedit",                            
                            editorOptions: {
                                dateInput: true,
                                min: new Date(pars.rok, pars.mes - 1, 1),
                                max: new Date(pars.rok, pars.mes, 0)
                            },
                           
                            validation: { required: true }
                        },
                    ]
                }],
                validateField: function (e) {
                    debugger;
                    //validationSuccess.html("");
                },
                submit: function (e) {
                    e.preventDefault();
                    //validationSuccess.html("<div class='k-messagebox k-messagebox-success'>Form data is valid!</div>");
                },
                clear: function (ev) {
                    // validationSuccess.html("");
                }
            });

            $("#wnd_editriziko").resize();

            btnRizikoBind();
            //enterBound("casPicker_npedit", onNPUlozit);
        }
        ///////////////////////////////////////////


        function onOdveztPZU(e) {
            var el = e.sender.element[0];
            var tyden = $(el).attr("data-tyden");
            var max_cas = $(el).attr("data-maxcas");                 

            if (max_cas.substring(0,1)=="-" || max_cas == "0:0" || max_cas == "00:00") {
                radalert(cPr("Není co převádě, nelze pokračovat"));
                return;
            }
            d4_wnd_zu.title(cPr("Převod nadúvazku do dalšího týdne"));
            $("#wnd_zu").data("tyden_zdroj", tyden);
            $("#wnd_zu").data("max_cas", max_cas);          

            d4_wnd_zu.open();

            btnZuBind()

            let d = [];
            let item = { "rok": pars.rok, "mes": pars.mes, "tyden": tyden }; d.push(item);           
            var data_send = JSON.stringify(d);

            $.ajax({
                type: "POST",
                url: "d4.aspx/GetZuWeekCombo",               
                data: "{data:'" + data_send + "'}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    var comboBox = $("#weekSelector").data("kendoComboBox");
                    if (comboBox) {                        
                        comboBox.setDataSource(response.d.Data);
                        comboBox.value(response.d.SelectedValue);
                        comboBox.text(response.d.SelectedText);
                        comboBox.trigger("change");
                    }
                },
                error: function (xhr, status, error) {
                    console.error("Error loading dropdown data: " + error);
                }
            });
        }


         function btnBind() {
             $("#btnUlozit").unbind();
             $("#btnZrusit").unbind();            
             $("#btnUlozit").kendoButton({
                 click: onUlozit                 
             });
             $("#btnZrusit").kendoButton({
                 click: onZrusit
             });

            
        }
        function btnZuBind() {
            $("#btnZuZrusit").unbind();
            $("#btnZuZrusit").kendoButton({
                click: onZuZrusit
            });

            $("#btnZuUlozit").unbind();
            $("#btnZuUlozit").kendoButton({
                click: onZuUlozit
            });            
        }

         function btnNPBind() {
             $("#btnNPUlozit").unbind();
             $("#btnNPZrusit").unbind();
             $("#btnNPUlozit").kendoButton({
                 click: onNPUlozit                 
             });
             $("#btnNPZrusit").kendoButton({
                 click: onNPZrusit
             });
        }

        function btnRizikoBind() {
            $("#btnRizikoUlozit").unbind();
            $("#btnRizikoZrusit").unbind();
            $("#btnRizikoUlozit").kendoButton({
                click: onRizikoUlozit
            });
            $("#btnRizikoZrusit").kendoButton({
                click: onRizikoZrusit
            });
        }


        function onInsert(e) {            
            if (!allowEdit()) return;

            d4_index = $(e.sender.element[0]).closest("tr").index();
            pars.cis_dne = d4_mesData[d4_index].CDne;
           
            $("#insertForm").empty();
            
            $("#wnd").data("kendoWindow").open();
            $("#wnd").data("kendoWindow").title(cPr("Vložení průchodu")+": " + d4_mesData[pars.cis_dne - 1].NDne);

            $("#edit_wrapper").append('<div id="insertForm"></div>');
            $("#wnd").data("kendoWindow").setOptions({               
                height:500
            });          
            $("#insertForm").kendoForm({
                orientation: "horizontal",
                buttonsTemplate: '',
                            
                formData: d4_editModel,
                items: [{
                    type: "group",
                    label: cPr("Začátek"),
                    items: [
                        {
                            id: "dd_kod_start", field: "kodstart", editor: "DropDownList", label: "", validation: { required: false },                           
                            editorOptions: {
                                placeholder: "Výběr kódu pro začátek průchodu",
                                dataTextField: "Nazev",
                                dataValueField: "Vyr_kod",
                                filter: "contains",
                                dataSource: d4_kody.filter(aa => aa.Nabizet == true),
                                change: function (e) {
                                    d4_pdabs = false;
                                    var value = this.value();                                    
                                    var kodProp = d4_kody.find(item => item.Vyr_kod === parseInt(value));
                                    var ddk = $("#dd_kod_konec").data("kendoDropDownList");
                                    if ((kodProp.IsAbsence) && (kodProp.Zpusob == "p")) {
                                        if (kodProp.Zpusob == "p") {                                           
                                            ddk.value(d4_kody.find(item => item.Ident === 3).Vyr_kod);
                                            ddk.enable(false);
                                            $("#casDoPicker").data("kendoTimePicker").enable(false);
                                            d4_pdabs = true;                                           
                                        }
                                    }
                                    else if (kodProp.Zpusob == "i"){                                      
                                        ddk.value(d4_kody.find(item => item.Ident === 3).Vyr_kod);
                                    }
                                    else {
                                        var kk = $("#dd_kod_konec").data("kendoDropDownList")
                                        kk.enable(true);
                                        kk.value("");
                                        var cd = $("#casDoPicker").data("kendoTimePicker");
                                        cd.enable(true);
                                        cd.value("");
                                        d4_pdabs = false;
                                    }                                  
                                }
                            }
                        },
                        {
                            field: "casod",
                            editor: "TimePicker",
                            label: "",
                            format: "HH:mm",
                            id: "casOdPicker",
                            placeholder:"HH:mm",
                            validation: { required: false }                            
                        }]
                },
                    {
                        label: cPr("Konec"),
                        type: "group",
                    items: [
                        {
                            id: "dd_kod_konec",field: "kodkonec", editor: "DropDownList", label: "",validation: { required: false },
                            editorOptions: {
                                placeholder: "Výběr kódu pro konec průchodu",
                                dataTextField: "Nazev",
                                dataValueField: "Vyr_kod",
                                filter: "contains",
                                dataSource: d4_kody.filter(aa => aa.Nabizet == true)
                            }
                        },                      
                        {
                            field: "casdo",
                            editor: "TimePicker",
                            label: "",
                            format: "HH:mm",
                            id: "casDoPicker",
                            placeholder: "HH:mm",
                            validation: { required: false }
                        }                       
                    ]
                }],
                validateField: function (e) {
                    alert("validace");
                    //validationSuccess.html("");
                },
                submit: function (e) {
                    e.preventDefault();                 
                },
                clear: function (ev) {
                   // validationSuccess.html("");
                }
            });           

            let ddk = $("#dd_kod_start").data("kendoDropDownList");
            setTimeout(() => {
                ddk.focus();
                ddk.open();
            }, 300);           

            $("#casOdPicker").kendoTimePicker({
                dateInput: true,
                change: function () {                  
                    if (d4_pdabs) {                                     
                        var pulsm = d4_mesData[pars.cis_dne - 1].FondTS.TotalMinutes / 2;                        
                        $("#casDoPicker").data("kendoTimePicker").value(this.value().addMinutes(pulsm));
                    }
                }
            });
            $("#casDoPicker").kendoTimePicker({
                dateInput: true
            });
            enterBound("casOdPicker", onUlozit);
            enterBound("casDoPicker", onUlozit);
            btnBind();

            $("#dd_kod_start").data("kendoDropDownList").bind("select", function (e) { $("#casOdPicker").focus();});
            $("#dd_kod_konec").data("kendoDropDownList").bind("select", function (e) { $("#casDoPicker").focus();});          
        }

         function enterBound(id, funct) {
             $("#" + id).on('keypress', function (e) {
                 if (e.which == 13) {
                     e.preventDefault();
                     funct();
                 }
             });
         }        

        function onZrusit() {           
            $("#wnd").data("kendoWindow").close();
            showErrMes("");
        }

        function onZuZrusit() {
            //$("#wnd_zu").data("kendoWindow").close();
            d4_wnd_zu.close();
           
            //showErrMes("");
        }

        function onZuUlozit(e) {
            var os_cislo = KSMaster.HF_sel_os_cislo.value;
            var cislo_pom = KSMaster.HF_sel_cislo_pom.value;

            var cas = $("#zuTimePicker").val();
            var tyden_cil = $("#weekSelector").val();            
            var tyden_zdroj=$("#wnd_zu").data("tyden_zdroj");           
            var max = $("#wnd_zu").data("max_cas");     

            if (cas > max) {            
                var alert = radalert(cPr("Zadáváte více než je maximální povolená hodnota"));                
                setTimeout(function () {                  
                    alert._popupElement.style.zIndex = 20000; 
                }, 100);
                return;
            }

            let data = {};
            data.tyden_zdroj = tyden_zdroj;
            data.tyden_cil = tyden_cil;
            data.cas = cas;
           
            var d = JSON.stringify(data);

            PageMethods.SaveZUPrevod(os_cislo, cislo_pom, pars.rok, pars.mes, d, onUlozenoZU, onPageMethodError);            
        }

        function onUlozenoZU(data) {
            //alert("uloženo");
            $("#wnd_zu").data("kendoWindow").close();
            getGridData();
        }

         function onNPZrusit() {
             $("#wnd_editnp").data("kendoWindow").close();
             showErrMesNP("");
        }

        function onRizikoZrusit() {
            $("#wnd_editriziko").data("kendoWindow").close();
            showErrMesNP("");
        }

        function onUlozit() {          
            var os_cislo = KSMaster.HF_sel_os_cislo.value;
            var cislo_pom = KSMaster.HF_sel_cislo_pom.value;
            var mesx = pars.mes;
            if (d4_index == 0 && d4_poslDenPM)
                mesx--;
            if ($("#editForm") != undefined && $("#editForm") != null && $("#editForm").length > 0) {
                var cas = $("#casPicker_edit").val();
                var kod = $("#combo_edit").val();

                d4_editModel.kod = kod;
                d4_editModel.cas = cas;
                var data = JSON.stringify(d4_editModel);

                Validace(os_cislo, cislo_pom, pars.rok, mesx, pars.cis_dne, data, "E");
                if (d4_error.IsValid) {
                    PageMethods.SaveData(os_cislo, cislo_pom, pars.rok, mesx, pars.cis_dne, data, onUlozeno, onPageMethodError);
                    $("#wnd").data("kendoWindow").close();
                }
                else {                                    
                    showErrMes(d4_error.ErrorMessage);
                }
            }
            else if ($("#insertForm") != undefined && $("#insertForm") != null && $("#insertForm").length > 0) {
                d4_editModel.id = null;               
                d4_editModel.cas_od = $("#casOdPicker").val();                
                d4_editModel.kod_start = $("#dd_kod_start").val();                
                d4_editModel.cas_do = $("#casDoPicker").val();               
                d4_editModel.kod_konec = $("#dd_kod_konec").val();              
                var data = JSON.stringify(d4_editModel);

                Validace(os_cislo, cislo_pom, pars.rok, mesx, pars.cis_dne, data, "I");               
                if (d4_error.IsValid) {
                    PageMethods.SaveData(os_cislo, cislo_pom, pars.rok, mesx, pars.cis_dne, data, onUlozeno, onPageMethodError);
                    $("#wnd").data("kendoWindow").close();
                }
                else {                   
                    showErrMes(d4_error.ErrorMessage);
                }
            }          
         }

         function onNPUlozit() {
             var os_cislo = KSMaster.HF_sel_os_cislo.value;
             var cislo_pom = KSMaster.HF_sel_cislo_pom.value;
             var cas = $("#casPicker_npedit").val();            
             var rozdil = d4_mesData[pars.cis_dne - 1].Rozdil;
             var fond = d4_mesData[pars.cis_dne - 1].Fond;
             if (casDoplnNuly(cas) > casDoplnNuly(rozdil))
                 showErrMesNP(cPr("Zadávaná hodnota") + ": " + cas + ". " + cPr("Maximální povolená hodnota") + ": " + rozdil);
             else {                 
                 PageMethods.SaveNP(os_cislo, cislo_pom, pars.rok, pars.mes, pars.cis_dne, fond, cas, onUlozeno, onPageMethodError);
                 $("#wnd_editnp").data("kendoWindow").close();
             }             
        }

        function onRizikoUlozit() {
            var os_cislo = KSMaster.HF_sel_os_cislo.value;
            var cislo_pom = KSMaster.HF_sel_cislo_pom.value;
            var cas = $("#casPicker_rizikoedit").val();
            var pickerOd = $("#datOdPicker_rizikoedit").data("kendoDatePicker");
            var pickerDo = $("#datDoPicker_rizikoedit").data("kendoDatePicker");

            var dat_od = pickerOd.value();
            var dat_do = pickerDo.value();

            PageMethods.SaveRiziko(os_cislo, cislo_pom, pars.rok, pars.mes, dat_od.getDate(), dat_do.getDate(), cas, onUlozeno, onPageMethodError);
            $("#wnd_editriziko").data("kendoWindow").close();
        }

         function casDoplnNuly(val) {
             if (val.length<5) 
                 return "0"+val;
             else
                 return val;
         }
        function onUlozeno() {           
            obnovGrid();
            KSMaster.NotifikaceInfoUlozeni();
        }

        function onOpen(e) {
            populateListView();

            /*
            $("#ulozitButton").kendoButton({                
                icon: "save",
                click:onSave
            });

            $("#cancelButton").kendoButton({
                icon: "cancel",
                click:onCancel
            });
            */
            /*
             '<button class="ks-delete-btn" id="deleteButton' + CDne + '">Smazat</button> ' +
                    '<button class="ks-upravit-btn" id="editButton' + CDne + '">Upravit</button>'+
             * */
        }
           
        function getIndexOfEl(e) {
            var id = e.sender.element[0].id;
            var index = parseInt(id.split("_")[2]);
            return index;
        }
        function onChangeKod(e) {           
            var index = getIndexOfEl(e);
            d4_pruchody[index].Kod = this.value();
        }
       
         /*
        function onSave(e) {
            var os_cislo = KSMaster.HF_sel_os_cislo.value;
            var cislo_pom = KSMaster.HF_sel_cislo_pom.value;           
            var data=JSON.stringify(d4_pruchody);
            PageMethods.SaveData(os_cislo, cislo_pom, pars.rok, pars.mes, data, updateGrid, onPageMethodError);            
        }
        */

        function onCancel(e) {

         }

        function cPr(str) {
            // PMEJ 03.03.2025 - pokud nebyl string v překladovém slovníku nalezen, vrátí se původní hodnota
             if (KSMaster.dict && KSMaster.dict.has(str)) {
                 return KSMaster.dict.get(str);
             }
             return str;
         }

        /*
        function populateListView() {
            $('#listPruchod .k-listview-item').remove();          
            
            $("#listPruchod").kendoListView({
                dataSource: {
                    data: d4_pruchody
                },
                template: kendo.template($("#templatePruchod").html()),
                pageable: false
            });
          
            $('.ks-pr').remove();           

            var rows = $('#listPruchod .k-listview-item');
            for (var i = 0; i < rows.length; i++) {
                createPr(rows[i], i, d4_pruchody[i]);
            }
        }
        */
        /*
        function createPr(row, i, p) {
            $('<div class="ks-pr" id="div_pr_' + i.toString() + '"/>').appendTo(row);
           
            $('<input id="combo_kody_' + i.toString() + '" data-role="combobox" />').appendTo("#div_pr_" + i.toString());
           var combo= $("#combo_kody_" + i.toString()).kendoComboBox({
                dataTextField: "Nazev",
                dataValueField: "Vyr_kod",
                dataSource: d4_kody,
                filter: "contains",
                suggest: true,
                change: onChangeKod,
                placeholder: "Kód..."              
                //,
                //noDataTemplate: $("#noDataTemplate").html()
           }).data("kendoComboBox");
            if (p != undefined)
                combo.value(p.Kod);

            var id = 'timepicker_cas_' + i.toString();
            $('<input id="' + id + '"/>').appendTo('#div_pr_' + i.toString());
            var picker=$("#" + id).kendoTimePicker({
                format: "HH:mm",
                dateInput: false,
                change:onChangeTime
            }).data("kendoTimePicker");
            if (p != undefined)
                picker.value(p.PruchodTime);

            var id_tlac = "tlac_" + i.toString();
            $('<a class="ks-pr-del" id="del_' + id_tlac + '"/>').appendTo('#div_pr_' + i.toString());

            $("#del_" + id_tlac).kendoButton({
                icon: "delete",
                click: onDelete
            });

            $('<div class="ks-plus-div" id="div_plus_' + id_tlac + '"/>').appendTo(row);

            $('<a class="ks-pr-plus" id="plus_' + id_tlac + '"/>').appendTo("#div_plus_" + id_tlac);
            $("#plus_" + id_tlac).kendoButton({
                icon: "plus",
                click: onInsert                
            });
        }
        */

        function createRekap() {
            $("#gr_rekap").kendoGrid({
                dataSource: d4_rekapitulace,
                width: 380,
                groupable: false,
                sortable: false,
                pageable: false,
                scrollable: false,
                columns: [
                    {
                        field: "Zkratka",
                        title: "",
                        width: 30,
                        attributes: {
                            "class": "ks-cell-polozka"
                        }
                    },
                    {
                    field: "Nazev",
                    title: "",
                    width: 220,
                    attributes: {
                            "class": "ks-cell-polozka"
                    }
                },{
                    field: "DobaFormat",
                    title: "",
                    width: 80,
                    attributes: {
                        "class": "ks-cell-hodiny"
                    }
                    }],
                dataBound: function (e) {                   
                    var rows = e.sender.tbody.children();
                    for (var j = 0; j < rows.length; j++) {
                        var row = $(rows[j]);
                        var dataItem = e.sender.dataItem(row);
                        var kod = dataItem.get("Kod");
                        var columnIndex = this.wrapper.find(".k-grid-header [data-field=" + "Zkratka" + "]").index();
                        var cell = row.children().eq(columnIndex);
                        cell.addClass("ks-kod-"+kod);
                    }                   
                }
            });            
         }


         function createChyby() {             
             $("#chyby").kendoGrid({
                 dataSource: d4_chyby,
                 width: 380,
                 height: 150,
                 groupable: false,
                 sortable: false,
                 pageable: false,
                 scrollable: true,
                 columns: [{
                     field: "TextChyby",
                     title: "",                     
                     attributes: {
                         "class": "ks-chyba"
                     }
                 }                   
                 ],
                 dataBound: function (e) {
                     var rows = e.sender.tbody.children();
                     for (var j = 0; j < rows.length; j++) {
                         var row = $(rows[j]);
                         var dataItem = e.sender.dataItem(row);
                         var cislo = dataItem.get("CisloChyby");
                         //var columnIndex = this.wrapper.find(".k-grid-header [data-field=" + "Zkratka" + "]").index();
                         var cell = row.children().eq(0);
                         if (cislo > 10000)
                             cell.addClass("ks-varovani");
                         else if (cislo > 0 && cislo < 10000)
                             cell.addClass("ks-chyba");
                             
                     }
                     /*
                     var rows = e.sender.tbody.children();
                     for (var j = 0; j < rows.length; j++) {
                         var row = $(rows[j]);
                         var dataItem = e.sender.dataItem(row);
                         var kod = dataItem.get("Kod");
                         var columnIndex = this.wrapper.find(".k-grid-header [data-field=" + "Zkratka" + "]").index();
                         var cell = row.children().eq(columnIndex);
                         cell.addClass("ks-kod-" + kod);
                     }
                     */
                 }
             });            
         }

         function createVolna(data) {
             if ($("#gr_volna").data("kendoGrid") != undefined) {
                 $("#gr_volna").data("kendoGrid").destroy();
                 $("#gr_volna").empty();
             }

             var sirka_sl = 100;
             var sirka_1sl = 250;
             var arrD = data.split("|||");
             var data_o = JSON.parse(arrD[0]);
             var sloupce = JSON.parse(arrD[1]);
             var cols = [];
             var it = new Object();
             it.field = "title";
             //it.title = cPr("Zůstatky volna k") + " 1." + pars.mes + "." + pars.rok;            
             var today = new Date();
             it.title = cPr("Zůstatky volna k") + " "+ today.getDate() + "." + (today.getMonth() + 1) + "." + today.getFullYear();
             it.width = sirka_1sl;
             cols.push(it);
             for (var i = 0; i < sloupce.length; i++) {
                 it = new Object();
                 it.field = sloupce[i].Item1;
                 it.title = sloupce[i].Item2;
                 it.width = sirka_sl;
                 it.attributes = {
                     "class": "ks-right"
                 };
                 cols.push(it);
             }             
             $("#gr_volna").kendoGrid({
                 dataSource: data_o,
                 width: (cols.length * sirka_sl + sirka_1sl),
                 groupable: false,
                 sortable: false,
                 pageable: false,
                 scrollable: false,
                 columns: cols                
             });
         }         

         function Validace(os_cislo, cislo_pom, rok, mes, cis_dne, data, typ) {                      
             var item = JSON.parse(data);           
             item.os_cislo = os_cislo;
             item.cislo_pom = cislo_pom;
             item.rok = rok;
             item.mes = mes;
             item.cis_dne = cis_dne;
             item.typ = typ;
             var data_send = JSON.stringify(item);             
             $.ajax({
                 type: "POST",
                 url: "<%=this.ResolveUrl(@"~/Dochazka/d4.aspx/ValidaceProKod")%>",

         data: "{data:'" + data_send + "'}",
         async: false,
         contentType: "application/json",
         dataType: "json",
         error: function (xhr, ajaxOptions, thrownError) {
             alert(xhr.status);
         alert(xhr.responseText);
         alert(thrownError);
                 },
         success: function (msg) {
             d4_error = msg.d;
                 }
             });
         }


    </script>


     <script id="prTemplate" type="text/x-kendo-template">
          #  var cdne=$(target).attr("data-cdne")#
            <div class="prTemplate-wrapper">
          #  var data=d4_mesData[cdne - 1]#      
             <div class="ks-hlavicka-tt">#=data.NDne#</div>         
        
          #   for (var i = 0; i < data.PruchodyTerminaly.length; i++) {#  
          #         var item=data.PruchodyTerminaly[i] #
                    <div>
                    <span class="ks-zkratka-tt">#=item.KodZkratka #</span>
                    <span class="ks-time-tt">#=item.Time #</span>
                     <span class="ks-par1-tt">#=item.Par1 #</span>
                    </div>
          #       }        #
            </div>
    </script>    
    <style type="text/css">
        .err {
            padding: 10px;
            color:red;
        }
        .pr_ikona
        {
            display:block;
            width:50px;
            height:50px;
        }
        .pozn-ikona, .pozn-ikona-empty {
            margin-left: 10px;
            margin-top:10px !important;
            cursor:pointer;
        }
        
   .ks-vikend
   {
       background-color:RGB(255, 255, 224) !important;
   }
   .k-grid th, .k-grid td
   {
       padding:4px 10px !important;
   }
   .ks-kod-nazev 
   {
       padding:0 3px;
       font-size:x-small !important;
       width:21px !important;
       display:inline-block !important;
      /* font-weight:bold;*/
       text-align:left;
       margin-left:12px;
       /*font-family: "OpenSans-Light" !important;*/
   }
   .ks-rekap-polozka 
   {
       padding:0 3px;
       font-size:x-small !important;         
       text-align:left;
       margin-left:12px;      
   }
   .ks-time
   {
       padding:0 3px;
       font-size:x-small !important;
       /*font-weight:bold;*/
       /*font-family: "OpenSans-Light" !important;*/
      /* width:30px !important;*/
       display:inline-block !important;
       margin-left:3px;
       margin-right:3px;

   }
   .ks-pruchod, .ks-pruchod-t
   {
       padding: 2px 0px;
       white-space:nowrap;    
       /*position:relative;*/      
   }
    .ks-npr
    {
        width:110px !important;
        text-align:left !important;
        display:block;
       
    }
    .ks-npr-hodnota
    {
        margin-left:15px;
        margin-right:8px;
    }
    .ks-poznamka
    {
        width:100%;
        height:calc(100% - 58px);
        background-color:white !important;
    }

   /*#grid .k-grid td{*/
    #grid td{
      line-height:1.3 !important;
      text-align:center !important;
      vertical-align:top !important;
   }

   #details-container
    {
        padding: 10px;
    }

    #details-container h2
    {
        margin: 0;
    }

    #details-container em
    {
        color: #8c8c8c;
    }

    #details-container dt
    {
        margin:0;
        display: inline;
    }

    .ks-edit-pruchod{
       
    }

    .ks-chyba{
        color:red;
        font-size:12px;
    }
    .ks-varovani{
        color:blue;
        font-size:12px;
    }

    .ks-plus-div{
         /*background-color:blue;*/
         margin-left:70px;
         width:150px;
         border-left:1px dotted black;
         text-align:center;
         vertical-align:central;
         padding:25px 0;
    }

    .ks-pr-del{
        margin-left:250px;
    }
    .k-timepicker
    {
        width:150px !important;
        padding-left:0;
        margin-top:10px;
    }
    .k-input>*, .k-picker>* {   
        background-color:lightyellow;
     }
    .ks-pr{
        border-bottom:1px dotted black;
        border-top:1px dotted black;
        /*width:50%;*/
    }
    .ks-pr-plus
    {
        position:relative;
        left: -75px;
        /*top:25px*/
    }
    .k-combobox
    {
        width:300px;
    }
    .ks-command
    {
        /*position:absolute;*/

    }

    .ks-vyzn-border{
        border:1px solid lightgray;
        margin:0px;
        padding:0px;
    }

    .ks-cell-pruchody {
       border-left-width: 0px !important;    
    }
    .ks-pruchod
    {
        text-align:left;
    }
    .ks-cell-pruchody-t
    {
        border-right-width: 0px !important;       
    }
     .k-grid .k-icon-button
     {
         padding:0px !important;
         width:18px;
         height:18px;
     }
     .ks-delete-btn
     {
         margin-left: 10px;
     }
     .ks-cell-polozka
     {
         text-align:left !important;
         font-size:12px;
     }
     .ks-cell-hodiny
     {
         text-align: right !important;
         padding-left:20px;
     }
     .ks-pruchod-c{
         margin:3px;
         text-align:left;
     }     
     #gr_rekap .k-header
     {
         display:none;
     }
     #chyby .k-header
     {
         display:none;
     }
     #gr_rekap
     {
         float:left;
     }

     .window-footer .k-button
     {
         margin-left: 20px;
     }

     .window-footer{
    position: absolute;
    bottom: 0;
    display: block;
    width: 95%;
    margin-top: 150px;
    padding: 19px 0 20px;
    text-align: right;
    border-top: 1px solid #e5e5e5;
  }

     td.ks-cell-pruchody {
       position: relative;     
    }
    .border-left-no{
          border-left-width:0px !important;
    }
    .ks-tydenni-sumy
    {       
        text-align:right;       
    }

 td.ks-cell-pruchody .ks-vlozit {
  position: absolute;
  right: 0;
  top: 0;
  /*width: 10px;
  height: 10px;
  background: red;*/
}
 .KsUnderlineTable
 {
     width:300px;
 }

 #div_obdobi{
     float:left;
 }
 .ks-cas-polozka, .ks-datum-polozka
 {
     text-align:right !important;
 } 
 #wnd_prescasy .k-footer-template td:nth-child(3), #wnd_prescasy .k-footer-template td:nth-child(4)  {
	text-align:right !important;
}
 #wnd_prescasy .k-numerictextbox{     
     margin: 2px;
     width: 60px !important;
 } 
 .ks-cas-kpropl
 {
     padding-bottom:10px;
     white-space:nowrap;
 }
 .div_schvalovani
 {
     margin-left:10px;
 }
 .ks-zaporny-rozdil
 {
     color:red !important;
 }
 .grPrescasy{
     width:100% !important;      
 }
 .ks-pr-chyba{
     width:8px !important;
     display:inline-block;
     vertical-align:bottom !important;
     padding-bottom:0px !important;
 }
 .prTemplate-wrapper
 {    
     /*font-size:1.2em;*/
 }
 .ks-zkratka-tt, .ks-time-tt
 {
     display:inline-block;
     width:30px;
     padding-left:20px;
 }
 .ks-par1-tt
 {  
     padding-left:20px;
 }
 .ks-hlavicka-tt
 {
     padding-bottom:10px !important;
 }

 .rozd_data{
     text-align:right !important;
     font-size:14px;
 }
 .rgCaption
 {
     font-size:small !important;
     text-align:right;
 }
 .DataFieldHeaderStyle
 {
     padding:4px 8px !important;
     text-align:right;
     font-size:14px;
 }
 .fi-exclamation
 {
     color:red;
 }
 .ks-left
 {
     text-align:left !important;
 }
 .ks-right
 {
     text-align:right !important;
 }
 #div_schval_kontejner{
     min-height:46px !important;
 }
 .ks-podtr{
     text-decoration:underline;
 }

#wnd_editriziko .k-timepicker {
    padding-left:10px;
}
#wnd_editriziko .k-input {
   margin-bottom:5px;
}
#wnd_editriziko .k-timepicker {
    padding-left:10px;
}
#wnd_editriziko .k-datepicker {
   width:150px;
}
.ks-riziko-zapoc {
    margin-bottom: 0px;
    font-weight: bold;
    color:darkgreen;
    padding-left:15px;
}
.ks-riziko-splneno, .ks-riziko-splneno-empty{
    display: inline-block;
    text-align:right;    
     color:darkgreen;
     width:20px;
}


  /*#loader {
        display: flex;
        position:absolute !important;
        left:100px;
        top:100px;
        justify-content: center;
        align-items: center;       
        z-index:10000;
      }*/


    /* #gr_rekap .k-grid .ks-cell-hodiny {
    line-height: 1.3 !important;
    text-align: left !important;
    vertical-align: top !important;
}*/
    

   /*.ks-pruchody
   {*/
      /* padding:2px 2px !important;*/
       /*border: none !important;
       margin:0px;
       border-collapse:collapse !important;
   }*/
   /*.ks-pruchody td{
       padding:0px !important;*/
       /*border-width:0px !important;*/
   /*}*/
   /*.k-grid td{
      line-height:1.3 !important;
      text-align:center !important;
      vertical-align:top !important;
   }
  
   .k-column-title{
         text-align:center !important;         
   }
   .k-header th{
       background-color:lightgray !important;
   }*/
   /*.ks-cell-pruchody
   {
       padding:0px !important;
       border-width:0px !important;*/
      /* width:200px !important;   */
   /*}*/
  /* .ks-cell-cas
   {
       width:80px;
   }

   .ks-cell-den{
       width:40px;
   }
   .ks-cell-smena{
       width:40px;
   }
   th[data-field="Smena"]
    {
      width:40px;
    }
    th[data-field="NDne"]
    {
      width:40px;
    }
     th[data-field="NDne"]
    {
      width:40px;
    }*/

   
</style>
     <%-- <telerik:RadAjaxLoadingPanel runat="server" ID="RALP"></telerik:RadAjaxLoadingPanel>--%>
   <%-- <div id="loader" class="RadAjax RadAjax_Metro" >
       <div class="raDiv">loader</div>
       <div class="raColor raTransp"></div>
    </div>--%>
    <%-- <div id="loader" class="loader k-loader">
                <div class="inner one"></div>
                <div class="inner two"></div>
                <div class="inner three"></div>
            </div>--%>
    <div  style="width:calc(100% - 30px); padding:15px" class="ksprvek">
        <table>
            <tr>
            <td  style="vertical-align:top">
                 <table class="colapsedTable">
                    <tr>
                        <td>
                            <kspwc:TImageButton ID="TIB_obdobi_prev" runat="server" CssClass="rbPrevious16 rbPredefinedIcons"
                                OnClientClick="PrevMonth(event, this);return false;" ImageUrl="~/Images/TransparentDot.png" />
                        </td>
                        <td>
                            <kspwc:TRadMonthYearPicker runat="server" ID="NabidkaObdobi" EnableTyping="False" AutoPostBack="false">
                                <DateInput ReadOnly="true">
                                </DateInput>
                                <ClientEvents OnDateSelected="NabidkaObdobi_OnDateSelected" />
                                </kspwc:TRadMonthYearPicker>
                        </td>
                        <td>
                            <kspwc:TImageButton ID="TIB_obdobi_next" runat="server" CssClass="rbNext16 rbPredefinedIcons"
                                OnClientClick="NextMonth(event, this);return false;" ImageUrl="~/Images/TransparentDot.png" />                           
                        </td>
                         <td>   
                            <button id="btnReload" class="kstlacitko"><i class="fi-refresh"></i><asp:Label runat="server" ID="Label31" Text="[%Načíst%]"></asp:Label></button>
                        </td>
                        <td>
                           <kspwc:TButton ID="TBPracList" runat="server" CssClass="kstlacitko" Icon-PrimaryIconCssClass="fi-rectangle-list" Text="[%Pracovní list%]" OnClick="TBPracList_Click" />
                        </td>
                        </tr>
                </table>
            </td>
                  
            </tr>
        </table>
      
        </div>
            
            
     <%--<div id="rightPanel" style="float:right;">lkjsdflaskjflasdkj lkj klj</div>--%>
 
     <div id="grid" class="ksprvek"></div>
     <div id="details"></div>
     

    <div id="wnd" class="ksprvek">  
        <div id="edit_wrapper"></div>
        <div class="window-footer" style="margin-top: 30px;">
            <div id="err_mess" class="err"></div>          
            <button id="btnUlozit" class="kstlacitko"><i class="fi-disk"></i><asp:Label runat="server" ID="lab_ulozit2" Text="[%Uložit%]"></asp:Label></button>
            <button id="btnZrusit" class="kstlacitko"><i class="fi-ban"></i><asp:Label runat="server" ID="lab_zrusit2" Text="[%Zrušit%]"></asp:Label></button>
        </div>
    </div>
    <div id="wnd_editnp" class="ksprvek">  
        <div id="edit_npwrapper"></div>
        <div class="window-footer" style="margin-top: 30px;">
            <div id="err_npmess" class="err"></div>             
             <button class="kstlacitko" id="btnNPUlozit"><i class="fi-disk"></i><asp:Label runat="server" ID="Label8" Text="[%Uložit%]"></asp:Label></button>
            <button class="kstlacitko" id="btnNPZrusit"><i class="fi-ban"></i><asp:Label runat="server" ID="Label9" Text="[%Zrušit%]"></asp:Label></button>
        </div>
    </div>
    <div id="wnd_editriziko" class="ksprvek">  
    <div id="edit_rizikowrapper"></div>
    <div class="window-footer" style="margin-top: 30px;">
        <div id="err_rizikomess" class="err"></div>             
         <button class="kstlacitko" id="btnRizikoUlozit"><i class="fi-disk"></i><asp:Label runat="server" ID="Label42" Text="[%Uložit%]"></asp:Label></button>
        <button class="kstlacitko" id="btnRizikoZrusit"><i class="fi-ban"></i><asp:Label runat="server" ID="Label44" Text="[%Zrušit%]"></asp:Label></button>
    </div>
</div>
    <br />
    <div id="prwnddiv"></div>
   <%-- <asp:Label runat="server" ID="lab_nadpis" Text="Rekapitulace" CssClass="H1" ></asp:Label>--%>
     <div id="wnd_prescasy" class="ksprvek">  
        <div id="prescasy_wrapper" class="kspvek"></div>
         <div class="window-footer" style="margin-top: 30px;">
             <div class="ks-cas-kpropl"><span>                
                 <asp:Label runat="server" ID="lab_k_propl" Text="[%K proplacení%]"></asp:Label>
              </span><input id="pr_hod" data-role="numerictextbox" data-format="0" data-decimals="0" data-min="0"/>:<input id="pr_min" data-role="numerictextbox" data-format="0" data-decimals="0" data-min="0"/></div>
              <button class="kstlacitko" id="btnUlozitPr"><i class="fi-disk"></i><asp:Label runat="server" ID="lab_ulozit" Text="[%Uložit%]"></asp:Label></button>
             <button class="kstlacitko" id="btnZrusitPr"><i class="fi-ban"></i><asp:Label runat="server" ID="lab_zavrit" Text="[%Zrušit%]"></asp:Label></button>
          </div>
    </div>

    <div id="wnd_zu" class="ksprvek">  
        <div id="zu_edit_wrapper" style="vertical-align:top !important;">
             <input id="zuTimePicker" />
             <select id="weekSelector" style="width:300px;margin-top:8px;height:30px;"></select>
        </div>
        <div class="window-footer" style="margin-top: 30px;">
            <div id="zu_err_mess" class="err"></div>          
            <button id="btnZuUlozit" class="kstlacitko"><i class="fi-disk"></i><asp:Label runat="server" ID="Label40" Text="[%Uložit%]"></asp:Label></button>
            <button id="btnZuZrusit" class="kstlacitko"><i class="fi-ban"></i><asp:Label runat="server" ID="Label41" Text="[%Zrušit%]"></asp:Label></button>
        </div>
    </div>

    <div id="wnd_zu_nahled" class="ksprvek">  
        <div id="zun_edit_wrapper" style="height:100%;">    
            <div id="grid_zu_prevody"></div>
        </div>
        <div class="window-footer" style="margin-top:30px;">
           <%--  <div id="zu_err_mess" class="err"></div>  --%>        
           <%-- <button id="btnZuUlozit" class="kstlacitko"><i class="fi-disk"></i><asp:Label runat="server" ID="Label42" Text="[%Uložit%]"></asp:Label></button>--%>
            <button id="btnZunZrusit" class="kstlacitko" style="margin-right:15px"><i class="fi-ban"></i><asp:Label runat="server" ID="Label43" Text="[%Zavřít%]"></asp:Label></button>
        </div>
    </div>
    
    <%--<div id="gr_rekap" class="ksprvek" style="float:left"></div>   --%>
<%--    KsUnderlineTable--%>
    <div>
        <table id="rekap_pripl" class="ksprvek" style="width:100%;">
            <tr>
                 <td class="rgCaption ks-left"><asp:Label runat="server" ID="Label25" Text="[%Příplatky%]"></asp:Label></td>

                    <td class="DataFieldHeaderStyle"> 
                        <asp:Label runat="server" Text="[%Odpolední%]:" ID="Label20" ></asp:Label></td>
                    <td class="rozd_data  ks-left">
                        <span id="pr_odpoledni"></span>
                    </td>

                    <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="[%Noční%]:" ID="Label21" ></asp:Label></td>
                    <td class="rozd_data  ks-left">                                          
                        <span id="pr_nocni"></span>
                    </td>

                    <td class="DataFieldHeaderStyle ks-vikend-jednotlivy"> <asp:Label runat="server" Text="[%Sobota%]:" ID="Label22" ></asp:Label></td>
                    <td class="rozd_data ks-left ks-vikend-jednotlivy">
                        <span id="pr_sobota"></span>
                    </td>

                    <td class="DataFieldHeaderStyle ks-vikend-jednotlivy"><asp:Label runat="server" ID="Label23" Text="[%Neděle%]:" ></asp:Label>
                    </td>
                    <td class="rozd_data ks-left ks-vikend-jednotlivy">
                        <span id="pr_nedele"></span>
                    </td>

                     <td class="DataFieldHeaderStyle ks-vikend-suma"><asp:Label runat="server" ID="Label30" Text="[%Víkend%]:" ></asp:Label>
                    </td>
                    <td class="rozd_data ks-left ks-vikend-suma">
                        <span id="pr_vikendy"></span>
                    </td>
                                        
                    <td class="DataFieldHeaderStyle"><asp:Label runat="server" ID="Label24" Text="[%Svátek%]:" ></asp:Label>
                    </td>
                    <td class="rozd_data ks-left">
                        <span id="pr_svatek"></span>
                    </td>
                    <td style="width:40%"></td>
                </tr>
        </table>
        <table  style="vertical-align:top;margin-top:20px;">
            <tr>
                <td style="vertical-align:top">
                    <div id="gr_rekap" class="ksprvek" style="float:left"></div>   
                </td>

                <td  style="vertical-align:top!important">
                 <table id="rekap_prescasu">                  
                    <tr>
                        <td>                        
                                <table style="border-collapse: collapse; white-space: nowrap" class="ksprvek ks-padding">
                                     <tr  id="tr_presuvazek">
                                        <td class="rgCaption"><asp:Label runat="server" ID="Label26" Text="[%Přesúvazek%]"></asp:Label></td>
                                        <td class="DataFieldHeaderStyle"> 
                                            <%--<asp:Label runat="server" Text="[%Období%]:" ID="Label27" ></asp:Label>--%>
                                        </td>
                                        <td class="rozd_data" >
                                            <span id="pr_presuvazek"></span>
                                        </td>
                                        <%--<td colspan="7"></td>--%>
                                         <td></td>
                                         <td class="rgCaption ks-saldo-ke-dni" colspan="3" >
                                             <asp:Label runat="server" ID="Label27" Text="[%Saldo ke dni%] "></asp:Label>
                                             <span id="lab_saldo_k_datu"></span>
                                         </td>
                                         <td class="rozd_data ks-saldo-ke-dni">
                                             <span id="pr_saldo_k_datu"></span>
                                             <span id="pr_saldo_k_datu_info"></span>
                                         </td>
                                         <td colspan="2"></td>
                                    </tr>
                                     <%-- PMEJ 18.09.2025 Nařízený přesčas převedený, pro PSP --%>
                                     <tr  id="tr_prescas_rozdel_nar_prescas">
                                        <%-- Název --%>
                                        <td class="rgCaption"><asp:Label runat="server" ID="Label34" Text="[%Nařízený přesčas%]"></asp:Label></td>  
                                            <td></td>
                                        <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="[%Celkem%]:" ID="Label35" ></asp:Label></td>
                                        <td class="rozd_data">
                                            <span id="pr_narizeny_celkem"></span>
                                        </td>
                                        <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="[%Převedeno%]:" ID="Label36" ></asp:Label></td>
                                        <td class="rozd_data">                                          
                                            <span id="pr_narizeny_prevedeno"></span>
                                        </td>
    
                                        </td>
                                        <td class="DataFieldHeaderStyle"><asp:Label runat="server" ID="Label37" Text="[%K proplacení%]:" ></asp:Label>
                                        </td>
                                        <td class="rozd_data">
                                            <span id="pr_narizeny_proplac"></span>
                                        </td>

                                        <td id="pr_narizeny_rozdeleno"></td>
                                        <td class="DataFieldHeaderStyle"><asp:Label runat="server" ID="Label38" Text="[%Zbývá%]:" ></asp:Label>                                           
                                        </td>
                                        <td class="rozd_data">
                                            <span id="pr_narizeny_zbyva"></span>
                                        </td>
                                        <td>                                          
                                            <button id="butt_presc_narizeny" class="kstlacitko"><i class="fi-pencil"></i></button>
                                        </td>
                                    </tr>

                                    <tr  id="tr_prescas_rozdel_nar_prescas_rocni">
                                        <td class="rgCaption"><asp:Label runat="server" ID="Label32" Text="-[%roční%]"></asp:Label></td>                                      
                                        <td></td>

                                         <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="[%Celkem%]:" ID="Label33" ></asp:Label></td>
                                         <td class="rozd_data">
                                             <span id="pr_narizeny_rocni_celkem"></span>
                                         </td>

                                         <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="[%Převedeno%]:" ID="Label39" ></asp:Label></td>
                                         <td class="rozd_data">                                          
                                             <span id="pr_narizeny_rocni_prevedeno"></span>
                                         </td>

                                        <%--   
                                         <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="[%Limit%]:" ID="Label40" ></asp:Label></td>
                                         <td class="rozd_data">
                                             <span id="pr_r_limit"></span>
                                         </td>
                                         <td></td>
                                         <td class="DataFieldHeaderStyle"><asp:Label runat="server" ID="Label41" Text="[%Zbývá%]:" ></asp:Label>
                                         </td>
                                         <td class="rozd_data">
                                             <span id="pr_r_zbyva"></span>
                                         </td>

                                         <td id="precerp_rocni_limit">                                            
                                         </td>
                                        --%>
                                     </tr>
                                    <%-- ---------------------------------------------------------------------------------------------- --%>

                                    <tr  id="tr_prescas_rozdel">
                                        <td class="rgCaption"><asp:Label runat="server" ID="lab_prescas" Text="[%Přesčas za NV%]"></asp:Label></td>
                                        <td id="pr_nabizet_hodiny"></td>
                                        <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="[%Celkem%]:" ID="lab_celkem" ></asp:Label></td>
                                        <td class="rozd_data">
                                            <span id="pr_celkem"></span>
                                        </td>

                                        <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="[%Převedeno%]:" ID="Label2" ></asp:Label></td>
                                        <td class="rozd_data">
                                            <span id="pr_prevedeno_celkem"></span>
                                        </td>

                                        <td class="DataFieldHeaderStyle"><asp:Label runat="server" ID="lab_k_proplac" Text="[%K proplacení%]:" ></asp:Label>
                                        </td>
                                        <td class="rozd_data">
                                            <span id="pr_k_proplac"></span>
                                        </td>
                                        <td id="pr_rozdeleno"></td>
                                        <td class="DataFieldHeaderStyle"><asp:Label runat="server" ID="Label1" Text="[%Zbývá%]:" ></asp:Label>                                           
                                        </td>
                                        <td class="rozd_data">
                                            <span id="pr_k_zbyva"></span>
                                        </td>
                                        <td>                                          
                                            <button id="butt_presc" class="kstlacitko"><i class="fi-pencil"></i></button>
                                        </td>
                                    </tr>                                                          

                                    <tr  id="tr_prescas_rozdel3">
                                        <td class="rgCaption"><asp:Label runat="server" ID="Label10" Text="-[%roční%]"></asp:Label></td>                                      
                                       <td></td>

                                        <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="[%Celkem%]:" ID="Label12" ></asp:Label></td>
                                        <td class="rozd_data">
                                            <span id="pr_r_celkem"></span>
                                        </td>

                                        <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="[%Převedeno%]:" ID="Label14" ></asp:Label></td>
                                        <td class="rozd_data">                                          
                                            <span id="pr_r_prevedeno"></span>
                                        </td>

                                         <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="[%Limit%]:" ID="Label11" ></asp:Label></td>
                                        <td class="rozd_data">
                                            <span id="pr_r_limit"></span>
                                        </td>
                                        <td></td>
                                        <td class="DataFieldHeaderStyle"><asp:Label runat="server" ID="Label13" Text="[%Zbývá%]:" ></asp:Label>
                                        </td>
                                        <td class="rozd_data">
                                            <span id="pr_r_zbyva"></span>
                                        </td>

                                        <td id="precerp_rocni_limit">                                            
                                        </td>
                                        
                                    </tr>

                                     <tr  id="tr_prescas_rozdel2">
                                        <td class="rgCaption"><asp:Label runat="server" ID="Label15" Text=""></asp:Label></td>  
                                         <td></td>
                                        <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="[%Nařízený%]:" ID="Label16" ></asp:Label></td>
                              
                                        <td class="rozd_data">
                                            <span id="pr_narizeny"></span>
                                        </td>

                                       <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="" ID="Label17" ></asp:Label></td>
                                        <td class="rozd_data">

                                        </td>

                                        <td class="DataFieldHeaderStyle"><asp:Label runat="server" ID="Label18" Text="[%Limit neplac.%]:" ></asp:Label>
                                        </td>
                                        <td class="rozd_data">
                                          <span id="pr_limit_neplacenych"></span>
                                        </td>
                                          <td></td>
                                        <td class="DataFieldHeaderStyle"><asp:Label runat="server" ID="Label19" Text="[%Zbývá%]:" ></asp:Label>                                           
                                        </td>
                                        <td class="rozd_data">  
                                            <span id="pr_limit_neplacenych_zbytek"></span>
                                        </td>
                                        <td>                                             
                                        </td>
                                    </tr>
                                    <tr><td colspan="9" style="height:10px">&nbsp</td></tr>
                                    <tr id="tr_svatek_rozdel">
                                        <td class="rgCaption"><asp:Label runat="server" ID="Label3" Text="[%Práce ve svátek%]"></asp:Label></td>
                                        <td><%--<i class="fi-picking pro-rucni-editaci"></i>--%></td>
                                        <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="[%Celkem%]:" ID="Label4" ></asp:Label>                </td>
                                        <td class="rozd_data">
                                            <span id="sv_celkem"></span>
                                        </td>

                                        <td class="DataFieldHeaderStyle"> <asp:Label runat="server" Text="[%Převedeno%]:" ID="Label5" ></asp:Label></td>
                                        <td class="rozd_data">
                                            <span id="sv_prevedeno_celkem"></span>
                                        </td>

                                        <td class="DataFieldHeaderStyle"><asp:Label runat="server" ID="Label6" Text="[%K proplacení%]:" ></asp:Label>
                                        </td>
                                        <td class="rozd_data">
                                            <span id="sv_k_proplac"></span>
                                        </td>
                                         <td></td>
                                        <td class="DataFieldHeaderStyle"><asp:Label runat="server" ID="Label7" Text="[%Zbývá%]:" ></asp:Label>                                           
                                        </td>
                                        <td class="rozd_data">
                                            <span id="sv_k_zbyva"></span>
                                        </td>
                                        <td>
                                            <button id="butt_svatek" class="kstlacitko"><i class="fi-pencil"></i></button>
                                        </td>
                                    </tr>

                                </table>
                            </td>
              </tr>
         </table>                  
           </td>
                <td style="vertical-align:top">
                    <div  class="ksprvek" id="chyby"></div>
                </td>
            </tr>
        </table>

        <div id="gr_volna" class="ksprvek" style="margin-top:20px"></div>

        <table class="ksprvek" style="width:100%; margin-top:20px" id="tab_schvalovani">
             <tr>                
                <td>
                    <div id="div_schval_kontejner">
                        <table id="div_schvalovani">                                   
                            <tr>
                                <td class="rgCaption"><asp:Label runat="server" ID="lab_akt" Text="[%Aktuální stav%]"></asp:Label></td>
                                <td class="rozd_data"><span id="akt_stav_text"></span></td>
                                <td class="DataFieldHeaderStyle"><asp:Label runat="server" ID="lab_zmena_stavu" Text="[%Změna stavu%]:"></asp:Label></td>
                                <td>
                                    <div id="btn_schvalovani"></div>
                                </td>
                            </tr>
                        </table>
                    </div>
                </td>                 
            </tr>
        </table>              
    </div>
 
    <div id="div_pozn"></div>
    <div id="wnd_poznamka" class="ksprvek">  
       <%-- <div id="poznamka_wrapper" class="kspvek">--%>
            <textarea id="txt_poznamka" rows="10" cols="60" class="ks-poznamka"></textarea>
        <%--</div>--%>
         <div class="window-footer" style="margin-top: 30px;">                   
              <button class="kstlacitko" id="btnUlozitPozn"><i class="fi-disk"></i><asp:Label runat="server" ID="Label28" Text="[%Uložit%]"></asp:Label></button>
             <button class="kstlacitko" id="btnZrusitPozn"><i class="fi-ban"></i><asp:Label runat="server" ID="Label29" Text="[%Zrušit%]"></asp:Label></button>
          </div>
    </div>

     <script type="text/x-kendo-template" id="template_edit_window">      
         <div id="details-container">
            <h2>#= NDne #</h2>           
            <div id="listPruchod"></div>
            <div>
              <button id="ulozitButton">cPr("Uložit")</button>
              <button id="cancelButton">cPr("Neuložit")</button>
            </div>
        </div>       
    </script>
    <script type="text/x-kendo-template" id="templatePruchod">
        <div class="ks-edit-pruchod">                         
        </div>
    </script>
    <%--<script type="text/x-kendo-template" id="templatePoznamka">
        <div class="ks-edit-poznamku">      
           <textarea id="txt_poznamka"></textarea>
        </div>
    </script>--%>
</asp:Content>
