﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="PorizKalendar.aspx.cs" Inherits="KSProgram.Dochazka.PorizKalendar" %>

<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register TagPrefix="wc" Namespace="KSProgram.WebControls" Assembly="WebControls" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxPanel runat="server" ID="RadPanel1">
        <telerik:RadCalendar ID="RadCalendar1" runat="server" AutoPostBack="true" Width="900"
            EnableMonthYearFastNavigation="true" DayNameFormat="Short" EnableMultiSelect="false"
            ShowRowHeaders="false" ShowOtherMonthsDays="false" OnDefaultViewChanged="RadCalendar1_DefaultViewChanged"
            OnSelectionChanged="RadCalendar1_SelectionChanged" OnDayRender="RadCalendar1_DayRender">
            <DayStyle VerticalAlign="Top" BorderColor="#CDCDCD" />
            <WeekendDayStyle BackColor="White" BorderColor="var(--kscolor1)" VerticalAlign="Top" />
            <DayOverStyle VerticalAlign="Top" CssClass="porizcal_day_over" />
            <TitleStyle CssClass="BackColor" ForeColor="White" />
            <OtherMonthDayStyle ForeColor="LightGray" BorderColor="#CDCDCD" />
            <DayStyle BorderColor="#CDCDCD" />
            <CalendarTableStyle BorderColor="#CDCDCD" />
            <DisabledDayStyle BorderColor="#CDCDCD" />
            <HeaderStyle BackColor="LightGray" />
            <SelectedDayStyle VerticalAlign="Top" CssClass="porizcal_day_over" ForeColor="Black" />
        </telerik:RadCalendar>
        <%--<telerik:RadAjaxLoadingPanel runat="server" ID="ralpConfiguration">
    </telerik:RadAjaxLoadingPanel>   --%>
        <telerik:RadAjaxPanel runat="server" ID="rapConfiguration">
            <telerik:RadWindow ID="modalPopup" runat="server" Width="1000px" Height="360px" Modal="true"
                EnableViewState="True" OnClientClose="refrCal" Behaviors="Close,Move,Maximize"
                DestroyOnClose="true">
                <ContentTemplate>
                    <telerik:RadAjaxPanel ID="pan_grid" runat="server">
                        <wc:TRadGrid ID="RadGrid2" GridLines="None" runat="server" AllowAutomaticDeletes="True"
                            AllowAutomaticInserts="True" PageSize="10" AllowAutomaticUpdates="True" AllowPaging="False"
                            OnNeedDataSource="RadGrid2_NeedDataSource1" OnUpdateCommand="RadGrid2_UpdateCommand"
                            OnInsertCommand="RadGrid2_InsertCommand" OnDeleteCommand="RadGrid2_DeleteCommand"
                            AutoGenerateColumns="False" OnItemDataBound="RadGrid2_ItemDataBound" OnItemCommand="RadGrid2_ItemCommand" >
                            <MasterTableView CommandItemDisplay="Top" DataKeyNames="id,kod,prac_str,cas_doba"
                                HorizontalAlign="NotSet" AutoGenerateColumns="False" EditMode="EditForms">
                                <Columns>
                                    <telerik:GridButtonColumn Text="[%Editace%]" CommandName="Edit" ButtonType="ImageButton" />
                                    <telerik:GridDropDownColumn DataField="kod" HeaderText="[%Kód%]" UniqueName="dd_kod" 
                                        ListTextField="cely_nazev" ListValueField="kod" DataSourceID="dsDdlKody" DropDownControlType="RadComboBox">
                                        <ColumnValidationSettings>
                                            <RequiredFieldValidator ErrorMessage="*" ></RequiredFieldValidator>
                                        </ColumnValidationSettings>
                                    </telerik:GridDropDownColumn>
                                    <telerik:GridTemplateColumn HeaderText="[%Doba%]" DataField="cas_doba" UniqueName="cas_doba"
                                        HeaderStyle-Width="70">
                                        <ItemTemplate>
                                            <%# Eval("cas_doba", "{0:HH:mm}") %>
                                        </ItemTemplate>
                                        <EditItemTemplate>
                                            <telerik:RadTimePicker runat="server" ID="dp_cas_doba" Width="70" TimeView-TimeFormat="HH:mm"
                                                DateInput-DateFormat="HH:mm" DateInput-DisplayDateFormat="HH:mm" DbSelectedDate='<%# Bind("cas_doba") %>'>
                                            </telerik:RadTimePicker>
                                            <asp:RequiredFieldValidator runat="server" ID="rfv_dp_cas_doba" ControlToValidate="dp_cas_doba" ErrorMessage="*" ></asp:RequiredFieldValidator>
                                        </EditItemTemplate>
                                    </telerik:GridTemplateColumn>
                                    <telerik:GridDropDownColumn DataField="prac_str" HeaderText="[%Středisko%]" UniqueName="dd_stred"
                                        ListTextField="cely_nazev" ListValueField="str" DataSourceID="dsStred" DropDownControlType="RadComboBox">
                                    </telerik:GridDropDownColumn>
                                    <telerik:GridTemplateColumn HeaderText="[%Země%]" DataField="c_pole2" UniqueName="zem">
                                        <ItemTemplate>
                                            <%# Eval("c_pole2") %>
                                        </ItemTemplate>
                                        <EditItemTemplate>
                                            <asp:Label ID="lblZeme" runat="server" Text='<%# Eval("c_pole2") %>' Visible="false"></asp:Label>
                                            <telerik:RadDropDownList runat="server" ID="dd_zeme" DataTextField="nazev" DataValueField="kod_zeme"
                                                AutoPostBack="true" OnSelectedIndexChanged="dd_zeme_SelectedIndexChanged">
                                            </telerik:RadDropDownList>
                                            <asp:RequiredFieldValidator runat="server" ID="val_zeme" ControlToValidate="dd_zeme"></asp:RequiredFieldValidator>
                                        </EditItemTemplate>
                                    </telerik:GridTemplateColumn>
                                    <telerik:GridTemplateColumn HeaderText="[%Činnost%]" DataField="c_pole1" UniqueName="cinnost">
                                        <ItemTemplate>
                                            <%# Eval("c_pole1") %>
                                        </ItemTemplate>
                                        <EditItemTemplate>
                                            <asp:Label ID="lblCinnost" runat="server" Text='<%# Eval("c_pole1") %>' Visible="false"></asp:Label>
                                            <telerik:RadDropDownList runat="server" ID="dd_cinnosti" DataTextField="vyznam" DataValueField="cislo">
                                            </telerik:RadDropDownList>
                                            <asp:RequiredFieldValidator runat="server" ID="val_cinnosti" ControlToValidate="dd_cinnosti"></asp:RequiredFieldValidator>
                                        </EditItemTemplate>
                                    </telerik:GridTemplateColumn>
                                    <telerik:GridButtonColumn Text="[%Smazat%]" CommandName="Delete" ButtonType="ImageButton" />
                                </Columns>
                                <EditFormSettings>
                                    <EditColumn ButtonType="ImageButton" />
                                </EditFormSettings>
                            </MasterTableView>
                        </wc:TRadGrid>
                    </telerik:RadAjaxPanel>
                </ContentTemplate>
            </telerik:RadWindow>
        </telerik:RadAjaxPanel>
        <%--<asp:HiddenField ID="dataForSQL" runat="server" />--%>
        <telerik:RadCodeBlock runat="server" ID="rdbScripts">
            <script type="text/javascript">
                var cas_od;
                var cas_do;
                var cas_doba;

                function SetEditorValue(sender, args) {
                    var container = args.get_container();
                    if (args.get_columnUniqueName() === "kod") {
                        dropdown = $telerik.findControl(container, "dd_kod");
                    }
                    else if (args.get_columnUniqueName() == "cas_od") {
                        cas_od = $telerik.findControl(container, "cas_od");
                    }
                    else if (args.get_columnUniqueName() == "cas_do") {
                        cas_do = $telerik.findControl(container, "cas_do");
                    }
                    else if (args.get_columnUniqueName() == "cas_doba") {
                        cas_doba = $telerik.findControl(container, "cas_doba");
                        var dd = $telerik.findControl(container, "dd_kod");
                        if (dd != null) {
                            var kod = dd.value;
                            if ((kod != null) && (kod != "") && (kod != undefined))
                                prestavProKod(kod);
                        }
                    }

                    args.set_cancel(false);
                }

                function ValueChanged(sender, args) {
                    if (args.get_columnUniqueName() === "kod") {
                        var container = args.get_container();
                        var cod = $telerik.findElement(container, "dp_cas_od");
                        alert(cod);
                    }
                }

                function GetCellValue(sender, args) {
                    if (args.get_columnUniqueName() === "kod") {
                        args.set_cancel(true);
                        var container = args.get_container();
                        var cod = $telerik.findElement(container, "dp_cas_od");
                        var cdo = $telerik.findElement(container, "cas_do");
                        //args.set_value(new Person(firstName, lastName));
                    }
                }

                function GetEditorValue(sender, args) {
                    if (args.get_columnUniqueName() === "kod") {
                        //alert("geteditor");
                        var container = args.get_container();
                        var pom = $telerik.findControl(container, "dd_kod");
                        var x = args.get_value();                       
                    }
                }



                function zpusob_zadavani(index, co) {
                    var res = false;
                    var p = arr_kody[index];
                    if (p == "h") {
                        if ((co == "cas_od") || (co == "cas_do")) {
                            return false;
                        } else if (co == "cas_doba") {
                            return true;
                        }
                    } else if (p == "i") {
                        if ((co == "cas_od") || (co == "cas_do")) {
                            return true;
                        } else if (co == "cas_doba") {
                            return false;
                        }
                    } else if ((p == "c") || (p == "p")) {
                        return false;
                    }
                    return res;
                }

                function prestavProKod(kod) {
                    if (cas_od == null) return;
                    var e = zpusob_zadavani(kod, "cas_od");
                    cas_od.set_enabled(e);
                    cas_do.set_enabled(e);

                    if (e == false) {
                        // cas_od.get_dateInput().set_value("");
                        // cas_do.get_dateInput().set_value("");
                    }
                    e = zpusob_zadavani(kod, "cas_doba");
                    cas_doba.set_enabled(e);
                    if (e == false) {
                        //cas_doba.get_dateInput().set_value("");
                    }
                }

                function dd_kod_ItemSelected(sender, eventArgs) {
                    var val = eventArgs.get_item().get_value();
                    if ((val != undefined) && (val != "") && (val != null))
                        prestavProKod(val);
                }

                function refrCal(sender, eventAgrs) {

                    __doPostBack("<%= RadCalendar1.ClientID %>", "");

                    var el = $find("<%= RadCalendar1.ClientID %>");
                    var selectedDates = el.get_selectedDates();
                    e.unselectDates(selectedDates);

                }

            </script>
        </telerik:RadCodeBlock>
        <asp:ObjectDataSource ID="dsKody" runat="server" SelectMethod="KodZkratkaNazevKalendar"
            TypeName="KSProgram.Ciselniky.CisDchKody" OldValuesParameterFormatString="original_{0}">
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="dsDen" runat="server" TypeName="KSProgram.Dochazka.PorizeniDen"
            SelectMethod="NacistDen" UpdateMethod="UpdateDen" DeleteMethod="DeleteZaznam"
            OnDeleted="dsDen_Deleted" OnUpdated="dsDen_Updated" OnUpdating="dsDen_Updating">
            <SelectParameters>
                <asp:Parameter Name="os_cislo" Type="Decimal" />
                <asp:Parameter Name="cislo_pom" Type="Int16" />
                <asp:Parameter Name="den" DbType="DateTime" />
            </SelectParameters>
            <UpdateParameters>
                <asp:Parameter Name="os_cislo" Type="Decimal" />
                <asp:Parameter Name="cislo_pom" Type="Int16" />
                <asp:Parameter Name="den" DbType="DateTime" />
                <asp:Parameter Name="kod" DbType="Int32" />
                <asp:Parameter Name="hod_od" DbType="Int32" />
                <asp:Parameter Name="min_od" DbType="Int32" />
                <asp:Parameter Name="hod_do" DbType="Int32" />
                <asp:Parameter Name="min_do" DbType="Int32" />
                <asp:Parameter Name="hod_doba" Type="Int32" />
                <asp:Parameter Name="min_doba" Type="Int32" />
                <asp:Parameter Name="id" DbType="String" />
                <asp:Parameter Name="original_id" DbType="String" />
                <asp:Parameter Name="c_pole1" DbType="String" />
                <asp:Parameter Name="sazba" DbType="Decimal" />
                <asp:Parameter Name="castka" DbType="Decimal" />
            </UpdateParameters>
            <DeleteParameters>
                <asp:Parameter Name="os_cislo" Type="Decimal" />
                <asp:Parameter Name="cislo_pom" Type="Int16" />
                <asp:Parameter Name="den" DbType="DateTime" />
                <asp:Parameter Name="id" DbType="String" />
                <asp:Parameter Name="original_id" DbType="String" />
            </DeleteParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="dsStred" runat="server" SelectMethod="VsechnaStrediska"
            TypeName="KSProgram.Ciselniky.CisStredisko" OldValuesParameterFormatString="original_{0}"
            CacheDuration="60" EnableCaching="true" CacheKeyDependency='<%# KSProgram.Globals.User %>'
            CacheExpirationPolicy="Absolute">
            <SelectParameters>
                <asp:ControlParameter ControlID="RadCalendar1" Name="datumOd" PropertyName="SelectedDate"
                    Type="DateTime" DefaultValue="" />
                <asp:ControlParameter ControlID="RadCalendar1" Name="datumDo" PropertyName="SelectedDate"
                    Type="DateTime" />
                <asp:Parameter Name="ab_prazdny" DefaultValue="true" Type="Boolean" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource runat="server" ID="dsDdlKody" TypeName="KSProgram.Ciselniky.CisDchKody"
            SelectMethod="KodZkratkaNazev" EnableCaching="true" CacheKeyDependency='<%# KSProgram.Globals.User %>'
            CacheDuration="30" CacheExpirationPolicy="Absolute"></asp:ObjectDataSource>
        <asp:ObjectDataSource runat="server" ID="dsZeme" TypeName="KSProgram.Ciselniky.CisCinnosti"
            SelectMethod="ZemeSCinnostmi" EnableCaching="true" CacheKeyDependency='<%# KSProgram.Globals.User %>'
            CacheDuration="30" CacheExpirationPolicy="Absolute"></asp:ObjectDataSource>
        <asp:ObjectDataSource runat="server" ID="dsCinnost" TypeName="KSProgram.Ciselniky.CisCinnosti"
            SelectMethod="CinnostiProZemi" EnableCaching="true" CacheKeyDependency='<%# KSProgram.Globals.User %>'
            CacheDuration="30" CacheExpirationPolicy="Absolute">
            <SelectParameters>
                <asp:Parameter Name="zeme" DbType="String" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <%--
              <table style="vertical-align:top;"><tr><td>

        <wc:TRadGrid runat="server" ID="TRadGrid_rekap" OnNeedDataSource="TRadGrid_rekap_needDataSource" >
        <MasterTableView>
            <Columns>
                <telerik:GridBoundColumn DataField="kod" HeaderText="Kód"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="nazev" HeaderText="Název"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="dny" HeaderText="Dny"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="hodiny" HeaderText="Hodiny"></telerik:GridBoundColumn>

            </Columns>
        </MasterTableView>
        </wc:TRadGrid>

        <asp:ObjectDataSource ID="dsRekapitulace" runat="server" OldValuesParameterFormatString="original_{0}" SelectMethod="Retrieve" TypeName="KSProgram.Dochazka.SesumujMesic" >
            <SelectParameters>
                <asp:Parameter Name="os_cislo" Type="Decimal" />
                <asp:Parameter Name="obdobi" Type="DateTime" />
            </SelectParameters>
        </asp:ObjectDataSource>
        </td><td>
            <table>
                <tr>
                    <td>
                        <wc:TLinkButton ID="TLinkButton1" runat="server" Width="200px" Text="[%Generovat podle kalendáře%]"
                            OnCommand="TLinkButton1_Command" SkinID="button"></wc:TLinkButton>
                    </td>
                </tr>             
                <tr>
                <td>
                    <asp:Panel runat="server" ID="PanelZmenaStavu">
                        <table style="border-collapse: collapse">
                            <tr>
                                <td>
                                    <asp:ObjectDataSource ID="dsStavyEdit" runat="server" OldValuesParameterFormatString="original_{0}"
                                        SelectMethod="StavyPozadavkuProTyp" TypeName="KSProgram.Pozadavky.WorkflowProces">
                                        <SelectParameters>
                                            <asp:Parameter Name="id_poz" Type="Int32" />
                                            <asp:Parameter Name="emptyRow" Type="Boolean" DefaultValue="false" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <asp:DropDownList runat="server" ID="ddl_zmena_stavu" DataTextField="popis" DataValueField="hodnota">
                                    </asp:DropDownList>
                                </td>
                                <td style="padding-left: 10px">
                                    <wc:TLinkButton runat="server" ID="lb_zmena_stavu" Text="[%Změna stavu%]" SkinID="button"
                                        OnCommand="lb_zmena_stavu_Command"></wc:TLinkButton>
                                </td>
                            </tr>
                        </table>
                    </asp:Panel>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    </table>
        --%>
    </telerik:RadAjaxPanel>
</asp:Content>
