﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Dochazka_DochRekapitulace" CodeBehind="DochRekapitulace.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="WebControlsAlone" Namespace="KSProgram.WebControlsAlone" TagPrefix="wca" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">

    <telerik:RadCodeBlock ID="RadScriptBlockrekapitulace" runat="server">
        <script type="text/javascript" id="telerikClientEvents1">
            var updateStateOnShow2 = true;
            var saveStateTimeOut2;
            function getStateJsonData(hf_id) {
                var stateStr = $get(hf_id).value;
                if (stateStr)
                    try {
                        return $telerik.$.parseJSON(stateStr);
                    }
                    catch (err) {
                        return null;
                    }
                else
                    return null;
            }
            function setSelJsonData(hf_id, obj) {
                var hf_sel = $get(hf_id);
                if (window.JSON && window.JSON.stringify) //in case the browser supports JSON natively (modern browsers, IE8 and above)
                {
                    hf_sel.value = JSON.stringify(obj);
                }
                else //the browser does not support JSON natively, create the string manually or use an external library
                {
                    var ser = "[";
                    for (var i in obj)
                        ser += obj[i].toString() + ",";
                    ser = ser.substring(0, ser.length - 1);
                    ser += "]";
                    hf_sel.value = ser;
                }
            }
            function TRadGrid_sestava_OnColumnShown(sender, args) {
                updateStatePoz();
            }

            function TRadGrid_sestava_OnColumnHidden(sender, args) {
                updateStatePoz();
            }

            function updateStatePoz() {
                if (updateStateOnShow2) {
                    var container = $get("<%=HF_grid_state.ClientID %>")
                var radGrid = $find('<%= TRadGrid_sestava.ClientID %>');
                    var table = radGrid.get_masterTableView();
                    var wndStateColls =
                    {
                        os_cislo: table.getColumnByUniqueName("os_cislo").get_visible(),
                        cislo_pom: table.getColumnByUniqueName("cislo_pom").get_visible(),
                        prijmeni: table.getColumnByUniqueName("prijmeni").get_visible(),
                        jmeno: table.getColumnByUniqueName("jmeno").get_visible(),
                        kmen_str: table.getColumnByUniqueName("kmen_str").get_visible(),
                        prac_str: table.getColumnByUniqueName("prac_str").get_visible(),
                        druh_pom_j: table.getColumnByUniqueName("druh_pom_j").get_visible(),
                        fond: table.getColumnByUniqueName("fond").get_visible()
                    }

                    var columns = table.get_columns();
                    var poradi = [];
                    for (var i = 0; i < columns.length; i++) {
                        poradi.push(columns[i].get_uniqueName());
                    }
                    var wndState =
                    {
                        pageSize: table.get_pageSize(),
                        collvisible: wndStateColls
                    }
                    if (window.JSON && window.JSON.stringify) //in case the browser supports JSON natively (modern browsers, IE8 and above)
                    {
                        container.value = JSON.stringify(wndState);
                        if (saveStateTimeOut2)
                            clearTimeout(saveStateTimeOut2);
                        saveStateTimeOut2 = setTimeout(function () { PageMethods.SaveStateSeznam(container.value); }, 500);
                    }

                }
            }

            function TRadGrid_sestava_OnGridCreated(sender, args) {
                var data = getStateJsonData("<%=HF_grid_state.ClientID %>");
                // _setFilters(sender, stateFilter);
                columnsVisibility(sender);
                //if (data && data.collorder)
                //    columnsOrder(sender, data.collorder);
            }


            function columnsVisibility(grid) {
                var tableView = grid.get_masterTableView();
                var data = getStateJsonData("<%=HF_grid_state.ClientID %>");
                updateStateOnShow2 = false;

                if (tableView) {
                    if (data) {
                        if (data.pageSize) {
                            if (tableView.get_pageSize() != data.pageSize)
                                tableView.set_pageSize(data.pageSize);
                        }
                        else {
                            tableView.set_pageSize(20);
                        }
                    }
                    else {
                        tableView.set_pageSize(20);
                    }
                }
                if (data) {
                    var cols = tableView.get_columns();
                    for (var key in data.collvisible) {
                        if (data.collvisible.hasOwnProperty(key)) {
                            var colum = tableView.getColumnByUniqueName(key);
                            if (colum) {
                                var index = getCollIndex(key, cols);
                                if (colum.get_visible() != data.collvisible[key]) {
                                    if (data.collvisible[key]) {
                                        tableView.showColumn(index);
                                    }
                                    else {
                                        tableView.hideColumn(index);
                                    }
                                }
                            }
                        }
                    }
                }
                updateStateOnShow2 = true;
            }
        </script>
    </telerik:RadCodeBlock>

    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRadGrid_sestava">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid_sestava" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <%--<asp:Label ID="Label1" runat="server" Text="[%Rekapitulace docházky%]" CssClass="nadpis1"></asp:Label>--%>


    <%--<table>
        <tr>--%>
    <%-- <td >
                            <kspwc:TRadObdobiInterval ID="TRadObdobi" runat="server" AutoPostBack="false" Vertical="true" TextOd="[%Období od%]:" TextDo="[%Období do%]:"></kspwc:TRadObdobiInterval>
                        </td>--%>
    <%--<td>--%>
    <wc:StrSkupDiv runat="server" ID="StrSkupDiv"></wc:StrSkupDiv>
    <%--</td>--%>
    <%--<td>
                            <kspwc:TRadButton ID="trb_prac" runat="server" Text="[%Prac. stř.%]" ToggleType="Radio" ButtonType="ToggleButton" GroupName="stredisko" Checked="true" Value="prac_str" AutoPostBack="false" UseSaveSetting="true"></kspwc:TRadButton>
                            <br />
                            <kspwc:TRadButton ID="trb_kmen" runat="server" Text="[%Kmen. stř.%]" ToggleType="Radio" ButtonType="ToggleButton" GroupName="stredisko" Checked="false" Value="kmen_str" AutoPostBack="false" UseSaveSetting="true"></kspwc:TRadButton>         
                        </td>--%>
    <%--<td>--%>
    <%--<kspwc:TRadButton runat="server" ID="Tcheck_prac_list" Text="[%Včetně přesčasů z prac. listu%]" ToggleType="CheckBox" ButtonType="StandardButton" AutoPostBack="false"></kspwc:TRadButton>--%>
    <%--</td>--%>
    <%--<td style="padding-left:5px" >
                            <kspwc:TRadButton runat="server" ID="trbutton" OnClick="trbutton_Click" Text="[%Vytvořit%]" ></kspwc:TRadButton>
                        </td>--%>
    <%--</tr>
    </table>--%>
    <br />
    <asp:HiddenField runat="server" ID="HF_grid_state" />
    <kspwc:TRadGrid EnableHeaderContextMenu="false" ID="TRadGrid_sestava" runat="server" OnDataBinding="TRadGrid_sestava_DataBinding" OnNeedDataSource="TRadGrid_sestava_NeedDataSource" AutoFilterWidth="true"
        ShowGroupPanel="false" AllowPaging="false" ShowFooter="true" OnItemDataBound="TRadGrid_sestava_ItemDataBound" ExportSettings-Csv-EncloseDataWithQuotes="false" OnItemCreated="TRadGrid_sestava_ItemCreated"
        AllowSorting="true" AutoGenerateColumns="false" ExportSettings-ExportOnlyData="true" ExportSettings-Csv-ColumnDelimiter="Semicolon" MasterTableView-Caption="[%Rekapitulace docházky%]"
        AutoFilterControlWidth="false">
        <ClientSettings AllowDragToGroup="false">
            <%--<ClientEvents OnColumnShown="TRadGrid_sestava_OnColumnShown" OnColumnHidden="TRadGrid_sestava_OnColumnHidden" OnGridCreated="TRadGrid_sestava_OnGridCreated" /> --%>
        </ClientSettings>
        <GroupingSettings ShowUnGroupButton="false"></GroupingSettings>
        <PagerStyle Mode="NextPrevNumericAndAdvanced"></PagerStyle>
        <ExportSettings HideStructureColumns="true" OpenInNewWindow="true">
        </ExportSettings>
        <MasterTableView CommandItemDisplay="Top">
            <HeaderStyle VerticalAlign="Middle" HorizontalAlign="Center" />
            <Columns>
                <telerik:GridBoundColumn DataField="os_cislo" HeaderText="[%Os. číslo%]" SortExpression="os_cislo" UniqueName="os_cislo">
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cislo_pom" HeaderText="[%Č.P.%]" SortExpression="cislo_pom" UniqueName="cislo_pom">
                    <ItemStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo"></kspwc:GridFotoZamColumn>
                <telerik:GridBoundColumn DataField="prijmeni" HeaderText="[%Příjmení%]" SortExpression="prijmeni" UniqueName="prijmeni">
                    <ItemStyle Width="90px" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" SortExpression="jmeno" UniqueName="jmeno">
                    <ItemStyle Width="90px" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="kmen_str" HeaderText="[%Kmen. stř.%]" SortExpression="kmen_str" UniqueName="kmen_str">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="prac_str" HeaderText="[%Prac. stř.%]" SortExpression="prac_str" UniqueName="prac_str">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="druh_pom_j" HeaderText="[%Druh poměru%]" SortExpression="druh_pom_j" UniqueName="druh_pom_j">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="vypl_str" HeaderText="[%Výplatní místo%]" SortExpression="vypl_str" UniqueName="vypl_str">
                </telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="fond" HeaderText="[%Fond%]" SortExpression="fond" DataType="System.Decimal" Aggregate="Sum" DataFormatString="{0:N2}" UniqueName="fond">
                    <HeaderStyle HorizontalAlign="Center" Width="60px" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="pr0" UniqueName="pr0" HeaderText="" DataFormatString="{0:N2}" SortExpression="pr0" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast0" HeaderText="" UniqueName="cast0" DataFormatString="{0:N2}" SortExpression="cast0" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr1" HeaderText="" UniqueName="pr1" DataFormatString="{0:N2}" SortExpression="pr1" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast1" HeaderText="" UniqueName="cast1" DataFormatString="{0:N2}" SortExpression="cast1" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr2" HeaderText="" UniqueName="pr2" DataFormatString="{0:N2}" SortExpression="pr2" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast2" HeaderText="" UniqueName="cast2" DataFormatString="{0:N2}" SortExpression="cast2" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr3" HeaderText="" UniqueName="pr3" DataFormatString="{0:N2}" SortExpression="pr3" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast3" HeaderText="" UniqueName="cast3" DataFormatString="{0:N2}" SortExpression="cast3" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr4" HeaderText="" UniqueName="pr4" DataFormatString="{0:N2}" SortExpression="pr4" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast4" HeaderText="" UniqueName="cast4" DataFormatString="{0:N2}" SortExpression="cast4" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr5" HeaderText="" UniqueName="pr5" DataFormatString="{0:N2}" SortExpression="pr5" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast5" HeaderText="" UniqueName="cast5" DataFormatString="{0:N2}" SortExpression="cast5" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr6" HeaderText="" UniqueName="pr6" DataFormatString="{0:N2}" SortExpression="pr6" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast6" HeaderText="" UniqueName="cast6" DataFormatString="{0:N2}" SortExpression="cast6" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr7" HeaderText="" UniqueName="pr7" DataFormatString="{0:N2}" SortExpression="pr7" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast7" HeaderText="" UniqueName="cast7" DataFormatString="{0:N2}" SortExpression="cast7" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr8" HeaderText="" UniqueName="pr8" DataFormatString="{0:N2}" SortExpression="pr8" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast8" HeaderText="" UniqueName="cast8" DataFormatString="{0:N2}" SortExpression="cast8" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr9" HeaderText="" UniqueName="pr9" DataFormatString="{0:N2}" SortExpression="pr9" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast9" HeaderText="" UniqueName="cast9" DataFormatString="{0:N2}" SortExpression="cast9" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr10" HeaderText="" UniqueName="pr10" DataFormatString="{0:N2}" SortExpression="pr10" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast10" HeaderText="" UniqueName="cast10" DataFormatString="{0:N2}" SortExpression="cast10" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr11" HeaderText="" UniqueName="pr11" DataFormatString="{0:N2}" SortExpression="pr11" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast11" HeaderText="" UniqueName="cast11" DataFormatString="{0:N2}" SortExpression="cast11" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr12" HeaderText="" UniqueName="pr12" DataFormatString="{0:N2}" SortExpression="pr12" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast12" HeaderText="" UniqueName="cast12" DataFormatString="{0:N2}" SortExpression="cast12" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr13" HeaderText="" UniqueName="pr13" DataFormatString="{0:N2}" SortExpression="pr13" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast13" HeaderText="" UniqueName="cast13" DataFormatString="{0:N2}" SortExpression="cast13" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr14" HeaderText="" UniqueName="pr14" DataFormatString="{0:N2}" SortExpression="pr14" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast14" HeaderText="" UniqueName="cast14" DataFormatString="{0:N2}" SortExpression="cast14" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr15" HeaderText="" UniqueName="pr15" DataFormatString="{0:N2}" SortExpression="pr15" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast15" HeaderText="" UniqueName="cast15" DataFormatString="{0:N2}" SortExpression="cast15" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr16" HeaderText="" UniqueName="pr16" DataFormatString="{0:N2}" SortExpression="pr16" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast16" HeaderText="" UniqueName="cast16" DataFormatString="{0:N2}" SortExpression="cast16" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr17" HeaderText="" UniqueName="pr17" DataFormatString="{0:N2}" SortExpression="pr17" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast17" HeaderText="" UniqueName="cast17" DataFormatString="{0:N2}" SortExpression="cast17" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr18" HeaderText="" UniqueName="pr18" DataFormatString="{0:N2}" SortExpression="pr18" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast18" HeaderText="" UniqueName="cast18" DataFormatString="{0:N2}" SortExpression="cast18" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr19" HeaderText="" UniqueName="pr19" DataFormatString="{0:N2}" SortExpression="pr19" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast19" HeaderText="" UniqueName="cast19" DataFormatString="{0:N2}" SortExpression="cast19" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr20" HeaderText="" UniqueName="pr20" DataFormatString="{0:N2}" SortExpression="pr20" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast20" HeaderText="" UniqueName="cast20" DataFormatString="{0:N2}" SortExpression="cast20" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr21" HeaderText="" UniqueName="pr21" DataFormatString="{0:N2}" SortExpression="pr21" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast21" HeaderText="" UniqueName="cast21" DataFormatString="{0:N2}" SortExpression="cast21" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr22" HeaderText="" UniqueName="pr22" DataFormatString="{0:N2}" SortExpression="pr22" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast22" HeaderText="" UniqueName="cast22" DataFormatString="{0:N2}" SortExpression="cast22" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr23" HeaderText="" UniqueName="pr23" DataFormatString="{0:N2}" SortExpression="pr23" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast23" HeaderText="" UniqueName="cast23" DataFormatString="{0:N2}" SortExpression="cast23" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr24" HeaderText="" UniqueName="pr24" DataFormatString="{0:N2}" SortExpression="pr24" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast24" HeaderText="" UniqueName="cast24" DataFormatString="{0:N2}" SortExpression="cast24" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr25" HeaderText="" UniqueName="pr25" DataFormatString="{0:N2}" SortExpression="pr25" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast25" HeaderText="" UniqueName="cast25" DataFormatString="{0:N2}" SortExpression="cast25" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr26" HeaderText="" UniqueName="pr26" DataFormatString="{0:N2}" SortExpression="pr26" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast26" HeaderText="" UniqueName="cast26" DataFormatString="{0:N2}" SortExpression="cast26" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr27" HeaderText="" UniqueName="pr27" DataFormatString="{0:N2}" SortExpression="pr27" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast27" HeaderText="" UniqueName="cast27" DataFormatString="{0:N2}" SortExpression="cast27" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr28" HeaderText="" UniqueName="pr28" DataFormatString="{0:N2}" SortExpression="pr28" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast28" HeaderText="" UniqueName="cast28" DataFormatString="{0:N2}" SortExpression="cast28" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr29" HeaderText="" UniqueName="pr29" DataFormatString="{0:N2}" SortExpression="pr29" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast29" HeaderText="" UniqueName="cast29" DataFormatString="{0:N2}" SortExpression="cast29" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr30" HeaderText="" UniqueName="pr30" DataFormatString="{0:N2}" SortExpression="pr30" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast30" HeaderText="" UniqueName="cast30" DataFormatString="{0:N2}" SortExpression="cast30" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr31" HeaderText="" UniqueName="pr31" DataFormatString="{0:N2}" SortExpression="pr31" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast31" HeaderText="" UniqueName="cast31" DataFormatString="{0:N2}" SortExpression="cast31" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr32" HeaderText="" UniqueName="pr32" DataFormatString="{0:N2}" SortExpression="pr32" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast32" HeaderText="" UniqueName="cast32" DataFormatString="{0:N2}" SortExpression="cast32" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr33" HeaderText="" UniqueName="pr33" DataFormatString="{0:N2}" SortExpression="pr33" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast33" HeaderText="" UniqueName="cast33" DataFormatString="{0:N2}" SortExpression="cast33" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr34" HeaderText="" UniqueName="pr34" DataFormatString="{0:N2}" SortExpression="pr34" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast34" HeaderText="" UniqueName="cast34" DataFormatString="{0:N2}" SortExpression="cast34" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr35" HeaderText="" UniqueName="pr35" DataFormatString="{0:N2}" SortExpression="pr35" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast35" HeaderText="" UniqueName="cast35" DataFormatString="{0:N2}" SortExpression="cast35" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr36" HeaderText="" UniqueName="pr36" DataFormatString="{0:N2}" SortExpression="pr36" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast36" HeaderText="" UniqueName="cast36" DataFormatString="{0:N2}" SortExpression="cast36" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr37" HeaderText="" UniqueName="pr37" DataFormatString="{0:N2}" SortExpression="pr37" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast37" HeaderText="" UniqueName="cast37" DataFormatString="{0:N2}" SortExpression="cast37" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr38" HeaderText="" UniqueName="pr38" DataFormatString="{0:N2}" SortExpression="pr38" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast38" HeaderText="" UniqueName="cast38" DataFormatString="{0:N2}" SortExpression="cast38" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr39" HeaderText="" UniqueName="pr39" DataFormatString="{0:N2}" SortExpression="pr39" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast39" HeaderText="" UniqueName="cast39" DataFormatString="{0:N2}" SortExpression="cast39" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr40" HeaderText="" UniqueName="pr40" DataFormatString="{0:N2}" SortExpression="pr40" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast40" HeaderText="" UniqueName="cast40" DataFormatString="{0:N2}" SortExpression="cast40" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr41" HeaderText="" UniqueName="pr41" DataFormatString="{0:N2}" SortExpression="pr41" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast41" HeaderText="" UniqueName="cast41" DataFormatString="{0:N2}" SortExpression="cast41" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr42" HeaderText="" UniqueName="pr42" DataFormatString="{0:N2}" SortExpression="pr42" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast42" HeaderText="" UniqueName="cast42" DataFormatString="{0:N2}" SortExpression="cast42" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr43" HeaderText="" UniqueName="pr43" DataFormatString="{0:N2}" SortExpression="pr43" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast43" HeaderText="" UniqueName="cast43" DataFormatString="{0:N2}" SortExpression="cast43" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr44" HeaderText="" UniqueName="pr44" DataFormatString="{0:N2}" SortExpression="pr44" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast44" HeaderText="" UniqueName="cast44" DataFormatString="{0:N2}" SortExpression="cast44" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr45" HeaderText="" UniqueName="pr45" DataFormatString="{0:N2}" SortExpression="pr45" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast45" HeaderText="" UniqueName="cast45" DataFormatString="{0:N2}" SortExpression="cast45" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr46" HeaderText="" UniqueName="pr46" DataFormatString="{0:N2}" SortExpression="pr46" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast46" HeaderText="" UniqueName="cast46" DataFormatString="{0:N2}" SortExpression="cast46" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr47" HeaderText="" UniqueName="pr47" DataFormatString="{0:N2}" SortExpression="pr47" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast47" HeaderText="" UniqueName="cast47" DataFormatString="{0:N2}" SortExpression="cast47" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr48" HeaderText="" UniqueName="pr48" DataFormatString="{0:N2}" SortExpression="pr48" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast48" HeaderText="" UniqueName="cast48" DataFormatString="{0:N2}" SortExpression="cast48" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="pr49" HeaderText="" UniqueName="pr49" DataFormatString="{0:N2}" SortExpression="pr49" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cast49" HeaderText="" UniqueName="cast49" DataFormatString="{0:N2}" SortExpression="cast49" Aggregate="Sum" Visible="false">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="ostatni" HeaderText="[%Ostatní%]" DataFormatString="{0:N2}" SortExpression="ostatni" Aggregate="Sum">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="prevedeno" HeaderText="[%Převedeno%]" DataFormatString="{0:N2}" SortExpression="prevedeno">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="rozdil" HeaderText="[%Rozdíl%]" DataFormatString="{0:N2}" SortExpression="rozdil">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <%--<telerik:GridBoundColumn DataField="prescas" HeaderText="[%Přesčas%]" DataFormatString="{0:N2}" SortExpression="prescas" Aggregate="Sum">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>--%>
                <telerik:GridBoundColumn DataField="stav_text" HeaderText="[%Stav%]" SortExpression="stav_text">
                    <HeaderStyle HorizontalAlign="Center" />
                    <FooterStyle HorizontalAlign="Left" />
                </telerik:GridBoundColumn>

                <telerik:GridBoundColumn DataField="pocet_strav" UniqueName="pocet_strav" HeaderText="[%Stravenky%]" DataFormatString="{0:N0}" SortExpression="pocet_strav" Aggregate="Sum">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>

                <telerik:GridBoundColumn DataField="praclist" UniqueName="praclist" HeaderText="[%Prac. list př.%]" DataFormatString="{0:N2}" SortExpression="praclist">
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Right" Width="60px" />
                    <FooterStyle HorizontalAlign="Right" />
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="prescasy_pozn" UniqueName="prescasy_pozn" HeaderText="[%Přesčas - poznámka%]" SortExpression="prescasy_pozn">
                    <HeaderStyle HorizontalAlign="Left" />
                    <ItemStyle HorizontalAlign="Left" />
                    <FooterStyle HorizontalAlign="Left" />
                </telerik:GridBoundColumn>
                <telerik:GridRowIndicatorColumn></telerik:GridRowIndicatorColumn>
            </Columns>
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" DateControl="TRadObdobiInterval" StrediskaComboBox-Visible="true">
                    <%--ShowExportToExcelXlsxItem="true" PH 28.1.2019 kvůli chybě teleriku tento export padal, až to opraví tak se to zase zpřístupní--%>
                    <ExportButton ID="ExportButton1" runat="server" ShowExportToExcelHtmlItem="true"
                        ShowExportToExcelXlsxItem="true" ShowExportToExcelMLItem="false" ShowExportToWordItem="false" ShowExportToWordDocxItem="false" />
                    <ContentTemplate>
                        <div class="gridCommandButton">
                            <kspwc:TRadButton runat="server" ID="Tcheck_prac_list" Text="[%Včetně přesčasů z prac. listu%]" ToggleType="CheckBox" ButtonType="StandardButton" OnDataBinding="Tcheck_prac_list_DataBinding" AutoPostBack="false"></kspwc:TRadButton>
                        </div>
                    </ContentTemplate>
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
        </MasterTableView>
    </kspwc:TRadGrid>

</asp:Content>
