﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOpomucky.ascx.cs" Inherits="KSPortal.Controls.ZadostOpomucky" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="~/Manazer/Pomucky/PomuckyVydejControl.ascx" TagPrefix="uc" TagName="PomuckyVydej" %>

<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekzavazek" OnInserted="ObjectDataSource1_Inserted"
    OnInserting="ObjectDataSource1_Inserting"
    OnUpdated="ObjectDataSource1_Updated"
    OnUpdating="ObjectDataSource1_Updating"
    UpdateMethod="Update" InsertMethod="Insert">
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="koho_osc" Type="Decimal" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="poznamka" Type="String" />
        <asp:Parameter Name="typ_operace" Type="String" />
    </UpdateParameters>
    <SelectParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter Name="id_poz" Type="Int32" Direction="InputOutput" />
        <asp:Parameter Name="koho_osc" Type="Decimal" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="poznamka" Type="String" />
        <asp:Parameter Name="typ_operace" Type="String" />
        <asp:Parameter Name="adresat" Type="Decimal" />
        <asp:Parameter Name="novy_stav" Type="String" />
        <asp:Parameter Name="duvod" Type="String" />
    </InsertParameters>
</asp:ObjectDataSource>
<asp:FormView ID="FormView1" runat="server" OnItemInserted="FormView1_ItemInserted" CssClass="nocss ksprvek"
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound" DataKeyNames="os_cislo">
    <%--PH 6.6.2018 fiktivní css aby tam telerik necpal rfdTable--%>
    <ItemTemplate>

        <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
            <asp:TableCell runat="server" ColumnSpan="5" ID="TableCellItem14x" SkinID="TitleRowStyle">
                <asp:Label ID="Label7x" runat="server" Text="[%Žádost o výdej/vrácení pomůcek%]"></asp:Label>
            </asp:TableCell>
        </asp:TableHeaderRow>
        <asp:TableRow runat="server" ID="TableRow1">
            <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell ColumnSpan="4" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
            </asp:TableCell>
        </asp:TableRow>

        <asp:TableRow runat="server" ID="TableRow2">
            <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                <asp:Label ID="Label1" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zaměstnanec%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell ColumnSpan="4" runat="server" SkinID="DataFieldStyle" ID="TableCell6">
                <asp:Label ID="Label2" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "koho_osc")))) %>'></asp:Label>
            </asp:TableCell>
        </asp:TableRow>

         <asp:TableRow runat="server" ID="TableRow5">
             <asp:TableCell runat="server" ID="TableCell11" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                 <asp:Label ID="Label7" runat="server" Text="[%Typ%]:"></asp:Label>
             </asp:TableCell>
             <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell12" SkinID="DataFieldStyle">
                 <asp:Label ID="Label12" runat="server" Text='<%# Bind("typ_operace_text") %>' Width="200px"></asp:Label>
             </asp:TableCell>
         </asp:TableRow>

        <asp:TableRow runat="server" ID="TableRowItem3">
            <asp:TableCell runat="server" ID="TableCellItem7" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                <asp:Label ID="Label3x" runat="server" Text="[%Požadované pomůcky%],[%Poznámka%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem8" SkinID="DataFieldStyle">
                <asp:Label ID="LabelDuvodx" runat="server" Text='<%# Bind("poznamka") %>' Width="200px"></asp:Label>
            </asp:TableCell>
        </asp:TableRow>

        <asp:TableRow runat="server" ID="TableRowItem4">
            <asp:TableCell runat="server" ID="TableCellItem9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                <asp:Label ID="Label4x" runat="server" Text="[%Vyřešit do%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem10" SkinID="DataFieldStyle">
                <asp:Label ID="LabelDatvyrizeni" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>'></asp:Label>
            </asp:TableCell>
        </asp:TableRow>
        <asp:TableRow runat="server" ID="TableRow6">
            <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                <asp:Label ID="Label8" runat="server" Text="[%Aktuální stav a datum změny stavu%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell4" SkinID="DataFieldStyle">
                <asp:Label ID="Label11" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"stav") %>'></asp:Label>
            </asp:TableCell>
            <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                <asp:Label ID="Label10" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyriz_datum"), "d") %>'></asp:Label>
            </asp:TableCell>
        </asp:TableRow>
    </ItemTemplate>
    <EditItemTemplate>
        <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
            <asp:TableCell runat="server" ColumnSpan="5" ID="TableCellItem14x" SkinID="TitleRowStyle">
                <asp:Label ID="Label7x" runat="server" Text="[%Žádost o výdej/vrácení pomůcek%]"></asp:Label>
            </asp:TableCell>
        </asp:TableHeaderRow>

        <asp:TableRow runat="server" ID="TableRow3">
            <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                <asp:Label ID="Label5" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell ColumnSpan="4" runat="server" SkinID="DataFieldStyle" ID="TableCell8">
                <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
            </asp:TableCell>
        </asp:TableRow>

        <asp:TableRow runat="server" ID="TableRow1">
            <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zaměstnanec%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell ColumnSpan="4" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                <telerik:RadComboBox ID="RadComboBox_zam"
                    runat="server" Height="600" Width="300" EmptyMessage="[%Příjmení%],[%Os.číslo%], [%Název prac. místa%]"
                    EnableLoadOnDemand="true" ShowMoreResultsBox="true"
                    EnableVirtualScrolling="true" AutoPostBack="true">

                    <HeaderTemplate>
                        <asp:Label runat="server" ID="lab_header" Text="[%Zaměstnanci%]" CssClass="h2"></asp:Label>
                    </HeaderTemplate>
                    <ClientItemTemplate>
    <div class="imageWrap">
        <img src='#=Attributes.ImageUrl#' alt=" #= Text # " />
    </div>
    <div>
        <ul class="personDetails">
            <li class="name"><span> #= Text # </span></li>                                    
            <li class="misto"><span> #= Attributes.NazPracmist # </span></li>
        </ul>
    </div>
                    </ClientItemTemplate>
                    <WebServiceSettings Method="GetZamestnance" Path="../Pis/SysSchema.aspx" />
                </telerik:RadComboBox>
                <kspwc:TRequiredValidator ID="RequiredFieldValidator1" runat="server"
                    ControlToValidate="RadComboBox_zam" ErrorMessage="[%Zaměstnanec je povinný údaj.%]"
                    ForeColor="Red" Display="Dynamic"></kspwc:TRequiredValidator>
            </asp:TableCell>
        </asp:TableRow>

        <asp:TableRow runat="server" ID="TableRow7">
            <asp:TableCell runat="server" ID="TableCell13" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                <asp:Label ID="Label13" runat="server" Text="[%Typ%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell runat="server" ID="TableCell14" ColumnSpan="3" SkinID="DataFieldStyle">
                <telerik:RadDropDownList  ID="ddlb_typ_edit" runat="server" SelectedValue ='<%# Bind("typ_operace") %>'  Width="300">
                    <Items>                       
                        <telerik:DropDownListItem Text="[%Nástup%]" Value="n" />
                        <telerik:DropDownListItem Text="[%Ostatní%]" Value="o" />
                         <telerik:DropDownListItem Text="[%Výstup%]" Value="v" />
                    </Items>
                </telerik:RadDropDownList>
                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator1" ControlToValidate="ddlb_typ_edit"></kspwc:TRequiredValidator>
            </asp:TableCell>
        </asp:TableRow>

        <asp:TableRow runat="server" ID="TableRowEdit3">
            <asp:TableCell runat="server" ID="TableCellEdit8" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                <asp:Label ID="Label3x" runat="server" Text="[%Požadované pomůcky%],[%Poznámka%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell runat="server" ID="TableCellEdit9" ColumnSpan="3" SkinID="DataFieldStyle">
                <telerik:RadTextBox ID="txt_poznamka_edit" runat="server" Text='<%# Bind("poznamka") %>' MaxLength="999"
                    TextMode="MultiLine" Width="284px" Height="40" Resize="Both">
                </telerik:RadTextBox><br />
               <%-- <kspwc:TRequiredValidator runat="server" ID="val1" ControlToValidate="txt_poznamka_edit"></kspwc:TRequiredValidator>--%>
            </asp:TableCell>
        </asp:TableRow>

        <asp:TableRow runat="server" ID="TableRowEdit4">
            <asp:TableCell runat="server" ID="TableCellEdit10" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell runat="server" ID="TableCellEdit11" ColumnSpan="3" SkinID="DataFieldStyle">
                <kspwc:TRadDatePicker ID="TextBoxDatVyrizeniEdit" DbSelectedDate='<%# Bind("vyridit_do") %>'
                    runat="server">
                </kspwc:TRadDatePicker>
            </asp:TableCell>
        </asp:TableRow>
    </EditItemTemplate>
    <InsertItemTemplate>
        <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
            <asp:TableCell runat="server" ColumnSpan="5" ID="TableCellItem14x" SkinID="TitleRowStyle">
                <asp:Label ID="Label7x" runat="server" Text="[%Žádost o výdej/vrácení pomůcek%]"></asp:Label>
            </asp:TableCell>
        </asp:TableHeaderRow>

        <asp:TableRow runat="server" ID="TableRow4">
            <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                <asp:Label ID="Label6" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell ColumnSpan="4" runat="server" SkinID="DataFieldStyle" ID="TableCell10">
                <asp:Label ID="Lab_zadatel" runat="server"></asp:Label>
            </asp:TableCell>
        </asp:TableRow>

        <asp:TableRow runat="server" ID="TableRow1">
            <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zaměstnanec%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell ColumnSpan="4" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                <telerik:RadComboBox ID="RadComboBox_zam"
                    runat="server" Height="600" Width="300" EmptyMessage="[%Příjmení%],[%Os.číslo%], [%Název prac. místa%]"
                    EnableLoadOnDemand="true" ShowMoreResultsBox="true"
                    EnableVirtualScrolling="true" AutoPostBack="true" OnSelectedIndexChanged="RadComboBox_zam_SelectedIndexChanged">

                    <HeaderTemplate>
                        <asp:Label runat="server" ID="lab_header" Text="[%Zaměstnanci%]" CssClass="h2"></asp:Label>
                    </HeaderTemplate>
                    <ClientItemTemplate>
     <div class="imageWrap">
         <img src='#=Attributes.ImageUrl#' alt=" #= Text # " />
     </div>
     <div>
         <ul class="personDetails">
             <li class="name"><span> #= Text # </span></li>                                    
             <li class="misto"><span> #= Attributes.NazPracmist # </span></li>
         </ul>
     </div>
                    </ClientItemTemplate>
                    <WebServiceSettings Method="GetZamestnance" Path="../Pis/SysSchema.aspx" />
                </telerik:RadComboBox>
                <kspwc:TRequiredValidator ID="RequiredFieldValidator1" runat="server"
                    ControlToValidate="RadComboBox_zam" ErrorMessage="[%Zaměstnanec je povinný údaj.%]" Display="Dynamic"></kspwc:TRequiredValidator>
            </asp:TableCell>
        </asp:TableRow>

         <asp:TableRow runat="server" ID="TableRow7">
             <asp:TableCell runat="server" ID="TableCell13" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                 <asp:Label ID="Label13" runat="server" Text="[%Typ%]:"></asp:Label>
             </asp:TableCell>
             <asp:TableCell runat="server" ID="TableCell14" ColumnSpan="3" SkinID="DataFieldStyle">
                 <telerik:RadDropDownList  ID="ddlb_typ_insert" runat="server" SelectedValue ='<%# Bind("typ_operace") %>' Width="300">
                     <Items>
                          <telerik:DropDownListItem Text="" Value="" />
                         <telerik:DropDownListItem Text="[%Nástup%]" Value="n" />
                         <telerik:DropDownListItem Text="[%Ostatní%]" Value="o" />
                          <telerik:DropDownListItem Text="[%Výstup%]" Value="v" />
                     </Items>
                 </telerik:RadDropDownList>
                 <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator1" ControlToValidate="ddlb_typ_insert"></kspwc:TRequiredValidator>
             </asp:TableCell>
         </asp:TableRow>

        <asp:TableRow runat="server" ID="TableRowInsert4">
            <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                <asp:Label ID="Label3" runat="server" Text="[%Požadované pomůcky%],[%Poznámka%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell runat="server" ID="TCInsert8" ColumnSpan="3" SkinID="DataFieldStyle">
                <telerik:RadTextBox ID="txt_poznamka_insert" runat="server" Text='<%# Bind("poznamka") %>' MaxLength="999"
                    TextMode="MultiLine" Width="400px" Height="80" Resize="Both">
                </telerik:RadTextBox>
               <%-- <kspwc:TRequiredValidator runat="server" ID="val2" ControlToValidate="txt_poznamka_insert"></kspwc:TRequiredValidator>--%>
            </asp:TableCell>
        </asp:TableRow>
        <asp:TableRow runat="server" ID="TableRowInsert5">
            <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="3" SkinID="DataFieldStyle">
                <kspwc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniInsert" DbSelectedDate='<%# DataBinder.Eval(Container.DataItem,"vyridit_do") %>'>
                </kspwc:TRadDatePicker>
            </asp:TableCell>
        </asp:TableRow>
    </InsertItemTemplate>
</asp:FormView>

<br />
<uc:PomuckyVydej ID="PomuckyVydej1" runat="server" />
