﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="Controls_ZadostOdovol"
    CodeBehind="ZadostOdovol.ascx.cs" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<style type="text/css">
    .cisPol
    {
        text-align:right;
    }
    .cisPolSum
    {
        text-align:right;
        font-weight:bold;
    } 
    .info
    {
       font-style:italic;
       white-space:normal;
    }

</style>

<telerik:RadFormDecorator ID="QsfFromDecorator" runat="server" DecoratedControls="CheckBoxes,RadioButtons,Select,Textarea,Textbox"
    EnableRoundedCorners="false" DecorationZoneID="FormView1" />
<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekdovol" InsertMethod="Insert"
    UpdateMethod="Update" OnUpdated="ObjectDataSource1_Updated" OnUpdating="ObjectDataSource1_Updating"
    OnInserting="ObjectDataSource1_Inserting" OnInserted="ObjectDataSource1_Inserted">
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="pul_dne" Type="String" />
        <asp:Parameter Name="zbytek_hodin" Type="Decimal" />
        <asp:Parameter Name="datum_od" Type="DateTime" />
        <asp:Parameter Name="datum_do" Type="DateTime" />
        <asp:Parameter Name="poznamka" Type="String" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
    </UpdateParameters>
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" DefaultValue="" />
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" Direction="InputOutput" />
        <asp:Parameter Name="cislo_pom" Type="Int16" />
        <asp:Parameter Name="pul_dne" Type="String" />
        <asp:Parameter Name="zbytek_hodin" Type="Decimal" />
        <asp:Parameter Name="datum_od" Type="DateTime" />
        <asp:Parameter Name="datum_do" Type="DateTime" />
        <asp:Parameter Name="poznamka" Type="String" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="adresat" Type="Decimal" />
        <asp:Parameter Name="novy_stav" Type="String" />
        <asp:Parameter Name="duvod" Type="String" />
    </InsertParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource runat="server" ID="ds_pomery" 
    OldValuesParameterFormatString="original_{0}" SelectMethod="GetPomery" 
    TypeName="KSProgram.Funkce.Prac_pom" >
    <SelectParameters>
        <asp:Parameter Name="co" Type="String" DefaultValue="p" />
        <asp:Parameter DefaultValue="0" Name="os_cislo" Type="Decimal" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:FormView ID="FormView1" runat="server" OnItemInserted="FormView1_ItemInserted"  CssClass="nocss ksprvek"  
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound"  DataKeyNames="os_cislo"><%--PH 6.6.2018 fiktivní css aby tam telerik necpal rfdTable--%>
    <ItemTemplate>
        <asp:Table runat="server" ID="TableItem" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Požadavek na dovolenou%]"></asp:Label><asp:Label CssClass="storno" runat="server" Text='<%#  DataBinder.Eval(Container.DataItem, "storno") %>' ID="lab_storno" ></asp:Label>
                    <kspwc:TRadButton runat="server" ID="rb_storno" Text="[%Stornovat%]" AutoPostBack="true" Visible='<%#  DataBinder.Eval(Container.DataItem, "stornovatelny") %>' CommandArgument='<%#  DataBinder.Eval(Container.DataItem, "storno_url") %>' OnCommand="rb_storno_Command"  CssClass="button-v-headeru-poz" >
                        <Icon PrimaryIconCssClass="fi fi-time-delete"></Icon>
                    </kspwc:TRadButton>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="row_pomer">
                <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label12" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Druh poměru%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell6">
                    <%--<asp:Label ID="Label13" runat="server" Text='<%# Bind("cislo_pom") %>'></asp:Label>--%>
                    <asp:Label ID="Label13" runat="server" Text='<%# Bind("pomer_text") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>


             <asp:TableRow runat="server" ID="TableRow_header">
                <asp:TableCell runat="server" ID="TableCell29" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">                    
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server"  ID="hodiny1" SkinID="DataFieldHeaderStyle"  CssClass="cisPol">
                    <asp:Label ID="label21" runat="server" Text="[%Hodiny%]"></asp:Label>
                </asp:TableCell>

                   <asp:TableCell ColumnSpan="1" runat="server"  ID="dny1" SkinID="DataFieldHeaderStyle"  CssClass="cisPol">
                    <asp:Label ID="label23" runat="server" Text="[%Dny%]"></asp:Label>
                </asp:TableCell>

                <asp:TableCell ColumnSpan="1" runat="server"  ID="TableCell_datum1" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="label28" runat="server" Text="[%Datum%]" ></asp:Label>
                </asp:TableCell>
            </asp:TableRow>


            <asp:TableRow runat="server" ID="TableRow_zust">
                <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label_zustatek_ke_dni" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zůstatek dovolené / ke dni%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="hodiny2"  CssClass="cisPol">
                    <asp:Label ID="label_zustatek" runat="server" Text='<%# Eval("dov_zustatek_hodiny", "{0:N2}") %>'></asp:Label>
                </asp:TableCell>

                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="dny2"  CssClass="cisPol">
                    <asp:Label ID="label24" runat="server" Text='<%# Eval("dov_zustatek_dny", "{0:N1}") %>'></asp:Label>
                </asp:TableCell>

                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum2">
                    <asp:Label ID="label15" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"dov_obdobi"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow_zazadano">
                <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label_zazadano_popisek" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zažádáno po tomto datu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="hodiny3"  CssClass="cisPol">
                    <asp:Label ID="label_zazadano" runat="server" Text='<%# Eval("zazadano_hodin", "{0:N2}") %>'></asp:Label>
                </asp:TableCell>

                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="dny3"  CssClass="cisPol">
                    <asp:Label ID="label26" runat="server" Text='<%# Eval("zazadano_dnu", "{0:N1}") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum3">                   
                </asp:TableCell>

            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow_pozadavky_zust">
                <asp:TableCell runat="server" ID="TableCell12" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label17" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zůstatek%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="hodiny4"  CssClass="cisPolSum">
                    <asp:Label ID="label18" runat="server" Text='<%# Eval("zustatek_celkovy_hodiny", "{0:N2}") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="dny4"  CssClass="cisPolSum">
                    <asp:Label ID="label20" runat="server" Text='<%# Eval("zustatek_celkovy_dny", "{0:N1}") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum4">                   
                </asp:TableCell>
            </asp:TableRow>

           <%-- <asp:TableRow runat="server" ID="TableRow5">
                <asp:TableCell runat="server" ID="TableCell14" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label19" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zůstatek dnů%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell15">
                    <asp:Label ID="label20" runat="server" Text='<%# Eval("zustatek_celkovy_dny", "{0:N1}") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>--%>

             <asp:TableRow runat="server" ID="TableRowItem2">
                <asp:TableCell runat="server" ID="TableCellItem3" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label1x" SkinID="DataFieldHeaderStyle" runat="server" Text="[%Od%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellItem4" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelOd" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"datum_od"), "d") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellItem5" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label2x" runat="server" Text="[%Do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellItem6" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDo" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"datum_do"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowItem1" Visible='<%# _pulDenVisible(DataBinder.Eval(Container.DataItem, "pul_dne")) %>'>
                <asp:TableCell runat="server" ID="TableCellItem1" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <%--' "[%Půl dne%]:"--%>
                    <%--Text='<%# Eval("popisek_pul_dne")%>'--%>
                    <asp:Label ID="lab_pul_dne" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Půl dne%]:" ></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCellItem2">
                    <asp:Label ID="Label5" runat="server" Text='<%# _textPulDen(DataBinder.Eval(Container.DataItem,"pul_dne")) %>' ></asp:Label>
                   <%-- <asp:Label ID="Label6" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"zbytek_hodin") %>' Visible='<%# Convert.ToBoolean(DataBinder.Eval(Container.DataItem, "zbytek_hodin_visible")) %>'></asp:Label>--%>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="row_check_zbytekInsert" Visible='<%# (DataBinder.Eval(Container.DataItem, "zbytek_hodin")!=DBNull.Value) %>'>
                <asp:TableCell runat="server" ID="TableCell13" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <%--' "[%Půl dne%]:"--%>
                    <%--Text='<%# Eval("popisek_pul_dne")%>'--%>
                    <asp:Label ID="Label29" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zbytek%]:" ></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell15">
                   <%-- <asp:Label ID="Label30" runat="server" Text='<%# (Convert.ToBoolean(DataBinder.Eval(Container.DataItem, "pul_dne"))==true?"[%ano%]":"[%ne%]") %>' Visible='<%# (!Convert.ToBoolean(DataBinder.Eval(Container.DataItem, "zbytek_hodin_visible"))) %>'></asp:Label>--%>
                    <asp:Label ID="Label31" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"zbytek_hodin") %>' ></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

           
            <asp:TableRow runat="server" ID="TableRowItem3">
                <asp:TableCell runat="server" ID="TableCellItem7" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label3x" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem8" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDuvodx" runat="server" Text='<%# Bind("poznamka") %>'
                        Width="200px"></asp:Label>
                    <%--<telerik:RadTextBox ID="LabelDuvodx" runat="server" Text='<%# Bind("duvod") %>' Height="20px" 
                        Width="200px" TextMode="MultiLine" ReadOnly="true" MaxLength="999"></telerik:RadTextBox>--%>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowItem4">
                <asp:TableCell runat="server" ID="TableCellItem9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label4x" runat="server" Text="[%Vyřešit do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem10" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDatvyrizeni" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow6">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label8" runat="server" Text="[%Aktuální stav a datum změny stavu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell4" SkinID="DataFieldStyle">
                    <asp:Label ID="Label11" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"stav") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                    <asp:Label ID="Label10" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyriz_datum"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <%--<asp:TableRow runat="server" ID="TableRowItem5">
                <asp:TableCell ColumnSpan="4" runat="server" ID="TableCellItem11">   
                </asp:TableCell>
            </asp:TableRow>--%>
        </asp:Table>
    </ItemTemplate>
    <EditItemTemplate>
        <asp:Table runat="server" ID="TableEdit" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowEidt">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Úprava požadavku na dovolenou%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRowEdit1a">
                <asp:TableCell runat="server" ID="TableCell1aedit" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8aedit" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="row_pomer">
                <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label12" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Druh poměru%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell6">
                    <%--<asp:Label ID="Label13" runat="server" Text='<%# Bind("cislo_pom") %>'></asp:Label>--%>
                    <asp:Label ID="Label13" runat="server" Text='<%# Bind("pomer_text") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>


             <asp:TableRow runat="server" ID="TableRow_header">
                <asp:TableCell runat="server" ID="TableCell29" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">                    
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server"  ID="hodiny1" SkinID="DataFieldHeaderStyle"   CssClass="cisPol">
                    <asp:Label ID="label21" runat="server" Text="[%Hodiny%]"></asp:Label>
                </asp:TableCell>

                   <asp:TableCell ColumnSpan="1" runat="server"  ID="dny1" SkinID="DataFieldHeaderStyle"  CssClass="cisPol">
                    <asp:Label ID="label23" runat="server" Text="[%Dny%]"></asp:Label>
                </asp:TableCell>

                <asp:TableCell ColumnSpan="1" runat="server"  ID="TableCell_datum1" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="label28" runat="server" Text="[%Datum%]" ></asp:Label>
                </asp:TableCell>
            </asp:TableRow>


              <asp:TableRow runat="server" ID="TableRow_zust">
                <asp:TableCell runat="server" ID="label_zust" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label_zustatek_ke_dni" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zůstatek dovolené / ke dni%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="hodiny2"  CssClass="cisPol">
                    <asp:Label ID="label_zustatek" runat="server" Text='<%# Eval("dov_zustatek_hodiny", "{0:N2}") %>'></asp:Label>
                </asp:TableCell>

                   <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="dny2"  CssClass="cisPol">
                    <asp:Label ID="label25" runat="server" Text='<%# Eval("dov_zustatek_dny", "{0:N1}") %>'></asp:Label>
                </asp:TableCell>

                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum2">
                    <asp:Label ID="label15" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"dov_obdobi"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow_zazadano">
                <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label_zazadano_popisek" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zažádáno po tomto datu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="hodiny3"  CssClass="cisPol">
                    <asp:Label ID="label_zazadano_hodin" runat="server" Text='<%# Eval("zazadano_hodin", "{0:N2}") %>'></asp:Label>
                </asp:TableCell>
                 <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="dny3"  CssClass="cisPol">
                    <asp:Label ID="label27" runat="server" Text='<%# Eval("zazadano_dnu", "{0:N1}") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum3">                   
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow_pozadavky_zust">
                <asp:TableCell runat="server" ID="TableCell12" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label17" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zůstatek%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="hodiny4"  CssClass="cisPolSum">
                    <asp:Label ID="label18" runat="server" Text='<%# Eval("zustatek_celkovy_hodiny", "{0:N2}") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="dny4"  CssClass="cisPolSum">
                    <asp:Label ID="label22" runat="server" Text='<%# Eval("zustatek_celkovy_dny", "{0:N1}") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum4">                   
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowInfo">
                <asp:TableCell runat="server" ID="TableCellInfo" ColumnSpan="4">
                    <div>
                     <span class="info">[%Volba pro půlden dovolené, případně zbytek dovolené se nabízí až po zadání datumu od%].</span>
                    </div>
                    <div>
                        <span class="info">[%O půlden dovolené lze žádat jen na jeden den%].</span>
                    </div>
                </asp:TableCell>
            </asp:TableRow>

          <asp:TableRow runat="server" ID="TableRowEdit2">
                <asp:TableCell runat="server" ID="TableCellEdit4" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label1x" runat="server" Text="[%Od%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit5" SkinID="DataFieldStyle">
                   
                    <kspwc:TRadDatePicker ID="TextBoxOdEdit" runat="server" DbSelectedDate='<%# Bind("datum_od") %>' AutoPostBack="true" OnSelectedDateChanged="TextBoxOdEdit_SelectedDateChanged">
                    </kspwc:TRadDatePicker>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit6" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label2x" runat="server" Text="[%Do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit7" SkinID="DataFieldStyle">                    
                    <kspwc:TRadDatePicker ID="TextBoxDoEdit" runat="server" DbSelectedDate='<%# Bind("datum_do") %>' Enabled='<%# Convert.ToBoolean(DataBinder.Eval(Container.DataItem, "dat_do_enabled")) %>' > 
                    </kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>
            
            <asp:TableRow runat="server" ID="TableRowEdit1"  Visible='<%# (Convert.ToBoolean(DataBinder.Eval(Container.DataItem, "pul_den_visible"))) %>'>
                <asp:TableCell runat="server" ID="TableCellEdit2" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                     <%--Text='<%# Eval("popisek_pul_dne")%>'--%>
                    <asp:Label ID="lab_pul_dne" runat="server" Text="[%Půl dne%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit3" ColumnSpan="3" SkinID="DataFieldStyle">
                   <%-- Visible='<%# (Convert.ToBoolean(DataBinder.Eval(Container.DataItem, "pul_den_visible"))) %>'--%>
                   <%-- Checked='<%# Bind("pul_dne") %>'--%>
                    <asp:CheckBox ID="CheckBoxPuldenEdit" runat="server" Checked='<%# Bind("pul_dne_checked") %>' AutoPostBack="True" OnCheckedChanged="BoxPulden_CheckedChanged"></asp:CheckBox>                    
                   <span>
                     <asp:RadioButtonList runat="server" ID="rb_pul_den_Edit" >
                        <Items>
                            <asp:ListItem Text="1.[%polovina směny%]" Value="a" />
                            <asp:ListItem Text="2.[%polovina směny%]" Value="d" />
                        </Items>
                    </asp:RadioButtonList>
                       <kspwc:TRequiredValidator runat="server" id="req_pul_den_Edit" Enabled="false" ControlToValidate="rb_pul_den_Edit" Text="[%Povinné pole%]" ErrorMessage="[%Povinné pole%]" ></kspwc:TRequiredValidator>                        
                        </span>
                 
                </asp:TableCell>                
            </asp:TableRow>

             <asp:TableRow runat="server" ID="row_check_zbytekEdit" Visible='<%# Convert.ToDecimal(DataBinder.Eval(Container.DataItem,"zbytek_k_cerpani"))>0%>'>
                <asp:TableCell runat="server" ID="TableCell8" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label19" runat="server" Text="[%Zbytek hodin%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell10" ColumnSpan="3" SkinID="DataFieldStyle">
                     <asp:Label runat="server" ID="lab_zbytek" Text='<%# DataBinder.Eval(Container.DataItem,"zbytek_k_cerpani") %>'></asp:Label>  
                     <asp:CheckBox ID="check_zbytekEdit" runat="server" 
                        AutoPostBack="True" OnCheckedChanged="check_zbytek_CheckedChanged"></asp:CheckBox>
                       <%-- Checked='<%# (Convert.ToBoolean(DataBinder.Eval(Container.DataItem,"zbytek_hodin")!=null)) %>'--%>
                   <%-- <asp:Label runat="server" ID="pom" Text='<%# (Convert.ToBoolean(DataBinder.Eval(Container.DataItem,"zbytek_hodin")!=null)) %>'></asp:Label>--%>
                </asp:TableCell>
            </asp:TableRow>

           
            <asp:TableRow runat="server" ID="TableRowEdit3">
                <asp:TableCell runat="server" ID="TableCellEdit8" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3x" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit9" ColumnSpan="3" SkinID="DataFieldStyle">
                    <telerik:RadTextBox ID="LabelDuvodx" runat="server" Text='<%# Bind("poznamka") %>' MaxLength="999"
                        TextMode="MultiLine" Width="284px" Height="40"  Resize="Both"></telerik:RadTextBox><br />
                    <kspwc:TextValidator runat="server" ID="val1" ControlToValidate="LabelDuvodx"></kspwc:TextValidator>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowEdit4">
                <asp:TableCell runat="server" ID="TableCellEdit10" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit11" ColumnSpan="3" SkinID="DataFieldStyle">
                    <kspwc:TRadDatePicker ID="TextBoxDatVyrizeniEdit" DbSelectedDate='<%# Bind("vyridit_do") %>'
                        runat="server">
                    </kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>
           <%-- <asp:TableRow runat="server" ID="TableRowEdit5">
                <asp:TableCell runat="server" ID="TableCellEdit12" ColumnSpan="4">
                </asp:TableCell>
            </asp:TableRow>--%>
        </asp:Table>
    </EditItemTemplate>
    <InsertItemTemplate>
        <asp:Table runat="server" ID="TableInsert" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowInsert">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Nový požadavek na dovolenou%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label_zam" runat="server" Text=""></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

             <asp:TableRow runat="server" ID="row_pomer">
                <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label12" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Číslo poměru%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell6">                    
                    <asp:DropDownList runat="server" ID="ddl_pomery" DataTextField="cislo_druh_nazev" AutoPostBack="true" DataValueField="cislo_pom" DataSourceID="ds_pomery" OnSelectedIndexChanged="ddl_pomery_SelectedIndexChanged" ></asp:DropDownList>
                </asp:TableCell>
            </asp:TableRow>


             <asp:TableRow runat="server" ID="TableRow_header">
                <asp:TableCell runat="server" ID="TableCell29" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">                    
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server"  ID="hodiny1" SkinID="DataFieldHeaderStyle"  CssClass="cisPol">
                    <asp:Label ID="label21" runat="server" Text="[%Hodiny%]"></asp:Label>
                </asp:TableCell>

                   <asp:TableCell ColumnSpan="1" runat="server"  ID="dny1" SkinID="DataFieldHeaderStyle"  CssClass="cisPol">
                    <asp:Label ID="label23" runat="server" Text="[%Dny%]"></asp:Label>
                </asp:TableCell>

                <asp:TableCell ColumnSpan="1" runat="server"  ID="TableCell_datum1" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="label28" runat="server" Text="[%Datum%]" ></asp:Label>
                </asp:TableCell>
            </asp:TableRow>


              <asp:TableRow runat="server" ID="TableRow_zust">
                <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label_zustatek_ke_dni" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zůstatek dovolené / ke dni%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="hodiny2" CssClass="cisPol">
                    <asp:Label ID="label_zustatek_hodiny" runat="server" ></asp:Label>
                </asp:TableCell>

                   <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="dny2" CssClass="cisPol">
                    <asp:Label ID="label_zustatek_dny" runat="server" ></asp:Label>
                </asp:TableCell>

                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum2">
                    <asp:Label ID="label_obdobi" runat="server" ></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow_zazadano">
                <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label_zazadano_popisek" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zažádáno po tomto datu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="hodiny3"  CssClass="cisPol">
                    <asp:Label ID="label_zazadano_hodin" runat="server" ></asp:Label>
                </asp:TableCell>
                 <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="dny3"  CssClass="cisPol">
                    <asp:Label ID="label_zazadano_dnu" runat="server" ></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum3">                   
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow_pozadavky_zust">
                <asp:TableCell runat="server" ID="TableCell12" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label17" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zůstatek%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="hodiny4"  CssClass="cisPolSum">
                    <asp:Label ID="label_zustatek_celkovy_hodin" runat="server"></asp:Label>
                </asp:TableCell>
                 <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="dny4"  CssClass="cisPolSum">
                    <asp:Label ID="label_zustatek_celkovy_dnu" runat="server"></asp:Label>
                </asp:TableCell>
                 <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum4">                    
                </asp:TableCell>
            </asp:TableRow>

             <asp:TableRow runat="server" ID="TableRowInfo">
                <asp:TableCell runat="server" ID="TableCellInfo" ColumnSpan="4">
                    <div>
                     <span class="info">[%Volba pro půlden dovolené, případně zbytek dovolené se nabízí až po zadání datumu od%].</span>
                    </div>
                    <div>
                        <span class="info">[%O půlden dovolené lze žádat jen na jeden den%].</span>
                    </div>
                </asp:TableCell>
            </asp:TableRow>

             <asp:TableRow runat="server" ID="TableRowInsert3">
                <asp:TableCell runat="server" ID="TCInsert3" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label1" runat="server" Text="[%Od%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert4" SkinID="DataFieldStyle">
                  
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxOdInsert" AutoPostBack="true" DbSelectedDate='<%# DataBinder.Eval(Container.DataItem,"datum_od") %>' OnSelectedDateChanged="TextBoxOdEdit_SelectedDateChanged">
                    </kspwc:TRadDatePicker>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert5" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label2" runat="server" Text="[%Do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert6" SkinID="DataFieldStyle">
                   
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDoInsert" DbSelectedDate='<%# DataBinder.Eval(Container.DataItem,"datum_od") %>'>
                    </kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="row_pul_denInsert" Visible="false">
                <asp:TableCell runat="server" ID="TCInsert1" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="lab_pul_dne" runat="server" Text="[%Půl dne%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert2" ColumnSpan="3" SkinID="DataFieldStyle">
                    <span>
                   <asp:CheckBox ID="CheckBoxPuldenInsert" runat="server" Checked='<%# Bind("pul_dne") %>'
                        AutoPostBack="True" OnCheckedChanged="BoxPulden_CheckedChanged"></asp:CheckBox>                    
                    </span>
                    <span>
                     <asp:RadioButtonList runat="server" ID="rb_pul_den_Insert"   >
                        <Items>
                            <asp:ListItem Text="1.[%polovina směny%]" Value="a" />
                            <asp:ListItem Text="2.[%polovina směny%]" Value="d" />
                        </Items>
                    </asp:RadioButtonList>
                        <kspwc:TRequiredValidator runat="server" id="req_pul_den_Insert" Enabled="false" ControlToValidate="rb_pul_den_Insert" Text="[%Povinné pole%]" ErrorMessage="[%Povinné pole%]" ></kspwc:TRequiredValidator>                        
                        </span>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="row_check_zbytekInsert" Visible="false">
                <asp:TableCell runat="server" ID="TableCell8" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label19" runat="server" Text="[%Zbytek hodin%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell10" ColumnSpan="3" SkinID="DataFieldStyle">
                     <asp:Label runat="server" ID="lab_zbytek" ></asp:Label>  
                     <asp:CheckBox ID="check_zbytekInsert" runat="server" Checked='<%# Bind("check_zbytek") %>'
                        AutoPostBack="True" OnCheckedChanged="check_zbytek_CheckedChanged"></asp:CheckBox>                                                    
                </asp:TableCell>
            </asp:TableRow>

           
            <asp:TableRow runat="server" ID="TableRowInsert4">
                <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert8" ColumnSpan="3" SkinID="DataFieldStyle">
                    <%--<asp:TextBox ID="LabelDuvod" runat="server" Text='<%# Bind("duvod") %>' MaxLength="10" 
                        TextMode="MultiLine" Width="283px" Height="200"></asp:TextBox><br />--%>
                    <telerik:RadTextBox ID="LabelDuvod" runat="server" Text='<%# Bind("poznamka") %>' MaxLength="999"
                        TextMode="MultiLine" Width="283px" Height="40"  Resize="Both"></telerik:RadTextBox>
                    <kspwc:TextValidator runat="server" ID="val2" ControlToValidate="LabelDuvod"></kspwc:TextValidator>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowInsert5">
                <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="3" SkinID="DataFieldStyle">
                    <%--<asp:TextBox ID="TextBoxDatVyrizeniInsert" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>' Width="95px"></asp:TextBox>
    <ajax:CalendarExtender runat="server" ID="CalendarDatVyrizeni" TargetControlID="TextBoxDatVyrizeniInsert" PopupButtonID="ImageButton3i"></ajax:CalendarExtender>
    <asp:ImageButton ID="ImageButton3i" runat="server" ImageUrl="~/Images/calendar.png" />--%>
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniInsert" DbSelectedDate='<%# DataBinder.Eval(Container.DataItem,"vyridit_do") %>'>
                    </kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>
           <%-- <asp:TableRow runat="server" ID="TableRowInsert6">
                <asp:TableCell runat="server" ID="TCInsert11" ColumnSpan="4">
  
                </asp:TableCell>
            </asp:TableRow>--%>
        </asp:Table>
    </InsertItemTemplate>
    <FooterTemplate>
        <asp:CustomValidator ID="PrekrytiIntervaluValidator" runat="server" OnServerValidate="PrekrytiIntervaluValidator_validate" Display="Dynamic"
            ErrorMessage="Překrývající požadavky, nelze pokračovat"></asp:CustomValidator>
    </FooterTemplate>
</asp:FormView>

