﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOannual.ascx.cs" Inherits="Controls_ZadostOannual" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<style type="text/css">
    .grid-block{
        padding-left:10px;
        padding-right:10px;
    }

    .text-block{
        padding:10px;
    }
    .rfdTable
    {
        max-width:800px;
    }
    .text-prohlaseni
    {
        padding-top:30px;
        font-weight: bold;
    }
    .table-section
    {
        width:100%;
        border:solid;
        border-width:1px;
        border-color:lightgray;
    }
    .text-volba{
        font-weight:bold;
    }
</style>

<telerik:RadScriptBlock runat="server">
    <script>
       function showWindow(rejstrik1, rejstrik2,rejstrik3,rejstrik4) {
         
           window.open(String(rejstrik1), "_blank");
           window.open(String(rejstrik2), "_blank");
           window.open(String(rejstrik3), "_blank");
           window.open(String(rejstrik4), "_blank");
        }
    </script>
</telerik:RadScriptBlock>



 <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekannual" OnUpdated="ObjectDataSource1_Updated"
        OnUpdating="ObjectDataSource1_Updating" OnInserting="ObjectDataSource1_Inserting"
        UpdateMethod="Insert" InsertMethod="Insert" OnInserted="ObjectDataSource1_Inserted">
      <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" DefaultValue="" />
    </SelectParameters>
    </asp:ObjectDataSource>
<asp:FormView ID="FormView1" runat="server" DefaultMode="Edit">   
    <ItemTemplate>
    </ItemTemplate>
    <EditItemTemplate>    
        
        <table style="width:100%" class="table-section">
            <tr>
                <td><span class="nadpis1">[%Výroční prohlášení compliance%]</span></td>
                <td colspan="2"><asp:Label CssClass="nadpis1" runat="server" ID="lab_rok" Text='<%# Eval("rok") %>'></asp:Label></td>
               
            </tr>
            <tr>
                <td><span>[%Jméno a přijmení zaměstnance%]</span></td>
                <td><asp:Label runat="server" ID="lab_jmeno" Text='<%# Eval("jmeno_prijmeni") %>'></asp:Label></td>
                 <td>  <kspwc:TRadButton runat="server" ID="TRB_overeniProhlizec" Text="[%Ověřit%]" OnClick="TRB_overeniProhlizec_Click"></kspwc:TRadButton></td>
            </tr>
             <tr>
                <td><span>[%Osobní číslo%] / [%útvar%]</span></td>
                <td colspan="2"><asp:Label runat="server" ID="Label19" Text='<%# Eval("os_cislo") %>'></asp:Label> / <asp:Label runat="server" ID="Label20" Text='<%# Eval("stred") %>'></asp:Label></td>
            </tr>
           
        </table>
        
        <asp:Table runat="server" ID="tab_dary" CssClass="table-section" >
         <asp:TableHeaderRow runat="server" ID="TableHeaderRow4">
                <asp:TableCell runat="server"  ID="TableCell99" SkinID="TitleRowStyle">
                    <asp:Label ID="Label96" runat="server" Text="[%Dary, výhody, pozvání%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
        <asp:TableRow runat="server" ID="row_dary" >
            <asp:TableCell runat="server" ID="cell_dary" >
           
             <div class="text-block">
                 <asp:Label runat="server" ID="lab_page_dary" Text='<%# lab_page_dary() %>' ></asp:Label>
             </div>        
              <div class="text-block">
              <table style="width: 100%; border-collapse: collapse" class="text-block">
                <tr>
                    <td>
                        <asp:Label CssClass="text-volba" runat="server" ID="Label8" Text='<%# lab_page_dary_ne() %>' ></asp:Label>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox   runat="server" ID="Check_dary_ne" AutoPostBack="true" OnCheckedChanged="check_dary_CheckedChanged"  Checked='<%# Bind("dary_ne") %>' />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic;">([%zaškrtněte odpověď%])</span>
                    </td>
                </tr>
                <tr>
                    <td>
                         <asp:Label CssClass="text-volba" runat="server" ID="Label9" Text='<%# lab_page_dary_ano() %>' ></asp:Label>
                    </td>
                    <td>
                        <asp:CheckBox   runat="server" ID="Check_dary_ano" AutoPostBack="true"   OnCheckedChanged="check_dary_CheckedChanged"  Checked='<%# Bind("dary_ano") %>' />
                    </td>
                    <td ></td>
                </tr>
            </table>
             </div>

              <div class="grid-block">
                <asp:ObjectDataSource runat="server" ID="ds_dary" TypeName="KSProgram.Pozadavky.Pozadavekannual" OnDataBinding="ds_dary_DataBinding" SelectMethod="GetTableMem" InsertMethod="SaveDary" UpdateMethod="SaveDary"  >
                <SelectParameters>
                <asp:Parameter Type="String" Name="klic" DefaultValue='dary' />
                 <asp:Parameter Type="Int32" Name="id_poz" DefaultValue='0' />
                <asp:Parameter Type="Boolean" Name="fromDb" DefaultValue='false' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />
                    <asp:Parameter Name="datum" Type="DateTime" />
                    <asp:Parameter Name="darce" Type="String" />
                    <asp:Parameter Name="firma" Type="String" />
                    <asp:Parameter Name="popis" Type="String" />
                    <asp:Parameter Name="hodnota" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_dary" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="datum" Type="DateTime" />                                
                    <asp:Parameter Name="darce" Type="String" />
                    <asp:Parameter Name="firma" Type="String" />
                    <asp:Parameter Name="popis" Type="String" />
                    <asp:Parameter Name="hodnota" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
              
                 <kspwc:TRadGrid ID="grid_dary" runat="server"   Visible="false"
                    AllowPaging="False" AllowAutomaticUpdates="True" CaptionVisible="false" AllowAutomaticInserts="True" DataSourceID="ds_dary"
                    AllowAutomaticDeletes="true" OnItemCommand="grid_dary_ItemCommand" >
                  <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />                    
                     <MasterTableView DataSourceID="ds_dary"  AutoGenerateColumns="False" DataKeyNames="id" CommandItemDisplay="Top" >
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                                         
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn"/>                           
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />                                  
                            <telerik:GridTemplateColumn HeaderText="[%Datum%]" UniqueName="datum"> 
                            <EditItemTemplate>                                
                            <table style=" border-collapse:collapse; border-width:0px;">
                                <tr>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="rdp_datum" DbSelectedDate='<%# Bind("datum") %>' DateInput-BackColor="#ffffcc" ></kspwc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <kspwc:TRequiredValidator runat="server" ID="rv_datum" ControlToValidate="rdp_datum" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                                    </td>
                                </tr>                                    
                             </table>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_datum" runat="server" Text='<%# DateTime.Parse(Eval("datum").ToString()).ToString("d") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Dárce (fyzická osoba)%]" UniqueName="darce"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_darce" runat="server" Text='<%# Bind("darce") %>' ValidationGroup="dary" MaxLength="50" BackColor="#ffffcc" ></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_darce" ControlToValidate="text_darce" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_darce" runat="server" Text='<%# Eval("darce") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Firma / jméno dárce%]" UniqueName="firma"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_firma" runat="server" Text='<%# Bind("firma") %>' ValidationGroup="dary" MaxLength="50" BackColor="#ffffcc" ></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_firma" ControlToValidate="text_firma" Text="[%Povinná položka%]" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_firma" runat="server" Text='<%# Eval("firma") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn  HeaderText="[%Popis daru%]" UniqueName="popis"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_popis" runat="server" Text='<%# Bind("popis") %>' ValidationGroup="dary" MaxLength="100" BackColor= "#ffffcc"></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_popis" ControlToValidate="text_popis" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_popis" runat="server" Text='<%# Eval("popis") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn  HeaderText="[%Hodnota (CZK)%]" UniqueName="hodnota"> 
                            <EditItemTemplate>
                                 <telerik:RadNumericTextBox  ID="text_hodnota" runat="server" Text='<%# Bind("hodnota") %>' ValidationGroup="dary" BackColor="#ffffcc" ></telerik:RadNumericTextBox >
                                 <kspwc:TRequiredValidator runat="server" ID="rv_hodnota" ControlToValidate="text_hodnota" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                                 <kspwc:DecimalValidator runat="server" ID="nv_hodnota" ControlToValidate="text_hodnota" ></kspwc:DecimalValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_hodnota" runat="server" Text='<%# Eval("hodnota") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>                                          
            </div>
                 </asp:TableCell>
        </asp:TableRow>
        </asp:Table>
        <%-- </telerik:RadPageView>
        <telerik:RadPageView runat="server" ID="page_vedl_cin">--%>
         <asp:Table runat="server" ID="Table1"  CssClass="table-section">
         <asp:TableHeaderRow runat="server" ID="TableHeaderRow1">
                <asp:TableCell runat="server"  ID="TableCell1" SkinID="TitleRowStyle">
                    <asp:Label ID="Label21" runat="server" Text="[%Výkon vedlejší činnosti%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
        <asp:TableRow runat="server" ID="TableRow1" >
            <asp:TableCell runat="server" ID="TableCell2" >
             <div class="text-block">
                 <asp:Label runat="server" ID="Label1" Text='<%# lab_vedl_cin() %>' ></asp:Label>
             </div>
             <div class="text-block">
                <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <asp:Label CssClass="text-volba" runat="server" ID="Label6" Text='<%# lab_page_vedl_cin_ne() %>' ></asp:Label>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox CssClass="text-volba"  runat="server" ID="Check_vedl_cin_ne" AutoPostBack="true" OnCheckedChanged="Check_vedl_cin_CheckedChanged"  Checked='<%# Bind("vedl_cin_ne") %>' />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic;">([%zaškrtněte odpověď%])</span>
                    </td>
                </tr>
                <tr>
                    <td>
                         <asp:Label CssClass="text-volba" runat="server" ID="Label7" Text='<%# lab_page_vedl_cin_ano() %>' ></asp:Label>
                    </td>
                    <td>
                        <asp:CheckBox CssClass="text-volba"  runat="server" ID="Check_vedl_cin_ano" AutoPostBack="true" OnCheckedChanged="Check_vedl_cin_CheckedChanged"  Checked='<%# Bind("vedl_cin_ano") %>' />
                    </td>
                    <td ></td>
                </tr>
            </table>
            </div>         
             <div class="grid-block">
                <asp:ObjectDataSource OnDataBinding="ds_prace_DataBinding" runat="server" ID="ds_prace" TypeName="KSProgram.Pozadavky.Pozadavekannual" SelectMethod="GetTableMem" InsertMethod="SavePrace" UpdateMethod="SavePrace"  >
                <SelectParameters>
                <asp:Parameter Type="String" Name="klic" DefaultValue='prace' />
                 <asp:Parameter Type="Int32" Name="id_poz" DefaultValue='0' />
                 <asp:Parameter Type="Boolean" Name="fromDb" DefaultValue='false' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />
                    <asp:Parameter Name="datum_od" Type="DateTime" />
                    <asp:Parameter Name="datum_do" Type="DateTime" />
                    <asp:Parameter Name="zamestnavatel" Type="String" />
                    <asp:Parameter Name="vztah" Type="String" />
                    <asp:Parameter Name="popis" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_prace" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="datum_od" Type="DateTime" />
                    <asp:Parameter Name="datum_do" Type="DateTime" />
                    <asp:Parameter Name="zamestnavatel" Type="String" />
                    <asp:Parameter Name="vztah" Type="String" />
                    <asp:Parameter Name="popis" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_prace" runat="server" CaptionVisible="false" DataSourceID="ds_prace" Visible="false"
                    AllowPaging="False" AllowAutomaticUpdates="True" AllowAutomaticInserts="True" 
                    AllowAutomaticDeletes="true" AllowSorting="true" OnItemCommand="grid_prace_ItemCommand" >
                     <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert"  />  
                     <MasterTableView DataSourceID="ds_prace" AutoGenerateColumns="False"
                        DataKeyNames="id" CommandItemDisplay="Top">
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn"/>                           
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />                                  
                            <telerik:GridTemplateColumn HeaderText="[%Datum od%]" UniqueName="datum_od"> 
                            <EditItemTemplate>
                                <table style=" border-collapse:collapse; border-width:0px;">
                                <tr>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="rdp_datum_od" DbSelectedDate='<%# Bind("datum_od") %>' DateInput-BackColor="#ffffcc"></kspwc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <kspwc:TRequiredValidator runat="server" ID="rv_datum_od" ControlToValidate="rdp_datum_od" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                                    </td>
                                 </tr>
                                 </table>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_datum" runat="server" Text='<%# DateTime.Parse(Eval("datum_od").ToString()).ToString("d") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="[%Datum do%]" UniqueName="datum_do"> 
                            <EditItemTemplate>
                                <table style=" border-collapse:collapse; border-width:0px;">
                                <tr>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="rdp_datum_do" DbSelectedDate='<%# Bind("datum_do") %>' ></kspwc:TRadDatePicker>
                                    </td>
                                    <td>
                                       <%-- <kspwc:TRequiredValidator runat="server" ID="rv_datum_do" ControlToValidate="rdp_datum_do" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>--%>
                                    </td>
                                </tr>
                                </table>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_datum_do" runat="server" Text='<%# _DateTimeNull(Eval("datum_do")) %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="[%Zaměstnavatel / osoba, v jejímž rámci je činnost vykonávána%]" UniqueName="zamestnavatel"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_zamestnavatel" runat="server" Text='<%# Bind("zamestnavatel") %>' MaxLength="50" BackColor= "#ffffcc"></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_zamestnavatel" ControlToValidate="text_zamestnavatel" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_zamestnavatel" runat="server" Text='<%# Eval("zamestnavatel") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>


                            <telerik:GridTemplateColumn HeaderText="[%Právní rámec (pracovněprávní vztah, obchodní vztah atd.)%]" UniqueName="vztah"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_vztah" runat="server" Text='<%# Bind("vztah") %>' MaxLength="50" BackColor="#ffffcc"></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_firma" ControlToValidate="text_vztah" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_vztah" runat="server" Text='<%# Eval("vztah") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="[%Popis  činnosti oznamovatele%]" UniqueName="popis"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_popis" runat="server" Text='<%# Bind("popis") %>' MaxLength="100" BackColor="#ffffcc"></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_popis" ControlToValidate="text_popis" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_popis" runat="server" Text='<%# Eval("popis") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
         </asp:TableCell>
            </asp:TableRow>
        </asp:Table>

        <%-- </telerik:RadPageView>
        <telerik:RadPageView runat="server" ID="page_obch_spol">--%>

        <asp:Table runat="server" ID="Table2"  CssClass="table-section">
         <asp:TableHeaderRow runat="server" ID="TableHeaderRow2">
                <asp:TableCell runat="server"  ID="TableCell3" SkinID="TitleRowStyle">
                    <asp:Label ID="Label22" runat="server" Text="[%Účast v jiné obchodní společnosti%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
        <asp:TableRow runat="server" ID="TableRow2" >
            <asp:TableCell runat="server" ID="TableCell4" >
            <div class="text-block">
                 <asp:Label runat="server" ID="Label2" Text='<%# lab_page_obch_spol() %>' ></asp:Label>
             </div>
            <div class="text-block">
            <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <asp:Label CssClass="text-volba" runat="server" ID="Label10" Text='<%# lab_page_obch_spol_ne() %>' ></asp:Label>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox CssClass="text-volba"  runat="server" ID="Check_obch_spol_ne" AutoPostBack="true" OnCheckedChanged="Check_obch_spol_CheckedChanged"  Checked='<%# Bind("obch_spol_ne") %>' />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic;">([%zaškrtněte odpověď%])</span>
                    </td>
                </tr>
                <tr>
                    <td>
                         <asp:Label CssClass="text-volba" runat="server" ID="Label11" Text='<%# lab_page_obch_spol_ano() %>' ></asp:Label>
                    </td>
                    <td>
                        <asp:CheckBox CssClass="text-volba"  runat="server" ID="Check_obch_spol_ano" AutoPostBack="true" OnCheckedChanged="Check_obch_spol_CheckedChanged"  Checked='<%# Bind("obch_spol_ano") %>' />
                    </td>
                    <td ></td>
                </tr>
            </table>
            </div>
            <div class="grid-block">
               <asp:ObjectDataSource OnDataBinding="ds_cinnost_DataBinding" runat="server" ID="ds_cinnost" TypeName="KSProgram.Pozadavky.Pozadavekannual" SelectMethod="GetTableMem" InsertMethod="SaveCinnost" UpdateMethod="SaveCinnost"  >
                <SelectParameters>
                <asp:Parameter Type="String" Name="klic" DefaultValue='cinnost' />
                 <asp:Parameter Type="Int32" Name="id_poz" DefaultValue='0' />
                 <asp:Parameter Type="Boolean" Name="fromDb" DefaultValue='false' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />                   
                    <asp:Parameter Name="firma" Type="String" />
                    <asp:Parameter Name="funkce" Type="String" />
                    <asp:Parameter Name="obor" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_cinnost" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="firma" Type="String" />
                    <asp:Parameter Name="funkce" Type="String" />
                    <asp:Parameter Name="obor" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_cinnost" runat="server" CaptionVisible="false" DataSourceID="ds_cinnost" Visible="false"
                    AllowPaging="False" AllowAutomaticUpdates="True" AllowAutomaticInserts="True" 
                    AllowAutomaticDeletes="true" AllowSorting="true" OnItemCommand="grid_cinnost_ItemCommand" >
                     <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />  
                     <MasterTableView DataSourceID="ds_cinnost" AutoGenerateColumns="False"
                        DataKeyNames="id" CommandItemDisplay="Top">
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn"/>                           
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />                            
                            <telerik:GridTemplateColumn HeaderText="[%Firma nebo název osoby%]" UniqueName="firma"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_firma" runat="server" Text='<%# Bind("firma") %>' MaxLength="50" BackColor="#ffffcc"></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_firma" ControlToValidate="text_firma" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_firma" runat="server" Text='<%# Eval("firma") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="[%Funkce nebo postavení oznamovatele v rámci této osoby%]" UniqueName="funkce"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_funkce" runat="server" Text='<%# Bind("funkce") %>' MaxLength="50" BackColor="#ffffcc"></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_funkce" ControlToValidate="text_funkce" Text="[%Povinná položka%]" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_funkce" runat="server" Text='<%# Eval("funkce") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="[%Obor, předmět činnosti této osoby%]" UniqueName="obor"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_obor" runat="server" Text='<%# Bind("obor") %>' MaxLength="50" BackColor="#ffffcc"></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_obor" ControlToValidate="text_obor" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_obor" runat="server" Text='<%# Eval("obor") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
        </asp:TableCell>
            </asp:TableRow>
        </asp:Table>

        <%-- </telerik:RadPageView>
        <telerik:RadPageView runat="server" ID="page_vztahy">--%>
         <asp:Table runat="server" ID="Table3"  CssClass="table-section">
         <asp:TableHeaderRow runat="server" ID="TableHeaderRow3">
                <asp:TableCell runat="server"  ID="TableCell5" SkinID="TitleRowStyle">
                    <asp:Label ID="Label23" runat="server" Text="[%Příbuzenské vztahy%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
        <asp:TableRow runat="server" ID="TableRow3" >
            <asp:TableCell runat="server" ID="TableCell6" >
           <div class="text-block">
                 <asp:Label  runat="server" ID="Label4" Text='<%# lab_page_vztahy() %>' ></asp:Label>
             </div>
           <div class="text-block">
             <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <asp:Label CssClass="text-volba" runat="server" ID="Label12" Text='<%# lab_page_vztahy_ne() %>' ></asp:Label>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox CssClass="text-volba"  runat="server" ID="Check_vztahy_ne" AutoPostBack="true" OnCheckedChanged="Check_vztahy_CheckedChanged" Checked='<%# Bind("vztahy_ne") %>' />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic;">([%zaškrtněte odpověď%])</span>
                    </td>
                </tr>
                <tr>
                    <td>
                         <asp:Label CssClass="text-volba" runat="server" ID="Label13" Text='<%# lab_page_vztahy_ano() %>' ></asp:Label>
                    </td>
                    <td>
                        <asp:CheckBox CssClass="text-volba"  runat="server" ID="Check_vztahy_ano" AutoPostBack="true" OnCheckedChanged="Check_vztahy_CheckedChanged"  Checked='<%# Bind("vztahy_ano") %>' />
                    </td>
                    <td ></td>
                </tr>
            </table>
            </div>
           <div class="grid-block">
                <asp:ObjectDataSource OnDataBinding="ds_osoby_DataBinding" runat="server" ID="ds_osoby" TypeName="KSProgram.Pozadavky.Pozadavekannual" SelectMethod="GetTableMem" InsertMethod="SaveOsoby" UpdateMethod="SaveOsoby"  >
                <SelectParameters>
                <asp:Parameter Type="String" Name="klic" DefaultValue='osoby' />
                 <asp:Parameter Type="Int32" Name="id_poz" DefaultValue='0' />
                 <asp:Parameter Type="Boolean" Name="fromDb" DefaultValue='false' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />                   
                    <asp:Parameter Name="jmeno" Type="String" />
                    <asp:Parameter Name="utvar" Type="String" />
                    <asp:Parameter Name="vztah" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_osoby" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="jmeno" Type="String" />
                    <asp:Parameter Name="utvar" Type="String" />
                    <asp:Parameter Name="vztah" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_osoby" runat="server" CaptionVisible="false" DataSourceID="ds_osoby" Visible="false"
                    AllowPaging="False" AllowAutomaticUpdates="True" AllowAutomaticInserts="True" 
                    AllowAutomaticDeletes="true" AllowSorting="true" OnItemCommand="grid_osoby_ItemCommand" >
                     <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />  
                     <MasterTableView DataSourceID="ds_osoby" AutoGenerateColumns="False"
                        DataKeyNames="id" CommandItemDisplay="Top">
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn"/>                           
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />                            
                            <telerik:GridTemplateColumn HeaderText="[%Jméno a příjmení osoby blízké%]" UniqueName="jmeno"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_jmeno" runat="server" Text='<%# Bind("jmeno") %>' MaxLength="50" BackColor="#ffffcc"></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_jmeno" ControlToValidate="text_jmeno" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_jmeno" runat="server" Text='<%# Eval("jmeno") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="[%Útvar RBCZ nebo třetí osoba (např. dodavatel)%]" UniqueName="utvar"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_utvar" runat="server" Text='<%# Bind("utvar") %>' MaxLength="50" BackColor="#ffffcc"></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_utvar" ControlToValidate="text_utvar" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_utvar" runat="server" Text='<%# Eval("utvar") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="[%Vztah k oznamovateli%]" UniqueName="vztah"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_vztah" runat="server" Text='<%# Bind("vztah") %>' MaxLength="50" BackColor="#ffffcc"></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_vztah" ControlToValidate="text_vztah" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_vztah" runat="server" Text='<%# Eval("vztah") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
        </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
        <%-- </telerik:RadPageView>
        
        <telerik:RadPageView runat="server" ID="page_politika">--%>
        <asp:Table runat="server" ID="Table4"  CssClass="table-section">
         <asp:TableHeaderRow runat="server" ID="TableHeaderRow5">
                <asp:TableCell runat="server"  ID="TableCell7" SkinID="TitleRowStyle">
                    <asp:Label ID="Label24" runat="server" Text="[%Politická angažovanost%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
        <asp:TableRow runat="server" ID="TableRow4" >
            <asp:TableCell runat="server" ID="TableCell8" >
            <div class="text-block">
                 <asp:Label runat="server" ID="Label3" Text='<%# lab_page_politika() %>' ></asp:Label>
             </div>
             <div class="text-block">
                <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <asp:Label CssClass="text-volba" runat="server" ID="Label14" Text='<%# lab_page_politika_ne() %>' ></asp:Label>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox CssClass="text-volba"  runat="server" ID="Check_politika_ne" AutoPostBack="true" OnCheckedChanged="Check_politika_CheckedChanged"  Checked='<%# Bind("politika_ne") %>' />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic;">([%zaškrtněte odpověď%])</span>
                    </td>
                </tr>
                <tr>
                    <td>
                         <asp:Label CssClass="text-volba" runat="server" ID="Label15" Text='<%# lab_page_politika_ano() %>' ></asp:Label>
                    </td>
                    <td>
                        <asp:CheckBox CssClass="text-volba"  runat="server" ID="Check_politika_ano" AutoPostBack="true" OnCheckedChanged="Check_politika_CheckedChanged"  Checked='<%# Bind("politika_ano") %>' />
                    </td>
                    <td ></td>
                </tr>
            </table>
            </div>
             <div class="grid-block">
                <asp:ObjectDataSource OnDataBinding="ds_politika_DataBinding" runat="server" ID="ds_politika" TypeName="KSProgram.Pozadavky.Pozadavekannual" SelectMethod="GetTableMem" InsertMethod="SavePolitika" UpdateMethod="SavePolitika"  >
                <SelectParameters>
                <asp:Parameter Type="String" Name="klic" DefaultValue='politika' />
                 <asp:Parameter Type="Int32" Name="id_poz" DefaultValue='0' />
                 <asp:Parameter Type="Boolean" Name="fromDb" DefaultValue='false' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />                   
                    <asp:Parameter Name="datum_od" Type="DateTime" />
                    <asp:Parameter Name="datum_do" Type="DateTime" />
                    <asp:Parameter Name="pravni_ramec" Type="String" />
                    <asp:Parameter Name="popis" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_politika" PropertyName="SelectedValue" />    
                   <asp:Parameter Name="datum_od" Type="DateTime" />
                    <asp:Parameter Name="datum_do" Type="DateTime" />
                    <asp:Parameter Name="pravni_ramec" Type="String" />
                    <asp:Parameter Name="popis" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_politika" runat="server" CaptionVisible="false" DataSourceID="ds_politika" Visible="false"
                    AllowPaging="False" AllowAutomaticUpdates="True" AllowAutomaticInserts="True" 
                    AllowAutomaticDeletes="true" AllowSorting="true" OnItemCommand="grid_politika_ItemCommand" >
                     <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />  
                     <MasterTableView DataSourceID="ds_politika" AutoGenerateColumns="False"
                        DataKeyNames="id" CommandItemDisplay="Top">
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn"/>                           
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />                                                   
                            <telerik:GridTemplateColumn HeaderText="[%Datum od%]" UniqueName="datum_od"> 
                            <EditItemTemplate>
                                <table style=" border-collapse:collapse; border-width:0px;">
                                <tr>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="rdp_datum_od" DbSelectedDate='<%# Bind("datum_od") %>' DateInput-BackColor="#ffffcc" ></kspwc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <kspwc:TRequiredValidator runat="server" ID="rv_datum_od" ControlToValidate="rdp_datum_od" Text="[%Povinná položka%]"  ErrorMessage="[%Povinná položka%]"></kspwc:TRequiredValidator>
                                    </td>
                                 </tr>
                                 </table>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_datum" runat="server" Text='<%# DateTime.Parse(Eval("datum_od").ToString()).ToString("d") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="[%Datum do%]" UniqueName="datum_do"> 
                            <EditItemTemplate>
                                <table style=" border-collapse:collapse; border-width:0px;">
                                <tr>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="rdp_datum_do" DbSelectedDate='<%# Bind("datum_do") %>' ></kspwc:TRadDatePicker>
                                    </td>                                   
                                </tr>
                                </table>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_datum_do" runat="server" Text='<%# _DateTimeNull(Eval("datum_do")) %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="[%Právní rámec (pracovněprávní vztah atd.)%]" UniqueName="utvar"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_utvar" runat="server" Text='<%# Bind("pravni_ramec") %>' MaxLength="50" BackColor="#ffffcc"></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_utvar" ControlToValidate="text_utvar" Text="[%Povinná položka%]"  ErrorMessage="[%Povinná položka%]"></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_utvar" runat="server" Text='<%# Eval("pravni_ramec") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="[%Popis činnosti oznamovatele%]" UniqueName="vztah"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_vztah" runat="server" Text='<%# Bind("popis") %>' MaxLength="100" BackColor="#ffffcc"></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_vztah" ControlToValidate="text_vztah" Text="[%Povinná položka%]"  ErrorMessage="[%Povinná položka%]"></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_vztah" runat="server" Text='<%# Eval("popis") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
        </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
        <%-- </telerik:RadPageView>
        <telerik:RadPageView runat="server" ID="page_predvolani">--%>
        <asp:Table runat="server" ID="Table5"  CssClass="table-section">
         <asp:TableHeaderRow runat="server" ID="TableHeaderRow6">
                <asp:TableCell runat="server"  ID="TableCell9" SkinID="TitleRowStyle">
                    <asp:Label ID="Label25" runat="server" Text="[%Předvolání orgány činnými v trestním řízení%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
        <asp:TableRow runat="server" ID="TableRow5" >
            <asp:TableCell runat="server" ID="TableCell10" >
             <div class="text-block">
                 <asp:Label runat="server" ID="Label5" Text='<%# lab_page_predvolani() %>' ></asp:Label>
             </div>
             <div class="text-block">
            <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <asp:Label CssClass="text-volba" runat="server" ID="Label16" Text='<%# lab_page_predvolani_ne() %>' ></asp:Label>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox CssClass="text-volba"  runat="server" ID="Check_predvolani_ne" AutoPostBack="true" OnCheckedChanged="Check_predvolani_CheckedChanged"  Checked='<%# Bind("predvolani_ne") %>' />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic;">([%zaškrtněte odpověď%])</span>
                    </td>
                </tr>
                <tr>
                    <td>
                         <asp:Label CssClass="text-volba" runat="server" ID="Label17" Text='<%# lab_page_predvolani_ano() %>' ></asp:Label>
                    </td>
                    <td>
                        <asp:CheckBox CssClass="text-volba"  runat="server" ID="Check_predvolani_ano" AutoPostBack="true" OnCheckedChanged="Check_predvolani_CheckedChanged" Checked='<%# Bind("predvolani_ano") %>' />
                    </td>
                    <td ></td>
                </tr>
            </table>
             </div>
             <div class="grid-block">
                <asp:ObjectDataSource OnDataBinding="ds_predvolani_DataBinding" runat="server" ID="ds_predvolani" TypeName="KSProgram.Pozadavky.Pozadavekannual" SelectMethod="GetTableMem" InsertMethod="SavePredvolani" UpdateMethod="SavePredvolani"  >
                <SelectParameters>
                <asp:Parameter Type="String" Name="klic" DefaultValue='vyslechy' />
                 <asp:Parameter Type="Int32" Name="id_poz" DefaultValue='0' />
                 <asp:Parameter Type="Boolean" Name="fromDb" DefaultValue='false' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />                   
                    <asp:Parameter Name="datum" Type="DateTime" />                    
                    <asp:Parameter Name="vec" Type="String" />
                    <asp:Parameter Name="osoba" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_predvolani" PropertyName="SelectedValue" />    
                   <asp:Parameter Name="datum" Type="DateTime" />
                    <asp:Parameter Name="vec" Type="String" />
                    <asp:Parameter Name="osoba" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_predvolani" runat="server" CaptionVisible="false" DataSourceID="ds_predvolani" Visible="false"
                    AllowPaging="False" AllowAutomaticUpdates="True" AllowAutomaticInserts="True" 
                    AllowAutomaticDeletes="true" AllowSorting="true" OnItemCommand="grid_predvolani_ItemCommand" >
                     <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />  
                     <MasterTableView DataSourceID="ds_predvolani" AutoGenerateColumns="False"
                        DataKeyNames="id" CommandItemDisplay="Top">
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn"/>                           
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />                                                   
                            <telerik:GridTemplateColumn HeaderText="[%Datum%]" UniqueName="datum"> 
                            <EditItemTemplate>
                                <table style=" border-collapse:collapse; border-width:0px;">
                                <tr>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="rdp_datum" DbSelectedDate='<%# Bind("datum") %>' DateInput-BackColor="#ffffcc" ></kspwc:TRadDatePicker>
                                        <kspwc:TRequiredValidator runat="server" ID="rv_datum_predvolani" ControlToValidate="rdp_datum" Text="[%Povinná položka%]"  ErrorMessage="[%Povinná položka%]"></kspwc:TRequiredValidator>
                                    </td>                                   
                                 </tr>
                                 </table>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_datum" runat="server" Text='<%# DateTime.Parse(Eval("datum").ToString()).ToString("d") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                           

                            <telerik:GridTemplateColumn HeaderText="[%Ve věci%]" UniqueName="ve_veci"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_utvar" runat="server" Text='<%# Bind("vec") %>' MaxLength="50" BackColor="#ffffcc"></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_utvar" ControlToValidate="text_utvar" Text="[%Povinná položka%]"  ErrorMessage="[%Povinná položka%]"></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_utvar" runat="server" Text='<%# Eval("vec") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="[%Kým jste byl/a předvolán/a (jméno a příjmení, telefoní číslo)%]" UniqueName="kym"> 
                            <EditItemTemplate>
                                 <telerik:RadTextBox ID="text_vztah" runat="server" Text='<%# Bind("osoba") %>' MaxLength="100" BackColor="#ffffcc"></telerik:RadTextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_vztah" ControlToValidate="text_vztah" Text="[%Povinná položka%]"  ErrorMessage="[%Povinná položka%]"></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_vztah" runat="server" Text='<%# Eval("osoba") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
         </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
        <%-- </telerik:RadPageView>
             
         </telerik:RadMultiPage>--%>
        <div class="text-block text-prohlaseni">
            <div>
                <asp:Label  runat="server" ID="Label18" Text='<%# prohlaseni() %>' ></asp:Label>
            </div>
            <div>
                 <asp:CheckBox runat="server" ID="CheckBox_souhlas"  Text="[%Ano%]"  Checked='<%# Bind("souhlas") %>' />
            </div>      
        </div>

        
        <div class="text-block text-prohlaseni">
            <span style="padding-right:20px;font-weight:normal !important"><asp:Label runat="server" ID="lab_pdp" Text="[%Podpis zaměstnance%]:"></asp:Label></span>
            <asp:Label  runat="server"  ID="lab_podpis" Text='<%# _zobrazPodpis(Eval("podpis_os_cislo")) %>' Font-Italic="true" ></asp:Label>
            <kspwc:TRadButton runat="server" ID="button_podpis" Text="[%Podepsat%]" Visible='<%# _zobrazTlacitkoPodpis(Eval("podpis_os_cislo")) %>' CausesValidation="false" OnClick="button_podpis_Click"  ></kspwc:TRadButton>
            <asp:Label runat="server" ID="lab_dat_podpisu" Text='<%# Eval("podpis_datum","{0:d}") %>'></asp:Label>
        </div>

         <div class="text-block">
            <asp:CustomValidator ID="val_form" runat="server" ErrorMessage="CustomValidator" OnServerValidate="val_form_ServerValidator" Display="Dynamic"></asp:CustomValidator>
        </div>
    </EditItemTemplate>
    <InsertItemTemplate>
        <%--nechám prázdný, nebude se využívat--%>
    </InsertItemTemplate>
</asp:FormView>



