﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZRZ_MF_2024.ascx.cs" Inherits="KSPortal.Controls.ZRZ_MF_2024" %>
<%@ Register assembly="WebControls" namespace="KSProgram.WebControls" tagprefix="kspwc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:ObjectDataSource ID="ODS_manzelky" runat="server" TypeName="KSProgram.Pozadavky.pozadavekzroczuct" SelectMethod="GetManzelky" EnableCaching="True" CacheDuration="120" CacheExpirationPolicy="Sliding">
    <SelectParameters>
        <asp:Parameter Name="osc" DbType="Decimal" />
        <asp:Parameter Name="keDni" DbType="DateTime" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource ID="ODS_deti" runat="server" TypeName="KSProgram.Pozadavky.pozadavekzroczuct" SelectMethod="GetDeti" EnableCaching="True" CacheDuration="120" CacheExpirationPolicy="Sliding">
    <SelectParameters>
        <asp:Parameter Name="osc" DbType="Decimal" />
        <asp:Parameter Name="keDni" DbType="DateTime" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource ID="ODS_rodprisl" runat="server" TypeName="KSProgram.Pozadavky.pozadavekzroczuct" SelectMethod="GetRodprislNeDeti" EnableCaching="True" CacheDuration="120" CacheExpirationPolicy="Sliding">
    <SelectParameters>
        <asp:Parameter Name="osc" DbType="Decimal" />
        <asp:Parameter Name="keDni" DbType="DateTime" />
    </SelectParameters>
</asp:ObjectDataSource>

<style type="text/css">
        .HTMLpageOkraj {
            position: relative;
            padding-top: 5mm;
            padding-left: 9mm;
            padding-right: 9mm;
            padding-bottom: 5mm;
            /*width: 193mm;*/
            /*height: 279mm;*/
            border: 1px solid grey;
            background-color: #FFE5E3;
            page-break-after: always;
            page-break-inside: avoid;            
        }

        .HTMLpage {
            -webkit-text-size-adjust: 94%; /* aby iPhone (webkit-based browsers) nezvětšoval font-size */
            /*position: relative;*/
            direction: ltr;
            padding-top: 0mm;
            padding-left: 0mm;
            padding-right: 0mm;
            padding-bottom: 0mm;
            margin: 0mm;
            width: 175mm;
            height: 269mm;
            /*border: 1px solid red;*/
            font-family: Arial, Helvetica, sans-serif;
            font-size: 3mm;
        }

        .HTMLpage > div {
            /*position: absolute;*/
            /*white-space: nowrap;*/
            overflow: hidden;
        }
        .HTMLpage > table {
            /*position: absolute;*/
            /*white-space: nowrap;*/
            overflow: hidden;
            padding: 0mm;
            margin: 0mm;
            border-collapse: separate;
            border-spacing: 0mm;
            text-align: left;
            vertical-align: middle;
            font-family: Arial, Helvetica, sans-serif;
            font-size: 3mm;
        }
        .HTMLpage th {
            text-align: center;
            font-weight: normal;
        }
        .HTMLpage td {
            padding: 0mm 1mm 0mm 1mm;
        }

        table.vysvetlivky {
            width: 100%; 
            padding-top: 0.55mm; 
            font-style: italic; 
            text-align: justify;
        }

        table.vysvetlivky td {
            font-size: 2.5mm;
            line-height: 115%; /*webkit na iPhonu nastavoval vetší řádkování */
            vertical-align: top; 
        }

        table.vysvetlivky td:first-child {
            font-size: 1.8mm; 
            padding-left: 0mm;
            width: 1mm;
        }
        
        sup {
            font-size: 90%;
            line-height: 50%;
        }

        .roundBorder {
            border: 1px solid black;
            border-radius: 2mm;
        }

        .BorderRadius {
            border-radius: 2mm;
        }

        .BorderTLRadius {
            border-top-left-radius: 2mm;
        }

        .BorderTRRadius {
            border-top-right-radius: 2mm;
        }

        .BorderBLRadius {
            border-bottom-left-radius: 2mm;
        }

        .BorderBRRadius {
            border-bottom-right-radius: 2mm;
        }

        .BorderTL {
            border-top: 1px solid black;
            border-left: 1px solid black;
        }

        .BorderBR {
            border-bottom: 1px solid black;
            border-right: 1px solid black;
        }

        .Border {
            border: 1px solid black;
        }

        .HTMLpage .input
        {   
            box-sizing: border-box;
            -moz-box-sizing: border-box;
            -webkit-box-sizing: border-box;
            border-color:#000000;border-style:solid;border-width:0px;background:#fff;color:black;height:22px;
            font-family:'Segoe UI',Arial,Helvetica,sans-serif; 
            font-size:11px; 
            font-weight:bold;
            vertical-align:middle; /*tímto se srovná bottom-line s RadDropDown*/
        }
        .HTMLpage .input:hover{color:black;border-color:#767676;border-width:1px;}
        .HTMLpage .input:focus{border-color:var(--kscolor1);border-width:1px;}
        .HTMLpage .input:disabled{background-color:gainsboro;color:black;filter: alpha(opacity=50);opacity: 0.5;}

        /*.hideIfEmpty:blank { blank nepodporuje žádný prohlížeč a :empty je zase že nemá žádný child element
          display: none;
        }*/
        .hide { 
          display: none;
        }

        /*telerikovske tridy kvuli vykopirovani casti html do souboru*/
        .HTMLpage .RadDropDownList {
         width:160px;
         line-height:1.3333;
         text-align:left;
         display:inline-block;
         vertical-align:middle;
         white-space:nowrap;
         cursor:default;
         *zoom:1;
         *display:inline
        }
        .HTMLpage .RadDropDownList .rddlInner {
         padding:2px 22px 2px 5px;
         border-width:0px;
         display:block;
         position:relative;
         overflow:hidden;
         background-color:white;
        }
        .HTMLpage .RadDropDownList .rddlFocused {
            color: black;
            border-color:var(--kscolor1);border-width:1px;
        }
        .HTMLpage .RadDropDownList .rddlDisabled {         
            background-color:gainsboro;         
        }

        .HTMLpage .RadDropDownList .rddlInner:hover{border-color:#767676;border-width:1px;}

        .HTMLpage .RadDropDownList .rddlFakeInput {
         margin:0;
         padding:0;
         width:100%;
         min-height:16px;
         display:block;
         overflow:hidden;
         font-weight:bold;
        }
        .HTMLpage .RadDropDownList .rddlIcon {
         width:16px;
         height:100%;
         border:0;
         background-repeat:no-repeat;
         position:absolute;
         top:0;
         right:0
        }        
        .HTMLpage .RadDropDownList .rddlDisabled .rddlIcon {         
         background-image:none;         
        }

        
        /*.RadDropDownList {         
            border-width:0px;border-style:none;
        }*/
        .Pad0>.rddlInner {        
            padding-top:0px; padding-bottom:0px;
        }
        .Pad0>.rddlInner>.rddlFakeInput {        
            min-height:10px;
            line-height:1;
        }

        .Pad0>.rddlInner>.rddlIcon {
            background-position-y: -22px;
        }

        input[type=checkbox] {
            margin-bottom: 0px; margin-top: 0px; height:12px;
        }

        .bottomLine{
            border-bottom: 1px solid black !important; 
            
        }
                
        @media print {
            

            body {
                margin: 0;
                padding: 0;
                width: 193mm;
            }

            .HTMLpageOkraj {
                padding: 0;
                border: none;
                background-color: none;
                page-break-after: always;                
            }

            .HTMLpage {
                padding-top: 0mm;
                padding-left: 10mm;
                padding-right: 0mm;
                padding-bottom: 0mm;
                margin: 0;
                border: none;
            }

            .HTMLpage > div {
                
            }
            .HTMLpage .RadButton {display: none;}

            .HTMLpage .rdllFocused {
                border: none;
            }
            .HTMLpage :disabled.input {
                background-color: none;
                color: black;
                filter: alpha(opacity=100);
                opacity: 1;
            }
            .RadDropDownList .rddlDisabled {
                filter: alpha(opacity=100);
                opacity: 1;
            }
        }
</style>
<span class="tiskHide">
            <asp:CustomValidator runat="server" ID="ValidPre"  OnServerValidate="ValidPre_ServerValidate" ValidationGroup="PreValidace"></asp:CustomValidator>
        </span>
<asp:FormView ID="FormView1" runat="server" CssClass="noclass" OnItemInserted="FormView1_ItemInserted"
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound" DataSourceID="ObjectDataSource1" OnItemCommand="FormView1_ItemCommand">
    <ItemTemplate>
        
  <div class="HTMLform">
     <div class="HTMLpageOkraj">
        <div class="HTMLpage">

            <div style="font-size: 31.6px; width: 100%; text-align: center; font-weight: bold; letter-spacing: 2mm;">ŽÁDOST</div>

            <div style="font-size: 18.43px; width: 100%; text-align: center; font-weight: bold;">o roční zúčtování záloh a daňového zvýhodnění</div>
            <div style="font-size: 18.43px; width: 100%; text-align: center; font-weight: bold; padding:2px;">
              za zdaňovací období
               <div class="roundBorder" style="display:inline-block; padding: 0px 2px 0px 2px; background-color: white; font-size: 17px;">
                 <kspwc:TTextBox ID="H_obd_rok" runat="server" Text='<%# Bind("H_obd_rok") %>' CssClass="input" style="text-align:center;font-size:12px;font-weight:bold;height:20px;" Width="14mm" MaxLength="4" ReadOnly="true"></kspwc:TTextBox>
               </div>
               <sup style="font-size: 10px">1)</sup>
            </div>

            <div class="roundBorder" style="position:relative; padding-top: 2px; width: 100%; height: 105px; background-color: white;">
                <div style="position:absolute; left: 16px; top: 5px; font-size: 10.4px; font-weight: bold;">Identifikace poplatníka</div>
                <div style="position:absolute; left: 16px; top: 28px; font-size: 10.4px; ">Příjmení  <kspwc:TTextBox ID="H_prijmeni_pop"	runat="server" Text='<%# Bind("H_prijmeni_pop") %>' Width="40mm" CssClass="input bottomLine"  ReadOnly="true"></kspwc:TTextBox> </div>
                <div style="position:absolute; left: 260px; top: 28px; font-size: 10.4px; ">Jméno(-a)   <kspwc:TTextBox ID="H_jmeno_pop" runat="server" Text='<%# Bind("H_jmeno_pop") %>' Width="25mm" CssClass="input bottomLine"  ReadOnly="true"></kspwc:TTextBox>    </div>
                <div style="position:absolute; left: 446px; top: 28px; font-size: 10.4px; ">Rodné číslo  <kspwc:TTextBox ID="H_rc_pop"	runat="server" Text='<%# Bind("H_rc_pop") %>' Width="19mm" CssClass="input bottomLine"  ReadOnly="true"></kspwc:TTextBox></div>
                <div style="position:absolute; left: 446px; top: 52px; font-size: 10.4px; ">příp. datum narození <sup>1a)</sup> <kspwc:TTextBox ID="H_datNar_pop"	runat="server" Text='<%# Bind("H_datNar_pop","{0:d}") %>' Width="20mm" CssClass="input bottomLine" ReadOnly="true" MaxLength="10"></kspwc:TTextBox></div>
                <div style="position:absolute; left: 16px; top: 59px; font-size: 10.4px; font-weight: bold;">Identifikace plátce daně (název)</div>
                <div style="position:absolute; left: 16px; top: 80px; font-size: 10.4px; "><kspwc:TTextBox ID="H_nazev_pl"	runat="server" Text='<%# Bind("H_nazev_pl") %>' Width="165mm" CssClass="input bottomLine" ReadOnly="True"></kspwc:TTextBox></div>
            </div>

            <table class="vysvetlivky">
                <tr>
                    <td>1)</td> <td>Uveďte kalendářní rok, za který roční zúčtování záloh a daňového zvýhodnění požadujete provést. </td>
                </tr>
                <tr>
                    <td>1a)</td> <td>U cizích státních příslušníků, kteří nemají přidělené rodné číslo v České republice, uveďte datum narození. </td>
                </tr>
            </table>
            
            <div style="padding-top: 5px; width: 100%; height: 40px; font-size: 10.4px; text-align: justify;">
                V souladu s § 38ch a § 35d zákona č. 586/1992 Sb., o daních z příjmů, ve znění pozdějších předpisů (dále jen „zákon“) žádám o provedení
                 ročního zúčtování záloh na daň a daňového zvýhodnění za uvedené zdaňovací období a současně prohlašuji, <b>že za uvedené</b>  
                <b>zdaňovací období nejsem povinen(-na) podat přiznání k dani z příjmů fyzických osob.</b>
            </div>

            <div style="padding-top: 5px; padding-bottom: 3px; width: 100%; font-size: 10.4px; ">
                <b>Uvádím, že jsem v uvedeném zdaňovacím období pobíral(-a) příjmy ze závislé činnosti od těchto předchozích plátců daně. <sup>2)</sup></b>
            </div>

            <table class="BorderBR BorderRadius" style="width: 100%; height: 80px;">
                <tr>
                  <th class="BorderTL BorderTLRadius" style="height: auto" rowspan="2">V kalendářních<br/> měsících od-do</th>
                  <th class="BorderTL" rowspan="2">Identifikace předchozích plátců daně</th>
                  <th class="BorderTL BorderTRRadius" colspan="3">Údaje z potvrzení o zdanitelných příjmech</th>
                </tr>
                <tr>               
                  <th class="BorderTL">Základ daně ř.5</th>
                  <th class="BorderTL">Zálohy daně ř.8</th>
                  <th class="BorderTL">Bonus ř.9</th>
                </tr>
                <tr style="background-color: white;">                    
                    <td class="BorderTL"> <kspwc:TTextBox ID="P1_mes"	runat="server" Text='<%# Bind("P1_mes") %>' MaxLength="10" Width="21mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P1_nazev"	runat="server" Text='<%# Bind("P1_nazev") %>' MaxLength="50"  Width="85mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P1_prijmy" runat="server" Text='<%# Bind("P1_prijmy") %>' MaxLength="12" Width="20mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P1_dan"	runat="server" Text='<%# Bind("P1_dan") %>' MaxLength="10" Width="14mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P1_bonus"	runat="server" Text='<%# Bind("P1_bonus") %>' MaxLength="10" Width="13mm" Height="5mm"></kspwc:TTextBox> </td>
                </tr>
                <tr style="background-color: white;">                    
                    <td class="BorderTL"> <kspwc:TTextBox ID="P2_mes"	runat="server" Text='<%# Bind("P2_mes") %>' MaxLength="10" Width="21mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P2_nazev"	runat="server" Text='<%# Bind("P2_nazev") %>' MaxLength="50"  Width="85mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P2_prijmy" runat="server" Text='<%# Bind("P2_prijmy") %>' MaxLength="12" Width="20mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P2_dan"	runat="server" Text='<%# Bind("P2_dan") %>' MaxLength="10" Width="14mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P2_bonus"	runat="server" Text='<%# Bind("P2_bonus") %>' MaxLength="10" Width="13mm" Height="5mm"></kspwc:TTextBox> </td>

                </tr>
                <tr style="background-color: white;">                    
                    <td class="BorderTL"> <kspwc:TTextBox ID="P3_mes"	runat="server" Text='<%# Bind("P3_mes") %>' MaxLength="10" Width="21mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P3_nazev"	runat="server" Text='<%# Bind("P3_nazev") %>' MaxLength="50"  Width="85mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P3_prijmy" runat="server" Text='<%# Bind("P3_prijmy") %>' MaxLength="12" Width="20mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P3_dan"	runat="server" Text='<%# Bind("P3_dan") %>' MaxLength="10" Width="14mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P3_bonus"	runat="server" Text='<%# Bind("P3_bonus") %>' MaxLength="10" Width="13mm" Height="5mm"></kspwc:TTextBox> </td>

                </tr>
                <tr style="background-color: white;">
                    <td class="BorderTL BorderBLRadius"> <kspwc:TTextBox ID="P4_mes"	runat="server" Text='<%# Bind("P4_mes") %>' MaxLength="10" Width="21mm" Height="5mm"></kspwc:TTextBox> </td>                    
                    <td class="BorderTL"> <kspwc:TTextBox ID="P4_nazev"	runat="server" Text='<%# Bind("P4_nazev") %>' MaxLength="50" Width="85mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P4_prijmy" runat="server" Text='<%# Bind("P4_prijmy") %>' MaxLength="12" Width="20mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P4_dan"	runat="server" Text='<%# Bind("P4_dan") %>' MaxLength="10" Width="14mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL BorderBRRadius"> <kspwc:TTextBox ID="P4_bonus"	runat="server" Text='<%# Bind("P4_bonus") %>' MaxLength="10" Width="13mm" Height="5mm"></kspwc:TTextBox> </td>

                </tr>
            </table>
            
            <table class="vysvetlivky">
                <tr>
                    <td>
                        2)
                    </td> 
                    <td>
                        Vyplňuje se pouze v případě, že poplatník pobíral od předchozích plátců daně (u kterých učinil prohlášení k dani) postupně příjmy, které vstupují 
                        do ročního zúčtování záloh a daňového zvýhodnění, včetně mezd zúčtovaných nebo vyplacených poplatníkovi těmito plátci dodatečně v době, kdy 
                        poplatník pro ně již nevykonával činnost (§ 38ch odst. 4 zákona), kromě příjmů zdanitelných srážkou podle zvláštní sazby daně a kromě příjmů, které 
                        nejsou předmětem daně nebo jsou od daně osvobozeny.
                    </td>
                </tr>
            </table>
            
            <div style="padding-top: 15px; padding-bottom: 2px; font-size: 15.8px; width: 100%; text-align: center; font-weight: bold;">
                NEZDANITELNÉ ČÁSTI ZÁKLADU DANĚ
            </div>
            
            <table class="BorderBR BorderRadius" style="width: 100%;">
                <tr>
                    <th class="BorderTL BorderTLRadius">Uplatňuji<sup>3)</sup></th>
                    <th class="BorderTL">Nezdanitelné části základu daně podle § 15 zákona</th>
                    <th class="BorderTL BorderTRRadius">Uplatňovaná částka (v Kč)</th>
                </tr>
               <tr style="background-color: white;">
                    <td class="BorderTL">
                        <telerik:RadDropDownList ID="N_dar_x"	runat="server" SelectedValue='<%# Bind("N_dar_x") %>' Width="16mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList></td>
                    <td class="BorderTL">Bezúplatná plnění - dary (odst. 1)</td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="N_dar_c"	runat="server" Text='<%# Bind("N_dar_c") %>' MaxLength="10" Width="38mm"></kspwc:TTextBox> </td>
                </tr>
               <tr style="background-color: white;">
                    <td class="BorderTL">
                        <telerik:RadDropDownList ID="N_uroky_x"	runat="server" SelectedValue='<%# Bind("N_uroky_x") %>' Width="16mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL">Úroky z úvěru na financování bytových potřeb (odst. 3 a 4)</td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="N_uroky_c"	runat="server" Text='<%# Bind("N_uroky_c") %>' MaxLength="10" Width="38mm"></kspwc:TTextBox> </td>
                </tr>
                <tr >
                    <th class="BorderTL">
                        Uplatňuji<sup>3)</sup>
                    </th>
                    <th class="BorderTL">Daňově podporované produkty spoření na stáří a pojištění dlouhodobé péče (odst. 5 a 6)</th>
                    <th class="BorderTL">Uplatňovaná částka (v Kč)<sup>3a)</sup></th>
                </tr>
               <tr style="background-color: white;">
                    <td class="BorderTL">
                        <telerik:RadDropDownList ID="N_penz_x"	runat="server" SelectedValue='<%# Bind("N_penz_x") %>' Width="16mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL">Příspěvek na penzijní připojištění se státním příspěvkem</td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="N_penz_c"	runat="server" Text='<%# Bind("N_penz_c") %>' MaxLength="10" Width="38mm"></kspwc:TTextBox> </td>
                </tr>
                <tr style="background-color: white;">
                    <td class="BorderTL">
                        <telerik:RadDropDownList ID="N_dopln_x"	runat="server" SelectedValue='<%# Bind("N_dopln_x") %>' Width="16mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL">Příspěvek na doplňkové penzijní spoření</td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="N_dopln_c"	runat="server" Text='<%# Bind("N_dopln_c") %>' MaxLength="10" Width="38mm"></kspwc:TTextBox> </td>
                </tr>
                <tr style="background-color: white;">
                    <td class="BorderTL">
                        <telerik:RadDropDownList ID="N_penz2_x"	runat="server" SelectedValue='<%# Bind("N_penz2_x") %>' Width="16mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL">Příspěvek na penzijní pojištění u instituce penzijního pojištění</td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="N_penz2_c"	runat="server" Text='<%# Bind("N_penz2_c") %>' MaxLength="10" Width="38mm"></kspwc:TTextBox> </td>
                </tr>
               <tr style="background-color: white;">
                    <td class="BorderTL">
                        <telerik:RadDropDownList ID="N_zivp_x"	runat="server" SelectedValue='<%# Bind("N_zivp_x") %>' Width="16mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL">Příspěvek pojistného na soukromé životní pojištění</td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="N_zivp_c"	runat="server" Text='<%# Bind("N_zivp_c") %>' MaxLength="10" Width="38mm"></kspwc:TTextBox> </td>
                </tr>
               <tr style="background-color: white;">
                    <td class="BorderTL">
                        <telerik:RadDropDownList ID="N_dip_x"	runat="server" SelectedValue='<%# Bind("N_dip_x") %>' Width="16mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL">Příspěvek na majetek připsaný ve prospěch dlouhodobého investičního produktu</td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="N_dip_c"	runat="server" Text='<%# Bind("N_dip_c") %>' MaxLength="10" Width="38mm"></kspwc:TTextBox> </td>
                </tr>
                <tr style="background-color: white;">
                    <td class="BorderTL BorderBLRadius">
                        <telerik:RadDropDownList ID="N_pece_x"	runat="server" SelectedValue='<%# Bind("N_pece_x") %>' Width="16mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL">Příspěvek pojistného na pojištění dlouhodobé péče</td>
                    <td class="BorderTL BorderBRRadius"> <kspwc:TTextBox ID="N_pece_c"	runat="server" Text='<%# Bind("N_pece_c") %>' MaxLength="10" Width="38mm"></kspwc:TTextBox> </td>
                </tr>
            </table>
                        
            <table class="vysvetlivky">
                <tr>
                    <td>
                        3)
                    </td> 
                    <td>
                        Označte „X“ nezdanitelnou část základu daně, kterou uplatňujete.
                    </td>
                </tr>
                <tr>
                    <td>
                        3a)
                    </td> 
                    <td>
                        Při placení příspěvků na více daňově podporovaných produktů spoření na stáří a na pojištění dlouhodobé péče nelze v celkovém úhrnu uplatňovaných
                        částek překročit maximální zákonem stanovený limit, který v součtu činí 48 000 Kč.
                    </td>
                </tr>
            </table>

            <div style="padding-top: 15px; padding-bottom: 6px; width: 100%; font-size: 10.4px; text-align: justify">
                <b>Prohlášení poplatníka podle § 38k odst. 5 písm. e) zákona k nezdanitelné části základu daně podle § 15 odst. 3 a 4 zákona:</b>
                <b>odpočet úroků</b> ze základu daně, na které uplatňuji nárok z důvodu zaplacených úroků z úvěru použitého na financování bytových potřeb ze
                stavebního spoření, úroků z hypotečního úvěru anebo z jiného úvěru poskytnutého v souvislosti s těmito úvěry, poskytovatelem stavebního
                spoření, bankou, za uvedené zdaňovací období <b>neuplatňuje</b> jiná osoba / <b>uplatňují</b> tyto osoby: <sup>4)</sup>
            </div>

            <table class="BorderBR BorderRadius" style="width: 100%; height: 70px;">
                <tr>
                    <th class="BorderTL BorderTLRadius" style="width: 20%">Jméno</th>
                    <th class="BorderTL" style="width: 25%">Příjmení</th>
                    <th class="BorderTL" style="width: 20%">Rodné číslo<sup>4a)</sup></th>
                    <th class="BorderTL BorderTRRadius">Adresa bydliště (místo trvalého pobytu)</th>
                </tr>
               <tr style="background-color: white;">
                    <td class="BorderTL">
                        <asp:HiddenField runat="server" ID="U1_id" Value='<%# Bind("U1_id") %>'></asp:HiddenField>
                        <kspwc:TTextBox ID="U1_jmeno" runat="server" Text='<%# Bind("U1_jmeno") %>' MaxLength="40" Width="22mm"></kspwc:TTextBox> 
                        <telerik:RadDropDownList ID="DDL_rodprisl1" runat="server" CssClass="Pad0" Width="8mm" Height="5mm" 
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm" 
                            OnSelectedIndexChanged="DDL_rodprisl_SelectedIndexChanged" AutoPostBack="true" ForeColor="White">
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="U1_prijmeni" runat="server" Text='<%# Bind("U1_prijmeni") %>' MaxLength="40" Width="41mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="U1_rc" runat="server" Text='<%# Bind("U1_rc") %>' MaxLength="10" Width="32mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="U1_adresa" runat="server" Text='<%# Bind("U1_adresa") %>' MaxLength="60" Width="60mm"></kspwc:TTextBox> </td>
                </tr>
                <tr style="background-color: white;">
                    <td class="BorderTL BorderBLRadius">
                        <asp:HiddenField runat="server" ID="U2_id" Value='<%# Bind("U2_id") %>'></asp:HiddenField>
                        <kspwc:TTextBox ID="U2_jmeno" runat="server" Text='<%# Bind("U2_jmeno") %>' MaxLength="40" Width="22mm"></kspwc:TTextBox> 
                        <telerik:RadDropDownList ID="DDL_rodprisl2" runat="server" CssClass="Pad0" Width="8mm" Height="5mm" 
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm" 
                            OnSelectedIndexChanged="DDL_rodprisl_SelectedIndexChanged" AutoPostBack="true" ForeColor="White">
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="U2_prijmeni" runat="server" Text='<%# Bind("U2_prijmeni") %>' MaxLength="40" Width="41mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="U2_rc" runat="server" Text='<%# Bind("U2_rc") %>' MaxLength="10" Width="32mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL BorderBRRadius"> <kspwc:TTextBox ID="U2_adresa" runat="server" Text='<%# Bind("U2_adresa") %>' MaxLength="60" Width="60mm"></kspwc:TTextBox> </td>
                </tr>
            </table>

            <table class="vysvetlivky">
                <tr>
                    <td>
                        4)
                    </td> 
                    <td>
                        Tabulku vyplňte pouze v případě, že úroky uplatňuje i jiná osoba/osoby.
                    </td>
                </tr>
                <tr>
                    <td>
                        4a)
                    </td> 
                    <td>
                        U cizích státních příslušníků, kteří nemají přidělené rodné číslo v České republice, uveďte datum narození.
                    </td>
                </tr>
            </table>

            <div style="padding-top: 15px; padding-bottom: 2px; font-size: 10.4px; font-weight: bold;">Uveďte adresu(-y), kde se nachází bytová potřeba, na kterou byl(-y) úvěr(-y) poskytnut(-y):</div>
            <div class="roundBorder" style="width: 100%; height: 60px; background-color: white;">
                 <kspwc:TTextBox ID="U_byt_adresa" runat="server" Text='<%# Bind("U_byt_adresa") %>' MaxLength="150" Width="659px" Height="60px" TextMode="MultiLine"></kspwc:TTextBox>
            </div>

            <table style="padding-top: 20px; font-size: 8px; width:100%">
                <tr>
                    <td style="width:50%">25 5457/B MFin 5457/B - vzor č. 4</td>
                    <td>1</td>
                </tr>
            </table>
        </div><%--HTMLpage--%>
     </div><%--HTMLpageOkraj--%>

     <span class="tiskHide">
        <asp:CustomValidator runat="server" ID="ValidPg1"  OnServerValidate="ValidPg1_ServerValidate" ></asp:CustomValidator>
     </span>

     <div class="HTMLpageOkraj">
        <div class="HTMLpage">
            <div style="width: 100%; font-size: 10px; ">
                <div class="roundBorder" style="display:inline-block; padding: 0px 4px 0px 4px; background-color: white;">
                    <telerik:RadDropDownList ID="U_byt_pred2021"	runat="server" SelectedValue='<%# Bind("U_byt_pred2021") %>' Width="36px" >
                        <Items>
                            <telerik:DropDownListItem Value="" Text="" />
                            <telerik:DropDownListItem Value="X" Text="X" />
                        </Items>
                    </telerik:RadDropDownList>
                </div>
                <sup>4b)</sup>
                <b>Pro úroky z úvěrů použitých na financování bytových potřeb obstaraných před 1. lednem 2021 a refinancování těchto úvěrů</b>
            </div>
            <div style="padding-top: 2px; width: 100%; text-align:justify; font-size: 10px; ">
                Prohlašuji, že předmět bytové potřeby podle § 15 odst. 3 zákona, ve znění zákona před 1. lednem 2021, 
                na který uplatňuji odpočet úroků z poskytnutého úvěru, byl užíván v souladu s § 15 odst. 4 zákona ve znění zákona před 1. lednem 2021,  
                a že částka úroků, o kterou se snižuje základ daně podle § 15 odst. 3 a 4 zákona ve znění zákona před 1. lednem 2021 
                v úhrnu u všech účastníků smluv o úvěrech žijících se mnou ve společně hospodařící domácnosti, nepřekročila v uplynulém zdaňovacím období částku 300 000 Kč. 
                Při placení úroků jen po část roku uplatňovaná částka nepřekročila jednu dvanáctinu této maximální částky za každý měsíc placení úroků.
            </div>

            <div style="padding-top: 5px; width: 100%; font-size: 10px; ">
                <div class="roundBorder" style="display:inline-block; padding: 0px 4px 0px 4px; background-color: white;">
                    <telerik:RadDropDownList ID="U_byt_po2021"	runat="server" SelectedValue='<%# Bind("U_byt_po2021") %>' Width="36px" >
                        <Items>
                            <telerik:DropDownListItem Value="" Text="" />
                            <telerik:DropDownListItem Value="X" Text="X" />
                        </Items>
                    </telerik:RadDropDownList>
                </div>
                <sup>4b)</sup>
                <b>Pro úroky z úvěrů použitých na financování bytových potřeb obstaraných od 1. ledna 2021 a refinancování těchto úvěrů</b> 
            </div>
            <div style="padding-top: 2px; width: 100%; text-align:justify; font-size: 10px; ">
                Prohlašuji, že předmět bytové potřeby podle § 4b odst. 1 zákona, na který uplatňuji odpočet úroků z poskytnutého úvěru, byl užíván v souladu s § 15 odst. 3 a 4 zákona,             
                a že částka úroků, o kterou se snižuje základ daně podle § 15 odst. 4 zákona 
                v úhrnu u všech účastníků smluv o úvěrech žijících se mnou ve společně hospodařící domácnosti, nepřekročila v uplynulém zdaňovacím období částku 150 000 Kč.
                Při placení úroků jen po část roku uplatňovaná částka nepřekročila jednu dvanáctinu této maximální částky za každý měsíc placení úroků.
            </div>
                        
            <table class="vysvetlivky" style="padding-top: 2px;">
                <tr>
                    <td>
                        4b)
                    </td>
                    <td>
                        Označte „X“ odpovídající variantu (úvěry).
                    </td>
                </tr>
            </table>

            <div style="padding-top: 4px; font-size: 10.4px;">
                <b>Upozornění:</b> Při kombinaci výše uvedených úvěrů nelze překročit maximální zákonem stanovený limit, který v součtu činí 300 000 Kč.
            </div>


            <div style="padding-top: 15px; font-size: 15.8px; width: 100%; text-align: center; font-weight: bold;">
                SLEVY NA DANI
            </div>
            <div style="padding-top: 2px; font-size: 10.4px; font-weight: bold; width: 100%; text-align: justify;">
                Kromě slevy na dani a daňového zvýhodnění uplatněného v Prohlášení poplatníka daně z příjmů fyzických
                osob ze závislé činnosti učiněného podle § 38k odst. 4, případně odst. 7 zákona, uplatňuji za výše uvedené zdaňovací období
                nárok na:
            </div>

            <div style="padding-top: 5px; padding-bottom: 2px; font-size: 10.4px; width: 100%; ">
                <b>Slevu za zastavenou exekuci</b> podle § 35 odst. 4 zákona ve výši náhrady přiznané exekutorem při zastavení exekuce.
            </div>

            <table class="BorderBR BorderRadius" style="width: 100%; height: 24px;">
                <tr style="background-color: white;">
                    <td class="BorderTL BorderTLRadius" style="width: 80%;">Výše exekutorem přiznané náhrady (v Kč)<sup>5)</sup></td>
                    <td class="BorderTL BorderTRRadius BorderBRRadius">
                        <kspwc:TTextBox ID="E_castka"	runat="server" Text='<%# Bind("E_castka") %>' MaxLength="10" Width="48mm"></kspwc:TTextBox>
                    </td>
                </tr>
            </table>

            <table class="vysvetlivky">
                <tr>
                    <td>
                        5)
                    </td> 
                    <td>
                        Sleva za jednu zastavenou exekuci může maximálně činit 450 Kč (30 % z 1500 Kč).
                    </td>
                </tr>
            </table>
            
            <div style="padding-top: 5px; padding-bottom: 5px; font-size: 10.4px; width: 100%; text-align: justify;">
                <b>Slevu na manžela (manželku)</b> podle § 35bb zákona a prohlašuji že: <br />
                1) žiji ve společně hospodařící domácnosti nejen s manželem/manželkou, ale i s vyživovaným dítětem, které nedovršilo věku 3 let a současně<br />
                2) manžel/manželka neměl za toto zdaňovací období vlastní příjem, přesahující částku 68 000 Kč.
            </div>

            <table class="BorderBR BorderRadius" style="width: 100%; height: 62px;">
                <tr>
                    <th class="BorderTL BorderTLRadius" style="width: 20%">Údaje o manželovi <br />Jméno</th>
                    <th class="BorderTL">Příjmení</th>
                    <th class="BorderTL">Rodné číslo<sup>6)</sup></th>
                    <th class="BorderTL">Nárok <br/>splněn za <sup>6a)</sup></th>
                    <th class="BorderTL">ZTP/P<sup>6b)</sup></th>
                    <th class="BorderTL BorderTRRadius">Nárok <br/>splněn za <sup>6c)</sup></th>
                </tr>
                <tr style="background-color: white;">
                    <td class="BorderTL BorderBLRadius">
                        <asp:HiddenField runat="server" ID="M_id" Value='<%# Bind("M_id") %>'></asp:HiddenField>
                        <kspwc:TTextBox ID="M_jmeno"	runat="server" Text='<%# Bind("M_jmeno") %>' MaxLength="40" Width="22mm" ReadOnly="true" ToolTip="[%Použij nabídku napravo%]"></kspwc:TTextBox> 
                        <telerik:RadDropDownList ID="DDL_manzelka" runat="server" CssClass="Pad0" Width="8mm" Height="5mm" 
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm" 
                            OnSelectedIndexChanged="DDL_manzelka_SelectedIndexChanged" AutoPostBack="true" ForeColor="White" ToolTip="[%Chybí osoba?%] [%Požádej o doplnění přes požadavek žádost o změnu osobních údajů.%]">
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="M_prijmeni"	runat="server" Text='<%# Bind("M_prijmeni") %>' MaxLength="40" Width="43mm" ReadOnly="true"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="M_rc"	runat="server" Text='<%# Bind("M_rc") %>' MaxLength="10" Width="24mm" ReadOnly="true"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="M_mes"	runat="server" Text='<%# Bind("M_mes") %>' MaxLength="10" Width="15mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> 
                        <telerik:RadDropDownList ID="M_ztp"	runat="server" SelectedValue='<%# Bind("M_ztp") %>' Width="16mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL BorderBRRadius"> <kspwc:TTextBox ID="M_ztp_mes"	runat="server" Text='<%# Bind("M_ztp_mes") %>' MaxLength="10" Width="20mm"></kspwc:TTextBox> </td>
                </tr>
            </table>
            
            <table class="vysvetlivky" style="padding-bottom: 5px; ">
                <tr>
                    <td>
                        6)
                    </td> 
                    <td>
                        U cizích státních příslušníků, kteří nemají přidělené rodné číslo v České republice, uveďte datum narození. 
                    </td>
                </tr>
                <tr>
                    <td>
                        6a)
                    </td> 
                    <td>
                        Uveďte kalendářní měsíce, na jejichž počátku byly splněny podmínky pro uplatnění slevy na manžela. Např. pro dítě narozené 31. 8. uveďte 9–12. 
                        Např. pro dítě, které 1.5. dovršilo věku 3. let, uveďte 1-4. Např. pro dítě, které 2.5. dovršilo věku 3. let, uveďte 1-5.
                    </td>
                </tr>
                <tr>
                    <td>
                        6b)
                    </td> 
                    <td>
                        Označte „X“, pokud byl manželovi (manželce) přiznán nárok na průkaz ZTP/P. 
                    </td>
                </tr>
                <tr>
                    <td>
                        6c)
                    </td> 
                    <td>
                        Uveďte kalendářní měsíce, na jejichž počátku byly splněny podmínky pro dvojnásobnou výši této slevy na dani (z titulu průkazu ZTP/P), např 11–12
                        v případě přiznání průkazu ZTP/P v průběhu měsíce října včetně splnění podmínky společně hospodařící domácnosti s vyživovaným dítětem, které
                        nedovršilo věku 3 let.
                    </td>
                </tr>
            </table>


            <table class="BorderBR BorderRadius" style="width: 100%; height: 82px;">
                <tr>
                    <th class="BorderTL BorderTLRadius" style="width: 25%">Údaje o dítěti<br />Jméno</th>
                    <th class="BorderTL" style="width: 30%">Příjmení</th>
                    <th class="BorderTL">Rodné číslo<sup>7)</sup></th>
                </tr>
               <tr style="background-color: white;">
                    <td class="BorderTL">
                        <asp:HiddenField runat="server" ID="D1_id" Value='<%# Bind("D1_id") %>'></asp:HiddenField>
                        <kspwc:TTextBox ID="D1_jmeno"	runat="server" Text='<%# Bind("D1_jmeno") %>' MaxLength="40" Width="22mm" ReadOnly="true" ToolTip="[%Použij nabídku napravo%]"></kspwc:TTextBox> 
                        <telerik:RadDropDownList ID="DDL_dite1" runat="server" CssClass="Pad0" Width="8mm" Height="5mm" 
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm" 
                            OnSelectedIndexChanged="DDL_dite_SelectedIndexChanged" AutoPostBack="true" ForeColor="White" ToolTip="[%Chybí dítě?%] [%Požádej o doplnění přes požadavek žádost o změnu osobních údajů.%]">
                        </telerik:RadDropDownList>
                        <asp:HiddenField ID="D1_mesice" runat="server" Value='<%# Bind("D1_mesice") %>' />
                    </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="D1_prijmeni"	runat="server" Text='<%# Bind("D1_prijmeni") %>' MaxLength="40" Width="38mm" ReadOnly="true"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="D1_rc"	runat="server" Text='<%# Bind("D1_rc") %>' MaxLength="10" Width="34mm" ReadOnly="true"></kspwc:TTextBox> </td>
                </tr>
                <tr style="background-color: white;">
                    <td class="BorderTL BorderBLRadius">
                        <asp:HiddenField runat="server" ID="D2_id" Value='<%# Bind("D2_id") %>'></asp:HiddenField>
                        <kspwc:TTextBox ID="D2_jmeno"	runat="server" Text='<%# Bind("D2_jmeno") %>' MaxLength="40" Width="22mm" ReadOnly="true"></kspwc:TTextBox> 
                        <telerik:RadDropDownList ID="DDL_dite2" runat="server" CssClass="Pad0" Width="8mm" Height="5mm" 
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm" 
                            OnSelectedIndexChanged="DDL_dite_SelectedIndexChanged" AutoPostBack="true" ForeColor="White">
                        </telerik:RadDropDownList>
                        <asp:HiddenField ID="D2_mesice" runat="server" Value='<%# Bind("D2_mesice") %>' />
                    </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="D2_prijmeni"	runat="server" Text='<%# Bind("D2_prijmeni") %>' MaxLength="40" Width="38mm" ReadOnly="true"></kspwc:TTextBox> </td>
                    <td class="BorderTL BorderBRRadius"> <kspwc:TTextBox ID="D2_rc"	runat="server" Text='<%# Bind("D2_rc") %>' MaxLength="10" Width="34mm" ReadOnly="true"></kspwc:TTextBox> </td>
                </tr>
            </table>

            <table class="vysvetlivky">
                <tr>
                    <td>
                        7)
                    </td> 
                    <td>
                        U dítětě, které nemá přiděleno rodné číslo v České republice, uveďte datum narození. 
                    </td>
                </tr>
            </table>

            <div style="padding-top: 15px; width: 100%; text-align: center; font-size: 15.8px; font-weight: bold;">
                PODPISOVÁ ČÁST
            </div>
            <div style="padding-top: 2px; width: 100%; font-size: 10.4px;">
                Potvrzuji pravdivost a úplnost údajů uvedených v této žádosti o roční zúčtování záloh a daňového zvýhodnění a prokazuji je příslušnými doklady podle § 38l zákona.
            </div>

            <div style="padding-top: 4px; width: 100%; text-align: justify; font-size: 10.4px;">
                Prohlašuji, že jsem si vědom(-a) skutečnosti, že případný rozdíl z nesprávně sražené daně z příjmů fyzických osob ze závislé činnosti,
                případně neoprávněně vyplacené částky na daňovém bonusu z poskytnutého daňového zvýhodnění, který vznikl mým zaviněním,
                mi bude v plné výši včetně úroku z prodlení sražen(-a) na základě dohody s plátcem daně (§ 38i odst. 5 písm. a) zákona). V případě,
                že k dohodě s plátcem daně o sražení dlužné částky nedojde, bude vzniklý rozdíl v souladu s § 38i odst. 5 písm. b) zákona vybrán
                správcem daně prostřednictvím daňového přiznání podle § 38g odst. 4 zákona.
            </div>

            <div style="padding-top: 4px; padding-bottom: 2px; width: 100%; font-size: 10.4px; font-weight: bold;">
                Současně žádám v souladu s § 38k odst. 7 zákona o dodatečné uplatnění slev na dani / daňového zvýhodnění <sup>8)</sup>
                <div class="roundBorder" style="display:inline-block; padding: 0px 4px 0px 4px; background-color: white;">
                    <telerik:RadDropDownList ID="H_dod_priz"	runat="server" SelectedValue='<%# Bind("H_dod_priz") %>' Width="40px" 
                        ToolTip="[%Vyplňte i prohlášení daně s volbou dodatečně činím!%]">
                        <Items>
                            <telerik:DropDownListItem Value="" Text="" />
                            <telerik:DropDownListItem Value="X" Text="X" />
                        </Items>
                    </telerik:RadDropDownList>
                </div>
            </div>
            
            <table class="BorderBR BorderRadius" style="width: 100%; height: 85px;">
                <tr>
                    <th class="BorderTL BorderTLRadius" style="width: 30%; height: 56%;"></th>
                    <th class="BorderTL" style="width: 35%">Žádost o roční zúčtování záloh a daňového<br />zvýhodnění učiněná<sup>8a)</sup><br />(písemně, elektronicky) a datum</th>
                    <th class="BorderTL BorderTRRadius">Ověření plátcem daně<sup>8b)</sup><br />(písemně, elektronicky) a datum</th>
                </tr>
                <tr style="background-color: white;">
                    <td class="BorderTL BorderBLRadius" style="text-align: center">Za uvedené zdaňovací období</td>
                    <td class="BorderTL">
                        <%--<kspwc:TTextBox ID="P_zad_kod" runat="server" Text='<%# Bind("P_zad_kod") %>' Width="30mm" ReadOnly="True"></kspwc:TTextBox>
                        <kspwc:TTextBox ID="P_d_zadosti" runat="server" Text='<%# Bind("P_d_zadosti","{0:d}") %>' Width="16mm" ReadOnly="True"></kspwc:TTextBox>
                        <telerik:RadButton ID="btn_podepsat" runat="server" Text="[%Podepsat%]" CommandName="podp_bezne_popl" Font-Size="2.75mm"></telerik:RadButton>--%>
                        
                        <kspwc:TTextBox ID="P_zad_kod" runat="server" Text='<%# Eval("P_zad_kod") %>' Width="38mm"></kspwc:TTextBox>
                        <kspwc:TTextBox ID="P_d_zadosti" runat="server" Text='<%# Eval("P_d_zadosti","{0:d}") %>' Width="19mm"></kspwc:TTextBox>
                        <telerik:RadButton ID="btn_podepsat" runat="server" Text="[%Podepsat%]" Font-Size="2.75mm" AutoPostBack="False" OnClientClicked="Podepsat"></telerik:RadButton>
                    </td>
                    <td class="BorderTL BorderBRRadius">
                        <kspwc:TTextBox ID="P_over_kod" runat="server" Text='<%# Bind("P_over_kod") %>' Width="38mm"></kspwc:TTextBox>
                        <kspwc:TTextBox ID="P_d_over" runat="server" Text='<%# Bind("P_d_over","{0:d}") %>' Width="19mm"></kspwc:TTextBox>
                        <telerik:RadButton ID="btn_overeno" runat="server" Text="[%Podepsat%]" Font-Size="2.75mm" AutoPostBack="False" ></telerik:RadButton>
                    </td>
                </tr>
            </table>

            <table class="vysvetlivky">
                <tr>
                    <td>
                        8)
                    </td> 
                    <td>
                        V případě, že v souladu s § 38k odst. 7 zákona uplatňujete slevy na dani podle § 35ba odst. 1 písm. a,c,d,e) příp. daňové zvýhodnění dodatečně
                        v rámci žádosti o roční zúčtování záloh a daňového zvýhodnění, pak označte „X“ a pro uplatnění použijte tiskopis Prohlášení poplatníka daně z příjmů
                        fyzických osob ze závislé činnosti na příslušné zdaňovací období a postupujte při vyplnění dle „upozornění“ na str. 2 tohoto tiskopisu MFin 5457. 
                    </td>
                </tr>
                <tr>
                    <td>
                        8a)
                    </td> 
                    <td>
                        Rozumí se projev vůle poplatníka, buď písemně (podpis) nebo elektronicky. 
                    </td>
                </tr>
                <tr>
                    <td>
                        8b)
                    </td> 
                    <td>
                        Plátce daně ověřil nárok na nezdanitelné části základu daně podle § 15 zákona, nárok na slevy na dani podle zákona. 
                    </td>
                </tr>
            </table>

            
            <div style="padding-top: 8px; width: 100%; text-align: center; font-size: 15.8px; font-weight: bold;">
                DALŠÍ ZÁZNAMY
            </div>
            <div class="roundBorder" style="padding-top: 1px; background-color: white;">
                <kspwc:TTextBox ID="H_zaznamy" runat="server" Text='<%# Bind("H_zaznamy") %>' MaxLength="999" Width="99%" Height="70px" TextMode="MultiLine"></kspwc:TTextBox>
            </div>

            <div style="padding-top: 8px; width: 100%; text-align: center; font-size: 7.9px; ">2</div>            
         </div>
     </div>    
     <span class="tiskHide">
          <asp:CustomValidator runat="server" ID="ValidPg2" OnServerValidate="ValidPg2_ServerValidate" ></asp:CustomValidator>
     </span>
  </div><%--HTMLForm--%>
    </ItemTemplate>
</asp:FormView>

<telerik:RadScriptBlock ID="ZRZ_RadScriptBlock1" runat="server">
    <script language="javascript" type="text/javascript">
        function Podepsat(sender, args) {
            var datum = sender.get_element().previousElementSibling;
            var jmeno = datum.previousElementSibling;

            jmeno.value = "<%= KSProgram.Funkce.Pracovnik.PrijmeniJmeno(KSProgram.Globals.OsCisloAktUserNeboZastupovany)  %>";
            datum.value = "<%= DateTime.Today.ToString("d") %>";

            $("#" + jmeno.id).removeClass("hide");
            $("#" + datum.id).removeClass("hide");
            sender.set_visible(false);
        }

    </script>
</telerik:RadScriptBlock>