﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="UzivPopup.ascx.cs" Inherits="KSPortal.Controls.UzivPopup" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>


<telerik:RadCodeBlock ID="RadScriptBlock1" runat="server">
    <style type="text/css">
        .RadUpload .ruStyled .ruFileInput {
            width: 100%;
            height: 100%;
        }

        .fotoEdit {
            position: absolute;
            margin-left: 110px;
            margin-top: -50px;
            background: white !important;
        }

        .popupPanel {
            display: grid;
            grid-template-columns: auto auto;
        }

            .popupPanel > div {
                margin: 10px;
                width: calc(100% - 10px);
            }

        .popupCheck {
            margin-right: 10px;
            margin-left: 10px;
        }
    </style>
    <script type="text/javascript">

        var url = parent.document.location.href;
        if (url.includes("UzivPopup.aspx")) {
            document.location.href = "<%=this.ResolveUrl(@"~/")%>";
        }

        function closeWin() {
            GetRadWindow().close();
            var url = parent.document.location.href;
            GetRadWindow().BrowserWindow.location.href = url;
        }
        function GetRadWindow() {
            var oWindow = null;
            if (window.radWindow) oWindow = window.radWindow;
            else if (window.frameElement.radWindow) oWindow = window.frameElement.radWindow;
            return oWindow;
        }
        function OnClientItemsRequesting(sender, eventArgs) {
            var context = eventArgs.get_context();
            context["os_cislo"] = KSMaster.HF_sel_os_cislo.value;
            context["cislo_pom"] = KSMaster.HF_sel_cislo_pom.value;
            context["sender"] = "D";
        }

        function fileUploaded(sender, args) {
            $find("<%= RadAjaxManager.GetCurrent(Page).ClientID %>").ajaxRequest(args.get_fileName());
            sender.deleteAllFileInputs();
        }

        function fotoPanelShow() {
            var panel = $get("<%= fotoPanel.ClientID %>");
            if (panel.style.display == "none") panel.style.display = "block";
            else panel.style.display = "none";
        }
    </script>
</telerik:RadCodeBlock>
<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="RadAjaxManagerProxy1">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="Thumbnail" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>

<div class="popupPanel">
    <div>
        <div style="width: fit-content; margin: auto">
            <asp:Image ID="Thumbnail" runat="server" CssClass="profileImg" Height="150" Width="150" />
            <kspwc:TRadButton ID="TRB_EditFoto" runat="server" Icon-PrimaryIconCssClass="fi fi-edit" OnClientClicked="fotoPanelShow"
                AutoPostBack="false" CssClass="fotoEdit kstlacitko">
            </kspwc:TRadButton>
        </div>
        <div id="fotoPanel" runat="server" style="display: none; width: fit-content; margin: auto;">
            <telerik:RadAsyncUpload OnLoad="telerikUpl_Load" runat="server" ID="telerikUpl" DropZones=".DropZone,.DropZone2" MultipleFileSelection="Disabled" MaxFileInputsCount="1"
                AllowedFileExtensions=".jpg" data-clientFilter="image/jpg"
                AutoAddFileInputs="true" OnClientFileUploaded="fileUploaded" TemporaryFolder="~/Temp">
                <Localization DropZone="[%Zde pusťte soubor%]" Remove="[%Odstranit%]" />
            </telerik:RadAsyncUpload>
            <div style="width: fit-content; margin: auto;">
                <kspwc:TSaveButton runat="server" ID="TRB_foto_save" ToggleType="None" ButtonType="StandardButton" Text="[%Zveřejnit%]" OnClick="TRB_foto_save_Click" />
                <kspwc:TRadButton runat="server" ID="rb_cancel" Icon-PrimaryIconCssClass="fi fi-ban" ToggleType="None" ButtonType="StandardButton" Text="[%Zrušit%]" OnClick="rb_cancel_Click" />
            </div>
        </div>

        <div style="margin: 10px 0;">
            <kspwca:TitledPanel ID="uziv_nastaveni" runat="server" CssClass="cItem" Width="100%">
                <TitleTemplate>
                    [%Volby pro aktuální sezení%]
                </TitleTemplate>
                <ContentTemplate>
                    <telerik:RadButton ID="rbtJenPrimePodrizene" runat="server" ToggleType="CheckBox" CssClass="popupCheck"
                        ButtonType="ToggleButton" Text="[%Omezit přístup jen na přímé podřízené%]" AutoPostBack="true"
                        OnCheckedChanged="rbtJenPrimePodrizene_CheckedChanged" OnLoad="rbtJenPrimePodrizene_Load">
                        <ToggleStates>
                            <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox"></telerik:RadButtonToggleState>
                            <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square"></telerik:RadButtonToggleState>
                        </ToggleStates>
                    </telerik:RadButton>
                    <br />
                    <telerik:RadButton ID="rbtVyjmoutMimoevS" runat="server" ToggleType="CheckBox" OnLoad="rbtVyjmoutMimoevS_Load" CssClass="popupCheck"
                        ButtonType="ToggleButton" Text="[%Ze seznamů vyjmout zaměstnance v mimoevidenčním stavu%]" AutoPostBack="true" OnCheckedChanged="rbtVyjmoutMimoevS_CheckedChanged">
                        <ToggleStates>
                            <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox"></telerik:RadButtonToggleState>
                            <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square"></telerik:RadButtonToggleState>
                        </ToggleStates>
                    </telerik:RadButton>
                    <br />
                    <telerik:RadButton ID="rbGenerujSlovnik" runat="server" ToggleType="CheckBox" OnLoad="rbGenerujSlovnik_Load" CssClass="popupCheck"
                        ButtonType="ToggleButton" Text="[%Generování zákaznického slovníku%]" AutoPostBack="true" OnCheckedChanged="rbGenerujSlovnik_CheckedChanged">
                        <ToggleStates>
                            <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox"></telerik:RadButtonToggleState>
                            <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square"></telerik:RadButtonToggleState>
                        </ToggleStates>
                    </telerik:RadButton>
                </ContentTemplate>
            </kspwca:TitledPanel>
        </div>
        <kspwca:TitledPanel ID="tp_dochazka" runat="server" CssClass="cItem" TitleText="[%Docházka%]" Width="100%">
            <ContentTemplate>
                <div style="padding: 10px;">
                    <asp:Label runat="server" ID="lab_impl_kod" Text="[%Implicitní kód pro zadávání v měs. sumaci%]:"></asp:Label>
                    <telerik:RadComboBox runat="server" ID="ddlKod" OnLoad="ddlKod_Load"
                        AutoPostBack="true" EnableLoadOnDemand="True"
                        ShowMoreResultsBox="true" DataTextField="cely_nazev" DataValueField="kod"
                        OnClientItemsRequesting="OnClientItemsRequesting" OnSelectedIndexChanged="ddlKod_SelectedIndexChanged"
                        EnableVirtualScrolling="false" >
                        <WebServiceSettings Method="GetKodyDochazka" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                    </telerik:RadComboBox>
                </div>
            </ContentTemplate>
        </kspwca:TitledPanel>
        <br />
        <kspwc:TRadButton runat="server" ID="rb_zmena_hesla" AutoPostBack="true" Text="[%Změna hesla%]" OnClick="rb_zmena_hesla_Click" Icon-PrimaryIconCssClass="fi fi-lock"></kspwc:TRadButton>
        <br />
    </div>

    <div>
        <div style="min-width: 200px">
            <kspwc:TDataList runat="server" ID="dl_role" DataSourceID="RadSiteMapDataSource1" CssClass="cItem" Width="100%">
                <ItemTemplate>
                    <span class="Header">- <%# DataBinder.Eval(Container.DataItem, "role") %> </span>
                </ItemTemplate>
                <HeaderTemplate>
                    [%Role%]
                </HeaderTemplate>
            </kspwc:TDataList>
        </div>
        <div id="uzivProfil" runat="server">
            <kspwc:TRadGrid ID="TRadGrid_uziv_ucty" runat="server" AllowPaging="True" class="cItem"
                AllowSorting="true" AutoGenerateColumns="false" CssClass="revertShadow"
                DataSourceID="ZdrojDatUzivUcty" AutoFilterControlWidth="false" MasterTableView-ShowFooter="False" OnDataBound="TRadGrid_uziv_ucty_DataBound">
                <GroupingSettings CaseSensitive="False" CollapseAllTooltip="Collapse all groups"></GroupingSettings>
                <ClientSettings>
                    <Selecting AllowRowSelect="True" />
                    <%--Dovolí vybrat položku z tabulky --%>
                </ClientSettings>
                <MasterTableView Caption="[%Výběr uživatelského profilu%]" CommandItemDisplay="Top" PagerStyle-Visible="false" DataKeyNames="ev_udaj">
                    <Columns>
                        <telerik:GridBoundColumn DataField="poradi" HeaderText="[%Čís. profilu%]" Display="true" />
                        <telerik:GridBoundColumn DataField="id" HeaderText="id" Display="true" />
                        <telerik:GridBoundColumn DataField="profil" HeaderText="[%Název profilu%]" SortExpression="profil" />
                        <telerik:GridBoundColumn DataField="delegace" HeaderText="[%Mož. delegovat%]" SortExpression="delegace" Visible="false" />
                        <telerik:GridDateTimeColumn DataField="pristup_od" HeaderText="[%Přist. od%]" SortExpression="pristup_od"
                            DataFormatString="{0:d.M.yyyy}" Visible="false" />
                        <telerik:GridDateTimeColumn DataField="pristup_do" HeaderText="[%Přist. do%]" SortExpression="pristup_do"
                            DataFormatString="{0:d.M.yyyy}" Visible="false" />
                        <telerik:GridBoundColumn DataField="vychozi_portal" HeaderText="[%Výchozí profil%]" SortExpression="vychozi_portal" />
                        <telerik:GridBoundColumn DataField="rad_prava" HeaderText="[%Druh řádkových práv%]" SortExpression="rad_prava" Display="false" />
                        <telerik:GridBoundColumn DataField="druh_rad_prav" HeaderText="[%Druh rad. práv%]" SortExpression="druh_rad_prav" Display="false" />
                        <telerik:GridBoundColumn DataField="role_id" HeaderText="[%Role ID%]" SortExpression="role_id" Display="false" />
                    </Columns>

                    <CommandItemTemplate>
                    </CommandItemTemplate>
                </MasterTableView>
            </kspwc:TRadGrid>
            <br />
            <table>
                <tr>
                    <td>
                        <kspwc:TRadButton ID="Zvolit" Text="[%Zvolit%]" runat="server" AutoPostBack="true" OnClick="BtnZvolit_Clicked" Icon-PrimaryIconCssClass="fi fi-file-user"></kspwc:TRadButton>
                    </td>
                    <td>
                        <kspwc:TRadButton ID="Nastavit" Text="[%Nastavit jako výchozí%]" runat="server" AutoPostBack="true" OnClick="BtnVychozi_Clicked" Icon-PrimaryIconCssClass="fi fi-user-add"></kspwc:TRadButton>
                    </td>
                    <td>
                        <kspwc:TRadButton ID="Zrusit" Text="[%Zrušit výchozí profil%]" runat="server" AutoPostBack="true" OnClick="BtnZrus_Clicked" Icon-PrimaryIconCssClass="fi fi-delete-user"></kspwc:TRadButton>
                    </td>
                </tr>
            </table>
            <asp:Label ID="FailureLabel2" Text="" runat="server" ForeColor="Red" Font-Size="Small"></asp:Label>
            <br />
        </div>
        <div id="profil_zastup_info" runat="server" style="font-weight:500; font-size:medium; padding-top:10px; color:blue;">
            [%Přihlášený uživatel má zapnut zástup za osobní číslo. Nelze pracovat s profily.%]
        </div>
    </div>
    <asp:ObjectDataSource runat="server" ID="RadSiteMapDataSource1" SelectMethod="GetRole"
        TypeName="KSPortal.Controls.UzivPopup"></asp:ObjectDataSource>

    <asp:ObjectDataSource ID="ZdrojDatUzivUcty" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="UzivatelskeUcty" TypeName="KSProgram.Personal.UzivProfily"></asp:ObjectDataSource>

</div>
