﻿<%@ Control Language="C#" AutoEventWireup="true"
    Inherits="Controls_SchemaSettings" Codebehind="SchemaSettings.ascx.cs" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls.Schema" TagPrefix="cc2" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajx" %>
<%@ Register Assembly="WebControlsAlone" Namespace="KSProgram.WebControlsAlone" TagPrefix="wca" %>
<%@ Register Src="~/Controls/TextProperties.ascx" TagName="text_format" TagPrefix="uc1" %>
<%@ Register Assembly="zdroje" Namespace="KSProgram.Systemizace" TagPrefix="cc1" %>
<asp:Wizard ID="Wizard1" runat="server" SideBarStyle-VerticalAlign="Top" StepStyle-VerticalAlign="Top"
    StepStyle-Width="1000" StepStyle-Height="300" SideBarStyle-BackColor="#E0E0E0"
    NavigationStyle-BackColor="#E0E0E0" HeaderStyle-BackColor="#E0E0E0" SideBarStyle-Width="110"
    ActiveStepIndex="3" FinishCompleteButtonText="Hotovo" FinishPreviousButtonText="Zpět"
    StartNextButtonText="Následující" StepNextButtonText="Následující" CssClass="ksprvek" 
    StepPreviousButtonText="Zpět">
    <HeaderStyle BackColor="#E0E0E0"></HeaderStyle>
    <HeaderTemplate>
        <table>
            <tr>
                <td>
                    <asp:Label ID="Label_header" Text="[%Konfigurace systemizačního schématu%]" runat="Server"
                        Font-Size="12pt" Font-Bold="True" />
                </td>
                <td>
                    <asp:Label ID="Label_druh" Text="" runat="Server" Font-Size="12pt" Font-Bold="True" />
                </td>
            </tr>
        </table>
    </HeaderTemplate>
    <NavigationStyle BackColor="#E0E0E0"></NavigationStyle>
    <SideBarStyle VerticalAlign="Top" BackColor="#E0E0E0" Width="110px"></SideBarStyle>
    <StepStyle VerticalAlign="Top" Height="300px" Width="1000px"></StepStyle>
    <WizardSteps>
        <asp:WizardStep runat="server" Title="Název">
            <asp:Label runat="server" ID="label_nazev" Text="[%Název schématu%]" ></asp:Label>
            <asp:TextBox ID="TextBox_nazev" runat="server"></asp:TextBox>
        </asp:WizardStep>
        <asp:WizardStep ID="WizardStep1" runat="server" Title="[%Obsah boxu%]">
            <table style="color: var(--kscolor2text)">
                <tr>
                    <td>
                        <asp:Label runat="server" ID="labr1" Text="[%Řádek č.%] 1:"></asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList runat="server" ID="DropDownList1">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label runat="server" ID="Label1" Text="[%Řádek č.%] 2:"></asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList runat="server" ID="DropDownList2">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label runat="server" ID="Label2" Text="[%Řádek č.%] 3:"></asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList runat="server" ID="DropDownList3">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label runat="server" ID="Label3" Text="[%Řádek č.%] 4:"></asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList runat="server" ID="DropDownList4">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label runat="server" ID="Label4" Text="[%Řádek č.%] 5:"></asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList runat="server" ID="DropDownList5">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label runat="server" ID="Label9" Text="[%Řádek č.%] 6:"></asp:Label>
                    </td>
                    <td>
                        <asp:DropDownList runat="server" ID="DropDownList6">
                        </asp:DropDownList>
                    </td>
                </tr>
            </table>
        </asp:WizardStep>
        <asp:WizardStep ID="WizardStep" runat="server" Title="Vzhled boxu">
            <table style="border-collapse: collapse">
                <tr style="vertical-align: middle">
                    <td>
                        <asp:Label runat="server" ID="label_barva_pozadi" Text="[%Barva pozadí plochy%]"></asp:Label>
                    </td>
                    <td>
                        <wca:ColorPicker runat="server" ID="ColorPozadi"></wca:ColorPicker>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label runat="server" ID="label_barva_car" Text="[%Barva spojovacích čar%]"></asp:Label>
                    </td>
                    <td>
                        <wca:ColorPicker runat="server" ID="ColorCary"></wca:ColorPicker>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label runat="server" ID="label_barva_ip" Text="[%Šířka boxu%]"></asp:Label>
                    </td>
                    <td>
                        <asp:TextBox runat="server" ID="SirkaInf" Width="30" MaxLength="3"></asp:TextBox>
                        <ajx:FilteredTextBoxExtender ID="ftbe" runat="server" TargetControlID="SirkaInf"
                            ValidChars="1234567890" />
                    </td>
                </tr>
            </table>
            <uc1:text_format ID="text_prop" runat="server" />
            <asp:LinkButton runat="server" ID="lb_nastavit" Text="[%Nastavit%]" SkinID="button" OnCommand="lb_nastavit_Command"></asp:LinkButton>
            <br />        
           
            <cc2:SystemSchemaChlivek ID="chlivek_vzor" runat="server">
            </cc2:SystemSchemaChlivek>

        </asp:WizardStep>
         <asp:WizardStep ID="WizardStep2" runat="server" Title="[%Úprava řádků%]">
             <table style="border-collapse: collapse">
                <tr style="vertical-align: middle">
                    <td><asp:Label runat="server" ID="lab_vyska_radku" Text="[%Výška řádku%]"></asp:Label></td>
                    <td>
                        <asp:TextBox runat="server" ID="text_vyska_radku" Text="" Width="30"></asp:TextBox>
                        <ajx:FilteredTextBoxExtender ID="FilteredTextBoxExtender1" runat="server" TargetControlID="text_vyska_radku"
                                ValidChars="1234567890" />
                    </td>
                </tr>
            </table> 
            <uc1:text_format ID="text_radky" runat="server" />
     
            <asp:LinkButton runat="server" ID="lb_nastav" Text="[%Nastavit%]" 
                 OnCommand="lb_nastav_radky_Command"></asp:LinkButton>
            <br />      
            
            <cc2:SystemSchemaChlivek ID="chlivek_vzor_radky" VyberZapnut="true"  runat="server"  OnChangedRow="chlivek_vzor_radky_rowChanged" >
             </cc2:SystemSchemaChlivek>

         </asp:WizardStep>
        <asp:WizardStep runat="server" Title="Typ">
            <table style="border-collapse: collapse">
                <tr>
                    <td style="text-align: left">
                        <asp:DropDownList runat="server" ID="ddl_typy" OnSelectedIndexChanged="ddl_typy_SelectedIndexChanged"
                            AutoPostBack="True">
                            <asp:ListItem Value="v_obr_radkovy" Text="[%Řádkový s fotem%]"></asp:ListItem>
                            <asp:ListItem Value="v_radkovy" Text="[%Řádkový%]"></asp:ListItem>
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:MultiView runat="server" ID="mv_typ">
                            <asp:View runat="server" ID="v_radkovy">
                                <table style="border-style: solid; border-width: 1px; border-bottom-color: Gray;
                                    width: 200px; border-collapse: collapse;">
                                    <tr style="height: 20px">
                                        <td style="border-style: solid; border-width: 1px; border-bottom-color: Gray;">
                                        </td>
                                    </tr>
                                    <tr style="height: 20px">
                                        <td style="border-style: solid; border-width: 1px; border-bottom-color: Gray;">
                                        </td>
                                    </tr>
                                    <tr style="height: 20px">
                                        <td style="border-style: solid; border-width: 1px; border-bottom-color: Gray;">
                                        </td>
                                    </tr>
                                    <tr style="height: 20px">
                                        <td style="border-style: solid; border-width: 1px; border-bottom-color: Gray;">
                                        </td>
                                    </tr>
                                    <tr style="height: 20px">
                                        <td style="border-style: solid; border-width: 1px; border-bottom-color: Gray;">
                                        </td>
                                    </tr>
                                </table>
                            </asp:View>
                            <asp:View runat="server" ID="v_obr_radkovy">
                                [%obrázkovy%]
                            </asp:View>
                        </asp:MultiView>
                    </td>
                </tr>
            </table>
        </asp:WizardStep>
    </WizardSteps>
</asp:Wizard>
