﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="Graf.ascx.cs" Inherits="KSPortal.Controls.Graf" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<telerik:RadAjaxManagerProxy runat="server" ID="RAMP_uc_sa">
    <AjaxSettings>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>

<telerik:RadCodeBlock ID="RadScriptBlock1" runat="server">

    <script type="text/javascript" src="../kendo/js/kendo.all.min.js"></script>
    <script type="text/javascript" id="telerikClientEvents1">

        var nazev;
        var osaX;
        var osaY;

        function createLineChart() {
            $("#chart").kendoChart({
                title: {
                    text: nazev
                },
                legend: {
                    position: "bottom"
                },
                seriesDefaults: {
                    type: "line"
                },
                series: osaY,
                valueAxis: {
                    labels: {
                        format: "{0}",
                        rotation: "auto"
                    }
                },
                categoryAxis: {
                    categories: osaX,
                },
                tooltip: {
                    visible: true,
                    shared: true,
                    format: "N0",
                },

            });
        }

        function createPieChart() {
            $("#chart").kendoChart({
                title: {
                    text: nazev
                },
                legend: {
                    position: "bottom"
                },
                seriesDefaults: {
                    labels: {
                        visible: true,
                        format: "{0}"
                    }
                },
                series: [{
                    type: "pie",
                    data: osaX
                }]
            });
        }


    </script>
</telerik:RadCodeBlock>

<div id="GrafWrapper" runat="server" class="grafWrapper">

    <table id="GrafCommandTable" runat="server" class="grafCommandItems">
        <tbody>
            <tr>
                <td>
                    <kspwc:TLabel runat="server" Text="[%Typ grafu%]"></kspwc:TLabel>
                </td>
                <td>
                    <kspwc:TLabel runat="server" ID="Label_osaX" Text="[%Osa X%]"></kspwc:TLabel>
                </td>
                <td>
                    <kspwc:TLabel runat="server" ID="Label_osaY" Text="[%Osa Y%]"></kspwc:TLabel>
                </td>
                <td>
                    <kspwc:TLabel runat="server" ID="Label_seskupit" Text="[%Seskupit podle%]"></kspwc:TLabel>
                </td>
            </tr>
            <tr>
                <td>
                    <kspwc:TDropDown ID="TDD_TypGrafu" runat="server" OnSelectedIndexChanged="DDL_TypGrafu_SelectedIndexChanged" AutoPostBack="true">
                        <asp:ListItem Value="Line">[%Spojnicový graf%]</asp:ListItem>
                        <asp:ListItem Value="Pie">[%Koláčový graf%]</asp:ListItem>
<%--                        <asp:ListItem Value="Bar">[%Sloupcový graf%]</asp:ListItem>
                        <asp:ListItem Value="Area">[%Plošný graf%]</asp:ListItem>
                        <asp:ListItem Value="Categorical">[%Kategorický sloupcový graf%]</asp:ListItem>--%>
                    </kspwc:TDropDown>
                </td>
                <td>
                    <kspwc:TDropDown ID="TDD_OsaX" runat="server"></kspwc:TDropDown>
                </td>
                <td>
                    <kspwc:TDropDown ID="TDD_OsaY" runat="server"></kspwc:TDropDown>
                </td>
                <td>
                    <kspwc:TDropDown ID="TDD_Seskupit" runat="server"></kspwc:TDropDown>
                </td>
                <td>
                    <kspwc:TRadButton runat="server" ID="TRB_Prekresli" OnClick="TRB_Prekresli_Click" Text="[%Překresli%]" Icon-PrimaryIconCssClass="fi fi-chart-line-up"></kspwc:TRadButton>
                </td>
            </tr>
        </tbody>
    </table>

    <div id="GrafBody" class="grafBody">
        <div id="chart" class="ksgraf"></div>
    </div>
</div>

<style type="text/css">
    .grafWrapper {
        background: var(--kscolor2);
        color: var(--kscolor2text);
        display: flex;
        flex-direction: column;
        padding: 20px;
        border: 1px solid lightgrey;
    }

        .grafWrapper .nadpis1 {
            width: fit-content;
            margin: auto;
            display: inherit;
        }

    .ksgraf {
        width: 100%;
        height: 100%;
    }

    .grafCommandItems {
        width: fit-content;
        height: fit-content;
        margin-left: 20px;
    }

    .grafBody {
        margin: auto;
        width: 100%;
        height: 100%;
        background: white;
    }
</style>
