﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="FotitControl.ascx.cs" Inherits="KSPortal.Controls.FotitControl" %>
<%@ Register assembly="Telerik.Web.UI" namespace="Telerik.Web.UI" tagprefix="telerik" %>
<div class="container">
  <div class="app">
    <table>
        <tr>
            <td>
                 <a href="#" id="start-camera" class="visible">Touch here to start the app.</a>
        <video id="camera-stream"></video>
            </td>
            <td style="padding-left:20px;">
                 <asp:Image runat="server" ID="img_red" CssClass="img_red" ImageUrl="~/ImagesN/AccessRed.png" />
            </td>
        </tr>
    </table>
       
   
    <%--<img id="snap">   --%> 
    

    <p id="error-message"></p>

   <%-- <div class="controls">
      <a href="#" id="delete-photo" title="Delete Photo" class="disabled"><i class="material-icons">delete</i></a>
      <a href="#" id="take-photo" title="Take Photo"><i class="material-icons">camera_alt</i></a>
      <a href="#" id="download-photo" download="selfie.png" title="Save Photo" class="disabled"><i class="material-icons">file_download</i></a>  
    </div>--%>

    <!-- Hidden canvas element. Used for taking snapshot of video. -->
    <canvas></canvas>

  </div>

</div>

<telerik:RadScriptBlock ID="RadCodeBlock2" runat="server">
     <style>
         .app {
             width: 100%;
             position: relative;
         }
             .app #start-camera {
                 display: none;
                 border-radius: 3px;
                 max-width: 400px;
                 color: #fff;
                 background-color: #448AFF;
                 text-decoration: none;
                 padding: 15px;
                 opacity: 0.8;
                 margin: 50px auto;
                 text-align: center;
             }

             .app video#camera-stream {
                 display: none;
                 width: 80px;
                 height: 100px;
             }

             .app img#snap {
                 position: absolute;
                 top: 0;
                 left: 0;
                 width: 100%;
                 z-index: 10;
                 display: none;
             }

             .app #error-message {
                 width: 400px;
                 height: 50px;
                 background-color: #ccc;
                 color: #9b9b9b;
                 /*font-size: 28px;
                 padding: 200px 100px;*/
                 text-align: center;
                 display: none;
             }

             .app canvas {
                 display: none;
             }

             .app video#camera-stream.visible,
             .app img#snap.visible,
             .app #error-message.visible {
                 display: block;
             }

             .not_visible
             {
                 display:none;
             }
             .visible
             {
                 display:block;
             }         
             
    </style>

    <script type="text/javascript">
        KSMaster.FotoSendUrl="";
        // References to all the element we will need.
        var video = document.querySelector('#camera-stream'),
            /*image = document.querySelector('#snap'),*/
            start_camera = document.querySelector('#start-camera'),
            error_message = document.querySelector('#error-message'),           
            img_red = document.querySelector('.img_red');

        img_red.classList.add("not_visible");

        /*
        // The getUserMedia interface is used for handling camera input.
        // Some browsers need a prefix so here we're covering all the options
        navigator.getMedia = (navigator.getUserMedia ||
                              navigator.webkitGetUserMedia ||
                              navigator.mozGetUserMedia ||
                              navigator.msGetUserMedia);

       

        if (!navigator.getMedia) {
            displayErrorMessage("Your browser doesn't have support for the navigator.getUserMedia interface.");
        }
        else {

            // Request the camera.
            navigator.getMedia(
              {
                  video: true
              },
              // Success Callback
              function (stream) {

                  // Create an object URL for the video stream and
                  // set it as src of our HTLM video element.
                  //video.src = window.URL.createObjectURL(stream);
                  //PH 18.10.2018
                  video.srcObject = stream;

                  // Play the video element to start the stream.
                  video.play();
                  video.onplay = function () {
                      showVideo();
                  };

              },
              // Error Callback
              function (err) {
                  displayErrorMessage("There was an error with accessing the camera stream: " + err.name, err);
              }
            );

        }
        */

        //PH 18.11.2019 HID:48833
        navigator.mediaDevices.getUserMedia({video:true, audio:false})
        .then(function (stream) {
            video.srcObject = stream;
            video.onloadedmetadata = function (e) {
                video.play();
            };
            video.onplay = function () {
                showVideo();
            };
        })
        .catch(function (err) {
            displayErrorMessage("The following error occurred: " + err.name);
        });

        // Mobile browsers cannot play video without user input,
        // so here we're using a button to start it manually.
        //start_camera=document.getElementById("start_camera");
        start_camera.addEventListener("click", function (e) {

            e.preventDefault();

            // Start video playback manually.
            video.play();
            showVideo();

        });

        function take_photo(id_dch_casy)
        {
            if (KSMaster.FotoSendUrl == "") return;
            var snap = id_dch_casy + "|" + takeSnapshot();
            img_red.classList.add("visible");
            $.ajax({                    
                url: KSMaster.FotoSendUrl,
                type: "POST",  
                data: "{ 'image': '" + snap + "'}",
                contentType: "application/json; charset=utf-8",
                dataType: "json",                
                success: function (data, status) {       
                    setTimeout(function () { img_red.classList.remove("visible");img_red.classList.add("not_visible");}, 1000);
                }
            });
        }   
        function showVideo() {
            // Display the video stream and the controls.
            hideUI();
            video.classList.add("visible");
        }


        function takeSnapshot() {
            // Here we're using a trick that involves a hidden canvas element.  

            var hidden_canvas = document.querySelector('canvas'),
                context = hidden_canvas.getContext('2d');

            var width = video.videoWidth,
                height = video.videoHeight;

            if (width && height) {

                // Setup a canvas with the same dimensions as the video.
                hidden_canvas.width = width;
                hidden_canvas.height = height;

                // Make a copy of the current frame in the video on the canvas.
                context.drawImage(video, 0, 0, width, height);

                // Turn the canvas image into a dataURL that can be used as a src for our photo.
                return hidden_canvas.toDataURL('image/png');
            }
        }


        function displayErrorMessage(error_msg, error) {
            error = error || "";
            if (error) {
                console.log(error);
            }
            error_message.innerText = error_msg;
            NastavTlacitka(true);

            hideUI();
            error_message.classList.add("visible");
        }


        function hideUI() {
            start_camera.classList.remove("visible");
            video.classList.remove("visible");
            error_message.classList.remove("visible");
        }
    </script>
</telerik:RadScriptBlock>
