/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.dropdownlist.min",["kendo.list.min","kendo.mobile.scroller.min","kendo.virtuallist.min","kendo.html.button.min"],function(){var t={id:"dropdownlist",name:"DropDownList",category:"web",description:"The DropDownList widget displays a list of values and allows the selection of a single value from the list.",depends:["list","html.button"],features:[{id:"mobile-scroller",name:"Mobile scroller",description:"Support for kinetic scrolling in mobile device",depends:["mobile.scroller"]},{id:"virtualization",name:"VirtualList",description:"Support for virtualization",depends:["virtuallist"]}]},r=window.kendo.jQuery,l=void 0,u=window.kendo,e=u.ui,_=u.html,s=e.List,p=e.Select,o=u.support,h=u._activeElement,v=u.data.ObservableObject,f=u.keys,c=".kendoDropDownList",i=c+"FocusEvent",m="disabled",b="readonly",w="change",n="k-focus",g="k-disabled",I="aria-disabled",L="aria-readonly",a="click"+c+" touchend"+c,x="mouseenter"+c+" mouseleave"+c,d="tabindex",k="filter",y="accept",T="The `optionLabel` option is not valid due to missing fields. Define a custom optionLabel as shown here http://docs.telerik.com/kendo-ui/api/javascript/ui/dropdownlist#configuration-optionLabel",V="open",D="close",C=p.extend({init:function(e,t){var i=this;var n=t&&t.index;var a,s,o;i.ns=c;t=Array.isArray(t)?{dataSource:t}:t;p.fn.init.call(i,e,t);t=i.options;e=i.element.on("focus"+c,i._focusHandler.bind(i));i._focusInputHandler=i._focusInput.bind(i);i.optionLabel=r();i._optionLabel();i._inputTemplate();i._reset();i._prev="";i._word="";i._wrapper();i._tabindex();i.wrapper.data(d,i.wrapper.attr(d));i._span();i._popup();i._mobile();i._dataSource();i._ignoreCase();i._filterHeader();i._aria();i._enable();i._attachFocusHandlers();i._oldIndex=i.selectedIndex=-1;if(n!==l)t.index=n;i._initialIndex=t.index;i.requireValueMapper(i.options);i._initList();i.listView.one("dataBound",i._attachAriaActiveDescendant.bind(i));i._cascade();i.one("set",function(e){if(!e.sender.listView.bound()&&i.hasOptionLabel())i._textAccessor(i._optionLabelText())});if(t.autoBind)i.dataSource.fetch();else if(i.selectedIndex===-1){s=t.text||"";if(!s){a=t.optionLabel;if(a&&t.index===0)s=a;else if(i._isSelect)s=e.children(":selected").text()}i._textAccessor(s)}o=r(i.element).parents("fieldset").is(":disabled");if(o)i.enable(false);i.listView.bind("click",function(e){e.preventDefault()});u.notify(i);i._applyCssClasses()},options:{name:"DropDownList",enabled:true,autoBind:true,index:0,text:null,value:null,delay:500,height:200,dataTextField:"",dataValueField:"",optionLabel:"",cascadeFrom:"",cascadeFromField:"",cascadeFromParentField:"",ignoreCase:true,animation:{},filter:"none",minLength:1,enforceMinLength:false,virtual:false,template:null,valueTemplate:null,optionLabelTemplate:null,groupTemplate:"#:data#",fixedGroupTemplate:"#:data#",autoWidth:false,popup:null,filterTitle:null,size:"medium",fillMode:"solid",rounded:"medium"},events:["open","close",w,"select","filtering","dataBinding","dataBound","cascade","set","kendoKeydown"],setOptions:function(e){p.fn.setOptions.call(this,e);this.listView.setOptions(this._listOptions(e));this._optionLabel();this._inputTemplate();this._accessors();this._filterHeader();this._enable();this._aria();if(!this.value()&&this.hasOptionLabel())this.select(0)},destroy:function(){var e=this;p.fn.destroy.call(e);e.wrapper.off(c);e.wrapper.off(i);e.element.off(c);e._arrow.off();e._arrow=null;e._arrowIcon=null;e.optionLabel.off();if(e.filterInput)e.filterInput.off(i)},open:function(){var e=this;var t=e.dataSource.filter()?e.dataSource.filter().filters.length>0:false;var i=this.listView;if(e.popup.visible())return;if(!e.listView.bound()||e._state===y){e._open=true;e._state="rebind";if(e.filterInput){e.filterInput.val("");e._prev=""}if(e.filterInput&&e.options.minLength!==1&&!t){e.refresh();e.popup.one("activate",e._focusInputHandler);e.wrapper.attr("aria-activedescendant",i._optionID);e.popup.open();e._resizeFilterInput()}else e._filterSource()}else if(e._allowOpening()){e._focusFilter=true;e.popup.one("activate",e._focusInputHandler);e.popup._hovered=true;e.wrapper.attr("aria-activedescendant",i._optionID);e.popup.open();e._resizeFilterInput();e._focusItem()}},close:function(){this._attachAriaActiveDescendant();this.popup.close()},_attachAriaActiveDescendant:function(){var e=this.wrapper,t=e.find(".k-input-inner").attr("id");e.attr("aria-describedby",t)},_focusInput:function(){this._focusElement(this.filterInput)},_resizeFilterInput:function(){var e=this.filterInput;var t=this._prevent;if(!e)return;var i=this.filterInput[0]===h();var n=u.caret(this.filterInput[0])[0];this._prevent=true;e.addClass("k-hidden");e.closest(".k-list-filter").css("width",this.popup.element.css("width"));e.removeClass("k-hidden");if(i){e.trigger("focus");u.caret(e[0],n)}this._prevent=t},_allowOpening:function(){return this.hasOptionLabel()||this.filterInput||p.fn._allowOpening.call(this)},toggle:function(e){this._toggle(e,true)},current:function(e){var t;if(e===l){t=this.listView.focus();if(!t&&this.selectedIndex===0&&this.hasOptionLabel())return this.optionLabel;return t}this._focus(e)},dataItem:function(e){var t=this;var i=null;if(e===null)return e;if(e===l)i=t.listView.selectedDataItems()[0];else{if(typeof e!=="number"){if(t.options.virtual)return t.dataSource.getByUid(r(e).data("uid"));if(e.hasClass("k-list-optionlabel"))e=-1;else e=r(t.items()).index(e)}else if(t.hasOptionLabel())e-=1;i=t.dataSource.flatView()[e]}if(!i)i=t._optionLabelDataItem();return i},refresh:function(){this.listView.refresh()},text:function(e){var t=this;var i;var n=t.options.ignoreCase;e=e===null?"":e;if(e!==l){if(typeof e!=="string"){t._textAccessor(e);return}i=n?e.toLowerCase():e;t._select(function(e){e=t._text(e);if(n)e=(e+"").toLowerCase();return e===i}).done(function(){t._textAccessor(t.dataItem()||e)})}else return t._textAccessor()},_clearFilter:function(){r(this.filterInput).val("");p.fn._clearFilter.call(this)},value:function(e){var t=this;var i=t.listView;var n=t.dataSource;var a=function(){t.value(e)};if(e===l){e=t._accessor()||t.listView.value()[0];return e===l||e===null?"":e}t.requireValueMapper(t.options,e);if(e||!t.hasOptionLabel())t._initialIndex=null;this.trigger("set",{value:e});if(t._request&&t.options.cascadeFrom&&t.listView.bound()){if(t._valueSetter)n.unbind(w,t._valueSetter);t._valueSetter=a.bind(t);n.one(w,t._valueSetter);return}if(t._isFilterEnabled()&&i.bound()&&i.isFiltered())t._clearFilter();else t._fetchData();i.value(e).done(function(){t._old=t._valueBeforeCascade=t._accessor();t._oldIndex=t.selectedIndex})},hasOptionLabel:function(){return this.optionLabel&&!!this.optionLabel[0]},_optionLabel:function(){var e=this;var t=e.options;var i=t.optionLabel;var n=t.optionLabelTemplate;if(!i){e.optionLabel.off().remove();e.optionLabel=r();return}if(!n){n="#:";if(typeof i==="string")n+="data";else n+=u.expr(t.dataTextField,"data");n+="#"}if(typeof n!=="function")n=u.template(n);e.optionLabelTemplate=n;if(!e.hasOptionLabel())e.optionLabel=r('<div role="option" class="k-list-optionlabel"></div>').prependTo(e.list);e.optionLabel.html(n(i)).off().on(a,e._click.bind(e)).on(x,e._toggleHover);e.angular("compile",function(){return{elements:e.optionLabel,data:[{dataItem:e._optionLabelDataItem()}]}})},_optionLabelText:function(){var e=this.options.optionLabel;return typeof e==="string"?e:this._text(e)},_optionLabelDataItem:function(){var e=this;var t=e.options.optionLabel;if(e.hasOptionLabel())return r.isPlainObject(t)?new v(t):e._assignInstance(e._optionLabelText(),"");return l},_buildOptions:function(e){var t=this;if(!t._isSelect)return;var i=t.listView.value()[0];var n=t._optionLabelDataItem();var a=n&&t._value(n);if(i===l||i===null)i="";if(n){if(a===l||a===null)a="";n='<option value="'+a+'">'+t._text(n)+"</option>"}t._options(e,n,i);if(i!==s.unifyType(t._accessor(),typeof i)){t._customOption=null;t._custom(i)}},_listBound:function(){var e=this;var t=e._initialIndex;var i=e._state===k;var n=e.dataSource.flatView();var a;e._presetValue=false;e._renderFooter();e._renderNoData();e._toggleNoData(!n.length);e._resizePopup(true);e.popup.position();e._buildOptions(n);if(!i){if(e._open)e.toggle(e._allowOpening());e._open=false;if(!e._fetch)if(n.length){if(!e.listView.value().length&&t>-1&&t!==null)e.select(t);e._initialIndex=null;a=e.listView.selectedDataItems()[0];if(a&&e.text()!==e._text(a))e._selectValue(a)}else if(e._textAccessor()!==e._optionLabelText()){e.listView.value("");e._selectValue(null);e._oldIndex=e.selectedIndex}}e._hideBusy();e.trigger("dataBound")},_listChange:function(){this._selectValue(this.listView.selectedDataItems()[0]);if(this._presetValue||this._old&&this._oldIndex===-1)this._oldIndex=this.selectedIndex},_filterPaste:function(){this._search()},_attachFocusHandlers:function(){var e=this;var t=e.wrapper;t.on("focusin"+i,e._focusinHandler.bind(e)).on("focusout"+i,e._focusoutHandler.bind(e));if(e.filterInput)e.filterInput.on("focusin"+i,e._focusinHandler.bind(e)).on("focusout"+i,e._focusoutHandler.bind(e))},_focusHandler:function(){this.wrapper.trigger("focus")},_focusinHandler:function(){this.wrapper.addClass(n);this._prevent=false},_focusoutHandler:function(){var e=this;var t=window.self!==window.top;if(!e._prevent){clearTimeout(e._typingTimeout);if(o.mobileOS.ios&&t)e._change();else e._blur();e.wrapper.removeClass(n);e._prevent=true;e._open=false;e.element.trigger("blur")}},_wrapperMousedown:function(){this._prevent=!!this.filterInput},_wrapperClick:function(e){e.preventDefault();this.popup.unbind("activate",this._focusInputHandler);this._focused=this.wrapper;this._prevent=false;this._toggle()},_editable:function(e){var t=this;var i=t.element;var n=e.disable;var a=e.readonly;var s=t.wrapper.add(t.filterInput).off(c);var o=t.wrapper.off(x);if(!a&&!n){i.prop(m,false).prop(b,false);o.removeClass(g).on(x,t._toggleHover);s.attr(d,s.data(d)).attr(I,false).attr(L,false).on("keydown"+c,t,t._keydown.bind(t)).on(u.support.mousedown+c,t._wrapperMousedown.bind(t)).on("paste"+c,t._filterPaste.bind(t));t.wrapper.on("click"+c,t._wrapperClick.bind(t));if(!t.filterInput)s.on("keypress"+c,t._keypress.bind(t));else s.on("input"+c,t._search.bind(t))}else if(n){s.removeAttr(d);o.addClass(g)}else o.removeClass(g);i.attr(m,n).attr(b,a);s.attr(I,n).attr(L,a)},_keydown:function(e){var t=this;var i=e.keyCode;var n=e.altKey;var a;var s;var o=t.popup.visible();if(t.filterInput)a=t.filterInput[0]===h();if(i===f.LEFT){i=f.UP;s=true}else if(i===f.RIGHT){i=f.DOWN;s=true}if(s&&a)return;e.keyCode=i;if(n&&i===f.UP||i===f.ESC)t._focusElement(t.wrapper);if(t._state===k&&i===f.ESC){t._clearFilter();t._open=false;t._state=y}if(i===f.ENTER&&t._typingTimeout&&t.filterInput&&o){e.preventDefault();return}if(i===f.SPACEBAR&&!a){t.toggle(!o);e.preventDefault()}s=t._move(e);if(s)return;if(!o||!t.filterInput){var r=t._focus();if(i===f.HOME){s=true;t._firstItem()}else if(i===f.END){s=true;t._lastItem()}if(s){if(t.trigger("select",{dataItem:t._getElementDataItem(t._focus()),item:t._focus()})){t._focus(r);return}t._select(t._focus(),true).done(function(){if(!o)t._blur()});e.preventDefault()}}if(!n&&!s&&t.filterInput)t._search()},_matchText:function(e,t){var i=this.options.ignoreCase;if(e===l||e===null)return false;e=e+"";if(i)e=e.toLowerCase();return e.indexOf(t)===0},_shuffleData:function(e,t){var i=this._optionLabelDataItem();if(i)e=[i].concat(e);return e.slice(t).concat(e.slice(0,t))},_selectNext:function(){var t=this;var e=t.dataSource.flatView();var i=e.length+(t.hasOptionLabel()?1:0);var n=S(t._word,t._last);var a=t.selectedIndex;var s;var o;if(a===-1)a=0;else{a+=n?1:0;a=F(a,i)}e=e.toJSON?e.toJSON():e.slice();e=t._shuffleData(e,a);for(var r=0;r<i;r++){o=t._text(e[r]);if(n&&t._matchText(o,t._last))break;else if(t._matchText(o,t._word))break}if(r!==i){s=t._focus();t._select(F(a+r,i)).done(function(){var e=function(){if(!t.popup.visible())t._change()};if(t.trigger("select",{dataItem:t._getElementDataItem(t._focus()),item:t._focus()}))t._select(s).done(e);else e()})}},_keypress:function(e){var t=this;if(e.which===0||e.keyCode===u.keys.ENTER)return;var i=String.fromCharCode(e.charCode||e.keyCode);if(t.options.ignoreCase)i=i.toLowerCase();if(i===" ")e.preventDefault();t._word+=i;t._last=i;t._search()},_popupOpen:function(){var e=this.popup;e.wrapper=u.wrap(e.element);if(e.element.closest(".km-root")[0]){e.wrapper.addClass("km-popup km-widget");this.wrapper.addClass("km-widget")}},_popup:function(){p.fn._popup.call(this);this.popup.one("open",this._popupOpen.bind(this))},_getElementDataItem:function(e){if(!e||!e[0])return null;if(e[0]===this.optionLabel[0])return this._optionLabelDataItem();return this.listView.dataItemByIndex(this.listView.getElementIndex(e))},_click:function(e){var t=this;var i=e.item||r(e.currentTarget);e.preventDefault();if(t.trigger("select",{dataItem:t._getElementDataItem(i),item:i})){t.close();return}t._userTriggered=true;t._select(i).done(function(){t._blur();t._focusElement(t.wrapper)})},_focusElement:function(e){var t=h();var i=this.wrapper;var n=this.filterInput;var a=e===n?i:n;var s=o.mobileOS&&(o.touch||o.MSPointers||o.pointers);if(n&&n[0]===e[0]&&s)return;if(n&&(a[0]===t||this._focusFilter)){this._focusFilter=false;this._prevent=true;this._focused=e.trigger("focus")}},_searchByWord:function(t){if(!t)return;var i=this;var e=i.options.ignoreCase;if(e)t=t.toLowerCase();i._select(function(e){return i._matchText(i._text(e),t)})},_inputValue:function(){return this.text()},_search:function(){var t=this;var e=t.dataSource;clearTimeout(t._typingTimeout);if(t._isFilterEnabled())t._typingTimeout=setTimeout(function(){var e=t.filterInput.val();if(t._prev!==e){t._prev=e;t.search(e);t._resizeFilterInput()}t._typingTimeout=null},t.options.delay);else{t._typingTimeout=setTimeout(function(){t._word=""},t.options.delay);if(!t.listView.bound()){e.fetch().done(function(){t._selectNext()});return}t._selectNext()}},_get:function(e){var t,i,n;var a=typeof e==="function";var s=!a?r(e):r();if(this.hasOptionLabel())if(typeof e==="number"){if(e>-1)e-=1}else if(s.hasClass("k-list-optionlabel"))e=-1;if(a){t=this.dataSource.flatView();for(n=0;n<t.length;n++)if(e(t[n])){e=n;i=true;break}if(!i)e=-1}return e},_firstItem:function(){if(this.hasOptionLabel())this._focus(this.optionLabel);else this.listView.focusFirst()},_lastItem:function(){this._resetOptionLabel();this.listView.focusLast()},_nextItem:function(){var e;if(this.optionLabel.hasClass("k-focus")){this._resetOptionLabel();this.listView.focusFirst();e=1}else e=this.listView.focusNext();return e},_prevItem:function(){var e;if(this.optionLabel.hasClass("k-focus"))return;e=this.listView.focusPrev();if(!this.listView.focus()&&!this.options.virtual)this._focus(this.optionLabel);return e},_focusItem:function(){var e=this.options;var t=this.listView;var i=t.focus();var n=t.select();n=n[n.length-1];if(n===l&&e.highlightFirst&&!i)n=0;if(n!==l)t.focus(n);else if(e.optionLabel&&(!e.virtual||e.virtual.mapValueTo!=="dataItem")){this._focus(this.optionLabel);this._select(this.optionLabel);this.listView.content.scrollTop(0)}else t.scrollToIndex(0)},_resetOptionLabel:function(e){this.optionLabel.removeClass("k-focus"+(e||"")).removeAttr("id")},_focus:function(e){var t=this.listView;var i=this.optionLabel;if(e===l){e=t.focus();if(!e&&i.hasClass("k-focus"))e=i;return e}this._resetOptionLabel();e=this._get(e);t.focus(e);if(e===-1){i.addClass("k-focus").attr("id",t._optionID);if(this.filterInput)this.filterInput.removeAttr("aria-activedescendant").attr("aria-activedescendant",t._optionID)}},_select:function(e,t){var i=this;e=i._get(e);return i.listView.select(e).done(function(){if(!t&&i._state===k)i._state=y;if(e===-1)i._selectValue(null)})},_selectValue:function(e){var t=this;var i=t.options.optionLabel;var n=t.listView.select();var a="";var s="";n=n[n.length-1];if(n===l)n=-1;this._resetOptionLabel(" k-selected");if(e||e===0){s=e;a=t._dataValue(e);if(i)n+=1}else if(i){t._focus(t.optionLabel.addClass("k-selected"));s=t._optionLabelText();if(typeof i==="string")a="";else a=t._value(i);n=0}t.selectedIndex=n;if(a===null)a="";t._textAccessor(s);t._accessor(a,n);t._triggerCascade()},_mobile:function(){var e=this,t=e.popup,i=o.mobileOS,n=t.element.parents(".km-root").eq(0);if(n.length&&i)t.options.animation.open.effects=i.android||i.meego?"fadeIn":i.ios||i.wp?"slideIn:up":t.options.animation.open.effects},_filterHeader:function(){var e='<div class="k-list-filter">'+'<span class="k-searchbox k-input k-input-md k-rounded-md k-input-solid" type="text" autocomplete="off">'+'<span class="k-input-icon k-icon k-i-search"></span>'+"</span>"+"</div>";if(this.filterInput){this.filterInput.off(c).closest(".k-list-filter").remove();this.filterInput=null}if(this._isFilterEnabled()){this.filterInput=r('<input class="k-input-inner" type="text" />').attr({placeholder:this.element.attr("placeholder"),title:this.options.filterTitle||this.element.attr("title"),role:"searchbox","aria-label":this.options.filterTitle,"aria-haspopup":"listbox","aria-autocomplete":"list"});this.list.parent().prepend(r(e)).find(".k-searchbox").append(this.filterInput)}},_span:function(){var e=this,t=e.wrapper,i="span.k-input-value-text",n=u.guid(),a=e.options,s,o;s=t.find(i);if(!s[0]){o=_.renderButton('<span role="button" class="k-input-button" aria-label="select"></span>',{icon:"arrow-s",size:a.size,fillMode:a.fillMode,shape:"none",rounded:"none"});t.append('<span id="'+n+'" unselectable="on" class="k-input-inner">'+'<span class="k-input-value-text"></span>'+"</span>").append(o).append(e.element);s=t.find(i)}e.span=s;e._arrow=t.find(".k-input-button");e._arrowIcon=e._arrow.find(".k-icon")},_wrapper:function(){var e=this,t=e.element,i=t[0],n;n=t.parent();if(!n.is("span.k-picker")){n=t.wrap("<span />").parent();n[0].style.cssText=i.style.cssText;n[0].title=i.title}e._focused=e.wrapper=n.addClass("k-picker k-dropdownlist").addClass(i.className).removeClass("input-validation-error").css("display","").attr({accesskey:t.attr("accesskey"),unselectable:"on",role:"combobox","aria-expanded":false});t.hide().removeAttr("accesskey")},_clearSelection:function(e){this.select(e.value()?0:-1)},_openHandler:function(e){this._adjustListWidth();if(this.trigger(V))e.preventDefault();else{this.wrapper.attr("aria-expanded",true);this.ul.attr("aria-hidden",false)}},_closeHandler:function(e){if(this.trigger(D))e.preventDefault();else{this.wrapper.attr("aria-expanded",false);this.ul.attr("aria-hidden",true)}},_inputTemplate:function(){var e=this,t=e.options.valueTemplate;if(!t)t=u.template("#:this._text(data)#",{useWithBlock:false}).bind(e);else t=u.template(t);e.valueTemplate=t;if(e.hasOptionLabel()&&!e.options.optionLabelTemplate)try{e.valueTemplate(e._optionLabelDataItem())}catch(e){throw new Error(T)}},_textAccessor:function(e){var t=null;var i=this.valueTemplate;var n=this._optionLabelText();var a=this.span;if(e===l)return a.text();if(r.isPlainObject(e)||e instanceof v)t=e;else if(n&&n===e)t=this.options.optionLabel;if(!t)t=this._assignInstance(e,this._accessor());if(this.hasOptionLabel())if(t===n||this._text(t)===n){i=this.optionLabelTemplate;if(typeof this.options.optionLabel==="string"&&!this.options.optionLabelTemplate)t=n}var s=function(){return{elements:a.get(),data:[{dataItem:t}]}};this.angular("cleanup",s);try{a.html(i(t))}catch(e){a.html("")}this.angular("compile",s)},_preselect:function(e,t){if(!e&&!t)t=this._optionLabelText();this._accessor(e);this._textAccessor(t);this._old=this._accessor();this._oldIndex=this.selectedIndex;this.listView.setValue(e);this._initialIndex=null;this._presetValue=true},_assignInstance:function(e,t){var i=this.options.dataTextField;var n={};if(i){O(n,i.split("."),e);O(n,this.options.dataValueField.split("."),t);n=new v(n)}else n=e;return n}});function O(e,t,i){var n=0,a=t.length-1,s;for(;n<a;++n){s=t[n];if(!(s in e))e[s]={};e=e[s]}e[t[a]]=i}function F(e,t){if(e>=t)e-=t;return e}function S(e,t){for(var i=0;i<e.length;i++)if(e.charAt(i)!==t)return false;return true}return e.plugin(C),u.cssProperties.registerPrefix("DropDownList","k-picker-"),u.cssProperties.registerValues("DropDownList",[{prop:"rounded",values:u.cssProperties.roundedValues.concat([["full","full"]])}]),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,i){(i||t)()});
//# sourceMappingURL=kendo.dropdownlist.min.js.map
