﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="ZakSpec_SpravaKaret"
    CodeBehind="SpravaKaret.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRadGrid_karty">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RW_NahratKartu"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="Label_zam"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TB_Karta">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid_karty"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="RW_NahratKartu"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Import">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RW_HromadnyImport"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Importsouboru">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RW_HromadnyImport"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <telerik:RadScriptBlock runat="server" ID="RadScript">

        <script type="text/javascript">
            function setFocus() {
                var radWindow = $find("<%= RW_NahratKartu.ClientID %>");
                if (radWindow != null && radWindow.IsVisible()) {
                    document.getElementById("<%= TB_Karta.ClientID %>").focus();
                }
            }
            function TB_Karta_onKeyPress(sender, eventArgs) {
                var currentVal = sender.get_textBoxValue(); 
                var keyChar = eventArgs.get_keyCharacter(); 
                var newVal = currentVal + keyChar;

                var lblElement = document.getElementById("<%=Lab_hvezdicky.ClientID%>");
                lblElement.innerHTML = "*".repeat(newVal.length);
            }
            window.onload = setFocus;
            window.onresize = setFocus;

            setInterval(setFocus, 500);
        </script>
    </telerik:RadScriptBlock>

    <asp:Label ID="Label1" runat="server" Text="[%Správa čipových karet%]" CssClass="nadpis1"></asp:Label>

    <kspwc:TRadGrid ID="TRadGrid_karty" runat="server" AllowPaging="True" OnItemCommand="TRadGrid_karty_ItemCommand"
        AllowSorting="true" AutoGenerateColumns="false" OnNeedDataSource="TRadGrid_karty_NeedDataSource"
        AutoFilterControlWidth="false" MasterTableView-ShowFooter="False" AllowMultiRowSelection="true">
        <GroupingSettings CaseSensitive="False" CollapseAllTooltip="Collapse all groups" ShowUnGroupButton="true"></GroupingSettings>
        <MasterTableView CommandItemDisplay="Top" Caption="[%Přiřazení karet zaměstnancům%]" PageSize="50" PagerStyle-Visible="true">
            <Columns>
                <telerik:GridBoundColumn UniqueName="os_cislo" DataField="os_cislo" SortExpression="os_cislo" HeaderText="[%Os. číslo%]"></telerik:GridBoundColumn>
                <%--<telerik:GridBoundColumn UniqueName="foto" DataField="foto" SortExpression="foto"></telerik:GridBoundColumn>--%>
                <telerik:GridBoundColumn UniqueName="prijmeni" DataField="prijmeni" SortExpression="prijmeni" HeaderText="[%Příjmení%]"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="jmeno" DataField="jmeno" SortExpression="jmeno" HeaderText="[%Jméno%]"></telerik:GridBoundColumn>
                <telerik:GridTemplateColumn HeaderText="[%Karta nahrána%]" ItemStyle-HorizontalAlign="Center">
                    <ItemTemplate>
                        <%# GetIcon(Container.DataItem) %>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn>
                    <ItemTemplate>
                        <telerik:RadButton ID="TRB_Nahrat" runat="server" Text="[%Nahrát%]" Icon-PrimaryIconCssClass="fi fi-credit-card" CommandName="nahrat" CssClass="kstlacitko"></telerik:RadButton>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
            </Columns>
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="GcIc3" runat="server"></kspwc:GridCommandItemControl>
                <primipodrizenibutton id="PrimiPodrizeniButton1" runat="server" visible="true"></primipodrizenibutton>
                <bezmesbutton id="BezMESButton1" runat="server" visible="true"></bezmesbutton>
                <kspwc:TRadButton ID="TRB_Import" runat="server" OnClick="TRB_Import_Click" Text="[%Import ze souboru%]" Icon-PrimaryIconCssClass="fi fi-file-import" CssClass="kstlacitko" Style="margin-top: 2px;" AutoPostBack="true"></kspwc:TRadButton>
            </CommandItemTemplate>
        </MasterTableView>
    </kspwc:TRadGrid>

    <telerik:RadWindow ID="RW_NahratKartu" runat="server" VisibleOnPageLoad="true" Visible="false" Width="400px" Height="400px" Modal="true">
        <ContentTemplate>
            <div class="NahratKartu">
                <img src="../Skins/ikony/uicons-regular-rounded/svg/fi-rr-credit-card.svg" alt="" width="200px" />
                <asp:Label ID="Label2" runat="server" Text="[%Přiložte čipovou kartu zaměstnance%]"></asp:Label>
                <asp:Label ID="Label_zam" runat="server" Text=""></asp:Label>
                <telerik:RadTextBox ID="TB_Karta" runat="server" OnTextChanged="TB_Karta_TextChanged" AutoCompleteType="Disabled" AutoPostBack="true">
                    <ClientEvents OnKeyPress="TB_Karta_onKeyPress" />
                </telerik:RadTextBox>
                <asp:Label ID="Lab_hvezdicky" runat="server" Text=""></asp:Label>
            </div>

        </ContentTemplate>
    </telerik:RadWindow>

    <telerik:RadWindow ID="RW_HromadnyImport" runat="server" VisibleOnPageLoad="true" Visible="false" Width="400px" Height="400px" Modal="true">
        <ContentTemplate>
            <div style="margin: auto; width: fit-content; display: flex; flex-direction: column; justify-content: center; height: 100%;">
                <asp:Label ID="Label3" runat="server" Text="[%Vyberte soubor, který chcete Importovat%] ([%typ%] - xlsx/csv/xls, [%sloupce%] - [%Osobní číslo%], UID):"></asp:Label>
                <telerik:RadAsyncUpload runat="server" ID="RAU_Import" AllowedFileExtensions=".xlsx,.csv,.xls" MultipleFileSelection="Automatic" TemporaryFolder="~/Temp"></telerik:RadAsyncUpload>
                
                 <kspwc:TRadButton ID="TRB_Importsouboru" runat="server" OnClick="TRB_Importsouboru_Click" Text="[%Importovat%]" Icon-PrimaryIconCssClass="fi fi-file-import" CssClass="kstlacitko" AutoPostBack="true" Style="margin-top: 20px;"></kspwc:TRadButton>
            </div>
        </ContentTemplate>
    </telerik:RadWindow>


</asp:Content>
