﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="OverovaniInsolvence.aspx.cs" Inherits="KSPortal.ZakSpec.OverovaniInsolvence" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
      <telerik:RadCodeBlock runat="server" ID="code_block">          
            <script type="text/javascript">
        //<![CDATA[                      
                (function () {
                })();
                function GetRadWindow() {
                    var oWindow = null;
                    if (window.radWindow) oWindow = window.radWindow;
                    else if (window.frameElement.radWindow) oWindow = window.frameElement.radWindow;
                    return oWindow;
                }
                function SetValue(spis_znacka, datum, stav) {                 
                    GetRadWindow().BrowserWindow.SetValueForm(datum,"date_insolvence_datum_5");
                    GetRadWindow().BrowserWindow.SetValueForm(spis_znacka + " " + stav, "text_insolvence_detail_5");
                    // Tip: you can pass an argument to provide data to the called function
                }
                function RowDblClickKod(sender, eventArgs) {
                    var spis_znacka = eventArgs.getDataKeyValue("spis_znacka");
                    var den = eventArgs.getDataKeyValue("dz_den");
                    var mes = eventArgs.getDataKeyValue("dz_mes");
                    var rok = eventArgs.getDataKeyValue("dz_rok");
                    var stav = eventArgs.getDataKeyValue("stav_konkurzu");
                    SetValue(spis_znacka, den + "," + mes + "," + rok, stav);
                }        
                 //]]>
            </script>
      </telerik:RadCodeBlock>
    <div style="width:550px;">    
          <kspwc:TRadGrid ID="tgv_insolvence" runat="server" IdPravaEditace="23" ExportSettings-ExportOnlyData="true" ExportSettings-Csv-ColumnDelimiter="Semicolon"
         DataKeyNames="spis_znacka,dz_den,dz_mes,dz_rok,stav_konkurzu"  AllowSorting="true" CaptionVisible="false"
          OnNeedDataSource="tgv_insolvence_NeedDataSource" >
        <ClientSettings EnableRowHoverStyle="true">
            <ClientEvents OnRowDblClick="RowDblClickKod" />
            <Selecting AllowRowSelect="True"></Selecting>        
        </ClientSettings>
        <MasterTableView AutoGenerateColumns="false" TableLayout="Fixed"  DataKeyNames="spis_znacka,dz_den,dz_mes,dz_rok,stav_konkurzu" ClientDataKeyNames="spis_znacka,dz_den,dz_mes,dz_rok,stav_konkurzu">            
            <Columns>
                <telerik:GridBoundColumn DataField="spis_znacka" HeaderText="[%Spis značka%]" SortExpression="spis_znacka" />
                <telerik:GridBoundColumn DataField="datum_zmeny" HeaderText="[%Datum změny%]" DataFormatString="{0:d}" SortExpression="datum_zmeny" />
                <telerik:GridBoundColumn DataField="stav_konkurzu" HeaderText="[%Stav konkurzu%]" SortExpression="stav_konkurzu" />
                <telerik:GridBoundColumn DataField="relevance_vysl" HeaderText="[%Relevance%]" SortExpression="relevance_vysl" />
                </Columns>
            </MasterTableView>        
        </kspwc:TRadGrid>  
    </div>   
</asp:Content>
