﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DashBoardPanel_Ankety.ascx.cs" Inherits="KSPortal.DashBoard.DashBoardPanel_Ankety" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>



<style type="text/css">
    fieldset.ksDbWarFs {
        margin: 2px 0 2px 0;
        border-color: lightgray;
        border-style: solid;
        border-width: 1px;
        padding: 4px 4px 4px 8px;
    }

        fieldset.ksDbWarFs > div {
            width: 100%;
            position: relative;
        }

            fieldset.ksDbWarFs > div > p {
                font-size: 16px !important;
                /*color: #294C7E !important;*/
            }

    .ksAnket {
        border: solid 2px lightgrey;
        border-radius: 10px;
        padding: 4px 4px 4px 8px;
        margin: 15px;
        transition: 0.4s;
        color: var(--kscolor2text);
    }

    .seznamOtazek {
        margin-top: 20px;
    }

    .seznamOdpovedi {

        width: 100%;
        margin: 10px;
    }

    .odpoved {
        min-width: 25%;
        margin-top: 5px;
    }

    .odpovedText {
        vertical-align: top;
    }

    .rwWindowContent div{
        height: fit-content !important;
        max-height: 800px;
    }
    .ksBlLv{
        margin-bottom: 10px;
    }
</style>

<style type="text/css">
    .ksBullEditorWindow {
        height: fit-content;
    }

        .ksBullEditorWindow td.rwBodyLeft, .ksBullEditorWindow td.rwBodyRight,
        .ksBullEditorWindow td.rwFooterLeft, .ksBullEditorWindow td.rwFooterCenter, .ksBullEditorWindow td.rwFooterRight {
            background-color: lightgray !important;
        }

    div.ksBullEditorCommand {
        width: 100%;
    }

    fieldset.ksBlFsEmpty {
        margin: 2px 0 2px 0;
        border-color: lightgray;
        border-style: solid;
        border-width: 1px;
        padding: 4px 4px 4px 8px;
    }

        fieldset.ksBlFsEmpty > div {
            width: 100%;
            position: relative;
        }

            fieldset.ksBlFsEmpty > div > p {
                font-size: 16px !important;
            }

    .button1 {
        background-color: var(--kscolor1);
        border: none;
        color: var(--kscolor1text);
        text-align: center;
        text-decoration: none;
        font-size: 16px;
        margin: 4px 2px;
        cursor: pointer;
    }
</style>

<style type="text/css">
    .nadpis2Anketa {
        font-weight: bold;
        font-size: 12px;
        text-align: left;
        margin-bottom: 0.25em;
        width: 100%;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .nadpis1Anketa {
        font-weight: bold;
        font-size: 15px;
        text-align: left;
        margin-bottom: 0.25em;
        width: 100%;
        height: 5em;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .tabSha {
        border: 2px solid lightgray;
        border-radius: 5px;
        background: white;
        margin: 20px;
        padding: 10px;
    }

    .nazevDotazniku {
        width: 100%;
        font-size: 20px;
        font-weight: bold;
        text-align: left;
        background: var(--kscolor1);
        color: var(--kscolor1text);
    }

    .bodySurveys {
        border: 1px solid lightgray;
    }

    .nadpis {
        padding-left: 0.5em;
    }

    .otazkaNadpis {
        width: 80%;
    }

    .diver {
        color: lightgray;
    }

    .odpovedTB {
        width: 100%;
        border: 1px solid lightgray;
    }

    .buttonText {
        border: none;
        background: transparent;
    }

        .buttonText:hover {
            color: cornflowerblue;
        }

    .buttonTextAdd {
        border: none;
        background: transparent;
    }

        .buttonTextAdd:hover {
            color: black;
            background: lightgray;
            border: 1px solid lightgray;
        }
</style>

<telerik:RadScriptBlock ID="RSB_warns" runat="server">
    <script type="text/javascript">
        String.prototype.cleanForJson = function () {
            return this.replace(/"/g, "'");
        };

        function Parse(sender, args) {
            var response = args.get_response().d;
            if (response) {
                args.set_parsedData(response.Data);
            }
        }

        function _emptyText2() {
            return '<%=KSProgram.Obecne.ReadGlobalResource.ZmenaTextu("[%Žádné ankety k vyplnění%]")%>';
        }

        function ksShowEditorAnke(id) {
            //pdfjsLib.GlobalWorkerOptions.workerSrc = './Scripts/pdf.worker.js';
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/Dotazniky/WebMethods.aspx/GetBulletinHtml",
                data: "{id: " + id + "}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    //alert("Chyba: " + JSON.parse(response.responseText).Message);
                    alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                },
                error: function (response) {
                    //alert("Chyba: ", JSON.parse(response.responseText).Message);
                    alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                },
                success: function (msg) {
                    id_bull = id;
                    anketaCreate(msg.d)
                    var window = $find("<%=RW_editorAnke.ClientID%>");
                    window.show();
                }
            });
        }

        pdfDataByte = null;
        numberofpage = 1;
    </script>


    <script>

        var counter = 2;
        var counterOtazek = 1;


        function anketaCreate(stringJson) {
            //console.log(json);
            var panel = document.getElementById("<%=panelZobrazeniOtazky.ClientID%>");
            panel.innerHTML = "";
            var json = JSON.parse(stringJson);
            //var json = stringJson;

            var window = $find("<%=RW_editorAnke.ClientID%>");
            window.set_title(json.nazev);

            var mainDiv = document.createElement("div");
            mainDiv.setAttribute("class", "teloAnkety");
            if (json.anonymni == "true") mainDiv.innerHTML += "<i class='fi fi-incognito' style='position: absolute; left: 10px; top: 10px;' title='Tato anketa je anonymní'/>";
            var seznamOtazek = document.createElement("div");
            seznamOtazek.setAttribute("class", "seznamOtazek");

            for (var i = 0; i < json.otazky.length; i++) {
                var element1 = document.createElement("div");
                element1.setAttribute("class", "tabSha");
                element1.setAttribute("id", "otazkaDiv" + i);

                var nazevOtazky = json.otazky[i].nazev;
                nazevOtazky = nazevOtazky.replace(/¶/g, "\n");

                if (json.otazky[i].povinny == "true") {
                    element1.style.border = "solid 2px var(--kscolor1)";
                }
                element1.innerHTML +=
                     "<label id='nadpisOtazky" + i + "' class='nadpis1Anketa' rows='2' cols='20''>" + nazevOtazky + "</label>"
                    + "<input type='checkbox' class='povinnaOtazka' style='visibility:hidden;' checked=" + json.otazky[i].povinny + "></input>"
                    + "<hr class='diver' />";
                var element3 = document.createElement("div");
                element3.setAttribute("class", "seznamOdpovedi");

                for (var j = 0; j < json.otazky[i].odpovedi.length; j++) {
                    var odpoved = json.otazky[i].odpovedi[j];
                    switch (odpoved.typ) {
                        case "checkbox":
                            element3.innerHTML += "<div class='odpoved'><input type='checkbox' name='checkbox" + i + "'><label for='checkbox" + i + "' class='odpovedText'>" + odpoved.nazev + "</label></div>";
                            break;
                        case "radio":
                            element3.innerHTML += "<div class='odpoved'><input type='radio' name='radio" + i + "'><label for='radio" + i + "' class='odpovedText'>" + odpoved.nazev + "</label></div>";
                            break;
                        case "text":
                            element3.innerHTML += "<div class='odpoved'><input type='text' style='width: 95%;'></div>";
                            break;
                    }
                }
                element1.appendChild(element3);
                seznamOtazek.appendChild(element1);
            }
            seznamOtazek.innerHTML += "<label class='lblNevyplneno' style='color:red;'></label>"
            seznamOtazek.innerHTML += "<input class='buttonVyveska' id='ulozitDotaznik' type='submit' value='Uložit dotazník' onclick='anketaUlozOdpovedi(); return false;' />"

            mainDiv.appendChild(seznamOtazek);
            panel.appendChild(mainDiv);
            document.getElementById("<%=HF_anonymni.ClientID%>").value = json.anonymni;
            document.getElementById("<%=HF_nazevAnkety.ClientID%>").value = json.nazev;
        }

        function anketaUlozOdpovedi() {

            var teloAnkety = document.getElementsByClassName("teloAnkety")[0];

            var dotaznik = teloAnkety.getElementsByClassName("seznamOtazek")[0];
            //tělo JSON ankety
            var jsonOtazky = '';
            for (var i = 0; i < dotaznik.childElementCount - 2; i++) {
                var prvek = dotaznik.children[i];

                var nadpis = prvek.getElementsByClassName("nadpis1Anketa")[0].textContent;

                var checkboxState = prvek.getElementsByClassName("povinnaOtazka")[0].getAttribute("checked");

                var jsonOdpovedi = '';

                //načtu si seznam odpovědí

                var seznamOdpovedi = prvek.getElementsByClassName("seznamOdpovedi")[0];

                for (var j = 0; j < seznamOdpovedi.children.length; j++) {
                    var ch = seznamOdpovedi.children[j];

                    var typOdpovedi = seznamOdpovedi.children[j].children[0].getAttribute("type");

                    if (typOdpovedi != "text") {
                        var textOdpovedi = seznamOdpovedi.children[j].children[1].innerHTML;
                        var checked = seznamOdpovedi.children[j].children[0].checked;

                        if (checked == true) {
                            if (jsonOdpovedi.length > 0) {
                                jsonOdpovedi += ',';
                            }
                            jsonOdpovedi += '{"nazev":"' + textOdpovedi.cleanForJson() + '",' +
                                '"typ":"' + typOdpovedi + '"}'
                        }
                    } else if (typOdpovedi == "text") {
                        //pokud je typu text tak vezmu jeho hodnotu 

                        var textOdpovedi = seznamOdpovedi.children[j].children[0].value;

                        if (textOdpovedi.length > 0) {
                            if (jsonOdpovedi.length > 0) {
                                jsonOdpovedi += ',';
                            }
                            jsonOdpovedi += '{"nazev":"' + textOdpovedi.cleanForJson() + '",' +
                                '"typ":"' + typOdpovedi + '"}'
                        }

                    }



                }

                if (jsonOdpovedi.length <= 0 && checkboxState == "true") {
                    document.getElementsByClassName("lblNevyplneno")[0].innerHTML = '<%= KSProgram.Obecne.ReadGlobalResource.ZmenaTextu("[%Některé povinné položky nebyly vyplněny.%]")%>';

                    return;
                }
                document.getElementsByClassName("lblNevyplneno")[0].innerHTML = "";

                if (i > 0) {
                    jsonOtazky += ',';
                }
                var str = nadpis.replace(/\n/g, "¶");
                jsonOtazky += '{"nazev":"' + str.cleanForJson() + '",' +
                    '"typ":"Text",' +
                    '"povinny":"' + checkboxState + '",' +
                    '"odpovedi":[' + jsonOdpovedi + ']}';
            }

            //hlavička JSON ankety
            var anonymni = document.getElementById("<%=HF_anonymni.ClientID%>").value;
            var nadpis = document.getElementById("<%=HF_nazevAnkety.ClientID%>").value;

            var json = '{ "nazev":"' + nadpis.cleanForJson() + '",' +
                '"anonymni":"' + anonymni + '",' +
                '"otazky":[' + jsonOtazky + ']}';

            //console.log(json);
            // console.log(JSON.parse(json))
            ulozVytvorenyVyplneny(json, anonymni);
        }

        function ulozVytvorenyVyplneny(json, anonym) {

            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/Dotazniky/WebMethods.aspx/UlozDotaznikOdpovedi",
                data: JSON.stringify({
                    json: json,
                    id: id_bull,
                    anonym: anonym
                }),
                async: false,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    //alert("Chyba: " + JSON.parse(response.responseText).Message);
                    alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                },
                error: function (response) {
                    //alert("Chyba: ", JSON.parse(response.responseText).Message);
                    alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                },
                success: function (msg) {
                    var window = $find("<%=RW_editorAnke.ClientID%>");
                    window.close();
                    showLoadingAnimation();
                    location.reload();
                }
            });
        }


    </script>


</telerik:RadScriptBlock>

<asp:HiddenField runat="server" ID="id_zpr" Value="" />

<telerik:RadListView runat="server" ID="RadListView1" AllowPaging="true" ItemPlaceholderID="ItemsPlaceHolder" ClientDataSourceID="RCDS_ankety"
    DataKeyNames="id" ClientDataKeyNames="id">
    <LayoutTemplate>
        <div id="ItemsPlaceHolder" runat="server" class="ksBlLv">
        </div>
    </LayoutTemplate>
    <ClientSettings>
        <DataBinding>
            <ItemTemplate>
                            <a href="javascript:ksShowEditorAnke ? ksShowEditorAnke(#= id #) : ''" style="text-decoration: none;">
                            <fieldset class="ksAnket">
                                <div class="ksBlBullItem">
                                    <div>
                                        <div class="ksBlFoto" style="display: #= id_image ? 'block' : 'none' #; #= id_image ? '' : 'max-height:unset;' #" >
                                            <img src="#= ImageUrl #" />
                                        </div>
                                        <div>
                                            <p>
                                                #= nadpis #
                                            </p>
                                           <p>
                                                #= telo #
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                                </a>
            </ItemTemplate>
            <EmptyDataTemplate>
                            <fieldset class="ksDbLiFs" style="border:none;">
                                <div>
                                    <p class="zadneBull">
                                        <i class="fi fi-test"></i>
                                        <label>#=_emptyText2()#</label>
                                    </p>
                                </div>
                            </fieldset>
            </EmptyDataTemplate>
        </DataBinding>
    </ClientSettings>
</telerik:RadListView>


<asp:HiddenField runat="server" ID="HF_anonymni" />
<asp:HiddenField runat="server" ID="HF_nazevAnkety" />

<telerik:RadWindow runat="server" ID="RW_editorAnke" AutoSize="false" KeepInScreenBounds="true" CssClass="ksBullEditorWindow"
    Behaviors="Close,Maximize,Minimize,Move, Resize" 
    ShowContentDuringLoad="false" MinWidth="680px" Modal="true">
    <ContentTemplate>
        <div class="ksBullEditorContainer">
            <div runat="server" id="RE_editor" cssclass="ksBullEditor">
                <asp:Panel Style="padding: 10px;" ID="panelZobrazeniOtazky" runat="server" Visible="true">
                </asp:Panel>
            </div>
        </div>
    </ContentTemplate>
</telerik:RadWindow>

<telerik:RadClientDataSource ID="RCDS_ankety" runat="server" AllowBatchOperations="false">
    <ClientEvents OnDataParse="Parse" />
    <DataSource>
        <WebServiceDataSourceSettings>
            <Select Url="Dotazniky/WebMethods.aspx/GetBulletins" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
        </WebServiceDataSourceSettings>
    </DataSource>
    <Schema>
        <Model ID="id">
            <telerik:ClientDataSourceModelField FieldName="id" DataType="Number" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="nadpis" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="telo" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="ImageUrl" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="id_image" DataType="Number" Editable="False" />
        </Model>
    </Schema>
</telerik:RadClientDataSource>
