﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZmppvInnerForm.ascx.cs" Inherits="KSPortal.Controls.ZmppvInnerForm" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="~/Controls/ZmppvCompare.ascx" TagName="ZmppvCompare" TagPrefix="uc1" %>
<style type="text/css">
    .rfdTable {
        background: none;
        box-shadow: none;
    }

    .ksfieldset {
        margin: 0 !important;
        border-radius: 5px;
    }
    .InnerTableFormFieldset, .ksclass{
        color: var(--kscolor2text) !important;
    }

    .InnerTableFormFieldset tr:nth-child(1) {
            text-align: unset !important;
        }

    .rcbInput {
        width: 100%;
    }

    .RadComboBox .rcbInput {
        width: 100%;
    }

    .t-col-6 {
        margin-top: 10px;
    }

    .t-container {
        padding: 0;
    }

    .ksclass {
        background: var(--kscolor2);
        border-radius: 35px;
        padding-top: 5px;
        padding-left: 10px;
        padding-right: 10px;
    }

    .ksRed {
        color: red;
    }
</style>
<script src="../Scripts/iban.js" type="text/javascript"></script>
<script src="../Scripts/KSValidator.js" type="text/javascript"></script>
<telerik:RadAjaxManagerProxy runat="server" ID="RAMP_inner">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="RNTB_e_hod_uvazek">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TableEdit" />
            </UpdatedControls>
        </telerik:AjaxSetting>
                <telerik:AjaxSetting AjaxControlID="TRMYP_plati_od">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TRG_priplatky" />
            </UpdatedControls>
        </telerik:AjaxSetting>
                <telerik:AjaxSetting AjaxControlID="RMTB_edit_rc">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="inner_panel" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRCB_e_id_pracmist">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TableEdit" />
                <telerik:AjaxUpdatedControl ControlID="TRG_dokumenty_p" />
                <telerik:AjaxUpdatedControl ControlID="TRG_priplatky" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="RNTB_deti_pro_duch">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="table_Evidencni" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRG_dokumenty_p">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TRG_dokumenty_p" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRG_priplatky">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TRG_priplatky" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="inner_panel">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="P_Form" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRB_rc_info">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="UC_Compare" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<%--změněno za RadScriptBlock, který umožňuje přerenderování při ajax postbacku. $find("<%= TRCB_trida.ClientID %>") nenašel aktuální kontrolku kvůli starému ClientId --%>
<telerik:RadScriptBlock ID="RSB_inner" runat="server">
    <script type="text/javascript" id="rsbs_inner">

        var oldPageLoad18 = !oldPageLoad18 ? KSMaster.onPageLoad : oldPageLoad18;
        KSMaster.onPageLoad = function () {
            oldPageLoad18.apply();
            var combo = $find("<%= TRCB_trida.ClientID %>");
            if (combo) {
                var input = combo.get_inputDomElement();
                input.onkeydown = onTridaKeyDownHandler;
            }

            var combo2 = $find("<%= TRCB_stupen.ClientID %>");
            if (combo2) {
                var input2 = combo2.get_inputDomElement();
                input2.onkeydown = onTridaKeyDownHandler;
            }

            setTarif();
        };
        KSMaster.onPageLoad.prototype = oldPageLoad18.prototype;

        function onTridaKeyDownHandler(e) {
            if (!e)
                e = window.event;
            var code = e.key;
            if (!(code == "0" || code == "1" || code == "2" || code == "3" || code == "4" || code == "5" || code == "6" || code == "7" || code == "8" || code == "9" ||
                code == "Backspace" || code == "Enter" || code == "Tab" || code == "ArrowDown" || code == "ArrowUp" || code == "ArrowLeft" || code == "ArrowRight" || code == "Escape" || code == "Delete")) {
                e.returnValue = false;
                if (e.preventDefault) {
                    e.preventDefault();
                }
            }
        }

        function telefon_validate(source, arguments) {
            var val = arguments.Value.replace(/\s/g, '');
            var args = KSValidator.getArgs();
            if (KSValidator.validateTelefon(val, args, '<%= (KSProgram.Zakaznik.IsSR() ? "421" : "420") %>')) {
                if (args.newValue && args.newValue != "" && args.newValue.replace(/\s/g, '') != val) {
                    var RMTB = $find('<%= RMTB_edit_telefon.ClientID %>');
                    RMTB.set_value(args.newValue);
                }
                arguments.IsValid = true;
                return;
            }
            arguments.IsValid = false;
        }

        function IsPrihlaseny(source, arguments) {
            var trcb = $find('<%= TRCB_insert_os_cislo.ClientID %>');
            var value = trcb?.get_value();
            if (value === KSMaster.HF_oc_akt_user_zast.value) {
                arguments.IsValid = false;
            }
            else {
                arguments.IsValid = true;
            }
        }

        function trida_ItemsRequesting(sender, args) {
            var context = args.get_context();
            var HF_typ_tt = $get('<%= HF_typ_tt_old.ClientID %>');
            var TRCB_typ_mzdy = $find('<%= TRCB_e_typ_mzdy.ClientID %>');
            var HF_typ_mzdy_old = $get('<%= HF_typ_mzdy_old.ClientID %>');

            context["typ_tt"] = HF_typ_tt ? HF_typ_tt.value : null;
            context["typ_mzdy"] = TRCB_typ_mzdy ? TRCB_typ_mzdy.get_value() : null;
            context["typ_mzdy_old"] = HF_typ_mzdy_old ? HF_typ_mzdy_old.value : null;
        }
        function mzd_stup_ItemsRequesting(sender, args) {
            var context = args.get_context();
            var HF_typ_tt = $get('<%= HF_typ_tt_old.ClientID %>');
            var TRCB_typ_mzdy = $find('<%= TRCB_e_typ_mzdy.ClientID %>');
            var HF_typ_mzdy_old = $get('<%= HF_typ_mzdy_old.ClientID %>');
            var TRCB_trida = $find('<%= TRCB_trida.ClientID %>');
            var HF_trida_old = $get('<%= HF_trida_old.ClientID %>');

            context["typ_tt"] = HF_typ_tt ? HF_typ_tt.value : null;
            context["typ_mzdy"] = TRCB_typ_mzdy ? TRCB_typ_mzdy.get_value() : null;
            context["typ_mzdy_old"] = HF_typ_mzdy_old ? HF_typ_mzdy_old.value : null;
            context["trida"] = TRCB_trida ? TRCB_trida.get_text() : null;
            context["trida_old"] = HF_trida_old ? HF_trida_old.value : null;
        }
        function smena_ItemsRequesting(sender, args) {
            var context = args.get_context();
            var TRCB_typ_kal = $find('<%= TRCB_e_typ_kal.ClientID %>');
            var HF_typ_kal_old = $get('<%= HF_typ_kal_old.ClientID %>');

            context["typ_kal"] = TRCB_typ_kal ? TRCB_typ_kal.get_value() : null;
            context["typ_kal_old"] = HF_typ_kal_old ? HF_typ_kal_old.value : null;
        }
        function comboDropDownClosed(sender, args) {
            sender.clearItems();
        }
        function TRCB_trida_TextChange(sender, args) {
            if (sender.get_text().length > 2) {
                sender.set_text(sender.get_text().substring(0, 2));
            }
            setTarif(sender, args);
        }
        function TRCB_prac_str_SelectedIndexChanged(sender, args) {
            var HF_prac_str_old = $get('<%= HF_prac_str_old.ClientID %>');
            var prac_str = args.get_item().get_value();
            var prac_str_old = HF_prac_str_old ? HF_prac_str_old.value : null;

            PageMethods.GetDivize(prac_str, prac_str_old, setDivizeCallBack);
        }

        function setDivizeCallBack(data) {
            if (data) {
                var HF_divize = $get('<%= HF_divize.ClientID %>');
                var L_divize = $get('<%= L_divize.ClientID %>');

                HF_divize.value = data.d_cislo;
                L_divize.innerText = data.d_nazev;

                var HF_skup_str = $get('<%= HF_skup_str.ClientID %>');
                var L_skup_str = $get('<%= L_skup_str.ClientID %>');

                HF_skup_str.value = data.ss_cislo;
                L_skup_str.innerText = data.ss_nazev;
            }
        }
        function OnTypKalChanged(sender, args) {
            var TRCB_smena = $find('<%= TRCB_smena.ClientID %>');
            TRCB_smena.clearSelection();
            TRCB_smena.clearItems();
        }
        function setTarif(sender, args) {
            var RNTB_e_tarif = $find('<%= RNTB_e_tarif.ClientID %>');
            if (RNTB_e_tarif) {
                var HF_typ_tt = $get('<%= HF_typ_tt_old.ClientID %>');
                var TRCB_typ_mzdy = $find('<%= TRCB_e_typ_mzdy.ClientID %>');
                var HF_typ_mzdy_old = $get('<%= HF_typ_mzdy_old.ClientID %>');
                var TRCB_trida = $find('<%= TRCB_trida.ClientID %>');
                var HF_trida_old = $get('<%= HF_trida_old.ClientID %>');
                var TRCB_stupen = $find('<%= TRCB_stupen.ClientID %>');
                var HF_mzd_stup_old = $get('<%= HF_mzd_stup_old.ClientID %>');

                var typ_tt = HF_typ_tt ? HF_typ_tt.value : null;
                var typ_mzdy = TRCB_typ_mzdy ? TRCB_typ_mzdy.get_value() : null;
                var typ_mzdy_old = HF_typ_mzdy_old ? HF_typ_mzdy_old.value : null;
                var trida = TRCB_trida ? (parseInt(TRCB_trida.get_text()) ? parseInt(TRCB_trida.get_text()) : null) : null;
                var trida_old = HF_trida_old ? HF_trida_old.value : null;
                var mzd_stup = TRCB_stupen ? (parseInt(TRCB_stupen.get_text()) ? parseInt(TRCB_stupen.get_text()) : null) : null;
                var mzd_stup_old = HF_mzd_stup_old ? HF_mzd_stup_old.value : null;

                PageMethods.GetTarif(typ_tt, typ_mzdy, typ_mzdy_old, trida, trida_old, mzd_stup, mzd_stup_old, sender ? true : false, setTarifCallBack);
            }
        }
        function setTarifCallBack(data) {
            var RNTB_e_tarif = $find('<%= RNTB_e_tarif.ClientID %>');
            RNTB_e_tarif.set_minValue(0);
            RNTB_e_tarif.set_maxValue(9999999);
            // PMEJ 13.05.2025 - Kontroluje se min a max pouze u Mesíční a hodinové mzdy. U smluvních a jiných se neprovádí.
            var TRCB_typ_mzdy = $find('<%= TRCB_e_typ_mzdy.ClientID %>');
            var typ_mzdy = TRCB_typ_mzdy ? TRCB_typ_mzdy.get_value() : null;

            if (data.UpdateTarif) {
                if (data.Tarif) {
                    RNTB_e_tarif.set_value(data.Tarif);
                }
                else {
                    RNTB_e_tarif.clear();
                }
            }

            var akt_tarif = RNTB_e_tarif.get_value();

            if (akt_tarif && data.MinTarif && akt_tarif < data.MinTarif) {
                RNTB_e_tarif.set_value(data.MinTarif);
            }

            if (akt_tarif && data.MaxTarif && akt_tarif > data.MaxTarif) {
                RNTB_e_tarif.set_value(data.MaxTarif);
            }
            // PMEJ 13.05.2025 - Kontroluje se min a max pouze u Mesíční a hodinové mzdy. U smluvních a jiných se neprovádí.
            if (typ_mzdy == 0 || typ_mzdy == 1) {
                if (data.MinTarif) {
                    RNTB_e_tarif.set_minValue(data.MinTarif);
                }

                if (data.MaxTarif) {
                    RNTB_e_tarif.set_maxValue(data.MaxTarif);
                }
            }
        }
    </script>
</telerik:RadScriptBlock>
<uc1:ZmppvCompare runat="server" ID="UC_Compare"></uc1:ZmppvCompare>
<asp:Panel runat="server" ID="inner_panel">
    <asp:HiddenField ID="HF_edit_os_cislo" runat="server" Value='<%# Bind("os_cislo") %>' />
    <asp:HiddenField ID="HF_edit_cislo_pom" runat="server" Value='<%# Bind("cislo_pom") %>' />
    <telerik:RadPageLayout runat="server" ID="RPL_ZmppvIF" GridType="Fluid" CssClass="rplInner">
        <Rows>
            <telerik:LayoutRow>
                <Columns>
                    <telerik:LayoutColumn Span="6" SpanXl="6" SpanLg="12" SpanMd="12" SpanSm="12" SpanXs="12">
                        <fieldset id="FS_os_cislo" runat="server" class="ksprvek ksfieldset">
                            <legend class="ksclass">[%Vyberte zaměstnance%]</legend>
                            <table class="InnerTableFormFieldset KsUnderlineTable" runat="server" id="table1">
                                <tr>
                                    <td>
                                        <kspwc:TRadComboBox ID="TRCB_insert_os_cislo" runat="server" EnableLoadOnDemand="True"
                                            EnableVirtualScrolling="True" Height="150px" ShowMoreResultsBox="True" DropDownAutoWidth="Enabled" MarkFirstMatch="true"
                                            EmptyMessage="[%Zaměstnanec%]" Label="[%Zaměstnanec%]" AutoPostBack="True" OnTextChanged="TRCB_insert_os_cislo_TextChanged"
                                            CausesValidation="False" OnClientItemsRequesting="TRCB_edit_os_cislo_ItemsRequesting" LabelCssClass="labelWidth">
                                            <WebServiceSettings Method="GetZamestnanci" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_insert_os_cislo" runat="server" CssClass="tdValidators" ControlToValidate="TRCB_insert_os_cislo"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Vyberte zaměstnance%]" Enabled="false">
                                        </asp:RequiredFieldValidator>
                                        <asp:CustomValidator ID="CV_os_cislo" runat="server" ControlToValidate="TRCB_insert_os_cislo" Display="Dynamic" EnableClientScript="true" Enabled="false"
                                            ErrorMessage="[%Není povoleno žádat o změnu vlastního poměru%]" Text="*" ClientValidationFunction="IsPrihlaseny">
                                        </asp:CustomValidator>
                                        <telerik:RadTextBox ID="RTB_edit_jmeno" runat="server" Resize="None"
                                            Width="300px" Label="[%Zaměstnanec%]" Text='<%# Bind("jmeno") %>' ReadOnly="True"
                                            LabelWidth="120px">
                                        </telerik:RadTextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <kspwc:TRadComboBox ID="TRCB_insert_prac_pom" runat="server" Label="[%Pracovní poměr%]"
                                            DataTextField="naz_mist" DataValueField="cislo_pom" Width="300px" DropDownAutoWidth="Enabled" AutoPostBack="true"
                                            OnSelectedIndexChanged="TRCB_insert_prac_pom_SelectedIndexChanged" CausesValidation="False" LabelCssClass="labelWidth">
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_insert_prac_pom" runat="server" CssClass="tdValidators" ControlToValidate="TRCB_insert_prac_pom"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Vyberte poměr%]" Enabled="false">
                                        </asp:RequiredFieldValidator>
                                        <telerik:RadTextBox ID="RTB_edit_cislo_pom_t" runat="server" Resize="None"
                                            Width="300px" Label="[%Pracovn&amp;#237; poměr%]" Text='<%# Bind("cislo_pom_t") %>'
                                            ReadOnly="True" LabelWidth="120px">
                                        </telerik:RadTextBox>
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </telerik:LayoutColumn>
                </Columns>
            </telerik:LayoutRow>
            <telerik:LayoutRow>
                <Columns>
                    <telerik:LayoutColumn Span="6" SpanXl="6" SpanLg="12" SpanMd="12" SpanSm="12" SpanXs="12">
                        <fieldset id="FS_edit_zam" runat="server" class="ksprvek ksfieldset">
                            <legend class="ksclass">[%Zaměstnanec%]</legend>
                            <table class="InnerTableFormFieldset KsUnderlineTable" runat="server" id="table_edit_zam">
                                <tr>
                                    <td>[%Rodné číslo%]
                                    </td>
                                    <td>
                                        <telerik:RadMaskedTextBox ID="RMTB_edit_rc" runat="server" EmptyMessage="[%Rodné číslo%]"
                                            Mask="&lt;0..9&gt;&lt;0..9&gt;&lt;0..9&gt;&lt;0..9&gt;&lt;0..9&gt;&lt;0..9&gt; / &lt;0..9&gt;&lt;0..9&gt;&lt;0..9&gt;#"
                                            Width="160px" LabelWidth="64px" ToolTip="[%Pokud jste cizinec, vyplňte rodné číslo ve tvaru: rrmmdd/000%]"
                                            Text='<%# Bind("rodne_cislo") %>' AutoPostBack="true" OnTextChanged="RMTB_edit_rc_TextChanged">
                                        </telerik:RadMaskedTextBox>
                                        <kspwc:TRadButton runat="server" ID="TRB_rc_info" OnClick="TRB_rc_info_Click" 
                                            ToolTip="[%Rodné číslo je již v evidenci%]"
                                            CausesValidation="false" Visible="false">
                                            <Icon PrimaryIconCssClass="fi fi-info ksRed" />
                                        </kspwc:TRadButton>
                                    </td>
                                    <td class="tdValidators">
<%--                                        <asp:CustomValidator ID="CV_rc_unique" runat="server" ClientValidationFunction="is_rc_unique" Display="Dynamic"
                                            ErrorMessage="[%Rodné číslo je již v evidenci%]" Text="[%Již existuje%]" ControlToValidate="RMTB_edit_rc" Enabled="false" CssClass="formatValidator"></asp:CustomValidator>--%>
                                        <asp:CustomValidator ID="CV_edit_rc" runat="server" ClientValidationFunction="rc_validate"
                                            Display="Dynamic" ErrorMessage="[%Rodné číslo není platné%]" Text="*" ControlToValidate="RMTB_edit_rc" Enabled="false" CssClass="formatValidator"></asp:CustomValidator>
                                        <asp:CustomValidator ID="RFV_edit_rc" runat="server" ClientValidationFunction="rc_is_not_empty" ControlToValidate="RMTB_edit_rc"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Rodné číslo je povinný údaj%]" Text="*" Enabled="false"></asp:CustomValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Osobní číslo%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_os_cislo" runat="server" EmptyMessage="[%Osobní číslo%]"
                                            Width="160px" LabelWidth="64px" Resize="None" ReadOnly="true"
                                            Text='<%# Bind("os_cislo") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>[%Titul před%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_titul_pred" runat="server" EmptyMessage="[%Titul před%]"
                                            Width="160px" LabelWidth="64px" Resize="None"
                                            Text='<%# Bind("titul") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td>&nbsp;
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Jméno%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_k_jmeno" runat="server" EmptyMessage="[%Jméno%]"
                                            Width="300px" LabelWidth="120px" Resize="None"
                                            Text='<%# Bind("k_jmeno") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_k_jmeno" runat="server" ControlToValidate="RTB_edit_k_jmeno"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Jméno je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Příjmení%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_prijmeni" runat="server" EmptyMessage="[%Příjmení%]"
                                            Width="300px" LabelWidth="120px" Resize="None"
                                            Text='<%# Bind("prijmeni") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_prijmeni" runat="server" ControlToValidate="RTB_edit_prijmeni"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Příjmení je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Rodné příjmení%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_rodne_jmeno" runat="server" EmptyMessage="[%Rodné příjmení%]"
                                            Width="300px" LabelWidth="120px" Resize="None" ToolTip="[%Vyplňte v případě, že máte rodné přijmení%]"
                                            Text='<%# Bind("rodne_jmeno") %>' MaxLength="40">
                                        </telerik:RadTextBox>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_rodne_jmeno" runat="server" ControlToValidate="RTB_edit_rodne_jmeno"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Rodné příjmení je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Dřívější příjmení%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_vsechna_prij" runat="server" EmptyMessage="[%Všechna dřívější příjmení%]"
                                            Width="300px" LabelWidth="120px" Resize="None" ToolTip="[%Vyplňte v případě, že máte dřívější přijmení%]"
                                            Text='<%# Bind("vsechna_prij") %>' MaxLength="80">
                                        </telerik:RadTextBox>
                                    </td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>[%Titul za%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_titul_za" runat="server" EmptyMessage="[%Titul za%]"
                                            Width="160px" LabelWidth="64px" Resize="None"
                                            Text='<%# Bind("titul_za") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td>&nbsp;
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </telerik:LayoutColumn>
                    <telerik:LayoutColumn Span="6" SpanXl="6" SpanLg="12" SpanMd="12" SpanSm="12" SpanXs="12">
                        <fieldset id="FS_insert_kontakt" runat="server" class="ksprvek ksfieldset">
                            <legend class="ksclass">[%Kontakt%] </legend>
                            <table class="InnerTableFormFieldset KsUnderlineTable" runat="server" id="table_insert_kontakt">
                                <tr>
                                    <td>[%Telefon%]
                                    </td>
                                    <td>
                                        <telerik:RadMaskedTextBox ID="RMTB_edit_telefon" runat="server" EmptyMessage="[%Telefon%]"
                                            Mask="+### ### ### ###" ToolTip="[%Vyplňtě váše osobní telefoní číslo%]"
                                            Width="160px" LabelWidth="64px"
                                            Text='<%# Bind("telefon") %>' CausesValidation="True">
                                        </telerik:RadMaskedTextBox>
                                        <%--<telerik:RadTextBox ID="RMTB_edit_telefon" runat="server" EmptyMessage="[%Telefon%]"
                                                Width="160px" LabelWidth="64px" Resize="None" InputType="Tel"
                                                 Text='<%# Bind("telefon") %>' MaxLength="13">
                                            </telerik:RadTextBox>--%>
                                        <telerik:RadLabel runat="server" ID="RL_edit_telefon">
                                        </telerik:RadLabel>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_telefon" runat="server" ControlToValidate="RMTB_edit_telefon"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Telefon je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                        <asp:CustomValidator ID="CV_edit_telefon" runat="server" ClientValidationFunction="telefon_validate"
                                            Display="Dynamic" ErrorMessage="[%Telefoní číslo není platné%]" Text="*" ControlToValidate="RMTB_edit_telefon" Enabled="false" CssClass="formatValidator"></asp:CustomValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%E-mail%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_email" runat="server" EmptyMessage="[%E-mail%]"
                                            Width="200px" LabelWidth="120px" Resize="None" ToolTip="[%Vyplňte Váš soukromý e-mail%]"
                                            Text='<%# Bind("email") %>' MaxLength="50">
                                        </telerik:RadTextBox>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:CustomValidator ID="CV_edit_email" runat="server" ClientValidationFunction="email_validate"
                                            Display="Dynamic" ErrorMessage="[%E-mail není platný%]" Text="*" ControlToValidate="RTB_edit_email" Enabled="false" CssClass="formatValidator"></asp:CustomValidator>
                                        <asp:RequiredFieldValidator ID="RFV_edit_email" runat="server" ControlToValidate="RTB_edit_email"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%E-mail je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Číslo účtu%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_cislo_uctu" runat="server" EmptyMessage="[%Číslo účtu%]"
                                            Width="200px" LabelWidth="120px" Resize="None"
                                            Text='<%# Bind("cislo_uctu") %>' MaxLength="17">
                                        </telerik:RadTextBox>
                                        <kspwc:TRadComboBox ID="TRCB_edit_kod_banky" runat="server" DataSourceID="ODS_kod_banky"
                                            DataTextField="cely_nazev" DataValueField="c_pole1" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%Kód banky%]" Height="150px" SelectedValue='<%# Bind("kod_banky") %>'
                                            Width="100px">
                                        </kspwc:TRadComboBox>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_cislo_uctu" runat="server" ControlToValidate="RTB_edit_cislo_uctu"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Číslo účtu je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                        <asp:CustomValidator ID="CV_edit_cislo_uctu" runat="server" ClientValidationFunction="cislo_uctu_validate"
                                            Display="Dynamic" ErrorMessage="[%Číslo účtu není platné%]" Text="*" ControlToValidate="RTB_edit_cislo_uctu" Enabled="false" CssClass="formatValidator"></asp:CustomValidator>
                                        <asp:RequiredFieldValidator ID="RFV_edit_kod_banky" runat="server" ControlToValidate="TRCB_edit_kod_banky"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Kód banky je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%IBAN%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_iban" runat="server" EmptyMessage="[%IBAN%]"
                                            Width="150px" LabelWidth="120px" Resize="None" ToolTip="[%Vyplňte v případě, že máte IBAN%]"
                                            Text='<%# Bind("iban") %>' MaxLength="50">
                                        </telerik:RadTextBox>
                                        <kspwc:TRadComboBox ID="TRCB_edit_swift" runat="server" DataSourceID="ODS_swift"
                                            DataTextField="cely_nazev" DataValueField="c_pole2" DropDownAutoWidth="Enabled" ToolTip="[%Vyplňte v případě, že máte SWIFT%]"
                                            EmptyMessage="[%SWIFT%]" Height="150px" SelectedValue='<%# Bind("swift") %>'
                                            Width="150px">
                                        </kspwc:TRadComboBox>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:CustomValidator ID="CV_edit_iban" runat="server" ClientValidationFunction="iban_validate"
                                            Display="Dynamic" ErrorMessage="[%IBAN není platný%]" Text="*" ControlToValidate="RTB_edit_iban" Enabled="false" CssClass="formatValidator"></asp:CustomValidator>
                                        <asp:RequiredFieldValidator ID="RFV_edit_iban" runat="server" ControlToValidate="RTB_edit_iban"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%IBAN je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                        <asp:RequiredFieldValidator ID="RFV_edit_swift" runat="server" ControlToValidate="TRCB_edit_swift"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%SWIFT je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </telerik:LayoutColumn>
                    <telerik:LayoutColumn Span="6" SpanXl="6" SpanLg="12" SpanMd="12" SpanSm="12" SpanXs="12">
                        <fieldset id="FS_insert_vzdelani" runat="server" class="ksprvek ksfieldset">
                            <legend class="ksclass">[%Nejvyšší dosažené vzdělání%] </legend>
                            <table class="InnerTableFormFieldset KsUnderlineTable" runat="server" id="table_insert_vzdelani">
                                <tr>
                                    <td>[%Stupeň%]
                                    </td>
                                    <td>
                                        <kspwc:TRadComboBox ID="TRCB_edit_vzd_stupen" runat="server" DataSourceID="ODS_stupen"
                                            DataTextField="cely_nazev" DataValueField="stupen" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%Stupeň%]" Height="150px" SelectedValue='<%# Bind("vzd_stupen") %>'
                                            Width="300px">
                                        </kspwc:TRadComboBox>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_vzd_stupen" runat="server" ControlToValidate="TRCB_edit_vzd_stupen"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Stupeň vdělání je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Obor%]
                                    </td>
                                    <td>
                                        <kspwc:TRadComboBox ID="TRCB_edit_vzd_obor" runat="server" DataSourceID="ODS_obor"
                                            DataTextField="vyznam" DataValueField="obor" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%Obor%]" Height="150px"
                                            Width="300px" OnClientDropDownOpening="dropDownOpening" OnClientItemsRequesting="dropDownItemsRequesting" OnClientKeyPressing="dropDownTextChange"
                                            EnableAutomaticLoadOnDemand="true" EnableVirtualScrolling="true" ShowMoreResultsBox="true" ItemsPerRequest="20" Filter="Contains">
                                        </kspwc:TRadComboBox>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_vzd_obor" runat="server" ControlToValidate="TRCB_edit_vzd_obor"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Obor Vzdělání je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </telerik:LayoutColumn>
                    <telerik:LayoutColumn Span="6" SpanXl="6" SpanLg="12" SpanMd="12" SpanSm="12" SpanXs="12">
                        <fieldset id="FS_insert_trv" runat="server" class="ksprvek ksfieldset">
                            <legend class="ksclass">[%Trvalé bydliště%] </legend>
                            <table class="InnerTableFormFieldset KsUnderlineTable" runat="server" id="table_insert_trv">
                                <tr>
                                    <td>[%Ulice%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_ulice" runat="server" EmptyMessage="[%Ulice%]"
                                            Width="300px" LabelWidth="120px" Resize="None"
                                            Text='<%# Bind("tr_ulice") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td colspan="2" class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_ulice" runat="server" ControlToValidate="RTB_edit_ulice"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Ulice trvalého bydliště je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Č.P.%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_cp" runat="server" EmptyMessage="[%Č.P.%]"
                                            Width="160px" LabelWidth="64px" Resize="None"
                                            Text='<%# Bind("tr_cislo") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td colspan="2" class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_cp" runat="server" ControlToValidate="RTB_edit_cp"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Číslo popisné trvalého bydliště je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Obec%]
                                    </td>
                                    <td>
                                        <kspwc:TRadComboBox ID="TRCB_edit_obec" runat="server" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%Obec%]" EnableLoadOnDemand="True" EnableVirtualScrolling="True"
                                            Height="150px" OnClientDropDownClosed="TRCB_psc_obec_DropDownClosed" OnClientItemsRequesting="obec_ItemsRequesting"
                                            ShowMoreResultsBox="True" Width="200px">
                                            <WebServiceSettings Method="GetObce" Path="../WebServices/AutoCompleteService.asmx" />
                                        </kspwc:TRadComboBox>
                                        <kspwc:TRadComboBox ID="TRCB_edit_stat_adr" runat="server" DataSourceID="ods_stat"
                                            DataTextField="cely_nazev" DataValueField="kod_znakovy2" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%Stát%]" Height="150px" SelectedValue='<%# Bind("stat_adr") %>'
                                            Width="100px">
                                        </kspwc:TRadComboBox>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_obec" runat="server" ControlToValidate="TRCB_edit_obec"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Obec trvalého bydliště je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_stat_adr" runat="server" ControlToValidate="TRCB_edit_stat_adr"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Stát trvalého bydličtě je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%PSČ%]
                                    </td>
                                    <td>
                                        <kspwc:TRadComboBox ID="TRCB_edit_psc" runat="server" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%PSČ%]" EnableLoadOnDemand="True" EnableVirtualScrolling="True"
                                            Height="150px" OnClientDropDownClosed="TRCB_psc_obec_DropDownClosed" OnClientItemsRequesting="psc_ItemsRequesting"
                                            ShowMoreResultsBox="True" Width="150px" MaxLength="5">
                                            <WebServiceSettings Method="GetPsc" Path="../WebServices/AutoCompleteService.asmx" />
                                        </kspwc:TRadComboBox>
                                        <telerik:RadTextBox ID="RTB_edit_trv_postcode" runat="server" EmptyMessage="[%Post Code%]"
                                            Width="150px" Resize="None" MaxLength="11"
                                            Text='<%# Bind("trv_postcode") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_psc" runat="server" ControlToValidate="TRCB_edit_psc"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%PSČ trvalého bydliště je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_trv_postcode" runat="server" ControlToValidate="RTB_edit_trv_postcode"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Post Code trvalého bydliště je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </telerik:LayoutColumn>
                    <telerik:LayoutColumn Span="6" SpanXl="6" SpanLg="12" SpanMd="12" SpanSm="12" SpanXs="12">
                        <fieldset id="FS_insert_prech" runat="server" class="ksprvek ksfieldset">
                            <legend class="ksclass">[%Doručovací adresa%] </legend>
                            <table class="InnerTableFormFieldset KsUnderlineTable" runat="server" id="table_insert_prech">
                                <tr>
                                    <td>[%Ulice%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_pr_ulice" runat="server" EmptyMessage="[%Ulice%]"
                                            Width="300px" LabelWidth="120px" Resize="None"
                                            Text='<%# Bind("pr_ulice") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td colspan="2" class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_pr_ulice" runat="server" ControlToValidate="RTB_edit_pr_ulice"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Ulice doručovací adresy je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Č.P.%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_pr_cislo" runat="server" EmptyMessage="[%Č.P.%]"
                                            Width="160px" LabelWidth="64px" Resize="None"
                                            Text='<%# Bind("pr_cislo") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td colspan="2" class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_pr_cislo" runat="server" ControlToValidate="RTB_edit_pr_cislo"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Číslo popisné doručovací adresy je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Obec%]
                                    </td>
                                    <td>
                                        <kspwc:TRadComboBox ID="TRCB_edit_misto_prech" runat="server" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%Obec%]" EnableLoadOnDemand="True" EnableVirtualScrolling="True"
                                            Height="150px" OnClientDropDownClosed="TRCB_psc_obec_DropDownClosed" OnClientItemsRequesting="obec_ItemsRequesting"
                                            ShowMoreResultsBox="True" Width="200px">
                                            <WebServiceSettings Method="GetObce" Path="../WebServices/AutoCompleteService.asmx" />
                                        </kspwc:TRadComboBox>
                                        <kspwc:TRadComboBox ID="TRCB_edit_prech_stat_adr" runat="server" DataSourceID="ods_stat"
                                            DataTextField="cely_nazev" DataValueField="kod_znakovy2" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%Stát%]" Height="150px" SelectedValue='<%# Bind("prech_stat_adr") %>'
                                            Width="100px">
                                        </kspwc:TRadComboBox>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_misto_prech" runat="server" ControlToValidate="TRCB_edit_misto_prech"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Obec doručovací adresy je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_prech_stat_adr" runat="server" ControlToValidate="TRCB_edit_prech_stat_adr"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Stát doručovací adresy je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%PSČ%]
                                    </td>
                                    <td>
                                        <kspwc:TRadComboBox ID="TRCB_edit_psc_prech" runat="server" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%PSČ%]" EnableLoadOnDemand="True" EnableVirtualScrolling="True"
                                            Height="150px" OnClientDropDownClosed="TRCB_psc_obec_DropDownClosed" OnClientItemsRequesting="psc_ItemsRequesting"
                                            ShowMoreResultsBox="True" Width="150px" MaxLength="5">
                                            <WebServiceSettings Method="GetPsc" Path="../WebServices/AutoCompleteService.asmx" />
                                        </kspwc:TRadComboBox>
                                        <telerik:RadTextBox ID="RTB_edit_prech_postcode" runat="server" EmptyMessage="[%Post Code%]"
                                            Width="150px" Resize="None" MaxLength="11"
                                            Text='<%# Bind("prech_postcode") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_psc_prech" runat="server" ControlToValidate="TRCB_edit_psc_prech"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%PSČ doručovací adresy je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_prech_postcode" runat="server" ControlToValidate="RTB_edit_prech_postcode"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Post Code doručovací adresy je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </telerik:LayoutColumn>
                </Columns>
            </telerik:LayoutRow>
            <telerik:LayoutRow>
                <Columns>
                    <telerik:LayoutColumn Span="6" SpanXl="6" SpanLg="12" SpanMd="12" SpanSm="12" SpanXs="12">
                        <fieldset id="FS_Evidencni" runat="server" class="ksprvek ksfieldset">
                            <legend class="ksclass">[%Evidenční údaje%]</legend>
                            <table class="InnerTableFormFieldset KsUnderlineTable" runat="server" id="table_Evidencni">
                                <tr>
                                    <td>[%Místo narození%]
                                    </td>
                                    <td>
                                        <kspwc:TRadComboBox ID="TRCB_edit_misto_nar" runat="server" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%Místo narození%]" EnableLoadOnDemand="True" EnableVirtualScrolling="True"
                                            Height="150px" ShowMoreResultsBox="True" Width="200px">
                                            <WebServiceSettings Method="GetObce" Path="../WebServices/AutoCompleteService.asmx" />
                                        </kspwc:TRadComboBox>
                                        <kspwc:TRadComboBox ID="TRCB_edit_stat_nar" runat="server" DataSourceID="ods_stat"
                                            DataTextField="cely_nazev" DataValueField="kod_znakovy2" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%Stát%]" Height="150px" SelectedValue='<%# Bind("stat_nar") %>'
                                            Width="100px">
                                        </kspwc:TRadComboBox>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_misto_nar" runat="server" ControlToValidate="TRCB_edit_misto_nar"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Místo narození je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                    <td class="tdValidators">
                                        <asp:RequiredFieldValidator ID="RFV_edit_stat_nar" runat="server" ControlToValidate="TRCB_edit_stat_nar"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Stát narození je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Rodinný stav%]
                                    </td>
                                    <td>
                                        <kspwc:TRadComboBox ID="TRCB_edit_rod_stav" runat="server" DataSourceID="ods_rodin_stav"
                                            DataTextField="nazev" DataValueField="cislo" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%Rodinný stav%]"
                                            SelectedValue='<%# Bind("rodin_stav") %>'>
                                        </kspwc:TRadComboBox>
                                    </td>
                                    <td class="tdValidators" colspan="2">
                                        <asp:RequiredFieldValidator ID="RFV_edit_rod_stav" runat="server" ControlToValidate="TRCB_edit_misto_nar"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Rodinný stav je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Počet dětí%]
                                    </td>
                                    <td>
                                        <telerik:RadNumericTextBox ID="RNTB_deti_pro_duch" runat="server" DataType="System.Int16" EmptyMessage="[%Počet dětí%]" ToolTip="[%Pro výpočet předpokládaného odchodu do důchodu%]"
                                            MaxValue="99" MinValue="0" DbValue='<%# Eval("deti_pro_duch") %>' Value="0" ShowSpinButtons="true">
                                            <NumberFormat DecimalDigits="0"></NumberFormat>
                                        </telerik:RadNumericTextBox>
                                    </td>
                                    <td class="tdValidators" colspan="2">
                                        <asp:RequiredFieldValidator ID="RFV_deti_pro_duch" runat="server" ControlToValidate="RNTB_deti_pro_duch"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Počet dětí pro důchod je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Státní příslušnost%]
                                    </td>
                                    <td>
                                        <kspwc:TRadComboBox ID="TRCB_edit_st_prisl" runat="server" DataSourceID="ods_st_prisl"
                                            DataTextField="<%#StatniPrislusnostCulture%>" DataValueField="kod_ciselny" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%Státní příslušnost%]" Height="150px" OnClientDropDownOpening="dropDownOpening" OnClientItemsRequesting="dropDownItemsRequesting" OnClientKeyPressing="dropDownTextChange"
                                            Width="300px" EnableAutomaticLoadOnDemand="true" EnableVirtualScrolling="true" ShowMoreResultsBox="true" ItemsPerRequest="20" Filter="Contains">
                                        </kspwc:TRadComboBox>
                                    </td>
                                    <td class="tdValidators" colspan="2">
                                        <asp:RequiredFieldValidator ID="RFV_edit_st_prisl" runat="server" ControlToValidate="TRCB_edit_st_prisl"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Státní příslušnost je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Číslo OP%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_cislo_op" runat="server" EmptyMessage="[%Číslo občanského průkazu%]"
                                            Width="160px" LabelWidth="64px" Resize="None" MaxLength="12"
                                            Text='<%# Bind("cislo_op") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td class="tdValidators" colspan="2">
                                        <asp:RequiredFieldValidator ID="RFV_edit_cislo_op" runat="server" ControlToValidate="RTB_edit_cislo_op"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Číslo OP je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Číslo pasu%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_cislo_pasu" runat="server" EmptyMessage="[%Číslo pasu%]"
                                            Width="160px" LabelWidth="64px" Resize="None" MaxLength="12"
                                            Text='<%# Bind("cislo_pasu") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td class="tdValidators" colspan="2">
                                        <asp:RequiredFieldValidator ID="RFV_edit_cislo_pasu" runat="server" ControlToValidate="RTB_edit_cislo_pasu"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Číslo pasu je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Č. dokladu k pobytu%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_c_pov_pobytu" runat="server" EmptyMessage="[%Číslo dokladu o povolení k pobytu%]"
                                            Width="160px" LabelWidth="64px" Resize="None" MaxLength="10"
                                            ToolTip="[%Vyplňte v případě, že máte v ČR trvalý nebo přechodný pobyt%]"
                                            Text='<%# Bind("c_pov_pobytu") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td class="tdValidators" colspan="2">
                                        <asp:RequiredFieldValidator ID="RFV_edit_c_pov_pobytu" runat="server" ControlToValidate="RTB_edit_c_pov_pobytu"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Číslo dokladu o povolení k pobytu je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Povolení k pobytu%]
                                    </td>
                                    <td>
                                        <telerik:RadTextBox ID="RTB_edit_vydal_povol_pobyt" runat="server" EmptyMessage="[%Orgán který vydal povolení k pobytu%]"
                                            Width="300px" LabelWidth="64px" Resize="None" MaxLength="100"
                                            Text='<%# Bind("vydal_povol_pobyt") %>'>
                                        </telerik:RadTextBox>
                                    </td>
                                    <td class="tdValidators" colspan="2">
                                        <asp:RequiredFieldValidator ID="RFV_edit_vydal_povol_pobyt" runat="server" ControlToValidate="RTB_edit_vydal_povol_pobyt"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Orgán který vydal povolení k pobytu je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Řidičský průkaz B%]
                                    </td>
                                    <td>
                                        <asp:RadioButtonList ID="RBL_edit_rp" runat="server" RepeatDirection="Horizontal" SelectedValue='<%# Bind("rp") %>'>
                                            <asp:ListItem Text="[%Ne%]" Value="0" Selected="True"></asp:ListItem>
                                            <asp:ListItem Text="[%Ano%]" Value="1"></asp:ListItem>
                                        </asp:RadioButtonList>
                                    </td>
                                    <td colspan="2"></td>
                                </tr>
                                <tr>
                                    <td>[%Zdr. pojišťovna%]
                                    </td>
                                    <td>
                                        <kspwc:TRadComboBox ID="TRCB_edit_zdrav_poj" runat="server" DataSourceID="ods_zdrav_poj"
                                            DataTextField="cely_nazev" DataValueField="n_pole1" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%Zdravotí pojišťovna%]" Height="150px" SelectedValue='<%# Bind("zdrav_poj") %>'
                                            Width="300px"
                                            ToolTip="[%Pokud jste cizinec, prosíme přiložte sken kartičky pojištěnce. Pokud nemáte zdravotní pojištění v ČR, prosíme vyberte kód '999' nebo '9999'%]">
                                        </kspwc:TRadComboBox>
                                    </td>
                                    <td class="tdValidators" colspan="2">
                                        <asp:RequiredFieldValidator ID="RFV_edit_zdrav_poj" runat="server" ControlToValidate="TRCB_edit_zdrav_poj"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Zdravotní pojišťovna je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Invalidita%]
                                    </td>
                                    <td>
                                        <kspwc:TRadComboBox ID="TRCB_edit_inv_stupen" runat="server" DataSourceID="ods_duchod"
                                            DataTextField="nazev" DataValueField="cislo" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%Stupeň%]" SelectedValue='<%# Bind("inv_stupen") %>'
                                            Width="160px">
                                        </kspwc:TRadComboBox>
                                        <kspwc:TRadDatePicker ID="TRDP_inv_od" runat="server" DropDownAutoWidth="Enabled"
                                            Width="140px"
                                            DbSelectedDate='<%# Bind("inv_od") %>'>
                                            <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" EmptyMessage="[%Datum od%]">
                                            </DateInput>
                                        </kspwc:TRadDatePicker>
                                    </td>
                                    <td colspan="2"></td>
                                </tr>
                                <tr>
                                    <td>[%Zdravotní postižení%]
                                    </td>
                                    <td>
                                        <asp:RadioButtonList ID="RBL_edit_postizeni" runat="server" RepeatDirection="Horizontal" SelectedValue='<%# Bind("postizeni") %>'>
                                            <asp:ListItem Text="[%Ne%]" Value="0" Selected="True"></asp:ListItem>
                                            <asp:ListItem Text="[%Ano%]" Value="1"></asp:ListItem>
                                        </asp:RadioButtonList>
                                    </td>
                                    <td colspan="2"></td>
                                </tr>
                                <tr>
                                    <td>[%Exekuce / Insolvence%]
                                    </td>
                                    <td>
                                        <asp:RadioButtonList ID="RBL_edit_exekuce" runat="server" RepeatDirection="Horizontal" SelectedValue='<%# Bind("exekuce") %>'>
                                            <asp:ListItem Text="[%Ne%]" Value="0" Selected="True"></asp:ListItem>
                                            <asp:ListItem Text="[%Ano%]" Value="1"></asp:ListItem>
                                        </asp:RadioButtonList>
                                    </td>
                                    <td colspan="2"></td>
                                </tr>
                                <tr>
                                    <td>[%Kmenové středisko%]
                                    </td>
                                    <td>
                                        <kspwc:TRadComboBox ID="TRCB_edit_kmen_str" runat="server" DropDownAutoWidth="Enabled"
                                            EmptyMessage="[%Kmenové středisko%]" Height="150px" Width="300px" DataSourceID="ods_kmen_str"
                                            DataTextField="cely_nazev" DataValueField="str"
                                            SelectedValue='<%# Bind("kmen_str") %>'>
                                        </kspwc:TRadComboBox>
                                    </td>
                                    <td class="tdValidators" colspan="2">
                                        <asp:RequiredFieldValidator ID="RFV_edit_kmen_str" runat="server" ControlToValidate="TRCB_edit_kmen_str"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Kmenové středisko je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Datum nástupu%]
                                    </td>
                                    <td>
                                        <kspwc:TRadDatePicker ID="TRDP_edit_datum_nast" runat="server" DropDownAutoWidth="Enabled"
                                            Width="160px"
                                            DbSelectedDate='<%# Bind("datum_nastupu") %>'>
                                            <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" EmptyMessage="[%Datum nástupu%]">
                                            </DateInput>
                                            <ClientEvents OnDateSelected="TRDP_edit_datum_nast_OnDateSelected" />
                                        </kspwc:TRadDatePicker>
                                    </td>
                                    <td class="tdValidators" colspan="2">
                                        <asp:RequiredFieldValidator ID="RFV_edit_datum_nast" runat="server" ControlToValidate="TRDP_edit_datum_nast"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Datum nástupu je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Požad. datum vyřízení%]
                                    </td>
                                    <td>
                                        <kspwc:TRadDatePicker ID="TRDP_edit_vyridit_do" runat="server" DropDownAutoWidth="Enabled" ShowPopupOnFocus="true"
                                            Width="160px" DbSelectedDate='<%# Bind("vyridit_do") %>'>
                                            <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" EmptyMessage="[%Vyřídit do%]">
                                            </DateInput>
                                        </kspwc:TRadDatePicker>
                                    </td>
                                    <td class="tdValidators" colspan="2">
                                        <asp:RequiredFieldValidator ID="RFV_edit_vyridit_do" runat="server" ControlToValidate="TRDP_edit_vyridit_do"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Požadované datum vyřízení je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>[%Platnost změny od%]
                                    </td>
                                    <td>
                                        <%--<kspwc:TRadDatePicker ID="TRDP_plati_od" runat="server" DropDownAutoWidth="Enabled"
                                                Width="160px" DbSelectedDate='<%# Bind("plati_od") %>'
                                                >
                                                <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" EmptyMessage="[%Platnost změny od%]">
                                                </DateInput>
                                            </kspwc:TRadDatePicker>--%>
                                        <kspwc:TRadMonthYearPicker runat="server" ID="TRMYP_plati_od" DbSelectedDate='<%# Bind("plati_od") %>' Width="160px"
                                            OnSelectedDateChanged="TRMYP_plati_od_SelectedDateChanged" AutoPostBack="true">
                                            <DateInput DateFormat="MMMM yyyy" DisplayDateFormat="MMMM yyyy" EmptyMessage="[%Platnost změny od%]">
                                            </DateInput>
                                        </kspwc:TRadMonthYearPicker>
                                    </td>
                                    <td class="tdValidators" colspan="2">
                                        <asp:RequiredFieldValidator ID="RFV_plati_od" runat="server" ControlToValidate="TRMYP_plati_od"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Platnost změny od je povinný údaj%]" Enabled="false"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </telerik:LayoutColumn>
                    <telerik:LayoutColumn Span="6" SpanXl="6" SpanLg="12" SpanMd="12" SpanSm="12" SpanXs="12">
                        <fieldset id="FS_dokumenty_p" runat="server" class="ksprvek ksfieldset">
                            <legend class="ksclass">[%Přijaté dokumenty%]</legend>
                            <kspwc:TRadGrid runat="server" ID="TRG_dokumenty_p" AutoMasterGridWidth="true" AutoGenerateColumns="false" OnNeedDataSource="TRG_dokumenty_p_NeedDataSource" CaptionVisible="false" CssClass="ksRgdokumenty_p"
                                OnItemDataBound="TRG_dokumenty_p_ItemDataBound" OnItemCommand="TRG_dokumenty_p_ItemCommand" OnUpdateCommand="TRG_dokumenty_p_UpdateCommand" OnInsertCommand="TRG_dokumenty_p_InsertCommand"
                                AllowAutomaticUpdates="false" OnDeleteCommand="TRG_dokumenty_p_DeleteCommand" OnLoad="TRG_dokumenty_p_Load">
                                <ValidationSettings EnableValidation="false" />
                                <MasterTableView DataKeyNames="typ,id_blob,md5,nazev,id" ClientDataKeyNames="md5" EditMode="InPlace" CommandItemDisplay="Top">
                                    <CommandItemTemplate>
                                        <kspwc:GridCommandItemControl ID="GCIC_dokumenty_p" runat="server">
                                            <AddNewItemButton runat="server" Visible="true" CausesValidation="false"></AddNewItemButton>
                                            <FilterButton runat="server" Visible="false"></FilterButton>
                                            <ExportButton runat="server" Visible="false"></ExportButton>
                                            <RebindButton runat="server" CausesValidation="false"></RebindButton>
                                        </kspwc:GridCommandItemControl>
                                    </CommandItemTemplate>
                                    <EditFormSettings>
                                        <EditColumn ButtonType="ImageButton"></EditColumn>
                                    </EditFormSettings>
                                    <Columns>
                                        <telerik:GridEditCommandColumn ButtonType="ImageButton"></telerik:GridEditCommandColumn>
                                        <telerik:GridDropDownColumn DataField="typ" DataType="System.String" UniqueName="typ_dokumentu" HeaderText="[%Dokument%]"
                                            DataSourceID="ODS_dokumenty_p" ListValueField="id" ListTextField="nazev">
                                        </telerik:GridDropDownColumn>
                                        <telerik:GridAttachmentColumn UploadControlType="RadAsyncUpload"
                                            HeaderText="[%Dokument%]"
                                            FileNameTextField="nazev" DataTextField="nazev"
                                            UniqueName="dokument" AllowedFileExtensions="txt,bmp,jpg,png,doc,docx,xml,csv,xls,xlsx,ods,odt,pdf"
                                            ButtonCssClass="no-block-ui">
                                        </telerik:GridAttachmentColumn>
                                        <telerik:GridButtonColumn ButtonType="ImageButton" HeaderTooltip="[%Smazat%]" CommandName="Delete" />
                                    </Columns>
                                </MasterTableView>
                            </kspwc:TRadGrid>
                            <kspwc:TCustomValidator runat="server" ID="CV_dokumenty_p" ClientValidationFunction="dokumenty_validate" CssClass="tableValidators"
                                Display="Dynamic" ErrorMessage="[%Nejsou připojeny povinné dokumenty%]" Text="*"></kspwc:TCustomValidator>
                            <telerik:RadScriptBlock ID="RSB_dokumenty" runat="server">
                                <script type="text/javascript" id="rsb_dokumenty">
                                    function dokumenty_validate(sender, args) {
                                        var items = $find(sender.closest("fieldset").getElementsByClassName("RadGrid")[0].id).get_masterTableView().get_dataItems();
                                        items.forEach(x => {
                                            if (!x.getDataKeyValue("md5")) {
                                                args.IsValid = false;
                                            }
                                        });
                                    }
                                </script>
                            </telerik:RadScriptBlock>
                        </fieldset>
                    </telerik:LayoutColumn>
                </Columns>
            </telerik:LayoutRow>
            <telerik:LayoutRow>
                <Columns>
                    <telerik:LayoutColumn ID="LC_pomer" Span="7" SpanXl="7" SpanLg="12" SpanMd="12" SpanSm="12" SpanXs="12">
                        <fieldset id="FS_pomer" runat="server" class="ksprvek ksfieldset">
                            <legend class="ksclass">[%Údaje o pracovním poměru%]</legend>
                            <asp:Table ID="TableEdit" runat="server" CssClass="InnerTableFormFieldset oldValues KsUnderlineTable">
                                <asp:TableRow runat="server" ID="TRE_header" CssClass="ppHeader nadpis3">
                                    <asp:TableCell runat="server" ID="TableCellItemHlavicka1"></asp:TableCell>
                                    <asp:TableCell runat="server" ID="TableCell73" Text="[%Původní hodnoty%]" HorizontalAlign="Center"></asp:TableCell>
                                    <asp:TableCell runat="server" ID="TableCell74" Text="[%Nové hodnoty%]" HorizontalAlign="Center"></asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow17" runat="server">
                                    <asp:TableCell runat="server" ID="TableCellItem3" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelid_pracmist"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_id_pracmist">
                                        <asp:HiddenField runat="server" ID="HF_id_pracmist_old" Value='<%# Eval("k_id_pracmist_old") %>' />
                                        <asp:Label runat="server" ID="L_id_pracmist_old" Text='<%# Eval("id_pracmist_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_id_pracmist">
                                        <kspwc:TRadComboBox ID="TRCB_e_id_pracmist" runat="server" DataTextField="cely_nazev"
                                            DataValueField="id" DropDownAutoWidth="Enabled" EmptyMessage="[%Pracovní místo%]"
                                            Height="150" DataSourceID="ods_prac_mista" Width="300px" OnClientDropDownOpening="dropDownOpening" OnClientItemsRequesting="dropDownItemsRequesting" OnClientKeyPressing="dropDownTextChange"
                                            EnableAutomaticLoadOnDemand="true" EnableVirtualScrolling="true" ShowMoreResultsBox="true" ItemsPerRequest="20" Filter="Contains"
                                            OnSelectedIndexChanged="TRCB_e_id_pracmist_SelectedIndexChanged" AutoPostBack="True" CausesValidation="False">
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_id_pracmist" runat="server" ControlToValidate="TRCB_e_id_pracmist"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Pracovní místo je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow28" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell18" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelprimy_nadrizeny"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_primy_nadrizeny">
                                        <asp:HiddenField runat="server" ID="HF_primy_nadrizeny_old" Value='<%# Eval("k_primy_nadrizeny_old") %>' />
                                        <asp:Label runat="server" ID="L_primy_nadrizeny_old" Text='<%# Eval("primy_nadrizeny_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_primy_nadrizeny">
                                        <asp:HiddenField runat="server" ID="HF_primy_nadrizeny" Value='<%# Eval("primy_nadrizeny") %>' />
                                        <asp:Label runat="server" ID="L_primy_nadrizeny" Text='<%# Eval("primy_nadrizeny_t") %>' />
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow29" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell19" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelkmen_str_p"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_kmen_str_p">
                                        <asp:HiddenField runat="server" ID="HF_kmen_str_p_old" Value='<%# Eval("k_kmen_str_p_old") %>' />
                                        <asp:Label runat="server" ID="L_kmen_str_p_old" Text='<%# Eval("kmen_str_p_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_kmen_str_p">
                                        <kspwc:TRadComboBox ID="TRCB_e_kmen_str_p" runat="server" DataTextField="cely_nazev"
                                            DataValueField="str" DropDownAutoWidth="Enabled" EmptyMessage="[%Kmenové středisko%]"
                                            Height="150px" Width="300px" DataSourceID="ods_kmen_str"
                                            SelectedValue='<%# Eval("kmen_str_p") %>'>
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_kmen_str_p" runat="server" ControlToValidate="TRCB_e_kmen_str_p"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Kmenové středisko je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow1" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell1" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelprac_str"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_prac_str">
                                        <asp:HiddenField runat="server" ID="HF_prac_str_old" Value='<%# Eval("k_prac_str_old") %>' />
                                        <asp:Label runat="server" ID="L_prac_str_old" Text='<%# Eval("prac_str_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_prac_str">
                                        <kspwc:TRadComboBox ID="TRCB_e_prac_str" runat="server" DataTextField="cely_nazev"
                                            DataValueField="str" DropDownAutoWidth="Enabled" EmptyMessage="[%Pracovní středisko%]"
                                            Height="150px" Width="300px" DataSourceID="ods_kmen_str" OnClientSelectedIndexChanged="TRCB_prac_str_SelectedIndexChanged"
                                            SelectedValue='<%# Eval("prac_str") %>'>
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_prac_str" runat="server" ControlToValidate="TRCB_e_prac_str"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Pracovní středisko je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow24" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell12" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labeldivize"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_divize">
                                        <asp:HiddenField runat="server" ID="HF_divize_old" Value='<%# Eval("k_divize_old") %>' />
                                        <asp:Label runat="server" ID="L_divize_old" Text='<%# Eval("divize_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_divize">
                                        <asp:HiddenField runat="server" ID="HF_divize" Value='<%# Eval("divize") %>' />
                                        <asp:Label runat="server" ID="L_divize" Text='<%# Eval("divize_t") %>' />
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow25" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell14" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelskup_str"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_skup_str">
                                        <asp:HiddenField runat="server" ID="HF_skup_str_old" Value='<%# Eval("k_skup_str_old") %>' />
                                        <asp:Label runat="server" ID="L_skup_str_old" Text='<%# Eval("skup_str_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_skup_str">
                                        <asp:HiddenField runat="server" ID="HF_skup_str" Value='<%# Eval("skup_str") %>' />
                                        <asp:Label runat="server" ID="L_skup_str" Text='<%# Eval("skup_str_t") %>' />
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow23" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell11" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelskup_prac"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_skup_prac">
                                        <asp:HiddenField runat="server" ID="HF_skup_prac_old" Value='<%# Eval("k_skup_prac_old") %>' />
                                        <asp:Label runat="server" ID="L_skup_prac_old" Text='<%# Eval("skup_prac_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_skup_prac">
                                        <kspwc:TRadComboBox ID="TRCB_e_skup_prac" runat="server" DataTextField="vyznam"
                                            DataValueField="cislo" DropDownAutoWidth="Enabled" EmptyMessage="[%Skupina pracujících%]"
                                            DataSourceID="ods_skup_prac" Width="300px" SelectedValue='<%# Eval("skup_prac") %>'>
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_skup_prac" runat="server" ControlToValidate="TRCB_e_skup_prac"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Skupina pracujících je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow2" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell4" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labeldruh_pom_j"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_druh_pom_j">
                                        <asp:HiddenField runat="server" ID="HF_druh_pom_j_old" Value='<%# Eval("k_druh_pom_j_old") %>' />
                                        <asp:Label runat="server" ID="L_druh_pom_j_old" Text='<%# Eval("druh_pom_j_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_druh_pom_j">
                                        <kspwc:TRadComboBox ID="TRCB_e_druh_pom_j" runat="server" DataTextField="vyznam"
                                            DataValueField="uziv_druh" DropDownAutoWidth="Enabled" EmptyMessage="[%Druh poměru%]"
                                            DataSourceID="ods_druh_pom" Width="160px" Text='<%# Eval("druh_pom_j_t") %>'>
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_druh_pom_j" runat="server" ControlToValidate="TRCB_e_druh_pom_j"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Druh poměru je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow27" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell17" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelmisto_vykonu"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_misto_vykonu">
                                        <asp:HiddenField runat="server" ID="HF_misto_vykonu_old" Value='<%# Eval("k_misto_vykonu_old") %>' />
                                        <asp:Label runat="server" ID="L_misto_vykonu_old" Text='<%# Eval("misto_vykonu_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_misto_vykonu">
                                        <telerik:RadTextBox runat="server" ID="RTB_misto_vykonu" Text='<%# Eval("misto_vykonu") %>' MaxLength="50" EmptyMessage="[%Místo výkonu%]"></telerik:RadTextBox>
                                        <asp:RequiredFieldValidator ID="RFV_misto_vykonu" runat="server" ControlToValidate="RTB_misto_vykonu"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Místo výkonu je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow21" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell8" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labeltyp_tt"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_typ_tt">
                                        <asp:HiddenField runat="server" ID="HF_typ_tt_old" Value='<%# Eval("k_typ_tt_old") %>' />
                                        <asp:Label runat="server" ID="L_typ_tt_old" Text='<%# Eval("typ_tt_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_typ_tt">
                                        <telerik:RadNumericTextBox ID="RNTB_typ_tt" runat="server" DataType="System.Int16"
                                            MaxValue="32767" MinValue="0" DbValue='<%# Eval("typ_tt") %>'>
                                            <NumberFormat DecimalDigits="0" GroupSizes="9"></NumberFormat>
                                        </telerik:RadNumericTextBox>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow3" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labeltyp_mzdy"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_typ_mzdy">
                                        <asp:HiddenField runat="server" ID="HF_typ_mzdy_old" Value='<%# Eval("k_typ_mzdy_old") %>' />
                                        <asp:Label runat="server" ID="L_typ_mzdy_old" Text='<%# Eval("typ_mzdy_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_typ_mzdy">
                                        <kspwc:TRadComboBox ID="TRCB_e_typ_mzdy" runat="server" DataTextField="nazev" DataValueField="cislo" OnClientSelectedIndexChanged="setTarif"
                                            DropDownAutoWidth="Enabled" EmptyMessage="[%Typ mzdy%]" DataSourceID="ods_typ_mzdy" Text='<%# Eval("typ_mzdy_t") %>'
                                            Width="160px">
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_typ_mzdy" runat="server" ControlToValidate="TRCB_e_typ_mzdy"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Typ mzdy je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow4" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell10" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labeltrida"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_trida">
                                        <asp:HiddenField runat="server" ID="HF_trida_old" Value='<%# Eval("k_trida_old") %>' />
                                        <asp:Label runat="server" ID="L_trida_old" Text='<%# Eval("trida_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_trida">
                                        <%--<telerik:RadNumericTextBox ID="RNTB_e_trida" runat="server" DataType="System.Int16"
                                            MaxValue="32767" MinValue="0" EmptyMessage="[%Třída%]" DbValue='<%# Eval("trida") %>'>
                                            <NumberFormat DecimalDigits="0" GroupSizes="9"></NumberFormat>
                                        </telerik:RadNumericTextBox>--%>
                                        <kspwc:TRadComboBox ID="TRCB_trida" runat="server" DropDownAutoWidth="Enabled" CloseDropDownOnBlur="true" EmptyMessage="[%Třída%]"
                                            EnableLoadOnDemand="true" Height="150px" OnClientItemsRequesting="trida_ItemsRequesting" OnClientDropDownClosed="comboDropDownClosed"
                                            ShowMoreResultsBox="false" Text='<%# Eval("trida") %>' OnClientTextChange="TRCB_trida_TextChange" OnClientSelectedIndexChanged="setTarif">
                                            <WebServiceSettings Method="GetTrida" Path="../WebServices/AutoCompleteService.asmx" />
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_trida" runat="server" ControlToValidate="TRCB_trida"
                                            Display="Dynamic" EnableClientScript="True" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow5" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell13" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelmzd_stup"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_mzd_stup">
                                        <asp:HiddenField runat="server" ID="HF_mzd_stup_old" Value='<%# Eval("k_mzd_stup_old") %>' />
                                        <asp:Label runat="server" ID="L_mzd_stup_old" Text='<%# Eval("mzd_stup_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_mzd_stup">
                                        <kspwc:TRadComboBox ID="TRCB_stupen" runat="server" DropDownAutoWidth="Enabled" CloseDropDownOnBlur="true" EmptyMessage="[%Stupeň%]"
                                            EnableLoadOnDemand="true" Height="150px" OnClientItemsRequesting="mzd_stup_ItemsRequesting" OnClientDropDownClosed="comboDropDownClosed"
                                            ShowMoreResultsBox="false" Text='<%# Eval("mzd_stup") %>' OnClientTextChange="TRCB_trida_TextChange" OnClientSelectedIndexChanged="setTarif">
                                            <WebServiceSettings Method="GetMzdStupen" Path="../WebServices/AutoCompleteService.asmx" />
                                        </kspwc:TRadComboBox>
                                        <%--<telerik:RadNumericTextBox ID="RNTB_e_stupen" runat="server" DataType="System.Int16"
                                            MaxValue="32767" MinValue="0" EmptyMessage="[%Stupeň%]" DbValue='<%# Eval("mzd_stup") %>'>
                                            <NumberFormat DecimalDigits="0" GroupSizes="9"></NumberFormat>
                                        </telerik:RadNumericTextBox>--%>
                                        <asp:RequiredFieldValidator ID="RFV_e_stupen" runat="server" ControlToValidate="TRCB_stupen"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Stupeň je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow6" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell16" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labeltarif"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_tarif">
                                        <asp:HiddenField runat="server" ID="HF_tarif_old" Value='<%# Eval("k_tarif_old") %>' />
                                        <asp:Label runat="server" ID="L_tarif_old" Text='<%# Eval("tarif_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_tarif">
                                        <telerik:RadNumericTextBox ID="RNTB_e_tarif" runat="server" DataType="System.Decimal"
                                            MaxValue="9999999" MinValue="0" EmptyMessage="[%Tarif%]" DbValue='<%# Eval("tarif") %>'>
                                        </telerik:RadNumericTextBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_tarif" runat="server" ControlToValidate="RNTB_e_tarif"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Tarif je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow19" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelos_hodn"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_os_hodn">
                                        <asp:HiddenField runat="server" ID="HF_os_hodn_old" Value='<%# Eval("k_os_hodn_old") %>' />
                                        <asp:Label runat="server" ID="L_os_hodn_old" Text='<%# Eval("os_hodn_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_os_hodn">
                                        <telerik:RadNumericTextBox ID="RNTB_e_os_hodn" runat="server" DataType="System.Decimal"
                                            MaxValue="99999" MinValue="0" EmptyMessage="[%Osobní příplatek%]" DbValue='<%# Eval("os_hodn") %>'>
                                        </telerik:RadNumericTextBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_os_hodn" runat="server" ControlToValidate="RNTB_e_os_hodn"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Osobní příplatek je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow20" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell6" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelprem_cast"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_prem_cast">
                                        <asp:HiddenField runat="server" ID="HF_prem_cast_old" Value='<%# Eval("k_prem_cast_old") %>' />
                                        <asp:Label runat="server" ID="L_prem_cast_old" Text='<%# Eval("prem_cast_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_prem_cast">
                                        <telerik:RadNumericTextBox ID="RNTB_e_prem_cast" runat="server" DataType="System.Decimal"
                                            MaxValue="9999999" MinValue="0" DbValue='<%# Eval("prem_cast") %>'>
                                        </telerik:RadNumericTextBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_prem_cast" runat="server" ControlToValidate="RNTB_e_prem_cast"
                                            Display="Dynamic" EnableClientScript="True" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow26" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell15" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labeltyp_premii"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_typ_premii">
                                        <asp:HiddenField runat="server" ID="HF_typ_premii_old" Value='<%# Eval("k_typ_premii_old") %>' />
                                        <asp:Label runat="server" ID="L_typ_premii_old" Text='<%# Eval("typ_premii_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_typ_premii">
                                        <kspwc:TRadComboBox ID="TRCB_typ_premii" runat="server" DataTextField="cely_nazev"
                                            DataValueField="kod" DropDownAutoWidth="Enabled" EmptyMessage="[%Typ prémií%]"
                                            DataSourceID="ods_typ_premii" Width="300px" SelectedValue='<%# Eval("typ_premii") %>'>
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_typ_premii" runat="server" ControlToValidate="TRCB_typ_premii"
                                            Display="Dynamic" EnableClientScript="True" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow30" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell20" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelpripl_vedeni"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_pripl_vedeni">
                                        <asp:HiddenField runat="server" ID="HF_pripl_vedeni_old" Value='<%# Eval("k_pripl_vedeni_old") %>' />
                                        <asp:Label runat="server" ID="L_pripl_vedeni_old" Text='<%# Eval("pripl_vedeni_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_pripl_vedeni">
                                        <telerik:RadNumericTextBox ID="RNTB_e_pripl_vedeni" runat="server" DataType="System.Decimal"
                                            MaxValue="99999" MinValue="0" DbValue='<%# Eval("pripl_vedeni") %>'>
                                        </telerik:RadNumericTextBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_pripl_vedeni" runat="server" ControlToValidate="RNTB_e_pripl_vedeni"
                                            Display="Dynamic" EnableClientScript="True" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow31" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell24" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelpripl_zvlastni"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_pripl_zvlastni">
                                        <asp:HiddenField runat="server" ID="HF_pripl_zvlastni_old" Value='<%# Eval("k_pripl_zvlastni_old") %>' />
                                        <asp:Label runat="server" ID="L_pripl_zvlastni_old" Text='<%# Eval("pripl_zvlastni_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_pripl_zvlastni">
                                        <telerik:RadNumericTextBox ID="RNTB_e_pripl_zvlastni" runat="server" DataType="System.Decimal"
                                            MaxValue="99999" MinValue="0" DbValue='<%# Eval("pripl_zvlastni") %>'>
                                        </telerik:RadNumericTextBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_pripl_zvlastni" runat="server" ControlToValidate="RNTB_e_pripl_zvlastni"
                                            Display="Dynamic" EnableClientScript="True" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow12" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell34" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labeldoba_uvazku"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_doba_uvazku">
                                        <asp:HiddenField runat="server" ID="HF_doba_uvazku_old" Value='<%# Eval("k_doba_uvazku_old") %>' />
                                        <asp:Label runat="server" ID="L_doba_uvazku_old" Text='<%# Eval("doba_uvazku_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_doba_uvazku">
                                        <kspwc:TRadComboBox ID="TRCB_e_doba_uvazku" runat="server" DataTextField="vyznam"
                                            DataValueField="cislo" DropDownAutoWidth="Enabled" EmptyMessage="[%Délka úvazku%]"
                                            DataSourceID="ods_doba_uvazku" Width="300px" SelectedValue='<%# Eval("doba_uvazku") %>'>
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_doba_uvazku" runat="server" ControlToValidate="TRCB_e_doba_uvazku"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Délka úvazku je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow8" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell22" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelpp_datum_nastupu"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_pp_datum_nastupu">
                                        <asp:HiddenField runat="server" ID="HF_pp_datum_nastupu_old" Value='<%# Eval("k_pp_datum_nastupu_old") %>' />
                                        <asp:Label runat="server" ID="L_pp_datum_nastupu_old" Text='<%# Eval("pp_datum_nastupu_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_pp_datum_nastupu">
                                        <kspwc:TRadDatePicker ID="TRDP_e_pp_datum_nastupu" runat="server" Width="160px" DbSelectedDate='<%# Eval("pp_datum_nastupu") %>'>
                                            <DateInput EmptyMessage="[%Zahájení pracovního poměru%]">
                                            </DateInput>
                                            <ClientEvents OnDateSelected="TRDP_i_datum_nastupu_OnDateSelected" />
                                        </kspwc:TRadDatePicker>
                                        <asp:RequiredFieldValidator ID="RFV_e_pp_datum_nastupu" runat="server" ControlToValidate="TRDP_e_pp_datum_nastupu"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Zahájení prac. poměru je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow7" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell2" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labeldatum_skut_nast"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_datum_skut_nast">
                                        <asp:HiddenField runat="server" ID="HF_datum_skut_nast_old" Value='<%# Eval("k_datum_skut_nast_old") %>' />
                                        <asp:Label runat="server" ID="L_datum_skut_nast_old" Text='<%# Eval("datum_skut_nast_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_datum_skut_nast">
                                        <kspwc:TRadDatePicker ID="TRDP_e_datum_skut_nast" runat="server" Width="160px" DbSelectedDate='<%# Eval("datum_skut_nast") %>'>
                                            <DateInput EmptyMessage="[%Datum skutečného nástupu%]">
                                            </DateInput>
                                        </kspwc:TRadDatePicker>
                                        <asp:RequiredFieldValidator ID="RFV_e_datum_skut_nast" runat="server" ControlToValidate="TRDP_e_datum_skut_nast"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Datum skutečného nástupu je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow13" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell37" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelzk_doba"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_zk_doba">
                                        <asp:HiddenField runat="server" ID="HF_zk_doba_old" Value='<%# Eval("k_zk_doba_old") %>' />
                                        <asp:Label runat="server" ID="L_zk_doba_old" Text='<%# Eval("zk_doba_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_zk_doba">
                                        <kspwc:TRadDatePicker ID="TRDP_e_zk_doba" runat="server" Width="160px" DbSelectedDate='<%# Eval("zk_doba") %>'>
                                            <DateInput EmptyMessage="[%Zkušební doba%]">
                                            </DateInput>
                                        </kspwc:TRadDatePicker>
                                        <asp:RequiredFieldValidator ID="RFV_e_zk_doba" runat="server" ControlToValidate="TRDP_e_zk_doba"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Zkušební doba je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow18" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell3" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labeldatum_ukonc"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_datum_ukonc">
                                        <asp:HiddenField runat="server" ID="HF_datum_ukonc_old" Value='<%# Eval("k_datum_ukonc_old") %>' />
                                        <asp:Label runat="server" ID="L_datum_ukonc_old" Text='<%# Eval("datum_ukonc_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_datum_ukonc">
                                        <kspwc:TRadDatePicker ID="TRDP_e_datum_ukonc" runat="server" Width="160px" DbSelectedDate='<%# Eval("datum_ukonc") %>'>
                                            <DateInput EmptyMessage="[%Doba neurčitá%]">
                                                <EmptyMessageStyle ForeColor="Black" />
                                                <ClientEvents OnValueChanged="TRDP_datum_ukonc_di_ValueChanged" />
                                            </DateInput>
                                        </kspwc:TRadDatePicker>
                                        <kspwc:TRadButton ID="TRB_e_datum_ukonc_6m" runat="server" Text="6M" AutoPostBack="False" OnClientClicked="TRB_e_datum_ukonc_m_Clicked" Width="40px" CommandArgument="6" CausesValidation="False">
                                        </kspwc:TRadButton>
                                        <kspwc:TRadButton ID="TRB_e_datum_ukonc_12m" runat="server" Text="12M" AutoPostBack="False" OnClientClicked="TRB_e_datum_ukonc_m_Clicked" Width="40px" CommandArgument="12" CausesValidation="False">
                                        </kspwc:TRadButton>
                                        <asp:RequiredFieldValidator ID="RFV_e_datum_ukonc" runat="server" ControlToValidate="TRDP_e_datum_ukonc"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Ukončení prac. poměru je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow9" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell25" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelprac_kateg"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_prac_kateg">
                                        <asp:HiddenField runat="server" ID="HF_prac_kateg_old" Value='<%# Eval("k_prac_kateg_old") %>' />
                                        <asp:Label runat="server" ID="L_prac_kateg_old" Text='<%# Eval("prac_kateg_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_prac_kateg">
                                        <kspwc:TRadComboBox ID="TRCB_e_prac_kateg" runat="server" DataTextField="cely_nazev"
                                            DataValueField="cislo" DropDownAutoWidth="Enabled" EmptyMessage="[%Pracovní kategorie%]"
                                            DataSourceID="ods_prac_kateg" Width="160px" SelectedValue='<%# Eval("prac_kateg") %>'>
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_prac_kateg" runat="server" ControlToValidate="TRCB_e_prac_kateg"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Pracovní kategorie je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow10" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell28" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labeltyp_kal"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_typ_kal">
                                        <asp:HiddenField runat="server" ID="HF_typ_kal_old" Value='<%# Eval("k_typ_kal_old") %>' />
                                        <asp:Label runat="server" ID="L_typ_kal_old" Text='<%# Eval("typ_kal_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_typ_kal">
                                        <kspwc:TRadComboBox ID="TRCB_e_typ_kal" runat="server" DataTextField="cely_nazev" OnClientSelectedIndexChanged="OnTypKalChanged"
                                            DataValueField="cislo" DropDownAutoWidth="Enabled" EmptyMessage="[%Kalendář%]"
                                            DataSourceID="ods_typ_kal" Width="300px" SelectedValue='<%# Eval("typ_kal") %>'>
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_typ_kal" runat="server" ControlToValidate="TRCB_e_typ_kal"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Kalendář je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow22" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelsmena"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_smena">
                                        <asp:HiddenField runat="server" ID="HF_smena_old" Value='<%# Eval("k_smena_old") %>' />
                                        <asp:Label runat="server" ID="L_smena_old" Text='<%# Eval("smena_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_smena">
                                        <kspwc:TRadComboBox ID="TRCB_smena" runat="server" DropDownAutoWidth="Enabled" CloseDropDownOnBlur="true" EmptyMessage="[%Rozvrh%]" AllowCustomText="false"
                                            EnableLoadOnDemand="true" Height="150px" OnClientItemsRequesting="smena_ItemsRequesting" OnClientDropDownClosed="comboDropDownClosed"
                                            ShowMoreResultsBox="false" Text='<%# Eval("smena") %>'>
                                            <WebServiceSettings Method="GetSmena" Path="../WebServices/AutoCompleteService.asmx" />
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_smena" runat="server" ControlToValidate="TRCB_smena"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Rozvrh je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow33" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell23" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelzak_uvazek"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_zak_uvazek">
                                        <asp:HiddenField runat="server" ID="HF_zak_uvazek_old" Value='<%# Eval("k_zak_uvazek_old") %>' />
                                        <asp:Label runat="server" ID="L_zak_uvazek_old" Text='<%# Eval("zak_uvazek_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_zak_uvazek">
                                        <telerik:RadNumericTextBox ID="RNTB_e_zak_uvazek" runat="server" DataType="System.Decimal"
                                            MaxValue="60" MinValue="0" EmptyMessage="[%Zákonný denní úvazek%]" DbValue='<%# Eval("zak_uvazek") %>' AutoPostBack="False">
                                        </telerik:RadNumericTextBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_zak_uvazek" runat="server" ControlToValidate="RNTB_e_zak_uvazek"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Zákonný denní úvazek je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow11" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell31" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelhod_uvazek"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_hod_uvazek">
                                        <asp:HiddenField runat="server" ID="HF_hod_uvazek_old" Value='<%# Eval("k_zak_uvazek_old") %>' />
                                        <asp:Label runat="server" ID="L_hod_uvazek_old" Text='<%# Eval("hod_uvazek_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_hod_uvazek">
                                        <telerik:RadNumericTextBox ID="RNTB_e_hod_uvazek" runat="server" DataType="System.Decimal" OnTextChanged="RNTB_e_hod_uvazek_TextChanged"
                                            MaxValue="60" MinValue="0" EmptyMessage="[%Skutečný denní úvazek%]" DbValue='<%# Eval("hod_uvazek") %>' AutoPostBack="True">
                                            <ClientEvents OnValueChanged="RNTB_e_hod_uvazek_OnValueChanged" />
                                        </telerik:RadNumericTextBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_hod_uvazek" runat="server" ControlToValidate="RNTB_e_hod_uvazek"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Skutečný denní úvazek je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow32" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell21" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelsmluv_pom_uv"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_smluv_pom_uv">
                                        <asp:HiddenField runat="server" ID="HF_smluv_pom_uv_old" Value='<%# Eval("k_smluv_pom_uv_old") %>' />
                                        <asp:Label runat="server" ID="L_smluv_pom_uv_old" Text='<%# Eval("smluv_pom_uv_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_smluv_pom_uv">
                                        <telerik:RadNumericTextBox ID="RNTB_e_smluv_pom_uv" runat="server" DataType="System.Decimal"
                                            MaxValue="1" MinValue="0" EmptyMessage="[%Smluvní podíl úvazku%]" DbValue='<%# Eval("smluv_pom_uv") %>' AutoPostBack="False">
                                            <ClientEvents OnValueChanged="RNTB_e_smluv_pom_uv_OnValueChanged" />
                                            <NumberFormat DecimalDigits="4" DecimalSeparator="," GroupSeparator="" />
                                        </telerik:RadNumericTextBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_smluv_pom_uv" runat="server" ControlToValidate="RNTB_e_smluv_pom_uv"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Smluvní podíl úvazku je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow14" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell40" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labeljkz"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_jkz">
                                        <asp:HiddenField runat="server" ID="HF_jkz_old" Value='<%# Eval("k_jkz_old") %>' />
                                        <asp:Label runat="server" ID="L_jkz_old" Text='<%# Eval("jkz_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_jkz">
                                        <kspwc:TRadComboBox ID="TRCB_e_jkz" runat="server" DropDownAutoWidth="Enabled" EmptyMessage="[%CZ-ISCO%]"
                                            Height="150" Width="300px" EnableAutomaticLoadOnDemand="true" OnClientDropDownOpening="dropDownOpening" OnClientItemsRequesting="dropDownItemsRequesting" OnClientKeyPressing="dropDownTextChange"
                                            EnableVirtualScrolling="true" ShowMoreResultsBox="true" ItemsPerRequest="20" Filter="Contains">
                                            <WebServiceSettings Method="GetKZAM" Path="../WebServices/AutoCompleteService.asmx" />
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_jkz" runat="server" ControlToValidate="TRCB_e_jkz"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%CZ-ISCO je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow15" runat="server">
                                    <asp:TableCell runat="server" ID="TableCell43" HorizontalAlign="Right">
                                        <asp:Label runat="server" ID="labelduvod_nastupu"></asp:Label>
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_duvod_nastupu">
                                        <asp:HiddenField runat="server" ID="HF_duvod_nastupu_old" Value='<%# Eval("k_duvod_nastupu_old") %>' />
                                        <asp:Label runat="server" ID="L_duvod_nastupu_old" Text='<%# Eval("duvod_nastupu_old") %>' />
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_duvod_nastupu">
                                        <kspwc:TRadComboBox ID="TRCB_e_duvod_nastupu" runat="server" DataTextField="nazev"
                                            DataValueField="cis_kodu" DropDownAutoWidth="Enabled" EmptyMessage="[%Důvod nástupu%]"
                                            DataSourceID="ods_duvod_nast" Width="300px" SelectedValue='<%# Eval("duvod_nastupu") %>'>
                                        </kspwc:TRadComboBox>
                                        <asp:RequiredFieldValidator ID="RFV_e_duvod_nastupu" runat="server" ControlToValidate="TRCB_e_duvod_nastupu"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="[%Důvod nástupu je povinný údaj%]" Enabled="false" CssClass="InnerTableFormFieldset tdValidators"></asp:RequiredFieldValidator>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow ID="TableRow16" runat="server" Visible="false">
                                    <asp:TableCell runat="server" ID="TableCell46" HorizontalAlign="Right">
                                        [%Popis práce%]
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_curr_popis_prace">
                            
                                    </asp:TableCell>
                                    <asp:TableCell runat="server" ID="TCE_new_popis_prace">
                            
                                    </asp:TableCell>
                                </asp:TableRow>
                            </asp:Table>
                        </fieldset>
                    </telerik:LayoutColumn>
                    <telerik:LayoutColumn Span="6" SpanXl="6" SpanLg="12" SpanMd="12" SpanSm="12" SpanXs="12">
                        <fieldset id="FS_priplatky" runat="server" class="ksprvek ksfieldset">
                            <legend class="ksclass">[%Příplatky%]</legend>
                            <kspwc:TRadGrid runat="server" ID="TRG_priplatky" AutoGenerateColumns="false" CaptionVisible="false" CssClass="ksRgpriplatky" AutoMasterGridWidth="true"
                                OnNeedDataSource="TRG_priplatky_NeedDataSource" 
                                OnBatchEditCommand="TRG_priplatky_BatchEditCommand"
                                OnDataBound="TRG_priplatky_DataBound"
                                OnItemDataBound="TRG_priplatky_ItemDataBound" >
                                <ClientSettings>
                                    <ClientEvents OnBatchEditOpened="TRG_priplatky_BatchEditOpened" OnBatchEditCellValueChanging="TRG_priplatky_CellValueChanging" OnRowDeleting="TRG_priplatky_CellValueChanging" />
                                </ClientSettings>
                                <MasterTableView DataKeyNames="kod" EditMode="Batch" CommandItemDisplay="Top" AllowAutomaticInserts="false" AllowAutomaticDeletes="false" AllowAutomaticUpdates="false">
                                    <BatchEditingSettings EditType="Row" HighlightDeletedRows="true" />
                                    <CommandItemTemplate>
                                        <kspwc:GridCommandItemControl ID="GCIC_priplatky" runat="server">
                                            <AddNewItemButton runat="server" CausesValidation="false" AutoPostBack="false" OnClientClicked="GCIC_pripl_add" Visible="true"></AddNewItemButton>
                                            <FilterButton runat="server" Visible="false"></FilterButton>
                                            <ExportButton runat="server" Visible="false"></ExportButton>
                                            <SaveButton runat="server" Visible="true" CausesValidation="false" CssClass="hidden rgBatchChanged"></SaveButton>
                                            <RebindButton runat="server" CausesValidation="false"></RebindButton>
                                        </kspwc:GridCommandItemControl>
                                    </CommandItemTemplate>
                                    <Columns>
                                        <telerik:GridDropDownColumn DataField="kod" DataType="System.Int16" UniqueName="kod" HeaderText="[%Příplatek%]"
                                            DataSourceID="ODS_kody_priplatky" ListValueField="kod" ListTextField="nazev">
                                        </telerik:GridDropDownColumn>
                                        <telerik:GridNumericColumn DataField="castka_old" DataType="System.Decimal" UniqueName="castka_old" HeaderText="[%Původní%]" DataFormatString="{0:### ### ##0.00}" ReadOnly="true"></telerik:GridNumericColumn>
                                        <telerik:GridNumericColumn DataField="castka" DataType="System.Decimal" UniqueName="castka" HeaderText="[%Částka%]" DataFormatString="{0:### ### ##0.00}"></telerik:GridNumericColumn>
                                        <telerik:GridDateTimeColumn DataField="plati_od" DataType="System.DateTime" UniqueName="plati_od" HeaderText="[%Platí od%]" DataFormatString="{0:d. M. yyyy}"></telerik:GridDateTimeColumn>
                                        <telerik:GridDateTimeColumn DataField="plati_do" DataType="System.DateTime" UniqueName="plati_do" HeaderText="[%Platí do%]" DataFormatString="{0:d. M. yyyy}"></telerik:GridDateTimeColumn>
                                        <telerik:GridClientDeleteColumn ButtonType="ImageButton" HeaderStyle-Width="35"></telerik:GridClientDeleteColumn>
                                    </Columns>
                                </MasterTableView>
                            </kspwc:TRadGrid>
                        </fieldset>
                    </telerik:LayoutColumn>
                </Columns>
            </telerik:LayoutRow>
        </Rows>
    </telerik:RadPageLayout>
</asp:Panel>

