﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="BulletinControl.ascx.cs" Inherits="KSPortal.Bulletin.BulletinControl" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<%@ Register Src="~/Dokumenty/PdfViewer.ascx" TagName="PdfViewer" TagPrefix="pdf" %>

<style type="text/css">
    .ksBullEditorWindow {
        min-width: 800px;
        position: absolute;
        height: fit-content;
        /*min-height: 600px;*/
        /*max-height: 90%;*/
        left: 50% !important;
        top: 50% !important;
        transform: translate(-50%,-50%) !important;
    }

        .ksBullEditorWindow td.rwBodyLeft, .ksBullEditorWindow td.rwBodyRight,
        .ksBullEditorWindow td.rwFooterLeft, .ksBullEditorWindow td.rwFooterCenter, .ksBullEditorWindow td.rwFooterRight {
            background-color: lightgray !important;
        }

    div.ksBullContainer {
        /*max-width: 800px;*/
        /*min-width: 680px;*/
        height: 800px;
        width: 100%;
    }

    div.ksBullEditorContainer {
        height: 100%;
    }

    div.ksBullEditorContainerE {
        height: calc(100% - <%= TRB_Zkontrolovano.Visible ? "74" : "0" %>px);
    }

        div.ksBullEditorContainerE > div.RadAjaxPanel {
            height: <%= RE_editor.Visible ? "100%" : "unset" %>;
        }

    div.ksBullEditorCommand {
        width: 100%;
    }

    form .rwContent, .ksBullEditorWindow {
    }

    div.ksPdfInner {
        height: 100%;
        width: 100%;
    }

    div.ksEditorInner {
        height: 100% !important;
        width: 100% !important;
        overflow: <%= RE_editor.Enabled ? "hidden" : "auto" %>;
    }

    .button {
        background-color: var(--kscolor1) !important;
        border: none !important;
        color: var(--kscolor1text) !important;
        padding: 15px 32px !important;
        text-align: center !important;
        text-decoration: none !important;
        font-size: 16px !important;
        margin: 4px 2px !important;
        cursor: pointer !important;
        /*visibility: hidden;*/
    }

    span.reksSave {
        background-image: url('./../<% = ((TPrePage)this.Page).GetIkonaSvgUrl("disk") %>');
        background-repeat: no-repeat;
        background-size: 32px 32px;
    }

        span.reksSave:before {
            content: '';
        }

    span.reOpen {
        background-image: url('./../<% = ((TPrePage)this.Page).GetIkonaSvgUrl("file") %>');
        background-repeat: no-repeat;
        background-size: 32px 32px;
    }

        span.reOpen:before {
            content: '';
        }

    span.reSaveAs {
        background-image: url('./../<% = ((TPrePage)this.Page).GetIkonaSvgUrl("file") %>');
        background-repeat: no-repeat;
        background-size: 32px 32px;
    }

        span.reSaveAs:before {
            content: '';
        }

    span.reSaveAsDocx {
        background-image: url('./../<% = ((TPrePage)this.Page).GetIkonaSvgUrl("file") %>');
        background-repeat: no-repeat;
        background-size: 16px 16px;
    }

        span.reSaveAsDocx:before {
            content: '';
        }

    span.reSaveAsRtf {
        background-image: url('./../<% = ((TPrePage)this.Page).GetIkonaSvgUrl("file") %>');
        background-repeat: no-repeat;
        background-size: 16px 16px;
    }

        span.reSaveAsRtf:before {
            content: '';
        }

    span.reSaveAsPDF {
        background-image: url('./../<% = ((TPrePage)this.Page).GetIkonaSvgUrl("file") %>');
        background-repeat: no-repeat;
        background-size: 16px 16px;
    }

        span.reSaveAsPDF:before {
            content: '';
        }
</style>

<telerik:RadAjaxManagerProxy runat="server" ID="RAMP_bulllist">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="RE_editor">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="RE_editor" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>

<telerik:RadScriptBlock runat="server" ID="RSB_fix">
    <script type="text/javascript">
        function OnShowWindow(sender, args) {
            fixEditor(sender, args);
            ksShowEditor();
            if (pdfParentWindowShow)
                pdfParentWindowShow(sender, args);
        }

        function fixEditor(sender, args) {
            $telerik.$(".RadEditor", sender.get_contentElement()).each(function (index, elem) {
                if (elem.control && elem.control.onParentNodeChanged) elem.control.onParentNodeChanged();
            });
        }

        var oldPageLoad1 = !oldPageLoad1 ? KSMaster.onPageLoad : oldPageLoad1;
        KSMaster.onPageLoad = function () {
            oldPageLoad1.apply();
            if (Telerik.Web.UI.Editor) {
                Telerik.Web.UI.Editor.CommandList["SaveAsDocx"] =
                    Telerik.Web.UI.Editor.CommandList["SaveAsRtf"] =
                    Telerik.Web.UI.Editor.CommandList["SaveAsHtml"] =
                    Telerik.Web.UI.Editor.CommandList["SaveAsPDF"] =
                    Telerik.Web.UI.Editor.CommandList["ksSave"] = function (commandName, editor, args) {
                        __doPostBack("", commandName);
                    };

                Telerik.Web.UI.Editor.CommandList["Open"] = function (commandName, editor, args) {
                    BullEditor.openUploadDialog();
                }
            }

            BullEditor.rwUploadId = "<%=RW_upload.ClientID%>";
            BullEditor.rnMessagesId = "<%=RadNotification1.ClientID%>";
            BullEditor.reId = "<%=RE_editor.ClientID%>";
        };
        KSMaster.onPageLoad.prototype = oldPageLoad1.prototype;

        function RW_editor_Close(sender, args) {
            var poz = $get('<%=HF_opened.ClientID%>');
            poz.value = "false";
        }

        function RW_editor_BeforeShow(sender, args) {
            var poz = $get('<%=P_hidden_holder.ClientID%>').getBoundingClientRect();
            //sender.moveTo(poz.left, poz.top);
        }

        function ksShowEditor() {
            id = document.getElementById("<%=HF_id.ClientID%>").value;
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/DashBoard/WebMethods.aspx/GetBulletinHtml",
                data: "{id: " + id + "}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                },
                error: function (response) {
                    alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                },
                success: function (msg) {
                    var window = $find("<%=RW_editor.ClientID%>");
                    var editor = $find("<%=RE_editor.ClientID%>");
                    var pdfViewer = $get("<%=PV_viewer.ViewerClientID%>");
                    id_bull = id;

                    setButtonText(id);

                    if (msg.d.substring(0, 3) == "PDF") {
                        if (editor) {
                            editor.set_visible(false);
                            editor.set_html('');
                        }
                        if (pdfViewer)
                            pdfViewer.style.display = "block";
                        return;
                    }

                    if (msg.d && msg.d.substring(0, 3) != "PDF") {
                        if (editor) {
                            editor.set_visible(true);
                            editor.repaint();
                        }

                        if (KSMaster && KSMaster.PdfViewer
                            && KSMaster.PdfViewer.isRendered
                            && KSMaster.PdfViewer.element
                            && KSMaster.PdfViewer.element.innerHTML != '')
                            KSMaster.PdfViewer.destroy();

                        if (pdfViewer)
                            pdfViewer.style.display = "none";
                    }
                }
            });
        }

        function setButtonText(id) {
            var button = $find("<%=TRB_Zkontrolovano.ClientID %>");
            $.ajax({
                type: "POST",
                url: "./../DashBoard/WebMethods.aspx/GetTextTlacitko",
                data: "{id: " + id + "}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    if (button)
                        button.set_visible(false);
                },
                error: function (response) {
                    if (button)
                        button.set_visible(false);
                },
                success: function (msg) {
                    if (button) {
                        button.set_visible(true);
                        button.set_text(msg.d);
                    }
                }
            });
        }

        function PdfControled(id) {
            $.ajax({
                type: "POST",
                url: "./../DashBoard/WebMethods.aspx/CallPdfUpdate",
                data: "{id: " + id + "}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                },
                error: function (response) {
                    alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                },
                success: function (msg) {
                    var window = $find("<%=RW_editor.ClientID%>");
                    if (window)
                        window.close();

                    showLoadingAnimation();
                    location.reload();

                }
            });

        }
    </script>


</telerik:RadScriptBlock>

<asp:Panel runat="server" ID="P_hidden_holder" CssClass="hodden">
</asp:Panel>
<asp:HiddenField runat="server" ID="HF_opened" />
<asp:HiddenField runat="server" ID="HF_id" />

<telerik:RadWindow runat="server" ID="RW_editor" KeepInScreenBounds="true" CssClass="ksBullEditorWindow"
    Behaviors="Close,Maximize,Move,Resize" OnClientClose="RW_editor_Close" OnClientBeforeShow="RW_editor_BeforeShow"
    ShowContentDuringLoad="false" Width="900" Modal="true" OnClientShow="OnShowWindow"
    Height="900" VisibleOnPageLoad="false" OpenerElementID="LB_nadpis">
    <ContentTemplate>
        <div class="ksBullEditorContainer">
            <div class="ksBullEditorContainerE">
                <pdf:PdfViewer runat="server" ID="PV_viewer" CssClass="ksPdfInner" AutoApppend="False">
                </pdf:PdfViewer>
                <telerik:RadEditor runat="server" ID="RE_editor" CssClass="ksEditorInner" NewLineMode="P" EditModes="All" ToolbarMode="RibbonBar"
                    EnableTrackChanges="false" EnableComments="false" DocumentManager-UploadPaths="~/Temp"
                    ContentFilters="DefaultFilters,PdfExportFilter,EncodeScripts,StripCssExpressions,StripDomEventAttributes"
                    OnClientLoad="BullEditor.toggleTrackChanges">
                    <ExportSettings OpenInNewWindow="true" FileName="RadEditor-Export"></ExportSettings>
                </telerik:RadEditor>
            </div>
            <kspwc:TRadButton runat="server" ID="TRB_Zkontrolovano" CssClass="button" OnClick="TRB_Zkontrolovano_Click" Text="" Width="100%" Visible="false"></kspwc:TRadButton>
        </div>
    </ContentTemplate>
</telerik:RadWindow>
<telerik:RadWindow ID="RW_upload" runat="server" Title="[%Otevřít soubor%]" Behaviors="Close, Move" VisibleStatusbar="false" Width="400" Height="110">
    <ContentTemplate>
        <div style="width: fit-content; margin: auto">
            [%Povolené soubory%]: doc ,docx, rtf, txt, htm, html, md<br />
            <telerik:RadAsyncUpload runat="server" ID="RAU_file" AllowedFileExtensions="doc,docx,rtf,txt,htm,html,md" MaxFileInputsCount="1"
                OnClientValidationFailed="BullEditor.OnClientValidationFailed" OnClientFileUploaded="BullEditor.uploadFile" TemporaryFolder="~/Temp"
                OnFileUploaded="RAU_file_FileUploaded" Width="100%">
            </telerik:RadAsyncUpload>
        </div>
    </ContentTemplate>
</telerik:RadWindow>
<telerik:RadNotification ID="RadNotification1" runat="server" Width="350px" Height="150px" Title="[%Došlo k chybě%]" TitleIcon="warning"
    ContentIcon="info" Position="Center" AutoCloseDelay="5000" EnableRoundedCorners="true" EnableShadow="true">
</telerik:RadNotification>
