﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="MzdovePolozky.aspx.cs" Inherits="KSPortal.Sestavy.MzdovePolozky" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy ID="RAMP_mzdove_polozky" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRG_mzdove_pozky">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_mzdove_pozky" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <telerik:RadCodeBlock ID="RadCodeBlock3" runat="server">
        <script type="text/javascript" id="telerikClientEvents1">
            //function TRCB_polozky_ItemDataBound(sender, args) {
            //    var item = args.get_item();
            //    var data = args.get_dataItem();

            //    item.set_checked(data.Attributes.Checked);
            //}

            function TRCB_polozky_CheckedChanged(sender, args) {
                var items = sender.get_items();
                var ret = [];
                items.forEach(function (element) {
                    if (element.get_checked()) {
                        ret.push(parseInt(element.get_value()));
                    }
                });
                $.ajax({
                    type: "POST",
                    url: KSMaster.baseUrl + "/Sestavy/MzdovePolozky.aspx/SaveVybranePolozky",
                    data: "{json: '" + JSON.stringify(ret) + "'}",
                    async: true,
                    contentType: "application/json",
                    dataType: "json",
                    failure: function (response) {
                        KSMaster.showError(response.responseText, response.statusText);
                    },
                    error: function (response) {
                        KSMaster.showError(response.responseText, response.statusText);
                    },
                    success: function (data) {
                    }
                });
            }
            function TRCB_pojmy_CheckedChanged(sender, args) {
                var items = sender.get_items();
                var ret = [];
                items.forEach(function (element) {
                    if (element.get_checked()) {
                        ret.push(element.get_value());
                    }
                });
                $.ajax({
                    type: "POST",
                    url: KSMaster.baseUrl + "/Sestavy/MzdovePolozky.aspx/SaveVybranePojmy",
                    data: "{json: '" + JSON.stringify(ret) + "'}",
                    async: true,
                    contentType: "application/json",
                    dataType: "json",
                    failure: function (response) {
                        KSMaster.showError(response.responseText, response.statusText);
                    },
                    error: function (response) {
                        KSMaster.showError(response.responseText, response.statusText);
                    },
                    success: function (data) {
                    }
                });
            }

            function RCB_setting_IndexChanging(sender, args) {

            }

            function RCB_setting_TextChange(sender, args) {
                if (findParentClassElement(args.get_domEvent().target, "ksBtnSave")) {
                    args.set_cancel(true);
                }
            }

            function findParentClassElement(element, trida) {
                if (element) {
                    if (element.classList.contains(trida)) {
                        return true;
                    }
                    else {
                        return findParentClassElement(element.parentElement, trida);
                    }
                }
                else {
                    return false;
                }
            }

            function OnHeaderMenuShowing(sender, args) {
                if (!<%= KSProgram.Prava.PravaAkce.PristupPovolen(375) ? "true" : "false" %>) {
                    var menu = args.get_menu();
                    var columnsMenu = menu.findItemByValue('ColumnsContainer');
                    if (columnsMenu) {
                        columnsMenu.set_visible(false);
                    }
                }
            }

        </script>
    </telerik:RadCodeBlock>
    <telerik:RadPersistenceManagerProxy ID="RPMP_mzdove_polozky" runat="server">
        <PersistenceSettings>
            
        </PersistenceSettings>
    </telerik:RadPersistenceManagerProxy>
    <asp:ObjectDataSource ID="ODS_polozky" runat="server" OldValuesParameterFormatString="original_{0}" SelectMethod="GetCiselnik" TypeName="KSProgram.Ciselniky.CisMzdPol">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ODS_pojmy" runat="server" OldValuesParameterFormatString="original_{0}" SelectMethod="GetPojmyCiselGroup" TypeName="KSProgram.Sestavy.Pojmy">
        <SelectParameters>
            <asp:Parameter Name="kody" Type="Object" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <%--<label class="nadpis1">[%Statistika mzdových položek%]</label>--%>
    <kspwc:TRadGrid runat="server" ID="TRG_mzdove_pozky" OnNeedDataSource="TRG_mzdove_pozky_NeedDataSource" EnableHeaderContextMenu="true" AutoFilterWidth="false" AutoFilterControlWidth="true"
        GroupingEnabled="true" ShowGroupPanel="true" AutoGenerateColumns="false" MasterTableView-Caption="[%Statistika mzdových položek%]"
        OnPreRender="TRG_mzdove_pozky_PreRender" OnGroupsChanging="TRG_mzdove_pozky_GroupsChanging" 
        OnExcelExportCellFormatting="TRG_mzdove_pozky_ExcelExportCellFormatting" 
        OnInfrastructureExporting="TRG_mzdove_pozky_InfrastructureExporting" 
        OnBiffExporting="TRG_mzdove_pozky_BiffExporting">
        <ClientSettings AllowDragToGroup="true">
            <ClientEvents OnHeaderMenuShowing="OnHeaderMenuShowing" />
        </ClientSettings>
        <GroupingSettings ShowUnGroupButton="true" IgnorePagingForGroupAggregates="true"  />
        <MasterTableView AllowPaging="true" AllowSorting="true" PageSize="100" CommandItemDisplay="Top" ShowFooter="true" ShowGroupFooter="true"
            EnableHeaderContextMenu="true" EnableHeaderContextAggregatesMenu="true" EnableHeaderContextFilterMenu="true"
            EnableGroupsExpandAll="true">
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl runat="server" ID="GCIC_polozky" DateControl="TRadObdobiInterval" RebindOnFiltersChanged="false">
                    <ExportButton runat="server"
                        ShowExportToExcelBIFFItem="true"
                        ShowExportToExcelMLItem="true">
                    </ExportButton>
                    <FilterButton runat="server" OnCheckedChanged="GCIC_RB_CheckedChanged"></FilterButton>
                    <ContentTemplate>
                        <div class="gridCommandButton">
                            <kspwc:TRadButton runat="server" ID="TRB_pojmy" ButtonType="StandardButton" AutoPostBack="false" ToggleType="CustomToggle"
                                OnPreRender="TRB_pojmy_PreRender" OnToggleStateChanged="TRB_pojmy_ToggleStateChanged" OnInit="TRB_pojmy_Init"
                                ToolTip="[%Nastavte, zda chcete zobrazit Mzdové položky nebo Pojmy%]"
                                Visible='<%# KSProgram.Prava.PravaAkce.PristupPovolen(375) %>'>
                                <ToggleStates>
                                    <telerik:RadButtonToggleState Text="[%Mzdové položky%]" Value="m" />
                                    <telerik:RadButtonToggleState Text="[%Pojmy%]" Value="p" />
                                    <telerik:RadButtonToggleState Text="[%Položky i pojmy%]" Value="a" />
                                </ToggleStates>
                            </kspwc:TRadButton>
                            <kspwc:TRadComboBox runat="server" ID="TRCB_polozky" DataValueField="kod" DataTextField="cely_nazev" DataSourceID="ODS_polozky" ToolTip="[%Filtr mzdových položek%]"
                                EnableCheckAllItemsCheckBox="true" CheckBoxes="true" DropDownAutoWidth="Enabled" MaxHeight="260px" EmptyMessage="[%Filtr mzdových položek%]"
                                OnItemDataBound="TRCB_polozky_ItemDataBound" OnClientItemChecked="TRCB_polozky_CheckedChanged"
                                OnClientCheckAllChecked="TRCB_polozky_CheckedChanged"
                                Visible='<%# KSProgram.Prava.PravaAkce.PristupPovolen(375) %>'>
                                <Localization AllItemsCheckedString="[%Všechny položky%]"/>
                            </kspwc:TRadComboBox>
                            <kspwc:TRadComboBox runat="server" ID="TRCB_pojmy" DataSourceID="ODS_pojmy" ToolTip="[%Filtr pojmů%]. [%Pojem sdružuje skupinu mzdových položek%]." 
                                EnableCheckAllItemsCheckBox="true" CheckBoxes="true" DropDownAutoWidth="Enabled" MaxHeight="260px" EmptyMessage="[%Filtr pojmů%]"
                                OnItemDataBound="TRCB_pojmy_ItemDataBound" OnClientItemChecked="TRCB_pojmy_CheckedChanged" OnClientCheckAllChecked="TRCB_pojmy_CheckedChanged"
                                Visible='<%# KSProgram.Prava.PravaAkce.PristupPovolen(375) %>'>
                                <Localization AllItemsCheckedString="[%Všechny pojmy%]" ItemsCheckedString="[%pojmů vybráno%]"/>
                            </kspwc:TRadComboBox>
                            <kspwc:TRadButton runat="server" ID="TRB_agregace" ButtonType="StandardButton" AutoPostBack="false" ToggleType="CustomToggle"
                                OnPreRender="TRB_agregace_PreRender" OnToggleStateChanged="TRB_agregace_ToggleStateChanged" OnInit="TRB_agregace_Init"
                                Visible='<%# KSProgram.Prava.PravaAkce.PristupPovolen(375) %>' ToolTip="[%Nastavte, zda se mají hodnoty sumovat.%]">
                                <ToggleStates>
                                    <telerik:RadButtonToggleState Text="[%Bez agregace%]" Value="0" />
                                    <telerik:RadButtonToggleState Text="[%Za kód%]" Value="1" />
                                    <telerik:RadButtonToggleState Text="[%Za kód a všechna období%]" Value="2" />
                                </ToggleStates>
                            </kspwc:TRadButton>
                            <kspwc:TRadButton runat="server" ID="TRB_insertEmpties" ButtonType="StandardButton" AutoPostBack="false" ToggleType="CustomToggle"
                                OnPreRender="TRB_insertEmpties_PreRender" OnToggleStateChanged="TRB_insertEmpties_ToggleStateChanged" OnInit="TRB_insertEmpties_Init"
                                ToolTip="[%Nastavte, zda se u vybraných položek mají zobrazit záznamy s nulovou částkou v případě, kdy v daném měsíci nejsou vygenerovány%]">
                                <ToggleStates>
                                    <telerik:RadButtonToggleState Text="[%Pouze existující%]" Value="n" />
                                    <telerik:RadButtonToggleState Text="[%Vložit vybrané%]" Value="a" />
                                </ToggleStates>
                            </kspwc:TRadButton>
                            <kspwc:TRadComboBox ID="RCB_setting" runat="server" DropDownAutoWidth="Enabled" EnableLoadOnDemand="true" EnableTextSelection="false" AutoPostBack="true" Label="[%Varianta%]:"
                                EmptyMessage="[%Uložená nastavení%]" OnClientSelectedIndexChanging="RCB_setting_IndexChanging" OnClientTextChange="RCB_setting_TextChange"
                                OnSelectedIndexChanged="RCB_setting_SelectedIndexChanged" OnPreRender="RCB_setting_PreRender"
                                Visible='<%# _varianty.Count() > 0 || KSProgram.Prava.PravaAkce.PristupPovolen(374) %>' >
                                <WebServiceSettings Method="GetVarianty" Path="~/Sestavy/MzdovePolozky.aspx"></WebServiceSettings>
                            </kspwc:TRadComboBox>
                            <kspwc:TRadButton runat="server" ID="TRB_save_setting" CssClass="ksBtnSave" OnClick="TRB_save_setting_Click" ToolTip="[%Uložit nastavení jako variantu%]" IdPrava="374" Visible='<%# KSProgram.Prava.PravaAkce.PristupPovolen(374) %>' 
                                ConfirmTitle="[%Uložení nastavení sestavy%]" ConfirmText="[%Nastavení sestavy bude uloženo pod aktuálně vybranou variantu%]" >
                                <Icon PrimaryIconCssClass="fi fi-disk" />
                            </kspwc:TRadButton>
                            <kspwc:TRadButton runat="server" ID="TRB_delete_setting" OnClick="TRB_delete_setting_Click" ToolTip="[%Vymazat variantu%]" IdPrava="374" Visible='<%# KSProgram.Prava.PravaAkce.PristupPovolen(374) %>' 
                                ConfirmTitle="[%Smazání Varianty sestavy%]" ConfirmText="[%Aktuálně vybraná varianta sestavy bude smazána%]">
                                <Icon PrimaryIconCssClass="fi fi-trash" />
                            </kspwc:TRadButton>
                        </div>
                    </ContentTemplate>
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
            <PagerStyle PageSizes="50,100,200,500,1000" />
            <GroupByExpressions>
                <telerik:GridGroupByExpression>
                    <GroupByFields>
                        <telerik:GridGroupByField FieldName="os_cislo" HeaderText="[%Osobní číslo%]"/>
                    </GroupByFields>
                    <SelectFields>
                        <telerik:GridGroupByField FieldName="os_cislo" HeaderText="[%Osobní číslo%]"/>
                    </SelectFields>
                </telerik:GridGroupByExpression>
                <telerik:GridGroupByExpression>
                    <GroupByFields>
                        <telerik:GridGroupByField FieldName="druh_pom_t" HeaderText="[%Druh pom.%]"/>
                    </GroupByFields>
                    <SelectFields>
                        <telerik:GridGroupByField FieldName="druh_pom_t" HeaderText="[%Druh pom.%]"/>
                    </SelectFields>
                </telerik:GridGroupByExpression>
            </GroupByExpressions>
            <Columns>
                <telerik:GridNumericColumn DataField="os_cislo" UniqueName="os_cislo" DataType="System.Decimal" HeaderText="[%Osobní číslo%]"></telerik:GridNumericColumn>
                <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo"></kspwc:GridFotoZamColumn>
                <telerik:GridBoundColumn DataField="jmeno" UniqueName="jmeno" DataType="System.String" HeaderText="[%Jméno%]"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="prijmeni" UniqueName="prijmeni" DataType="System.String" HeaderText="[%Příjmení%]"></telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="cislo_pom" UniqueName="cilso_pom" DataType="System.Int16" HeaderText="[%Číslo pom.%]"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="druh_pom_t" UniqueName="druh_pom_t" DataType="System.String" HeaderText="[%Druh pom.%]"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cis_pracmist" UniqueName="cis_pracmist" DataType="System.String" HeaderText="[%Číslo místa%]"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="naz_pracmist" UniqueName="naz_pracmist" DataType="System.String" HeaderText="[%Pracovní místo%]"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="prac_str" UniqueName="prac_str" DataType="System.String" HeaderText="[%Číslo stř.%]"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="prac_str_t" UniqueName="prac_str_t" DataType="System.String" HeaderText="[%Pracovní středisko%]"></telerik:GridBoundColumn>
                <telerik:GridDateTimeColumn DataField="datum" UniqueName="datum" DataType="System.DateTime" HeaderText="[%Období%]" DataFormatString="{0:MMMM yyyy}"></telerik:GridDateTimeColumn>
                <telerik:GridBoundColumn DataField="typ_zaznamu" UniqueName="typ_zaznamu" DataType="System.String" HeaderText="[%Typ%]" SortExpression="isPojem"></telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="kod" UniqueName="kod" DataType="System.Int16" HeaderText="[%Kód%]"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="vyznam" UniqueName="vyznam" DataType="System.String" HeaderText="[%Význam%]"></telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="dny" UniqueName="dny" DataType="System.Decimal" HeaderText="[%Dny%]" DataFormatString="{0:0.0}"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="hodiny" UniqueName="hodiny" DataType="System.Decimal" HeaderText="[%Hodiny%]" DataFormatString="{0:0.00}"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="sazba" UniqueName="sazba" DataType="System.Decimal" HeaderText="[%Sazba%]" DataFormatString="{0:#,##0.00}"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="castka" UniqueName="castka" DataType="System.Decimal" HeaderText="[%Částka%]"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="hruba" UniqueName="hruba" DataType="System.Decimal" HeaderText="[%V hrubé%]" Aggregate="Sum" HeaderTooltip="[%Touto částkou je položka nebo pojem zastoupen v hrubé mzdě%]"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="cista" UniqueName="cista" DataType="System.Decimal" HeaderText="[%V čisté%]" Aggregate="Sum" HeaderTooltip="[%Touto částkou je položka nebo pojem zastoupen v čisté mzdě%]"></telerik:GridNumericColumn>
            </Columns>
        </MasterTableView>
    </kspwc:TRadGrid>
</asp:Content>

