﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="AnketaControl.ascx.cs"
    Inherits="KSPortal.Controls.AnketaControl" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<style type="text/css">
    .bodySurveys {
        border: 1px solid lightgray;
    }

    .nadpis {
        padding-left: 0.5em;
    }

    .otazkaNadpis {
        width: 70%;
    }

    .odpoved {
        width: 100%;
    }

    .diver {
        color: lightgray;
    }

    .odpovedTB {
        width: 100%;
        border: 1px solid lightgray;
    }

    .buttonText {
        border: none;
        background: transparent;
    }

        .buttonText:hover {
            color: cornflowerblue;
        }

    .buttonTextAdd {
        border: none;
        background: transparent;
    }

        .buttonTextAdd:hover {
            color: black;
            background: lightgray;
            border: 1px solid lightgray;
        }

    .ksBullEditorWindow {
    }

        .ksBullEditorWindow td.rwBodyLeft, .ksBullEditorWindow td.rwBodyRight,
        .ksBullEditorWindow td.rwFooterLeft, .ksBullEditorWindow td.rwFooterCenter, .ksBullEditorWindow td.rwFooterRight {
            background-color: lightgray !important;
        }

    .otazkaEdit {
        margin: 15px;
        border-radius: 5px;
        padding: 10px;
        border: 2px var(--kscolor1) solid;
        background: white;
    }
</style>
<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
    <script>
        String.prototype.cleanForJson = function () {
            return this.replace(/"/g, "'");
        };

        function RMS_adresats_OnChange(sender, args) {
            var HF = $get("<%=HF_adresati.ClientID %>");
            HF.value = sender.get_value()?.join(',');

        }
        var counter = 2;
        var counterOtazek = 1;

        function novaOdpoved(sender) {
            //var id =sender._uniqueID;
            //console.log(sender._element);
            //id=id.replaceAll("$","_");
            //console.log(sender);
            var butt = sender;
            var div = butt.nextElementSibling.nextElementSibling.nextElementSibling;

            var element1 = document.createElement("table");
            element1.id = "T_odpoved" + counter;
            element1.setAttribute("Height", "server");
            element1.style.height = "28px";

            var element2 = document.createElement("tr");
            var element3 = document.createElement("td");
            //-------------------------------------------------------------
            var element4 = document.createElement("select");
            element4.id = "TDD_odpovedi" + counter;
            element4.setAttribute("runat", "server");
            element4.setAttribute("class", "selectVarianty");
            //-------------------------------------------------------------
            var element5 = document.createElement("option");
            element5.setAttribute("Value", "checkbox");
            element5.innerHTML = "CheckBox";
            var element6 = document.createElement("option");
            element6.setAttribute("Value", "radio");
            element6.innerHTML = "RadioButton";
            var element7 = document.createElement("option");
            element7.setAttribute("Value", "text");
            element7.innerHTML = "Text";
            //-------------------------------------------------------------
            var element8 = document.createElement("td");
            element8.setAttribute("class", "odpoved");

            var element9 = document.createElement("textArea");
            element9.id = "RTB_odpoved" + counter;
            element9.setAttribute("runat", "server");
            element9.setAttribute("class", "odpovedTB");
            //element9.setAttribute("type", "text");
            element9.setAttribute("rows", "1");

            var element10 = document.createElement("td");
            var element11 = document.createElement("button")
            element11.setAttribute("id", "close");
            element11.setAttribute("value", "T_odpoved" + counter);
            var idcko = "T_odpoved" + counter;
            element11.setAttribute("onclick", "odstranOdpoved(" + idcko + "); return false;");
            var element12 = document.createElement("img");
            element12.setAttribute("src", "../Images/delete_tel.png");
            //------------------------------------------------------
            element11.appendChild(element12);
            element10.appendChild(element11);
            element8.appendChild(element9);
            element4.appendChild(element5);
            element4.appendChild(element6);
            element4.appendChild(element7);
            element3.appendChild(element4);
            element2.appendChild(element3);
            element2.appendChild(element8);
            element2.appendChild(element10);
            element1.appendChild(element2);

            div.appendChild(element1);

            counter++;
        }

        function odstranOdpoved(sender) {
            sender.remove()
        }

        function novaOtazka(nazev) {

            var div = document.getElementById(nazev);

            var element1 = document.createElement("div")
            element1.setAttribute("id", "otazkaDiv" + counterOtazek);
            element1.setAttribute("class", "otazkaEdit ksprvek");
            element1.innerHTML +=
                "<div style='float:right'><label for='povinny'>Povinná otázka</label><input class='checkboxPovinny' id='povinnyCheck' type='checkbox' name='povinny' ><input type='image' src='../Images/delete_tel.png' onclick='odstranOtazku(otazkaDiv" + counterOtazek + "); return false;' style='float:right'/></div>"
                + "<table class='otazkaNadpis'><tr><td>"
                + "<textarea id='nadpisOtazky" + counterOtazek + "' class='nadpis1Anketa'  Placeholder='Zadejte text otázky' rows='2' cols='20'></textarea>"
                + "</td></tr></table>"
                + " <hr class='diver' /> <input id='novaOdpovedAdd" + counterOtazek + "' type='button' Value='+ Nová odpověď' class='buttonText' OnClick='novaOdpoved(this);' /><br /><br />";
            var element3 = document.createElement("div");
            var element2 = document.createElement("table");
            element2.setAttribute("id", "T_odpoved" + counterOtazek);
            element3.setAttribute("class", "seznamOdpovedi");
            element2.innerHTML += "<tr><td><select id='TDD_odpovedi" + counterOtazek + "' class='selectVarianty'><option value='checkbox'>Checkbox</option><option value='radio'>RadioButton</option><option value='text'>Text</option></select></td>"
                + "<td class='odpoved'><textArea type='text' id='RTB_odpoved" + counterOtazek + "' class='odpovedTB' rows='1'></textArea></td></tr></table>";
            element3.appendChild(element2);
            element1.appendChild(element3);
            div.appendChild(element1);
            counterOtazek++;
        }

        function ulozDotaznikVytvoreny(sender) {
            var dotaznik = document.getElementById("seznamOtazekEdit");

            //tělo JSON ankety
            var jsonOtazky = '';
            for (var i = 0; i < dotaznik.childElementCount; i++) {
                var prvek = dotaznik.children[i];
                var nadpis = prvek.getElementsByClassName("nadpis1Anketa")[0].value;
                var checkboxState = prvek.getElementsByClassName("checkboxPovinny")[0].checked;
                var jsonOdpovedi = '';

                //načtu si seznam odpovědí

                var seznamOdpovedi = prvek.getElementsByClassName("seznamOdpovedi")[0];
                for (var j = 0; j < seznamOdpovedi.childElementCount; j++) {
                    var typOdpovedi = seznamOdpovedi.children[j].getElementsByClassName("selectVarianty")[0].value;
                    var textOdpovedi = seznamOdpovedi.children[j].getElementsByClassName("odpovedTB")[0].value;
                    if (j > 0) {
                        jsonOdpovedi += ',';
                    }
                    jsonOdpovedi += '{"nazev":"' + textOdpovedi.cleanForJson() + '",' +
                        '"typ":"' + typOdpovedi + '"}'
                }

                if (i > 0) {
                    jsonOtazky += ',';
                }
                // alert(nadpis + " Delka:" +nadpis.length)
                var str = nadpis.replace(/\n/g, "¶");
                jsonOtazky += '{"nazev":"' + str.cleanForJson() + '",' +
                    '"typ":"Text",' +
                    '"povinny":"' + checkboxState + '",' +
                    '"odpovedi":[' + jsonOdpovedi + ']}';
            }

            //hlavička JSON ankety
            var anonymni = document.getElementById("<%=HF_anonymni.ClientID%>").value;
            var nadpis = document.getElementById("<%=HF_nazevAnkety.ClientID%>").value;
            var json = '{ "nazev":"' + nadpis.cleanForJson() + '",' +
                '"anonymni":"' + anonymni + '",' +
                '"otazky":[' + jsonOtazky + ']}';

            var jsonVystup = JSON.parse(json);
            document.getElementById("<%=HF_json.ClientID%>").value = json;
        }



        function anketaUlozOdpovedi() {

            var teloAnkety = document.getElementsByClassName("teloAnkety")[0];

            var dotaznik = teloAnkety.children[0];
            //tělo JSON ankety
            var jsonOtazky = '';
            for (var i = 0; i < dotaznik.childElementCount - 1; i++) {
                var prvek = dotaznik.children[i];

                var nadpis = prvek.getElementsByClassName("nadpis1Anketa")[0].value;
                var checkboxState = prvek.getElementsByClassName("checkboxPovinny")[0].getAttribute("checked");
                // console.log(checkboxState);
                var jsonOdpovedi = '';

                //načtu si seznam odpovědí

                var seznamOdpovedi = prvek.getElementsByClassName("seznamOdpovedi")[0];


                for (var j = 0; j < seznamOdpovedi.children[0].rows.length; j++) {
                    var typOdpovedi = seznamOdpovedi.children[0].rows[j].cells[0].children[0].getAttribute("type");

                    if (typOdpovedi != "text") {
                        var textOdpovedi = seznamOdpovedi.children[0].rows[j].cells[0].children[1].innerHTML;
                        var checked = seznamOdpovedi.children[0].rows[j].cells[0].children[0].checked;

                        if (checked == true) {
                            if (jsonOdpovedi.length > 0) {
                                jsonOdpovedi += ',';
                            }
                            jsonOdpovedi += '{"nazev":"' + textOdpovedi.cleanForJson() + '",' +
                                '"typ":"' + typOdpovedi + '"}'
                        }
                    } else if (typOdpovedi == "text") {
                        //pokud je typu text tak vezmu jeho hodnotu 
                        var textOdpovedi = seznamOdpovedi.children[0].rows[j].cells[0].children[0].value;

                        if (textOdpovedi.length > 0) {
                            if (jsonOdpovedi.length > 0) {
                                jsonOdpovedi += ',';
                            }
                            jsonOdpovedi += '{"nazev":"' + textOdpovedi.cleanForJson() + '",' +
                                '"typ":"' + typOdpovedi + '"}'
                        }

                    }



                }

                if (i > 0) {
                    jsonOtazky += ',';
                }

                var str = nadpis.replace(/\n/g, "¶");
                jsonOtazky += '{"nazev":"' + str.cleanForJson() + '",' +
                    '"typ":"Text",' +
                    '"povinny":"' + checkboxState + '",' +
                    '"odpovedi":[' + jsonOdpovedi + ']}';
            }

            //hlavička JSON ankety
            var anonymni = document.getElementById("<%=HF_anonymni.ClientID%>").value;
            var nadpis = document.getElementById("<%=HF_nazevAnkety.ClientID%>").value;
            var json = '{ "nazev":"' + nadpis.cleanForJson() + '",' +
                '"anonymni":"' + anonymni + '",' +
                '"otazky":[' + jsonOtazky + ']}';

            //console.log(json);
            // console.log(JSON.parse(json))
        }

        function odstranOtazku(sender) {
            sender.remove();

        }


        function RW_editor_Close(sender, args) {
            var poz = $get('<%=HF_opened2.ClientID%>');
            poz.value = "false";
            var win = $get('<%=RW_novaAnketa.ClientID%>');
            win.close;
            win.setAttribute("VisibleOnPageLoad", "false")



        }

        function EditujAnketu(sender, args) {

            ZrusEditaci();
            EditBull(true, sender);
            var value = sender._value;
            var id = sender._element.id;
            var button = document.getElementById(id);
            var bull = button.parentElement.parentElement;
            document.getElementById("<%=HF_id.ClientID%>").value = value;
            document.getElementById("<%=HF_adresati.ClientID%>").value = "";

            $.ajax({
                type: "POST",
                url: "./../Dotazniky/WebMethods.aspx/GetOtazky",
                data: "{id: " + value + "}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                },
                error: function (response) {
                    alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                },
                success: function (msg) {
                    var json = JSON.parse(msg.d);
                    //novaOtazka('seznamOtazekEdit');
                    var otazEdit = document.getElementById("otazkyEdit");
                    otazEdit.children[0].innerHTML = "";
                    if (json != null) {
                        NactiOtazky(json.otazky);
                        bull.querySelector("#body").querySelector("#text").children[2].children[1].checked = json.anonymni == "true";
                    }
                }

            });
        }

        function NactiOtazky(data) {
            var otazEdit = document.getElementById("otazkyEdit");
            var otazka = otazEdit.children[0];
            // PMEJ 11.09.2025 - Přidána kontrola zda anketa obsahuje otázky.
            //if (data[0].nazev != '') {
            if (Array.isArray(data) && data.length > 0 && data[0].nazev != '') {
                for (let i = 0; i < data.length; i++) {
                    novaOtazka('seznamOtazekEdit');
                    NactiJednuOtazku(otazEdit.children[0].children[i], data[i]);
                }
            }
        }

        function NactiJednuOtazku(otazka, data) {
            var nadpis = otazka.getElementsByClassName("nadpis1Anketa");
            nadpis[0].textContent = data.nazev;
            var checkbox = otazka.getElementsByClassName("checkboxPovinny");
            checkbox[0].checked = data.povinny == "true";

            var button = otazka.getElementsByClassName("buttonText")[0];

            for (let i = 1; i < data.odpovedi.length; i++) {
                novaOdpoved(button);
            }

            var druh = otazka.getElementsByClassName("selectVarianty");
            var odpoved = otazka.getElementsByClassName("odpovedTB");

            for (let i = 0; i < data.odpovedi.length; i++) {
                if (data.odpovedi[i].typ == "checkbox") druh[i].selectedIndex = 0;
                else if (data.odpovedi[i].typ == "radio") druh[i].selectedIndex = 1;
                else druh[i].selectedIndex = 2;
                odpoved[i].textContent = data.odpovedi[i].nazev;
            }
        }

        function UlozitAnketu(sender, args) {

            var id = sender._element.id;
            var button = document.getElementById(id);
            var bull = button.parentElement.parentElement;

            var nadpis = bull.getElementsByClassName("bullNadpis");
            document.getElementById("<%=HF_nazevAnkety.ClientID%>").value = nadpis[1].value;
            document.getElementById("<%=HF_anonymni.ClientID%>").value = bull.querySelector("#body").querySelector("#text").children[2].children[1].checked;

            ulozDotaznikVytvoreny(sender);
            EditBull(false, sender);

        }

        function EditBull(edit, sender) {
            var id = sender._element.id;
            var button = document.getElementById(id);
            var bull = button.parentElement.parentElement;
            ZmenViditelnost(edit, bull);
        }

        function ZrusEditaci() {
            var bulls = document.getElementsByClassName("ksBlBullItem");
            for (let i = 0; i < bulls.length; i++) {
                ZmenViditelnost(false, bulls[i]);
            }
        }

        function ZmenViditelnost(edit, bull) {
            var odd;
            var even;

            if (edit) {
                odd = "none";
                even = "block";
                bull.parentElement.style.background = "white";
                bull.parentElement.style.border = "solid 2px var(--kscolor1)";
                bull.parentElement.style.padding = "5px";
                bull.style.height = "220px";
            }
            else {
                even = "none";
                odd = "block";
                bull.parentElement.style.background = "var(--kscolor2)";
                bull.parentElement.style.border = "1px solid lightgrey";
                bull.parentElement.style.padding = "4px 4px 4px 8px";
                bull.style.height = "auto";
            }

            // PMEJ 11.09.2025 - zobrazení tlačítka pro zvolení obrázku v editačním režimu. 
            document.querySelectorAll('.imageUpload').forEach(function (el) {
                if (odd == "none") {
                    el.style.display = 'block';
                }
            });

            bull.querySelector("#body").querySelector("#text").children[0].style.display = odd; //nadpi
            bull.querySelector("#body").querySelector("#text").children[1].style.display = even; //nadpis edit
            bull.querySelector("#body").querySelector("#text").children[2].style.display = even; //anonym checkbox
            bull.querySelector("#body").querySelector("#text").children[4].style.display = odd; //text
            bull.querySelector("#body").querySelector("#text").children[5].style.display = even; //text edit
            //bull.querySelector("#body").querySelector("#text").children[6].children[0].style.display = odd; //adresati
            bull.querySelector("#body").querySelector("#text").children[6].children[1].style.display = even; //adresati edit

            bull.getElementsByClassName("RadPicker")[0].parentElement.style.display = odd;
            bull.getElementsByClassName("RadPicker")[2].parentElement.style.display = even;

            bull.children[1].children[0].style.display = odd;   //TRB_Editovat
            bull.children[1].children[1].style.display = even;  //TRB_Uloz
            bull.children[1].children[2].style.display = odd;   //TRB_Sablona

            var otazky = document.getElementById("otazkyEdit");
            otazky.style.display = even;

            var editButtons = document.getElementsByClassName("EditButton");

            for (let i = 0; i < editButtons.length; i++) {
                editButtons[i].style.display = odd;
            }
        }


    </script>
</telerik:RadScriptBlock>
<asp:HiddenField runat="server" ID="HF_adresati" />
<asp:HiddenField runat="server" ID="HF_anonymni" Value="false" />
<asp:HiddenField runat="server" ID="HF_nazevAnkety" />
<asp:HiddenField runat="server" ID="HF_json" />
<asp:HiddenField runat="server" ID="HF_id" />


<asp:Panel runat="server" ID="panelSeznamAnket">
    <telerik:RadListView runat="server" ID="RLV_SeznamAnket">
    </telerik:RadListView>
</asp:Panel>


<asp:HiddenField runat="server" ID="HF_opened2" />


<telerik:RadWindow Title="[%Vytvoření nové ankety%]" runat="server" ID="RW_novaAnketa" VisibleOnPageLoad="false" MaxWidth="600px" Modal="true"
    AutoSize="true" AutoSizeBehaviors="Width,Height" MinWidth="580px" OnClientClose="RW_editor_Close" Clien="true">
    <ContentTemplate>
        <asp:Panel ID="P_initDotaznik" runat="server">
            <div class="tabSha">
                <table style="width: 100%">
                    <tr>
                        <th class="nadpis2Anketa">
                            <telerik:RadLabel runat="server" Text="[%Název ankety%]:"></telerik:RadLabel>
                        </th>

                    </tr>
                    <tr>
                        <td>
                            <telerik:RadTextBox runat="server" ID="RTB_nazevAnkety" CssClass="nadpis2Anketa povinne-pole" Width="100%" MaxLength="120" Wrap="true"></telerik:RadTextBox>
                            <%--<asp:RequiredFieldValidator runat="server" ID="RFV_nazevankety" Display="Dynamic" ControlToValidate="RTB_nazevAnkety" ></asp:RequiredFieldValidator>--%>
                        </td>
                    </tr>
                    <%--<tr>
                        <th class="nadpis2Anketa">
                            <telerik:RadLabel runat="server" Text="[%Anonymní%]:"></telerik:RadLabel>
                        </th>
                    </tr>--%>
                    <%--<tr>
                        <td>
                            <telerik:RadDropDownList runat="server" ID="RDDL_anonymni" Width="100%">
                                <Items>
                                    <telerik:DropDownListItem Text="[%ANO%]" Value="true" Selected="true" />
                                    <telerik:DropDownListItem Text="[%NE%]" Value="false" />
                                </Items>
                            </telerik:RadDropDownList>
                        </td>
                    </tr>--%>
                    <tr>
                        <th class="nadpis2Anketa">
                            <telerik:RadLabel runat="server" Text="[%Popis ankety%]:"></telerik:RadLabel>
                        </th>

                    </tr>
                    <tr>
                        <td>
                            <telerik:RadTextBox runat="server" ID="RTB_popisAnkety" CssClass="nadpis2Anketa" Width="100%" TextMode="MultiLine" Rows="4" Wrap="true" MaxLength="255"></telerik:RadTextBox>
                        </td>
                    </tr>
                    <tr>
                        <th class="nadpis2Anketa">
                            <telerik:RadLabel runat="server" Text="[%Publikování%]:"></telerik:RadLabel>
                        </th>
                    </tr>
                    <tr>
                        <td>
                            <kspwc:TRadDatePicker runat="server" ID="TRDP_e_od" SelectedDate='<%# Bind("datum_od") %>'>
                                <DateInput EmptyMessage="[%Publikovat od%]"></DateInput>
                            </kspwc:TRadDatePicker>
                            <kspwc:TRadDatePicker runat="server" ID="TRDP_e_do" SelectedDate='<%# Bind("datum_do") %>'>
                                <DateInput EmptyMessage="[%Publikovat do%]"></DateInput>
                            </kspwc:TRadDatePicker>

                            <%--                        <kspwc:TRadButton runat="server" ID="TRB_e_publikovat" AutoPostBack="false" ButtonType="StandardButton" ToggleType="CheckBox" Checked='<%# Bind("Publikovano") %>'>
                            <ToggleStates>
                                <telerik:RadButtonToggleState Text="[%Je publikováno%]" />
                                <telerik:RadButtonToggleState Text="[%Není publikováno%]" />
                            </ToggleStates>
                        </kspwc:TRadButton>--%>

                        </td>
                    </tr>
                    <tr>
                        <th class="nadpis2Anketa">
                            <telerik:RadLabel runat="server" Text="[%Obrázek%]:"></telerik:RadLabel>
                        </th>
                    </tr>
                    <tr>
                        <td>
                            <telerik:RadAsyncUpload runat="server" ID="RAU_e_image" HideFileInput="true" AllowedFileExtensions=".jpeg,.jpg,.png" Width="80" MultipleFileSelection="Disabled" MaxFileInputsCount="1" OnFileUploaded="RAU_e_image_FileUploaded"
                                TemporaryFolder="~/Temp">
                                <FileFilters>
                                    <telerik:FileFilter Extensions=".jpeg,.jpg,.png" />
                                </FileFilters>
                            </telerik:RadAsyncUpload>
                        </td>
                    </tr>
                    <tr>
                        <th class="nadpis2Anketa">
                            <telerik:RadLabel runat="server" Text="[%Seznam osob%]:"></telerik:RadLabel>
                        </th>
                    </tr>
                    <tr>
                        <td>
                            <telerik:RadMultiSelect runat="server" ID="RMS_e_adresats" Filter="Contains" Skin="Metro" CssClass="ksBlMultiSelect"
                                AutoClose="false" DataValueField="key" DataTextField="nazev" Width="100%" AutoWidth="true" MinLength="1">
                                <ClientEvents OnChange="RMS_adresats_OnChange" OnDataBound="RMS_adresats_OnChange" />
                                <WebServiceClientDataSource runat="server" AutoSync="true">
                                    <WebServiceSettings>
                                        <Select Url="../WebServices/AutoCompleteService.asmx/GetAdresatsOfBulletins" RequestType="Post" DataType="JSON" ContentType="application/json; charset=utf-8" />
                                    </WebServiceSettings>
                                    <GroupExpressions>
                                        <telerik:ClientDataSourceGroupExpression FieldName="nazev_typ" />
                                    </GroupExpressions>
                                    <Schema DataName="d">
                                        <Model>
                                            <%-- ID neoznačuje id modelu ale sloupec obsahující klíč--%>
                                            <telerik:ClientDataSourceModelField FieldName="typ_org_j" DataType="Number" Editable="False" Nullable="false" />
                                            <telerik:ClientDataSourceModelField FieldName="org_j" DataType="String" Editable="False" />
                                            <telerik:ClientDataSourceModelField FieldName="nazev" DataType="String" Editable="False" />
                                            <telerik:ClientDataSourceModelField FieldName="nazev_typ" DataType="String" Editable="False" />
                                            <telerik:ClientDataSourceModelField FieldName="key" DataType="String" Editable="False" />
                                        </Model>
                                    </Schema>
                                </WebServiceClientDataSource>
                            </telerik:RadMultiSelect>
                        </td>
                    </tr>
                </table>
                <br />
                <telerik:RadLabel runat="server" ID="ErrorLabel" Text="[%Nebyl zadán název ankety.%]" ForeColor="Red" Visible="false"></telerik:RadLabel>
                <kspwc:TRadButton runat="server" ID="RB_createSurvey" Text="[%Vytvořit anketu%]" Width="100%" OnClick="RB_createSurvey_Click" Type="Submit" Icon-PrimaryIconCssClass="fi fi-add"></kspwc:TRadButton>
            </div>
        </asp:Panel>
        <asp:Panel ID="panelTvorbaOtazky" runat="server" Visible="false">
            <div id="bodySurvey" class="bodySurveys">
                <table class="nazevDotazniku">
                    <tr>
                        <td>
                            <asp:Label runat="server" ID="label_nadpis" CssClass="nadpis"></asp:Label>
                        </td>
                    </tr>
                </table>

                <div id="seznamOtazek">
                    <div id="otazkaDiv0" class="otazkaEdit ksprvek">
                        <div style="float: right">
                            <label for='povinny'>Povinná otázka</label>
                            <input class="checkboxPovinny" id='povinnyCheck' type='checkbox' name='povinny'>
                        </div>
                        <table class="otazkaNadpis">
                            <tr>
                                <td>
                                    <textarea id='nadpisOtazky' class='nadpis1Anketa' placeholder='Zadejte text otázky' rows='2' cols='20'></textarea>
                                </td>
                            </tr>
                        </table>
                        <hr class="diver" />
                        <input id="novaodpovedAdd" type='button' value="+ Nová odpověď" class="buttonText" onclick="novaOdpoved(this);" />
                        <br />
                        <br />
                        <div class="seznamOdpovedi">
                            <table id="T_odpoved1">
                                <tr>
                                    <td>
                                        <select id="TDD_odpovedi" class="selectVarianty">
                                            <option value="checkbox">Checkbox</option>
                                            <option value="radio">RadioButton</option>
                                            <option value="text">Text</option>
                                        </select>

                                    </td>
                                    <td class="odpoved">
                                        <textarea id="RTB_odpoved" class="odpovedTB" rows='1' />
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>

                </div>
                <input id="novaOtazkanazev" type="button" class="buttonTextAdd" value="+ Nová otázka" onclick="novaOtazka('seznamOtazek');" />
                <input runat="server" id="ulozitDotaznik" type="button" value="Uložit dotazník" onclick="ulozDotaznikVytvoreny(this);" onserverclick="ulozitDotaznik_ServerClick" />

            </div>
        </asp:Panel>
    </ContentTemplate>
</telerik:RadWindow>




