﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOzavazek.ascx.cs" Inherits="KSPortal.Controls.ZadostOzavezek" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<telerik:RadScriptBlock runat="server" ID="radscriptblock_zavazek" >
    <script type="text/javascript" id="telerikClientEvents2">
        var combo_druh_new;
        function clientLoad_ddlbinsert_druh_new(sender) {
            combo_druh_new = sender;
        }
        function ddlb_druh_edit_OnClientDropDownClosed(sender) {
            sender.clearItems();
            sender.trackChanges();
        }
    </script>
  </telerik:RadScriptBlock>
  <style type="text/css" id="id_style">
       .rgEditPopup div:nth-child(2) {
          padding: 0px 10px 10px 10px;
       }

       .zmena_mazani {
           border: solid 3px var(--kscolor1) !important;
       }

      .zmena_mazani::after {
          padding-left: 10px;
          content: url(../WebResource.axd?d=AaS8WEVe8bI4232n5BKtVnkxPQYX-YzqZRonhyjlDVj1DcAggAmLw3MgKS9KIG4Rs66APO6GvpD_Y10OmN3Nr6atsg5yUGxVtZb_G3uC3r-RwdqSus7S2NW6CY706UTp9ozi5rfZj7tsTWk6yBNeIWJZ1xB3M_U81gx-EtcAJyc1&amp;t=637073618400000000);
          vertical-align: +100%;
          color: var(--kscolor1);
          position: absolute;
      }

      .rfdTable td.zmena, .rfdTable tr.zmena {
          border: solid 3px var(--kscolor1) !important;
      }

      .zmena::after {
          padding-left: 10px;
          content: url(../WebResource.axd?d=OWsUznC0lyIAnEAMwFFNKMIeEh50eSFnUYAP39v-25xo_z3dFIaV4zHmNFJ1xDKpwgFKYvurCyTc83HUTxKrfSLXFiIwxIrLgrJdFpYVQIfZdiN2yJA6zwqEnmJ3gMG4hGxiDCTMd6U46Hpr-kWRn4XNzBn88ZWgzXGYOJhxbUc1&amp;t=637073618400000000);
          vertical-align: +100%;
          position: relative;
      }
       .rgMasterTable {
             border-collapse: collapse !important;
       }
    </style>

<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekzavazek" OnInserted="ObjectDataSource1_Inserted" 
    OnInserting="ObjectDataSource1_Inserting" 
    OnUpdated="ObjectDataSource1_Updated"
    OnUpdating="ObjectDataSource1_Updating"
    UpdateMethod="Update" InsertMethod="Insert" >
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />      
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="duvod" Type="String" />
     </UpdateParameters>
    <SelectParameters>
        <asp:Parameter Name="id_poz" Type="Int32"/>
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter Name="id_poz" Type="Int32" Direction="InputOutput" />   
        <asp:Parameter Name="koho_osc" Type="Decimal" />
        <asp:Parameter Name="koho_cislo_pom" Type="Int16" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="duvod" Type="String" />
        <asp:Parameter Name="adresat" Type="Decimal" />
        <asp:Parameter Name="novy_stav" Type="String" />       
    </InsertParameters>
    </asp:ObjectDataSource>

<asp:ObjectDataSource runat="server" ID="ds_zavazky"
    TypeName="KSProgram.Pozadavky.Pozadavekzavazek" SelectMethod="GetZavazkyMem"
    InsertMethod="SaveZavazekMem" UpdateMethod="SaveZavazekMem" DeleteMethod="DeleteZavazekMem"
    OldValuesParameterFormatString="original_{0}">    
    <SelectParameters>
        <asp:Parameter Name="puvodni" Type="Boolean" />
    </SelectParameters>   
    <InsertParameters>
       <%-- <asp:Parameter Name="id_poz" Type="Int32" />--%>
        <asp:Parameter Name="Druh" Type="String" />
        <asp:Parameter Name="DatumOd" Type="DateTime" />
        <asp:Parameter Name="DatumDo" Type="DateTime" />
        <asp:Parameter Name="Splneno" Type="DateTime" />
        <asp:Parameter Name="CestaSoubor" Type="String" />
        <asp:Parameter Name="Poznamka" Type="String" />
        <asp:Parameter Name="NazevSoubor" Type="String" />
        <asp:Parameter Name="InventarniCislo" Type="String" />
        <asp:Parameter Name="VyrobniCislo" Type="String" />       
        <%--<asp:Parameter Name="id_zavazku" Type="Int32" />--%>
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="Druh" Type="String" />
        <asp:Parameter Name="DatumOd" Type="DateTime" />
        <asp:Parameter Name="DatumDo" Type="DateTime" />
        <asp:Parameter Name="Splneno" Type="DateTime" />
        <asp:Parameter Name="CestaSoubor" Type="String" />
        <asp:Parameter Name="Poznamka" Type="String" />
        <asp:Parameter Name="NazevSoubor" Type="String" />
        <asp:Parameter Name="InventarniCislo" Type="String" />
        <asp:Parameter Name="VyrobniCislo" Type="String" />       
      <%--  <asp:Parameter Name="id_zavazku" Type="Int32" />--%>
    </UpdateParameters>
    <DeleteParameters>
    </DeleteParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource runat="server" ID="ds_zavazky_p"
    TypeName="KSProgram.Pozadavky.Pozadavekzavazek" SelectMethod="GetZavazkyMem"    
    OldValuesParameterFormatString="original_{0}"> 
    <SelectParameters>
          <asp:Parameter Name="puvodni" Type="Boolean" DefaultValue="True" />
    </SelectParameters>   
</asp:ObjectDataSource>


<kspwc:TRadGrid ID="grid_zavazky_p" runat="server" AllowPaging="False" AllowAutomaticUpdates="False" NotifikaceDisable="true" 
     AllowAutomaticInserts="True" DataSourceID="ds_zavazky_p" AllowAutomaticDeletes="true">
     <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />    
     <MasterTableView DataSourceID="ds_zavazky_p" AutoGenerateColumns="False" Caption="[%Původní hodnoty%]" DataKeyNames="Id" CssClass="rfdTable"  >
         <Columns>            
             <telerik:GridBoundColumn DataField="Druh" HeaderText="[%Druh závazku%]" UniqueName="Druh"></telerik:GridBoundColumn>
             <telerik:GridDateTimeColumn HeaderText="[%Datum od%]" DataField="DatumOd" UniqueName="DatumOd" DataFormatString="{0:d}" DataType="System.DateTime"></telerik:GridDateTimeColumn>
             <telerik:GridDateTimeColumn HeaderText="[%Datum do%]" DataField="DatumDo" UniqueName="DatumDo"  DataFormatString="{0:d}" DataType="System.DateTime"></telerik:GridDateTimeColumn>
             <telerik:GridDateTimeColumn HeaderText="[%Splněno%]" DataField="Splneno" UniqueName="Splneno"  DataFormatString="{0:d}"  DataType="System.DateTime"></telerik:GridDateTimeColumn>
             <telerik:GridBoundColumn HeaderText="[%Poznámka%]" DataField="Poznamka"  ItemStyle-Width="250" HeaderStyle-Width="250" UniqueName="Poznamka" DataType="System.String"/>
             <telerik:GridBoundColumn HeaderText="[%Inventární číslo%]" DataField="InventarniCislo" UniqueName="InventarniCislo" DataType="System.String"></telerik:GridBoundColumn>
             <telerik:GridBoundColumn HeaderText="[%Výrobní číslo%]" DataField="VyrobniCislo" UniqueName="VyrobniCislo" DataType="System.String"></telerik:GridBoundColumn>
             
         </Columns>
     </MasterTableView>
 </kspwc:TRadGrid>

<br />

 <kspwc:TRadGrid ID="grid_zavazky" runat="server" AllowPaging="False" AllowAutomaticUpdates="True" NotifikaceDisable="true" 
     AllowAutomaticInserts="True" DataSourceID="ds_zavazky" AllowAutomaticDeletes="true"  OnPreRender="grid_zavazky_PreRender" 
     OnItemDataBound="grid_zavazky_ItemDataBound"  OnItemCommand="grid_zavazky_ItemCommand"  >
     <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert"  />
     <ClientSettings>
     </ClientSettings>
     <MasterTableView EditMode="PopUp" DataSourceID="ds_zavazky" AutoGenerateColumns="False" DataKeyNames="Id" CommandItemDisplay="Top" Caption="-[%nové hodnoty%]" CssClass="rfdTable" >
         <EditFormSettings InsertCaption="[%Přidat nový závazek%]" CaptionFormatString="[%Editace závazku%]" PopUpSettings-Modal="true"
             CaptionDataField="druh">
             <EditColumn ButtonType="ImageButton" />
         </EditFormSettings>
         <CommandItemSettings AddNewRecordText="[%Přidat nový záznam%]" />
         <Columns>
             <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn" />
             <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />
             <telerik:GridTemplateColumn DataField="druh" HeaderText="[%Druh závazku%]" UniqueName="Druh">
                 <ItemTemplate>
                     <asp:Label runat="server" Text='<%# Eval("Druh") %>' ID="lab_item_druh"></asp:Label>
                 </ItemTemplate>
                 <InsertItemTemplate>
                     <kspwc:TRadComboBox ID="ddlb_druh_edit" runat="server" DropDownAutoWidth="Enabled" InputCssClass="povinne-pole"
                         EnableLoadOnDemand="True" EnableVirtualScrolling="True" SelectedValue='<%# Bind("Druh") %>'
                         Height="150px"  MarkFirstMatch="true" AutoCompleteSeparator=""
                         ShowMoreResultsBox="True" Width="250px" DropDownWidth="250" OnClientLoad="clientLoad_ddlbinsert_druh_new" OnClientDropDownClosed="ddlb_druh_edit_OnClientDropDownClosed">
                         <WebServiceSettings Method="GetDruhyZavazku" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                     </kspwc:TRadComboBox>
                     <kspwc:TRequiredValidator runat="server" ID="req_druh" ControlToValidate="ddlb_druh_edit"></kspwc:TRequiredValidator>

                 </InsertItemTemplate>
                 <EditItemTemplate>
                     <kspwc:TRadComboBox ID="ddlb_druh_insert" runat="server" DropDownAutoWidth="Enabled" InputCssClass="povinne-pole"
                          DataTextField="Text" DataValueField="Value"
                         EnableLoadOnDemand="True" EnableVirtualScrolling="True" Text='<%# Bind("Druh") %>' SelectedValue='<%# Bind("Druh") %>'
                         Height="150px" OnClientLoad="clientLoad_ddlbinsert_druh_new"  OnClientDropDownClosed="ddlb_druh_edit_OnClientDropDownClosed"
                         ShowMoreResultsBox="True" Width="250px" DropDownWidth="250px" EnableAutomaticLoadOnDemand="true">
                         <WebServiceSettings Method="GetDruhyZavazku" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                     </kspwc:TRadComboBox>
                     <kspwc:TRequiredValidator runat="server" ID="val_druh_edit2" ControlToValidate="ddlb_druh_insert"></kspwc:TRequiredValidator>
                 </EditItemTemplate>
             </telerik:GridTemplateColumn>             
             <telerik:GridDateTimeColumn HeaderText="[%Datum od%]" DataField="DatumOd" UniqueName="DatumOd"  DataFormatString="{0:d}"  DataType="System.DateTime"></telerik:GridDateTimeColumn>
             <telerik:GridDateTimeColumn HeaderText="[%Datum do%]" DataField="DatumDo" UniqueName="DatumDo"  DataFormatString="{0:d}"  DataType="System.DateTime"></telerik:GridDateTimeColumn>
             <telerik:GridDateTimeColumn HeaderText="[%Splněno%]" DataField="Splneno" UniqueName="Splneno"  DataFormatString="{0:d}"  DataType="System.DateTime"></telerik:GridDateTimeColumn>
             <telerik:GridTemplateColumn HeaderText="[%Poznámka%]" DataField="Poznamka" UniqueName="Poznamka">
                <ItemTemplate>
                    <%# Eval("Poznamka") %>
                </ItemTemplate>
                <EditItemTemplate>
                    <asp:TextBox ID="txtPoznamka" runat="server" Width="250px" MaxLength="60" Text='<%# Bind("Poznamka") %>' />
                </EditItemTemplate>
            </telerik:GridTemplateColumn>
             <%--<telerik:GridBoundColumn HeaderText="[%Inventární číslo%]" MaxLength="20" DataField="InventarniCislo" UniqueName="InventarniCislo" DataType="System.String"></telerik:GridBoundColumn>--%>
              <telerik:GridTemplateColumn HeaderText="[%Inventární číslo%]" DataField="InventarniCislo" UniqueName="InventarniCislo">
                    <ItemTemplate>
                        <%# Eval("InventarniCislo") %>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <asp:TextBox ID="txtInventarniCislo" runat="server" Width="250px" MaxLength="20" Text='<%# Bind("InventarniCislo") %>' />
                    </EditItemTemplate>
              </telerik:GridTemplateColumn>
             <%--<telerik:GridBoundColumn HeaderText="[%Výrobní číslo%]" MaxLength="30" DataField="VyrobniCislo" UniqueName="VyrobniCislo" DataType="System.String"></telerik:GridBoundColumn>--%>
              <telerik:GridTemplateColumn HeaderText="[%Výrobní číslo%]" DataField="VyrobniCislo" UniqueName="VyrobniCislo">
                   <ItemTemplate>
                       <%# Eval("VyrobniCislo") %>
                   </ItemTemplate>
                   <EditItemTemplate>
                       <asp:TextBox ID="txtVyrobniCislo" runat="server" Width="250px" MaxLength="30" Text='<%# Bind("VyrobniCislo") %>' />
                   </EditItemTemplate>
             </telerik:GridTemplateColumn>
         </Columns>
     </MasterTableView>
 </kspwc:TRadGrid>
<br />


<asp:FormView ID="FormView1" runat="server" OnItemInserted="FormView1_ItemInserted"  CssClass="nocss ksprvek" 
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound"  DataKeyNames="os_cislo"><%--PH 6.6.2018 fiktivní css aby tam telerik necpal rfdTable--%>
    <ItemTemplate>
         <asp:TableRow runat="server" ID="TableRowItem3">
                <asp:TableCell runat="server" ID="TableCellItem7" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label3x" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem8" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDuvodx" runat="server" Text='<%# Bind("duvod") %>' Width="200px"></asp:Label>                   
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowItem4">
                <asp:TableCell runat="server" ID="TableCellItem9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label4x" runat="server" Text="[%Vyřešit do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem10" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDatvyrizeni" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow6">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label8" runat="server" Text="[%Aktuální stav a datum změny stavu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell4" SkinID="DataFieldStyle">
                    <asp:Label ID="Label11" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"stav") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                    <asp:Label ID="Label10" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyriz_datum"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
    </ItemTemplate>
    <EditItemTemplate>
         <asp:TableRow runat="server" ID="TableRowEdit3">
                <asp:TableCell runat="server" ID="TableCellEdit8" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3x" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit9" ColumnSpan="3" SkinID="DataFieldStyle">
                    <telerik:RadTextBox ID="LabelDuvodx" runat="server" Text='<%# Bind("duvod") %>' MaxLength="999"
                        TextMode="MultiLine" Width="284px" Height="40"  Resize="Both"></telerik:RadTextBox><br />
                    <kspwc:TextValidator runat="server" ID="val1" ControlToValidate="LabelDuvodx"></kspwc:TextValidator>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowEdit4">
                <asp:TableCell runat="server" ID="TableCellEdit10" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit11" ColumnSpan="3" SkinID="DataFieldStyle">
                    <kspwc:TRadDatePicker ID="TextBoxDatVyrizeniEdit" DbSelectedDate='<%# Bind("vyridit_do") %>'
                        runat="server">
                    </kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>
    </EditItemTemplate>
    <InsertItemTemplate>
         <asp:TableRow runat="server" ID="TableRowInsert4">
                <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert8" ColumnSpan="3" SkinID="DataFieldStyle">                   
                    <telerik:RadTextBox ID="LabelDuvod" runat="server" Text='<%# Bind("duvod") %>' MaxLength="999"
                        TextMode="MultiLine" Width="283px" Height="40"  Resize="Both"></telerik:RadTextBox>
                    <kspwc:TextValidator runat="server" ID="val2" ControlToValidate="LabelDuvod"></kspwc:TextValidator>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowInsert5">
                <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="3" SkinID="DataFieldStyle">                   
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniInsert" DbSelectedDate='<%# DataBinder.Eval(Container.DataItem,"vyridit_do") %>'>
                    </kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>
    </InsertItemTemplate>
 </asp:FormView>


