﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOzadostdnp.ascx.cs" Inherits="KSPortal.Controls.ZadostOzadostdnp" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="tel" %>


<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" 
    OnInserted="ObjectDataSource1_Inserted" OnUpdating="ObjectDataSource1_Updating" OnUpdated="ObjectDataSource1_Updated"
    TypeName="KSProgram.Pozadavky.Pozadavekzadostdnp"
    SelectMethod="Select" 
    UpdateMethod="InsertOrUpdate" >
    <SelectParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
    </SelectParameters>
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32" Direction="InputOutput"/>
        <asp:Parameter Name="id_zadosti" Type="Int32" Direction="InputOutput"/>
        <asp:Parameter Name="cislo_rozhodnuti" Type="String" />
        <asp:Parameter Name="druh" Type="String" />
        <asp:Parameter Name="nepritomen_od" Type="DateTime" />
        <asp:Parameter Name="id_rod_prisl" Type="Int32" />
        <asp:Parameter Name="rodne_cislo" Type="String" />
        <asp:Parameter Name="datum_narozeni" Type="DateTime" />
        <asp:Parameter Name="prijmeni" Type="String" />
        <asp:Parameter Name="jmeno" Type="String" />
    </UpdateParameters>
    <DeleteParameters>
    </DeleteParameters>
</asp:ObjectDataSource>


<asp:ObjectDataSource ID="CisDruhDavky" runat="server"
    TypeName="KSProgram.Cssz.Ednp.CisDruhDavky"
    SelectMethod="Seznam">
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="CisPpmDuvodPece" runat="server"
    TypeName="KSProgram.Cssz.Ednp.CisPpmDuvodPece"
    SelectMethod="Seznam">
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="CisOppDuvodOtcovske" runat="server"
    TypeName="KSProgram.Cssz.Ednp.CisOppDuvodOtcovske"
    SelectMethod="Seznam">
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="CisOseVztahkOsetrovane" runat="server"
    TypeName="KSProgram.Cssz.Ednp.CisOseVztahkOsetrovane"
    SelectMethod="Seznam">
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="CisOseDuvodOsetrovani" runat="server"
    TypeName="KSProgram.Cssz.Ednp.CisOseDuvodOsetrovani"
    SelectMethod="Seznam">
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="CisDloSpolecnaKodVztah" runat="server" 
    TypeName="KSProgram.Cssz.Ednp.CisDloSpolecnaKodVztah"
    SelectMethod="Seznam">
</asp:ObjectDataSource>

<style type="text/css">
    .colHdr
    {
        text-align:right;
    }
    .info
    {
       font-style:italic;
       white-space:normal;
    }

</style>

<asp:FormView ID="FormView1" runat="server" CssClass="ksprvek" DataSourceID="ObjectDataSource1" DataKeyNames="id_zadosti" 
    OnPreRender="FormView1_PreRender" OnItemUpdating="FormView1_ItemUpdating" Width="700px" >    
    <ItemTemplate>
        <table cellpadding="4" style="border-collapse:collapse;width:100%">
            <tr>
                <td  colspan="5" class="rgCaption">
                    <wc:TLabel ID="Lab_title" runat="server" Text="[%Žádost o dávku nemocenského pojištění%]" />
                </td>
            </tr>
            <tr>
                <td class="colHdr" style="width:216px">
                    <asp:Label ID="id_zadosti_Lab" runat="server" Text="[%ID%]:"/>
                </td>
                <td colspan="4">
                    <asp:Label ID="id_zadosti" runat="server" Text='<%# Eval("id_zadosti") %>' />
                </td>
            </tr>
            <tr>
                <td class="colHdr">[%Zaměstnanec%]:</td>
                <td colspan="4">
                    <asp:HiddenField ID="os_cislo" runat="server" Value='<%# Eval("os_cislo") %>'></asp:HiddenField>
                    <asp:Label ID="zamestnanec" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>' />
                </td>
            </tr>
            <tr>
                <td class="colHdr">[%Druh dávky%]:</td>
                <td colspan="3">
                    <asp:HiddenField ID="druh" runat="server" Value='<%# Eval("druh") %>'></asp:HiddenField>
                    <asp:Label ID="druh_display" runat="server" Text='<%# Eval("druh_display") %>' Font-Bold="true" />
                </td>
            </tr>
            <tr>
                <td class="colHdr">[%Číslo rozhodnutí%]:</td>
                <td>
                    <asp:Label ID="cislo_rozhodnuti" runat="server" Text='<%# Eval("cislo_rozhodnuti") %>' />
                </td>
                <td>
                    <asp:CheckBox ID="bez_cr" runat="server" Checked='<%# Eval("bez_cr") %>' Text="[%Zahraniční (bez čísla rozhodnutí)%]" Enabled="False" />
                </td>
            </tr>
            <tr>
                <td class="colHdr">[%Nepřítomnost od%]:</td>
                <td>
                    <asp:Label ID="nepritomen_od" runat="server" Text='<%# Eval("nepritomen_od", "{0:d}") %>' />
                </td>
            </tr>
            <tr>
                <td class="colHdr">

                </td>
                <td colspan="4">
                    <asp:CheckBox ID="zduvodu_pece" runat="server"  Text="[%Z důvodu péče o dítě%]" 
                    Checked="false"
                    Visible="false" />
                </td>
            </tr>
            <tr id="tr_osoba1" runat="server">
                <td class="colHdr"><asp:Label ID="osoba_Lab" runat="server" Text="(ošetřovaný/dítě)" /></td> 
                <td> 
                    <asp:Label ID="prijmeni" runat="server" Text='<%# Eval("prijmeni") %>' /> &nbsp;&nbsp;
                    <asp:Label ID="jmeno" runat="server" Text='<%# Eval("jmeno") %>' /> &nbsp;&nbsp;
                    <asp:Label ID="rodne_cislo" runat="server" Text='<%# Eval("rodne_cislo") %>' /> &nbsp;&nbsp;
                    <asp:Label ID="datum_narozeni" runat="server" Text='<%# Eval("datum_narozeni", "{0:d}") %>' />
                    
                </td>
            </tr>
            <tr id="tr_osoba2" runat="server">
                
            </tr>
            <tr id="tr_osoba3" runat="server">
                
            </tr>
        </table>
    </ItemTemplate>
   
    <EditItemTemplate>
        <table cellpadding="4" style="border-collapse:collapse;width:100%">
            <tr>
                <td colspan="5" class="rgCaption">
                    <wc:TLabel ID="Lab_title" runat="server" Text="[%Žádost o dávku nemocenského pojištění%]" />
                </td>
            </tr>
            <tr>
                <td class="colHdr" style="width:216px">
                    <asp:Label ID="id_zadosti_Lab" runat="server" Text="[%ID%]:"/>
                </td>
                <td colspan="4">
                    <asp:Label ID="id_zadosti" runat="server" Text='<%# Eval("id_zadosti") %>' />
                </td>
            </tr>
            <tr>
                <td class="colHdr">[%Zaměstnanec%]:</td>
                <td colspan="4">
                    <asp:HiddenField ID="os_cislo" runat="server" Value='<%# Eval("os_cislo") %>'></asp:HiddenField>
                    <asp:Label ID="zamestnanec" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>' />
                </td>
            </tr>
            <tr>
                <td class="colHdr">[%Druh dávky%]:</td>
                <td colspan="4">
                    <tel:RadDropDownList ID="druh" runat="server" SelectedValue='<%# Bind("druh") %>' 
                        DataSourceID="CisDruhDavky" DataValueField="Key" DataTextField="Value"
                        AutoPostBack="true" OnSelectedIndexChanged="druh_DDL_SelectedIndexChanged" >
                    </tel:RadDropDownList>
                </td>
            </tr>
            <tr>
                <td class="colHdr">[%Číslo rozhodnutí%]:</td>
                <td>
                    <tel:RadTextBox ID="cislo_rozhodnuti" runat="server" Text='<%# Bind("cislo_rozhodnuti") %>' MaxLength="20"/>
                </td>
                <td colspan="3">
                    <asp:CheckBox ID="bez_cr" runat="server" Checked='<%# Eval("bez_cr") %>' Text="[%Zahraniční (bez čísla rozhodnutí)%]" />
                </td>
            </tr>
            <tr>
                <td class="colHdr">[%Nepřítomnost od%]:</td>
                <td colspan="4">
                    <wc:TRadDatePicker ID="nepritomen_od" runat="server" DbSelectedDate='<%# Bind("nepritomen_od") %>' Width="100px" DateInput-MaxLength="10" />
                </td>
            </tr>
            <tr>
                <td class="colHdr">

                </td>
                <td colspan="4">
                    <asp:CheckBox ID="zduvodu_pece" runat="server"  Text="[%Z důvodu péče o dítě%]" 
                    Checked="false" Visible="false" AutoPostBack="true" OnCheckedChanged="zduvodu_pece_CheckedChanged" />
                </td>
            </tr>
            <tr id="tr_osoba1" runat="server">
                <td class="colHdr">
                    <asp:Label ID="osoba_Lab" runat="server" Text="" />
                </td>
                <td>

                    <asp:ObjectDataSource ID="ODS_CisRodPrisl" runat="server"
                        TypeName="KSProgram.Personal.RodPrisl"
                        SelectMethod="Seznam">
                        <SelectParameters>
                            <asp:ControlParameter Name="os_cislo" Type="Decimal" ControlID="os_cislo" />
                            <asp:Parameter Name="prazdny_radek" Type="Boolean" DefaultValue="true" />
                        </SelectParameters>
                    </asp:ObjectDataSource>

                    <tel:RadDropDownList ID="id_rod_prisl" runat="server" SelectedValue='<%# Bind("id_rod_prisl") %>' 
                        DataSourceID="ODS_CisRodPrisl" DataTextField="jmeno_datum_narozeni" DataValueField="id_rod_prisl" 
                        AutoPostBack="true" OnSelectedIndexChanged="id_rod_prisl_SelectedIndexChanged" />
                </td>
                <td colspan="3">
                    <asp:Label ID="Label1" runat="server" Text="[%vyber nebo vyplň údaje níže%]" Font-Italic="True" />
                </td>
            </tr>
            <tr id="tr_osoba2" runat="server">
                <td></td><td>[%Příjmení%]</td><td>[%Jméno%]</td><td>[%Rodné číslo%]</td><td>[%Datum narození%]</td>
            </tr>
            <tr id="tr_osoba3" runat="server">
                <td></td>
                <td>
                    <tel:RadTextBox ID="prijmeni" runat="server" Text='<%# Bind("prijmeni") %>' MaxLength="40" Width="120px"/>
                </td>
                <td>
                    <tel:RadTextBox ID="jmeno" runat="server" Text='<%# Bind("jmeno") %>' MaxLength="40"  Width="120px"/>
                </td>
                <td>
                    <tel:RadTextBox ID="rodne_cislo" runat="server" Text='<%# Bind("rodne_cislo") %>' MaxLength="10"  Width="100px"/>
                </td>
                <td>
                    <wc:TRadDatePicker ID="datum_narozeni" runat="server" DbSelectedDate='<%# Bind("datum_narozeni") %>' Width="100px" 
                        DateInput-MaxLength="10"  MinDate="01.01.1900 0:00:00" />
                </td>
            </tr>
            <tr>
                <td colspan="5">
                    <asp:CustomValidator runat="server" ID="ValHlav" OnServerValidate="ValHlav_ServerValidate" />
                </td>
            </tr>
        </table>
    </EditItemTemplate>
</asp:FormView>


<asp:ObjectDataSource ID="ODS_Listy" runat="server" OnUpdating="ODS_Listy_Updating"
    TypeName="KSProgram.CSSZ.Ednp.EdnpZadostUdaje"
    SelectMethod="Select"
    InsertMethod=""
    UpdateMethod="InsertOrUpdate"
    DeleteMethod="Delete">
    <SelectParameters>
        <asp:Parameter Name="id_zadosti" Type="Int32" />
        <asp:Parameter Name="prazdny_radek" Type="Boolean" />
    </SelectParameters>
    <UpdateParameters>
        <asp:Parameter Name="id_zadost_detail" Type="Int32" Direction="InputOutput"/>
        <asp:Parameter Name="id_zadosti" Type="Int32" />
        <asp:Parameter Name="nepritomen_do" Type="DateTime" />
        <asp:Parameter Name="akce_vznik" Type="String" />
        <asp:Parameter Name="akce_trvani" Type="String" />
        <asp:Parameter Name="akce_ukonceni" Type="String" />
        <asp:Parameter Name="davka_od" Type="DateTime" />
        <asp:Parameter Name="davka_do" Type="DateTime" />
        <asp:Parameter Name="vztah_k_osetrovane" Type="String" />
        <asp:Parameter Name="duvod_osetrovani" Type="String" />
        <asp:Parameter Name="ic_zarizeni" Type="String" />
        <asp:Parameter Name="nazev_zarizeni" Type="String" />
        <asp:Parameter Name="spolecna_domacnost" Type="String" />
        <asp:Parameter Name="je_osamely" Type="String" />
        <asp:Parameter Name="v_peci_dite" Type="String" />
        <asp:Parameter Name="jinaos_ppm_rp" Type="String" />
        <asp:Parameter Name="jinaos_ppm_nec_vol" Type="String" />
        <asp:Parameter Name="jinaos_ppm_nemoc" Type="String" />
        <asp:Parameter Name="pecoval_celoudobu" Type="String" />
        <asp:Parameter Name="spolecna_kod_vztah" Type="Int16" />
        <asp:Parameter Name="stridani" Type="Boolean" />
        <asp:Parameter Name="duvod_pece_ppm" Type="String" />
        <asp:Parameter Name="dat_predp_porodu" Type="DateTime" />
        <asp:Parameter Name="hospital_dite" Type="Boolean" />
        <asp:Parameter Name="duvod_otcovske" Type="String" />
        <asp:Parameter Name="pece_od1" Type="DateTime" />
        <asp:Parameter Name="pece_do1" Type="DateTime" />
        <asp:Parameter Name="pece_od2" Type="DateTime" />
        <asp:Parameter Name="pece_do2" Type="DateTime" />
        <asp:Parameter Name="pece_od3" Type="DateTime" />
        <asp:Parameter Name="pece_do3" Type="DateTime" />
        <asp:Parameter Name="pece_od4" Type="DateTime" />
        <asp:Parameter Name="pece_do4" Type="DateTime" />
        <asp:Parameter Name="pece_od5" Type="DateTime" />
        <asp:Parameter Name="pece_do5" Type="DateTime" />
    </UpdateParameters>
</asp:ObjectDataSource>


<asp:ListView ID="LV_Listy" runat="server" DataSourceID="ODS_Listy" DataKeyNames="id_zadost_detail, id_zadosti" InsertItemPosition="None"
    OnPreRender="LV_Listy_PreRender" OnItemDataBound="LV_Listy_ItemDataBound">
    <LayoutTemplate>
        <table id="itemPlaceholderContainer" runat="server" cellpadding="4"
            style="background-color: #FFFFFF; border-collapse: collapse; width:700px">
            <tr>
                <td colspan="6" >
                    <wc:TLabel ID="Lab_titulek" runat="server" Text="[%Listy%]" Font-Bold="True" />
                </td>
            </tr>
            <tr id="itemPlaceholder" runat="server">
            </tr>
        </table>
    </LayoutTemplate>
    <ItemTemplate>
       
        <tr runat="server" id="tr_PPM">
            <td>
                <asp:Label ID="dat_predp_porodu_Lab" runat="server" Text="[%Datum předpokládaného porodu%]:" />
            </td>
            <td>
                <asp:Label ID="dat_predp_porodu" runat="server" Text='<%# Eval("dat_predp_porodu", "{0:d}") %>' />
            </td>
            <td>
                <%--<asp:CheckBox ID="zduvodu_pece" runat="server"  Text="[%Z důvodu péče o dítě%]" 
                    Checked='<%# !string.IsNullOrEmpty(Eval("duvod_pece_ppm").ToString()) %>'
                    Visible='<%# !string.IsNullOrEmpty(Eval("duvod_pece_ppm").ToString()) %>' />--%>
            </td>
            <td>
                <asp:Label ID="duvod_pece_ppm_Lab" runat="server" Text="[%Důvod péče o dítě%]:" Visible='<%# !string.IsNullOrEmpty(Eval("duvod_pece_ppm").ToString()) %>' />
            </td>
            <td>
                <asp:Label ID="duvod_pece_ppm" runat="server" Text='<%# Eval("duvod_pece_ppm_display") %>' Visible='<%# !string.IsNullOrEmpty(Eval("duvod_pece_ppm").ToString()) %>' />
            </td>
            <td>
                
            </td>
        </tr>
        <tr runat="server" id="tr_OPP">
            <td>
                <asp:Label ID="duvod_otcovske_Lab" runat="server" Text="[%Důvod otcovské%]:" />
            </td>
            <td>
                <asp:Label ID="duvod_otcovske" runat="server" Text='<%# Eval("duvod_otcovske_display") %>' />
            </td>
            <td>
                <asp:CheckBox ID="hospital_dite" runat="server" Checked='<%# Eval("hospital_dite") %>' Text="[%Hospitalizace dítěte%]" />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_akce_vznik">
            <td colspan="6">
                <asp:CheckBox ID="akce_vznik" runat="server" Checked='<%# Eval("akce_vznik") %>' Text="[%Vznik%]" />
            </td>
        </tr>
        <tr runat="server" id="tr_DLO_vztah_k_osetrovane">
            <td class="colHdr" style="min-width:113px">
                <asp:Label ID="spolecna_kod_vztah_Lab" runat="server" Text="[%Vztah ošetřované osoby k zaměstnanci%]:" />
            </td>
            <td colspan="5">
                <asp:Label ID="spolecna_kod_vztah_display" runat="server" Text='<%# Eval("spolecna_kod_vztah_display") %>' />
            </td>
        </tr>
        <tr runat="server" id="tr_OSE_vztah_k_osetrovane">
            <td class="colHdr" style="min-width:113px">
                <asp:Label ID="vztah_k_osetrovane_Lab" runat="server" Text="[%Vztah ošetřované osoby k zaměstnanci%]:" />
            </td>
            <td colspan="5">
                <asp:Label ID="vztah_k_osetrovane_display" runat="server" Text='<%# Eval("vztah_k_osetrovane_display") %>' />
            </td>
        </tr>
        <tr runat="server" id="tr_OSE_duvod_osetrovani">
            <td class="colHdr">
                <asp:Label ID="duvod_osetrovani_Lab" runat="server" Text="[%Důvod ošetřování%]:" />
            </td>
            <td colspan="5">
                 <asp:HiddenField ID="duvod_osetrovani" runat="server" Value='<%# Eval("duvod_osetrovani") %>' />
                <asp:Label ID="duvod_osetrovani_display" runat="server" Text='<%# Eval("duvod_osetrovani_display") %>' />
            </td>
        </tr>
        <tr runat="server" id="tr_OSE_zarizeni">
            <td class="colHdr">
                <asp:Label ID="nazev_zarizeni_Lab" runat="server" Text="[%Název zařízení (školy)%]:" />
            </td>
            <td colspan="3">
                <asp:Label ID="nazev_zarizeni" runat="server" Text='<%# Eval("nazev_zarizeni") %>' />
            </td>
            <td class="colHdr">
                <asp:Label ID="ic_zarizeni_Lab" runat="server" Text="[%IČ zařízení%]:" />
            </td>
            <td>
                <asp:Label ID="ic_zarizeni" runat="server" Text='<%# Eval("ic_zarizeni") %>' />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_spolecna_domacnost">
            <td>

            </td>
            <td colspan="5">
                <asp:CheckBox ID="spolecna_domacnost_ChB" runat="server" Checked='<%# Eval("spolecna_domacnost") %>' Text="[%Žiji ve společné domácnosti s ošetřovanou osobou%]" />
                <br />
                <asp:CheckBox ID="je_osamely_ChB" runat="server" Checked='<%# Eval("je_osamely") %>' Text="[%Jsem osamělým zaměstnancem ve smyslu § 40 zákona č. 187/2006 Sb. (Zákon o nemocenském pojištění)%]" />
                <br />            
                <asp:CheckBox ID="v_peci_dite_ChB" runat="server" Checked='<%# Eval("v_peci_dite") %>' Text="[%Mám v péči dítě do 16 let, které neukončilo povinnou školní docházku%]" />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_jinaos">
            <td>

            </td>
            <td colspan="5">
                <asp:CheckBox ID="jinaos_ppm_rp_ChB" runat="server" Checked='<%# Eval("jinaos_ppm_rp") %>' Text="[%Na ošetřovanou osobu, která je dítětem, je jiné fyzické osobě poskytována peněžitá pomoc v mateřství nebo má jiná osoba nárok na rodičovský příspěvek na ošetřovanou osobu (dítě)%]" />
                <br />
                &nbsp;&nbsp;<asp:CheckBox ID="jinaos_ppm_nec_vol_ChB" runat="server" Checked='<%# Eval("jinaos_ppm_nec_vol") %>' Text="[%Jiná fyzická osoba s nárokem na rodičovský příspěvek je zaměstnancem a v zaměstnání nečerpá volno nebo je OSVČ%]" />
                <br />
                &nbsp;&nbsp;<asp:CheckBox ID="jinaos_ppm_nemoc_ChB" runat="server" Checked='<%# Eval("jinaos_ppm_nemoc") %>' Text="[%Jiná fyzická osoba, které je poskytována peněžitá pomoc v mateřství nebo má nárok na rodičovský příspěvek na ošetřovanou osobu (dítě), onemocněla, utrpěla úraz, nastaly u ní situace uvedené v § 57 odst. 1 písm. b) nebo c) ZNP, porodila, nebo jí byla nařízena karanténa%]" />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_akce_TU">
            <td colspan="6">
                <asp:CheckBox ID="akce_ukonceni" runat="server" Checked='<%# Eval("akce_ukonceni") %>' Text="[%Ukončení%]" />
                <asp:CheckBox ID="akce_trvani" runat="server" Checked='<%# Eval("akce_trvani") %>' Text="[%Trvání%]" />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_nepritomen_do">
            <td class="colHdr">
                <asp:Label ID="nepritomen_do_Lab" runat="server" Text="[%Nepřítomnost%]:" />
            </td>
            <td>
                [%od%] <asp:Label ID="nepritomen_od" runat="server" Text='<%# Eval("nepritomen_od", "{0:d}") %>' />
            </td>
            <td colspan="4">
                [%do%] <asp:Label ID="nepritomen_do" runat="server" Text='<%# Eval("nepritomen_do", "{0:d}") %>' />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_davka_od_do">
            <td class="colHdr">
                <asp:Label ID="davka_od_Lab" runat="server" Text="[%Žádost o výplatu ošetřovného za období%]:" />
            </td>
            <td>
                 [%od%] <asp:Label ID="davka_od" runat="server" Text='<%# Eval("davka_od", "{0:d}") %>' />
            </td>
            <td colspan="4">
                <asp:Label ID="davka_do_Lab" runat="server" Text="[%do%]" />
                <asp:Label ID="davka_do" runat="server" Text='<%# Eval("davka_do", "{0:d}") %>' />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_pecoval_celoudobu">
            <td>

            </td>
            <td colspan="5">
                <asp:CheckBox ID="pecoval_celoudobu_ChB" runat="server" Checked='<%# Eval("pecoval_celoudobu") %>' Text="[%Ošetřování/péči jsem osobně poskytoval po celou dobu nepřítomnosti v zaměstnání%]" />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_pece_tit">
            <td></td>
            <td colspan="5">
                <asp:Label ID="pece_od" runat="server" Text="[%Ošetřování/péči jsem osobně poskytoval v těchto dnech%]:" />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_PECEOD">
            <td></td>
            <td colspan="5">
                <asp:Label ID="pece_1" runat="server" Text='<%# Eval("pece_od1", "{0:d}") + " - " + Eval("pece_do1", "{0:d}") %>' />
                
                <asp:Label ID="pece_2" runat="server" Text='<%# Eval("pece_od2", "{0:d}") + " - " + Eval("pece_do2", "{0:d}") %>' />
            
                <asp:Label ID="pece_3" runat="server" Text='<%# Eval("pece_od3", "{0:d}") + " - " + Eval("pece_do3", "{0:d}") %>' />

                 <asp:Label ID="pece_4" runat="server" Text='<%# Eval("pece_od4", "{0:d}") + " - " + Eval("pece_do4", "{0:d}") %>' />   

                 <asp:Label ID="pece_5" runat="server" Text='<%# Eval("pece_od5", "{0:d}") + " - " + Eval("pece_do5", "{0:d}") %>' />
            </td>            
        </tr>
        <tr runat="server" id="tr_OSEDLO_PECEDO">
            <td colspan="2" style="text-align:center">
                            
            </td>
            <td colspan="2" style="text-align:center">
               
            </td>
            <td colspan="2" style="text-align:center">
                
            </td>
        </tr>
        <tr runat="server" id="tr_DLO_stridani">
            <td colspan="6">
                <asp:CheckBox ID="stridani" runat="server" Checked='<%# Bind("stridani") %>' Text="[%V péči se budu střídat s dalšími ošetřujícími osobami%]" />
            </td>
        </tr>
        <%--<tr>
            <td colspan ="6">
                <asp:CheckBox ID="DeleteCheckBox" runat="server" Text="[%Smazat%]" Visible="false" />
            </td>
        </tr>--%>
    </ItemTemplate>

    <EditItemTemplate>
        
        <tr runat="server" id="tr_PPM">
            <td colspan="2">
                <asp:Label ID="dat_predp_porodu_Lab" runat="server" Text="[%Datum předpokládaného porodu%]:" />
            </td>
            <td>
                <wc:TRadDatePicker ID="dat_predp_porodu" runat="server" DbSelectedDate='<%# Bind("dat_predp_porodu") %>' Width="100px" DateInput-MaxLength="10" />
            </td>
            <td>
                <%--<asp:CheckBox ID="zduvodu_pece" runat="server"  Text="[%Z důvodu péče o dítě%]" 
                    Checked='<%# !string.IsNullOrEmpty(Eval("duvod_pece_ppm").ToString()) %>'
                    Visible="true" />--%>
            </td>
            <td>
                <asp:Label ID="duvod_pece_ppm_Lab" runat="server" Text="[%Důvod péče o dítě%]:" />
            </td>
            <td>
                <tel:RadDropDownList ID="duvod_pece_ppm" runat="server" SelectedValue='<%# Bind("duvod_pece_ppm") %>' Width="160px"
                    DataSourceID="CisPpmDuvodPece" DataValueField="Key" DataTextField="Value">
                </tel:RadDropDownList>
            </td>
        </tr>
        <tr runat="server" id="tr_OPP">
            <td>
                <asp:Label ID="duvod_otcovske_Lab" runat="server" Text="[%Důvod otcovské%]:" />
            </td>
            <td colspan="4">
                <tel:RadDropDownList ID="duvod_otcovske" runat="server" SelectedValue='<%# Bind("duvod_otcovske") %>' Width="400px"
                    DataSourceID="CisOppDuvodOtcovske" DataValueField="Key" DataTextField="Value">
                </tel:RadDropDownList>
            </td>
            <td>
                <asp:CheckBox ID="hospital_dite" runat="server" Checked='<%# Bind("hospital_dite") %>' Text="[%Hospitalizace dítěte%]" />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_akce_vznik">
            <td colspan="6">
                <asp:CheckBox ID="akce_vznik" runat="server" Checked='<%# Bind("akce_vznik") %>' Text="[%Vznik%]" AutoPostBack="True" />
            </td>
        </tr>
        <tr runat="server" id="tr_DLO_vztah_k_osetrovane">
            <td class="colHdr" style="min-width:113px">
                <asp:Label ID="spolecna_kod_vztah_Lab" runat="server" Text="[%Vztah ošetřované osoby k zaměstnanci%]:" />
            </td>
            <td colspan="5">
                <tel:RadDropDownList ID="spolecna_kod_vztah" runat="server" SelectedValue='<%# Bind("spolecna_kod_vztah") %>' Width="400px"
                    DataSourceID="CisDloSpolecnaKodVztah" DataValueField="Key" DataTextField="Value">
                </tel:RadDropDownList>
            </td>
        </tr>
        <tr runat="server" id="tr_OSE_vztah_k_osetrovane">
            <td class="colHdr" style="min-width:113px">
                <asp:Label ID="vztah_k_osetrovane_Lab" runat="server" Text="[%Vztah ošetřované osoby k zaměstnanci%]:" />
            </td>
            <td colspan="5">
                <tel:RadDropDownList ID="vztah_k_osetrovane" runat="server" SelectedValue='<%# Bind("vztah_k_osetrovane") %>' Width="400px"
                    DataSourceID="CisOseVztahkOsetrovane" DataValueField="Key" DataTextField="Value">
                </tel:RadDropDownList>
            </td>
        </tr>
        <tr runat="server" id="tr_OSE_duvod_osetrovani">
            <td class="colHdr">
                <asp:Label ID="duvod_osetrovani_Lab" runat="server" Text="[%Důvod ošetřování%]:" />
            </td>
            <td colspan="5">
                <tel:RadDropDownList ID="duvod_osetrovani" runat="server" SelectedValue='<%# Bind("duvod_osetrovani") %>' Width="400px"
                    DataSourceID="CisOseDuvodOsetrovani" DataValueField="Key" DataTextField="Value" AutoPostBack="true">
                </tel:RadDropDownList>
            </td>
        </tr>
        <tr runat="server" id="tr_OSE_zarizeni">
            <td class="colHdr">
                <asp:Label ID="nazev_zarizeni_Lab" runat="server" Text="[%Název zařízení (školy)%]:" />
            </td>
            <td colspan="5">
                <tel:RadTextBox ID="nazev_zarizeni" runat="server" Text='<%# Bind("nazev_zarizeni") %>' MaxLength="100" Width="250px" />
            </td>
            <td class="colHdr">
                <asp:Label ID="ic_zarizeni_Lab" runat="server" Text="[%IČ zařízení%]:" />
            </td>
            <td>
                <tel:RadTextBox ID="ic_zarizeni" runat="server" Text='<%# Bind("ic_zarizeni") %>' MaxLength="8" />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_spolecna_domacnost">
            <td>

            </td>
            <td colspan="5">
                <asp:CheckBox ID="spolecna_domacnost" runat="server" Checked='<%# Bind("spolecna_domacnost") %>' 
                    Text="[%Žiji ve společné domácnosti s ošetřovanou osobou%]" 
                    ToolTip="[%Domácností se rozumí společenství fyzických osob, které spolu trvale žijí a společně uhrazují náklady na své potřeby. V případě svěření dítěte soudem do společné nebo do střídavé péče obou rodičů se za domácnost považuje domácnost každého z těchto rodičů.%]" />
                <br />
                <asp:CheckBox ID="je_osamely" runat="server" Checked='<%# Bind("je_osamely") %>' 
                    Text="[%Jsem osamělým zaměstnancem ve smyslu § 40 zákona č. 187/2006 Sb. (Zákon o nemocenském pojištění)%]" 
                    ToolTip="[%Za osamělého zaměstnance se považuje zaměstnanec svobodný, ovdovělý nebo rozvedený, pokud nežije s družkou (druhem) nebo v registrovaném partnerství. Za osamělého zaměstnance se považuje i zaměstnanec, jehož manželka (manžel) je ve výkonu trestu odnětí svobody uloženého v trvání nejméně jednoho roku nebo ve výkonu zabezpečovací detence, nebo bylo-li zahájeno řízení o prohlášení manželky (manžela) za nezvěstnou anebo za mrtvou, a tento zaměstnanec nežije s družkou (druhem).%]"/>
                <br />
                <asp:CheckBox ID="v_peci_dite" runat="server" Checked='<%# Bind("v_peci_dite") %>' Text="[%Mám v péči dítě do 16 let, které neukončilo povinnou školní docházku%]" />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_jinaos">
            <td>

            </td>
            <td colspan="5">
                <asp:CheckBox ID="jinaos_ppm_rp" runat="server" Checked='<%# Bind("jinaos_ppm_rp") %>' Text="[%Na ošetřovanou osobu, která je dítětem, je jiné fyzické osobě poskytována peněžitá pomoc v mateřství nebo má jiná osoba nárok na rodičovský příspěvek na ošetřovanou osobu (dítě)%]" />
                <br />
                &nbsp;-&nbsp<asp:CheckBox ID="jinaos_ppm_nec_vol" runat="server" Checked='<%# Bind("jinaos_ppm_nec_vol") %>' Text="[%Jiná fyzická osoba s nárokem na rodičovský příspěvek je zaměstnancem a v zaměstnání nečerpá volno nebo je OSVČ%]" />
                <br />
                &nbsp;-&nbsp<asp:CheckBox ID="jinaos_ppm_nemoc" runat="server" Checked='<%# Bind("jinaos_ppm_nemoc") %>' Text="[%Jiná fyzická osoba, které je poskytována peněžitá pomoc v mateřství nebo má nárok na rodičovský příspěvek na ošetřovanou osobu (dítě), onemocněla, utrpěla úraz, nastaly u ní situace uvedené v § 57 odst. 1 písm. b) nebo c) ZNP, porodila, nebo jí byla nařízena karanténa%]" />
            </td>
        </tr>

        <tr runat="server" id="tr_OSEDLO_akce_TU">
            <td colspan="6">
                <asp:CheckBox ID="akce_ukonceni" runat="server" Checked='<%# Bind("akce_ukonceni") %>' Text="[%Ukončení%]" AutoPostBack="True" OnCheckedChanged="akce_ukonceni_CheckedChanged" />
                <asp:CheckBox ID="akce_trvani" runat="server" Checked='<%# Bind("akce_trvani") %>' Text="[%Trvání%]" AutoPostBack="True" OnCheckedChanged="akce_trvani_CheckedChanged" />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_nepritomen_do">
            <td class="colHdr">
                <asp:Label ID="nepritomen_do_Lab" runat="server" Text="[%Nepřítomnost%]:" />
            </td>
            <td>
                [%od%] <wc:TRadDatePicker ID="nepritomen_od" runat="server" DbSelectedDate='<%# Eval("nepritomen_od") %>' Width="100px" DateInput-MaxLength="10" Enabled="false" />
            </td>
            <td colspan="4">
                [%do%] <wc:TRadDatePicker ID="nepritomen_do" runat="server" DbSelectedDate='<%# Bind("nepritomen_do") %>' Width="100px" DateInput-MaxLength="10" />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_davka_od_do">
            <td class="colHdr">
                <asp:Label ID="davka_od_Lab" runat="server" Text="[%Žádám o výplatu ošetřovného za období%]:" />
            </td>
            <td>
                [%od%] <wc:TRadDatePicker ID="davka_od" runat="server" DbSelectedDate='<%# Bind("davka_od") %>' Width="100px" DateInput-MaxLength="10" />
            </td>
            <td colspan="4">
                [%do%] <wc:TRadDatePicker ID="davka_do" runat="server" DbSelectedDate='<%# Bind("davka_do") %>' Width="100px" DateInput-MaxLength="10" />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_pecoval_celoudobu">
            <td>

            </td>
            <td colspan="5">
                <asp:CheckBox ID="pecoval_celoudobu" runat="server" Checked='<%# Bind("pecoval_celoudobu") %>' 
                    Text="[%Ošetřování/péči jsem osobně poskytoval po celou dobu nepřítomnosti v zaměstnání%]" 
                    AutoPostBack="True" OnCheckedChanged="pecoval_celoudobu_CheckedChanged" />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_pece_tit">
            <td></td>
            <td colspan="5">
                <asp:Label ID="pece_od" runat="server" Text="[%Ošetřování/péči jsem osobně poskytoval v těchto dnech%]:" />
            </td>
        </tr>
        <tr runat="server" id="tr_OSEDLO_PECEOD">
            <%--UDELAT PODTABULKU, JINAK nebudo slopce stejne siroke--%>
            <td></td>
            <td colspan="5"> 
                [%od%]&nbsp;<wc:TRadDatePicker ID="pece_od1" runat="server" DbSelectedDate='<%# Bind("pece_od1") %>'  Width="100px" DateInput-MaxLength="10" />                
                [%do%]&nbsp;<wc:TRadDatePicker ID="pece_do1" runat="server" DbSelectedDate='<%# Bind("pece_do1") %>'  Width="100px" DateInput-MaxLength="10" />
                <br />
                [%od%]&nbsp;<wc:TRadDatePicker ID="pece_od2" runat="server" DbSelectedDate='<%# Bind("pece_od2") %>'  Width="100px" DateInput-MaxLength="10" />
                [%do%]&nbsp;<wc:TRadDatePicker ID="pece_do2" runat="server" DbSelectedDate='<%# Bind("pece_do2") %>'  Width="100px" DateInput-MaxLength="10" />
                <br />
                [%od%]&nbsp;<wc:TRadDatePicker ID="pece_od3" runat="server" DbSelectedDate='<%# Bind("pece_od3") %>'  Width="100px" DateInput-MaxLength="10" />
                [%do%]&nbsp;<wc:TRadDatePicker ID="pece_do3" runat="server" DbSelectedDate='<%# Bind("pece_do3") %>'  Width="100px" DateInput-MaxLength="10" />
                <br />
                [%od%]&nbsp;<wc:TRadDatePicker ID="pece_od4" runat="server" DbSelectedDate='<%# Bind("pece_od4") %>'  Width="100px" DateInput-MaxLength="10" />
                [%do%]&nbsp;<wc:TRadDatePicker ID="pece_do4" runat="server" DbSelectedDate='<%# Bind("pece_do4") %>'  Width="100px" DateInput-MaxLength="10" />
                <br />
                [%od%]&nbsp;<wc:TRadDatePicker ID="pece_od5" runat="server" DbSelectedDate='<%# Bind("pece_od5") %>'  Width="100px" DateInput-MaxLength="10" />
                [%do%]&nbsp;<wc:TRadDatePicker ID="pece_do5" runat="server" DbSelectedDate='<%# Bind("pece_do5") %>'  Width="100px" DateInput-MaxLength="10" />                
            </td>            
        </tr>
        <tr runat="server" id="tr_OSEDLO_PECEDO">
            
        </tr>
        <tr runat="server" id="tr_DLO_stridani">
            <td colspan="6">
                <asp:CheckBox ID="stridani" runat="server" Checked='<%# Bind("stridani") %>' Text="[%V péči se budu střídat s dalšími ošetřujícími osobami%]" />
            </td>
        </tr>
        <%--<tr>
            <td colspan ="6">
                <asp:CheckBox ID="DeleteCheckBox" runat="server" Text="[%Smazat%]" Visible="false" />
            </td>
        </tr>--%>
        <tr>
            <td colspan ="6">
                <asp:CustomValidator runat="server" ID="ValDetail" OnServerValidate="ValDetail_ServerValidate" />
            </td>
        </tr>
    </EditItemTemplate>
</asp:ListView>
<br />