﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOpracmisto.ascx.cs" Inherits="KSPortal.Controls.ZadostOpracmisto" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="PrMistoControl.ascx" TagName="PrMistoControl" TagPrefix="uc1" %>

<telerik:RadAjaxManagerProxy runat="server" ID="RAMP_manager">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="ajax_panel">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="ajax_panel" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<asp:Panel runat="server" ID="ajax_panel">
    <telerik:RadFormDecorator ID="QsfFromDecorator" runat="server" DecoratedControls="CheckBoxes,RadioButtons,Select,Textarea,Textbox"
        EnableRoundedCorners="false" DecorationZoneID="FormView1" />

    <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekpracmisto" InsertMethod="Insert"
        UpdateMethod="Update" OnSelecting="ObjectDataSource1_Selecting"
        OnInserting="ObjectDataSource1_Inserting" OnInserted="ObjectDataSource1_Inserted"
        OnUpdating="ObjectDataSource1_Updating" OnUpdated="ObjectDataSource1_Updated">
        <SelectParameters>
            <asp:Parameter Name="id_pozadavku" Type="Int32" DefaultValue="" />
        </SelectParameters>
        <UpdateParameters>
            <asp:Parameter Name="id_poz" Type="Int32" />
            <asp:Parameter Name="vyridit_do" Type="DateTime" />
        </UpdateParameters>
        <InsertParameters>
            <asp:Parameter Direction="InputOutput" Name="id_poz" Type="Int32" />
            <asp:Parameter Name="vyridit_do" Type="DateTime" />
            <asp:Parameter Name="id_pracmist" Type="DateTime" />
        </InsertParameters>
    </asp:ObjectDataSource>

    <asp:FormView ID="FormView1" runat="server" DataKeyNames="os_cislo" OnDataBound="FormView1_DataBound">
        <ItemTemplate>
            <table class="InnerTableForm">
                <tr>
                    <td>
                        <fieldset id="FS_read_zam">
                            <legend>[%Požadavek%]</legend>
                            <table class="InnerTableFormFieldset">
                                <tr>
                                    <td>
                                        <asp:Label runat="server" ID="L_r_nazev" Text="[%Návrhované pracovní místo%]:"></asp:Label>
                                    </td>
                                    <td>
                                        <%# Eval("naz_pracmist") %>
                                    </td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:Label runat="server" ID="L_r_vyriz" Text="[%Vyřídit do%]:"></asp:Label>
                                    </td>
                                    <td>
                                        <%# String.Format("{0:d.M.yyyy}", Eval("vyridit_do")) %>
                                    </td>
                                    <td>
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </td>
                </tr>
            </table>
        </ItemTemplate>
        <EditItemTemplate>
            <table class="InnerTableForm">
                <tr>
                    <td>
                        <fieldset id="FS_edit_zam">
                            <legend>[%Požadavek%]</legend>
                            <table class="InnerTableFormFieldset">
                                <tr>
                                    <td>
                                        <asp:Label runat="server" ID="L_e_nazev" Text="[%Návrhované pracovní místo%]:"></asp:Label>
                                    </td>
                                    <td>
                                        <%# Eval("naz_pracmist") %>
                                    </td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:Label runat="server" ID="L_e_vyriz" Text="[%Vyřídit do%]:"></asp:Label>
                                    </td>
                                    <td>
                                        <kspwc:TRadDatePicker ID="TRDP_edit_vyriz_datum" runat="server" DropDownAutoWidth="Enabled"
                                            Width="160px" DbSelectedDate='<%# Bind("vyridit_do") %>'>
                                            <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" EmptyMessage="[%Vyřídit do%]" CssClass="povinne-pole">
                                            </DateInput>
                                        </kspwc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <asp:RequiredFieldValidator ID="RFV_edit_vyriz_datum" runat="server" ControlToValidate="TRDP_edit_vyriz_datum"
                                            Display="Static" ErrorMessage="*"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </td>
                </tr>
            </table>
        </EditItemTemplate>
        <InsertItemTemplate>
            <table class="InnerTableForm">
                <tr>
                    <td>
                        <fieldset id="FS_read_zam">
                            <legend>[%Požadavek%]</legend>
                            <asp:Label runat="server" ID="L_err" ForeColor="Red" Text="[%Nexistuje Šablona popisu určená pro návrh nového pracovního místa, profese nebo pozice, o jejíž schválení by bylo možné žádat. Nejprve takovou šablonu vytvořte a až pak budete moci žádat o její schválení.%]" Visible="false"></asp:Label>
                            <table class="InnerTableFormFieldset">
                                <tr>
                                    <td>
                                        <asp:Label runat="server" ID="L_i_nazev" Text="[%Návrhované pracovní místo%]:"></asp:Label>
                                    </td>
                                    <td>
                                        <asp:ObjectDataSource runat="server" ID="ODS_navrhy_mist" TypeName="KSProgram.Pozadavky.Pozadavekpracmisto" SelectMethod="NavrhyMist"></asp:ObjectDataSource>
                                        <kspwc:TRadComboBox ID="TRCB_navrh_mist_i" runat="server" SelectedValue='<%# Bind("id_pracmist") %>' OnSelectedIndexChanged="TRCB_navrh_mist_i_SelectedIndexChanged" DropDownAutoWidth="Enabled" Width="210px" DataSourceID="ODS_navrhy_mist" DataTextField="cely_nazev" DataValueField="id" CssClass="povinne-pole" AutoPostBack="True">
                                        </kspwc:TRadComboBox>
                                    </td>
                                    <td>
                                        <asp:RequiredFieldValidator ID="RFV_navrh_mist_i" runat="server" ControlToValidate="TRCB_navrh_mist_i"
                                            Display="Dynamic" EnableClientScript="True" ErrorMessage="*"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:Label runat="server" ID="L_i_vyriz" Text="[%Vyřídit do%]:"></asp:Label>
                                    </td>
                                    <td>
                                        <kspwc:TRadDatePicker ID="TRDP_insert_vyriz_datum" runat="server" DropDownAutoWidth="Enabled"
                                            Width="160px" DbSelectedDate='<%# Bind("vyridit_do") %>'>
                                            <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" EmptyMessage="[%Vyřídit do%]" CssClass="povinne-pole">
                                            </DateInput>
                                        </kspwc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <asp:RequiredFieldValidator ID="RFV_insert_vyriz_datum" runat="server" ControlToValidate="TRDP_insert_vyriz_datum"
                                            Display="Dynamic" ErrorMessage="*"></asp:RequiredFieldValidator>
                                    </td>
                                </tr>
                            </table>
                        </fieldset>
                    </td>
                </tr>
            </table>
        </InsertItemTemplate>
        <FooterTemplate>
        </FooterTemplate>
    </asp:FormView>
    <fieldset id="FS_read_zam">
        <legend>[%Pracovní místo%]</legend>
        <uc1:PrMistoControl ID="PracMistoControl" runat="server" />
    </fieldset>
</asp:Panel>


