/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.tooltip.min",["kendo.core.min","kendo.popup.min","kendo.fx.min"],function(){var t={id:"tooltip",name:"Tooltip",category:"web",description:"The Tooltip widget displays a popup hint for a given html element.",depends:["core","popup"],features:[{id:"tooltip-fx",name:"Animation",description:"Support for animation",depends:["fx"]}]},a=window.kendo.jQuery,h=void 0,l=window.kendo,n=l.ui.Widget,d=l.ui.Popup,m=l.isFunction,w=a.isPlainObject,i=a.extend,s=a(document),_=l.isLocalUrl,g="_tb_active",r="aria-describedby",v="show",k="hide",b="error",p="contentLoad",y="requestStart",u="k-content-frame",O='<div role="tooltip" class="k-widget k-tooltip#if (!autoHide) {# k-tooltip-closable#}#">'+'<div class="k-tooltip-content"></div>'+'#if (!autoHide) {# <div class="k-tooltip-button"><a href="\\#" class="k-icon k-i-close" title="Close"></a></div> #}#'+'#if (callout){ #<div class="k-callout k-callout-#=dir#"></div>#}#'+"</div>",T=l.template("<iframe frameborder='0' class='"+u+"' src='#= content.url #'>"+"This page requires frames in order to show content"+"</iframe>"),c=".kendoTooltip",S={bottom:{origin:"bottom center",position:"top center"},top:{origin:"top center",position:"bottom center"},left:{origin:"center left",position:"center right",collision:"fit flip"},right:{origin:"center right",position:"center left",collision:"fit flip"},center:{position:"center center",origin:"center center"}},C={top:"bottom",bottom:"top",left:"right",right:"left",center:"center"},H={bottom:"n",top:"s",left:"e",right:"w",center:"n"},x={horizontal:{offset:"top",size:"outerHeight"},vertical:{offset:"left",size:"outerWidth"}},o=function(t){return t.target.data(l.ns+"title")};function D(t){while(t.length){if(e(t))break;t=t.parent()}}function e(t){var o=t.data(l.ns+"title");if(o){t.attr("title",o);t.removeData(l.ns+"title");return true}}function A(t){var o=t.attr("title");if(o){t.data(l.ns+"title",o);t.attr("title","");return true}}function P(t){while(t.length&&!t.is("body")){if(A(t))break;t=t.parent()}}var f=n.extend({init:function(t,o){var e=this,i;n.fn.init.call(e,t,o);i=e.options.position.match(/left|right/)?"horizontal":"vertical";e.dimensions=x[i];if(l.support.touch&&this._isShownOnMouseEnter())e.element.on(l.support.mousedown+c,e.options.filter,e._showOn.bind(e));e.element.on(e.options.showOn+c,e.options.filter,e._showOn.bind(e))},options:{name:"TooltipBase",filter:"",offset:0,showAfter:100,hideAfter:100,callout:true,position:"bottom",showOn:"mouseenter",animation:{open:{effects:"fade:in",duration:0},close:{duration:40,hide:true}}},destroy:function(){var t=this.popup;if(t){t.element.off(c);t.destroy()}clearTimeout(this.timeout);n.fn.destroy.call(this)},hide:function(){if(this.popup)this.popup.close()},show:function(t){t=t||this.element;this._saveTitle(t);this._show(t)},target:function(){if(this.popup)return this.popup.options.anchor;return null},_showOn:function(t){var o=this;var e=a(t.currentTarget);if(o._isShownOnClick()&&!o._isShownOnMouseEnter())o._show(e);else if(o._isShownOnFocus()){o._saveTitle(e);o._show(e)}else{clearTimeout(o.timeout);o.timeout=setTimeout(function(){o._show(e)},o.options.showAfter)}},_isShownOnFocus:function(){return this.options.showOn&&this.options.showOn.match(/focus/)},_isShownOnMouseEnter:function(){return this.options.showOn&&this.options.showOn.match(/mouseenter/)},_isShownOnClick:function(){return this.options.showOn&&this.options.showOn.match(/click/)},_positionCallout:function(){var t=this,o=t.options.position,e=t.dimensions,i=e.offset,n=t.popup,s=n.options.anchor,r=a(s).offset(),p=a(n.element).offset(),u=H[n.flipped?C[o]:o],l=r[i]-p[i]+a(s)[e.size]()/2;t._offset(o,t.options.offset);t.arrow.removeClass("k-callout-n k-callout-s k-callout-w k-callout-e").addClass("k-callout-"+u).css(i,l)},_offset:function(t,o,e){var i=this,n=t=="top"||t=="left",s=i.popup.flipped,r=n&&s||!n&&!s?1:-1,p=n?"margin-"+t:"margin-"+C[t],u=(e||l._outerWidth(i.arrow))/2+o;i.popup.wrapper.css(p,u*r+"px")},_addDescribedBy:function(){var t=this,o=t.popup.options.anchor,e=o[0].id||t.element[0].id||l.guid(),i=[];if(o.attr(r))i.push(o.attr(r));if(e){i.push(e+g);o.attr(r,i.join(" "));t.popup.element.attr("id",e+g)}},_removeDescribedBy:function(t){var o=this.popup.element.attr("id"),e=t.attr(r),i,n,s;if(!e)return;i=e.split(" ");if(i&&i.length>0)n=i.filter(function(t){return t!==o});if(n&&n.length>0){s=n.join(" ");t.attr(r,s)}else t.removeAttr(r)},_openPopup:function(){if(!this.popup)return;this.popup._hovered=true;this.popup.open()}}),j=(l.ui.plugin(f),f.extend({init:function(t,o){var e=this,i;f.fn.init.call(e,t,o);i=e.options.position.match(/left|right/)?"horizontal":"vertical";e.dimensions=x[i];e._documentKeyDownHandler=e._documentKeyDown.bind(e);if(this._isShownOnMouseEnter()||this._isShownOnClick())e.element.on("mouseenter"+c,e.options.filter,e._mouseenter.bind(e));if(this.options.autoHide&&this._isShownOnMouseEnter())e.element.on("mouseleave"+c,e.options.filter,e._mouseleave.bind(e));if(this.options.autoHide&&this._isShownOnFocus())e.element.on("blur"+c,e.options.filter,e._blur.bind(e));if(l.support.touch)e.element.on(l.support.mousedown+c,e.options.filter,e._mouseenter.bind(e))},options:{name:"Tooltip",filter:"",content:o,showAfter:100,callout:true,offset:0,position:"bottom",showOn:"mouseenter",autoHide:true,width:null,height:null,animation:{open:{effects:"fade:in",duration:0},close:{duration:40,hide:true}}},events:[v,k,p,b,y],_mouseenter:function(t){P(a(t.currentTarget))},_saveTitle:function(t){P(t)},_appendContent:function(t){var o=this,e=o.options.content,i=o.content,n=o.options.iframe,s;if(w(e)&&e.url){if(!("iframe"in o.options))n=!_(e.url);o.trigger(y,{options:e,target:t});if(!n){i.empty();l.ui.progress(i,true);o._ajaxRequest(e)}else{i.hide();s=i.find("."+u)[0];if(s)s.src=e.url||s.src;else i.html(T({content:e}));i.find("."+u).off("load"+c).on("load"+c,function(){o.trigger(p);i.show()})}}else if(e&&m(e)){e=e({sender:this,target:t});i.html(e||"")}else i.html(e);o.angular("compile",function(){return{elements:i}})},_ajaxRequest:function(t){var e=this,o=function(t){l.ui.progress(e.content,false);e.content.html(t);if(l._outerHeight(e.popup.element)>l._outerHeight(e.popup.wrapper)){e.popup.wrapper.css("height",l._outerHeight(e.popup.element)+"px");e.popup.position();e._positionCallout()}e.trigger(p)};jQuery.ajax(i({type:"GET",dataType:"html",cache:false,error:function(t,o){l.ui.progress(e.content,false);e.trigger(b,{status:o,xhr:t})},success:o.bind(e)},t))},_documentKeyDown:function(t){if(t.keyCode===l.keys.ESC)this.hide()},refresh:function(){var t=this,o=t.popup;if(o&&o.options.anchor)t._appendContent(o.options.anchor)},_show:function(t){var o=this,e=o.target();if(!o.popup)o._initPopup();if(e&&e[0]!=t[0]){o.popup.close();o.popup.element.kendoStop(true,true)}if(!e||e[0]!=t[0]){o._appendContent(t);o.popup.options.anchor=t}o.popup.one("deactivate",function(){D(t);o._removeDescribedBy(t);this.element.removeAttr("id").attr("aria-hidden",true);s.off("keydown"+c,o._documentKeyDownHandler)});o._openPopup()},_initPopup:function(){var t=this,o=t.options,e=a(l.template(O)({callout:o.callout&&o.position!=="center",dir:H[o.position],autoHide:o.autoHide}));t.popup=new d(e,i({autosize:true,activate:function(){t._addDescribedBy();if(o.callout)t._positionCallout();else t._offset(t.options.position,t.options.offset);this.element.removeAttr("aria-hidden");s.on("keydown"+c,t._documentKeyDownHandler);t.trigger(v);t.popup._hovered=h},close:function(){t.trigger(k)},copyAnchorStyles:false,animation:o.animation},S[o.position]));e.css({width:o.width,height:o.height});t.content=e.find(".k-tooltip-content");t.arrow=e.find(".k-callout");if(o.autoHide&&this._isShownOnMouseEnter())e.on("mouseleave"+c,t._mouseleave.bind(t));else e.on("click"+c,".k-tooltip-button",t._closeButtonClick.bind(t))},_closeButtonClick:function(t){t.preventDefault();this.hide()},_mouseleave:function(t){var o=this;clearTimeout(o.timeout);o.timeout=setTimeout(function(){o._closePopup(t.currentTarget)},o.options.hideAfter)},_blur:function(t){this._closePopup(t.currentTarget)},_closePopup:function(t){if(this.popup&&!this.popup._hovered)this.popup.close();else D(a(t))},destroy:function(){this.element.off(c);s.off("keydown"+c,this._documentKeyDownHandler);f.fn.destroy.call(this)}}));return l.ui.plugin(j),window.kendo})}("function"==typeof define&&define.amd?define:function(t,o,e){(e||o)()});
//# sourceMappingURL=kendo.tooltip.min.js.map
