/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.captcha.min",["kendo.core.min","kendo.slider.min","kendo.textbox.min","kendo.skeletoncontainer.min"],function(){var e={id:"captcha",name:"Captcha",category:"web",description:"The Captcha widget displays captcha validation image and an input so that user case be validated against captcha value.",depends:["core","slider","textbox","skeletoncontainer"]},l=window.kendo.jQuery,t=void 0,n=window.kendo,o=n.ui.Widget,d=l.extend,m=l.ajax,f=n.isFunction,h="string",a,i="."+"kendoCaptcha",r="click",v="blur",s="change",u="requestStart",c="requestEnd",g="error",_={wrapper:"k-widget k-captcha",textbox:"k-textbox",button:"k-button k-button-md k-rounded-md k-button-solid k-button-solid-base",buttonIcon:"k-button-icon",iconButton:"k-icon-button",resetIcon:"k-icon k-i-reload",audioIcon:"k-icon k-i-volume-up",disabled:"k-disabled",inputWrapper:"k-captcha-input k-vstack",imageWrapper:"k-captcha-image-wrap k-hstack",captchaImage:"k-captcha-image",buttonsWrapper:"k-captcha-image-controls k-vstack",volumeControlWrapper:"k-captcha-volume-control k-vstack k-pos-absolute",hidden:"k-hidden",success:"k-captcha-validation-message k-text-success",loading:"k-captcha-loading"},p=o.extend({init:function(e,t){var a=this;o.fn.init.call(a,e,t);a._captchaField=a.options.dataCaptchaField;a._valueField=a.element.attr("name")||"captcha";a._captchaIdField=a.options.dataCaptchaIdField;a._wrapper();a._idInput();a._captchaImage();if(a.options.audioButton||a.options.resetButton)a._buttons();if(!a.options.captcha||!a.options.captchaId)a._resetHandler();if(a.options.validateOnBlur)a.element.on(v+i,function(){a._validationHandler()});a.element.on(s+i,function(e){delete a._isValid;a.trigger(s,{value:a.element.val(),originalEvent:e})});n.notify(a)},events:[s,u,c,g],options:{name:"Captcha",dataCaptchaField:"captcha",dataCaptchaIdField:"captchaId",captchaId:"",captcha:null,handler:null,audioHandler:null,validationHandler:null,validateOnBlur:false,resetButton:true,audioButton:true,volumeControl:true,messages:{reset:"Reset captcha",audio:"Speak captcha",imageAlt:"Type the Captcha code from the image",success:"Verification successful"}},destroy:function(){var e=this;e.textbox.destroy();if(e.resetButton)e.resetButton.off(i);if(e.audioButton)e.audioButton.off(i);e.element.off(i);e._audioEnded();o.fn.destroy.call(e)},_wrapper:function(){var e=this,t=p.styles,a="<div class='"+t.wrapper+"'><div class='"+t.inputWrapper+"'></div></div>",n="<div class='"+t.imageWrapper+"'></div>",o=e.element[0].style.cssText;e.element.css("width","auto");e.element.css("height","auto");e.textbox=e.element.kendoTextBox().data("kendoTextBox");e._inputWrapper=e.textbox.wrapper;e.wrapper=e._inputWrapper.wrap(a).parent().parent();e.wrapper[0].style.cssText=o;e.imageWrapper=l(n);e.wrapper.prepend(e.imageWrapper)},_captchaImage:function(){var e=this,t=e.options,a=t.messages,n=p.styles;e.captchaImage=l('<div class="'+n.captchaImage+'">'+'<img alt="'+a.imageAlt+'" src= "'+(t.captcha||"")+'"/>'+"</div>").find("img");e.imageWrapper.append(e.captchaImage.parent());e._tabindex(e.captchaImage)},_idInput:function(){var e=this,t=e.options,a=e._captchaIdField;e.idInput=l('<input type="hidden" name="'+a+'" value="'+t.captchaId+'" data-'+n.ns+'stop="true" />');e._inputWrapper.after(e.idInput)},_buttons:function(){var e=this,t=p.styles;e.buttonsWrapper=l('<div class="'+t.buttonsWrapper+'"></div>');e.imageWrapper.append(e.buttonsWrapper);if(e.options.audioButton)e._audioButton();if(e.options.resetButton)e._resetButton()},_resetButton:function(){var e=this,t=e.options.messages,a=p.styles;e.resetButton=l('<button type="button" title="'+t.reset+'" class="'+a.button+" "+a.iconButton+'">'+'<span class="'+a.buttonIcon+" "+a.resetIcon+'"></span>'+"</button>");e.buttonsWrapper.append(e.resetButton);e.resetButton.on(r+i,e._resetHandler.bind(e,true))},_audioButton:function(){var e=this,t=e.options.messages,a=p.styles;e.audioButton=l('<button type="button" title="'+t.audio+'" class="'+a.button+" "+a.iconButton+'">'+'<span class="'+a.buttonIcon+" "+a.audioIcon+'"></span>'+"</button>");e.buttonsWrapper.append(e.audioButton);e.audioButton.on(r+i,e._audioHandler.bind(e))},_resetHandler:function(e){var t=this,a=t.options.handler,n=l.Deferred(),o=t._resetCaptcha.bind(t,n);delete t._isValid;t._toggleSuccessMessage(false);t._audioEnded();t._progress(true);if(!a){window.console.error("Captcha's handler option is not defined!");n.reject({msg:"Captcha's handler option is not defined!",error:"handler_not_defined"});t._progress(false);return n.promise()}t._callHandler("reset",a,o).done(function(){if(e)t.resetButton.trigger("focus")}).fail(function(e){t._progress(false);n.reject(e)});return n.promise()},_audioHandler:function(){var e=this,t=e.options.audioHandler,a=l.Deferred(),n=e._playAudio.bind(e,a),o={};o[e._captchaIdField]=e.idInput.val();if(!t){window.console.error("Captcha's audioHandler option is not defined!");a.reject({msg:"Captcha's audioHandler option is not defined!",error:"handler_not_defined"});return a.promise()}e._callHandler("audio",t,n,o).fail(a.reject);return a.promise()},_validationHandler:function(){var e=this,t=e.options.validationHandler,a=l.Deferred(),n=e._validate.bind(e,a),o={};delete e._isValid;o[e._captchaIdField]=e.idInput.val();o[e._valueField]=e.element.val();if(!t){window.console.error("Captcha's validationHandler option is not defined!");a.reject({msg:"Captcha's validationHandler option is not defined!",error:"handler_not_defined"});return a.promise()}e._callHandler("validation",t,n,o).fail(a.reject);return a.promise()},_callHandler:function(e,t,a,n){var o=this,i=o._error.bind(o,e),r=o._requestEnd.bind(o,e),s;if(f(t)){t({success:a,data:n});return l.Deferred().promise()}else{s=typeof t===h?{url:t,cache:false}:d({},t);s.success=a;s.data=d({},n,s.data);if(!o.trigger(u,{type:e,data:n}))return m(s).done(r).fail(i)}},_requestEnd:function(e,t){var a=this;a.trigger(c,{type:e,data:t})},_error:function(e,t,a,n){var o=this;o.trigger(g,{type:e,jqXHR:t,textStatus:a,errorThrown:n})},_resetCaptcha:function(e,t){var a=this,n=t[a._captchaIdField],o=t[a._captchaField];a.idInput.val(n);a.captchaImage.attr("src",o||"");a.captchaImage.one("load",function(){a._progress(false)});e.resolve(t)},_playAudio:function(e,t){var a=this;if(a._canPlayWav()){if(a.audioElement)return;a.audioElement=new Audio(t);a.audioElement.volume=a._audioVolume||a.audioElement.volume;if(a.options.volumeControl)l(a.audioElement).on("loadeddata"+i,function(){a._showVolumeControl(a.audioElement.volume)});l(a.audioElement).on("ended"+i+" error"+i,a._audioEnded.bind(a,e));a.audioElement.play()}else if(a._canPlayWithPlugin()){if(a.audioElement){a.audioElement.play();return}a.audioElement=a._createEmbedElement(t);a.wrapper.append(a.audioElement)}},_createEmbedElement:function(e){var t=this,a=document.createElement("embed");a.setAttribute("src",e);a.setAttribute("autostart","true");a.setAttribute("pluginspage",t._audioPlugin);a.setAttribute("enablejavascript","true");a.setAttribute("type","audio/wav");a.setAttribute("tabIndex","-1");a.style.width="0px";a.style.height="0px";a.style.position="absolute";a.style.top=0;a.style.left=0;return a},_showVolumeControl:function(e){var t=this,a=p.styles,n=l('<div class="'+a.volumeControlWrapper+'"></div>');if(t.volumeControl)return;t.volumeControlElm=l("<input />");t.volumeControlWrapper=n.append(t.volumeControlElm);t.imageWrapper.append(n);t.volumeControlWrapper.css(t._isRtl()?"right":"left",t.wrapper.width());t.volumeControl=t.volumeControlElm.kendoSlider({min:0,max:1,smallStep:.1,largeStep:.5,orientation:"vertical",showButtons:false,tickPlacement:"none",value:e,tooltip:{enabled:false},change:function(e){t._audioVolume=t.audioElement.volume=e.value}}).data("kendoSlider")},_audioEnded:function(e){var t=this;if(l(document.activeElement).is("a.k-draghandle"))t.audioButton.trigger("focus");if(t.volumeControl){t.volumeControl.destroy();t.volumeControl.wrapper.remove();delete t.volumeControl;t.volumeControlElm.remove();t.volumeControlWrapper.remove();delete t.volumeControlElm;delete t.volumeControlWrapper}if(t.audioElement)t.audioElement.pause();l(t.audioElement).off(i);l(t.audioElement).remove();delete t.audioElement;if(e&&e.resolve)e.resolve()},_canPlayWav:function(){var e=this,t;if(e._canPlayAudio)return e._canPlayAudio;t=new Audio;e._canPlayAudio=t.canPlayType("audio/wav").replace(/no/gi,"")!=="";return e._canPlayAudio},_canPlayWithPlugin:function(){var e=this;if(e._audioPlugin)return e._audioPlugin;e._audioPlugin=e._getPlugin();return e._audioPlugin},_getPlugin:function(){var e=function(e){var t=navigator.plugins;for(var a=0;a<t.length;a++){var n=t[a].name;if(n.indexOf(e)!==-1)return true}return false};var t=function(e){try{var t=new window.ActiveXObject(e);return!!t}catch(e){return false}};if(t("QuickTime.QuickTime")||t("QuickTimeCheckObject.QuickTimeCheck")||e("QuickTime Plug-in"))return"http://www.apple.com/quicktime/download/";if(t("WMPlayer.OCX")||e("Windows Media"))return"http://www.microsoft.com/Windows/MediaPlayer"},_validate:function(e,t){var a=this;a._isValid=t;a._toggleSuccessMessage(a._isValid);e.resolve(t)},_toggleSuccessMessage:function(e){var t=this,a=(t.element.attr("id")||t.element.attr("name"))+"-success",n=t.options.messages;l(t.successMessage).remove();t.element.removeAttr("aria-describedby");if(e){t.successMessage=l('<span id="'+a+'" class="'+p.styles.success+'">'+n.success+"</span>");t._inputWrapper.after(t.successMessage);t.element.attr("aria-describedby",a)}},_toggleButtons:function(e){var t=this;if(t.resetButton)t.resetButton.prop("disabled",!e);if(t.audioButton)t.audioButton.prop("disabled",!e)},_progress:function(e){var t=this;t.wrapper.toggleClass(p.styles.loading,e);t._inputWrapper.toggleClass(p.styles.disabled,e);t._toggleButtons(!e);t._toggleSkeleton(e)},_toggleSkeleton:function(e){var t=this;if(t.skeleton)t.skeleton.remove();if(e){t.skeleton=l("<span class='k-skeleton k-skeleton-rect k-skeleton-pulse' style=\"width: 100%; height: 100%;\"></span>");t.captchaImage.before(t.skeleton)}},_isRtl:function(){return n.support.isRtl(this.wrapper)},value:function(){return this.element.val()},getCaptchaId:function(){return this.idInput.val()},toJSON:function(){var e=this,t={};t[e._valueField]=e.value();t[e._captchaIdField]=e.getCaptchaId();return t},validate:function(){return this._validationHandler()},isValid:function(){return this._isValid},enable:function(e){var t=this;e=e!==false;t._toggleButtons(e);t.textbox.enable(e);if(e){t.captchaImage.removeAttr("tabIndex");t._tabindex(t.captchaImage)}else t.captchaImage.attr("tabIndex","-1");t.captchaImage.toggleClass(p.styles.disabled,!e);t.wrapper.toggleClass(p.styles.disabled,!e)},readonly:function(e){var t=this;e=e!==false;if(t.resetButton)t.resetButton.prop("disabled",e);t.textbox.readonly(e)},speak:function(){return this._audioHandler()},reset:function(){return this._resetHandler()}});return n.ui.plugin(p),d(true,p,{styles:_}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,a){(a||t)()});
//# sourceMappingURL=kendo.captcha.min.js.map
