﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="UjeteKm.aspx.cs" Inherits="KSPortal.Zamestnanec.UjeteKm" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        span table {
            color: inherit !important;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">

    <telerik:RadScriptBlock ID="RadCodeBlock1" runat="server">
        <script type="text/javascript" id="telerikClientEvents1">
            //<![CDATA[

            function tb_tach_km_Changing(sender, args) {
                //batch editace způsobuje, že event je volán i při překliknutí do řádku
                //a něco jiného zase, že event běží 2x, jednou nastaví číslo bez desetin a podruhé s desetinami
                //alert(args.get_oldValue());
                //var oldV = args.get_oldValue();
                //if (isNaN(oldV)) oldV = 0;
                var tach_km_kon = args.get_newValue();
                if (isNaN(tach_km_kon)) tach_km_kon = 0;

                //alert(sender.get_element().id);
                //return;
                var tach_km_poc = $find(sender.get_element().id.replace("tb_tach_km", "tb_tach_km_poc")).get_value();
                //alert("tach_km_poc=" + tach_km_poc);
                var sluz_km = $find(sender.get_element().id.replace("tb_tach_km", "tb_sluz_km")).get_value();
                //alert("sluz_km=" + sluz_km);
                var sc_km = $find(sender.get_element().id.replace("tb_tach_km", "tb_sc_km")).get_value();
                //alert("sc_km=" + sc_km);

                var souk = tach_km_kon - tach_km_poc - sc_km - sluz_km;
                $find(sender.get_element().id.replace("tb_tach_km", "tb_souk_km")).set_value(souk);

                args.set_cancel(false);
            }

            //]]>
        </script>
    </telerik:RadScriptBlock>

    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRADObdobi">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadGrid1" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

    <wc:TLabel ID="TLabel3" runat="server" Text="[%Ujeté km%]" CssClass="nadpis1 tiskHide"></wc:TLabel>

    <table class="pozadiText">
        <tr>
            <td>
                <wc:TLabel ID="TLabel4" runat="server" Text="[%v období%]" CssClass="tiskHide"></wc:TLabel>
            </td>
            <td>
                <kspwc:TRadObdobiInterval ID="TRADObdobi" AutoPostBack="true" Vertical="false" runat="server" TextOd="[%od%]" TextDo="[%do%]"></kspwc:TRadObdobiInterval>
            </td>
        </tr>
    </table>

    <asp:ObjectDataSource ID="ODS_SlcUjeteKm" runat="server"
        OldValuesParameterFormatString="{0}"
        SelectMethod="UjeteKmVozidelPracovnika"
        UpdateMethod="UjeteKmVozidlaPracovnikaUpdate"
        TypeName="KSProgram.Sluzebky.SlcUjetekm">
        <SelectParameters>
            <%--<asp:SessionParameter Name="os_cislo" Type="Decimal" SessionField="GlobOsCislo" DefaultValue="0" />--%>
            <asp:Parameter Name="os_cislo" Type="Decimal" DefaultValue="0" />
            <%--//PR 13.10.2021 HID=58245 --%>
            <asp:ControlParameter Name="obd_od" Type="DateTime" ControlID="TRADObdobi" PropertyName="SelectedDateOd" />
            <asp:ControlParameter Name="obd_do" Type="DateTime" ControlID="TRADObdobi" PropertyName="SelectedDateDo" />
        </SelectParameters>
        <UpdateParameters>
            <asp:Parameter Name="spz" Type="String" />
            <asp:Parameter Name="os_cislo" Type="Decimal" />
            <asp:Parameter Name="datum" Type="DateTime" />
            <asp:Parameter Name="souk_km" Type="Decimal" />
            <asp:Parameter Name="sluz_km" Type="Decimal" />
        </UpdateParameters>
    </asp:ObjectDataSource>

    <wc:TRadGrid ID="RadGrid1" GridLines="Both" runat="server" AllowAutomaticDeletes="False"
        AllowAutomaticInserts="False" AllowAutomaticUpdates="True" AllowPaging="False" AllowSorting="true"
        AutoGenerateColumns="False" DataSourceID="ODS_SlcUjeteKm" Width="1100px" OnInit="RadGrid1_Init" OnItemCommand="RadGrid1_ItemCommand">

        <MasterTableView CommandItemDisplay="TopAndBottom" DataKeyNames="spz,os_cislo,datum"
            DataSourceID="ODS_SlcUjeteKm" HorizontalAlign="NotSet" EditMode="InPlace" AutoGenerateColumns="False">
            <%--<BatchEditingSettings EditType="Row" />--%>
            <ColumnGroups>
                <telerik:GridColumnGroup HeaderText="[%Kilometry služebně%]" Name="km_sluz_colgrp" HeaderStyle-HorizontalAlign="Center"></telerik:GridColumnGroup>
            </ColumnGroups>
            <Columns>
                <telerik:GridEditCommandColumn ButtonType="ImageButton"
                    UniqueName="EditCommandColumn" ItemStyle-Width="15">
                    <ItemStyle Width="15px"></ItemStyle>
                </telerik:GridEditCommandColumn>
                <telerik:GridBoundColumn DataField="os_cislo" UniqueName="os_cislo" DataType="System.Decimal" HeaderStyle-Width="0px" HeaderText="os_cislo" Visible="false">
                </telerik:GridBoundColumn>
                <telerik:GridDateTimeColumn DataField="datum" UniqueName="datum" DataType="System.DateTime" DataFormatString="{0:MM'/'yyyy}" HeaderStyle-Width="50px" HeaderText="[%Období%]" ReadOnly="True">
                </telerik:GridDateTimeColumn>
                <telerik:GridBoundColumn DataField="spz" UniqueName="spz" HeaderStyle-Width="60px" HeaderText="[%SPZ%]" ReadOnly="True">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="nazev" UniqueName="nazev" HeaderStyle-Width="300px" HeaderText="[%Název%]" ReadOnly="True">
                </telerik:GridBoundColumn>
                <%--<telerik:GridNumericColumn DataField="tach_km_poc" UniqueName="tach_km_poc" DataType="System.Decimal" DecimalDigits="2" DataFormatString="{0:N2}" HeaderStyle-Width="160px" HeaderText="[%Počáteční stav tachometru%]" ReadOnly="True">
                    </telerik:GridNumericColumn>--%>
                <telerik:GridTemplateColumn DataField="tach_km_poc" UniqueName="tach_km_poc" DataType="System.Decimal" HeaderStyle-Width="120px" HeaderText="[%Počáteční stav tachometru%]">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="lbl_tach_km_poc" Text='<%# Eval("tach_km_poc", "{0:N2}") %>' BorderStyle="Solid" BorderColor="#CCCCCC" BorderWidth="1px" Width="98px" Height="20px"></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox Width="100px" runat="server" ID="tb_tach_km_poc" DbValue='<%# Eval("tach_km_poc") %>' ReadOnly="True" DataType="System.Decimal" NumberFormat-DecimalDigits="2" IncrementSettings-InterceptArrowKeys="False" IncrementSettings-InterceptMouseWheel="False" BackColor="#CCCCCC">
                        </telerik:RadNumericTextBox>
                    </EditItemTemplate>
                </telerik:GridTemplateColumn>

                <telerik:GridTemplateColumn DataField="souk_km" UniqueName="souk_km" DataType="System.Decimal" HeaderStyle-Width="120px" HeaderText="[%Kilometry soukromě%]">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="lbl_souk_km" Text='<%# Eval("souk_km", "{0:N2}") %>' BorderStyle="Solid" BorderColor="#CCCCCC" BorderWidth="1px" Width="98px" Height="20px"></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox Width="100px" runat="server" ID="tb_souk_km" DbValue='<%# Bind("souk_km") %>' DataType="System.Decimal" NumberFormat-DecimalDigits="2" IncrementSettings-InterceptArrowKeys="False" IncrementSettings-InterceptMouseWheel="False">
                        </telerik:RadNumericTextBox>
                    </EditItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn DataField="sluz_km" UniqueName="sluz_km" DataType="System.Decimal" HeaderStyle-Width="120px"
                    HeaderText="[%nevyúčtované ve SC%]" ColumnGroupName="km_sluz_colgrp">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="lbl_sluz_km" Text='<%# Eval("sluz_km", "{0:N2}") %>' BorderStyle="Solid" BorderColor="#CCCCCC" BorderWidth="1px" Width="98px" Height="20px"></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox Width="100px" runat="server" ID="tb_sluz_km" DbValue='<%# Bind("sluz_km") %>' DataType="System.Decimal" NumberFormat-DecimalDigits="2" IncrementSettings-InterceptArrowKeys="False" IncrementSettings-InterceptMouseWheel="False">
                        </telerik:RadNumericTextBox>
                        <%--ReadOnly='<%# KSProgram.Zakaznik.IsCurrent("VARROC")%>'--%>
                    </EditItemTemplate>
                </telerik:GridTemplateColumn>

                <%--<telerik:GridNumericColumn DataField="sc_km" UniqueName="sc_km" DataType="System.Decimal" DecimalDigits="2" DataFormatString="{0:N2}" HeaderStyle-Width="120px" 
                        HeaderText="[%vyúčtované ve SC%]" ColumnGroupName="km_sluz_colgrp" ReadOnly="True">
                    </telerik:GridNumericColumn>--%>
                <telerik:GridTemplateColumn DataField="sc_km" UniqueName="sc_km" DataType="System.Decimal" HeaderStyle-Width="120px" HeaderText="[%vyúčtované ve SC%]" ColumnGroupName="km_sluz_colgrp">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="lbl_sc_km" Text='<%# Eval("sc_km", "{0:N2}") %>' BorderStyle="Solid" BorderColor="#CCCCCC" BorderWidth="1px" Width="98px" Height="20px"></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox Width="100px" runat="server" ID="tb_sc_km" DbValue='<%# Eval("sc_km") %>' ReadOnly="True" DataType="System.Decimal" NumberFormat-DecimalDigits="2" IncrementSettings-InterceptArrowKeys="False" IncrementSettings-InterceptMouseWheel="False" BackColor="#CCCCCC">
                        </telerik:RadNumericTextBox>
                    </EditItemTemplate>
                </telerik:GridTemplateColumn>


                <%--<telerik:GridNumericColumn DataField="tach_km" UniqueName="tach_km" DataType="System.Decimal" DecimalDigits="2" DataFormatString="{0:N2}" HeaderStyle-Width="160px" HeaderText="[%Konečný stav tachometru%]" ReadOnly="True">
                    </telerik:GridNumericColumn>--%>

                <telerik:GridTemplateColumn DataField="tach_km" UniqueName="tach_km" DataType="System.Decimal" HeaderStyle-Width="160px" HeaderText="[%Konečný stav tachometru%]" ReadOnly="False">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="lbl_tach_km" Text='<%# Eval("tach_km", "{0:N2}") %>' BorderStyle="Solid" BorderColor="#CCCCCC" BorderWidth="1px" Width="98px" Height="20px"></asp:Label>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox Width="100px" runat="server" ID="tb_tach_km" DbValue='<%# Eval("tach_km") %>' DataType="System.Decimal" NumberFormat-DecimalDigits="2" IncrementSettings-InterceptArrowKeys="False" IncrementSettings-InterceptMouseWheel="False">
                            <ClientEvents OnValueChanging="tb_tach_km_Changing" />
                        </telerik:RadNumericTextBox>
                    </EditItemTemplate>
                </telerik:GridTemplateColumn>

            </Columns>
            <CommandItemSettings ShowAddNewRecordButton="False" />
            <NoRecordsTemplate>
                <div class="NoRecordsTemplate">
                    <i class="fi fi-car-garage"></i>
                    <label>[%Nemáte přiděleno žádné firemní vozidlo ve zvoleném období%]</label>
                </div>
            </NoRecordsTemplate>
            <EditFormSettings>
                <EditColumn ButtonType="ImageButton" />
            </EditFormSettings>
        </MasterTableView>
        <ClientSettings AllowKeyboardNavigation="true"></ClientSettings>
    </wc:TRadGrid>
</asp:Content>
