﻿    <%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Zamestnanec_SkolAkceHodn"
    CodeBehind="SkolAkceHodn.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="cc1" %>
<asp:Content ID="ContentH" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <script type="text/javascript">

        function OnKeyPressHodnoceni(sender, eventArgs) {
            var char = eventArgs.get_keyCode();
            //backspace      sipka        sipka         carka      tabulator           cisla
            if (char == 8 || char == 37 || char == 39 || char == 44 || (char >= 48 && char <= 57)) {
                eventArgs.set_cancel(false);
            }
            else {
                eventArgs.set_cancel(true);
            }
        }
    </script>
    <telerik:RadAjaxManagerProxy runat="server" ID="RAMP_manager">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="ajax_panel">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="ajax_panel" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <asp:Label ID="nadpis" runat="server" CssClass="nadpis1" Text="[%Hodnocení školících akcí%]"></asp:Label>
    <asp:Panel runat="server" ID="ajax_panel">
        <table>
            <tr>
                <td valign="top">
                    <telerik:RadButton ID="RadButton1" runat="server" Text="[%Zobrazit jen nevyhodnocené školící akce%]"
                        ButtonType="LinkButton" ToggleType="CheckBox">
                        <ToggleStates>
                            <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox" />
                            <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square" />
                        </ToggleStates>
                    </telerik:RadButton>
                    <asp:ObjectDataSource ID="ODS_VzdelAkce" runat="server" SelectMethod="SeznamAkciKHodnoceni"
                        TypeName="KSProgram.Personal.VzdelavaciAkce" OldValuesParameterFormatString="original_{0}"
                        UpdateMethod="UpdateCelkoveHodnoceni">
                        <SelectParameters>
                            <asp:ControlParameter ControlID="RadButton1" Name="jenNevyhodnocene" PropertyName="Checked"
                                Type="Boolean" />
                        </SelectParameters>
                        <UpdateParameters>
                            <asp:Parameter Name="original_p_cislo" Type="Int32" />
                            <asp:Parameter Name="stupen" Type="Decimal" />
                        </UpdateParameters>
                    </asp:ObjectDataSource>
                    <asp:ObjectDataSource ID="ODS_Stupnice" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="StupniceHodnoceni" TypeName="KSProgram.Personal.VzdelavaciAkce"></asp:ObjectDataSource>
                    <cc1:TGridView ID="GV_Akce" runat="server" AllowPaging="True" DataKeyNames="p_cislo" CssClass="ksprvek"
                        DataSourceID="ODS_VzdelAkce" ShowTitleRow="False" SortAscImageUrl="" SortDescImageUrl=""
                        TitleText="[%Školící akce%]" OnRowCommand="GV_Akce_RowCommand">
                        <Columns>
                            <asp:CommandField ButtonType="Link" />
                            <asp:BoundField DataField="p_cislo" HeaderText="[%Akce%]" SortExpression="p_cislo"
                                Visible="False" ReadOnly="True" />
                            <asp:BoundField DataField="cislo_akce" HeaderText="[%Číslo%]" SortExpression="cislo_akce"
                                ReadOnly="True" />
                            <asp:BoundField DataField="nazev" HeaderText="[%Název%]" SortExpression="nazev" ReadOnly="True" />
                            <asp:BoundField DataField="dat_od" HeaderText="[%Datum od%]" SortExpression="dat_od"
                                ReadOnly="True" DataFormatString="{0:d}" HtmlEncode="False" />
                            <asp:BoundField DataField="dat_do" HeaderText="[%Datum do%]" SortExpression="dat_do"
                                ReadOnly="True" DataFormatString="{0:d}" HtmlEncode="False" />
                            <asp:BoundField DataField="lektor" HeaderText="[%Lektor%]" SortExpression="lektor"
                                ReadOnly="True" />
                            <asp:BoundField DataField="stupen" HeaderText="[%Hodnocení%]" SortExpression="stupen"
                                ReadOnly="True" Visible="False" />
                            <asp:BoundField DataField="stupen" HeaderText="[%Hodnocení%]" SortExpression="stupen"
                                ApplyFormatInEditMode="True" Visible="False" />
                            <asp:TemplateField HeaderText="[%Hodnocení%]" SortExpression="stupen" Visible="False">
                                <EditItemTemplate>
                                    <cc1:TDropDown ID="TDD_HodnoceniCelkove" runat="server" SelectedValue='<%# Bind("stupen") %>'
                                        DataSourceID="ODS_Stupnice" DataTextField="Value" DataValueField="Key">
                                    </cc1:TDropDown>
                                </EditItemTemplate>
                                <ItemTemplate>
                                    <asp:Label ID="Label8" runat="server" Text='<%# Eval("stupen") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </cc1:TGridView>
                </td>
                <td valign="top">
                    <asp:Panel ID="PanelHodnoceniOtazky" runat="server" CssClass="margin_left_10">
                        <asp:ObjectDataSource ID="ODS_Hodnoceni" runat="server" OldValuesParameterFormatString="original_{0}"
                            SelectMethod="SelectPodrobneHodnoceniAkce" TypeName="KSProgram.Personal.VzdelavaciAkce">
                            <SelectParameters>
                                <asp:ControlParameter ControlID="GV_Akce" Name="p_cislo" PropertyName="SelectedValue"
                                    Type="Int32" />
                            </SelectParameters>
                        </asp:ObjectDataSource>
                        <asp:Repeater ID="Repeater1" runat="server" DataSourceID="ODS_Hodnoceni" Visible="False"
                            OnPreRender="Repeater1_PreRender">
                            <HeaderTemplate>
                                <asp:Label ID="Label3" runat="server" Text="[%Podrobné hodnocení%]" SkinID="caption" CssClass="pozadiText"></asp:Label>
                                <br />
                                <br />
                            </HeaderTemplate>
                            <ItemTemplate>
                                <asp:HiddenField ID="HF_Id" runat="server" Value='<%# Eval("cislo_otazky") %>' />
                                <asp:Table ID="TablePodrobneHodnoceni" runat="server" CellPadding="2" CssClass="pozadiText">
                                    <asp:TableRow>
                                        <asp:TableCell>
                                            <asp:Label ID="Label4" runat="server" Text="[%Otázka%]:"></asp:Label>
                                        </asp:TableCell>
                                        <asp:TableCell>
                                            <asp:Label ID="Label5" runat="server" Text='<%# Eval("otazka") %>' Font-Bold="true"></asp:Label>
                                        </asp:TableCell>
                                    </asp:TableRow>
                                    <asp:TableRow>
                                        <asp:TableCell>
                                            <asp:Label ID="Label6" runat="server" Text="[%Hodnocení%]:" Visible='<%# Eval("hodnoceni_visible") %>'></asp:Label>
                                        </asp:TableCell>
                                        <asp:TableCell>
                                            <%--<asp:TextBox ID="TB_Hodnoceni1" runat="server" Text='<%# Eval("hodnoceni","{0:N2}") %>' Visible='<%# Eval("hodnoceni_visible") %>' ></asp:TextBox>--%>
                                            <%--KM 26.5.2016 omezení mozných vstupnich hodnot pro rucni hodnoceni--%>
                                            <telerik:RadNumericTextBox ID="RNTB_Hodnoceni1" runat="server" MaxValue="99.99" MinValue="-99.99" DataType="System.Decimal" DbValue='<%# Eval("hodnoceni") %>' Visible='<%# Eval("hodnoceni_visible") %>'>
                                            </telerik:RadNumericTextBox>
                                        </asp:TableCell>
                                    </asp:TableRow>
                                    <asp:TableRow>
                                        <asp:TableCell>
                                            <asp:Label ID="Label1" runat="server" Text="[%Hodnocení%]:" Visible='<%# Eval("hodnoceni_visible") %>'></asp:Label>
                                        </asp:TableCell>
                                        <asp:TableCell>
                                            <asp:ObjectDataSource ID="ODS_StupnicePodrobne" runat="server" OldValuesParameterFormatString="original_{0}"
                                                SelectMethod="StupniceHodnoceni" TypeName="KSProgram.Personal.VzdelavaciAkce"></asp:ObjectDataSource>
                                            <%--<cc1:TDropDown ID="TDD_HodnoceniPodrobne" runat="server" SelectedValue='<%# Eval("hodnoceni") %>' DataSourceID="ODS_StupnicePodrobne" 
                                            DataTextField="Value" DataValueField="Key" Visible='<%# Eval("hodnoceni_visible") %>'>
                                        </cc1:TDropDown>--%>
                                            <%-- vlozeni funkce pro convertovani decimal do int --%>
                                            <cc1:TDropDown ID="TDD_HodnoceniPodrobne" runat="server" SelectedValue='<%# ConvertToInt( Eval("hodnoceni") ) %>' DataSourceID="ODS_StupnicePodrobne"
                                                DataTextField="Value" DataValueField="Key" Visible='<%# Eval("hodnoceni_visible") %>'>
                                            </cc1:TDropDown>
                                        </asp:TableCell>
                                    </asp:TableRow>
                                    <asp:TableRow>
                                        <asp:TableCell>
                                            <asp:Label ID="Label7" runat="server" Text="[%Poznámka%]:" Visible='<%# Eval("poznamka_visible") %>'></asp:Label>
                                        </asp:TableCell>
                                        <asp:TableCell>
                                            <telerik:RadTextBox ID="TB_Poznamka" runat="server" Text='<%# Bind("poznamka") %>'
                                                Visible='<%# Eval("poznamka_visible") %>' TextMode="MultiLine" Width="350" Rows="4"
                                                MaxLength="250">
                                            </telerik:RadTextBox><br />
                                            <kspwc:TextValidator runat="server" ID="TV_Poznamka" ControlToValidate="TB_Poznamka"></kspwc:TextValidator>
                                        </asp:TableCell>
                                    </asp:TableRow>
                                </asp:Table>
                            </ItemTemplate>
                            <SeparatorTemplate>
                                <br />
                            </SeparatorTemplate>
                            <FooterTemplate>
                                <%--<br />--%>
                                <%-- <asp:LinkButton ID="LB_Update" runat="server" SkinID="caption" OnClick="LB_Update_Click">[%Uložit%]</asp:LinkButton>
                            &nbsp;
                            <asp:LinkButton ID="LB_Cancel" runat="server" SkinID="caption" OnClick="LB_Cancel_Click"
                                CausesValidation="False">[%Zrušit změny%]</asp:LinkButton>
                            &nbsp;
                            <asp:LinkButton ID="LB_Delete" runat="server" SkinID="caption" OnClick="LB_Delete_Click"
                                CausesValidation="False">[%Vymazat%]</asp:LinkButton>--%>
                                <br />
                                <kspwc:TRadButton ID="TRB_Update" runat="server" Text="[%Uložit%]" OnClick="TRB_Update_Click"></kspwc:TRadButton>
                                <kspwc:TRadButton ID="TRB_Cancel" runat="server" Text="[%Zrušit změny%]" ConfirmText="[%Chcete zrušit neuložené změny%]?" OnClick="TRB_Cancel_Click" CausesValidation="false"></kspwc:TRadButton>
                                <kspwc:TRadButton ID="TRB_Delete" runat="server" Text="[%Vymazat%]" ConfirmText="[%Chcete vymazat hodnocení%]?" OnClick="TRB_Delete_Click" CausesValidation="false"></kspwc:TRadButton>
                            </FooterTemplate>
                        </asp:Repeater>
                    </asp:Panel>
                </td>
            </tr>
        </table>
    </asp:Panel>
</asp:Content>
