﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    Inherits="Zamestnanec_MzdoveUdaje" CodeBehind="MzdoveUdaje.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="kspwc" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Zamestatnec" TypeName="KSProgram.Personal.MzdoveUdaje"></asp:ObjectDataSource>
    <telerik:RadDataForm ID="MzdUdajeZam" runat="server" DataSourceID="ObjectDataSource1">
        <LayoutTemplate>
            <div>
                <div class="rgCaption">[%Mzdové údaje zaměstnance%]</div>
                <div id="itemPlaceholder" runat="server"></div>
            </div>
        </LayoutTemplate>
        <ItemTemplate>
            <div style="padding: 15px; min-width: 700px; background: white; color: black">
                <div style="width: 100%">
                    <wc:BindTable ID="BindTable1" runat="server" HeaderText="[%Zdravotní pojištění%]" Width="100%" CssClass="KsUnderlineTable">
                        <TextFieldStyle Width="150px" />
                        <Rows>
                            <wc:BindRow Text="[%Pojišťovna%]" DataField="zdrav_poj" />
                            <wc:BindRow Text="[%Platí od%]" DataField="zdrav_poj_od" DataFormatString="{0:d}" HtmlEncode="false" />
                            <wc:BindRow Text="[%Minulá zdrav. pojišťovna%]" DataField="min_zdrav_poj" />
                        </Rows>
                    </wc:BindTable>
                </div>
                <div style="display: flex; flex-direction: row; flex-wrap: wrap; width: 100%">
                    <div style="width: 46%; margin: 2%;">
                        <div style="margin-bottom: 20px;">
                            <wc:BindTable ID="BindTable2" runat="server" HeaderText="[%Daně%]" CssClass="KsUnderlineTable">
                                <TextFieldStyle Width="150px" />
                                <Rows>
                                    <wc:BindRow Text="[%Podepsáno prohlášení%]" DataField="dan_sleva" />
                                    <wc:BindRow Text="[%Odpočet od%]" DataField="sleva_od" DataFormatString="{0:d}" HtmlEncode="false" />
                                    <wc:BindRow Text="[%Odpočet do%]" DataField="sleva_do" DataFormatString="{0:d}" HtmlEncode="false" />
                                </Rows>
                            </wc:BindTable>
                        </div>
                        <div>
                            <wc:BindTable ID="BindTable3" runat="server" HeaderText="[%Vyživované osoby%]" CssClass="KsUnderlineTable">
                                <TextFieldStyle Width="150px" />
                                <Rows>
                                    <wc:BindRow Text="[%Pro existenční minimum%]" DataField="vyziv_os_exm" />
                                </Rows>
                            </wc:BindTable>
                        </div>
                    </div>
                    <div style="width: 46%; margin: 2%;">
                        <div style="margin-bottom: 20px;">
                            <wc:BindTable ID="BindTable4" runat="server" HeaderText="[%Ostatní údaje%]" OnDataBound="BindTable4_DataBound" CssClass="KsUnderlineTable">
                                <TextFieldStyle Width="150px" />
                                <Rows>
                                    <wc:BindRow Text="[%Výplatní místo%]" DataField="vypl_str" />
                                    <wc:BindRow Text="[%Zaměstnanec souhlasí s evidencí citlivých dat%]" DataField="souhlas_cud_text" />
                                    <wc:BindRow Text="[%Členství v odborovém hnutí%]" DataField="clen_roh" />
                                    <wc:BindRow Text="[%Student (aktuálně)%]" DataField="student" />
                                </Rows>
                            </wc:BindTable>
                        </div>
                        <div>
                            <wc:BindTable ID="BindTable5" runat="server" HeaderText="[%Číslo účtu, na který odchází mzda%]" CssClass="KsUnderlineTable">
                                <TextFieldStyle Width="75px" />
                                <Rows>
                                    <wc:BindRow Text="[%Číslo účtu%]" DataField="cislo_platby" HideWhenEmpty="true" />
                                    <wc:BindRow Text="[%Kód banky%]" DataField="cislo_banky" HideWhenEmpty="true" />
                                    <wc:BindRow Text="[%IBAN%]" DataField="iban" HideWhenEmpty="true" />
                                    <wc:BindRow Text="[%SWIFT%]" DataField="swift" HideWhenEmpty="true" />
                                </Rows>
                            </wc:BindTable>
                        </div>
                    </div>
                </div>
            </div>
        </ItemTemplate>
    </telerik:RadDataForm>
</asp:Content>
