﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    Inherits="Sestavy_HomeOfficePrehled" CodeBehind="HomeOfficePrehled.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadAjaxManagerProxy ID="RAMP_hoprhled" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRG_HomeOffice">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_HomeOffice" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <telerik:RadPersistenceManagerProxy ID="RPMP_shomeof" runat="server">
        <PersistenceSettings>
            <telerik:PersistenceSetting ControlID="TRG_HomeOffice" />
        </PersistenceSettings>
    </telerik:RadPersistenceManagerProxy>


    <kspwc:TRadGrid ID="TRG_HomeOffice" runat="server" AutoGenerateColumns="false"
        KSGridType="Filtrovani,AutoFit,Trizeni,Rolovani,Pager,Grupovani,Footer,Command,Agregace" OnNeedDataSource="TRG_HomeOffice_NeedDataSource">
        <ClientSettings AllowColumnsReorder="True">
            <Scrolling SaveScrollPosition="true" EnableColumnClientFreeze="true" FrozenColumnsCount="4" CountGroupSplitterColumnAsFrozen="false"></Scrolling>
        </ClientSettings>
        <MasterTableView CommandItemDisplay="Top" DataKeyNames="os_cislo" Caption="[%Přehled Homeoffice%]" PageSize="15">
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl runat="server" DateControl="TRadObdobi">
                    <ExportButton runat="server" ShowExportToExcelBIFFItem="false" ShowExportToExcelHtmlItem="false" ShowExportToExcelMLItem="true"></ExportButton>
                    <RebindButton runat="server" OnClick="Rebind_Click" OnPreRender="Rebind_PreRender"></RebindButton>
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
            <PagerStyle PageSizes="10,30,50,100,200,500,1000" />
            <ColumnGroups>
                <telerik:GridColumnGroup Name="zam" HeaderText="[%Zaměstnanec%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="pom" HeaderText="[%Pracovní poměr%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="hom" HeaderText="[%Homeoffice%]"></telerik:GridColumnGroup>
            </ColumnGroups>
            <Columns>
                <telerik:GridNumericColumn UniqueName="id_podniku" DataField="id_podniku" HeaderText="[%Id. pod.%]" DataType="System.Int32" DecimalDigits="0" ColumnGroupName="zam"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn UniqueName="os_cislo" DataField="os_cislo" HeaderText="[%Os. číslo%]" DataType="System.Decimal" DecimalDigits="0" ColumnGroupName="zam"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn UniqueName="prijmeni" DataField="prijmeni" HeaderText="[%Příjmení%]" DataType="System.String" ColumnGroupName="zam"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="jmeno" DataField="jmeno" HeaderText="[%Jméno%]" DataType="System.String" ColumnGroupName="zam"></telerik:GridBoundColumn>
                <telerik:GridNumericColumn UniqueName="cislo_pom" DataField="cislo_pom" HeaderText="[%Číslo%]" DataType="System.Int16" ColumnGroupName="pom"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn UniqueName="druh_pom_j" DataField="druh_pom_j" HeaderText="[%Druh%]" DataType="System.String" ColumnGroupName="pom"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="druh_pom_j_vyznam" DataField="druh_pom_j_vyznam" HeaderText="[%Název%]" DataType="System.String" ColumnGroupName="pom"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="rez_zakazka" DataField="rez_zakazka" HeaderText="[%Režijní zakázka%]" DataType="System.String" ColumnGroupName="pom"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="rozp_kateg" DataField="rozp_kateg" HeaderText="[%Rozp. kateg.%]" DataType="System.String" ColumnGroupName="pom"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="prac_str" DataField="prac_str" HeaderText="[%Středisko%]" DataType="System.String" ColumnGroupName="pom"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="prac_str_nazev" DataField="prac_str_nazev" HeaderText="[%Název střediska%]" DataType="System.String" ColumnGroupName="pom"></telerik:GridBoundColumn>
                <telerik:GridNumericColumn UniqueName="hod_uvazek" DataField="hod_uvazek" HeaderText="[%Úvazek%]" DataType="System.Decimal" DecimalDigits="2" ColumnGroupName="pom"></telerik:GridNumericColumn>

                <telerik:GridNumericColumn UniqueName="cerpani" DataField="cerpani" HeaderText="[%Čerpání%]" DataType="System.Decimal" DecimalDigits="2" DataFormatString="{0:#,0.0}" ColumnGroupName="hom"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn UniqueName="plan" DataField="plan" HeaderText="[%Plán%]" DataType="System.Decimal" DecimalDigits="2" DataFormatString="{0:#,0.0}" ColumnGroupName="hom"></telerik:GridNumericColumn>
            </Columns>
        </MasterTableView>
    </kspwc:TRadGrid>

</asp:Content>
