﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="PravaRoleAkce.aspx.cs" Inherits="KSPortal.Obecne.PravaRoleAkce" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <script type="text/javascript" id="telerikClientEvents1">
//<![CDATA[

        function RadTreeListAkce_OnItemSelected(sender, args) {
            var childs = args.get_item().get_childItems();
            for (child in childs) {
                sender.selectItem(childs[child]);
            }
        }
        function RadTreeListAkce_OnItemDeselected(sender, args) {
            var childs = args.get_item().get_childItems();
            for (child in childs) {
                sender.deselectItem(childs[child]);
            }
        }   
//]]>
    </script>
    <style type="text/css">
        .sibl
        {
            font-weight: bold;
            background-color: #d7d7d7;
        }
        .padding_button
        {
            padding: 10px 5px 10px 5px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="RadComboBoxRole">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadTreeListAkce" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RadButtonZakazat">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadTreeListAkce" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RadButtonPovolit">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadTreeListAkce" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RadButtonPovolitPrihl">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadTreeListAkce" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RadTreeListAkce">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadTreeListAkce" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    
    <asp:ObjectDataSource ID="ODS_Akce" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="StromAkciProRoli" TypeName="KSProgram.Prava.Prtl_role_akce">
        <SelectParameters>
             <asp:Parameter Name="roleid" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <telerik:RadDockLayout runat="server" ID="RadDockLayout1">
        <telerik:RadDockZone runat="server" ID="RadDockZone1" MinHeight="70" MinWidth="300">
            <telerik:RadDock runat="server" ID="RadDock1" Title="[%Táhnutím myší mě přemístíš%]..." OnClientInitialize="KSMaster.doch_load"
                EnableRoundedCorners="true" Width="500" DefaultCommands="PinUnpin">
                 <Commands>                                    
                    <telerik:DockCommand AutoPostBack="true" Name="zpet" Text="Zpět na výchozí místo" OnClientCommand="KSMaster.DockRadDock1ToZone" ></telerik:DockCommand>
                    <telerik:DockPinUnpinCommand />
                </Commands>
                <ContentTemplate>
                    <table style="border-collapse: collapse;">
                        <tr>
                        <asp:ObjectDataSource ID="ds_allRoles" runat="server" SelectMethod="GetAllRoles" TypeName="KSProgram.Prava.PravaAkce"></asp:ObjectDataSource>
                            <td colspan="3" class="padding_button">
                                <telerik:RadComboBox ID="RadComboBoxRole" runat="server" 
                                    EmptyMessage="[%Role%]" Width="350px"
                                    DataSourceID="ds_allRoles" DataTextField="roleName" 
                                    DataValueField="roleId" AutoPostBack="True"
                                    OnSelectedIndexChanged="RadComboBoxRole_SelectedIndexChanged" 
                                    DropDownAutoWidth="Enabled" DropDownWidth="350px">
                                </telerik:RadComboBox>
                            </td>
                        </tr>
                        <tr>
                            <td class="padding_button">
                                <telerik:RadButton ID="RadButtonZakazat" runat="server" Text="[%Zakázat%]" CommandName="zmena_stavu"
                                    CommandArgument="zakazat" OnClick="RadButtonZakazat_Click">
                                    <Icon PrimaryIconUrl="../ImagesN/AccessRed.png" />
                                </telerik:RadButton>
                            </td>
                            <td class="padding_button">
                                <telerik:RadButton ID="RadButtonPovolit" runat="server" Text="[%Povolit%]" CommandName="zmena_stavu"
                                    CommandArgument="povolit" OnClick="RadButtonPovolit_Click" >
                                    <Icon PrimaryIconUrl="../ImagesN/AccessAllow.png" />
                                </telerik:RadButton>
                            </td>
                            <td class="padding_button">
                                <telerik:RadButton ID="RadButtonPovolitPrihl" runat="server" Text="[%Povolit, jen pokud je vybrán přihlášený uživatel%]"
                                    CommandName="zmena_stavu" CommandArgument="povolit_prih" OnClick="RadButtonPovolitPrihl_Click">
                                    <Icon PrimaryIconUrl="../ImagesN/AccessCond.png" />
                                </telerik:RadButton>
                            </td>
                        </tr>
                    </table>
                </ContentTemplate>
            </telerik:RadDock>
        </telerik:RadDockZone>
    </telerik:RadDockLayout>
    <br />
    <br />
    <telerik:RadTreeList ID="RadTreeListAkce" runat="server" AutoGenerateColumns="False"
         DataKeyNames="id" ParentDataKeyNames="parent_id"
        OnItemCreated="RadTreeListAkce_ItemCreated" Visible="False" AllowMultiItemSelection="True"
        AllowSorting="True" OnItemDataBound="RadTreeListAkce_ItemDataBound">
        <ClientSettings>
            <Selecting AllowItemSelection="True" AllowToggleSelection="True" />
            <ClientEvents OnItemDeselected="RadTreeListAkce_OnItemDeselected" OnItemSelected="RadTreeListAkce_OnItemSelected" />
        </ClientSettings>
        <EditFormSettings EditFormType="AutoGenerated">
        </EditFormSettings>
        <ValidationSettings CommandsToValidate="PerformInsert,Update"></ValidationSettings>
        <Columns>
            <telerik:TreeListBoundColumn DataField="short_name" HeaderText="[%Název%]" SortExpression="short_name">
                <HeaderStyle Width="300px" />
            </telerik:TreeListBoundColumn>
            <telerik:TreeListSelectColumn UniqueName="SelectColumn">
                <HeaderStyle Width="35px" />
            </telerik:TreeListSelectColumn>
            <telerik:TreeListBoundColumn DataField="type" HeaderText="[%Typ%]" SortExpression="type">
                <HeaderStyle Width="100px" />
            </telerik:TreeListBoundColumn>
            <telerik:TreeListImageColumn UniqueName="img" DataImageUrlFields="img">
                <HeaderStyle Width="35px" />
                <ItemStyle VerticalAlign="Middle" />
            </telerik:TreeListImageColumn>
            <telerik:TreeListBoundColumn DataField="stav_popis" HeaderText="[%Stav%]" SortExpression="stav_popis">
                <HeaderStyle Width="300px" />
            </telerik:TreeListBoundColumn>
            <telerik:TreeListBoundColumn DataField="akce" UniqueName="akce" DataType="System.Int32"
                Visible="False">
            </telerik:TreeListBoundColumn>
            <telerik:TreeListBoundColumn DataField="stav" DataType="System.Int32" Visible="False">
            </telerik:TreeListBoundColumn>
        </Columns>
        <PagerStyle PageSizeControlType="RadComboBox"></PagerStyle>
    </telerik:RadTreeList>
    <telerik:RadCodeBlock runat="server" ID="cb1">
    <script type="text/javascript" id="Script1">
//<![CDATA[
        KSMaster.doch_load = function (sender, args) {
            KSMaster.dock = sender;
        };

        KSMaster.DockRadDock1ToZone = function () {
            var zone = $find('<%= RadDockZone1.ClientID %>');
            if (KSMaster.dock && zone) {
                zone.dock(KSMaster.dock);
                KSMaster.dock.set_dockMode(3);
                KSMaster.dock.set_enableDrag(true);
            }
        };         
     //]]>
    </script>
    </telerik:RadCodeBlock>

</asp:Content>


