﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Manazer_DokumentyVystavene"
    CodeBehind="DokumentyVystavene.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<%@ Register Src="~/Dokumenty/PdfViewer.ascx" TagName="PdfViewer" TagPrefix="pdf" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        #progressbar, #progress_anal {
            width: auto;
            display: block;
            margin: 10px;
        }

        .progr_buttons {
            text-align: right;
        }

        .rgRow .kstlacitko,
        .rgAltRow .kstlacitko {
            padding: 0px !important;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRB_SelectAll">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RW_progress" />
                    <telerik:AjaxUpdatedControl ControlID="HF_ids_progress" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRadGrid1">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid1"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="RW_Dokument" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_prg_ok">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RW_progress" />
                    <telerik:AjaxUpdatedControl ControlID="HF_ids_progress" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid1" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="ExportToTRB_pripona">
                <UpdatedControls>
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

    <telerik:RadPersistenceManagerProxy runat="server" ID="RPMP_man_dok_vyst">
        <PersistenceSettings>
            <telerik:PersistenceSetting ControlID="TRadGrid1" />
        </PersistenceSettings>
    </telerik:RadPersistenceManagerProxy>

    <%--<asp:Label ID="Label2" runat="server" Text="[%Dokumenty vystavené%]" CssClass="nadpis1"></asp:Label>--%>

    <kspwc:TRadGrid ID="TRadGrid1" runat="server" AutoFilterControlWidth="false" AutoFilterWidth="true" ShowGroupPanel="True" MasterTableView-Caption="[%Dokumenty vystavené%]"
        AllowSorting="True" AutoGenerateColumns="False" OnItemCommand="TRadGrid1_ItemCommand" OnItemDataBound="TRadGrid1_ItemDataBound" OnItemCreated="TRadGrid1_ItemCreated"
        AllowPaging="true" OnNeedDataSource="TRadGrid1_NeedDataSource">
        <GroupingSettings CaseSensitive="False" ShowUnGroupButton="true"></GroupingSettings>
        <ClientSettings AllowDragToGroup="True">
        </ClientSettings>
        <MasterTableView CommandItemDisplay="Top" DataKeyNames="id,id_poz,id_podpisu,vazba_blob,externi_cesta" EnableHeaderContextMenu="true">
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl runat="server" ID="GCIC1" DateControl="TRadObdobiInterval">
                    <RebindButton runat="server" ID="trb_rebind" OnClick="trb_rebind_Click" />
                    <TRadObdobiInterval ID="TROI" runat="server">
                        <PickerDo runat="server" ID="troi_do" OnSelectedDateChanged="troi_SelectedDateChanged"></PickerDo>
                        <PickerOd runat="server" ID="troi_od" OnSelectedDateChanged="troi_SelectedDateChanged" ></PickerOd>
                    </TRadObdobiInterval>
                </kspwc:GridCommandItemControl>
                <%--tlačítko pro výběr všeho--%>
                <kspwc:TRadButton AutoPostBack="true" runat="server" OnClick="TRB_SelectAll_Click" ID="TRB_SelectAll" Text="[%Předat zobrazené k podpisu%]" Style="margin-top: 2px;"
                     Icon-PrimaryIconCssClass="fi fi-pencil"
                    ConfirmTitle="[%Předání k podpisu%]" ConfirmText="[%Touto akcí zahájíte založení požadavků všech dokumentů načtených v agendě po aplikaci filtrování, bez ohledu na stránky. Opravdu chcete pokračovat?%]" />
                <kspwc:TRadButton runat="server" ID="TRB_analyze_signs" Text="[%Analýza podpisů%]" OnClientClicked="TRB_analyze_signs_Clicked" AutoPostBack="false" Style="margin-top: 2px;"
                    ToolTip="[%Ověří podpisy a časová razítka, zhodnotí LTV a připraví dokumenty k razítkování. Lze automatizovat pomocí Aplikačního serveru.%]">
                    <Icon PrimaryIconCssClass="fi fi-info" />
                </kspwc:TRadButton>
                <kspwc:TRadButton runat="server" ID="TRB_razitkuj" Text="[%Razítkování TSA%]" OnClientClicked="TRB_razitkuj_Clicked" AutoPostBack="false" Style="margin-top: 2px;"
                    ToolTip="[%Spustí časové razítkování u dokumentů, u nichž již proběhla analýza. Orazítkovány budou pouze ty, které nemají aktivní LTV a blíží se konec jejich platnosti. Tím se prodlouží jejich validita. Lze automatizovat pomocí Aplikačního serveru.%]">
                    <Icon PrimaryIconCssClass="fi fi-legal" />
                </kspwc:TRadButton>
            </CommandItemTemplate>
            <ColumnGroups>
                <telerik:GridColumnGroup Name="d" HeaderText="[%Dokument%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="s" HeaderText="[%Šablona%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="p" HeaderText="[%Podpis%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="v" HeaderText="[%Vývěska%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="z" HeaderText="[%Zaměstnanec%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="d2" HeaderText="[%Formát%]"></telerik:GridColumnGroup>
            </ColumnGroups>
            <Columns>
                <telerik:GridNumericColumn UniqueName="id" DataField="id" DataType="System.Int32" HeaderText="Id" ColumnGroupName="d"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn UniqueName="id_predlohy" DataField="id_predlohy" DataType="System.Int32" HeaderText="[%Id Předlohy%]" ColumnGroupName="d" Display="false"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn FilterControlAltText="Filter poznamka column" UniqueName="poznamka"
                    DataField="poznamka" HeaderText="[%Název%]" SortExpression="poznamka" ColumnGroupName="d" Display="false">
                </telerik:GridBoundColumn>
                <telerik:GridDateTimeColumn FilterControlAltText="Filter dat_vystaveni column" UniqueName="dat_vystaveni"
                    PickerType="DatePicker" HeaderText="[%Datum vystavení%]" DataField="dat_vystaveni"
                    DataFormatString="{0:d.M.yyyy}" EditDataFormatString="d.M.yyyy" ColumnGroupName="d">
                </telerik:GridDateTimeColumn>
                <telerik:GridAttachmentColumn ButtonCssClass="no-block-ui" DataTextField="externi_cesta"
                    FilterControlAltText="Filter document column" HeaderText="[%Dokument%]" UniqueName="document"
                    SortExpression="externi_cesta" ColumnGroupName="d">
                </telerik:GridAttachmentColumn>
                <telerik:GridTemplateColumn UniqueName="nahled" ColumnGroupName="d" AllowFiltering="false">
                    <ItemTemplate>
                        <kspwc:TRadButton runat="server" CommandName="preview" ToolTip="[%Náhled%]" >
                            <Icon PrimaryIconCssClass="fi fi-search" />
                        </kspwc:TRadButton>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridNumericColumn UniqueName="id_sab" DataField="id_sab" DataType="System.Int32" HeaderText="Id" ColumnGroupName="s"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn UniqueName="s_nazev" DataField="s_nazev" HeaderText="[%Název šablony%]" SortExpression="s_nazev" ColumnGroupName="s">
                </telerik:GridBoundColumn>
                <telerik:GridButtonColumn UniqueName="sign" ButtonType="LinkButton" Text="[%Předat k podpisu%]" CommandName="sign" ColumnGroupName="p">
                </telerik:GridButtonColumn>
                <telerik:GridNumericColumn UniqueName="id_poz" DataField="id_poz" DataType="System.Int32" HeaderText="[%Id požadavku%]" ColumnGroupName="p" Display="false"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn UniqueName="stav_podpisu" DataField="stav_podpisu" DataType="System.String" HeaderText="[%Stav podpisu%]" ColumnGroupName="p"></telerik:GridBoundColumn>
                <telerik:GridTemplateColumn UniqueName="sign_analyze" ColumnGroupName="p" AllowFiltering="false">
                    <ItemTemplate>
                        <kspwc:TRadButton runat="server" CommandName="sign_analyze" ToolTip="[%Analýza podpisů%]" >
                            <Icon PrimaryIconCssClass="fi fi-info" />
                        </kspwc:TRadButton>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridDateTimeColumn UniqueName="platnost_do" DataField="platnost_do" DataType="System.DateTime" HeaderText="[%Platný do%]" ColumnGroupName="p" DataFormatString="{0:d.M.yyyy}" EditDataFormatString="d.M.yyyy"></telerik:GridDateTimeColumn>
                <telerik:GridButtonColumn UniqueName="bulletin" ButtonType="LinkButton" Text="[%Vyvěsit%]" CommandName="bulletin" ColumnGroupName="v">
                </telerik:GridButtonColumn>
                <telerik:GridButtonColumn UniqueName="bulletin_d" ButtonType="LinkButton" Text="[%Smazat%]" CommandName="bulletin_d" ColumnGroupName="v" Visible="false">
                </telerik:GridButtonColumn>
                <telerik:GridDateTimeColumn UniqueName="vyveseno" HeaderText="[%Vyvěšeno%]" DataField="vyveseno" DataFormatString="{0:d.M.yyyy}" ColumnGroupName="v">
                </telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn UniqueName="zobrazeno" HeaderText="[%Zobrazeno%]" DataField="zobrazeno" DataFormatString="{0:d.M.yyyy}" ColumnGroupName="v">
                </telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn UniqueName="precteno" HeaderText="[%Potvrzeno%]" DataField="precteno" DataFormatString="{0:d.M.yyyy}" ColumnGroupName="v">
                </telerik:GridDateTimeColumn>
                <telerik:GridBoundColumn UniqueName="os_cislo" DataField="os_cislo" SortExpression="os_cislo" HeaderText="[%Os.číslo%]" ColumnGroupName="z"></telerik:GridBoundColumn>
                <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo" ColumnGroupName="z"></kspwc:GridFotoZamColumn>
                <telerik:GridBoundColumn UniqueName="jmeno" DataField="jmeno" SortExpression="jmeno" HeaderText="[%Jméno%]" ColumnGroupName="z"></telerik:GridBoundColumn>
                <telerik:GridTemplateColumn HeaderText="[%Stažení ve formátu%]" AllowFiltering="false" ColumnGroupName="d2" Display="false">
                    <ItemTemplate>
                        <asp:Repeater OnDataBinding="R_pripony_DataBinding" runat="server" ID="R_pripony">
                            <ItemTemplate>
                                <kspwc:TRadButton runat="server" ID="ExportToTRB_pripona" Text='<%# Eval("pripona") %>' CommandName='<%# Eval("pripona") %>' CommandArgument='<%# Eval("id") %>' OnClick="TRB_pripona_Click">
                                </kspwc:TRadButton>
                            </ItemTemplate>
                        </asp:Repeater>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
            </Columns>

        </MasterTableView>

    </kspwc:TRadGrid>

    <telerik:RadWindow ID="RW_Dokument" runat="server" Behaviors="Close,Resize,Move,Pin" Modal="false" 
        Title="[%Dokument%]" VisibleOnPageLoad="false" Height="1024px" Width="800px" Top="60">
        <ContentTemplate>
            <pdf:PdfViewer runat="server" ID="PV_viewer" Height="100%" Width="100%" ParentWindowPozice="Right"></pdf:PdfViewer>
        </ContentTemplate>
    </telerik:RadWindow>
    <asp:HiddenField ID="HF_ids_progress" runat="server" />
    <label id="l_progress_text0" class="hidden">[%Zpracováno dokumentů: {0} z {1}%]</label>
    <label id="l_progress_text1" class="hidden">[%Založeno požadavků:%] </label>
    <label id="l_progress_text2" class="hidden">[%Přibližná doba zpracování:%] </label>
    <label id="l_progress_text3" class="hidden">[%Zpracování je dokončeno%]</label>
    <label id="l_progress_text4" class="hidden">[%Zpracováno dokumentů: {0}%]</label>
    <label id="l_progress_text5" class="hidden">[%Vloženo razítek: {0}%]</label>
    <label id="l_progress_text6" class="hidden">[%Razítkování podpisů%]</label>
    <label id="l_progress_text7" class="hidden">[%Analýza podpisů%]</label>

    <telerik:RadWindow ID="RW_progress" runat="server" Width="300" Height="200" CssClass="ksMessageAutoSize" OnClientShow="RW_progress_Show"  Title="[%Zakládání požadavků%]"
        Modal="true" Behaviors="None" VisibleStatusbar="false" DestroyOnClose="true">
        <ContentTemplate>
            <div id="progressbar"></div>
            <label id="l_cas"></label>
            <br />
            <label id="l_progress"></label>
            <br />
            <label id="l_progress1"></label>
            <br />
            <br />
            <div class="progr_buttons">
                <kspwc:TRadButton runat="server" ID="TRB_prg_cancel" Text="[%Přerušit%]" AutoPostBack="false" OnClientClicked="TRB_prg_cancel_Clicked" Icon-PrimaryIconCssClass="fi fi-stop"></kspwc:TRadButton>
                <kspwc:TRadButton runat="server" ID="TRB_prg_ok" Text="[%Ok%]" OnClientClicked="TRB_prg_ok_Clicked" OnClick="TRB_prg_ok_Click" Icon-PrimaryIconCssClass="fi fi-check"></kspwc:TRadButton>
            </div>
        </ContentTemplate>
    </telerik:RadWindow>

    <telerik:RadWindow ID="RW_progress_analyze" runat="server" Width="300" Height="230" CssClass="ksMessageAutoSize"
        Modal="true" Behaviors="None" VisibleStatusbar="false" DestroyOnClose="true" OnClientShow="RW_progress_analyze_Show">
        <ContentTemplate>
            <div id="progress_anal"></div>
            <br />
            <label id="l_cas_a"></label>
            <br />
            <br />
            <label id="l_done_a"></label>
            <br />
            <br />
            <div class="progr_buttons">
                <kspwc:TRadButton runat="server" ID="TRB_anal_cancel" Text="[%Přerušit%]" AutoPostBack="false" OnClientClicked="TRB_prg_cancel_Clicked" Icon-PrimaryIconCssClass="fi fi-stop"></kspwc:TRadButton>
                <kspwc:TRadButton runat="server" ID="TRB_anal_ok" Text="[%Ok%]" AutoPostBack="false" OnClientClicked="TRB_anal_ok_Clicked" OnClick="TRB_anal_ok_Click" Icon-PrimaryIconCssClass="fi fi-check"></kspwc:TRadButton>
            </div>
        </ContentTemplate>
    </telerik:RadWindow>

    <telerik:RadScriptBlock runat="server">
        <script type="text/javascript">
            function onLoad(sender, args) {
                resizeViewer(sender);
            }
            function resizeViewer(pdfViewer) {
                pdfViewer.set_height($(pdfViewer.get_element().parentElement).height());
            }
            var progress_data;
            var succes_wf;
            var canceled;
            var start_time;
            function RW_progress_Show(sender, args) {
                var hf = $get('<%= HF_ids_progress.ClientID %>');
                progress_data = $telerik.$.parseJSON(hf.value);
                $("#progressbar").kendoProgressBar({
                    min: 0,
                    max: progress_data.length,
                    value: progress_data.length - progress_data.ids.length,
                    type: "value",
                    animation: {
                        duration: 600
                    }
                });
                update_progress();
                succes_wf = 0;
                canceled = false;
                start_time = Date.now();
                $find('<%=TRB_prg_ok.ClientID%>').set_enabled(false);
                $find('<%=TRB_prg_cancel.ClientID%>').set_enabled(true);
                setTimeout(make_wf_all);
            }
            
            function make_wf_all() {
                if (progress_data.ids.length > 0 && !canceled) {
                    var i = 5;
                    var ids = [];
                    while (progress_data.ids.length > 0 && i > 0) {
                        ids.push(progress_data.ids.shift());
                        i--;
                    }
                    setTimeout(function () { make_wf_ajax(ids); }, 100);
                }
                else {
                    close_progress();
                }
            }
            
            function make_wf_ajax(ids) {
                $.ajax({
                    type: "POST",
                    url: KSMaster.baseUrl + "/Manazer/DokumentyVystavene.aspx/ZalozPodpisy",
                    data: "{jsonIds: '" + JSON.stringify(ids) + "'}",
                    async: true,
                    contentType: "application/json",
                    dataType: "json",
                    failure: function (response) {
                        close_progress();
                        KSMaster.showError(response.responseText, response.statusText);
                    },
                    error: function (response) {
                        close_progress();
                        KSMaster.showError(response.responseText, response.statusText);
                    },
                    success: function (data) {
                        succes_wf += data.d;
                        update_progress();
                        make_wf_all();
                    }
                });
            }

            function update_progress() {
                var pb = $("#progressbar").data("kendoProgressBar");
                pb.value(progress_data.length - progress_data.ids.length);

                var pr = $("#l_progress_text0")[0].innerText.replace("{0}", (progress_data.length - progress_data.ids.length));
                pr = pr.replace("{1}", progress_data.length)
                $("#l_progress")[0].innerText = pr;

                $("#l_progress1")[0].innerText = $("#l_progress_text1")[0].innerText + succes_wf;
                if (start_time) {
                    var time = Math.floor(((Date.now() - start_time) / (progress_data.length - progress_data.ids.length) * progress_data.ids.length) / 1000);
                    $("#l_cas")[0].innerText = $("#l_progress_text2")[0].innerText + getTimeString(time);
                }
            }

            function getTimeString(time) {
                var ret = time % 60 + "s";
                time = Math.floor(time / 60);
                if (time > 0) {
                    ret = time % 60 + "m " + ret;
                    time = Math.floor(time / 60);
                    if (time > 0) {
                        ret = time % 60 + "h " + ret;
                        time = Math.floor(time / 24);
                        if (time > 0) {
                            ret = time + "d " + ret;
                        }
                    }
                }
                return ret;
            }

            function close_progress() {
                $find('<%=TRB_prg_ok.ClientID%>').set_enabled(true);
                $find('<%=TRB_prg_cancel.ClientID%>').set_enabled(false);
                $("#l_cas")[0].innerText = $("#l_progress_text3")[0].innerText;
            }

            function TRB_prg_cancel_Clicked(sender, args) {
                canceled = true;
            }

            function TRB_prg_ok_Clicked(sender, args) {
                $find('<%=RW_progress.ClientID%>').close();
            }

            var proces_podpisu = '';
            function TRB_analyze_signs_Clicked(sender, args) {
                proces_podpisu = 'analyza';
                $find('<%=RW_progress_analyze.ClientID%>').show();
            }

            function TRB_razitkuj_Clicked(sender, args) {
                proces_podpisu = 'razitka';
                $find('<%=RW_progress_analyze.ClientID%>').show();
            }

            function RW_progress_analyze_Show(sender, args) {
                canceled = false;
                count_anal = null;
                start_time = Date.now();
                performed = 0;
                if (proces_podpisu == 'analyza')
                    sender.set_title($("#l_progress_text7")[0].innerText);
                else
                    sender.set_title($("#l_progress_text6")[0].innerText);

                $("#progress_anal").kendoProgressBar({
                    min: 0,
                    type: "value",
                    animation: {
                        duration: 600
                    }
                });

                $find('<%=TRB_anal_ok.ClientID%>').set_enabled(false);
                $find('<%=TRB_anal_cancel.ClientID%>').set_enabled(true);

                make_analyze_ajax(true);
            }
            var count_anal;
            function make_analyze_ajax(first) {
                $.ajax({
                    type: "POST",
                    url: KSMaster.baseUrl + "/Manazer/DokumentyVystavene.aspx/AnalizujPodpisy",
                    data: JSON.stringify({ buff: 10, first, proces_podpisu }),
                    async: true,
                    contentType: "application/json",
                    dataType: "json",
                    failure: function (response) {
                        close_progress_anal();
                        KSMaster.showError(response.responseText, response.statusText);
                    },
                    error: function (response) {
                        close_progress_anal();
                        KSMaster.showError(response.responseText, response.statusText);
                    },
                    success: function (data) {
                        var ret = data.d;
                        update_progress_anal(ret);
                        if (ret.count > 0 && !canceled && !ret.error)
                            setTimeout(function ()
                            {
                                make_analyze_ajax(false);
                            }, 10);
                        else {
                            $find('<%=TRB_anal_ok.ClientID%>').set_enabled(true);
                            $find('<%=TRB_anal_cancel.ClientID%>').set_enabled(false);
                            $("#l_cas_a")[0].innerText = $("#l_progress_text3")[0].innerText;
                            if (ret.error) {
                                radalert(ret.error, 0, 0, "TSA Server Error" , null, null);
                            }
                        }
                    }
                });
            }

            function TRB_anal_ok_Clicked(sender, args) {
                close_progress_anal();
            }

            function close_progress_anal() {
                $("#l_cas_a")[0].innerText = '';
                $("#l_done_a")[0].innerText = '';
                $find('<%=RW_progress_analyze.ClientID%>').close();
            }
            var performed = 0;
            function update_progress_anal(d) {
                var prdiv = $("#progress_anal");
                var pb = prdiv.data("kendoProgressBar");
                if (count_anal == null) {
                    pb.options.max = d.count;
                    count_anal = d.count;
                }

                var done = count_anal - d.count;

                pb.value(done);

                // Po animaci (čekej o něco déle než duration), přepiš text
                setTimeout(() => {
                    const text = done + " / " + count_anal;
                    prdiv.find(".k-progress-status").text(text);
                }, 650);

                if (start_time) {
                    var time = Math.floor(((Date.now() - start_time) / (done) * d.count) / 1000);
                    $("#l_cas_a")[0].innerText = $("#l_progress_text2")[0].innerText + getTimeString(time);
                }

                performed += d.perform;

                var donetext = proces_podpisu == "analyza"
                    ? $("#l_progress_text4")[0].innerText
                    : $("#l_progress_text5")[0].innerText;

                donetext = donetext.replace("{0}", (performed));

                $("#l_done_a")[0].innerText = donetext;
            }

        </script>
    </telerik:RadScriptBlock>
</asp:Content>
