﻿<%@ Page Language="C#" MasterPageFile="~/main.master" AutoEventWireup="true" Inherits="Dochazka_Uzaverka" CodeBehind="Uzaverka.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControlsAlone" Namespace="KSProgram.WebControlsAlone" TagPrefix="wca" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadCodeBlock runat="server" ID="rcb">
        <script type="text/javascript">                     
            (function (global, undefined) {
                var ZPRDOCH = window.ZPRDOCH = window.ZPRDOCH || {},
                    progressBar,
                    CITAC = 0,
                    DATA = {},                    
                    POCET_PODNIKU = 0,
                    POCET_ZAZNAMU = 0,
                    ERROR=false

                ZPRDOCH.progressBar_load = function (sender, args) {
                    progressBar = sender;
                    $('#progressWrapper').css('visibility', 'hidden');
                }
                ZPRDOCH.zpracDoch = function (js) {
                    progressBar.set_value(0);
                    setTimeout(ZPRDOCH.zprZam(js), 0);
                }
                ZPRDOCH.zprZam = function (js) {
                    if (js.length == 0) {
                        radalert(message_zpracovani + ': ' + POCET_ZAZNAMU, 280, 145, "", null, null);
                        zpracovavam(false);
                        return;
                    }
                    $('#progressWrapper').css('visibility', 'visible');
                    zpracovavam(true);                   
                    DATA = js;
                    POCET_PODNIKU = DATA.length;
                    POCET_ZAZNAMU = DATA.reduce((sum, item) => sum + item.Item5, 0);
                    PROGRESS_BAR_STEP = 100 / POCET_ZAZNAMU;
                    CITAC = 0;
                    ERROR = false;
                    progressBar.set_minValue(0);
                    progressBar.set_maxValue(POCET_ZAZNAMU);                   
                    for (var i = 0; i < POCET_PODNIKU; i++) {                       
                        processItemsSequentially(DATA[i].Item4, DATA[i].Item2, DATA[i].Item3, DATA[i].Item1);
                    }
                }  

                function processItemsSequentially(items, rok, mes, id_podniku, index = 0) {
                    if (index >= items.length) {
                        zpracUzaverkaKonec(rok + "x" + mes, id_podniku);
                        return;
                    }
                    PageMethods.UzaverkaZam(
                        items[index].Os_cislo,
                        items[index].Cislo_pom,
                        rok,
                        mes,
                        function (result) {                           
                            let r = JSON.parse(result);
                            if (r.Code >= 499) {                                
                                onPageMethodError(r.Message);
                                ERROR = true;
                                return;
                            }
                            CITAC++;
                            setTimeout(progressBar.set_value(CITAC), 0); 
                            if (CITAC % 50 == 0)
                               resetSessionTimeout();
                            processItemsSequentially(items, rok, mes, id_podniku, index + 1);
                        },
                        onPageMethodError
                    );
                }
               
                function zpracovavam(sw) {
                    var sw_tl = "none";
                    var sw_tl_n = "block";
                    if (sw) {
                        sw_tl = "none"; sw_tl_n = "block";
                    }
                    else {
                        sw_tl = "block"; sw_tl_n = "none";
                    }
                    $('#tlacitko').css('display', sw_tl);
                    $('#tlacitko_nahrada').css('display', sw_tl_n);
                }

                function onPageMethodError(err) {
                    if (err) {                      
                        ERROR = true;
                        zpracovavam(false);
                        $('#progressWrapper').css('visibility', 'hidden');
                        KSMaster.showError(err, "Uzávěrka docházky", 400, 300)
                    }
                }                
                
                function zpracUzaverkaKonec(obdobi, id_podniku) {
                    var d = [];
                    var item = { "obdobi": obdobi };
                    d.push(item);
                    item = { "id_podniku": id_podniku };
                    d.push(item);
                    var data_send = JSON.stringify(d);
                    $.ajax({
                        type: "POST",
                        url: "Uzaverka.aspx/UzaverkaKonec",
                        data: "{data:'" + data_send + "'}",
                        async: false,
                        contentType: "application/json",
                        dataType: "json",
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(xhr.status);
                            alert(xhr.responseText);
                            alert(thrownError);
                        },
                        success: function (msg) {
                            let r=JSON.parse(msg.d);
                            zpracovavam(false);
                            $('#progressWrapper').css('visibility', 'hidden');
                            let vc = $find("<%= vice_ico.ClientID %>");
                            if (r.Code == 501) {
                                radalert(r.Message, 320, 145, "", null, null);
                            }
                            else
                            {
                                resetSessionTimeout();                              
                                if (vc != null && vc != undefined)
                                    vc.get_masterTableView().rebind();
                                else {                                   
                                    let lab = document.getElementById('ctl00_HlavniOblast_TitledPanel1_ObdobiText');
                                    if (lab != undefined && lab != null) {
                                        lab.innerHTML = r.Message;
                                        document.getElementById('<%= HiddenObdobiText.ClientID %>').value = r.Message;
                                    }                                   
                                }                               
                            }
                        }
                    });
                }
            })(window);
        </script>
    </telerik:RadCodeBlock>

   <asp:HiddenField ID="HiddenObdobiText" runat="server" />
    <asp:MultiView runat="server" ID="mv">
        <asp:View runat="server" ID="mv0">
            <wca:TitledPanel runat="server" ID="TitledPanel1">
                <TitleTemplate>
                    <asp:Label runat="server" ID="titletempl" Text="[%Měsíční uzávěrka%]"></asp:Label>
                </TitleTemplate>
                <ContentTemplate>
                    <table style="width: 286px;">
                        <tr>
                            <td style="text-align: center;">
                                <table>
                                    <tr>
                                        <td>
                                            <asp:Label runat="server" ID="popisek" Text="[%Aktuální období%] "></asp:Label>
                                        </td>
                                        <td>                                           
                                            <wc:TRadObdobi runat="server" ID="Obdobi" EnableTyping="False">
                                                <Picker ID="Picker1" runat="server">
                                                    <DateInput ReadOnly="true">
                                                    </DateInput>
                                                </Picker>
                                            </wc:TRadObdobi>
                                            <asp:Label runat="server" ID="ObdobiText" Font-Size="Medium" ForeColor="#990000"></asp:Label>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align: center;">
                                <br />
                                <div id="tlacitko">
                                    <telerik:RadButton ID="LinkButton1" runat="server" Text="[%Spustit uzávěrku%]" OnCommand="LinkButton1_Command" SkinID="button"></telerik:RadButton>
                                </div>
                                 <div id="tlacitko_nahrada" style="display: none">
                                    <telerik:RadButton Enabled="false" ID="TLinkButton1" Width="100" runat="server" SkinID="button" Text="[%Zpracovávám%]..."></telerik:RadButton>
                                </div>
                                <br />
                                <br />
                                <asp:Label ID="Label_mess" runat="server"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </ContentTemplate>
            </wca:TitledPanel>
        </asp:View>
        <asp:View runat="server" ID="mv1">
            <table>
                <tr>
                    <td>
                        <wc:TRadGrid runat="server" ID="vice_ico" OnNeedDataSource="vice_ico_NeedDataSource" MasterTableView-Caption="[%Uzávěrka%]">
                            <GroupingSettings CaseSensitive="False"></GroupingSettings>

                            <MasterTableView AutoGenerateColumns="false">
                                <Columns>
                                    <telerik:GridBoundColumn DataField="id" HeaderText="Id"></telerik:GridBoundColumn>
                                    <telerik:GridBoundColumn DataField="nazev" HeaderText="[%Název podniku%]"></telerik:GridBoundColumn>
                                    <telerik:GridBoundColumn DataField="obdobi" HeaderText="[%Aktuální období%]" DataFormatString="{0:MMMM yyyy}"></telerik:GridBoundColumn>
                                    <telerik:GridTemplateColumn DataField="provest" HeaderText="[%Spustit uzávěrku%]">
                                        <ItemTemplate>
                                            <asp:CheckBox runat="server" ID="check_provest" Visible='<%# Convert.ToBoolean(Eval("pristup")) %>'></asp:CheckBox>
                                            <asp:Label runat="server" ID="lab_nepritup" Style="color: Red;" Text="[%Nepřístupný podnik%]" Visible='<%# !Convert.ToBoolean(Eval("pristup")) %>'></asp:Label>
                                        </ItemTemplate>
                                        <ItemStyle HorizontalAlign="Center" />
                                    </telerik:GridTemplateColumn>
                                </Columns>
                            </MasterTableView>
                        </wc:TRadGrid>
                    </td>
                </tr>
                <tr>
                    <td style="text-align: right; padding-top: 10px;">
                        <div id="tlacitko">
                            <wc:TRadButton ID="LinkButton2" runat="server" Text="[%Spustit uzávěrku%]" OnCommand="LinkButton2_Command2"  ></wc:TRadButton>
                         </div>
                         <div id="tlacitko_nahrada" style="display: none">
                            <kspwc:TLinkButton Enabled="false" ID="TLinkButton1" Width="100" runat="server" SkinID="button" Text="[%Zpracovávám%]..."></kspwc:TLinkButton>
                        </div>
                    </td>
                </tr>
            </table>            
        </asp:View>
    </asp:MultiView>
    <div id="progressWrapper">
    <telerik:RadProgressBar EnableViewState="false" ChunksCount="10" ID="rpbFormCompleteness" runat="server" BarType="Percent" ShowLabel="false">
        <ClientEvents OnLoad="ZPRDOCH.progressBar_load" />
        <AnimationSettings Duration="300" EnableChunkAnimation="true" />
    </telerik:RadProgressBar>
</div>
</asp:Content>

