﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DashBoardPanel_Pozadavky.ascx.cs" Inherits="KSPortal.DashBoard.DashBoardPanel_Pozadavky" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<style type="text/css">
    table.ksDbPozTable > tbody > tr > td:nth-child(1) {
        width: 55%;
        height: 40px;
    }

        table.ksDbPozTable > tbody > tr > td:nth-child(1) a {
            position: absolute;
            margin-top: -17px;
            margin-left: -10px;
        }

    table.ksDbPozTable > tbody > tr > td:nth-child(2) {
        width: 25%;
        z-index: 1;
        background: white;
        position: relative;
        padding-left: 10px;
    }

    table.ksDbPozTable > tbody > tr > td:nth-child(3) {
        width: 20%;
        z-index: 1;
        background: white;
        position: relative;
    }

    div.ksDbPozPager {
        display: flow-root;
        border-bottom: 1px var(--kscolor1) solid;
    }
        div.ksDbPozPager > div {
            float: right;
            margin-bottom: 5px;
            margin-left: 4px;
        }

    .ksDbPozTable, .ksDbPozTable a {
        color: var(--kscolor2text);
    }

    .ksDbPozDat {
        width: unset;
    }

        .ksDbPozDatOd {
            margin-right: 5px;
        }

        .ksDbPozDat .RadInput, .ksDbPozDat .RadInput > input {
            border-radius: 5px;
        }

            .ksDbPozDat .RadInput > input {
                text-align: center;
            }
</style>
<telerik:RadScriptBlock ID="RSB2" runat="server">
    <script type="text/javascript">
        //<![CDATA[

        function RD_Pozadavky_ClientDockPositionChanged(sender, args) {
            //var table = $find('TRG_pozadavky.ClientID');
            //resizeColumnsDash(table);
        }

        function ParameterMapPozadavky(sender, args) {
            var TRMYP_dat_od = $find("<%= TRMYP_dat_od.ClientID %>").get_selectedDate();
            var TRYMP_dat_do = $find("<%= TRMYP_dat_do.ClientID %>").get_selectedDate();
            var TRCB_typ = $find("<%= TRCB_typ.ClientID %>");

            var pars = {
                datum_od: null,
                datum_do: null,
                typy: []
            };

            if (TRMYP_dat_od) {
                pars.datum_od = [TRMYP_dat_od.getMonth() + 1, TRMYP_dat_od.getFullYear()];
            }
            if (TRYMP_dat_do) {
                pars.datum_do = [TRYMP_dat_do.getMonth() + 1, TRYMP_dat_do.getFullYear()];
            }

            if (TRCB_typ) {
                if (TRCB_typ.get_checkAllCheckBox().checked) {
                    pars.typy.push("vse");
                }
                else {
                    var checkedItems = TRCB_typ.get_checkedItems()
                    checkedItems.forEach(typ => pars.typy.push(typ.get_value()));
                }
            }

            var s = JSON.stringify(pars);
            if (args.get_type() == "read") {
                args.set_parameterFormat(s);
            }
        }
        function ParsePozadavky(sender, args) {
            var response = args.get_response().d;
            if (response) {
                args.set_parsedData(response.Data);
            }
        }

        //function TRG_pozadavky_GridCreated(sender, args) {
        //    resizeColumnsDash(sender);
        //}

        //function resizeColumnsDash(grid) {
        //    var columns = grid.get_masterTableView().get_columns();
        //    for (var i = 0; i < columns.length; i++) {
        //        columns[i].resizeToFit(false, false);
        //    }
        //    grid.repaint();
        //}

        //function TRG_pozadavky_DataBound(sender, args) {
        //    resizeColumnsDash(sender);
        //}

        function RCDS_pozadavky_RequestStart(sender, args) {
            setTimeout(function () {
                KSMaster.LoadingPanel_TopLeft.show("<%= this.Parent.Parent.ClientID%>");
            }, 0);
        }

        function RCDS_pozadavky_RequestEnd(sender, args) {
            setTimeout(function () {
                KSMaster.LoadingPanel_TopLeft.hide("<%= this.Parent.Parent.ClientID%>");
            }, 0);
        }

        function RLV_pozadavky_DataBound(sender, args) {
            var pageIndexSlider = $find("<%= RS_pager.ClientID%>");
            pageIndexSlider.set_value(sender.get_currentPageIndex());
            pageIndexSlider.set_maximumValue((sender.get_virtualItemCount() - 1) / sender.get_pageSize() | 0);
            if (sender.get_virtualItemCount() <= sender.get_pageSize()) {
                pageIndexSlider.get_element().hidden = true;
            }
            else {
                pageIndexSlider.get_element().hidden = false;
            }
            KSMaster.LoadingPanel_TopLeft.hide(sender._element.id);
        }

        function RS_pager_ValueChanged(sender, args) {
            var listView = $find("<%= RLV_pozadavky.ClientID%>");
            listView.page(args.get_newValue());
        }

        function _emptyPozadavky() {
            return '<%=KSProgram.Obecne.ReadGlobalResource.ZmenaTextu("[%Žádné požadavky k vyřízení%]")%>';
        }

        function showTypyPozMenu(sender, args) {
            var contextMenu = $find('<%= RCM_new_typy.ClientID %>');
            if (contextMenu) {
                var currentLocation = $telerik.getBounds(sender.get_element());
                contextMenu.showAt(currentLocation.x, currentLocation.y + currentLocation.height);
            }
        }
        function RCM_new_typy_ItemClicked(sender, args) {
            location.replace("./Pozadavky/PozadavekDetail.aspx?typ=" + args.get_item().get_value());
        }

        function seznamRedirect() {
            location.replace("./Pozadavky/Pozadavky2.aspx");
        }

        function FilterChanged(sender, args) {
            var lv = $find("<%= RLV_pozadavky.ClientID%>");
            var ds = $find("<%= RCDS_pozadavky.ClientID%>");

            ds.set_data([]);
            ds.fetch(function (fetchArgs) {
                lv.set_dataSource(fetchArgs.get_data());
                lv.rebind();
            });
        }

        var checkchanged = false;
        function TRCB_typ_ItemChecked(sender, args) {
            checkchanged = true;
        }

        function TRCB_typ_DropDownClosed(sender, args) {
            if (checkchanged) {
                checkchanged = false;
                FilterChanged(sender, args);
            }
        }
        Sys.Application.add_load(function () {
            $telerik.$(".ksDbPozCombo .RadComboBoxDropDown").mouseleave(function () {
                $find("<%= TRCB_typ.ClientID %>").hideDropDown();
            });
        });
    </script>
</telerik:RadScriptBlock>
<asp:ObjectDataSource ID="ODS_poz_typy" runat="server"
    SelectMethod="GetTypy" TypeName="KSProgram.Pozadavky.PozadavkyTypy">
    <SelectParameters>
        <asp:Parameter DefaultValue="false" Name="vcetne_vse" Type="Boolean" />
        <asp:Parameter DefaultValue="true" Name="vcetne_dochazka" Type="Boolean" />
        <asp:Parameter DefaultValue="false" Name="emptyRow" Type="Boolean" />
    </SelectParameters>
</asp:ObjectDataSource>
<div class="ksDbPozPager">
    <kspwc:TRadButton ID="TRB_add_new" runat="server" Text="[%Nový%]"
        AutoPostBack="False" OnClientClicked="showTypyPozMenu">
        <Icon PrimaryIconCssClass="fi fi-add"></Icon>
    </kspwc:TRadButton>
    <kspwc:TRadButton ID="TRadButton1" runat="server" Text="[%Přehled%]"
        AutoPostBack="False" OnClientClicked="seznamRedirect">
        <Icon PrimaryIconCssClass="fi fi-list"></Icon>
    </kspwc:TRadButton>
    <telerik:RadSlider ID="RS_pager" runat="server" MaximumValue="0" ItemType="Tick" OnClientValueChanged="RS_pager_ValueChanged"
        ToolTip="[%Stránkování%]" DragText="[%Táhnout%]" DecreaseText="[%Předchozí strana%]" IncreaseText="[%Další strana%]"
        CssClass="ksDbPozSlider">
    </telerik:RadSlider>
    <kspwc:TRadComboBox runat="server" ID="TRCB_typ" CloseDropDownOnBlur="true" DropDownAutoWidth="Enabled" CheckBoxes="true" EnableCheckAllItemsCheckBox="true" Label="[%Typ%]:"
        DataSourceID="ODS_poz_typy" DataValueField="typ" DataTextField="typ_text" CssClass="ksDbPozCombo"
        OnClientItemChecked="TRCB_typ_ItemChecked" OnClientCheckAllChecked="TRCB_typ_ItemChecked" OnClientDropDownClosed="TRCB_typ_DropDownClosed"
        OnDataBound="TRCB_typ_DataBound">
        <Localization AllItemsCheckedString="[%Vše%]" />
    </kspwc:TRadComboBox>
    <div>
        <kspwc:TRadMonthYearPicker ID="TRMYP_dat_od" runat="server" Height="28" ShowPopupOnFocus="True" ToolTip="[%Období od%]" CssClass="ksDbPozDat ksDbPozDatOd">
            <ClientEvents OnDateSelected="FilterChanged" />
            <DatePopupButton CssClass="hidden" />
            <DateInput Label="[%Období%]:" Width="95"></DateInput>
        </kspwc:TRadMonthYearPicker>
        <kspwc:TRadMonthYearPicker ID="TRMYP_dat_do" runat="server" Height="28" ShowPopupOnFocus="True" ToolTip="[%Období do%]" CssClass="ksDbPozDat">
            <ClientEvents OnDateSelected="FilterChanged" />
            <DatePopupButton CssClass="hidden" />
            <DateInput Label="[%až%]" Width="95"></DateInput>
        </kspwc:TRadMonthYearPicker>
    </div>

</div>
<telerik:RadListView runat="server" ID="RLV_pozadavky" AllowPaging="true" PageSize="6" ItemPlaceholderID="ItemsPlaceHolder" ClientDataSourceID="RCDS_pozadavky">
    <LayoutTemplate>
        <div id="ItemsPlaceHolder" runat="server">
        </div>
    </LayoutTemplate>
    <ClientSettings>
        <ClientEvents OnDataBound="RLV_pozadavky_DataBound" />
        <DataBinding>
            <ItemTemplate>
                <fieldset class="ksDbLiFs">
                    <legend>#= typ #</legend>
                    <table class="ksDbPozTable">
                        <tr>
                            <td>
                                <a href="#= url #" class="kstlacitko" style="color: black !important"><i style="font-size: 15px;" class="#= ikona #"></i> #= text #</a>
                            </td>
                            <td>
                                <span>#= jmeno + ' ' + prijmeni #</span>
                            </td>
                            <td>
                                <span>#= stav #</span>
                            </td>
                        </tr>
                    </table>
                </fieldset>
            </ItemTemplate>
            <EmptyDataTemplate>
                <fieldset class="ksDbLiFs" style="border:none;">
                    <div>
                        <p class="zadneBull">
                            <i class="fi fi-document-signed"></i>
                            <label>#=_emptyPozadavky()#</label>
                        </p>
                    </div>
                </fieldset>
            </EmptyDataTemplate>
        </DataBinding>
    </ClientSettings>
</telerik:RadListView>
<asp:ObjectDataSource runat="server" ID="ODS_new_typy" SelectMethod="GetTypyNabidkaZalozeni"
    OldValuesParameterFormatString="original_{0}" TypeName="KSProgram.Pozadavky.PozadavkyTypy">
</asp:ObjectDataSource>
<telerik:RadContextMenu ID="RCM_new_typy" runat="server"
    DataSourceID="ODS_new_typy"
    DataTextField="typ_text" DataValueField="typ"
    OnClientItemClicked="RCM_new_typy_ItemClicked">
</telerik:RadContextMenu>
<telerik:RadClientDataSource ID="RCDS_pozadavky" runat="server" AllowBatchOperations="false">
    <ClientEvents OnDataParse="ParsePozadavky" OnRequestStart="RCDS_pozadavky_RequestStart" OnRequestEnd="RCDS_pozadavky_RequestEnd" OnRequestFailed="RCDS_pozadavky_RequestEnd" OnCustomParameter="ParameterMapPozadavky" />
    <DataSource>
        <WebServiceDataSourceSettings>
            <Select Url="DashBoard/WebMethods.aspx/GetPozadavky" EnableCaching="false" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
        </WebServiceDataSourceSettings>
    </DataSource>
    <Schema>
        <Model ID="id_poz">
            <%-- ID neoznačuje id modelu ale sloupec obsahující klíč--%>
            <telerik:ClientDataSourceModelField FieldName="id_poz" DataType="Number" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="prijmeni" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="jmeno" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="typ" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="text" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="stav" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="datum_od" DataType="Date" Editable="true" />
            <telerik:ClientDataSourceModelField FieldName="datum_do" DataType="Date" Editable="true" />
        </Model>
    </Schema>
</telerik:RadClientDataSource>
