﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOodmenysl.ascx.cs" Inherits="KSPortal.Controls.ZadostOodmenysl" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>

<telerik:RadCodeBlock ID="RadCodeBlock1" runat="server">
    <style type="text/css">
        .oznBorder {
            padding: 1px !important;
            padding-right:5px !important;
            width: 60px;
            background-color: lightblue;
        }

        .pznColl {
            padding-left: 0px !important;
            padding-right: 0px !important;
            border-style:none !important;
        }
        .pznCollHeader{
            border-left-style:none !important;
        }

        .rgBatchContainer input {
            width: 50px !important;
            background-color: white;
            border-style: none;
        }

        .gridWidth {
            table-layout: fixed !important;
        }

        table.table_hodn td {
            padding: 3px;
        }

        .rmLeftImage {
            background-image: url("") !important;
        }
        .castka_wrapper
        {
             width:100% !important;
        }
        .rgBatchContainer input
        {
            width:100% !important;
        }
        .RadInput{
            width:100% !important;
        }

        .RadInputMultiline {
            width: 100% !important;
        }

        .rcbTemplate {
            padding: 10px 10px 10px 100px !important;
            border: 0 !important;
            border-bottom: 1px solid #cccccc !important;
            *zoom: 1;
        }

            .rcbTemplate:after {
                content: "";
                height: 0;
                clear: both;
                display: block;
            }

            .rcbTemplate .imageWrap {
                margin: 0 0 0 -85px;
                float: left;
            }

                .rcbTemplate .imageWrap img {
                    border-radius: 5px;
                    border: 1px solid #ccc;
                    max-width: 58px;
                    max-height: 58px;
                }


            .rcbTemplate .personDetails {
                margin: 0;
                padding: 0;
                list-style: none;
            }

            .rcbTemplate .name {
                font-weight: bold;
            }

            .rcbTemplate .misto {
                font-size: small;
            }

            .rcbTemplate .os_cislo {
                font-weight: bold;
            }  
            .hidden{
                display:none;
                position:absolute;
            }
            .show{
                display:block;
                position:absolute;
                z-index:1000 !important;
            }

            #RadWindowWrapper_ctl00_HlavniOblast_UserControl_RW_budgety .rgCaption
            {
                display:none;
            }            

            .RadInput_Metro .riTextBox{
                padding: 0 !important;
            }

            .rgFilterRow > td,  .rgEditRow > td
            {
                padding-left:2px !important;
                padding-right:2px !important;
            }

    </style>
    <script type="text/javascript">
        var zakazEditace = false;
        var typ = "";
        var idPozadavku = -1;
        var castka_text = "";
        var dny_text = "";
        var hodiny_text = "";
        var sazba_text = "";
        var chyba = "";
        var obdobi = "";
        var rowIndex = -1;
        var kod = 0;
        var os_cislo = 0;
        var cislo_pom = -1;
        var useBudgety = false;
        var saveStateWBTimeOut;
        var disable_header_menu = false;
       

        function OnBatchEditCellValueChanging(sender, args) {
            var grid = sender;           
            var columnUniqueName = args.get_columnUniqueName();
            var editorValue = args.get_editorValue();         

            var masterTableView = grid.get_masterTableView();
            var editorValue = args.get_editorValue();
            var rowIndex = args.get_row().id.split("__")[1];

            var dataItem = masterTableView.get_dataItems()[rowIndex];
            var os_cislo = dataItem.getDataKeyValue("os_cislo");
            var cislo_pom = dataItem.getDataKeyValue("cislo_pom");
            editorValue = editorValue.replace(",", ".");
            editorValue = editorValue.replace(/\s/g, "");
            if ((editorValue != "") && (isNaN(editorValue))) {
                args.set_cancel(true);
                return;
            }          

            var vazba =  masterTableView.get_dataItems()[rowIndex].getDataKeyValue("id_vazby");

            var budget_id = null;
            var arr = columnUniqueName.split("_");
            if (arr.length == 2) {                
                if ((arr[1] == "dny") || (arr[1] == "hodiny") || (arr[1] == "castka") || (arr[1] === "sazba")) {
                    if (arr[1] == "dny") {
                        if (parseFloat(editorValue) > 99) {
                            args.set_cancel(true);
                            return;
                        }
                    }
                    else if (arr[1] == "hodiny") {
                        if (parseFloat(editorValue) > 999) {
                            args.set_cancel(true);
                            return;
                        }
                    }
                    else if (arr[1] == "castka" || arr[1] == "sazba") {
                        if (parseFloat(editorValue) > 9999999999999999) {
                            args.set_cancel(true);
                            return;
                        }
                        //načtu budget id                        
                        if (masterTableView.getColumnByUniqueName(arr[0] + "_budget")) {
                            var v = $telerik.$(dataItem.get_cell(arr[0] + "_budget")).text().trim();
                            if (v != "") {                                
                                budget_id = v.split("-")[0];
                            }
                        }                        
                    }
                    var co = arr[1];
                    if (vazba != undefined)
                        co += "|" + vazba;
                    var err = SendData(os_cislo, cislo_pom, arr[0], co, editorValue, idPozadavku, typ, "", budget_id);
                    if (err != "") {
                        args.set_cancel(true);
                        return;
                    }
                }
            }
        }
        function SendData(os_cislo, cislo_pom, kod, co, hodnota, id_pozadavku, typ, filterExpression, budget_id, notShowError) {
            var d = [];
            var item = { "os_cislo": os_cislo }; d.push(item);
            item = { "cislo_pom": cislo_pom }; d.push(item);
            item = { "kod": kod }; d.push(item);
            item = { "co": co }; d.push(item);
            item = { "hodnota": hodnota }; d.push(item);
            item = { "id_pozadavku": id_pozadavku }; d.push(item);
            item = { "typ": typ }; d.push(item);
            item = { "filterExpression": filterExpression }; d.push(item);
            item = { "budget_id": budget_id }; d.push(item);
            var data_send = JSON.stringify(d);
            var errMess = "";
            if (useBudgety) {
                $.ajax({
                    type: "POST",
                    url: KSMaster.baseUrl + "/Controls/ZadostOodmenysl_pom.aspx/TestujZustatekBudgetu",

                     data: "{data:'" + data_send + "'}",
                     async: false,
                     contentType: "application/json",
                     dataType: "json",
                     error: function (xhr, ajaxOptions, thrownError) {
                         alert(xhr.status);
                         alert(xhr.responseText);
                         alert(thrownError);
                     },
                     success: function (msg) {                       
                         errMess = msg.d;                           
                     }
                 });

            }          
            if (errMess === "") {

                $.ajax({
                    type: "POST",
                    url: KSMaster.baseUrl + "/Controls/ZadostOodmenysl_pom.aspx/Save",

                    data: "{data:'" + data_send + "'}",
                    async: false,
                    contentType: "application/json",
                    dataType: "json",
                    error: function (xhr, ajaxOptions, thrownError) {
                        alert(xhr.status);
                        alert(xhr.responseText);
                        alert(thrownError);
                    },
                    success: function (msg) {
                        if (useBudgety) {
                            retrieveOdmenyGrid();
                        }
                    }
                });
            }
            else {               
                if (!notShowError)
                    radalert(errMess, 350, 150, "", null, null);
            }
            return errMess;
        }

        function TestujUloz(os_cislo, id_mista) {
            var d = [];
            var item = { "os_cislo": os_cislo }; d.push(item);
            item = { "id_mista": id_mista }; d.push(item);
            item = { "idPozadavku": idPozadavku }; d.push(item);
            var data_send = JSON.stringify(d);
            $.ajax({
                type: "POST",
                url: "<%=this.ResolveUrl(@"~/Controls/ZadostOodmenysl_pom.aspx/TestujUloz")%>",
                data: "{data:'" + data_send + "'}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(xhr.status);
                    alert(xhr.responseText);
                    alert(thrownError);
                },
                success: function (msg) {
                    if (msg.d == "") {
                        $find('<%= RadGrid1.ClientID %>').get_masterTableView().rebind();
                    }
                    else
                        radalert(msg.d, 0, 0, "", null, null);
                }
            });
        }

        function HeaderShowing(sender, args) {
            var cell = null;
            id_clicked = args.get_gridColumn()._data.UniqueName;
            if (id_clicked.indexOf("_castka") > -1) {
                var kod = id_clicked.split("_")[0];
                cell=$find('<%= RadGrid1.ClientID %>').get_masterTableView().getColumnByUniqueName(kod + "_budget");
            } 
           
            args.get_menu().get_items().forEach(function (item) {
                if (disable_header_menu) 
                    item.set_visible(false);              
                else
                {
                    if (item.get_attributes().getAttribute("Co") === "hrom") {
                        item.set_visible(!zakazEditace);
                        if (item.get_visible() == true && cell != null)
                            item.set_enabled(false);
                    }
                }
            });            
        }

        function onMenuClicked(sender, args) {
            var par = args._item._attributes._data["Co"];
            if (par == "hrom") {
                $find('<%= rw_hrom_zmena.ClientID %>').show();
            } else if (par == "pozn") {
                showOdmenyPoznamka();
            }
        }

        function rb_hrom_zmena(sender, args) {
            var arr = id_clicked.split("_");
            var hodnota = $find("<%= rntb_hodnota.ClientID %>").get_value();
            var filter = document.getElementById('<%= gridFilterExpression.ClientID %>').value;          
            SendData(-1, -1, arr[0], arr[1], hodnota, idPozadavku, typ, filter, null);
            
          
            $find('<%= RadGrid1.ClientID %>').get_masterTableView().rebind();
        }

        function rw_hrom_zmena_clientShow(sender, args) {
            $find("<%= rntb_hodnota.ClientID %>").focus();
        }
        function rw_hrom_zmena_odmeny_beforeShow(sender, args) {
            let d = { kod: 0, text: "", puvodni_text: "" };
            _rozdel(d);
            document.getElementById('<%=lab_zmena_kod.ClientID%>').textContent = d.kod;
            document.getElementById('<%=lab_zmena_typ_hodnoty.ClientID%>').textContent = d.text;

            $find("<%= rntb_hodnota.ClientID %>").set_value("");
        }

        function _rozdel(d) {
            var arr = id_clicked.split("_");
            d.text = "";
            if (arr[1] == "castka")
                d.text = castka_text
            else if (arr[1] == "hodiny")
                d.text = hodiny_text;
            else if (arr[1] == "dny")
                d.text = dny_text;
            else if (arr[1] == "sazba")
                d.text = sazba_text;

            d.kod = arr[0];
            d.puvodni_text = arr[1];
        }

        function rb_hrom_zmena_close_clientClicked(sender, args) {
            var oWindowCust = $find('<%= rw_hrom_zmena.ClientID %>');
            oWindowCust.close();
        }      
        function BatchEditOpening(sender, args) {
            if (zakazEditace) {
                args.set_cancel(true);
                return;
            }
            var colName = args.get_columnUniqueName();
            if ((colName == "os_cislo") || (colName == "cislo_pom") || (colName == "jmeno")) {
                args.set_cancel(true);
                return;
            }
            else if (colName.indexOf(kod + "_budget") > -1) {
                var fItem = sender.get_masterTableView().get_dataItems()[args.get_row().rowIndex - 1];
                var psl = fItem.getDataKeyValue(kod + "_budget_count");
                if (psl != undefined && psl != null) {
                    if (psl <= 1) {
                        args.set_cancel(true);
                        return;
                    }
                }
            }
            else {
                var fItem = sender.get_masterTableView().get_dataItems()[args.get_row().rowIndex - 1];
                var psl = fItem.getDataKeyValue("povolene_sloupce");
                if (psl.indexOf(colName) == -1) {
                    args.set_cancel(true);
                }
            }
        }

        function showSestavu() {
            var WSodmSestava = $find("<%= rw_sestava_odmeny.ClientID %>");
            if (WSodmSestava) {
                WSodmSestava.show();
                WSodmSestava.maximize();
            }
        }
        function showOdmenyPoznamka() {        
            var rw_odmeny_poznamka = $find("<%= rw_odmeny_poznamka.ClientID %>");
            let kod = 0; let text; var puvodni_text;
            if (rw_odmeny_poznamka) {
                let d = { kod: 0, text: "", puvodni_text: "" };
                _rozdel(d);
                var par_url = "?kod=" + d.kod + "&text=" + d.puvodni_text + "&idpozadavku=" + idPozadavku + "&typ=" + typ;
                rw_odmeny_poznamka._navigateUrl = "<%=this.ResolveUrl(@"~/Pozadavky/OdmenyPoznamka.aspx")%>" + par_url;

                SendData(-2, -2, d.kod, d.puvodni_text, zakazEditace, -1, typ, "", null);

                rw_odmeny_poznamka.show();
                rw_odmeny_poznamka.maximize();
                myF = setInterval(sentRebind, 100);

                var foto = KSMaster.Img_photo;
                if (foto != null) foto.classList.add("hidden");

                try { //JH 4.9.2023 - HID 68374
                    var WSezn = KSMaster.RW_seznam_zam;
                    WSezn.close();
                }
                catch { }

            }
        }

        function sentRebind() {
            var rw_odmeny_poznamka = $find("<%= rw_odmeny_poznamka.ClientID %>");
            if (rw_odmeny_poznamka) {
                var oManager = GetRadWindowManager();
                var oActive = oManager.getActiveWindow();
                if (oActive.GetContentFrame()?.contentWindow?.nacist != undefined) {
                    oActive.GetContentFrame().contentWindow.nacist();
                    clearInterval(myF);
                }
            }
        }
        function rw_odmeny_poznamka_clientClose(sender, args) {
            $find('<%= RadGrid1.ClientID %>').get_masterTableView().rebind();
        }

        function showNovyZam() {
            clearDropBox();
            var rw_novy = $find("<%= rw_novy.ClientID %>");
            rw_novy.show();
        }

        function rw_novy_clientClose(sender, args) {
            clearDropBox();
        }
        function clearDropBox() {
            var c = $find("<%=RadComboBox_zam.ClientID%>");
            c.hideDropDown();
            c.clearSelection();
            c._applyEmptyMessage();
        }

        function button_ok_OnClientClicked(sender, args) {
            var val = $find("<%=RadComboBox_zam.ClientID%>").get_value();
            if (val === "") return;

            var arr = val.split("_");
            testujUloz(arr[1], arr[0]);
            if (chyba) {
                jAlert(chyba);
                return;
            }
        }

        function testujUloz(oc, id) {
            chyba = "";
            TestujUloz(oc, id);
        }

        function CellClick(index, cell) {
            if (zakazEditace) return;

            rowIndex = index;
            kod = cell.split("_")[0];          

            var grid = $find("<%=RadGrid1.ClientID %>");
            var row = grid.get_masterTableView().get_dataItems()[rowIndex];
            var pocet = parseInt(row.getDataKeyValue(kod + "_budget_count"));
            if (pocet < 2 || pocet == null) {
                combo_budety_setvisible(false);
                return;
            }
            else {
                var txt = row.get_cell(cell).innerHTML;
                txt = txt.split("<")[0];
                combo_budety_setvisible(true, cell, index, txt);
                return;
            }
        }
        function combo_budety_setvisible(p, cell, index, value) {
            var combo = $find("<%= combo_budgety.ClientID %>");           

            var combo_el = combo.get_element();
           
            if (p) {
                var el = document.getElementById(cell + "_" + index);
                $(combo_el).detach().appendTo(el);

                $(combo_el).removeClass("hidden");
                $(combo_el).addClass("show");
                $(combo_el).offset($(el).offset());
                if (value != "") {
                    combo.set_text(value);
                    combo.set_value(value.split("-")[0]);
                }
            }
            else {
                combo.clearItems();
                combo.clearSelection();
                combo.set_text("");

                $(combo_el).removeClass("show");
                $(combo_el).addClass("hidden");
            }
        }
        function budget_OnClientBlur(sender, args) {
            combo_budety_setvisible(false);
        }
        function budget_OnClientSelectedIndexChanged(sender, args) {            
            row = rowByIndex();
            var oc = row.getDataKeyValue("os_cislo");
            var cp = row.getDataKeyValue("cislo_pom");           
            var err = SendData(oc, cp, kod, "id_budgetu", sender.get_value(), idPozadavku, typ, "", sender.get_value());
           
            if (err != "") {              
                var grid = $find("<%=RadGrid1.ClientID %>");
                var row = grid.get_masterTableView().get_dataItems()[rowIndex];
                var cell = row.get_cell(kod + "_castka");
                grid.get_batchEditingManager().changeCellValue(cell, "0");
            }            
            row.get_cell(kod + "_budget").innerHTML = sender.get_text();
        }

        function button_zavrit_onClientClicked(sender, args) {
            var rw_novy = $find("<%= rw_novy.ClientID %>");
            rw_novy.close();
        }
        function val_zakazy(sender, args) {            
            var id_pozadavku = $telerik.$("[id$='HF_id_poz']").get(0).value;
            var d = [];
            var item = { "id_pozadavku": id_pozadavku }; d.push(item);
            item = { "insert": (id_pozadavku==0)}; d.push(item);
            var data_send = JSON.stringify(d);
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/Controls/ZadostOodmenysl_pom.aspx/TestujZakazy",
                data: "{data:'" + data_send + "'}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(xhr.status);
                    alert(xhr.responseText);
                    alert(thrownError);
                },
                success: function (msg) {
                    if (msg.d == "") {                       
                        args.IsValid = true;
                    }
                    else {                       
                        args.IsValid = false;
                        sender.errormessage = msg.d;
                    }
                }
            });
        }

        var oldPozadavekSaveClicking = !oldPozadavekSaveClicking ? KSMaster.onPozadavekSaveClicking : oldPozadavekSaveClicking;
        KSMaster.onPozadavekSaveClicking = function (sender, args) {
            oldPozadavekSaveClicking.apply(sender, args);
            var isValid = Page_ClientValidate();

            if (!isValid) {
                var RW_Errors = $find('<%= RW_Errors.ClientID %>');
                RW_Errors.show();
                RW_Errors.autoSize();
            }
        };
        KSMaster.onPozadavekSaveClicking.prototype = oldPozadavekSaveClicking.prototype;

        function RW_Errors_close(sender, args) {
            var RW_Errors = $find('<%= RW_Errors.ClientID %>');
            RW_Errors.close();
        }

        function budget_clientRequesting(sender, args) {
            row = rowByIndex();

            var bd_all = row.getDataKeyValue(kod + "_budgety_all");
            var bdarr = bd_all.split("|");

            sender.trackChanges();
            for (var i = 0; i < bdarr.length; i++) {
                var id = bdarr[i].split("-")[0];
                var item = new Telerik.Web.UI.RadComboBoxItem();

                item.set_text(bdarr[i]);
                item.set_value(id);

                sender.get_items().add(item);
            }
            sender.commitChanges();
            args.set_cancel(true);
        }
        function rowByIndex() {
            var Rows = $find('<%= RadGrid1.ClientID %>').get_masterTableView().get_dataItems();
            return Rows[rowIndex];
        }
        function budget_OnClientDropDownClosed(sender, args) {
            sender.clearItems();
            sender.trackChanges();
        }
        function retrieveOdmenyGrid() {           
                getOdmenyData();
        }
        function getOdmenyData() {
            if (useBudgety) {
                $find("<%= RALP_TRadGrid.ClientID %>").show("<%= TRadGrid_budgety.ClientID %>");
                var grid = $find("<%= TRadGrid_budgety.ClientID %>");
                if (grid) {
                    var tableView = grid.get_masterTableView();
                    if (tableView != null) {                       
                        PageMethods.GetBudgetyRekap(KSMaster.idPozadavku, !zakazEditace, updateOdmenyGrid);
                    }
                }                
            }
        }
        function updateOdmenyGrid(result) {
            var tableView = $find("<%= TRadGrid_budgety.ClientID %>").get_masterTableView();
            tableView.set_dataSource(result.Data);
            tableView.dataBind();
            var wnd = $find("<%= RW_budgety.ClientID %>");
            if (wnd.isClosed())
                wnd.show();

            $find("<%= RALP_TRadGrid.ClientID %>").hide("<%= TRadGrid_budgety.ClientID %>");

            var rw = $find('<%= RW_budgety.ClientID%>');
            RW_budgety_OnClientResize(rw);
        }
        function load() {
            retrieveOdmenyGrid();
            combo_budety_setvisible(false);
            
            $("#"+"<%= RadGrid1.ClientID %>"+" .rgFilterBox").on("keydown", function (e, source) {
                if (e.which == 13) {                   
                    var arr = $("#" + e.target.id)[0].alt.split(" ");                  
                    if (arr.length == 3) {                      
                        var col = $find("<%= RadGrid1.ClientID %>").get_masterTableView().getColumnByUniqueName(arr[1]);
                        fireFilterCommand("<%= RadGrid1.ClientID %>", arr[1], col._data.Acff, document.getElementById(e.target.id), e);
                    }                                    
                }               
            });
        }        
        function TRadGrid_budgety_refresh(sender, args) {           
            getOdmenyData();
        }
       
        function RW_budgety_OnClientResize(sender, args) {
            SaveWindowPos();
            var bounds = sender.getWindowBounds();
            var grid = $find('<%= TRadGrid_budgety.ClientID%>');
            grid.get_element().style.height = (bounds.height - 80) + "px";
            grid.repaint();
        }
        function RW_budgety_OnClientShow(sender, args) {           
            var pos = $get("<%=HF_BudgetyWindow.ClientID %>").value;// = JSON.stringify(wndBounds);
            if (pos != "") {
                var rw = $find('<%= RW_budgety.ClientID%>');             
                var bnd = $.parseJSON(pos);
                rw.moveTo(bnd.x + "px", bnd.y + "px");
                setTimeout(function(){
                    rw.setSize(bnd.width, bnd.height);                    
                    RW_budgety_OnClientResize(sender);
                }, 100);
            }
        }

        function SaveWindowPosLocal() {
            var wndBounds = $find('<%= RW_budgety.ClientID%>').getWindowBounds();           
            $get("<%=HF_BudgetyWindow.ClientID %>").value=JSON.stringify(wndBounds);
        }

        function SaveWindowPos() {           
            SaveWindowPosLocal();        
        }

        function RW_budgety_OnClientDragEnd(sender, args) {
            SaveWindowPos();
        }

        function val_poznamky(sender, args) {           
            var id_pozadavku = $telerik.$("[id$='HF_id_poz']").get(0).value;
            var d = [];
            var item = { "id_pozadavku": id_pozadavku }; d.push(item);
            item = { "insert": (id_pozadavku == 0) }; d.push(item);
            var data_send = JSON.stringify(d);
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/Controls/ZadostOodmenysl_pom.aspx/TestujPoznamky",
                data: "{data:'" + data_send + "'}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(xhr.status);
                    alert(xhr.responseText);
                    alert(thrownError);
                },
                success: function (msg) {
                    if (msg.d == "") {
                        args.IsValid = true;
                    }
                    else {
                        args.IsValid = false;
                        sender.errormessage = msg.d;
                    }
                }
            });
        }      



        Sys.Application.add_load(load);
    </script>
</telerik:RadCodeBlock>
<asp:HiddenField runat="server" ID="HF_BudgetyWindow" EnableViewState="true" />
<input type="hidden" id="gridFilterExpression" runat="Server" /> 
<div style="padding-bottom:5px;">
    <asp:Label runat="server" ID="lab_zamek_info" Text="" Font-Size="Larger" ForeColor="Red"></asp:Label>    
    <kspwc:TRadButton CssClass = "kstlacitko" UseSaveSetting="true" AutoPostBack="true" runat="server" ID="rb_jen_s_hodnotami" Text="[%Zaměstnanci s pořízenými hodnotami%]" ToggleType="CheckBox" OnCheckedChanged="rb_jen_s_hodnotami_CheckedChanged" >
        <ToggleStates>
            <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox" />
            <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square" />
        </ToggleStates>
    </kspwc:TRadButton>
    <kspwc:TRadButtonPrimiPodrizeni runat="server" ID="primi_podriz" UseSaveSetting="true" OnCheckedChanged="primi_podriz_CheckedChanged" OnPreRender="primi_podriz_PreRender"></kspwc:TRadButtonPrimiPodrizeni>
 </div>
<kspwc:TRadGrid MarginWidth="10" ID="RadGrid1" runat="server" OnNeedDataSource="RadGrid1_NeedDataSource" AllowAutomaticDeletes="False" DefaultFilter="false"
    AllowAutomaticUpdates="false" AllowPaging="True" OnInsertCommand="RadGrid1_InsertCommand" OnSortCommand="RadGrid1_SortCommand"  
    AutoGenerateColumns="False" EnableColumnsViewState="true" OnBatchEditCommand="RadGrid1_BatchEditCommand" OnLoad="RadGrid1_Load"   OnItemDataBound="RadGrid1_ItemDataBound" AutoFilterWidth="False" UseSaveSetting="False" OnItemCreated="RadGrid1_ItemCreated">
    <MasterTableView  CommandItemDisplay="Top" ShowFooter="true"  ClientDataKeyNames="os_cislo,cislo_pom,povolene_sloupce" EnableHeaderContextMenu="true" DataKeyNames="os_cislo,cislo_pom,povolene_sloupce" CommandItemSettings-ShowAddNewRecordButton="false" AllowFilteringByColumn="true" CommandItemSettings-ShowSaveChangesButton="false" AllowSorting="true" AllowAutomaticInserts="false"
        HorizontalAlign="NotSet" EditMode="Batch" AutoGenerateColumns="False" EditFormSettings-PopUpSettings-KeepInScreenBounds="true">
        <BatchEditingSettings EditType="Cell" />
        <PagerStyle PageSizes="30,50,100" />
        <Columns>
            <telerik:GridBoundColumn AllowFiltering="true" HeaderText="[%Os. číslo%]" EnableHeaderContextMenu="false" DataField="os_cislo" UniqueName="os_cislo" SortExpression="os_cislo" ></telerik:GridBoundColumn>
            <telerik:GridBoundColumn AllowFiltering="false" HeaderText="[%Č. P.%]" EnableHeaderContextMenu="false" DataField="cislo_pom" UniqueName="cislo_pom" SortExpression="cislo_pom" ></telerik:GridBoundColumn>
            <telerik:GridBoundColumn AllowFiltering="true" HeaderText="[%Jméno%]" EnableHeaderContextMenu="false" DataField="jmeno" UniqueName="jmeno" SortExpression="jmeno" ></telerik:GridBoundColumn>
            <telerik:GridBoundColumn AllowFiltering="true" HeaderText="[%Prac. stř.%]" EnableHeaderContextMenu="false" DataField="prac_str" UniqueName="prac_str" SortExpression="prac_str" ></telerik:GridBoundColumn>
            <telerik:GridBoundColumn Visible="false" HeaderText="" DataField="povolene_sloupce" UniqueName="povolene_sloupce" HeaderStyle-Width="0" ItemStyle-Width="0"></telerik:GridBoundColumn>
        </Columns>
        <EditFormSettings UserControlName="~/Controls/ZadostOodmenysl.ascx" EditFormType="WebUserControl">
        </EditFormSettings>
        <CommandItemTemplate>
            <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" PracPomeryComboBox-Visible="false" RebindButton-Visible="false" AddNewItemButton-Visible="<%# _add_new_Visible() %>" AddNewItemButton-AutoPostBack="false" AddNewItemButton-OnClientClicked="showNovyZam">
                <ExportButton ID="ExportButton1" Visible="false" runat="server" ShowExportToExcelBIFFItem="false" ShowExportToExcelHtmlItem="false" />
                <PracPomeryComboBox runat="server" Visible="false" AutoPostBack="true"></PracPomeryComboBox>
                <FilterButton runat="server" Visible="false" ID="filterButton" AutoPostBack="true"></FilterButton>               
            </kspwc:GridCommandItemControl>            
        </CommandItemTemplate>
    </MasterTableView>
    <ClientSettings AllowKeyboardNavigation="true">
        <Scrolling AllowScroll="True" UseStaticHeaders="True" SaveScrollPosition="true" />
        <ClientEvents OnHeaderMenuShowing="HeaderShowing" OnBatchEditOpening="BatchEditOpening" OnBatchEditCellValueChanging="OnBatchEditCellValueChanging" />
    </ClientSettings>
</kspwc:TRadGrid>
<asp:ObjectDataSource runat="server" ID="ObjectDataSource1" OnDataBinding="ObjectDataSource1_DataBinding" TypeName="KSPortal.Controls.ZadostOodmenysl" SelectMethod="Retrieve">
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" />     
    </SelectParameters>
</asp:ObjectDataSource>
    <div style="display:none;">
       <asp:TextBox runat="server" ID="HF1" CausesValidation="true" MaxLength="1"></asp:TextBox>    
        <kspwc:TCustomValidator runat="server" ID="cv_val_zakazy" EnableClientScript="true" Text="" ValidateEmptyText="true" ControlToValidate="HF1" ClientValidationFunction="val_zakazy" ErrorMessage="[%Neplatná hodnota%]" ></kspwc:TCustomValidator>
    </div>
<div style="height: 15px;"></div>
<div class="ksPozProces">
    <%--CssClass="nocss"--%>
    <asp:FormView ID="FormView1" runat="server" CssClass="ksPozProces" Width="700" OnDataBinding="FormView1_DataBinding">
        <ItemTemplate>
            <asp:Table runat="server" ID="table1" Style="width: 100%">
                 <asp:TableRow runat="server" ID="TableRow2">
                    <asp:TableCell runat="server" ID="TableCell6" Width="120" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                        <asp:Label ID="Label2" runat="server" Text="[%Typ požadavku%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell7" SkinID="DataFieldStyle">
                        <asp:Label ID="label5" runat="server" Text='<%# Bind("typ_popisek") %>'></asp:Label>
                    </asp:TableCell>
                </asp:TableRow>

                 <asp:TableRow runat="server" ID="TableRow3">
                    <asp:TableCell runat="server" ID="TableCell8" Width="120" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                        <asp:Label ID="Label6" runat="server" Text="[%Období%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell9" SkinID="DataFieldStyle">
                        <asp:Label ID="label7" runat="server" Text='<%# DateTime.Parse(Eval("obdobi").ToString()).ToString("MM-yyyy") %>'></asp:Label>
                    </asp:TableCell>
                </asp:TableRow>

                <asp:TableRow runat="server" ID="TableRow1">
                    <asp:TableCell runat="server" ID="TableCell2" Width="120" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                        <asp:Label ID="Label1" runat="server" Text="[%Žadatel%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell5" SkinID="DataFieldStyle">
                        <asp:Label ID="label_os_cislo" runat="server" Text='<%# Bind("jmeno") %>'></asp:Label>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRowItem3">
                    <asp:TableCell runat="server" ID="TableCellItem7" Width="120" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                        <asp:Label ID="Label3x" runat="server" Text="[%Poznámka%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem8" SkinID="DataFieldStyle">
                        <asp:Label ID="LabelDuvodx" Style="width: 100%" runat="server" Text='<%# Bind("duvod") %>'></asp:Label>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRowItem4">
                    <asp:TableCell runat="server" ID="TableCellItem9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                        <asp:Label ID="Label4x" runat="server" Width="120" Text="[%Vyřešit do%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem10" SkinID="DataFieldStyle">
                        <asp:Label ID="LabelDatvyrizeni" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>'></asp:Label>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRow6">
                    <asp:TableCell runat="server" ID="TableCell1" Width="120" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                        <asp:Label ID="Label8" runat="server" Text="[%Aktuální stav a datum změny stavu%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell4" SkinID="DataFieldStyle">
                        <asp:Label ID="Label11" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"stav") %>'></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                        <asp:Label ID="Label10" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyriz_datum"), "d") %>'></asp:Label>
                    </asp:TableCell>
                </asp:TableRow>
            </asp:Table>
        </ItemTemplate>
        <InsertItemTemplate>
            <asp:Table runat="server" ID="tab2" Style="width: 100%">
                <asp:TableRow runat="server" ID="TableRow2">
                    <asp:TableCell runat="server" ID="TableCell6" Width="120" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                        <asp:Label ID="Label2" runat="server" Text="[%Typ požadavku%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell7" SkinID="DataFieldStyle">
                        <asp:Label ID="label_typ_popisek" runat="server" Text=""></asp:Label>
                    </asp:TableCell>
                </asp:TableRow>

                 <asp:TableRow runat="server" ID="TableRow3">
                    <asp:TableCell runat="server" ID="TableCell8" Width="120" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                        <asp:Label ID="Label6" runat="server" Text="[%Období%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell9" SkinID="DataFieldStyle">
                        <asp:Label ID="label_obdobi" runat="server" ></asp:Label>
                    </asp:TableCell>
                </asp:TableRow>

                <asp:TableRow runat="server" ID="TableRow1">
                    <asp:TableCell runat="server" ID="TableCell2" Width="120" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                        <asp:Label ID="Label1" runat="server" Text="[%Žadatel%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell5" SkinID="DataFieldStyle">
                        <asp:Label ID="label_os_cislo" runat="server" Text='<%# Bind("jmeno") %>'></asp:Label>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRowInsert4">
                    <asp:TableCell runat="server" ID="TCInsert7" Width="120" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label3" runat="server" Text="[%Poznámka%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TCInsert8" ColumnSpan="3" SkinID="DataFieldStyle">
                        <telerik:RadTextBox ID="LabelDuvod" runat="server" Text='<%# Bind("duvod") %>' MaxLength="999"
                            TextMode="MultiLine" Style="width: 100%">
                        </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="val2" ControlToValidate="LabelDuvod"></kspwc:TextValidator>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRowInsert5">
                    <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="3" SkinID="DataFieldStyle">
                        <kspwc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniInsert" DbSelectedDate='<%# DataBinder.Eval(Container.DataItem,"vyridit_do") %>'>
                        </kspwc:TRadDatePicker>
                    </asp:TableCell>
                </asp:TableRow>
            </asp:Table>
        </InsertItemTemplate>
        <EditItemTemplate>
            <asp:Table runat="server" ID="tab2" Style="width: 100%">
                <asp:TableRow runat="server" ID="TableRow2">
                    <asp:TableCell runat="server" ID="TableCell6" Width="120" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                        <asp:Label ID="Label2" runat="server" Text="[%Typ požadavku%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell7" SkinID="DataFieldStyle">
                        <asp:Label ID="label5" runat="server" Text='<%# Bind("typ_popisek") %>'></asp:Label>
                    </asp:TableCell>
                </asp:TableRow>

                 <asp:TableRow runat="server" ID="TableRow3">
                    <asp:TableCell runat="server" ID="TableCell8" Width="120" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                        <asp:Label ID="Label6" runat="server" Text="[%Období%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell9" SkinID="DataFieldStyle">
                        <asp:Label ID="label7" runat="server" Text='<%# DateTime.Parse(Eval("obdobi").ToString()).ToString("MM-yyyy") %>'></asp:Label>
                    </asp:TableCell>
                </asp:TableRow>

                <asp:TableRow runat="server" ID="TableRow1">
                    <asp:TableCell runat="server" ID="TableCell2" SkinID="DataFieldHeaderStyle" Width="120" HorizontalAlign="Right">
                        <asp:Label ID="Label1" runat="server" Text="[%Žadatel%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell5" SkinID="DataFieldStyle">
                        <asp:Label ID="label_os_cislo" runat="server" Text='<%# Bind("jmeno") %>'></asp:Label>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRowEdit3">
                    <asp:TableCell runat="server" ID="TableCellEdit8" Width="120" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label3x" runat="server" Text="[%Poznámka%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCellEdit9" ColumnSpan="3" SkinID="DataFieldStyle">
                        <telerik:RadTextBox ID="LabelDuvodEdit" runat="server" Text='<%# Bind("duvod") %>' MaxLength="999"
                            TextMode="MultiLine" Style="width: 100%" Height="200">
                        </telerik:RadTextBox><br />
                        <kspwc:TextValidator runat="server" ID="val1" ControlToValidate="LabelDuvodEdit"></kspwc:TextValidator>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRowEdit4">
                    <asp:TableCell runat="server" Width="120" ID="TableCellEdit10" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCellEdit11" ColumnSpan="3" SkinID="DataFieldStyle">
                        <kspwc:TRadDatePicker ID="TextBoxDatVyrizeniEdit" DbSelectedDate='<%# Bind("vyridit_do") %>'
                            runat="server">
                        </kspwc:TRadDatePicker>
                    </asp:TableCell>
                </asp:TableRow>
            </asp:Table>
        </EditItemTemplate>
    </asp:FormView>
</div>
<telerik:RadWindowManager Behaviors="Close" ID="RadWindowManager" DestroyOnClose="false" runat="server" >
    <Windows>
        <telerik:RadWindow ID="rw_sestava_odmeny"  Title="[%Požadavky na odměny%]" runat="server">
        </telerik:RadWindow>
        <telerik:RadWindow ID="rw_hrom_zmena" CssClass="showTop" runat="server" Title="[%Hromadné zadání%]" VisibleStatusbar="false" Width="300" Height="250" OnClientShow="rw_hrom_zmena_clientShow" OnClientBeforeShow="rw_hrom_zmena_odmeny_beforeShow"
            Behaviors="Move,Close" DestroyOnClose="true">
            <ContentTemplate>
                <table style="margin: 15px;" class="table_hodn">
                    <tr>
                        <td>[%Kód%]:</td>
                        <td>
                            <asp:Label runat="server" ID="lab_zmena_kod"></asp:Label></td>
                    </tr>
                    <tr>
                        <td>[%Typ hodnoty%]:</td>
                        <td>
                            <asp:Label runat="server" ID="lab_zmena_typ_hodnoty"></asp:Label></td>
                    </tr>
                    <tr>
                        <td>[%Hodnota%]:</td>
                        <td>
                            <telerik:RadNumericTextBox runat="server" ID="rntb_hodnota" MaxLength="6" Width="70"></telerik:RadNumericTextBox></td>
                    </tr>
                </table>
                <div style="width: 100%; text-align: Left; margin-top: 20px;">
                    <wc:TRadButton ID="rb_hrom_zmena" runat="server" Text="[%Nastavit%]" AutoPostBack="false" CommandName="Save" Icon-PrimaryIconCssClass="fi fi-disk" OnClientClicked="rb_hrom_zmena" />
                    <wc:TRadButton ID="rb_hrom_zmena_close" runat="server" Text="[%Konec%]" AutoPostBack="false" OnClientClicked="rb_hrom_zmena_close_clientClicked" />
                </div>
            </ContentTemplate>
        </telerik:RadWindow>
        <telerik:RadWindow style="z-index:2002 !important;" Behaviors="Move" ID="rw_odmeny_poznamka" ShowContentDuringLoad="false" Title="[%Odměny s poznámkou%]" runat="server" DestroyOnClose="false"
            OnClientClose="rw_odmeny_poznamka_clientClose" >
        </telerik:RadWindow>

        <telerik:RadWindow Behaviors="Close" Modal="true" Width="450" Height="200" ID="rw_novy" ShowContentDuringLoad="false" Title="[%Přidat zaměstnance%]" runat="server" DestroyOnClose="false"
            OnClientClose="rw_novy_clientClose">
            <ContentTemplate>
                <table style="margin-top: 10px;">
                    <tr>
                        <td>
                            <asp:Label runat="server" ID="Label1" Text="[%Vyhledávání%]"></asp:Label>
                        </td>
                        <td>
                            <telerik:RadComboBox ID="RadComboBox_zam"
                                runat="server" Width="300" EmptyMessage="[%Příjmení%],[%Os.číslo%], [%Název prac. místa%]"
                                EnableLoadOnDemand="true" ShowMoreResultsBox="true"
                                EnableVirtualScrolling="true" AutoPostBack="false">
                                <HeaderTemplate>
                                    <asp:Label runat="server" ID="lab_header" Text="[%Zaměstnanci%]" CssClass="h2"></asp:Label>
                                </HeaderTemplate>
                                <ClientItemTemplate>
                    <div class="imageWrap">
                        <img src='#=Attributes.ImageUrl#' alt=" #= Text # " />
                    </div>
                    <div>
                        <ul class="personDetails">
                            <li class="name"><span> #= Text # </span></li>                                    
                            <li class="misto"><span> #= Attributes.NazPracmist # </span></li>
                        </ul>
                    </div>
                                </ClientItemTemplate>
                                <WebServiceSettings Method="GetZamestnance" Path="~/Pis/SysSchema.aspx" />
                            </telerik:RadComboBox>
                        </td>
                    </tr>
                    <tr>
                        <td></td>
                        <td style="padding-top: 50px;" align="right">
                            <kspwc:TRadButton runat="server" ID="button_ok" Text="[%Vložit%]" AutoPostBack="false" OnClientClicked="button_ok_OnClientClicked"></kspwc:TRadButton>
                            <kspwc:TRadButton runat="server" ID="button_zavrit" Text="[%Zavřít%]" CausesValidation="false" OnClientClicked="button_zavrit_onClientClicked"></kspwc:TRadButton>
                        </td>
                    </tr>
                </table>
            </ContentTemplate>

        </telerik:RadWindow>
        <telerik:RadWindow runat="server" Title="[%Chyby ve formuláři%]" ID="RW_Errors" AutoSizeBehaviors="Height, Width" MaxHeight="600px" Behaviors="Close, Move, Pin" InitialBehaviors="Close, Move" KeepInScreenBounds="True" Modal="False" VisibleStatusbar="False">
        <ContentTemplate>
            <telerik:RadFormDecorator ID="RFD_decor" runat="server" DecoratedControls="All"
                DecorationZoneID="formsumary" EnableRoundedCorners="False" />
            <div id="formsumary" class="formsumary">
                <asp:ValidationSummary ID="ValidationSummary1" Width="380px" runat="server" />
            </div>
            <kspwc:TRadButton ID="TRB_vs_close" runat="server" AutoPostBack="false" OnClientClicked="RW_Errors_close" Text="[%Zavřít%]">
                <Icon PrimaryIconCssClass="fi fi-ban"></Icon>
            </kspwc:TRadButton>
        </ContentTemplate>
    </telerik:RadWindow>     
    <telerik:RadWindow style="z-index:2001 !important;overflow: hidden;" runat="server" ID="RW_budgety" Title="[%Budgety%] - [%zůstatky%]" AutoSize="true" OnClientDragEnd="RW_budgety_OnClientDragEnd"  AutoSizeBehaviors="Height, Width" Behaviors="Move, Pin, Resize, Minimize, Maximize, Reload"
        MinWidth="710" InitialBehaviors="Move,Resize" KeepInScreenBounds="True" Modal="False" VisibleStatusbar="False"  OnClientResize="RW_budgety_OnClientResize" OnClientShow="RW_budgety_OnClientShow" >
        <ContentTemplate>
            <kspwc:TRadGrid CaptionVisible="false" ID="TRadGrid_budgety" runat="server" ShowGroupPanel="False" AllowPaging="false" EnableViewState="false"  Width="100%" Height="100%" 
                                     AllowSorting="false" AutoGenerateColumns="false" 
                                     ShowFooter="false" PageSize="300" >                  
                                    <MasterTableView Caption="" CommandItemDisplay="Top" CommandItemSettings-ShowRefreshButton="false" CommandItemSettings-ShowAddNewRecordButton="false" ShowGroupFooter="false" ShowHeader="True" AllowFilteringByColumn="false">              
                                        <CommandItemTemplate >                                         
                                            <kspwc:TRadButton ID="TRB_rebind" runat="server" Text="[%Načíst%]" AutoPostBack="False"  OnClientClicked="TRadGrid_budgety_refresh">
                                                <Icon PrimaryIconCssClass="rbRefresh" PrimaryIconLeft="4" PrimaryIconTop="3"></Icon>
                                            </kspwc:TRadButton>
                                        </CommandItemTemplate>
                                        
                                        <Columns>                                           
                                            <telerik:GridBoundColumn DataType="System.String" DataField="Nazev" HeaderText="[%Budget%]" >   
                                                <ItemStyle Wrap="true" />
                                            </telerik:GridBoundColumn> 
                                            <telerik:GridBoundColumn DataType="System.String" DataField="Kod" HeaderText="[%Mzd. kód%]" >                                            
                                            </telerik:GridBoundColumn> 
                                            <telerik:GridBoundColumn DataType="System.Decimal" DataField="ZustZacatek" HeaderText="[%Zůstatek na začátku období%]" UniqueName="ZustZacatek" > </telerik:GridBoundColumn>
                                            <telerik:GridBoundColumn DataType="System.Decimal" DataField="Rezervovano" HeaderText="[%Rezervace%]" UniqueName="Rezervovano" > </telerik:GridBoundColumn>                                            
                                            <telerik:GridBoundColumn DataType="System.Decimal" DataField="Cerpano" HeaderText="[%Čerpáno%]" UniqueName="Cerpano"> </telerik:GridBoundColumn>
                                            <telerik:GridBoundColumn DataType="System.Decimal" DataField="Zustatek" HeaderText="[%Zůstatek%]" UniqueName="Zustatek">
                                                <ItemStyle Font-Bold="true" /><HeaderStyle Font-Bold="true" />
                                            </telerik:GridBoundColumn>  
                                            <telerik:GridBoundColumn DataType="System.Decimal" DataField="VPozadavku" HeaderText="[%V požadavku%]" UniqueName="VPozadavku" > 
                                                 <ItemStyle Font-Bold="true" /><HeaderStyle Font-Bold="true" />
                                            </telerik:GridBoundColumn>
                                        </Columns>                                       
                                    </MasterTableView> 
                
                                   <ClientSettings >
                                      <ClientEvents OnCommand="function(){}" /> 
                                       <Scrolling AllowScroll="true" UseStaticHeaders="true" />
                                   </ClientSettings>
                </kspwc:TRadGrid>
               <telerik:RadAjaxLoadingPanel runat="server" ID="RALP_TRadGrid" ></telerik:RadAjaxLoadingPanel>
        </ContentTemplate>
    </telerik:RadWindow>
    </Windows>
</telerik:RadWindowManager>

<asp:ObjectDataSource runat="server" ID="ods_budgety" TypeName="KSPortal.Controls.ZadostOodmenysl" SelectMethod="DummyBudgety">

</asp:ObjectDataSource>
<kspwc:TRadComboBox  runat="server" ID="combo_budgety" Width="200"  EnableLoadOnDemand="true" OnClientItemsRequesting="budget_clientRequesting"
                                                                                 OnClientDropDownClosed="budget_OnClientDropDownClosed" 
                                                                                 OnClientSelectedIndexChanged="budget_OnClientSelectedIndexChanged"
                                                                                 OnClientBlur="budget_OnClientBlur"  >
     <WebServiceSettings Method="GetBudgety" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
</kspwc:TRadComboBox>

<asp:CustomValidator runat="server" ID="cv_validate" EnableClientScript="true"  ClientValidationFunction="val_poznamky">

</asp:CustomValidator>
