﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOkonflikt.ascx.cs"
    Inherits="KSPortal.Controls.ZadostOkonflikt" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajax" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<telerik:RadFormDecorator ID="QsfFromDecorator" runat="server" DecoratedControls="CheckBoxes,RadioButtons,Select,Textarea,Textbox" EnableRoundedCorners="false" DecorationZoneID="FormView1" />
<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekkonflikt" InsertMethod="Insert" UpdateMethod="Update"
    OnInserted="ObjectDataSource1_Inserted" OnInserting="ObjectDataSource1_Inserting" 
    OnUpdating="ObjectDataSource1_Updating">
    <InsertParameters>
        <asp:Parameter Direction="InputOutput" Name="id_poz" Type="Int32" />
        <asp:Parameter Name="adresat" Type="Decimal" />
        <asp:Parameter Name="vyriz_uzivatel" Type="String" />
        <asp:Parameter Name="os_cislo" Type="Decimal" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="event_type" Type="String" />
        <%--<asp:Parameter Name="sub_fo" Type="String" />--%>
        <asp:Parameter Name="sub_po" Type="String" />
        <asp:Parameter Name="dept" Type="String" />
        <asp:Parameter Name="type_of_rel" Type="String" />
        <asp:Parameter Name="amount" Type="String" />
        <asp:Parameter Name="trans" Type="String" />
        <asp:Parameter Name="isin" Type="String" />
        <asp:Parameter Name="title" Type="String" />
        <asp:Parameter Name="description" Type="String" />
        <asp:Parameter Name="rejection" Type="String" />
        <asp:Parameter Name="whistle" Type="String" />
        <asp:Parameter Name="responsible" Type="String" />
        <asp:Parameter Name="fu1" Type="String" />
        <asp:Parameter Name="fu2" Type="String" />
        <asp:Parameter Name="fu3" Type="String" />
        <asp:Parameter Name="fu1_date" Type="DateTime" />
        <asp:Parameter Name="typ_pole" Type="String" />
        <asp:Parameter Name="poznamka" Type="String" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="vyriz_uzivatel" Type="String" />
        <asp:Parameter Name="os_cislo" Type="Decimal" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="event_type" Type="String" />
        <%--<asp:Parameter Name="sub_fo" Type="String" />--%>
        <asp:Parameter Name="sub_po" Type="String" />
        <asp:Parameter Name="dept" Type="String" />
        <asp:Parameter Name="type_of_rel" Type="String" />
        <asp:Parameter Name="amount" Type="String" />
        <asp:Parameter Name="trans" Type="String" />
        <asp:Parameter Name="isin" Type="String" />
        <asp:Parameter Name="title" Type="String" />
        <asp:Parameter Name="description" Type="String" />
        <asp:Parameter Name="rejection" Type="String" />
        <asp:Parameter Name="whistle" Type="String" />
        <asp:Parameter Name="responsible" Type="String" />
        <asp:Parameter Name="fu1" Type="String" />
        <asp:Parameter Name="fu2" Type="String" />
        <asp:Parameter Name="fu3" Type="String" />
        <asp:Parameter Name="fu1_date" Type="DateTime" />
        <asp:Parameter Name="typ_pole" Type="String" />
        <asp:Parameter Name="poznamka" Type="String" />
    </UpdateParameters>
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ds_vazby" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="GetVazby" TypeName="KSProgram.Pozadavky.Pozadavekkonflikt"></asp:ObjectDataSource>
<asp:ObjectDataSource ID="ds_interakce" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="GetInterakce" TypeName="KSProgram.Pozadavky.Pozadavekkonflikt">
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ds_typgi" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="GetIaD" TypeName="KSProgram.Pozadavky.Pozadavekkonflikt"></asp:ObjectDataSource>
<asp:ObjectDataSource ID="ds_whistle" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="GetWhistle" TypeName="KSProgram.Pozadavky.Pozadavekkonflikt"></asp:ObjectDataSource>
<asp:ObjectDataSource ID="ds_smer" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="GetSmer" TypeName="KSProgram.Pozadavky.Pozadavekkonflikt"></asp:ObjectDataSource>
<asp:ObjectDataSource ID="ds_responsible" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="GetResponsible" TypeName="KSProgram.Pozadavky.Pozadavekkonflikt">
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ds_typ_pole" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="GetTypPole" TypeName="KSProgram.Pozadavky.Pozadavekkonflikt"></asp:ObjectDataSource>
<asp:ObjectDataSource ID="ds_event_type" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="GetEventTypes" 
    TypeName="KSProgram.Pozadavky.Pozadavekkonflikt">
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ds_all_zam" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="GetSeznamZam" 
    TypeName="KSProgram.Pozadavky.Pozadavekkonflikt">
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ds_stred" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="VsechnaPracStrediska" 
    TypeName="KSProgram.Ciselniky.CisStredisko" 
    ondatabinding="ds_stred_DataBinding">
    <SelectParameters>
        <asp:Parameter Name="datum" Type="DateTime" />
        <asp:Parameter DefaultValue="true" Name="ab_prazdny" Type="Boolean" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:FormView ID="FormView1" runat="server" DataSourceID="ObjectDataSource1" OnDataBound="FormView1_DataBound"
    OnLoad="FormView1_Load" OnPreRender="FormView1_PreRender" 
    oniteminserting="FormView1_ItemInserting" >
    <InsertItemTemplate>
        <asp:Table runat="server" ID="titled_panel" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Hlášení konfliktu%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow7">
                <asp:TableCell runat="server" ID="TableCell151">
                    <asp:Table runat="server" ID="table1">
                        <asp:TableRow runat="server" ID="r_os_cislo">
                            <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label1" runat="server" Text="[%Os. číslo%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="c_os_cislo" SkinID="DataFieldStyle">
                                <asp:Label ID="i_os_cislo" runat="server" Text=""></asp:Label>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRow2">
                            <asp:TableCell runat="server" ID="TableCell40" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label23" runat="server" Text="[%Příjmení a jméno%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell41" SkinID="DataFieldStyle">
                                <asp:Label ID="i_jmeno" runat="server" Text=""></asp:Label>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRow8">
                            <asp:TableCell runat="server" ID="TableCell4" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="label" runat="server" Text="[%Pracovní pozice%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell5" SkinID="DataFieldStyle">
                                <asp:Label ID="label_prac_misto" runat="server" Text=""></asp:Label>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_datum">
                            <asp:TableCell runat="server" ID="TableCell2" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="datum" runat="server" Text="[%Datum%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                                <asp:Label ID="i_datum" runat="server" Text=""></asp:Label>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_vyridit_do">
                            <asp:TableCell runat="server" ID="TableCell48" SkinID="DataFieldHeaderStyle">
                                <asp:Label runat="server" ID="Label4" Text="[%Požadované datum vyřízení%]"></asp:Label></asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell49" SkinID="DataFieldStyle">
                                <%--<asp:Label runat="server" ID="dat_vyriz" Text='<%# _date(Container.DataItem, "vyriz_datum") %>' ></asp:Label>--%>
                                <kspwc:TRadDatePicker runat="server" ID="rad_vyridit_do" SelectedDate='<%# Bind("vyridit_do") %>' />
                                <%--<kspwc:TRequiredValidator runat="server" ID="req_vyriz_datum" ControlToValidate="vyriz_datum" ></kspwc:TRequiredValidator>--%>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRow1">
                            <asp:TableCell runat="server" ID="TableCell38" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label22" runat="server" Text="[%Typ konfliktu%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell39" SkinID="DataFieldStyle">
                                <asp:DropDownList ID="ddl_event_type" runat="server" DataSourceID="ds_event_type"
                                    AutoPostBack="True" DataTextField="popis" DataValueField="hodnota" OnSelectedIndexChanged="ddl_event_type_SelectionIndexChanged" Width="550">
                                </asp:DropDownList>
                            </asp:TableCell>
                        </asp:TableRow>
                        <%--<asp:TableRow runat="server" ID="r_sub_fo">
                            <asp:TableCell runat="server" ID="TableCell4" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label5" runat="server" Text="[%Související fyzická osoba%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell5" SkinID="DataFieldStyle">
                                <asp:TextBox ID="sub_fo" runat="server" Text="" MaxLength="400" TextMode="MultiLine"  Width="550" Height="120">
                                </asp:TextBox><br />
                                <kspwc:TRequiredValidator runat="server" ID="req_sub_fo" ControlToValidate="sub_fo"></kspwc:TRequiredValidator>
                                <table style="border-collapse: collapse;">
                                    <tr>
                                        <td>
                                            <asp:TextBox ID="text_sub_fo" runat="server" AutoCompleteType="DisplayName" AutoPostBack="True"
                                                OnTextChanged="tx_jmeno_TextChanged" Width="550"></asp:TextBox>
                                                <br />
                                               <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator35" ControlToValidate="text_sub_fo"></kspwc:TRequiredValidator>
                                            <div runat="server" id="div_zam">
                                            </div>
                                            <ajax:AutoCompleteExtender ID="ac_jmeno" runat="server" TargetControlID="text_sub_fo"
                                                ServiceMethod="JmenoZam" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                                MinimumPrefixLength="1" FirstRowSelected="True" UseContextKey="True" CompletionListElementID="div_zam"
                                                OnClientPopulated="onPopulated" CompletionInterval="500" ContextKey="konflikt">
                                            </ajax:AutoCompleteExtender>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:CustomValidator ID="cv_sub_fo" runat="server" ErrorMessage="V poli musí být uvedeno 'Přijmení,Jméno-os.číslo'"
                                                ControlToValidate="text_sub_fo" Display="Dynamic" OnServerValidate="sub_fo_validate"></asp:CustomValidator>
                                        </td>
                                    </tr>
                                </table>
                            </asp:TableCell>
                        </asp:TableRow>--%>
                        <asp:TableRow runat="server" ID="r_sub_po">
                            <asp:TableCell runat="server" ID="TableCell6" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label6" runat="server" Text="[%Související subjekt(název společnosti/jméno fyzické osoby)%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell7" SkinID="DataFieldStyle">
                                <asp:TextBox ID="sub_po" runat="server" Text="" MaxLength="400" TextMode="MultiLine"  Width="550" Height="120">
                                </asp:TextBox><br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator1" ControlToValidate="sub_po"></kspwc:TRequiredValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_dept">
                            <asp:TableCell runat="server" ID="TableCell10" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label8" runat="server" Text="[%Útvar%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell11" SkinID="DataFieldStyle">
                                <%--<asp:TextBox ID="dept" runat="server" Text="" MaxLength="400" TextMode="MultiLine">
                                </asp:TextBox>--%>
                                <asp:DropDownList ID="dept" runat="server" DataSourceID="ds_stred" DataTextField="cely_nazev" DataValueField="str"  Width="550">
                                </asp:DropDownList><br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator2" ControlToValidate="dept"></kspwc:TRequiredValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_type_of_rel">
                            <asp:TableCell runat="server" ID="TableCell8" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label7" runat="server" Text="[%Typ vztahu%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell9" SkinID="DataFieldStyle">
                                <asp:DropDownList ID="type_of_rel_vazby" runat="server" DataSourceID="ds_vazby" AutoPostBack="True"
                                    DataTextField="vyznam" DataValueField="cislo"  Width="550">
                                </asp:DropDownList><br />
                                <kspwc:TRequiredValidator runat="server" ID="val_type_of_rel_vazby" ControlToValidate="type_of_rel_vazby"></kspwc:TRequiredValidator>
                                <asp:DropDownList ID="type_of_rel_gi" runat="server" DataSourceID="ds_typgi" AutoPostBack="True"
                                    DataTextField="vyznam" DataValueField="cislo"  Width="550">
                                </asp:DropDownList><br />
                                <kspwc:TRequiredValidator runat="server" ID="val_type_of_rel_gi" ControlToValidate="type_of_rel_gi"></kspwc:TRequiredValidator>
                                <asp:DropDownList ID="type_of_rel_interakce" runat="server" DataSourceID="ds_interakce"
                                    AutoPostBack="True" DataTextField="vyznam" DataValueField="cislo"  Width="550">
                                </asp:DropDownList><br />
                                <kspwc:TRequiredValidator runat="server" ID="val_type_of_rel_interakce" ControlToValidate="type_of_rel_interakce"></kspwc:TRequiredValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_amount">
                            <asp:TableCell runat="server" ID="TableCell12" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label9" runat="server" Text="[%Hodnota / částka%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell13" SkinID="DataFieldStyle">
                                <asp:TextBox ID="amount" runat="server" Text="">
                                </asp:TextBox><br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator6" ControlToValidate="amount"></kspwc:TRequiredValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_trans">
                            <asp:TableCell runat="server" ID="TableCell14" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label10" runat="server" Text="[%Transakce%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell15" SkinID="DataFieldStyle">
                                <%--<asp:TextBox ID="trans" runat="server" Text=""></asp:TextBox>--%>
                                <asp:DropDownList ID="trans" runat="server" DataSourceID="ds_smer" AutoPostBack="True"
                                    DataTextField="vyznam" DataValueField="cislo"  Width="550">
                                </asp:DropDownList><br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator7" ControlToValidate="trans"></kspwc:TRequiredValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_isin">
                            <asp:TableCell runat="server" ID="TableCell16" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label11" runat="server" Text="ISIN"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell17" SkinID="DataFieldStyle">
                                <asp:TextBox ID="isin" runat="server" Text="" MaxLength="400" TextMode="MultiLine"  Width="550" Height="120">
                                </asp:TextBox><br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator8" ControlToValidate="isin"></kspwc:TRequiredValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_title">
                            <asp:TableCell runat="server" ID="TableCell18" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label12" runat="server" Text="[%Titul%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell19" SkinID="DataFieldStyle">
                                <asp:TextBox ID="title" runat="server" Text="" MaxLength="400" TextMode="MultiLine"  Width="550" Height="120">
                                </asp:TextBox><br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator9" ControlToValidate="title"></kspwc:TRequiredValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_description">
                            <asp:TableCell runat="server" ID="TableCell20" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label13" runat="server" Text="[%Popis%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell21" SkinID="DataFieldStyle">
                                <asp:TextBox ID="description" runat="server" Text="" MaxLength="400" TextMode="MultiLine"  Width="550" Height="120">
                                </asp:TextBox><br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator10" ControlToValidate="description"></kspwc:TRequiredValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_rejection">
                            <asp:TableCell runat="server" ID="TableCell22" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label14" runat="server" Text="[%Odmítnutí%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell23" SkinID="DataFieldStyle">
                                <asp:CheckBox ID="rejection" runat="server"></asp:CheckBox>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_whistle">
                            <asp:TableCell runat="server" ID="TableCell24" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label15" runat="server" Text="Whistle Blowing"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell25" SkinID="DataFieldStyle">
                                <asp:DropDownList ID="whistle" runat="server" DataSourceID="ds_whistle" AutoPostBack="True"
                                    DataTextField="vyznam" DataValueField="cislo"  Width="550">
                                </asp:DropDownList><%--<br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator11" ControlToValidate="whistle"></kspwc:TRequiredValidator>--%>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_responsible">
                            <asp:TableCell runat="server" ID="TableCell26" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label16" runat="server" Text="[%Řešitel%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell27" SkinID="DataFieldStyle">
                                <asp:DropDownList ID="responsible" runat="server" DataSourceID="ds_responsible" AutoPostBack="True"
                                    DataTextField="jmeno_os_cislo" DataValueField="os_cislo"  Width="550">
                                </asp:DropDownList><%--<br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator12" ControlToValidate="responsible"></kspwc:TRequiredValidator>--%>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_fu1">
                            <asp:TableCell runat="server" ID="TableCell28" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label17" runat="server" Text="FU 1"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell29" SkinID="DataFieldStyle">
                                <asp:TextBox ID="fu1" runat="server" Text="" MaxLength="400" TextMode="MultiLine"  Width="550" Height="120">
                                </asp:TextBox><br />
                                <%--<kspwc:TRequiredValidator runat="server" ID="TRequiredValidator13" ControlToValidate="fu1"></kspwc:TRequiredValidator>--%>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_fu2">
                            <asp:TableCell runat="server" ID="TableCell30" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label18" runat="server" Text="FU 2"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell31" SkinID="DataFieldStyle">
                                <asp:TextBox ID="fu2" runat="server" Text="" MaxLength="400" TextMode="MultiLine"  Width="550" Height="120">
                                </asp:TextBox><%--<br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator14" ControlToValidate="fu2"></kspwc:TRequiredValidator>--%>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_fu3">
                            <asp:TableCell runat="server" ID="TableCell32" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label19" runat="server" Text="FU 3"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell33" SkinID="DataFieldStyle">
                                <asp:TextBox ID="fu3" runat="server" Text="" MaxLength="400" TextMode="MultiLine"  Width="550" Height="120">
                                </asp:TextBox><%--<br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator15" ControlToValidate="fu3"></kspwc:TRequiredValidator>--%>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_fu1_date">
                            <asp:TableCell runat="server" ID="TableCell34" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label20" runat="server" Text="FU 1 date"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell35" SkinID="DataFieldStyle">                                
                                 <%--<wc:DateControl runat="server" ID="fu1_date" />--%>
                                 <kspwc:TRadDatePicker runat="server" ID="fu1_date" >                                 
                                 </kspwc:TRadDatePicker>     <br />
                                 <%--<kspwc:TRequiredValidator runat="server" ID="TRequiredValidator16" ControlToValidate="fu1_date"></kspwc:TRequiredValidator>         --%>             
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_typ_pole">
                            <asp:TableCell runat="server" ID="TableCell36" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label21" runat="server" Text="[%Typ%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell37" SkinID="DataFieldStyle">
                                <asp:DropDownList ID="typ_pole" runat="server" DataSourceID="ds_typ_pole" AutoPostBack="True"
                                    DataTextField="vyznam" DataValueField="cislo"  Width="550">
                                </asp:DropDownList>
                                <%--<br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator17" ControlToValidate="typ_pole"></kspwc:TRequiredValidator>--%>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRow5">
                            <asp:TableCell runat="server" ID="TableCell50" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label26" runat="server" Text="[%Poznámka%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell51" SkinID="DataFieldStyle">
                                <asp:TextBox ID="poznamka" runat="server" Text="" MaxLength="400" TextMode="MultiLine"  Width="550" Height="120">
                                </asp:TextBox>
                            </asp:TableCell>
                        </asp:TableRow>
                    </asp:Table>
        </asp:TableCell> 
        </asp:TableRow>
        </asp:Table>
    </InsertItemTemplate>
    <EditItemTemplate>
        <asp:Table runat="server" ID="titled_panel" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Hlášení konfliktu%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow7">
                <asp:TableCell runat="server" ID="TableCell46">
                    <asp:Table runat="server" ID="table1">
                        <asp:TableRow runat="server" ID="r_os_cislo">
                            <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label1" runat="server" Text="[%Os. číslo%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="c_os_cislo" SkinID="DataFieldStyle">
                                <asp:Label ID="os_cislo" runat="server" Text='<%# Bind("os_cislo") %>'></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRow3">
                            <asp:TableCell runat="server" ID="TableCell42" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label24" runat="server" Text="[%Příjmení a jméno%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell43" SkinID="DataFieldStyle">
                                <asp:Label ID="jmeno" runat="server" Text='<%# Bind("jmeno") %>'></asp:Label></asp:TableCell>
                        </asp:TableRow>
                         <asp:TableRow runat="server" ID="TableRow8">
                            <asp:TableCell runat="server" ID="TableCell4" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label5" runat="server" Text="[%Pracovní pozice%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell5" SkinID="DataFieldStyle">
                                <asp:Label ID="label_prac_misto" runat="server" Text='<%# Bind("prac_misto") %>'></asp:Label>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_datum">
                            <asp:TableCell runat="server" ID="TableCell2" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label3" runat="server" Text="[%Datum%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                                <asp:Label ID="datum" runat="server" Text='<%# Bind("datum", "{0:d}") %>'></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_vyridit_do">
                            <asp:TableCell runat="server" ID="TableCell48" SkinID="DataFieldHeaderStyle">
                                <asp:Label runat="server" ID="Label4" Text="[%Požadované datum vyřízení%]"></asp:Label></asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell49" SkinID="DataFieldStyle">
                                <kspwc:TRadDatePicker runat="server" ID="rad_vyridit_do" DbSelectedDate='<%# Bind("vyridit_do") %>' />
                                <%--<kspwc:TRequiredValidator runat="server" ID="req_vyriz_datum" ControlToValidate="vyriz_datum" ></kspwc:TRequiredValidator>--%>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRow1">
                            <asp:TableCell runat="server" ID="TableCell38" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label22" runat="server" Text="[%Typ konfliktu%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell39" SkinID="DataFieldStyle">
                                <asp:DropDownList ID="ddl_event_type" runat="server" DataSourceID="ds_event_type" SelectedValue='<%# Bind("event_type") %>'
                                    AutoPostBack="True" DataTextField="popis" DataValueField="hodnota"  Width="550" OnSelectedIndexChanged="ddl_event_type_SelectionIndexChanged">
                                </asp:DropDownList>
                            </asp:TableCell>
                        </asp:TableRow>
                        <%--<asp:TableRow runat="server" ID="r_sub_fo">
                            <asp:TableCell runat="server" ID="TableCell4" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label5" runat="server" Text="[%Související fyzická osoba%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell5" SkinID="DataFieldStyle">
                                <asp:TextBox ID="sub_fo" runat="server" Text='<%# Bind("sub_fo_text") %>' MaxLength="400"
                                    TextMode="MultiLine" Width="550" Height="120"></asp:TextBox><br />
                                 <kspwc:TRequiredValidator runat="server" ID="req_sub_fo" ControlToValidate="sub_fo"></kspwc:TRequiredValidator>
                                <table style="border-collapse: collapse;">
                                    <tr>
                                        <td>
                                            <asp:TextBox ID="text_sub_fo" runat="server" AutoCompleteType="DisplayName" AutoPostBack="True"
                                                OnTextChanged="tx_jmeno_TextChanged" Width="550" Text='<%# Bind("sub_fo_popis") %>'></asp:TextBox><br />
                                            <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator36" ControlToValidate="sub_fo"></kspwc:TRequiredValidator>
                                            <div runat="server" id="div_zam">
                                            </div>
                                            <ajax:AutoCompleteExtender ID="ac_jmeno" runat="server" TargetControlID="text_sub_fo"
                                                ServiceMethod="JmenoZam" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                                MinimumPrefixLength="1" FirstRowSelected="True" UseContextKey="True" CompletionListElementID="div_zam"
                                                OnClientPopulated="onPopulated" CompletionInterval="500" ContextKey="konflikt">
                                            </ajax:AutoCompleteExtender>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:CustomValidator ID="cv_sub_fo" runat="server" ErrorMessage="V poli musí být uvedeno 'Přijmení,Jméno-os.číslo'"
                                                ControlToValidate="text_sub_fo" Display="Dynamic" OnServerValidate="sub_fo_validate"></asp:CustomValidator>
                                        </td>
                                    </tr>
                                </table>
                            </asp:TableCell>
                        </asp:TableRow>--%>
                        <asp:TableRow runat="server" ID="r_sub_po">
                            <asp:TableCell runat="server" ID="TableCell6" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label6" runat="server" Text="[%Související subjekt(název společnosti/jméno fyzické osoby)%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell7" SkinID="DataFieldStyle">
                                <asp:TextBox ID="sub_po" runat="server" Text='<%# Bind("sub_po") %>' MaxLength="400" TextMode="MultiLine"  Width="550" Height="120"></asp:TextBox>
                                <br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator18" ControlToValidate="sub_po"></kspwc:TRequiredValidator>
                             </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_dept">
                            <asp:TableCell runat="server" ID="TableCell10" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label8" runat="server" Text="[%Útvar%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell11" SkinID="DataFieldStyle">
                                <%--<asp:TextBox ID="dept" runat="server" Text='<%# Bind("dept") %>'></asp:TextBox>--%>
                                <asp:DropDownList ID="dept" runat="server" DataSourceID="ds_stred" DataTextField="cely_nazev" DataValueField="str"  Width="550">
                                </asp:DropDownList>
                                <br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator19" ControlToValidate="dept"></kspwc:TRequiredValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_type_of_rel">
                            <asp:TableCell runat="server" ID="TableCell8" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label7" runat="server" Text="[%Typ vztahu%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell9" SkinID="DataFieldStyle">
             
                                <asp:DropDownList ID="type_of_rel_vazby" runat="server" AutoPostBack="True" DataTextField="vyznam" DataSourceID="ds_vazby"
                                    DataValueField="cislo" SelectedValue='<%# Bind("type_of_rel_vazby") %>'  Width="550">
                                </asp:DropDownList><br />
                                <kspwc:TRequiredValidator runat="server" ID="val_type_of_rel_vazby" ControlToValidate="type_of_rel_vazby"></kspwc:TRequiredValidator>
                                <asp:DropDownList ID="type_of_rel_gi" runat="server" AutoPostBack="True" DataTextField="vyznam" DataSourceID="ds_typgi"
                                    DataValueField="cislo" SelectedValue='<%# Bind("type_of_rel_gi") %>'  Width="550">
                                </asp:DropDownList><br />
                                <kspwc:TRequiredValidator runat="server" ID="val_type_of_rel_gi" ControlToValidate="type_of_rel_gi"></kspwc:TRequiredValidator>
                                <asp:DropDownList ID="type_of_rel_interakce" runat="server" AutoPostBack="True" DataTextField="vyznam" DataSourceID="ds_interakce"
                                    DataValueField="cislo" SelectedValue='<%# Bind("type_of_rel_interakce") %>'  Width="550">
                                </asp:DropDownList><br />
                                <kspwc:TRequiredValidator runat="server" ID="val_type_of_rel_interakce" ControlToValidate="type_of_rel_interakce"></kspwc:TRequiredValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_amount">
                            <asp:TableCell runat="server" ID="TableCell12" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label9" runat="server" Text="[%Hodnota / částka%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell13" SkinID="DataFieldStyle">
                                <asp:TextBox ID="amount" runat="server" Text='<%# Bind("amount") %>'></asp:TextBox><br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator23" ControlToValidate="amount"></kspwc:TRequiredValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_trans">
                            <asp:TableCell runat="server" ID="TableCell14" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label10" runat="server" Text="[%Transakce%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell15" SkinID="DataFieldStyle">
                                <%--<asp:TextBox ID="trans" runat="server" Text='<%# Bind("trans") %>'></asp:TextBox>--%>
                                <asp:DropDownList ID="trans" runat="server" DataSourceID="ds_smer" AutoPostBack="True"
                                    DataTextField="vyznam" DataValueField="cislo" SelectedValue='<%# Bind("trans") %>'  Width="550">
                                </asp:DropDownList>
                                <br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator24" ControlToValidate="trans"></kspwc:TRequiredValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_isin">
                            <asp:TableCell runat="server" ID="TableCell16" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label11" runat="server" Text="ISIN"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell17" SkinID="DataFieldStyle">
                                <asp:TextBox ID="isin" runat="server" Text='<%# Bind("isin") %>' MaxLength="400" TextMode="MultiLine"  Width="550" Height="120"></asp:TextBox>
                                <br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator25" ControlToValidate="isin"></kspwc:TRequiredValidator>
                             </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_title">
                            <asp:TableCell runat="server" ID="TableCell18" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label12" runat="server" Text="[%Titul%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell19" SkinID="DataFieldStyle">
                                <asp:TextBox ID="title" runat="server" Text='<%# Bind("title") %>' MaxLength="400" TextMode="MultiLine"  Width="550" Height="120"></asp:TextBox>
                                <br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator26" ControlToValidate="title"></kspwc:TRequiredValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_description">
                            <asp:TableCell runat="server" ID="TableCell20" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label13" runat="server" Text="[%Popis%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell21" SkinID="DataFieldStyle">
                                <asp:TextBox ID="description" runat="server" Text='<%# Bind("description") %>' MaxLength="400" TextMode="MultiLine"  Width="550" Height="120"></asp:TextBox>
                                <br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator27" ControlToValidate="description"></kspwc:TRequiredValidator>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_rejection">
                            <asp:TableCell runat="server" ID="TableCell22" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label14" runat="server" Text="[%Odmítnutí%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell23" SkinID="DataFieldStyle">
                                <asp:CheckBox ID="rejection" runat="server" Checked='<%# (DataBinder.Eval(Container.DataItem,"rejection").ToString()=="n" ? false : true) %>'></asp:CheckBox></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_whistle">
                            <asp:TableCell runat="server" ID="TableCell24" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label15" runat="server" Text="Whistle Blowing"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell25" SkinID="DataFieldStyle">
                                <asp:DropDownList ID="whistle" runat="server" SelectedValue='<%# Bind("whistle") %>'
                                    DataSourceID="ds_whistle" AutoPostBack="True" DataTextField="vyznam" DataValueField="cislo"  Width="550">
                                </asp:DropDownList>
                                <%--<br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator28" ControlToValidate="whistle"></kspwc:TRequiredValidator>--%>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_responsible">
                            <asp:TableCell runat="server" ID="TableCell26" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label16" runat="server" Text="[%Řešitel%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell27" SkinID="DataFieldStyle">
                                <asp:DropDownList ID="responsible" runat="server" SelectedValue='<%# Bind("responsible") %>'
                                    DataSourceID="ds_responsible" AutoPostBack="True" DataTextField="jmeno_os_cislo" DataValueField="os_cislo"  Width="550">
                                </asp:DropDownList>
                                <%--<br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator29" ControlToValidate="responsible"></kspwc:TRequiredValidator>--%>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_fu1">
                            <asp:TableCell runat="server" ID="TableCell28" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label17" runat="server" Text="FU 1"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell29" SkinID="DataFieldStyle">
                                <asp:TextBox ID="fu1" runat="server" Text='<%# Bind("fu1") %>' MaxLength="400" TextMode="MultiLine"  Width="550" Height="120"></asp:TextBox>
                                <%--<br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator30" ControlToValidate="fu1"></kspwc:TRequiredValidator>--%>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_fu2">
                            <asp:TableCell runat="server" ID="TableCell30" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label18" runat="server" Text="FU 2"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell31" SkinID="DataFieldStyle">
                                <asp:TextBox ID="fu2" runat="server" Text='<%# Bind("fu2") %>' MaxLength="400" TextMode="MultiLine"  Width="550" Height="120"></asp:TextBox>
                               <%-- <br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator31" ControlToValidate="fu2"></kspwc:TRequiredValidator>--%>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_fu3">
                            <asp:TableCell runat="server" ID="TableCell32" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label19" runat="server" Text="FU 3"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell33" SkinID="DataFieldStyle">
                                <asp:TextBox ID="fu3" runat="server" Text='<%# Bind("fu3") %>' MaxLength="400" TextMode="MultiLine"  Width="550" Height="120"></asp:TextBox>
                                <%--<br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator32" ControlToValidate="fu3"></kspwc:TRequiredValidator>--%>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_fu1_date">
                            <asp:TableCell runat="server" ID="TableCell34" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label20" runat="server" Text="FU 1 date"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell35" SkinID="DataFieldStyle">
                                <%--<asp:TextBox ID="fu1_date" runat="server" Text='<%# Bind("fu1_date", "{0:d}") %>'></asp:TextBox>--%>
                                <%--<wc:DateControl runat="server" ID="fu1_date" Datum='<%# _date(Container.DataItem, "fu1_date") %>' />--%>
                                <kspwc:TRadDatePicker runat="server" ID="fu1_date" DbSelectedDate='<%# Bind("fu1_date") %>' /> 
                                <%--<br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator33" ControlToValidate="fu1_date"></kspwc:TRequiredValidator>       --%>                      
                                </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_typ_pole">
                            <asp:TableCell runat="server" ID="TableCell36" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label21" runat="server" Text="[%Typ%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell37" SkinID="DataFieldStyle">
                                <asp:DropDownList ID="typ_pole" runat="server" SelectedValue='<%# Bind("typ_pole") %>'
                                    DataSourceID="ds_typ_pole" AutoPostBack="True" DataTextField="vyznam" DataValueField="cislo"  Width="550">
                                </asp:DropDownList>
                                <%--<br />
                                <kspwc:TRequiredValidator runat="server" ID="TRequiredValidator34" ControlToValidate="typ_pole"></kspwc:TRequiredValidator>--%>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRow5">
                            <asp:TableCell runat="server" ID="TableCell50" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label26" runat="server" Text="[%Poznámka%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell51" SkinID="DataFieldStyle">
                                <asp:TextBox ID="poznamka" runat="server" Text='<%# Bind("poznamka") %>' MaxLength="400" TextMode="MultiLine"  Width="550" Height="120">
                                </asp:TextBox>
                            </asp:TableCell>
                        </asp:TableRow>
                    </asp:Table>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </EditItemTemplate>
    <ItemTemplate>
        <asp:Table runat="server" ID="titled_panel" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Hlášení konfliktu%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow7">
                <asp:TableCell runat="server" ID="TableCell47">
                    <asp:Table runat="server" ID="table1">
                        <asp:TableRow runat="server" ID="r_os_cislo">
                            <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label1" runat="server" Text="[%Os. číslo%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="c_os_cislo" SkinID="DataFieldStyle">
                                <asp:Label ID="os_cislo" runat="server" Text='<%# Bind("os_cislo") %>' Width="550"></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRow4">
                            <asp:TableCell runat="server" ID="TableCell44" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label2" runat="server" Text="[%Příjmení a jméno%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell45" SkinID="DataFieldStyle">
                                <asp:Label ID="jmeno" runat="server" Text='<%# Bind("jmeno") %>'  Width="550" ></asp:Label></asp:TableCell>
                        </asp:TableRow>
                       
                         <asp:TableRow runat="server" ID="TableRow9">
                            <asp:TableCell runat="server" ID="TableCell52" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label28" runat="server" Text="[%Pracovní pozice%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell53" SkinID="DataFieldStyle">
                                <asp:Label ID="label_prac_misto" runat="server" Text='<%# Bind("prac_misto") %>'  Width="550" ></asp:Label></asp:TableCell>
                        </asp:TableRow>

                        <asp:TableRow runat="server" ID="r_datum">
                            <asp:TableCell runat="server" ID="TableCell2" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label3" runat="server" Text="[%Datum%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                                <asp:Label ID="datum" runat="server" Text='<%# Bind("datum", "{0:d}") %>'></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRow6">
                            <asp:TableCell runat="server" ID="TableCell48" SkinID="DataFieldHeaderStyle">
                                <asp:Label runat="server" ID="Label4" Text="[%Požadované datum vyřízení%]"></asp:Label></asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell49" SkinID="DataFieldStyle">
                                <asp:Label runat="server" ID="dat_vyriz" Text='<%# Bind("vyridit_do", "{0:d}") %>' ></asp:Label>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRow1">
                            <asp:TableCell runat="server" ID="TableCell38" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label22" runat="server" Text="[%Typ konfliktu%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell39" SkinID="DataFieldStyle">
                                <asp:Label ID="Label25" runat="server" Text='<%# Bind("event_type_popis") %>'></asp:Label>
                                <asp:Label ID="text_event_type" runat="server" Text='<%# Bind("event_type") %>' Style="display:none;"></asp:Label>
                            </asp:TableCell>
                        </asp:TableRow>
                        <%--<asp:TableRow runat="server" ID="r_sub_fo">
                            <asp:TableCell runat="server" ID="TableCell4" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label5" runat="server" Text="[%Související fyzická osoba%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell5" SkinID="DataFieldStyle">
                                <asp:Label ID="sub_fo_popis" runat="server" Text='<%# Bind("sub_fo_popis") %>'  Width="550" Height="120"></asp:Label></asp:TableCell>
                        </asp:TableRow>--%>
                        <asp:TableRow runat="server" ID="r_sub_po">
                            <asp:TableCell runat="server" ID="TableCell6" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label6" runat="server" Text="[%Související subjekt(název společnosti/jméno fyzické osoby)%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell7" SkinID="DataFieldStyle">
                                <asp:Label ID="sub_po" runat="server" Text='<%# Bind("sub_po") %>'  Width="550" Height="120"></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_dept">
                            <asp:TableCell runat="server" ID="TableCell10" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label8" runat="server" Text="[%Útvar%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell11" SkinID="DataFieldStyle">
                                <asp:Label ID="dept" runat="server" Text='<%# Bind("dept_popis") %>'  Width="550"></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_type_of_rel">
                            <asp:TableCell runat="server" ID="TableCell8" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label7" runat="server" Text="[%Typ vztahu%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell9" SkinID="DataFieldStyle">
                                <asp:Label ID="type_of_rel_popis" runat="server" Text='<%# Bind("type_of_rel_popis") %>'  Width="550" ></asp:Label>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_amount">
                            <asp:TableCell runat="server" ID="TableCell12" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label9" runat="server" Text="[%Hodnota / částka%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell13" SkinID="DataFieldStyle">
                                <asp:Label ID="amount" runat="server" Text='<%# Bind("amount") %>'  Width="550" ></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_trans">
                            <asp:TableCell runat="server" ID="TableCell14" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label10" runat="server" Text="[%Transakce%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell15" SkinID="DataFieldStyle">
                                <asp:Label ID="trans" runat="server" Text='<%# Bind("trans_cely") %>'  Width="550" Height="120"></asp:Label>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_isin">
                            <asp:TableCell runat="server" ID="TableCell16" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label11" runat="server" Text="ISIN"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell17" SkinID="DataFieldStyle">
                                <asp:Label ID="isin" runat="server" Text='<%# Bind("isin") %>'  Width="550" Height="120"></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_title">
                            <asp:TableCell runat="server" ID="TableCell18" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label12" runat="server" Text="[%Titul%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell19" SkinID="DataFieldStyle">
                                <asp:Label ID="title" runat="server" Text='<%# Bind("title") %>'  Width="550" Height="120"></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_description">
                            <asp:TableCell runat="server" ID="TableCell20" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label13" runat="server" Text="[%Popis%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell21" SkinID="DataFieldStyle">
                                <asp:Label ID="description" runat="server" Text='<%# Bind("description") %>'  Width="550" Height="120"></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_rejection">
                            <asp:TableCell runat="server" ID="TableCell22" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label14" runat="server" Text="[%Odmítnutí%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell23" SkinID="DataFieldStyle">
                                <asp:Label ID="rejection" runat="server" Text='<%# _ano_ne(Container.DataItem, "rejection") %>'  Width="550"></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_whistle">
                            <asp:TableCell runat="server" ID="TableCell24" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label15" runat="server" Text="Whistle Blowing"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell25" SkinID="DataFieldStyle">
                                <asp:Label ID="whistle" runat="server" Text='<%# Bind("whistle_popis") %>'  Width="550"></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_responsible">
                            <asp:TableCell runat="server" ID="TableCell26" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label16" runat="server" Text="[%Řešitel%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell27" SkinID="DataFieldStyle">
                                <asp:Label ID="responsible" runat="server" Text='<%# Bind("responsible_popis") %>'  Width="550"></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_fu1">
                            <asp:TableCell runat="server" ID="TableCell28" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label17" runat="server" Text="FU 1"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell29" SkinID="DataFieldStyle">
                                <asp:Label ID="fu1" runat="server" Text='<%# Bind("fu1") %>'  Width="550" Height="120"></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_fu2">
                            <asp:TableCell runat="server" ID="TableCell30" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label18" runat="server" Text="FU 2"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell31" SkinID="DataFieldStyle">
                                <asp:Label ID="fu2" runat="server" Text='<%# Bind("fu2") %>'  Width="550" Height="120"></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_fu3">
                            <asp:TableCell runat="server" ID="TableCell32" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label19" runat="server" Text="FU 3"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell33" SkinID="DataFieldStyle">
                                <asp:Label ID="fu3" runat="server" Text='<%# Bind("fu3") %>'  Width="550" Height="120"></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_fu1_date">
                            <asp:TableCell runat="server" ID="TableCell34" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label20" runat="server" Text="FU 1 date"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell35" SkinID="DataFieldStyle">
                                <asp:Label ID="fu1_date" runat="server" Text='<%# Bind("fu1_date", "{0:d}") %>'></asp:Label></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="r_typ_pole">
                            <asp:TableCell runat="server" ID="TableCell36" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label21" runat="server" Text="[%Typ%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell37" SkinID="DataFieldStyle">
                                <asp:Label ID="typ_pole" runat="server" Text='<%# Bind("typ_pole_popis") %>'  Width="550"></asp:Label>
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow runat="server" ID="TableRow5">
                            <asp:TableCell runat="server" ID="TableCell50" SkinID="DataFieldHeaderStyle">
                                <asp:Label ID="Label26" runat="server" Text="[%Poznámka%]"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell runat="server" ID="TableCell51" SkinID="DataFieldStyle">
                                 <asp:Label ID="Label27" runat="server" Text='<%# Bind("poznamka") %>'  Width="550" Height="120"></asp:Label>
                            </asp:TableCell>
                        </asp:TableRow>
                    </asp:Table>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </ItemTemplate>
</asp:FormView>
