﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOdokument.ascx.cs" Inherits="KSPortal.Controls.ZadostOdokument" %>
<%@ Register assembly="WebControls" namespace="KSProgram.WebControls" tagprefix="kspwc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register assembly="AjaxControlToolkit" namespace="AjaxControlToolkit" tagprefix="cc1" %>


<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
<script type="text/javascript" id="telerikClientEvents1">
//<![CDATA[
    function TRCB_Jmeno_ItemsRequesting(sender, args) {
        var context = args.get_context();
        context["contextKey"] = "dokument_pro";
    }
    function TRCB_Jmeno_ItemsRequested(sender, eventArgs) {
        var items = sender.get_items();

        for (var itemIndex = 0; itemIndex < items.get_count(); itemIndex++) {
            var item = items.getItem(itemIndex);

            var s = item.get_attributes().getAttribute("s");
            if (s == "v")
                item.get_element().style.color = "red";
            else if (s == "b")
                item.get_element().style.color = "blue";
        }
    }
//]]>
</script>
</telerik:RadScriptBlock>
<%--TypeName="KSProgram.Pozadavky.Pozadavekdokument"--%>
<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Retrieve"  InsertMethod="Insert"
    UpdateMethod="Update" OnInserted="ObjectDataSource1_Inserted" OnInserting="ObjectDataSource1_Inserting" >
    <InsertParameters>
        <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" Direction="InputOutput" />
        <asp:Parameter Name="koho_osc" Type="Decimal" />
        <asp:Parameter Name="koho_cislo_pom" Type="Int16" />        
        <asp:Parameter Name="druh_dok" Type="String" />
        <asp:Parameter Name="dat_prijeti" Type="DateTime" />
        <asp:Parameter Name="dat_vystaveni" Type="DateTime" />
        <asp:Parameter Name="poznamka" Type="String" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="adresat" Type="Decimal" />
        <asp:Parameter Name="novy_stav" Type="String" />
        <asp:Parameter Name="duvod" Type="String" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32"/>
        <asp:Parameter Name="koho_osc" Type="Decimal" />
        <asp:Parameter Name="koho_cislo_pom" Type="Int16" />        
        <asp:Parameter Name="druh_dok" Type="String" />
        <asp:Parameter Name="dat_prijeti" Type="DateTime" />
        <asp:Parameter Name="dat_vystaveni" Type="DateTime" />
        <asp:Parameter Name="poznamka" Type="String" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />       
    </UpdateParameters>
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" DefaultValue="0" />
    </SelectParameters>    
</asp:ObjectDataSource>



<asp:ObjectDataSource runat="server" ID="ds_druh_dok" 
    OldValuesParameterFormatString="original_{0}" SelectMethod="RetrieveFiltered" TypeName="KSProgram.Ciselniky.CisDruhyDokumentu" >
    <SelectParameters>
        <asp:Parameter Name="pridatPrazdnyRadek" Type="Boolean" DefaultValue="true" />
        <asp:Parameter Name="agenda" Type="String" DefaultValue="ZadostODokument.ascx" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:FormView ID="FormView1" runat="server" OnItemInserted="FormView1_ItemInserted"
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound" DataSourceID="ObjectDataSource1">
    <ItemTemplate>
        <asp:Table runat="server" ID="TableItem" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Požadavek na dokument%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%#  KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(Eval("zadatel_osc"))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow2">
                <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label14" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Druh dokumentu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell8">
                    <asp:Label ID="Label15" runat="server" Text='<%# KSProgram.Ciselniky.CisDruhyDokumentu.DruhNazev(Convert.ToString(Eval("druh_dok"))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowItem1">
                <asp:TableCell runat="server" ID="TableCellItem1" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label6x" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Dokument se týká zaměstnance%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle" ID="TableCellItem2">
                    <asp:Label ID="Label5" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "koho_osc").Equals(DBNull.Value) ? string.Empty : KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(Eval("koho_osc"))) %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label12" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Číslo poměru%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle" ID="TableCell6">
                    <asp:Label ID="Label13" runat="server" Text='<%# Eval("koho_cislo_pom") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowItem2">
                <asp:TableCell runat="server" ID="TableCellItem3" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label1x" SkinID="DataFieldHeaderStyle" runat="server" Text="[%Datum přijetí dokumentu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem4" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelOd" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(Eval("dat_prijeti"), "d") %>'></asp:Label>
                </asp:TableCell>
               
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow4">                
                <asp:TableCell runat="server" ID="TableCell10" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label16" runat="server" Text="[%Datum vystavení dokumentu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell11" SkinID="DataFieldStyle">
                    <asp:Label ID="Label17" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(Eval("dat_vystaveni"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowItem3">
                <asp:TableCell runat="server" ID="TableCellItem7" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label3x" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem8" SkinID="DataFieldStyle">                    
                    <telerik:RadTextBox ID="LabelDuvodx" runat="server" Text='<%# Eval("poznamka") %>' Height="59px" 
                        Width="200px" TextMode="MultiLine" ReadOnly="true"></telerik:RadTextBox>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowItem4">
                <asp:TableCell runat="server" ID="TableCellItem9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label4x" runat="server" Text="[%Vyřešit do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem10" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDatvyrizeni" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(Eval("vyridit_do"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </ItemTemplate>

    <EditItemTemplate>
        <asp:Table runat="server" ID="TableEdit" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowEidt">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Úprava požadavku na dokument%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRowEdit1a">
                <asp:TableCell runat="server" ID="TableCell1aedit" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8aedit" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(Eval("zadatel_osc"))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowEdit1">
                <asp:TableCell runat="server" ID="TableCellEdit2" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label6x" runat="server" Text="[%Druh dokumentu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit3" ColumnSpan="3" SkinID="DataFieldStyle">
                    <%--<asp:DropDownList runat="server" ID="ddl_druh_dok" DataTextField="nazev" DataValueField="id" DataSourceID="ds_druh_dok" 
                        SelectedValue='<%# Bind("druh_dok") %>'></asp:DropDownList>--%>
                    <telerik:RadDropDownList runat="server" ID="ddl_druh_dok" CssClass="povinne-pole" DataTextField="nazev" DataValueField="id" DataSourceID="ds_druh_dok" SelectedValue='<%# Bind("druh_dok") %>' Width="200px"></telerik:RadDropDownList>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="[%Povinné pole%]" ControlToValidate="ddl_druh_dok" Display="Dynamic"></asp:RequiredFieldValidator>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow3">
                <asp:TableCell runat="server" ID="TableCell1" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Dokument se týká zaměstnance%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle" ID="TableCell3">
                    <asp:HiddenField ID="HF_koho_osc" runat="server" Value='<%# Bind("koho_osc") %>' />
                    <asp:Label ID="Label10" runat="server" Text='<%# ( DataBinder.Eval(Container.DataItem, "koho_osc").Equals(DBNull.Value) ? string.Empty : KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "koho_osc")))) %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">                    
                    <asp:Label ID="Label12" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Číslo poměru%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle" ID="TableCell6">
                    <asp:HiddenField ID="HF_koho_cislo_pom" runat="server" Value='<%# Bind("koho_cislo_pom") %>' />
                    <asp:Label ID="Label13" runat="server" Text='<%# Eval("koho_cislo_pom") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
                        
            <asp:TableRow runat="server" ID="TableRowEdit2">
                <asp:TableCell runat="server" ID="TableCellEdit4" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label1x" runat="server" Text="[%Datum přijetí dokumentu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellEdit5" SkinID="DataFieldStyle">                    
                    <kspwc:TRadDatePicker ID="TextBoxOdEdit" runat="server" DbSelectedDate='<%# Bind("dat_prijeti") %>'>
                    </kspwc:TRadDatePicker>
                </asp:TableCell>                
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow5">                
                <asp:TableCell runat="server" ID="TableCell12" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label11" runat="server" Text="[%Datum vystavení dokumentu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell13" SkinID="DataFieldStyle">                   
                    <kspwc:TRadDatePicker ID="TRadDatePicker2" runat="server" DbSelectedDate='<%# Bind("dat_vystaveni") %>'>
                    </kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowEdit3">
                <asp:TableCell runat="server" ID="TableCellEdit8" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3x" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellEdit9" SkinID="DataFieldStyle">
                    <asp:TextBox ID="LabelDuvodx" runat="server" Text='<%# Bind("poznamka") %>' MaxLength="999"
                        TextMode="MultiLine" Width="284px" Height="200"></asp:TextBox><br />
                    <kspwc:TextValidator runat="server" ID="val1" ControlToValidate="LabelDuvodx"></kspwc:TextValidator>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowEdit4">
                <asp:TableCell runat="server" ID="TableCellEdit10" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellEdit11" SkinID="DataFieldStyle">                    
                    <kspwc:TRadDatePicker ID="TextBoxDatVyrizeniEdit" DbSelectedDate='<%# Bind("vyridit_do") %>'
                        runat="server">
                    </kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>
            
        </asp:Table>
    </EditItemTemplate>
    <InsertItemTemplate>
        <asp:Table runat="server" ID="TableInsert" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="THRI">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Nový požadavek na dokument%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TRI1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label_zam" runat="server" Text='<%# KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(KSProgram.Pozadavky.PozadavekZpracovaniAbstract.VydavatelProNovyPoz()) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TRI2">
                <asp:TableCell runat="server" ID="TableCellEdit2" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label6x" runat="server" Text="[%Druh dokumentu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit3" ColumnSpan="3" SkinID="DataFieldStyle">
                    <telerik:RadDropDownList runat="server" ID="ddl_druh_dok" CssClass="povinne-pole" DataTextField="nazev" DataValueField="id" DataSourceID="ds_druh_dok" SelectedValue='<%# Bind("druh_dok") %>' Width="200px"></telerik:RadDropDownList>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="[%Povinné pole%]" ControlToValidate="ddl_druh_dok" Display="Dynamic"></asp:RequiredFieldValidator>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TRI3">
                <asp:TableCell runat="server" ID="TableCell1" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Dokument se týká zaměstnance%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle" ID="TableCell3">
                    <kspwc:TRadComboBox ID="TRCB_Jmeno" runat="server" 
                        EnableLoadOnDemand="True"
                        EnableVirtualScrolling="True" Height="150px" ShowMoreResultsBox="True" DropDownAutoWidth="Enabled"
                        AutoPostBack="True"  
                        OnClientItemsRequesting="TRCB_Jmeno_ItemsRequesting"  OnClientItemsRequested="TRCB_Jmeno_ItemsRequested"
                        OnTextChanged="TRCB_Jmeno_TextChanged" EmptyMessage='<%# WebControlHelper.ZmenaTextu("[%Jméno%]") %>' CausesValidation="False" Width="200px">
                        <WebServiceSettings Method="JmenoZam2" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                    </kspwc:TRadComboBox>
                    <br />
                    <telerik:RadTextBox ID="TextBoxOsCislo" runat="server" Text='<%# Bind("koho_osc") %>' CausesValidation="True" EmptyMessage='<%# WebControlHelper.ZmenaTextu("[%Os. číslo%]") %>'
                        AutoPostBack="True" OnTextChanged="TextBoxOsCislo_TextChanged" Width="200px"></telerik:RadTextBox>
                                        
                    <asp:CustomValidator ID="cv_platne_os_cislo" runat="server" ErrorMessage="[%Neplatné osobní číslo nebo neaktivní zaměstnanec%]"
                        ControlToValidate="TextBoxOsCislo" OnServerValidate="cv_platne_os_cislo_validate"></asp:CustomValidator>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TRI4">
                <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label12" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Číslo poměru%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle" ID="TableCell6">  
                    <asp:ObjectDataSource runat="server" ID="ds_pomery" 
                        OldValuesParameterFormatString="original_{0}" SelectMethod="GetPomery" TypeName="KSProgram.Funkce.Prac_pom" >
                        <SelectParameters>
                            <asp:Parameter Name="co" Type="String" DefaultValue="p" />
                            <asp:ControlParameter DefaultValue="0" Name="os_cislo" Type="Decimal" ControlID="TextBoxOsCislo" PropertyName="Text" />
                        </SelectParameters>
                    </asp:ObjectDataSource>                  
                    <telerik:RadDropDownList runat="server" ID="ddl_pomery" DataTextField="cislo_druh_nazev" DataValueField="cislo_pom" DataSourceID="ds_pomery" Width="200px">
                    </telerik:RadDropDownList> <%--SelectedValue='<%# Bind("koho_cislo_pom") %>'--%>
                </asp:TableCell>
            </asp:TableRow>
                        
            <asp:TableRow runat="server" ID="TRI5">
                <asp:TableCell runat="server" ID="TCInsert3" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label1" runat="server" Text="[%Datum přijetí dokumentu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TCInsert4" SkinID="DataFieldStyle">                    
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxOdInsert" DbSelectedDate='<%# Bind("dat_prijeti") %>' 
                        Calendar-CultureInfo="cs-CZ" Calendar-Culture="cs-CZ" DatePopupButton-ToolTip="Otevřít kalendář">
                    </kspwc:TRadDatePicker>
                </asp:TableCell>                
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TRI6">                
                <asp:TableCell runat="server" ID="TableCell14" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label18" runat="server" Text="[%Datum vystavení dokumentu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell15" SkinID="DataFieldStyle">                   
                    <kspwc:TRadDatePicker runat="server" ID="TRadDatePicker3" DbSelectedDate='<%# Bind("dat_vystaveni") %>' 
                        Calendar-CultureInfo="cs-CZ" Calendar-Culture="cs-CZ" DatePopupButton-ToolTip="Otevřít kalendář">
                    </kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TRI7">
                <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert8" ColumnSpan="3" SkinID="DataFieldStyle">                   
                    <telerik:RadTextBox ID="LabelDuvod" runat="server" Text='<%# Bind("poznamka") %>' MaxLength="999"
                        TextMode="MultiLine" Width="283px" Height="200"></telerik:RadTextBox>
                    <kspwc:TextValidator runat="server" ID="val2" ControlToValidate="LabelDuvod"></kspwc:TextValidator>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TRI8">
                <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="3" SkinID="DataFieldStyle">                    
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniInsert" DbSelectedDate='<%# Bind("vyridit_do") %>'>
                    </kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>
            
        </asp:Table>
    </InsertItemTemplate>
    <FooterTemplate>
        
    </FooterTemplate>
</asp:FormView>