/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.scheduler.view.min",["kendo.core.min"],function(){var e={id:"scheduler.view",name:"Scheduler View",category:"web",description:"The Scheduler Common View",depends:["core"],hidden:true},t,v=(kendo.ui.scheduler={},window.kendo.jQuery),g=window.kendo,r=g.ui,n=g.date.getDate,i=r.Widget,c=g._outerHeight,d=g.keys,o=".kendoSchedulerView",s="k-event-inverse",f=1024,u=Math,l=" ";function h(t,i){var o=[];function s(t,e){e=e[i];if(e){var n=o[t]=o[t]||[];for(var r=0;r<e.length;r++){n.push(e[r]);s(t+1,e[r])}}}s(0,t);return o}function p(t,e){if(!t.length)return"";return'<table role="presentation" class="'+g.trim("k-scheduler-table "+(e||""))+'">'+"<tr>"+t.join("</tr><tr>")+"</tr>"+"</table>"}function m(t,e){if(!t.length)return"";return"<div style='position:relative'>"+p(t,e)+"</div>"}function S(t,e,n){var r=[];if(n>0)for(var i=0;i<t;i++)r.push("<th>&#8203;</th>");if(e)r.push('<th class="k-scheduler-times-all-day">'+e.text+"</th>");if(n<1)return v();return v('<div class="k-scheduler-times">'+p(r)+"</div>")}function y(){return v('<div class="k-scheduler-content">'+'<table role="presentation" class="k-scheduler-table"></table>'+"</div>")}var C='<div class="k-marquee k-scheduler-marquee">'+'<div class="k-marquee-color"></div>'+'<div class="k-marquee-text">'+'<div class="k-label-top"></div>'+'<div class="k-label-bottom"></div>'+"</div>"+"</div>",D=g.Class.extend({init:function(t,e,n){this._index=t;this._timeSlotCollections=[];this._daySlotCollections=[];this._isRtl=e;this._enforceAllDaySlot=n},addTimeSlotCollection:function(t,e){return this._addCollection(t,e,this._timeSlotCollections)},addDaySlotCollection:function(t,e){return this._addCollection(t,e,this._daySlotCollections)},_addCollection:function(t,e,n){var r=new k(t,e,this._index,n.length);n.push(r);return r},timeSlotCollectionCount:function(){return this._timeSlotCollections.length},daySlotCollectionCount:function(){return this._daySlotCollections.length},daySlotByPosition:function(t,e,n){return this._slotByPosition(t,e,this._daySlotCollections,n)},timeSlotByPosition:function(t,e,n){return this._slotByPosition(t,e,this._timeSlotCollections,n)},_slotByPosition:function(t,e,n,u){for(var r=0;r<n.length;r++){var i=n[r];for(var o=0;o<i.count();o++){var s=i.at(o);var h=s.offsetWidth;var c=s.offsetHeight;var l;var a=s.offsetLeft+h;var f=s.offsetTop+c;if(!u)l=i.at(o+1);if(l)if(l.offsetLeft!=s.offsetLeft)if(this._isRtl)a=s.offsetLeft+(s.offsetLeft-l.offsetLeft);else a=l.offsetLeft;else f=l.offsetTop;if(t>=s.offsetLeft&&t<a&&e>=s.offsetTop&&e<f)return s}}},refresh:function(){var t;for(t=0;t<this._daySlotCollections.length;t++)this._daySlotCollections[t].refresh();for(t=0;t<this._timeSlotCollections.length;t++)this._timeSlotCollections[t].refresh()},timeSlotRanges:function(t,e){var n=this._timeSlotCollections;var r=this._startSlot(t,n);var i,o;if(!r.inRange&&t>=r.slot.end){i=r.slot.collectionIndex+1;r=null}var s=r;if(t<e)s=this._endSlot(e,n);if(s&&!s.inRange&&e<=s.slot.start){o=s.slot.collectionIndex;if(e===s.slot.start&&(r&&o>r.slot.collectionIndex||o>i))o-=1;s=null}if(r===null&&s===null)if(e-t<g.date.MS_PER_DAY)return[];else{r={inRange:true,slot:n[i].first()};s={inRange:true,slot:n[o].last()}}if(r===null){if(s.slot.end<=t)return[];r={inRange:true,slot:(n[i]||n[s.slot.collectionIndex]).first()}}if(s===null){if(r.slot.start>=e)return[];s={inRange:true,slot:(n[o]||n[r.slot.collectionIndex]).last()}}return this._continuousRange(w,n,r,s)},daySlotRanges:function(t,e,n){var r=this._daySlotCollections;var i=this._startSlot(t,r,n);if(!i.inRange&&t>=i.slot.end)i=null;var o=i;if(t<e)o=this._endSlot(e,r,n);if(o&&!o.inRange&&e<=o.slot.start)o=null;if(i===null&&o===null)return[];if(i===null){if(o.slot.end<=t)return[];do{t+=g.date.MS_PER_DAY;i=this._startSlot(t,r,n)}while(!i.inRange&&t>=i.slot.end)}if(o===null){if(i.slot.start>=e)return[];do{e-=g.date.MS_PER_DAY;o=this._endSlot(e,r,n)}while(!o.inRange&&e<=o.slot.start)}return this._continuousRange(x,r,i,o)},_continuousRange:function(u,h,c,d){var t=c.slot;var e=d.slot;var n=t.collectionIndex;var r=e.collectionIndex;var v=[];for(var i=n;i<=r;i++){var o=h[i];var s=o.first();var l=o.last();var a=false;var f=false;if(i==n)f=!c.inRange;if(i==r)a=!d.inRange;if(s.start<t.start)s=t;if(l.start>e.start)l=e;if(n<r)if(i==n)a=true;else if(i==r)f=true;else a=f=true;v.push(new u({start:s,end:l,collection:o,head:a,tail:f}))}return v},slotRanges:function(t,e){var n=t._startTime||g.date.toUtcTime(t.start);var r=t._endTime||g.date.toUtcTime(t.end);if(e===undefined)if(this._enforceAllDaySlot)e=t.isMultiDay();else e=t.isAllDay;if(e)return this.daySlotRanges(n,r,t.isAllDay);return this.timeSlotRanges(n,r)},ranges:function(t,e,n,r){if(typeof t!="number")t=g.date.toUtcTime(t);if(typeof e!="number")e=g.date.toUtcTime(e);if(n)return this.daySlotRanges(t,e,r);return this.timeSlotRanges(t,e)},_startCollection:function(t,e){for(var n=0;n<e.length;n++){var r=e[n];if(r.startInRange(t))return r}return null},_endCollection:function(t,e,n){for(var r=0;r<e.length;r++){var i=e[r];if(i.endInRange(t,n))return i}return null},_getCollections:function(t){return t?this._daySlotCollections:this._timeSlotCollections},continuousSlot:function(t,e){var n=e?-1:1;var r=this._getCollections(t.isDaySlot);var i=r[t.collectionIndex+n];return i?i[e?"last":"first"]():undefined},firstSlot:function(){var t=this._getCollections(this.daySlotCollectionCount());return t[0].first()},lastSlot:function(){var t=this._getCollections(this.daySlotCollectionCount());return t[t.length-1].last()},upSlot:function(t,i,e){var o=this;var n=function(t,e,n){var r=n===0;if(!i&&!t&&r&&o.daySlotCollectionCount())return o._daySlotCollections[0].at(e)};if(!this.timeSlotCollectionCount())i=true;return this._verticalSlot(t,-1,n,e)},downSlot:function(t,r,e){var i=this;var n=function(t,e,n){if(!r&&t&&i.timeSlotCollectionCount())return i._timeSlotCollections[n].at(0)};if(!this.timeSlotCollectionCount())r=true;return this._verticalSlot(t,1,n,e)},leftSlot:function(t,e){return this._horizontalSlot(t,-1,e)},rightSlot:function(t,e){return this._horizontalSlot(t,1,e)},_horizontalSlot:function(t,e,n){var r=t.index;var i=t.isDaySlot;var o=t.collectionIndex;var s=this._getCollections(i);i=n?false:i;if(i)r+=e;else o+=e;var l=s[o];return l?l.at(r):undefined},_verticalSlot:function(t,e,n,r){var i=t.index;var o=t.isDaySlot;var s=t.collectionIndex;var l=this._getCollections(o);t=n(o,s,i);if(t)return t;o=r?false:o;if(o)s+=e;else i+=e;var a=l[s];return a?a.at(i):undefined},_collection:function(t,e){var n=e?this._daySlotCollections:this._timeSlotCollections;return n[t]},_startSlot:function(t,e,n){var r=this._startCollection(t,e);var i=true;var o=0;if(!r){r=e[o];while(o<e.length-1&&r._start<t){o++;r=e[o]}i=false}var s=r.slotByStartDate(t,n);if(!s){s=r.first();i=false}return{slot:s,inRange:i}},_endSlot:function(t,e,n){var r=this._endCollection(t,e,n);var i=true;var o=e.length-1;if(!r){r=e[o];while(o>0&&r._start>t){o--;r=e[o]}i=false}var s=r.slotByEndDate(t,n);if(!s){if(t<=r.first().start)s=r.first();else s=r.last();i=false}return{slot:s,inRange:i}},getSlotCollection:function(t,e){return this[e?"getDaySlotCollection":"getTimeSlotCollection"](t)},getTimeSlotCollection:function(t){return this._timeSlotCollections[t]},getDaySlotCollection:function(t){return this._daySlotCollections[t]}}),b=g.Class.extend({init:function(t){v.extend(this,t)},innerHeight:function(){var t=this.collection;var e=this.start.index;var n=this.end.index;var r=0;for(var i=e;i<=n;i++)r+=t.at(i).offsetHeight;return r},events:function(){return this.collection.events()},addEvent:function(t){this.events().push(t)},startSlot:function(){if(this.start.offsetLeft>this.end.offsetLeft)return this.end;return this.start},endSlot:function(){if(this.start.offsetLeft>this.end.offsetLeft)return this.start;return this.end}}),w=b.extend({innerHeight:function(){var t=this.collection;var e=this.start.index;var n=this.end.index;var r=0;for(var i=e;i<=n;i++)r+=t.at(i).offsetHeight;return r},outerRect:function(t,e,n){return this._rect("offset",t,e,n)},_rect:function(t,e,n,u){var r;var h;var i;var o;var s=this.start;var l=this.end;var c=g.support.isRtl(s.element);if(typeof e!="number")e=g.date.toUtcTime(e);if(typeof n!="number")n=g.date.toUtcTime(n);if(u){r=s.offsetTop;h=l.offsetTop+l[t+"Height"];if(c){i=l.offsetLeft;o=s.offsetLeft+s[t+"Width"]}else{i=s.offsetLeft;o=l.offsetLeft+l[t+"Width"]}}else{var a=e-s.start;if(a<0)a=0;var d=s.end-s.start;r=s.offsetTop+s[t+"Height"]*a/d;var f=l.end-n;if(f<0)f=0;var v=l.end-l.start;h=l.offsetTop+l[t+"Height"]-l[t+"Height"]*f/v;if(c){i=Math.round(l.offsetLeft+l[t+"Width"]*f/v);o=Math.round(s.offsetLeft+s[t+"Width"]-s[t+"Width"]*a/d)}else{i=Math.round(s.offsetLeft+s[t+"Width"]*a/d);o=Math.round(l.offsetLeft+l[t+"Width"]-l[t+"Width"]*f/v)}}return{top:r,bottom:h,left:i===0?i:i+1,right:o}},innerRect:function(t,e,n){return this._rect("client",t,e,n)}}),x=b.extend({innerWidth:function(){var t=this.collection;var e=this.start.index;var n=this.end.index;var r=0;var i=e!==n?"offsetWidth":"clientWidth";for(var o=e;o<=n;o++)r+=t.at(o)[i];return r}}),k=g.Class.extend({init:function(t,e,n,r){this._slots=[];this._events=[];this._start=g.date.toUtcTime(t);this._end=g.date.toUtcTime(e);this._groupIndex=n;this._collectionIndex=r},refresh:function(){for(var t=0;t<this._slots.length;t++)this._slots[t].refresh()},startInRange:function(t){return this._start<=t&&t<this._end},endInRange:function(t,e){var n=e?t<this._end:t<=this._end;return this._start<=t&&n},slotByStartDate:function(t){var e=t;if(typeof e!="number")e=g.date.toUtcTime(t);for(var n=0;n<this._slots.length;n++){var r=this._slots[n];if(r.startInRange(e))return r}return null},slotByEndDate:function(t,e){var n=t;if(typeof n!="number")n=g.date.toUtcTime(t);if(e)return this.slotByStartDate(t,false);for(var r=0;r<this._slots.length;r++){var i=this._slots[r];if(i.endInRange(n))return i}return null},count:function(){return this._slots.length},events:function(){return this._events},addTimeSlot:function(t,e,n,r){var i=new I(t,e,n,this._groupIndex,this._collectionIndex,this._slots.length,r);this._slots.push(i)},addDaySlot:function(t,e,n,r){var i=new H(t,e,n,this._groupIndex,this._collectionIndex,this._slots.length,r);this._slots.push(i)},first:function(){return this._slots[0]},last:function(){return this._slots[this._slots.length-1]},at:function(t){return this._slots[t]}}),R=g.Class.extend({init:function(t,e,n,r,i,o){this.element=t;this.clientWidth=t.clientWidth;this.clientHeight=t.clientHeight;this.offsetWidth=t.offsetWidth;this.offsetHeight=t.offsetHeight;this.offsetTop=t.offsetTop;this.offsetLeft=t.offsetLeft;this.start=e;this.end=n;this.element=t;this.groupIndex=r;this.collectionIndex=i;this.index=o;this.isDaySlot=false},refresh:function(){var t=this.element;this.clientWidth=t.clientWidth;this.clientHeight=t.clientHeight;this.offsetWidth=t.offsetWidth;this.offsetHeight=t.offsetHeight;this.offsetTop=t.offsetTop;this.offsetLeft=t.offsetLeft},startDate:function(){return g.timezone.toLocalDate(this.start)},endDate:function(){return g.timezone.toLocalDate(this.end)},startInRange:function(t){return this.start<=t&&t<this.end},endInRange:function(t){return this.start<t&&t<=this.end},startOffset:function(){return this.start},endOffset:function(){return this.end}}),I=R.extend({init:function(t,e,n,r,i,o,s){R.fn.init.apply(this,arguments);this.isHorizontal=s?true:false},offsetX:function(t,e){if(t)return this.offsetLeft+e;else return this.offsetLeft+e},startInRange:function(t){return this.start<=t&&t<this.end},endInRange:function(t){return this.start<t&&t<=this.end},startOffset:function(t,e,n){if(n)return this.start;var r=v(this.element).offset();var i=this.end-this.start;var o;var s;if(this.isHorizontal){var l=g.support.isRtl(this.element);o=t-r.left;s=Math.floor(i*(o/this.offsetWidth));if(l)return this.start+i-s}else{o=e-r.top;s=Math.floor(i*(o/this.offsetHeight))}return this.start+s},endOffset:function(t,e,n){if(n)return this.end;var r=v(this.element).offset();var i=this.end-this.start;var o;var s;if(this.isHorizontal){var l=g.support.isRtl(this.element);o=t-r.left;s=Math.floor(i*(o/this.offsetWidth));if(l)return this.start+i-s}else{o=e-r.top;s=Math.floor(i*(o/this.offsetHeight))}return this.start+s}}),H=R.extend({init:function(t,e,n,r,i,o,s){R.fn.init.apply(this,arguments);this.eventCount=s;this.isDaySlot=true;if(this.element.children.length){var l=this.element.children[0];this.firstChildHeight=l.offsetHeight;this.firstChildTop=l.offsetTop}else{this.firstChildHeight=3;this.firstChildTop=0}},startDate:function(){var t=new Date(this.start);return g.timezone.apply(t,"Etc/UTC")},endDate:function(){var t=new Date(this.end);return g.timezone.apply(t,"Etc/UTC")},startInRange:function(t){return this.start<=t&&t<this.end},endInRange:function(t){return this.start<t&&t<=this.end}});function T(){t=t?t:g.support.scrollbar();return t}function L(t,e,n){var r,i,o,s,l;for(r=t.length-1;r>=0;r--){i=E(t[r]);o=i.start;l=i.end;s=o<=e&&l>=e;if(s||o>=e&&l<=n||e<=o&&n>=o){if(o<e)e=o;if(l>n)n=l}}return z(t,e,n)}function E(t){return{start:t.start,end:t.end}}function z(t,e,n){var r=[];for(var i=0;i<t.length;i++){var o=E(t[i]);if(o.start<e&&o.end>e||o.start>=e&&o.end<=n)r.push(t[i])}return r}function V(t){return G(t)}function A(t){return G(t)}g.ui.SchedulerView=i.extend({init:function(t,e){i.fn.init.call(this,t,v.extend({},this.options,e));this._normalizeOptions();this._scrollbar=T();this._isRtl=g.support.isRtl(t);this._resizeHint=v();this._moveHint=v();this._cellId=g.guid();this._resourcesForGroups();this._selectedSlots=[];this.element.attr("role","application")},options:{messages:{ariaEventLabel:{on:"on",at:"at",to:"to",allDay:"(all day)",prefix:""}}},visibleEndDate:function(){return this.endDate()},_normalizeOptions:function(){var t=this.options;if(t.startTime)t.startTime.setMilliseconds(0);if(t.endTime)t.endTime.setMilliseconds(0);if(t.workDayStart)t.workDayStart.setMilliseconds(0);if(t.workDayEnd)t.workDayEnd.setMilliseconds(0)},_isMobile:function(){var t=this.options;return t.mobile===true&&g.support.mobileOS||t.mobile==="phone"||t.mobile==="tablet"},_addResourceView:function(){var t=new D(this.groups.length,this._isRtl,this.options.enforceAllDaySlot);this.groups.push(t);return t},dateForTitle:function(){return g.format(this.options.selectedDateFormat,this.startDate(),this.endDate())},shortDateForTitle:function(){return g.format(this.options.selectedShortDateFormat,this.startDate(),this.endDate())},mobileDateForTitle:function(){return g.format(this.options.selectedMobileDateFormat||this.options.selectedShortDateFormat,this.startDate(),this.endDate())},_changeGroup:function(t,e){var n=e?"prevGroupSlot":"nextGroupSlot";var r=this[n](t.start,t.groupIndex,t.isAllDay);if(r)t.groupIndex+=e?-1:1;if(this._isGroupedByDate()&&!r)t.groupIndex=e?this.groups.length-1:0;return r},_changeDate:function(t,e,n){var r=this.groups[t.groupIndex];var i,o;if(n){i=r._getCollections(false);o=r.daySlotCollectionCount()?e.index-1:e.collectionIndex-1;if(o>=0)return i[o]._slots[i[o]._slots.length-1]}else{i=r._getCollections(r.daySlotCollectionCount());o=r.daySlotCollectionCount()?0:e.collectionIndex+1;var s=r.daySlotCollectionCount()?e.collectionIndex+1:0;if(i[o]&&i[o]._slots[s])return i[o]._slots[s]}},_changeGroupContinuously:function(){return null},_changeViewPeriod:function(){return false},_isInRange:function(t,e){if(!t||!e||!this.options.min||!this.options.max)return false;return n(t)<=n(this.options.min)||n(e)>=n(this.options.max)},_horizontalSlots:function(t,e,n,r){var i=r?"leftSlot":"rightSlot";var o={startSlot:e[0].start,endSlot:e[e.length-1].end};var s=this.groups[t.groupIndex];var u=this._isVerticallyGrouped();if(!n){var l=this._normalizeHorizontalSelection(t,e,r);if(l)o.startSlot=o.endSlot=l}if(this._isGroupedByDate()&&!n){var a=this._changeGroup(t,r);if(!a)o=this._getNextHorizontalRange(s,i,o);else o.startSlot=o.endSlot=a}else{o.startSlot=s[i](o.startSlot);o.endSlot=s[i](o.endSlot);if(!n&&!u&&(!o.startSlot||!o.endSlot))o.startSlot=o.endSlot=this._changeGroup(t,r)}var f;if((!o.startSlot||!o.endSlot)&&!this._isGroupedByDate()){f=this._continuousSlot(t,e,r);f=this._changeGroupContinuously(t,f,n,r);if(f)o.startSlot=o.endSlot=f}return o},_getNextHorizontalRange:function(t,e,n){if(!this._isVerticallyGrouped()){n.startSlot=t[e](n.startSlot);n.endSlot=t[e](n.endSlot)}return n},_verticalSlots:function(t,e,n,r){var i=this.groups[t.groupIndex];var o;var s={startSlot:e[0].start,endSlot:e[e.length-1].end};if(!n){o=this._normalizeVerticalSelection(t,e,r);if(o)s.startSlot=s.endSlot=o}var l=r?"upSlot":"downSlot";s=this._getNextVerticalRange(i,l,s,n);if(!n&&this._isVerticallyGrouped()&&(!s.startSlot||!s.endSlot))if(this._isGroupedByDate())s.startSlot=s.endSlot=this._changeDate(t,o,r);else s.startSlot=s.endSlot=this._changeGroup(t,r);return s},_getNextVerticalRange:function(t,e,n,r){n.startSlot=t[e](n.startSlot,r);n.endSlot=t[e](n.endSlot,r);return n},_normalizeHorizontalSelection:function(){return null},_normalizeVerticalSelection:function(t,e,n){var r;if(n)r=e[0].start;else r=e[e.length-1].end;return r},_continuousSlot:function(){return null},_footer:function(){var s=this;var l=s.options;if(s._isMobile()){var t='<div class="k-scheduler-footer k-toolbar" role="toolbar">';t+='<span class="k-scheduler-today"><a href="#" class="k-link">';t+=l.messages.today+"</a></span>";t+="</div>";s.footer=v(t).appendTo(s.element)}if(s.footer)s.footer.on("click"+o,".k-scheduler-today",function(t){t.preventDefault();var e=s.options.timezone;var n="today";var r=new Date;var i;if(e){var o=g.timezone.offset(r,e);i=g.timezone.convert(r,r.getTimezoneOffset(),o)}else i=r;s.trigger("navigate",{view:s.name||l.name,action:n,date:i})})},constrainSelection:function(t){var e=this.groups[0];var n;if(!this.inRange(t)){n=e.firstSlot();t.isAllDay=n.isDaySlot;t.start=n.startDate();t.end=n.endDate()}else if(!e.daySlotCollectionCount())t.isAllDay=false;else if(!e.timeSlotCollectionCount())t.isAllDay=true;if(!this.groups[t.groupIndex])t.groupIndex=0},move:function(t,e,n){var r=false;var i=this.groups[t.groupIndex];var u=this._isGroupedByDate()&&this._isVerticallyGrouped();if(!i.timeSlotCollectionCount())t.isAllDay=true;var o=i.ranges(t.start,t.end,t.isAllDay,false);var s,l,a,f;if(e===d.DOWN||e===d.UP){r=true;a=e===d.UP;this._updateDirection(t,o,n,a,true);f=this._verticalSlots(t,o,n,a);if(!f.startSlot&&!n&&this._changeViewPeriod(t,a,!u))return r}else if(e===d.LEFT||e===d.RIGHT){r=true;a=e===d.LEFT;this._updateDirection(t,o,n,a,false);f=this._horizontalSlots(t,o,n,a);if(!f.startSlot&&!n&&this._changeViewPeriod(t,a,u))return r}if(r){s=f.startSlot;l=f.endSlot;if(n){var h=t.backward;if(h&&s)t.start=s.startDate();else if(!h&&l)t.end=l.endDate()}else if(s&&l){t.isAllDay=s.isDaySlot;t.start=s.startDate();t.end=l.endDate()}t.events=[]}return r},moveToEventInGroup:function(u,t,e,n){var r=u._continuousEvents||[];var h,i;var o=n?-1:1;var s=r.length;var l=n?s-1:0;var a,f;if(e.length){f=e[e.length-1];if(n){for(a=0;a<r.length;a++)if(r[a].uid===f)l=a+o}else for(a=r.length-1;a>-1;a--)if(r[a].uid===f)l=a+o}while(l<s&&l>-1){i=r[l];if(!n&&i.start.startDate()>=t.startDate()||n&&i.start.startDate()<=t.startDate())if(i&&v.inArray(i.uid,e)===-1){h=!!i;break}l+=o}return i},moveToEvent:function(t,e){var n=t.groupIndex;var r=this.groups[n];var i=r.ranges(t.start,t.end,this.name==="month"||t.isAllDay,false)[0].start;var u=this.groups.length;var o=e?-1:1;var s=t.events;var l;if(this._isGroupedByDate()){var h=this._getAllEvents();var c=this._getUniqueEvents(h);var a=this._getSortedEvents(c);if(s.length===0){var d=this._getNextEventIndexBySlot(i,a,n);if(e)d--;l=a[d]}else{var f=this._getStartIdx(s,a);while(f<a.length&&f>-1){if(s.length>0)i=this._getSelectedSlot(i,a,l,f,o,e);if(!i)break;if(!e&&a[f].start.startDate()>=i.startDate()||e&&a[f].start.startDate()<=i.startDate())if(s[0]!=a[f].uid){l=a[f];break}f+=o}}}else while(n<u&&n>-1){l=this.moveToEventInGroup(r,i,s,e);n+=o;r=this.groups[n];if(!r||l)break;s=[];if(e)i=r.lastSlot();else i=r.firstSlot(true)}if(l){t.events=[l.uid];t.start=l.start.startDate();t.end=l.end.endDate();t.isAllDay=l.start.isDaySlot;t.groupIndex=l.start.groupIndex;t.eventElement=l.element[0]}return!!l},current:function(t){if(t!==undefined){this._current=t;if(this.content.has(t))this._scrollTo(t,this.content[0])}else return this._current},select:function(t){this.clearSelection();if(!this._selectEvents(t))this._selectSlots(t)},_getNextEventIndexBySlot:function(t,e,n){var r=0;var i=g.date.getDate(t.startDate());for(var o=0;o<e.length;o++){var s=g.date.getDate(e[o].start.startDate());if(i>s){r++;continue}if(i.getTime()===s.getTime()&&n>e[o].start.groupIndex){r++;continue}if(i.getTime()===s.getTime()&&n>=e[o].start.groupIndex&&t.startDate()>e[o].start.startDate()){r++;continue}break}return r},_getSelectedSlot:function(t,e,n,r,i,o){if(e[r+i]&&e[r].start.groupIndex!==e[r+i].start.groupIndex){var s=e[r+i].start.groupIndex;var l=this.groups[s];if(!l||n)t=null;if(o)t=l.lastSlot();else t=l.firstSlot(true)}return t},_getStartIdx:function(t,e){var n=0;v.each(e,function(){if(this.uid===t[0])return false;n++});return n},_getAllEvents:function(){var t=[];var e=this.groups;for(var n=0;n<e.length;n++)if(e[n]._continuousEvents)t=t.concat(e[n]._continuousEvents);return t},_getUniqueEvents:function(t){var e=[];for(var n=0;n<t.length;n++){var r=false;for(var i=0;i<e.length;i++)if(t[n].uid===e[i].uid){r=true;break}if(!r)e.push(t[n])}return e},_getSortedEvents:function(t){return t.sort(function(t,e){var n=t.start.startDate();var r=e.start.startDate();var i=g.date.getDate(n)-g.date.getDate(r);if(i===0)i=t.start.groupIndex-e.start.groupIndex;if(i===0)i=n.getTime()-r.getTime();if(i===0){if(t.start.isDaySlot&&!e.start.isDaySlot)i=-1;if(!t.start.isDaySlot&&e.start.isDaySlot)i=1}if(i===0)i=v(t.element).index()-v(e.element).index();return i})},_selectSlots:function(t){var e=t.isAllDay;var n=this.groups[t.groupIndex];if(!n.timeSlotCollectionCount())e=true;this._selectedSlots=[];var r=n.ranges(t.start,t.end,e,false);var i;var o;for(var s=0;s<r.length;s++){var l=r[s];var a=l.collection;for(var f=l.start.index;f<=l.end.index;f++){o=a.at(f);i=o.element;F(i);this._selectedSlots.push({start:o.startDate(),end:o.endDate(),element:i})}}if(t.backward)i=r[0].start.element;this.current(i)},_selectEvents:function(t){var e=false;var n=t.events;var r=this._getAllEvents();var i,o,s=r.length;if(!n[0]||!r[0])return e;var l=v();t.events=[];for(i=0;i<s;i++)if(v.inArray(r[i].uid,n)>-1){o=r[i];l=l.add(o.element);if(t.events.indexOf(o.uid)===-1)t.events.push(o.uid)}if(l[0]){l.addClass("k-selected");if(t.eventElement)this.current(t.eventElement);else this.current(l.last()[0]);this._selectedSlots=[];e=true}return e},inRange:function(t){var e=this.startDate();var n=g.date.addDays(this.endDate(),1);var r=t.start;var i=t.end;return e<=r&&r<n&&e<i&&i<=n},_resourceValue:function(t,e){if(t.valuePrimitive)e=g.getter(t.dataValueField)(e);return e},_setResourceValue:function(t,e,n){var r=t.value,i;if(e.multiple)r=[r];i=g.setter(e.field);i(n,r)},_resourceBySlot:function(u){var t=this.groupedResources;var e={};if(t.length){var h=u.groupIndex,n=this.options.group,c=n.date||n.orientation==="horizontal"?"columns":"rows",d=c==="rows"?this.rowLevels:this.columnLevels,v=n.date&&n.orientation==="horizontal"?1:0,r=d[t.length-1+v],i=t[t.length-1],o=r[h],s,l,a,f;this._setResourceValue(o,i,e);for(a=t.length-2;a>=0;a--){r=d[a+v];i=t[a];s=0;for(f=0;f<r.length;f++){o=r[f];l=o[c].length;if(l>h-s){this._setResourceValue(o,i,e);f=r.length}else s+=l}}}return e},_createResizeHint:function(t,e,n,r){return v(C).css({left:t,top:e,width:n,height:r})},_removeResizeHint:function(){this._resizeHint.remove();this._resizeHint=v()},_removeMoveHint:function(t){if(t){this._moveHint.filter("[data-uid='"+t+"']").remove();this._moveHint=this._moveHint.filter("[data-uid!='"+t+"']")}else{this._moveHint.remove();this._moveHint=v()}},_scrollTo:function(t,e){var n=t.offsetTop,r=t.offsetHeight,i=e.scrollTop,o=e.clientHeight,s=n+r,l=0;if(i>n)l=n;else if(s>i+o)if(r<=o)l=s-o;else l=n;else l=i;e.scrollTop=l},_inverseEventColor:function(t){var e=t.css("color");var n=new a(e).isDark();var r=t.css("background-color");var i=new a(r).isDark();if(n==i)t.addClass(s)},_eventTmpl:function(t,e){var n=this.options,r=v.extend({},g.Template,n.templateSettings),i=r.paramName,o="",s=typeof t,l={storage:{},count:0};if(s==="function"){l.storage["tmpl"+l.count]=t;o+="#=this.tmpl"+l.count+"("+i+")#";l.count++}else if(s==="string")o+=t;var a=g.template(g.format(e,o),r);if(l.count>0)a=a.bind(l.storage);return a},eventResources:function(u){var t=[],e=this.options;if(!e.resources)return t;for(var n=0;n<e.resources.length;n++){var r=e.resources[n];var h=r.field;var i=g.getter(h)(u);if(i==null)continue;if(!r.multiple)i=[i];var o=r.dataSource.view();for(var s=0;s<i.length;s++){var l=null;var a=i[s];if(!r.valuePrimitive)a=g.getter(r.dataValueField)(a);for(var f=0;f<o.length;f++)if(o[f].get(r.dataValueField)==a){l=o[f];break}if(l!==null){var c=g.getter(r.dataColorField)(l);t.push({field:r.field,title:r.title,name:r.name,text:g.getter(r.dataTextField)(l),value:a,color:c})}}}return t},createLayout:function(t){var e=-1;if(!t.rows)t.rows=[];for(var n=0;n<t.rows.length;n++)if(t.rows[n].allDay){e=n;break}var r=t.rows[e];if(e>=0)t.rows.splice(e,1);var i=this.columnLevels=h(t,"columns");var o=this.rowLevels=h(t,"rows");if(this._isVirtualized())this._trimRowLevels(o);this.table=v('<table role="presentation" class="k-scheduler-layout k-scheduler-'+this.name+'view"><tbody></tbody></table>');var s=o[o.length-1].length;this.table.find("tbody").first().append(this._topSection(i,r,s));this.table.find("tbody").first().append(this._bottomSection(i,o,s));this.element.append(this.table);if(this._isVirtualized())this._updateDomRowLevels();if(this._isMobile()&&i.length>1&&this._groupOrientation()==="horizontal"&&g._outerWidth(v(window))<f){this.table.find(".k-scheduler-content .k-scheduler-table").width(i[i.length-2].length*100+"%");this.table.find(".k-scheduler-header .k-scheduler-table").width(i[i.length-2].length*100+"%")}this._scroller()},_isVirtualized:function(){return this.options.virtual&&this.rowLevels.length>1&&this._isVerticallyGrouped()},_trimRowLevels:function(t){var e=t[t.length-2];var n=this.cachedRowLevels||[];var r;this._hasContentToRender=true;var i=function(t,e){var n=t[e-1].length>0,r,i;if(n){r=t[e-1][0];i=t[e][0].parentValue;return r.value!==i}else return true};for(var o=t.length-2;o>=0;o--){var s=false;if(o>0&&i(t,o)){s=true;r=o}n[o]=t[o].splice(1);if(o<t.length-2&&t[o][0].rows.length!=1)t[o][0].rows=t[o+1];if(s)break}n[t.length-1]=t[t.length-1].splice(e[0].rows.length);this.cachedRowLevels=n;if(!n[n.length-1].length)this._hasContentToRender=false;return{levelMarker:r||0,rowLevels:t}},createNextLayout:function(){var t=[];var e;var n;var r;var i;for(var o=0;o<this.cachedRowLevels.length;o++)t[o]=this.cachedRowLevels[o];e=this._trimRowLevels(t);n=e.rowLevels.splice(e.levelMarker);r=e.levelMarker;i=n[n.length-1].length;delete this._height;for(var s=r;s<this.rowLevels.length;s++)this.rowLevels[s]=this.rowLevels[s].concat(n[s-r]);this.table.find(".k-scheduler-times").last().find("tbody").append(this._times(n,i,this._isMobile()).find("tr"));this._updateDomRowLevels();if(r>0)for(s=0;s<r;s++){var l=this.table.find("[data-row-level="+s+"]").last();var a=parseInt(l.attr("rowspan"),10)+i;l.attr("rowspan",a)}this._virtualContent(n,this.columnLevels);this.render(this._cachedEvents)},_tryRenderContent:function(){var t=this;var e=t.table.innerHeight();var n=t.content.find("table").innerHeight();var r=t.content.scrollTop();while(t._hasContentToRender&&n-e<r){t.createNextLayout();n=t.content.find("table").innerHeight()}},_updateDomRowLevels:function(){var t=this;var e=t.times.find(".k-scheduler-group-cell:not([data-row-level])");if(!this._rowLevelIndices){this._rowLevelIndices=e.map(function(t,e){v(e).attr("data-row-level",t);return t}).toArray().reverse();return}e=e.toArray().reverse();for(var n=0;n<=e.length;n++)v(e[n]).attr("data-row-level",this._rowLevelIndices[n])},refreshLayout:function(){var t=this,e=t.element.find("> .k-scheduler-toolbar"),n=t.element.innerHeight(),r=this._scrollbar,i=0,o=this._isRtl?"left":"right";for(var s=0;s<e.length;s++)n-=c(e.eq(s));if(t.datesHeader)i=c(t.datesHeader);if(t.timesHeader&&c(t.timesHeader)>i)i=c(t.timesHeader);if(t.datesHeader&&t.timesHeader){var l=t.datesHeader.find("table").first().find("tr");t.timesHeader.find("tr").height(function(t){v(this).height(l.eq(t).height())})}if(i)n-=i;if(t.footer)n-=c(t.footer);var u=function(t){var e,n;if(t[0].style.height)return true;else e=t.height();t.height("auto");n=t.height();if(e!=n){t.height("");return true}t.height("");return false};var a=t.content[0],h=!g.support.kineticScrollNeeded?r:0;if(u(t.element)){if(n>r*2)t.content.height(n);else t.content.height(r*2+1);if(t.times){t.times.height(a.clientHeight);var f=t.times.find("table");if(f.length)f.height(t.content.find("table")[0].clientHeight)}}if(t.table){if(a.offsetWidth-a.clientWidth>0){t.table.addClass("k-scrollbar-v");t.datesHeader.css("padding-"+o,h-parseInt(t.datesHeader.children().css("border-"+o+"-width"),10))}else t.datesHeader.css("padding-"+o,"0");if(a.offsetHeight-a.clientHeight>0||a.clientHeight>t.content.children(".k-scheduler-table").height())t.table.addClass("k-scrollbar-h");else t.table.removeClass("k-scrollbar-h")}},_topSection:function(t,e,n){var r=v("<tr>");this.timesHeader=S(t.length,e,n);this.datesHeader=this._datesHeader(t,e);var i=this.datesHeader.find(".k-nav-day");if(i.length)i.closest("tr").addClass("k-scheduler-date-group");if(this._isMobile()){r.addClass("k-mobile-header");r.addClass("k-mobile-"+this._groupOrientation()+"-header")}return v(r).append(this.timesHeader.add(this.datesHeader).wrap("<td>").parent())},_bottomSection:function(t,e,n){this.times=this._times(e,n,this._isMobile());this.content=y(t[t.length-1],e[e.length-1]);return v("<tr>").append(this.times.add(this.content).wrap("<td>").parent())},_scroller:function(){var e=this;this.content.on("scroll"+o,function(){g.scrollLeft(e.datesHeader.find(">.k-scheduler-header-wrap"),this.scrollLeft);e.times.scrollTop(this.scrollTop);if(e._isVirtualized())e._tryRenderContent()});var t=g.touchScroller(this.content,{avoidScrolling:function(t){return v(t.event.target).closest(".k-event.k-event-active").length>0}});if(t&&t.movable){this._touchScroller=t;this.content=t.scrollElement;t.movable.bind("change",function(t){g.scrollLeft(e.datesHeader.find(">.k-scheduler-header-wrap"),-t.sender.x);e.times.scrollTop(-t.sender.y);if(e._isVirtualized())e._tryRenderContent()})}},_resourcesForGroups:function(){var t=[];var e=this.options.group;var n=this.options.resources;e=e&&e.resources?e.resources:[];if(n&&e.length)for(var r=0,i=n.length;r<i;r++)for(var o=0,s=e.length;o<s;o++)if(n[r].name===e[o])t.push(n[r]);this.groupedResources=t},_createDateLayout:function(t,e,n){return B("rows",t,e,n)},_createColumnsLayout:function(t,e,n,r,i,o){return _("columns",t,e,n,r,i,o)},_groupOrientation:function(){var t=this.options.group;return t&&t.resources?t.orientation:"horizontal"},_isGroupedByDate:function(){return this.options.group&&this.options.group.date},_isVerticallyGrouped:function(){return this.groupedResources.length&&this._groupOrientation()==="vertical"},_createRowsLayout:function(t,e,n,r){return _("rows",t,e,n,r)},selectionByElement:function(){return null},clearSelection:function(){this.content.find(".k-selected").removeAttr("id").removeClass("k-selected")},destroy:function(){var t=this;i.fn.destroy.call(this);if(t.table){g.destroy(t.table);t.table.remove()}if(t.footer){g.destroy(t.footer);t.footer.remove()}t.groups=null;t.table=null;t.content=null;t.times=null;t.datesHeader=null;t.timesHeader=null;t.footer=null;t._resizeHint=null;t._moveHint=null},calendarInfo:function(){return g.getCulture().calendars.standard},prevGroupSlot:function(t,e,n){var r;var i=this.groups[e];var o=i.ranges(t,t,n,false)[0].start;if(e<=0)return;if(this._isGroupedByDate())return o;if(this._isVerticallyGrouped())if(!i.timeSlotCollectionCount()){r=i._collection(i.daySlotCollectionCount()-1,true);return r.at(o.index)}else{r=i._collection(n?o.index:o.collectionIndex,false);return r.last()}else if(!i.timeSlotCollectionCount()){r=i._collection(o.collectionIndex,true);return r.last()}else{r=i._collection(n?0:i.timeSlotCollectionCount()-1,n);return n?r.last():r.at(o.index)}},nextGroupSlot:function(t,e,n){var r;var i=this.groups[e];var o=i.ranges(t,t,n,false)[0].start;var s;if(e>=this.groups.length-1)return;if(this._isGroupedByDate())return o;if(this._isVerticallyGrouped())if(!i.timeSlotCollectionCount()){r=i._collection(0,true);return r.at(o.index)}else{s=i.daySlotCollectionCount();r=i._collection(s?0:o.collectionIndex,s);return n?r.first():r.at(o.collectionIndex)}else if(!i.timeSlotCollectionCount()){r=i._collection(o.collectionIndex,true);return r.first()}else{r=i._collection(0,n);return n?r.first():r.at(o.index)}},_eventOptionsForMove:function(){return{}},_updateEventForResize:function(){return},_updateEventForSelection:function(t){return t},_innerElements:function(t,s,l){var a=0,f=function(t){var e=t[l],n=t[s],r,i,o;if(e){a+=e;return}if(!n||n.length===0){a+=1;return}for(o=0;o<n.length;o++){r=n[o];i=r[s];if(i&&i[0])if(!i[0][s]||i[0][s].length===0)a+=i.length;else f(r);else a+=1}};f(t);return a},_times:function(t,e,u){var h=this;var n=new Array(e).join().split(",");var r=[];var i;for(var o=0;o<t.length;o++){var c=t[o];var d=0;for(i=0;i<c.length;i++){var s=c[i];var l=s.className||"";var a=s.text;var f=h._innerElements(s,"rows");d+=f;if(s.allDay)l="k-scheduler-times-all-day";if(u&&l.indexOf("k-scheduler-group-cell")!==-1)a='<span class="k-scheduler-group-text">'+a+"</span>";n[d-f]+='<th class="'+l+'" rowspan="'+f+'">'+a+"</th>"}}for(i=0;i<e;i++)r.push(n[i]);if(e<1)return v();return v('<div class="k-scheduler-times">'+p(r)+"</div>")},_datesHeader:function(t,e){var u=this;var n=[];var r;for(var i=0;i<t.length;i++){var o=t[i];var s=[];for(r=0;r<o.length;r++){var l=o[r];var h=u._innerElements(l,"columns","colspan");s.push('<th colspan="'+(l.colspan||h)+'" class="'+(l.className||"")+'">'+l.text+"</th>")}n.push(s.join(""))}var a=[];if(e){var f=t[t.length-1];var c=[];var d=e.cellContent;for(r=0;r<f.length;r++)c.push('<td class="'+(f[r].className||"")+'">'+(d?d(r):"&nbsp;")+"</td>");a.push(c.join(""))}return v('<div class="k-scheduler-header">'+'<div class="k-scheduler-header-wrap">'+p(n)+m(a,"k-scheduler-header-all-day")+"</div>"+"</div>")},_formatEventAriaLabel:function(t,e,n,r){var i=this.options.messages.ariaEventLabel,o=g.date.getDate(e).getTime()===g.date.getDate(n).getTime(),s;if(typeof i==="string")return g.format(i,t,e,e);s=(i.prefix+l+t+l+i.on+l+g.toString(e,"D")).trim();if(r&&o)return s+l+i.allDay;else if(r)return s+l+i.to+l+g.toString(n,"D")+l+i.allDay;else{s=s+l+i.at+l+g.toString(e,"t")+l+i.to+l;if(o)return s+g.toString(n,"t");else return s+g.toString(n,"D")+l+i.at+l+g.toString(n,"t")}}});var a=function(t){var e=this,n=a.formats,r,i,o,s,l;if(arguments.length===1){t=e.resolveColor(t);for(s=0;s<n.length;s++){r=n[s].re;i=n[s].process;o=r.exec(t);if(o){l=i(o);e.r=l[0];e.g=l[1];e.b=l[2]}}}else{e.r=arguments[0];e.g=arguments[1];e.b=arguments[2]}e.r=e.normalizeByte(e.r);e.g=e.normalizeByte(e.g);e.b=e.normalizeByte(e.b)};function G(t){var e=[];for(var n=0;n<t.length;n++){var r=t[n];var i=E(r);var o=null;for(var s=0,l=e.length;s<l;s++){var a=i.start>e[s].end;if(i.start<e[s].start||a){o=e[s];if(o.end<i.end)o.end=i.end;break}}if(!o){o={start:i.start,end:i.end,events:[]};e.push(o)}o.events.push(r)}return e}function B(i,t,o,s){var l=[];v.each(t,function(t,e){var n=e.className?"k-slot-cell "+e.className:"k-slot-cell";var r={text:e.text,className:n};if(s&&!e.minorTicks)r[i]=B(i,e.columns,o,s);else r[i]=o;l.push(r)});return l}function _(n,r,t,i,e,o,s){var l=r[0];var u=[];if(l){if(e&&t){v.each(e,function(t,e){if(o&&!e.minorTicks)e[n]=_(n,r,e.columns,i,e.columns,o,s);else e[n]=_(n,r,null,i,null,null,s)});u=e}else{var a=l.dataSource.view();a=a.filter(function(t){var e=g.getter(l.dataParentValueField)(t);return e===null||e===undefined||e===s});for(var f=0;f<a.length;f++){var h=g.getter(l.dataValueField)(a[f]);var c={text:i({text:g.htmlEncode(g.getter(l.dataTextField)(a[f])),color:g.getter(l.dataColorField)(a[f]),field:l.field,title:l.title,name:l.name,value:h}),className:"k-slot-cell k-scheduler-group-cell",parentValue:s,value:h};c[n]=_(n,r.slice(1),t,i,e,o,h);u.push(c)}}return u}return t}function M(n){return function(t){if(Array.isArray(t)||t instanceof g.data.ObservableArray){for(var e=0;e<t.length;e++)if(t[e]==n)return true;return false}return t==n}}a.prototype={resolveColor:function(t){t=t||"#000";if(t.charAt(0)=="#")t=t.substr(1,6);t=t.replace(/ /g,"");t=t.toLowerCase();t=a.namedColors[t]||t;return t},normalizeByte:function(t){return t<0||isNaN(t)?0:t>255?255:t},percBrightness:function(){var t=this;return u.sqrt(.241*t.r*t.r+.691*t.g*t.g+.068*t.b*t.b)},isDark:function(){var t=this;var e=t.percBrightness();return e<180}},a.formats=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(t){return[parseInt(t[1],10),parseInt(t[2],10),parseInt(t[3],10)]}},{re:/^(\w{2})(\w{2})(\w{2})$/,process:function(t){return[parseInt(t[1],16),parseInt(t[2],16),parseInt(t[3],16)]}},{re:/^(\w{1})(\w{1})(\w{1})$/,process:function(t){return[parseInt(t[1]+t[1],16),parseInt(t[2]+t[2],16),parseInt(t[3]+t[3],16)]}}],a.namedColors={aqua:"00ffff",azure:"f0ffff",beige:"f5f5dc",black:"000000",blue:"0000ff",brown:"a52a2a",coral:"ff7f50",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgray:"a9a9a9",darkgreen:"006400",darkorange:"ff8c00",darkred:"8b0000",dimgray:"696969",fuchsia:"ff00ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lightblue:"add8e6",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumblue:"0000cd",navy:"000080",olive:"808000",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",pink:"ffc0cb",plum:"dda0dd",purple:"800080",red:"ff0000",royalblue:"4169e1",salmon:"fa8072",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",steelblue:"4682b4",tan:"d2b48c",teal:"008080",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"};var W=/\s*k-selected/;function F(t){t.className=t.className.replace(W,"")+" k-selected"}return v.extend(r.SchedulerView,{createColumns:V,createRows:A,rangeIndex:E,collidingEvents:L,groupEqFilter:M}),window.kendo})}("function"==typeof define&&define.amd?define:function(t,e,n){(n||e)()});
//# sourceMappingURL=kendo.scheduler.view.min.js.map
