/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("dataviz/diagram/utils.min",["kendo.core.min"],function(){var i=window.kendo.jQuery,l=void 0,e=window.kendo,s=e.dataviz.diagram={},d,n=Array.isArray,r=1e-6,h={};function t(t,e,i){if(typeof t=="undefined"||typeof e=="undefined")return[];if(i&&h.sign(e-t)!=h.sign(i))throw"The sign of the increment should allow to reach the stop-value.";i=i||1;t=t||0;e=e||t;if((e-t)/i===Infinity)throw"Infinite range defined.";var n=[],s=-1,r;function o(t){var e=1;while(t*e%1)e*=10;return e}var a=o(Math.abs(i));t*=a;e*=a;i*=a;if(t>e&&i>0)i=-i;if(i<0)while((r=t+i*++s)>=e)n.push(r/a);else while((r=t+i*++s)<=e)n.push(r/a);return n}function o(t,e){if(t==e)return 0;var i=e.x-t.x,n=t.y-e.y,s=Math.atan(i/n);if(n>=0)return i<0?s+2*Math.PI:s;return s+Math.PI}(0,e.deepExtend)(h,{isNearZero:function(t){return Math.abs(t)<r},isDefined:function(t){return typeof t!=="undefined"},isUndefined:function(t){return typeof t==="undefined"||t===null},isObject:function(t){return t===Object(t)},has:function(t,e){return Object.hasOwnProperty.call(t,e)},isString:function(t){return Object.prototype.toString.call(t)=="[object String]"},isBoolean:function(t){return Object.prototype.toString.call(t)=="[object Boolean]"},isType:function(t,e){return Object.prototype.toString.call(t)=="[object "+e+"]"},isNumber:function(t){return!isNaN(parseFloat(t))&&isFinite(t)},isEmpty:function(t){if(t===null)return true;if(n(t)||h.isString(t))return t.length===0;for(var e in t)if(h.has(t,e))return false;return true},simpleExtend:function(t,e){if(!h.isObject(e))return;for(var i in e)t[i]=e[i]},initArray:function t(e,i){var n=[];for(var s=0;s<e;++s)n[s]=i;return n},serializePoints:function(t){var e=[];for(var i=0;i<t.length;i++){var n=t[i];e.push(n.x+";"+n.y)}return e.join(";")},deserializePoints:function(t){var e=t.split(";"),i=[];if(e.length%2!==0)throw"Not an array of points.";for(var n=0;n<e.length;n+=2)i.push(new s.Point(parseInt(e[n],10),parseInt(e[n+1],10)));return i},randomInteger:function(t,e){return parseInt(Math.floor(Math.random()*e)+t,10)},DFT:function(t,e){e(t);if(t.childNodes)for(var i=0;i<t.childNodes.length;i++){var n=t.childNodes[i];this.DFT(n,e)}},getMatrixAngle:function(t){if(t===null||t.d===0)return 0;return Math.atan2(t.b,t.d)*180/Math.PI},getMatrixScaling:function(t){var e=Math.sqrt(t.a*t.a+t.c*t.c);var i=Math.sqrt(t.b*t.b+t.d*t.d);return[e,i]}}),h.sign=function(t){return t?t<0?-1:1:0},h.findAngle=function(t,e){return o(t,e)*180/Math.PI},h.forEach=function(t,e,i){for(var n=0;n<t.length;n++)e.call(i,t[n],n,t)},h.any=function(t,e){for(var i=0;i<t.length;++i)if(e(t[i]))return t[i];return null},h.remove=function(t,e){var i;while((i=h.indexOf(t,e))!==-1)t.splice(i,1);return t},h.contains=function(t,e){return h.indexOf(t,e)!==-1},h.indexOf=function(t,e){return i.inArray(e,t)},h.fold=function(t,e,i,n){var s=arguments.length>2;for(var r=0;r<t.length;r++){var o=t[r];if(!s){i=o;s=true}else i=e.call(n,i,o,r,t)}if(!s)throw"Reduce of empty array with no initial value";return i},h.find=function(t,n,s){var r;h.any(t,function(t,e,i){if(n.call(s,t,e,i)){r=t;return true}return false});return r},h.first=function(t,e,i){if(t.length===0)return null;if(h.isUndefined(e))return t[0];return h.find(t,e,i)},h.insert=function(t,e,i){t.splice(i,0,e);return t},h.all=function(t,e,i){var n=true;var s;for(var r=0;r<t.length;r++){s=t[r];n=n&&e.call(i,s,r,t);if(!n)break}return n},h.clear=function(t){t.splice(0,t.length)},h.bisort=function(t,e,i){if(h.isUndefined(t))throw"First array is not specified.";if(h.isUndefined(e))throw"Second array is not specified.";if(t.length!=e.length)throw"The two arrays should have equal length";var n=[],s;for(s=0;s<t.length;s++)n.push({x:t[s],y:e[s]});if(h.isUndefined(i))n.sort(function(t,e){return t.x-e.x});else n.sort(function(t,e){return i(t.x,e.x)});h.clear(t);h.clear(e);for(s=0;s<n.length;s++){t.push(n[s].x);e.push(n[s].y)}},h.addRange=function(t,e){t.push.apply(t,e)};var a={easeInOut:function(t){return-Math.cos(t*Math.PI)/2+.5}},c=e.Class.extend({init:function(){this.adapters=[];this.target=0;this.tick=0;this.interval=20;this.duration=800;this.lastTime=null;this.handlers=[];var t=this;this.transition=a.easeInOut;this.timerDelegate=function(){t.onTimerEvent()}},addAdapter:function(t){this.adapters.push(t)},onComplete:function(t){this.handlers.push(t)},removeHandler:function(e){this.handlers=i.grep(this.handlers,function(t){return t!==e})},trigger:function(){var e=this;if(this.handlers)h.forEach(this.handlers,function(t){return t.call(e.caller!==null?e.caller:e)})},onStep:function(){},seekTo:function(t){this.seekFromTo(this.tick,t)},seekFromTo:function(t,e){this.target=Math.max(0,Math.min(1,e));this.tick=Math.max(0,Math.min(1,t));this.lastTime=(new Date).getTime();if(!this.intervalId)this.intervalId=window.setInterval(this.timerDelegate,this.interval)},stop:function(){if(this.intervalId){window.clearInterval(this.intervalId);this.intervalId=null;this.trigger()}},play:function(t){if(this.adapters.length===0)return;if(t!==null)this.caller=t;this.initState();this.seekFromTo(0,1)},reverse:function(){this.seekFromTo(1,0)},initState:function(){if(this.adapters.length===0)return;for(var t=0;t<this.adapters.length;t++)this.adapters[t].initState()},propagate:function(){var t=this.transition(this.tick);for(var e=0;e<this.adapters.length;e++)this.adapters[e].update(t)},onTimerEvent:function(){var t=(new Date).getTime();var e=t-this.lastTime;this.lastTime=t;var i=e/this.duration*(this.tick<this.target?1:-1);if(Math.abs(i)>=Math.abs(this.tick-this.target))this.tick=this.target;else this.tick+=i;try{this.propagate()}finally{this.onStep.call(this);if(this.target==this.tick)this.stop()}}});e.deepExtend(s,{init:function(t){e.init(t,s.ui)},Utils:h,Range:t,Ticker:c})})}("function"==typeof define&&define.amd?define:function(t,e,i){(i||e)()}),function(define){define("dataviz/diagram/math.min",["./utils.min","kendo.dataviz.core.min"],function(){var n=window.kendo.jQuery,i=void 0,w=window.kendo,p=w.dataviz.diagram,t=w.Class,e=w.deepExtend,r,E=p.Utils,x=w.dataviz.Point2D,o=w.isFunction,g=E.contains,a=n.map,h=3,c=1e-6,l=(e(x.fn,{plus:function(t){return new x(this.x+t.x,this.y+t.y)},minus:function(t){return new x(this.x-t.x,this.y-t.y)},offset:function(t){return new x(this.x-t,this.y-t)},times:function(t){return new x(this.x*t,this.y*t)},normalize:function(){if(this.length()===0)return new x;return this.times(1/this.length())},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},toString:function(){return"("+this.x+","+this.y+")"},lengthSquared:function(){return this.x*this.x+this.y*this.y},middleOf:function t(e,i){return new x(i.x-e.x,i.y-e.y).times(.5).plus(e)},toPolar:function(t){var e=1;if(t)e=180/Math.PI;var i=Math.atan2(Math.abs(this.y),Math.abs(this.x));var n=Math.PI/2;var s=this.length();if(this.x===0){if(this.y===0)return new C(0,0);if(this.y>0)return new C(s,e*n);if(this.y<0)return new C(s,e*3*n)}else if(this.x>0){if(this.y===0)return new C(s,0);if(this.y>0)return new C(s,e*i);if(this.y<0)return new C(s,e*(4*n-i))}else{if(this.y===0)return new C(s,2*n);if(this.y>0)return new C(s,e*(2*n-i));if(this.y<0)return new C(s,e*(2*n+i))}},isOnLine:function(t,e){if(t.x>e.x){var i=e;e=t;t=i}var n=new b(t.x,t.y).inflate(h,h),s=new b(e.x,e.y).inflate(h,h),r,o;if(n.union(s).contains(this)){if(t.x===e.x||t.y===e.y)return true;else if(t.y<e.y){r=n.x+(s.x-n.x)*(this.y-(n.y+n.height))/(s.y+s.height-(n.y+n.height));o=n.x+n.width+(s.x+s.width-(n.x+n.width))*(this.y-n.y)/(s.y-n.y)}else{r=n.x+(s.x-n.x)*(this.y-n.y)/(s.y-n.y);o=n.x+n.width+(s.x+s.width-(n.x+n.width))*(this.y-(n.y+n.height))/(s.y+s.height-(n.y+n.height))}return this.x>r&&this.x<o}return false}}),e(x,{parse:function(t){var e=t.slice(1,t.length-1),i=e.split(","),n=parseInt(i[0],10),s=parseInt(i[1],10);if(!isNaN(n)&&!isNaN(s))return new x(n,s)}}),t.extend({init:function(t,e,i){this.point=t;this.left=e;this.right=i}})),b=t.extend({init:function(t,e,i,n){this.x=t||0;this.y=e||0;this.width=i||0;this.height=n||0},contains:function(t){return t.x>=this.x&&t.x<=this.x+this.width&&t.y>=this.y&&t.y<=this.y+this.height},inflate:function(t,e){if(e===i)e=t;this.x-=t;this.y-=e;this.width+=2*t+1;this.height+=2*e+1;return this},offset:function(t,e){var i=t,n=e;if(t instanceof x){i=t.x;n=t.y}this.x+=i;this.y+=n;return this},union:function(t){var e=Math.min(this.x,t.x);var i=Math.min(this.y,t.y);var n=Math.max(this.x+this.width,t.x+t.width);var s=Math.max(this.y+this.height,t.y+t.height);return new b(e,i,n-e,s-i)},center:function(){return new x(this.x+this.width/2,this.y+this.height/2)},top:function(){return new x(this.x+this.width/2,this.y)},right:function(){return new x(this.x+this.width,this.y+this.height/2)},bottom:function(){return new x(this.x+this.width/2,this.y+this.height)},left:function(){return new x(this.x,this.y+this.height/2)},topLeft:function(){return new x(this.x,this.y)},topRight:function(){return new x(this.x+this.width,this.y)},bottomLeft:function(){return new x(this.x,this.y+this.height)},bottomRight:function(){return new x(this.x+this.width,this.y+this.height)},clone:function(){return new b(this.x,this.y,this.width,this.height)},isEmpty:function(){return!this.width&&!this.height},equals:function(t){return this.x===t.x&&this.y===t.y&&this.width===t.width&&this.height===t.height},rotatedBounds:function(t){var e=this.clone(),i=this.rotatedPoints(t),n=i[0],s=i[1],r=i[2],o=i[3];e.x=Math.min(r.x,n.x,s.x,o.x);e.y=Math.min(r.y,n.y,s.y,o.y);e.width=Math.max(r.x,n.x,s.x,o.x)-e.x;e.height=Math.max(r.y,n.y,s.y,o.y)-e.y;return e},rotatedPoints:function(t){var e=this,i=e.center(),n=e.bottomRight().rotate(i,360-t),s=e.topLeft().rotate(i,360-t),r=e.topRight().rotate(i,360-t),o=e.bottomLeft().rotate(i,360-t);return[s,r,n,o]},toString:function(t){t=t||" ";return this.x+t+this.y+t+this.width+t+this.height},scale:function(t,e,i,n,s){var r=this.topLeft();var o=this.center();r.rotate(o,360-s).rotate(n,s);var a=i.minus(r);var h=new x(a.x*t,a.y*e);var c=a.minus(h);r=r.plus(c);r.rotate(n,360-s).rotate(o,s);this.x=r.x;this.y=r.y;this.width*=t;this.height*=e},zoom:function(t){this.x*=t;this.y*=t;this.width*=t;this.height*=t;return this},overlaps:function(t){var e=this.bottomRight();var i=t.bottomRight();var n=!(e.x<t.x||e.y<t.y||i.x<this.x||i.y<this.y);return n}}),d=t.extend({init:function(t,e){this.width=t;this.height=e}});function u(t){return Math.abs(t)<c}function f(t,e,i,n,s){var r=(e.x-t.x)*(n.y-i.y)-(e.y-t.y)*(n.x-i.x);if(u(r))return;var o=(t.y-i.y)*(n.x-i.x)-(t.x-i.x)*(n.y-i.y);var a=(t.y-i.y)*(e.x-t.x)-(t.x-i.x)*(e.y-t.y);var h=o/r;var c=a/r;if(s&&(h<0||h>1||c<0||c>1))return;return new x(t.x+h*(e.x-t.x),t.y+h*(e.y-t.y))}d.prototype.Empty=new d(0,0),b.toRect=function(t){if(!(t instanceof b))t=new b(t.x,t.y,t.width,t.height);return t},b.empty=function(){return new b(0,0,0,0)},b.fromPoints=function(t,e){if(isNaN(t.x)||isNaN(t.y)||isNaN(e.x)||isNaN(e.y))throw"Some values are NaN.";return new b(Math.min(t.x,e.x),Math.min(t.y,e.y),Math.abs(t.x-e.x),Math.abs(t.y-e.y))};var _={lines:function(t,e,i,n){return f(t,e,i,n)},segments:function(t,e,i,n){return f(t,e,i,n,true)},rectWithLine:function(t,e,i){return _.segments(e,i,t.topLeft(),t.topRight())||_.segments(e,i,t.topRight(),t.bottomRight())||_.segments(e,i,t.bottomLeft(),t.bottomRight())||_.segments(e,i,t.topLeft(),t.bottomLeft())},rects:function(t,e,i){var n=e.topLeft(),s=e.topRight(),r=e.bottomLeft(),o=e.bottomRight();var a=e.center();if(i){n=n.rotate(a,i);s=s.rotate(a,i);r=r.rotate(a,i);o=o.rotate(a,i)}var h=t.contains(n)||t.contains(s)||t.contains(r)||t.contains(o)||_.rectWithLine(t,n,s)||_.rectWithLine(t,n,r)||_.rectWithLine(t,s,o)||_.rectWithLine(t,r,o);if(!h){n=t.topLeft();s=t.topRight();r=t.bottomLeft();o=t.bottomRight();if(i){var c=360-i;n=n.rotate(a,c);s=s.rotate(a,c);r=r.rotate(a,c);o=o.rotate(a,c)}h=e.contains(n)||e.contains(s)||e.contains(r)||e.contains(o)}return h}},y=t.extend({init:function(t){this.container=b.toRect(t)},align:function(t,e){var i=e.toLowerCase().split(" ");for(var n=0;n<i.length;n++)t=this._singleAlign(t,i[n]);return t},_singleAlign:function(t,e){if(o(this[e]))return this[e](t);else return t},left:function(t){return this._align(t,this._left)},center:function(t){return this._align(t,this._center)},right:function(t){return this._align(t,this._right)},stretch:function(t){return this._align(t,this._stretch)},top:function(t){return this._align(t,this._top)},middle:function(t){return this._align(t,this._middle)},bottom:function(t){return this._align(t,this._bottom)},_left:function(t,e){e.x=t.x},_center:function(t,e){e.x=(t.width-e.width)/2||0},_right:function(t,e){e.x=t.width-e.width},_top:function(t,e){e.y=t.y},_middle:function(t,e){e.y=(t.height-e.height)/2||0},_bottom:function(t,e){e.y=t.height-e.height},_stretch:function(t,e){e.x=0;e.y=0;e.height=t.height;e.width=t.width},_align:function(t,e){t=b.toRect(t);e(this.container,t);return t}}),C=t.extend({init:function(t,e){this.r=t;this.angle=e}}),s=t.extend({init:function(t,e,i,n,s,r){this.a=t||0;this.b=e||0;this.c=i||0;this.d=n||0;this.e=s||0;this.f=r||0},plus:function(t){this.a+=t.a;this.b+=t.b;this.c+=t.c;this.d+=t.d;this.e+=t.e;this.f+=t.f},minus:function(t){this.a-=t.a;this.b-=t.b;this.c-=t.c;this.d-=t.d;this.e-=t.e;this.f-=t.f},times:function(t){return new s(this.a*t.a+this.c*t.b,this.b*t.a+this.d*t.b,this.a*t.c+this.c*t.d,this.b*t.c+this.d*t.d,this.a*t.e+this.c*t.f+this.e,this.b*t.e+this.d*t.f+this.f)},apply:function(t){return new x(this.a*t.x+this.c*t.y+this.e,this.b*t.x+this.d*t.y+this.f)},applyRect:function(t){return b.fromPoints(this.apply(t.topLeft()),this.apply(t.bottomRight()))},toString:function(){return"matrix("+this.a+" "+this.b+" "+this.c+" "+this.d+" "+this.e+" "+this.f+")"}}),S=(e(s,{fromSVGMatrix:function(t){var e=new s;e.a=t.a;e.b=t.b;e.c=t.c;e.d=t.d;e.e=t.e;e.f=t.f;return e},fromMatrixVector:function(t){var e=new s;e.a=t.a;e.b=t.b;e.c=t.c;e.d=t.d;e.e=t.e;e.f=t.f;return e},fromList:function(t){if(t.length!==6)throw"The given list should consist of six elements.";var e=new s;e.a=t[0];e.b=t[1];e.c=t[2];e.d=t[3];e.e=t[4];e.f=t[5];return e},translation:function(t,e){var i=new s;i.a=1;i.b=0;i.c=0;i.d=1;i.e=t;i.f=e;return i},unit:function(){return new s(1,0,0,1,0,0)},rotation:function(t,e,i){var n=new s;n.a=Math.cos(t*Math.PI/180);n.b=Math.sin(t*Math.PI/180);n.c=-n.b;n.d=n.a;n.e=e-e*n.a+i*n.b||0;n.f=i-i*n.a-e*n.b||0;return n},scaling:function(t,e){var i=new s;i.a=t;i.b=0;i.c=0;i.d=e;i.e=0;i.f=0;return i},parse:function(t){var e,i;if(t){t=t.trim();if(t.slice(0,6).toLowerCase()==="matrix"){i=t.slice(7,t.length-1).trim();e=i.split(",");if(e.length===6)return s.fromList(a(e,function(t){return parseFloat(t)}));e=i.split(" ");if(e.length===6)return s.fromList(a(e,function(t){return parseFloat(t)}))}if(t.slice(0,1)==="("&&t.slice(t.length-1)===")")t=t.substr(1,t.length-1);if(t.indexOf(",")>0){e=t.split(",");if(e.length===6)return s.fromList(a(e,function(t){return parseFloat(t)}))}if(t.indexOf(" ")>0){e=t.split(" ");if(e.length===6)return s.fromList(a(e,function(t){return parseFloat(t)}))}}return e}}),t.extend({init:function(t,e,i,n,s,r){this.a=t||0;this.b=e||0;this.c=i||0;this.d=n||0;this.e=s||0;this.f=r||0},fromMatrix:function t(e){var i=new S;i.a=e.a;i.b=e.b;i.c=e.c;i.d=e.d;i.e=e.e;i.f=e.f;return i}}));function k(t,e){var i,n,s;do{i=Math.random()*2-1;n=Math.random()*2-1;s=i*i+n*n}while(!s||s>1);return t+e*i*Math.sqrt(-2*Math.log(s)/s)}function T(t){if(E.isUndefined(t))t=10;var e="";var i="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";for(var n=t;n>0;--n)e+=i.charAt(Math.round(Math.random()*(i.length-1)));return e}var M={_distanceToLineSquared:function(t,e,i){function n(t,e){return(t.x-e.x)*(t.x-e.x)+(t.y-e.y)*(t.y-e.y)}if(e===i)return n(t,e);var s=i.x-e.x,r=i.y-e.y,o=(t.x-e.x)*s+(t.y-e.y)*r;if(o<0)return n(e,t);o=(i.x-t.x)*s+(i.y-t.y)*r;if(o<0)return n(i,t);o=(i.x-t.x)*r-(i.y-t.y)*s;return o*o/(s*s+r*r)},distanceToLine:function(t,e,i){return Math.sqrt(this._distanceToLineSquared(t,e,i))},distanceToPolyline:function(t,e){var i=Number.MAX_VALUE;if(E.isUndefined(e)||e.length===0)return Number.MAX_VALUE;for(var n=0;n<e.length-1;n++){var s=e[n];var r=e[n+1];var o=this._distanceToLineSquared(t,s,r);if(o<i)i=o}return Math.sqrt(i)}},D=w.Class.extend({init:function(){this._buckets=[];this.length=0},add:function(t,e){var i=this._createGetBucket(t);if(E.isDefined(e))i.value=e;return i},get:function(t){if(this._bucketExists(t))return this._createGetBucket(t);return null},set:function(t,e){this.add(t,e)},containsKey:function(t){return this._bucketExists(t)},remove:function(t){if(this._bucketExists(t)){var e=this._hash(t);delete this._buckets[e];this.length--;return t}},forEach:function(t){var e=this._hashes();for(var i=0,n=e.length;i<n;i++){var s=e[i];var r=this._buckets[s];if(E.isUndefined(r))continue;t(r)}},clone:function(){var t=new D;var e=this._hashes();for(var i=0,n=e.length;i<n;i++){var s=e[i];var r=this._buckets[s];if(E.isUndefined(r))continue;t.add(r.key,r.value)}return t},_hashes:function(){var t=[];for(var e in this._buckets)if(this._buckets.hasOwnProperty(e))t.push(e);return t},_bucketExists:function(t){var e=this._hash(t);return E.isDefined(this._buckets[e])},_createGetBucket:function(t){var e=this._hash(t);var i=this._buckets[e];if(E.isUndefined(i)){i={key:t};this._buckets[e]=i;this.length++}return i},_hash:function(t){if(E.isNumber(t))return t;if(E.isString(t))return this._hashString(t);if(E.isObject(t))return this._objectHashId(t);throw"Unsupported key type."},_hashString:function(t){var e=0;if(t.length===0)return e;for(var i=0;i<t.length;i++){var n=t.charCodeAt(i);e=e*32-e+n}return e},_objectHashId:function(t){var e=t._hashId;if(E.isUndefined(e)){e=T();t._hashId=e}return e}}),z=w.Observable.extend({init:function(t){var e=this;w.Observable.fn.init.call(e);this._hashTable=new D;this.length=0;if(E.isDefined(t))if(Array.isArray(t))for(var i=0;i<t.length;i++)this.add(t[i]);else t.forEach(function(t,e){this.add(t,e)},this)},add:function(t,e){var i=this._hashTable.get(t);if(!i){i=this._hashTable.add(t);this.length++;this.trigger("changed")}i.value=e},set:function(t,e){this.add(t,e)},get:function(t){var e=this._hashTable.get(t);if(e)return e.value;throw new Error("Cannot find key "+t)},containsKey:function(t){return this._hashTable.containsKey(t)},remove:function(t){if(this.containsKey(t)){this.trigger("changed");this.length--;return this._hashTable.remove(t)}},forEach:function(e,i){this._hashTable.forEach(function(t){e.call(i,t.key,t.value)})},forEachValue:function(e,i){this._hashTable.forEach(function(t){e.call(i,t.value)})},forEachKey:function(e,i){this._hashTable.forEach(function(t){e.call(i,t.key)})},keys:function(){var e=[];this.forEachKey(function(t){e.push(t)});return e}}),I=w.Class.extend({init:function(){this._tail=null;this._head=null;this.length=0},enqueue:function(t){var e={value:t,next:null};if(!this._head){this._head=e;this._tail=this._head}else{this._tail.next=e;this._tail=this._tail.next}this.length++},dequeue:function(){if(this.length<1)throw new Error("The queue is empty.");var t=this._head.value;this._head=this._head.next;this.length--;return t},contains:function(t){var e=this._head;while(e){if(e.value===t)return true;e=e.next}return false}}),P=w.Observable.extend({init:function(t){var e=this;w.Observable.fn.init.call(e);this._hashTable=new D;this.length=0;if(E.isDefined(t))if(t instanceof D)t.forEach(function(t){this.add(t)});else if(t instanceof z)t.forEach(function(t,e){this.add({key:t,value:e})},this)},contains:function(t){return this._hashTable.containsKey(t)},add:function(t){var e=this._hashTable.get(t);if(!e){this._hashTable.add(t,t);this.length++;this.trigger("changed")}},get:function(t){if(this.contains(t))return this._hashTable.get(t).value;else return null},hash:function(t){return this._hashTable._hash(t)},remove:function(t){if(this.contains(t)){this._hashTable.remove(t);this.length--;this.trigger("changed")}},forEach:function(e,t){this._hashTable.forEach(function(t){e(t.value)},t)},toArray:function(){var e=[];this.forEach(function(t){e.push(t)});return e}}),v=w.Class.extend({init:function(t,e){this.links=[];this.outgoing=[];this.incoming=[];this.weight=1;if(E.isDefined(t))this.id=t;else this.id=T();if(E.isDefined(e)){this.associatedShape=e;var i=e.bounds();this.width=i.width;this.height=i.height;this.x=i.x;this.y=i.y}else this.associatedShape=null;this.data=null;this.type="Node";this.shortForm="Node '"+this.id+"'";this.isVirtual=false},isIsolated:function(){return E.isEmpty(this.links)},bounds:function(t){if(!E.isDefined(t))return new p.Rect(this.x,this.y,this.width,this.height);this.x=t.x;this.y=t.y;this.width=t.width;this.height=t.height},isLinkedTo:function(e){var i=this;return E.any(i.links,function(t){return t.getComplement(i)===e})},getChildren:function(){if(this.outgoing.length===0)return[];var t=[];for(var e=0,i=this.outgoing.length;e<i;e++){var n=this.outgoing[e];t.push(n.getComplement(this))}return t},getParents:function(){if(this.incoming.length===0)return[];var t=[];for(var e=0,i=this.incoming.length;e<i;e++){var n=this.incoming[e];t.push(n.getComplement(this))}return t},clone:function(){var t=new v;if(E.isDefined(this.weight))t.weight=this.weight;if(E.isDefined(this.balance))t.balance=this.balance;if(E.isDefined(this.owner))t.owner=this.owner;t.associatedShape=this.associatedShape;t.x=this.x;t.y=this.y;t.width=this.width;t.height=this.height;return t},adjacentTo:function(t){return this.isLinkedTo(t)!==null},removeLink:function(t){if(t.source===this){E.remove(this.links,t);E.remove(this.outgoing,t);t.source=null}if(t.target===this){E.remove(this.links,t);E.remove(this.incoming,t);t.target=null}},hasLinkTo:function(e){return E.any(this.outgoing,function(t){return t.target===e})},degree:function(){return this.links.length},incidentWith:function(t){return g(this.links,t)},getLinksWith:function(e){return E.all(this.links,function(t){return t.getComplement(this)===e},this)},getNeighbors:function(){var e=[];E.forEach(this.incoming,function(t){e.push(t.getComplement(this))},this);E.forEach(this.outgoing,function(t){e.push(t.getComplement(this))},this);return e}}),L=w.Class.extend({init:function(t,e,i,n){if(E.isUndefined(t))throw"The source of the new link is not set.";if(E.isUndefined(e))throw"The target of the new link is not set.";var s,r;if(E.isString(t))s=new v(t);else s=t;if(E.isString(e))r=new v(e);else r=e;this.source=s;this.target=r;this.source.links.push(this);this.target.links.push(this);this.source.outgoing.push(this);this.target.incoming.push(this);if(E.isDefined(i))this.id=i;else this.id=T();if(E.isDefined(n))this.associatedConnection=n;else this.associatedConnection=null;this.type="Link";this.shortForm="Link '"+this.source.id+"->"+this.target.id+"'"},getComplement:function(t){if(this.source!==t&&this.target!==t)throw"The given node is not incident with this link.";return this.source===t?this.target:this.source},getCommonNode:function(t){if(this.source===t.source||this.source===t.target)return this.source;if(this.target===t.source||this.target===t.target)return this.target;return null},isBridging:function(t,e){return this.source===t&&this.target===e||this.source===e&&this.target===t},getNodes:function(){return[this.source,this.target]},incidentWith:function(t){return this.source===t||this.target===t},adjacentTo:function(t){return g(this.source.links,t)||g(this.target.links,t)},changeSource:function(t){E.remove(this.source.links,this);E.remove(this.source.outgoing,this);t.links.push(this);t.outgoing.push(this);this.source=t},changeTarget:function(t){E.remove(this.target.links,this);E.remove(this.target.incoming,this);t.links.push(this);t.incoming.push(this);this.target=t},changesNodes:function(t,e){if(this.source===t)this.changeSource(e);else if(this.target===t)this.changeTarget(e)},reverse:function(){var t=this.source;var e=this.target;this.source=e;E.remove(t.outgoing,this);this.source.outgoing.push(this);this.target=t;E.remove(e.incoming,this);this.target.incoming.push(this);return this},directTo:function(t){if(this.source!==t&&this.target!==t)throw"The given node is not incident with this link.";if(this.target!==t)this.reverse()},createReverseEdge:function(){var t=this.clone();t.reverse();t.reversed=true;return t},clone:function(){var t=new L(this.source,this.target);return t}}),m=w.Class.extend({init:function(t){this.links=[];this.nodes=[];this._nodeMap=new z;this.diagram=null;this._root=null;if(E.isDefined(t))if(E.isString(t))this.id=t;else{this.diagram=t;this.id=t.id}else this.id=T();this.bounds=new b;this._hasCachedRelationships=false;this.type="Graph"},cacheRelationships:function(t){if(E.isUndefined(t))t=false;if(this._hasCachedRelationships&&!t)return;for(var e=0,i=this.nodes.length;e<i;e++){var n=this.nodes[e];n.children=this.getChildren(n);n.parents=this.getParents(n)}this._hasCachedRelationships=true},assignLevels:function(t,e,i){if(!t)throw"Start node not specified.";if(E.isUndefined(e))e=0;this.cacheRelationships();if(E.isUndefined(i)){i=new z;E.forEach(this.nodes,function(t){i.add(t,false)})}i.set(t,true);t.level=e;var n=t.children;for(var s=0,r=n.length;s<r;s++){var o=n[s];if(!o||i.get(o))continue;this.assignLevels(o,e+1,i)}},root:function(t){if(E.isUndefined(t))if(!this._root){var e=E.first(this.nodes,function(t){return t.incoming.length===0});if(e)return e;return E.first(this.nodes)}else return this._root;else this._root=t},getConnectedComponents:function(){this.componentIndex=0;this.setItemIndices();var t=E.initArray(this.nodes.length,-1);for(var e=0;e<this.nodes.length;e++)if(t[e]===-1){this._collectConnectedNodes(t,e);this.componentIndex++}var i=[],n;for(n=0;n<this.componentIndex;++n)i[n]=new m;for(n=0;n<t.length;++n){var s=i[t[n]];s.addNodeAndOutgoings(this.nodes[n])}i.sort(function(t,e){return e.nodes.length-t.nodes.length});return i},_collectConnectedNodes:function(n,t){n[t]=this.componentIndex;var s=this.nodes[t];E.forEach(s.links,function(t){var e=t.getComplement(s);var i=e.index;if(n[i]===-1)this._collectConnectedNodes(n,i)},this)},calcBounds:function(){if(this.isEmpty()){this.bounds=new b;return this.bounds}var t=null;for(var e=0,i=this.nodes.length;e<i;e++){var n=this.nodes[e];if(!t)t=n.bounds();else t=t.union(n.bounds())}this.bounds=t;return this.bounds},getSpanningTree:function(t){var e=new m;var i=new z,n,s;e.root=t.clone();e.root.level=0;e.root.id=t.id;i.add(t,e.root);t.level=0;var r=[];var o=[];e._addNode(e.root);r.push(t);o.push(t);var a=1;while(o.length>0){var h=o.pop();for(var l=0;l<h.links.length;l++){var d=h.links[l];var c=d.getComplement(h);if(g(r,c))continue;c.level=h.level+1;if(a<c.level+1)a=c.level+1;if(!g(o,c))o.push(c);if(!g(r,c))r.push(c);if(i.containsKey(h))n=i.get(h);else{n=h.clone();n.level=h.level;n.id=h.id;i.add(h,n)}if(i.containsKey(c))s=i.get(c);else{s=c.clone();s.level=c.level;s.id=c.id;i.add(c,s)}var u=new L(n,s);e.addLink(u)}}var f=[];for(var p=0;p<a;p++)f.push([]);E.forEach(e.nodes,function(t){f[t.level].push(t)});e.treeLevels=f;e.cacheRelationships();return e},takeRandomNode:function(e,i){if(E.isUndefined(e))e=[];if(E.isUndefined(i))i=4;if(this.nodes.length===0)return null;if(this.nodes.length===1)return g(e,this.nodes[0])?null:this.nodes[0];var t=n.grep(this.nodes,function(t){return!g(e,t)&&t.degree()<=i});if(E.isEmpty(t))return null;return t[E.randomInteger(0,t.length)]},isEmpty:function(){return E.isEmpty(this.nodes)},isHealthy:function(){return E.all(this.links,function(t){return g(this.nodes,t.source)&&g(this.nodes,t.target)},this)},getParents:function(t){if(!this.hasNode(t))throw"The given node is not part of this graph.";return t.getParents()},getChildren:function(t){if(!this.hasNode(t))throw"The given node is not part of this graph.";return t.getChildren()},addLink:function(t,e,i){if(E.isUndefined(t))throw"The source of the link is not defined.";if(E.isUndefined(e))if(E.isDefined(t.type)&&t.type==="Link"){this.addExistingLink(t);return}else throw"The target of the link is not defined.";var n=this.getNode(t);if(E.isUndefined(n))n=this.addNode(t);var s=this.getNode(e);if(E.isUndefined(s))s=this.addNode(e);var r=new L(n,s);if(E.isDefined(i))r.owner=i;this.links.push(r);return r},removeAllLinks:function(){while(this.links.length>0){var t=this.links[0];this.removeLink(t)}},addExistingLink:function(t){if(this.hasLink(t))return;this.links.push(t);if(this.hasNode(t.source.id)){var e=this.getNode(t.source.id);t.changeSource(e)}else this.addNode(t.source);if(this.hasNode(t.target.id)){var i=this.getNode(t.target.id);t.changeTarget(i)}else this.addNode(t.target)},hasLink:function(e){if(E.isString(e))return E.any(this.links,function(t){return t.id===e});if(e.type==="Link")return g(this.links,e);throw"The given object is neither an identifier nor a Link."},getNode:function(t){var e=t.id||t;if(this._nodeMap.containsKey(e))return this._nodeMap.get(e)},hasNode:function(t){var e=t.id||t;return this._nodeMap.containsKey(e)},_addNode:function(t){this.nodes.push(t);this._nodeMap.add(t.id,t)},_removeNode:function(t){E.remove(this.nodes,t);this._nodeMap.remove(t.id)},removeNode:function(t){var e=t;if(E.isString(t))e=this.getNode(t);if(E.isDefined(e)){var i=e.links;e.links=[];for(var n=0,s=i.length;n<s;n++){var r=i[n];this.removeLink(r)}this._removeNode(e)}else throw"The identifier should be a Node or the Id (string) of a node."},areConnected:function(e,i){return E.any(this.links,function(t){return t.source==e&&t.target==i||t.source==i&&t.target==e})},removeLink:function(t){E.remove(this.links,t);E.remove(t.source.outgoing,t);E.remove(t.source.links,t);E.remove(t.target.incoming,t);E.remove(t.target.links,t)},addNode:function(t,e,i){var n=null;if(!E.isDefined(t))throw"No Node or identifier for a new Node is given.";if(E.isString(t)){if(this.hasNode(t))return this.getNode(t);n=new v(t)}else{if(this.hasNode(t))return this.getNode(t);n=t}if(E.isDefined(e))n.bounds(e);if(E.isDefined(i))n.owner=i;this._addNode(n);return n},addNodeAndOutgoings:function(t){if(!this.hasNode(t))this._addNode(t);var e=t.outgoing;t.outgoing=[];E.forEach(e,function(t){this.addExistingLink(t)},this)},setItemIndices:function(){var t;for(t=0;t<this.nodes.length;++t)this.nodes[t].index=t;for(t=0;t<this.links.length;++t)this.links[t].index=t},clone:function(t){var i=new m;var n=E.isDefined(t)&&t===true;if(n){i.nodeMap=new z;i.linkMap=new z}var s=new z;E.forEach(this.nodes,function(t){var e=t.clone();s.set(t,e);i._addNode(e);if(n)i.nodeMap.set(e,t)});E.forEach(this.links,function(t){if(s.containsKey(t.source)&&s.containsKey(t.target)){var e=i.addLink(s.get(t.source),s.get(t.target));if(n)i.linkMap.set(e,t)}});return i},linearize:function(t){return m.Utils.linearize(this,t)},depthFirstTraversal:function(t,e){if(E.isUndefined(t))throw"You need to supply a starting node.";if(E.isUndefined(e))throw"You need to supply an action.";if(!this.hasNode(t))throw"The given start-node is not part of this graph";var i=this.getNode(t);var n=[];this._dftIterator(i,e,n)},_dftIterator:function(t,e,i){e(t);i.push(t);var n=t.getChildren();for(var s=0,r=n.length;s<r;s++){var o=n[s];if(g(i,o))continue;this._dftIterator(o,e,i)}},breadthFirstTraversal:function(t,e){if(E.isUndefined(t))throw"You need to supply a starting node.";if(E.isUndefined(e))throw"You need to supply an action.";if(!this.hasNode(t))throw"The given start-node is not part of this graph";var i=this.getNode(t);var n=new I;var s=[];n.enqueue(i);while(n.length>0){var r=n.dequeue();e(r);s.push(r);var o=r.getChildren();for(var a=0,h=o.length;a<h;a++){var c=o[a];if(g(s,c)||g(n,c))continue;n.enqueue(c)}}},_stronglyConnectedComponents:function(t,e,i,n,s,r,o){i.add(e,o);n.add(e,o);o++;r.push(e);var l=e.getChildren(),a;for(var h=0,d=l.length;h<d;h++){a=l[h];if(!i.containsKey(a)){this._stronglyConnectedComponents(t,a,i,n,s,r,o);n.add(e,Math.min(n.get(e),n.get(a)))}else if(g(r,a))n.add(e,Math.min(n.get(e),i.get(a)))}if(n.get(e)===i.get(e)){var c=[];do{a=r.pop();c.push(a)}while(a!==e);if(!t||c.length>1)s.push(c)}},findCycles:function(t){if(E.isUndefined(t))t=true;var e=new z;var i=new z;var n=[];var s=[];for(var r=0,o=this.nodes.length;r<o;r++){var a=this.nodes[r];if(e.containsKey(a))continue;this._stronglyConnectedComponents(t,a,e,i,n,s,0)}return n},isAcyclic:function(){return E.isEmpty(this.findCycles())},isSubGraph:function(t){var e=t.linearize();var i=this.linearize();return E.all(e,function(t){return g(i,t)})},makeAcyclic:function(){if(this.isEmpty()||this.nodes.length<=1||this.links.length<=1)return[];if(this.nodes.length==2){var l=[];if(this.links.length>1){var d=this.links[0];var u=d.source;for(var f=0,p=this.links.length;f<p;f++){var g=this.links[f];if(g.source==u)continue;var v=g.reverse();l.push(v)}}return l}var t=this.clone(true);var n=this.nodes.length;var e=new z;var s=function(t){if(t.outgoing.length===0)return 2-n;else if(t.incoming.length===0)return n-2;else return t.outgoing.length-t.incoming.length};var m=function(t,e){var i=s(t,n);if(!e.containsKey(i))e.set(i,[]);e.get(i).push(t)};E.forEach(t.nodes,function(t){m(t,e)});var i=[];var _=[];while(t.nodes.length>0){var r,o,a;if(e.containsKey(2-n)){var y=e.get(2-n);while(y.length>0){o=y.pop();for(var w=0;w<o.links.length;w++){var x=o.links[w];r=x.getComplement(o);a=s(r,n);E.remove(e.get(a),r);r.removeLink(x);m(r,e)}t._removeNode(o);_.unshift(o)}}if(e.containsKey(n-2)){var b=e.get(n-2);while(b.length>0){r=b.pop();for(var C=0;C<r.links.length;C++){var S=r.links[C];o=S.getComplement(r);a=s(o,n);E.remove(e.get(a),o);o.removeLink(S);m(o,e)}i.push(r);t._removeNode(r)}}if(t.nodes.length>0)for(var h=n-3;h>2-n;h--)if(e.containsKey(h)&&e.get(h).length>0){var k=e.get(h);var c=k.pop();for(var T=0;T<c.links.length;T++){var M=c.links[T];var D=M.getComplement(c);a=s(D,n);E.remove(e.get(a),D);D.removeLink(M);m(D,e)}i.push(c);t._removeNode(c);break}}i=i.concat(_);var I=new z;for(var P=0;P<this.nodes.length;P++)I.set(t.nodeMap.get(i[P]),P);var L=[];E.forEach(this.links,function(t){if(I.get(t.source)>I.get(t.target)){t.reverse();L.push(t)}});return L}});m.Predefined={EightGraph:function(){return m.Utils.parse(["1->2","2->3","3->4","4->1","3->5","5->6","6->7","7->3"])},Mindmap:function(){return m.Utils.parse(["0->1","0->2","0->3","0->4","0->5","1->6","1->7","7->8","2->9","9->10","9->11","3->12","12->13","13->14","4->15","4->16","15->17","15->18","18->19","18->20","14->21","14->22","5->23","23->24","23->25","6->26"])},ThreeGraph:function(){return m.Utils.parse(["1->2","2->3","3->1"])},BinaryTree:function(t){if(E.isUndefined(t))t=5;return m.Utils.createBalancedTree(t,2)},Linear:function(t){if(E.isUndefined(t))t=10;return m.Utils.createBalancedTree(t,1)},Tree:function(t,e){return m.Utils.createBalancedTree(t,e)},Forest:function(t,e,i){return m.Utils.createBalancedForest(t,e,i)},Workflow:function(){return m.Utils.parse(["0->1","1->2","2->3","1->4","4->3","3->5","5->6","6->3","6->7","5->4"])},Grid:function(t,e){var i=new p.Graph;if(t<=0&&e<=0)return i;for(var n=0;n<t+1;n++){var s=null;for(var r=0;r<e+1;r++){var o=new v(n.toString()+"."+r.toString());i.addNode(o);if(s)i.addLink(s,o);if(n>0){var a=i.getNode((n-1).toString()+"."+r.toString());i.addLink(a,o)}s=o}}return i}},m.Utils={parse:function(t){var e,i=new p.Graph,n=t.slice();for(var s=0,r=n.length;s<r;s++){var o=n[s];if(E.isString(o)){if(o.indexOf("->")<0)throw"The link should be specified as 'a->b'.";var a=o.split("->");if(a.length!=2)throw"The link should be specified as 'a->b'.";e=new L(a[0],a[1]);i.addLink(e)}if(E.isObject(o)){if(!e)throw"Specification found before Link definition.";w.deepExtend(e,o)}}return i},linearize:function(t,e){if(E.isUndefined(t))throw"Expected an instance of a Graph object in slot one.";if(E.isUndefined(e))e=false;var i=[];for(var n=0,s=t.links.length;n<s;n++){var r=t.links[n];i.push(r.source.id+"->"+r.target.id);if(e)i.push({id:r.id})}return i},_addShape:function(t,e,i,n){if(E.isUndefined(e))e=new p.Point(0,0);if(E.isUndefined(i))i=T();n=w.deepExtend({width:20,height:20,id:i,radius:10,fill:"#778899",data:"circle",undoable:false,x:e.x,y:e.y},n);return t.addShape(n)},_addConnection:function(t,e,i,n){return t.connect(e,i,n)},createDiagramFromGraph:function(t,e,i,n){if(E.isUndefined(t))throw"The diagram surface is undefined.";if(E.isUndefined(e))throw"No graph specification defined.";if(E.isUndefined(i))i=true;if(E.isUndefined(n))n=false;var l=t.element.clientWidth||200;var d=t.element.clientHeight||200;var s=[],r,o;for(var a=0,u=e.nodes.length;a<u;a++){r=e.nodes[a];var h=r.position;if(E.isUndefined(h))if(E.isDefined(r.x)&&E.isDefined(r.y))h=new x(r.x,r.y);else h=new x(E.randomInteger(10,l-20),E.randomInteger(10,d-20));var f={};if(r.id==="0");else if(n)w.deepExtend(f,{width:Math.random()*150+20,height:Math.random()*80+50,data:"rectangle",fill:{color:"#778899"}});o=this._addShape(t,h,r.id,f);var c=o.bounds();if(E.isDefined(c)){r.x=c.x;r.y=c.y;r.width=c.width;r.height=c.height}s[r.id]=o}for(var p=0;p<e.links.length;p++){var g=e.links[p];var v=s[g.source.id];if(E.isUndefined(v))continue;var m=s[g.target.id];if(E.isUndefined(m))continue;this._addConnection(t,v,m,{id:g.id})}if(i){var _=new t.SpringLayout(t);_.layoutGraph(e,{limitToView:false});for(var y=0;y<e.nodes.length;y++){r=e.nodes[y];o=s[r.id];o.bounds(new b(r.x,r.y,r.width,r.height))}}},createBalancedTree:function(t,e){if(E.isUndefined(t))t=3;if(E.isUndefined(e))e=3;var i=new p.Graph,n=-1,s=[],r;if(t<=0||e<=0)return i;var o=new v((++n).toString());i.addNode(o);i.root=o;s.push(o);for(var a=0;a<t;a++){r=[];for(var h=0;h<s.length;h++){var l=s[h];for(var c=0;c<e;c++){var d=new v((++n).toString());i.addLink(l,d);r.push(d)}}s=r}return i},createBalancedForest:function(t,e,i){if(E.isUndefined(t))t=3;if(E.isUndefined(e))e=3;if(E.isUndefined(i))i=5;var n=new p.Graph,s=-1,r=[],o;if(t<=0||e<=0||i<=0)return n;for(var a=0;a<i;a++){var h=new v((++s).toString());n.addNode(h);r=[h];for(var l=0;l<t;l++){o=[];for(var c=0;c<r.length;c++){var d=r[c];for(var u=0;u<e;u++){var f=new v((++s).toString());n.addLink(d,f);o.push(f)}}r=o}}return n},createRandomConnectedGraph:function(t,e,i){if(E.isUndefined(t))t=40;if(E.isUndefined(e))e=4;if(E.isUndefined(i))i=false;var n=new p.Graph,s=-1;if(t<=0)return n;var l=new v((++s).toString());n.addNode(l);if(t===1)return n;if(t>1){for(var r=1;r<t;r++){var o=n.takeRandomNode([],e);if(!o)break;var d=n.addNode(r.toString());n.addLink(o,d)}if(!i&&t>1){var u=E.randomInteger(1,t);for(var a=0;a<u;a++){var h=n.takeRandomNode([],e);var c=n.takeRandomNode([],e);if(h&&c&&!n.areConnected(h,c))n.addLink(h,c)}}return n}},randomDiagram:function(t,e,i,n,s){var r=w.dataviz.diagram.Graph.Utils.createRandomConnectedGraph(e,i,n);m.Utils.createDiagramFromGraph(t,r,false,s)}},w.deepExtend(p,{init:function(t){w.init(t,p.ui)},Point:x,Intersect:_,Geometry:M,Rect:b,Size:d,RectAlign:y,Matrix:s,MatrixVector:S,normalVariable:k,randomId:T,Dictionary:z,HashTable:D,Queue:I,Set:P,Node:v,Link:L,Graph:m,PathDefiner:l})})}("function"==typeof define&&define.amd?define:function(t,e,i){(i||e)()}),function(define){define("dataviz/diagram/svg.min",["kendo.drawing.min","./math.min"],function(){var d=window.kendo.jQuery,u=void 0,i=window.kendo,e=i.dataviz.diagram,t=i.Class,h=i.deepExtend,f=e.Point,p=e.Rect,g=e.Matrix,v=e.Utils,m=v.isNumber,_=v.isString,y=e.MatrixVector,a=i.geometry,r=i.drawing,o=r.util.defined,w=d.inArray,x="transparent",b={none:"none",arrowStart:"ArrowStart",filledCircle:"FilledCircle",arrowEnd:"ArrowEnd"},C=360,c="start",S="end",k="width",T="height",M="x",D="y";function I(t,e){var i=this.options;var n=false;var s,r;for(var o=0;o<e.length;o++){r=e[o];s=t[r];if(m(s)&&i[r]!==s){i[r]=s;n=true}}return n}e.Markers=b;var P=t.extend({init:function(t,e){this.x=t;this.y=e},toMatrix:function(){return g.scaling(this.x,this.y)},toString:function(){return i.format("scale({0},{1})",this.x,this.y)},invert:function(){return new P(1/this.x,1/this.y)}}),L=t.extend({init:function(t,e){this.x=t;this.y=e},toMatrixVector:function(){return new y(0,0,0,0,this.x,this.y)},toMatrix:function(){return g.translation(this.x,this.y)},toString:function(){return i.format("translate({0},{1})",this.x,this.y)},plus:function(t){this.x+=t.x;this.y+=t.y},times:function(t){this.x*=t;this.y*=t},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},normalize:function(){if(this.Length===0)return;this.times(1/this.length())},invert:function(){return new L(-this.x,-this.y)}}),l=t.extend({init:function(t,e,i){this.x=e||0;this.y=i||0;this.angle=t},toString:function(){if(this.x&&this.y)return i.format("rotate({0},{1},{2})",this.angle,this.x,this.y);else return i.format("rotate({0})",this.angle)},toMatrix:function(){return g.rotation(this.angle,this.x,this.y)},center:function(){return new f(this.x,this.y)},invert:function(){return new l(C-this.angle,this.x,this.y)}}),E=(l.ZERO=new l(0),l.create=function(t){return new l(t.angle,t.x,t.y)},l.parse=function(t){var e=t.slice(1,t.length-1).split(","),i=e[0],n=e[1],s=e[2];var r=new l(i,n,s);return r},t.extend({init:function(t,e,i,n,s,r){this.translate=new L(t,e);if(i!==u&&n!==u)this.scale=new P(i,n);if(s!==u)this.rotate=r?new l(s,r.x,r.y):new l(s)},toString:function(){var t=function(t){return t?t.toString():""};return t(this.translate)+t(this.rotate)+t(this.scale)},render:function(t){t._transform=this;t._renderTransform()},toMatrix:function(){var t=g.unit();if(this.translate)t=t.times(this.translate.toMatrix());if(this.rotate)t=t.times(this.rotate.toMatrix());if(this.scale)t=t.times(this.scale.toMatrix());return t},invert:function(){var t=this.rotate?this.rotate.invert():u,e=t?t.toMatrix():g.unit(),i=this.scale?this.scale.invert():u,n=i?i.toMatrix():g.unit();var s=new f(-this.translate.x,-this.translate.y);s=e.times(n).apply(s);var r=new L(s.x,s.y);var o=new E;o.translate=r;o.rotate=t;o.scale=i;return o}})),z={_setScale:function(){var t=this.options;var e=this._originWidth;var i=this._originHeight;var n=t.width/e;var s=t.height/i;if(!m(n))n=1;if(!m(s))s=1;this._transform.scale=new P(n,s)},_setTranslate:function(){var t=this.options;var e=t.x||0;var i=t.y||0;this._transform.translate=new L(e,i)},_initSize:function(){var t=this.options;var e=false;if(t.autoSize!==false&&(o(t.width)||o(t.height))){this._measure(true);this._setScale();e=true}if(o(t.x)||o(t.y)){this._setTranslate();e=true}if(e)this._renderTransform()},_updateSize:function(t){var e=false;if(this.options.autoSize!==false&&this._diffNumericOptions(t,[k,T])){e=true;this._measure(true);this._setScale()}if(this._diffNumericOptions(t,[M,D])){e=true;this._setTranslate()}if(e)this._renderTransform();return e}},n=t.extend({init:function(t){var e=this;e.options=h({},e.options,t);e.id=e.options.id;e._originSize=p.empty();e._transform=new E},visible:function(t){return this.drawingContainer().visible(t)},redraw:function(t){if(t&&t.id)this.id=t.id},position:function(t,e){var i=this.options;if(!o(t))return new f(i.x,i.y);if(o(e)){i.x=t;i.y=e}else if(t instanceof f){i.x=t.x;i.y=t.y}this._transform.translate=new L(i.x,i.y);this._renderTransform()},rotate:function(t,e){if(o(t)){this._transform.rotate=new l(t,e.x,e.y);this._renderTransform()}return this._transform.rotate||l.ZERO},drawingContainer:function(){return this.drawingElement},_renderTransform:function(){var t=this._transform.toMatrix();this.drawingContainer().transform(new a.Matrix(t.a,t.b,t.c,t.d,t.e,t.f))},_hover:function(){},_diffNumericOptions:I,_measure:function(t){var e;if(!this._measured||t){var i=this._boundingBox()||new a.Rect;var n=i.topLeft();e=new p(n.x,n.y,i.width(),i.height());this._originSize=e;this._originWidth=e.width;this._originHeight=e.height;this._measured=true}else e=this._originSize;return e},_boundingBox:function(){return this.drawingElement.rawBBox()}}),s=n.extend({init:function(t){n.fn.init.call(this,t);t=this.options;t.fill=j(t.fill);t.stroke=j(t.stroke)},options:{stroke:{color:"gray",width:1},fill:{color:x}},fill:function(t,e){this._fill({color:J(t),opacity:e})},stroke:function(t,e,i){this._stroke({color:J(t),width:e,opacity:i})},redraw:function(t){if(t){var e=t.stroke;var i=t.fill;if(e)this._stroke(j(e));if(i)this._fill(j(i));n.fn.redraw.call(this,t)}},_hover:function(t){var e=this.drawingElement;var i=this.options;var n=i.hover;if(n&&n.fill){var s=t?j(n.fill):i.fill;e.fill(s.color,s.opacity)}},_stroke:function(t){var e=this.options;h(e,{stroke:t});t=e.stroke;var i=null;if(t.width>0)i={color:t.color,width:t.width,opacity:t.opacity,dashType:t.dashType};this.drawingElement.options.set("stroke",i)},_fill:function(t){var e=this.options;h(e,{fill:t||{}});var i=e.fill;if(i.gradient){var n=i.gradient;var s=n.type==="radial"?r.RadialGradient:r.LinearGradient;this.drawingElement.fill(new s(n))}else this.drawingElement.fill(i.color,i.opacity)}}),B=s.extend({init:function(t){t=this._textColor(t);s.fn.init.call(this,t);this._font();this._initText();this._initSize()},options:{fontSize:15,fontFamily:"sans-serif",stroke:{width:0},fill:{color:"black"},autoSize:true},_initText:function(){var t=this.options;this.drawingElement=new r.Text(o(t.text)?t.text:"",new a.Point,{font:t.font});this._fill();this._stroke()},_textColor:function(t){if(t&&t.color)t=h({},t,{fill:{color:t.color}});return t},_font:function(){var t=this.options;if(t.fontFamily&&o(t.fontSize)){var e=[];if(t.fontStyle)e.push(t.fontStyle);if(t.fontWeight)e.push(t.fontWeight);e.push(t.fontSize+(m(t.fontSize)?"px":""));e.push(t.fontFamily);t.font=e.join(" ")}else delete t.font},content:function(t){return this.drawingElement.content(t)},redraw:function(t){if(t){var e=false;var i=this.options;t=this._textColor(t);s.fn.redraw.call(this,t);if(t.fontFamily||o(t.fontSize)||t.fontStyle||t.fontWeight){h(i,{fontFamily:t.fontFamily,fontSize:t.fontSize,fontStyle:t.fontStyle,fontWeight:t.fontWeight});this._font();this.drawingElement.options.set("font",i.font);e=true}if(t.text){this.content(t.text);e=true}if(!this._updateSize(t)&&e)this._initSize()}}}),R=(h(B.fn,z),s.extend({init:function(t){s.fn.init.call(this,t);this._initPath();this._setPosition()},_setPosition:function(){var t=this.options;var e=t.x;var i=t.y;if(o(e)||o(i))this.position(e||0,i||0)},redraw:function(t){if(t){s.fn.redraw.call(this,t);if(this._diffNumericOptions(t,[k,T]))this._drawPath();if(this._diffNumericOptions(t,[M,D]))this._setPosition()}},_initPath:function(){var t=this.options;this.drawingElement=new r.Path({stroke:t.stroke,closed:true});this._fill();this._drawPath()},_drawPath:function(){var t=this.drawingElement;var e=Y(this.options);var i=e.width;var n=e.height;t.segments.elements([Z(0,0),Z(i,0),Z(i,n),Z(0,n)])}})),N=s.extend({init:function(t){s.fn.init.call(this,t);var e=this.options.anchor;this.anchor=new a.Point(e.x,e.y);this.createElement()},options:{stroke:{color:x,width:0},fill:{color:"black"}},_transformToPath:function(t,e){var i=e.transform();if(t&&i)t=t.transformCopy(i);return t},redraw:function(t){if(t){if(t.position)this.options.position=t.position;s.fn.redraw.call(this,t)}}}),O=N.extend({options:{radius:4,anchor:{x:0,y:0}},createElement:function(){var t=this.options;this.drawingElement=new r.Circle(new a.Circle(this.anchor,t.radius),{fill:t.fill,stroke:t.stroke})},positionMarker:function(t){var e=this.options;var i=e.position;var n=t.segments;var s;var r;if(i==c)s=n[0];else s=n[n.length-1];if(s){r=this._transformToPath(s.anchor(),t);this.drawingElement.transform(a.transform().translate(r.x,r.y))}}}),A=N.extend({options:{path:"M 0 0 L 10 5 L 0 10 L 3 5 z",anchor:{x:10,y:5}},createElement:function(){var t=this.options;this.drawingElement=r.Path.parse(t.path,{fill:t.fill,stroke:t.stroke})},positionMarker:function(t){var e=this._linePoints(t);var i=e.start;var n=e.end;var s=a.transform();if(i)s.rotate(Q(i,n),n);if(n){var r=this.anchor;var o=n.clone().translate(-r.x,-r.y);s.translate(o.x,o.y)}this.drawingElement.transform(s)},_linePoints:function(t){var e=this.options;var i=t.segments;var n,s,r;if(e.position==c){r=i[0];if(r){s=r.anchor();n=r.controlOut();var o=i[1];if(!n&&o)n=o.anchor()}}else{r=i[i.length-1];if(r){s=r.anchor();n=r.controlIn();var a=i[i.length-2];if(!n&&a)n=a.anchor()}}if(s)return{start:this._transformToPath(n,t),end:this._transformToPath(s,t)}}}),U={_getPath:function(t){var e=this.drawingElement;if(e instanceof r.MultiPath)if(t==c)e=e.paths[0];else e=e.paths[e.paths.length-1];if(e&&e.segments.length)return e},_normalizeMarkerOptions:function(t){var e=t.startCap;var i=t.endCap;if(_(e))t.startCap={type:e};if(_(i))t.endCap={type:i}},_removeMarker:function(t){var e=this._markers[t];if(e){this.drawingContainer().remove(e.drawingElement);delete this._markers[t]}},_createMarkers:function(){var t=this.options;this._normalizeMarkerOptions(t);this._markers={};this._markers[c]=this._createMarker(t.startCap,c);this._markers[S]=this._createMarker(t.endCap,S)},_createMarker:function(t,e){var i=(t||{}).type;var n=this._getPath(e);var s,r;if(!n){this._removeMarker(e);return}if(i==b.filledCircle)s=O;else if(i==b.arrowStart||i==b.arrowEnd)s=A;else this._removeMarker(e);if(s){r=new s(h({},t,{position:e}));r.positionMarker(n);this.drawingContainer().append(r.drawingElement);return r}},_positionMarker:function(t){var e=this._markers[t];if(e){var i=this._getPath(t);if(i)e.positionMarker(i);else this._removeMarker(t)}},_capMap:{start:"startCap",end:"endCap"},_redrawMarker:function(t,e,i){this._normalizeMarkerOptions(i);var n=this.options;var s=this._capMap[e];var r=(n[s]||{}).type;var o=i[s];var a=false;if(o){n[s]=h({},n[s],o);if(o.type&&r!=o.type){this._removeMarker(e);this._markers[e]=this._createMarker(n[s],e);a=true}else if(this._markers[e])this._markers[e].redraw(o)}else if(t&&!this._markers[e]&&n[s]){this._markers[e]=this._createMarker(n[s],e);a=true}return a},_redrawMarkers:function(t,e){if(!this._redrawMarker(t,c,e)&&t)this._positionMarker(c);if(!this._redrawMarker(t,S,e)&&t)this._positionMarker(S)}},V=s.extend({init:function(t){s.fn.init.call(this,t);this.container=new r.Group;this._createElements();this._initSize()},options:{autoSize:true},drawingContainer:function(){return this.container},data:function(t){var e=this.options;if(t){if(e.data!=t){e.data=t;this._setData(t);this._initSize();this._redrawMarkers(true,{})}}else return e.data},redraw:function(t){if(t){s.fn.redraw.call(this,t);var e=this.options;var i=t.data;if(o(i)&&e.data!=i){e.data=i;this._setData(i);if(!this._updateSize(t))this._initSize();this._redrawMarkers(true,t)}else{this._updateSize(t);this._redrawMarkers(false,t)}}},_createElements:function(){var t=this.options;this.drawingElement=r.Path.parse(t.data||"",{stroke:t.stroke});this._fill();this.container.append(this.drawingElement);this._createMarkers()},_setData:function(t){var e=this.drawingElement;var i=r.Path.parse(t||"");var n=i.paths.slice(0);i.paths.elements([]);e.paths.elements(n)}}),H=(h(V.fn,z),h(V.fn,U),s.extend({init:function(t){s.fn.init.call(this,t);this.container=new r.Group;this._initPath();this._createMarkers()},drawingContainer:function(){return this.container},redraw:function(t){if(t){t=t||{};var e=t.from;var i=t.to;if(e)this.options.from=e;if(i)this.options.to=i;if(e||i){this._drawPath();this._redrawMarkers(true,t)}else this._redrawMarkers(false,t);s.fn.redraw.call(this,t)}},_initPath:function(){var t=this.options;var e=this.drawingElement=new r.Path({stroke:t.stroke});this._fill();this._drawPath();this.container.append(e)},_drawPath:function(){var t=this.options;var e=this.drawingElement;var i=t.from||new f;var n=t.to||new f;e.segments.elements([Z(i.x,i.y),Z(n.x,n.y)])}})),F=(h(H.fn,U),s.extend({init:function(t){s.fn.init.call(this,t);this.container=new r.Group;this._initPath();this._createMarkers()},drawingContainer:function(){return this.container},points:function(t){var e=this.options;if(t){e.points=t;this._updatePath()}else return e.points},redraw:function(t){if(t){var e=t.points;s.fn.redraw.call(this,t);if(e&&this._pointsDiffer(e)){this.points(e);this._redrawMarkers(true,t)}else this._redrawMarkers(false,t)}},_initPath:function(){var t=this.options;this.drawingElement=new r.Path({stroke:t.stroke});this._fill();this.container.append(this.drawingElement);if(t.points)this._updatePath()},_pointsDiffer:function(t){var e=this.options.points;var i=e.length!==t.length;if(!i)for(var n=0;n<t.length;n++)if(e[n].x!==t[n].x||e[n].y!==t[n].y){i=true;break}return i},_updatePath:function(){var t=this.drawingElement;var e=this.options;var i=e.points;var n=[];var s;for(var r=0;r<i.length;r++){s=i[r];n.push(Z(s.x,s.y))}t.segments.elements(n)},options:{points:[]}})),G=(h(F.fn,U),n.extend({init:function(t){n.fn.init.call(this,t);this._initImage()},redraw:function(t){if(t){if(t.source)this.drawingElement.src(t.source);if(this._diffNumericOptions(t,[k,T,M,D]))this.drawingElement.rect(this._rect());n.fn.redraw.call(this,t)}},_initImage:function(){var t=this.options;var e=this._rect();this.drawingElement=new r.Image(t.source,e,{})},_rect:function(){var t=Y(this.options);var e=new a.Point(t.x,t.y);var i=new a.Size(t.width,t.height);return new a.Rect(e,i)}})),q=n.extend({init:function(t){this.children=[];n.fn.init.call(this,t);this.drawingElement=new r.Group;this._initSize()},options:{autoSize:false},append:function(t){this.drawingElement.append(t.drawingContainer());this.children.push(t);this._childrenChange=true},remove:function(t){if(this._remove(t))this._childrenChange=true},_remove:function(t){var e=w(t,this.children);if(e>=0){this.drawingElement.removeAt(e);this.children.splice(e,1);return true}},clear:function(){this.drawingElement.clear();this.children=[];this._childrenChange=true},toFront:function(t){var e;for(var i=0;i<t.length;i++){e=t[i];if(this._remove(e))this.append(e)}},toBack:function(t){this._reorderChildren(t,0)},toIndex:function(t,e){this._reorderChildren(t,e)},_reorderChildren:function(t,e){var i=this.drawingElement;var n=i.children.slice(0);var s=this.children;var l=m(e);var r,o,a,h,c;for(r=0;r<t.length;r++){c=t[r];h=c.drawingContainer();o=w(c,s);if(o>=0){n.splice(o,1);s.splice(o,1);a=l?e:e[r];n.splice(a,0,h);s.splice(a,0,c)}}i.clear();i.append.apply(i,n)},redraw:function(t){if(t){if(this._childrenChange){this._childrenChange=false;if(!this._updateSize(t))this._initSize()}else this._updateSize(t);n.fn.redraw.call(this,t)}},_boundingBox:function(){var t=this.children;var e;var i,n;for(var s=0;s<t.length;s++){i=t[s];if(i.visible()&&i._includeInBBox!==false){n=i.drawingContainer().clippedBBox(null);if(n)if(e)e=a.Rect.union(e,n);else e=n}}return e}}),K=(h(q.fn,z),q.extend({init:function(t,e){this.children=[];n.fn.init.call(this,e);this.drawingElement=new r.Layout($(t),e);this._initSize()},rect:function(t){if(t)this.drawingElement.rect($(t));else{var e=this.drawingElement.rect();if(e)return new p(e.origin.x,e.origin.y,e.size.width,e.size.height)}},reflow:function(){this.drawingElement.reflow()},redraw:function(t){i.deepExtend(this.drawingElement.options,t);q.fn.redraw.call(this,t)}})),W=s.extend({init:function(t){s.fn.init.call(this,t);this._initCircle();this._initSize()},redraw:function(t){if(t){var e=this.options;if(t.center){h(e,{center:t.center});this._center.move(e.center.x,e.center.y)}if(this._diffNumericOptions(t,["radius"]))this._circle.setRadius(e.radius);this._updateSize(t);s.fn.redraw.call(this,t)}},_initCircle:function(){var t=this.options;var e=t.width;var i=t.height;var n=t.radius;if(!o(n)){if(!o(e))e=i;if(!o(i))i=e;t.radius=n=Math.min(e,i)/2}var s=t.center||{x:n,y:n};this._center=new a.Point(s.x,s.y);this._circle=new a.Circle(this._center,n);this.drawingElement=new r.Circle(this._circle,{stroke:t.stroke});this._fill()}}),X=(h(W.fn,z),t.extend({init:function(t,e){e=e||{};this.element=t;this.surface=r.Surface.create(t,e);if(i.isFunction(this.surface.translate))this.translate=this._translate;this.drawingElement=new r.Group;this._viewBox=new p(0,0,e.width,e.height);this.size(this._viewBox)},bounds:function(){var t=this.drawingElement.clippedBBox();return new p(0,0,t.width(),t.height())},size:function(t){var e=this._viewBox;if(o(t)){e.width=t.width;e.height=t.height;this.surface.setSize(t)}return{width:e.width,height:e.height}},_translate:function(t,e){var i=this._viewBox;if(o(t)&&o(e)){i.x=t;i.y=e;this.surface.translate({x:t,y:e})}return{x:i.x,y:i.y}},draw:function(){this.surface.draw(this.drawingElement)},append:function(t){this.drawingElement.append(t.drawingContainer());return this},remove:function(t){this.drawingElement.remove(t.drawingContainer())},insertBefore:function(){},clear:function(){this.drawingElement.clear()},destroy:function(t){this.surface.destroy();if(t)d(this.element).remove()}}));function Y(t){return{x:t.x||0,y:t.y||0,width:t.width||0,height:t.height||0}}function j(t){if(t){var e=t;if(_(e))e={color:e};if(e.color)e.color=J(e.color);return e}}function J(t){var e;if(t!=x)e=new r.Color(t).toHex();else e=t;return e}function Q(t,e){var i=e.x-t.x;var n=e.y-t.y;var s=r.util.deg(Math.atan2(n,i));return s}function Z(t,e){return new r.Segment(new a.Point(t,e))}function $(t){if(t)return new a.Rect([t.x,t.y],[t.width,t.height])}i.deepExtend(e,{init:function(t){i.init(t,e.ui)},diffNumericOptions:I,Element:n,Scale:P,Translation:L,Rotation:l,Circle:W,Group:q,Rectangle:R,Canvas:X,Path:V,Layout:K,Line:H,MarkerBase:N,ArrowMarker:A,CircleMarker:O,Polyline:F,CompositeTransform:E,TextBlock:B,Image:G,VisualBase:s})})}("function"==typeof define&&define.amd?define:function(t,e,i){(i||e)()}),function(define){define("dataviz/diagram/services.min",["kendo.drawing.min","./svg.min"],function(){var l=window.kendo.jQuery,o=void 0,h=window.kendo,e,c=h.dataviz.diagram,t=h.Class,d=c.Group,y=c.Rect,u=c.Rectangle,x=c.Utils,f=x.isUndefined,w=c.Point,p=c.Circle,i=c.Ticker,a=h.deepExtend,g=h.ui.Movable,v=h.drawing.util,r=v.defined,m=l.inArray,n={arrow:"default",grip:"pointer",cross:"pointer",add:"pointer",move:"move",select:"pointer",south:"s-resize",east:"e-resize",west:"w-resize",north:"n-resize",rowresize:"row-resize",colresize:"col-resize"},_=10,b="Auto",C="Top",S="Right",k="Left",T="Bottom",M=10,D=10,I="dragStart",P="drag",L="dragEnd",E="itemRotate",z="itemBoundsChange",B=5,R=5,N="mouseEnter",O="mouseLeave",A="zoomStart",U="zoomEnd",V=-2e4,H=2e4,F=.9,G=.93,q=5,K="transparent",W="pan",X="rotated",Y,j="target",J={"-1":"source",1:j},Q=(c.Cursors=n,h.Class.extend({init:function(t){this.layoutState=t;this.diagram=t.diagram},initState:function(){this.froms=[];this.tos=[];this.subjects=[];function t(t,e){var i=this.diagram.getShapeById(t);if(i){this.subjects.push(i);this.froms.push(i.bounds().topLeft());this.tos.push(e.topLeft())}}this.layoutState.nodeMap.forEach(t,this)},update:function(t){if(this.subjects.length<=0)return;for(var e=0;e<this.subjects.length;e++)this.subjects[e].position(new w(this.froms[e].x+(this.tos[e].x-this.froms[e].x)*t,this.froms[e].y+(this.tos[e].y-this.froms[e].y)*t))}})),Z=t.extend({init:function(t,e,i){if(f(i))this.animate=false;else this.animate=i;this._initialState=t;this._finalState=e;this.title="Diagram layout"},undo:function(){this.setState(this._initialState)},redo:function(){this.setState(this._finalState)},setState:function(t){var n=t.diagram;if(this.animate){t.linkMap.forEach(function(t,e){var i=n.getShapeById(t);i.visible(false);if(i)i.points(e)});var e=new i;e.addAdapter(new Q(t));e.onComplete(function(){t.linkMap.forEach(function(t){var e=n.getShapeById(t);e.visible(true)})});e.play()}else{t.nodeMap.forEach(function(t,e){var i=n.getShapeById(t);if(i)i.position(e.topLeft())});t.linkMap.forEach(function(t,e){var i=n.getShapeById(t);if(i)i.points(e)})}}}),$=t.extend({init:function(t){this.units=[];this.title="Composite unit";if(t!==o)this.units.push(t)},add:function(t){this.units.push(t)},undo:function(){for(var t=0;t<this.units.length;t++)this.units[t].undo()},redo:function(){for(var t=0;t<this.units.length;t++)this.units[t].redo()}}),tt=t.extend({init:function(t,e,i){this.item=t;this._redoSource=e;this._redoTarget=i;if(r(e))this._undoSource=t.source();if(r(i))this._undoTarget=t.target();this.title="Connection Editing"},undo:function(){if(this._undoSource!==o)this.item._updateConnector(this._undoSource,"source");if(this._undoTarget!==o)this.item._updateConnector(this._undoTarget,"target");this.item.updateModel()},redo:function(){if(this._redoSource!==o)this.item._updateConnector(this._redoSource,"source");if(this._redoTarget!==o)this.item._updateConnector(this._redoTarget,"target");this.item.updateModel()}}),et=t.extend({init:function(t,e,i){this.item=t;this._undoSource=e;this._undoTarget=i;this._redoSource=t.source();this._redoTarget=t.target();this.title="Connection Editing"},undo:function(){this.item._updateConnector(this._undoSource,"source");this.item._updateConnector(this._undoTarget,"target");this.item.updateModel()},redo:function(){this.item._updateConnector(this._redoSource,"source");this.item._updateConnector(this._redoTarget,"target");this.item.updateModel()}}),it=t.extend({init:function(t){this.connection=t;this.diagram=t.diagram;this.targetConnector=t.targetConnector;this.title="Delete connection"},undo:function(){this.diagram._addConnection(this.connection,false)},redo:function(){this.diagram.remove(this.connection,false)}}),nt=t.extend({init:function(t){this.shape=t;this.diagram=t.diagram;this.title="Deletion"},undo:function(){this.diagram._addShape(this.shape,false);this.shape.select(false)},redo:function(){this.shape.select(false);this.diagram.remove(this.shape,false)}}),st=t.extend({init:function(t,e,i){this.shapes=t;this.undoStates=e;this.title="Transformation";this.redoStates=[];this.adorner=i;for(var n=0;n<this.shapes.length;n++){var s=this.shapes[n];this.redoStates.push(s.bounds())}},undo:function(){for(var t=0;t<this.shapes.length;t++){var e=this.shapes[t];e.bounds(this.undoStates[t]);if(e.hasOwnProperty("layout"))e.layout(e,this.redoStates[t],this.undoStates[t]);e.updateModel()}if(this.adorner){this.adorner.refreshBounds();this.adorner.refresh()}},redo:function(){for(var t=0;t<this.shapes.length;t++){var e=this.shapes[t];e.bounds(this.redoStates[t]);if(e.hasOwnProperty("layout"))e.layout(e,this.undoStates[t],this.redoStates[t]);e.updateModel()}if(this.adorner){this.adorner.refreshBounds();this.adorner.refresh()}}}),rt=t.extend({init:function(t,e){this.connection=t;this.diagram=e;this.title="New connection"},undo:function(){this.diagram.remove(this.connection,false)},redo:function(){this.diagram._addConnection(this.connection,false)}}),ot=t.extend({init:function(t,e){this.shape=t;this.diagram=e;this.title="New shape"},undo:function(){this.diagram.deselect();this.diagram.remove(this.shape,false)},redo:function(){this.diagram._addShape(this.shape,false)}}),at=t.extend({init:function(t,e,i){this.initial=t;this.finalPos=e;this.diagram=i;this.title="Pan Unit"},undo:function(){this.diagram.pan(this.initial)},redo:function(){this.diagram.pan(this.finalPos)}}),ht=t.extend({init:function(t,e,i){this.shapes=e;this.undoRotates=i;this.title="Rotation";this.redoRotates=[];this.redoAngle=t._angle;this.adorner=t;this.center=t._innerBounds.center();for(var n=0;n<this.shapes.length;n++){var s=this.shapes[n];this.redoRotates.push(s.rotate().angle)}},undo:function(){var t,e;for(t=0;t<this.shapes.length;t++){e=this.shapes[t];e.rotate(this.undoRotates[t],this.center,false);if(e.hasOwnProperty("layout"))e.layout(e);e.updateModel()}if(this.adorner){this.adorner._initialize();this.adorner.refresh()}},redo:function(){var t,e;for(t=0;t<this.shapes.length;t++){e=this.shapes[t];e.rotate(this.redoRotates[t],this.center,false);if(e.hasOwnProperty("layout"))e.layout(e);e.updateModel()}if(this.adorner){this.adorner._initialize();this.adorner.refresh()}}}),ct=t.extend({init:function(t,e,i){this.diagram=t;this.indices=i;this.items=e;this.title="Rotate Unit"},undo:function(){this.diagram._toIndex(this.items,this.indices)},redo:function(){this.diagram.toFront(this.items,false)}}),lt=t.extend({init:function(t,e,i){this.diagram=t;this.indices=i;this.items=e;this.title="Rotate Unit"},undo:function(){this.diagram._toIndex(this.items,this.indices)},redo:function(){this.diagram.toBack(this.items,false)}}),dt=h.Observable.extend({init:function(t){h.Observable.fn.init.call(this,t);this.bind(this.events,t);this.stack=[];this.index=0;this.capacity=100},events:["undone","redone"],begin:function(){this.composite=new $},cancel:function(){this.composite=o},commit:function(t){if(this.composite.units.length>0)this._restart(this.composite,t);this.composite=o},addCompositeItem:function(t){if(this.composite)this.composite.add(t);else this.add(t)},add:function(t,e){this._restart(t,e)},pop:function(){if(this.index>0){this.stack.pop();this.index--}},count:function(){return this.stack.length},undo:function(){if(this.index>0){this.index--;this.stack[this.index].undo();this.trigger("undone")}},redo:function(){if(this.stack.length>0&&this.index<this.stack.length){this.stack[this.index].redo();this.index++;this.trigger("redone")}},_restart:function(t,e){this.stack.splice(this.index,this.stack.length-this.index);this.stack.push(t);if(e!==false)this.redo();else this.index++;if(this.stack.length>this.capacity){this.stack.splice(0,this.stack.length-this.capacity);this.index=this.capacity}},clear:function(){this.stack=[];this.index=0}}),ut=t.extend({init:function(t){this.toolService=t},start:function(){},move:function(){},end:function(){},tryActivate:function(){return false},getCursor:function(){return n.arrow}}),ft=ut.extend({init:function(t){var e=this;var i=h.support.mobileOS?G:F;ut.fn.init.call(e,t);var n=e.toolService.diagram,s=n.canvas;var r=n.scroller=e.scroller=l(n.scrollable).kendoMobileScroller({friction:i,velocityMultiplier:q,mousewheelScrolling:false,zoom:false,scroll:e._move.bind(e)}).data("kendoMobileScroller");if(s.translate)e.movableCanvas=new g(s.element);var o=function(t,e,i){t.makeVirtual();t.virtualSize(e||V,i||H)};o(r.dimensions.x);o(r.dimensions.y);r.disable()},tryActivate:function(t,e){var i=this.toolService;var n=i.diagram.options.pannable;var s=e.ctrlKey;if(r(n.key))if(!n.key||n.key=="none")s=Et(e)&&!r(i.hoveredItem);else s=e[n.key+"Key"];return n!==false&&s&&!r(i.hoveredAdorner)&&!r(i._hoveredConnector)},start:function(){this.scroller.enable()},move:function(){},_move:function(t){var e=this,i=e.toolService.diagram,n=i.canvas,s=new w(t.scrollLeft,t.scrollTop);if(n.translate){i._storePan(s.times(-1));e.movableCanvas.moveTo(s);n.translate(s.x,s.y)}else s=s.plus(i._pan.times(-1));i.trigger(W,{pan:s})},end:function(){this.scroller.disable()},getCursor:function(){return n.move}}),pt=t.extend({init:function(t){this.toolService=t},tryActivate:function(){return true},start:function(t,e){var i=this.toolService,n=i.diagram,s=i.hoveredItem;if(s){i.selectSingle(s,e);if(s.adorner){this.adorner=s.adorner;this.handle=this.adorner._hitTest(t)}}if(!this.handle){this.handle=n._resizingAdorner._hitTest(t);if(this.handle)this.adorner=n._resizingAdorner}if(this.adorner)if(!this.adorner.isDragHandle(this.handle)||!n.trigger(I,{shapes:this.adorner.shapes,connections:[]}))this.adorner.start(t);else{i.startPoint=t;i.end(t)}},move:function(t){if(this.adorner){this.adorner.move(this.handle,t);if(this.adorner.isDragHandle(this.handle))this.toolService.diagram.trigger(P,{shapes:this.adorner.shapes,connections:[]})}},end:function(){var t=this.toolService.diagram,e=this.adorner,i;if(e)if(!e.isDragHandle(this.handle)||!t.trigger(L,{shapes:e.shapes,connections:[]})){i=e.stop();if(i)t.undoRedoService.add(i,false)}else e.cancel();this.adorner=o;this.handle=o},getCursor:function(t){return this.toolService.hoveredItem?this.toolService.hoveredItem._getCursor(t):n.arrow}}),gt=t.extend({init:function(t){this.toolService=t},tryActivate:function(t,e){var i=this.toolService;var n=i.diagram.options.selectable;var s=n&&n.multiple!==false;if(s)if(n.key&&n.key!="none")s=e[n.key+"Key"];else s=Et(e);return s&&!r(i.hoveredItem)&&!r(i.hoveredAdorner)},start:function(t){var e=this.toolService.diagram;e.deselect();e.selector.start(t)},move:function(t){var e=this.toolService.diagram;e.selector.move(t)},end:function(t,e){var i=this.toolService.diagram,n=this.toolService.hoveredItem;var s=i.selector.bounds();if((!n||!n.isSelected)&&!e.ctrlKey)i.deselect();if(!s.isEmpty())i.selectArea(s);i.selector.end()},getCursor:function(){return n.arrow}}),vt=t.extend({init:function(t){this.toolService=t;this.type="ConnectionTool"},tryActivate:function(){return this.toolService._hoveredConnector},start:function(t,e){var i=this.toolService,n=i.diagram,s=i._hoveredConnector,r=n._createConnection({},s._c,t);if(Pt(r)&&!n.trigger(I,{shapes:[],connections:[r],connectionHandle:j})&&n._addConnection(r)){i._connectionManipulation(r,s._c.shape,true);i._removeHover();i.selectSingle(i.activeConnection,e);if(e.type=="touchmove")n._cachedTouchTarget=s.visual}else{r.source(null);i.end(t)}},move:function(t){var e=this.toolService;var i=e.activeConnection;i.target(t);e.diagram.trigger(P,{shapes:[],connections:[i],connectionHandle:j});return true},end:function(t){var e=this.toolService,i=e.diagram,n=e.activeConnection,s=e.hoveredItem,r=e._hoveredConnector,o,a=i._cachedTouchTarget;if(!n)return;if(r&&r._c!=n.sourceConnector)o=r._c;else if(s&&s instanceof c.Shape)o=s.getConnector(b)||s.getConnector(t);else o=t;n.target(o);if(!i.trigger(L,{shapes:[],connections:[n],connectionHandle:j})){n.updateModel();i._syncConnectionChanges()}else{i.remove(n,false);i.undoRedoService.pop()}e._connectionManipulation();if(a){i._connectorsAdorner.visual.remove(a);i._cachedTouchTarget=null}},getCursor:function(){return n.arrow}}),mt=t.extend({init:function(t){this.toolService=t;this.type="ConnectionTool"},tryActivate:function(t,e){var i=this.toolService,n=i.diagram,s=n.options.selectable,r=i.hoveredItem,o=s!==false&&r&&r.path&&!(r.isSelected&&e.ctrlKey);if(o)this._c=r;return o},start:function(t,e){var i=this.toolService;var n=this._c;i.selectSingle(n,e);var s=n.adorner;var r,o;if(s){r=s._hitTest(t);o=J[r]}if(Pt(n)&&s&&!i.diagram.trigger(I,{shapes:[],connections:[n],connectionHandle:o})){this.handle=r;this.handleName=o;s.start(t)}else{i.startPoint=t;i.end(t)}},move:function(t){var e=this._c.adorner;if(Pt(this._c)&&e){e.move(this.handle,t);this.toolService.diagram.trigger(P,{shapes:[],connections:[this._c],connectionHandle:this.handleName});return true}},end:function(t){var e=this._c;var i=e.adorner;var n=this.toolService;var s=n.diagram;if(i)if(Pt(e)){var r=i.stop(t);if(!s.trigger(L,{shapes:[],connections:[e],connectionHandle:this.handleName})){s.undoRedoService.add(r,false);e.updateModel();s._syncConnectionChanges()}else r.undo()}},getCursor:function(){return n.move}});function s(t,e){return e.charCodeAt(0)==t||e.toUpperCase().charCodeAt(0)==t}var _t=t.extend({init:function(t){this.diagram=t;this.tools=[new ft(this),new mt(this),new vt(this),new gt(this),new pt(this)];this.activeTool=o},start:function(t,e){e=a({},e);if(this.activeTool)this.activeTool.end(t,e);this._updateHoveredItem(t);this._activateTool(t,e);this.activeTool.start(t,e);this._updateCursor(t);this.diagram.focus();this.diagram.canvas.surface.suspendTracking();this.startPoint=t;return true},move:function(t,e){e=a({},e);var i=true;if(this.activeTool)i=this.activeTool.move(t,e);if(i)this._updateHoveredItem(t);this._updateCursor(t);return true},end:function(t,e){e=a({},e);if(this.activeTool)this.activeTool.end(t,e);this.diagram.canvas.surface.resumeTracking();this.activeTool=o;this._updateCursor(t);return true},keyDown:function(t,e){var i=this.diagram;e=a({ctrlKey:false,metaKey:false,altKey:false},e);if((e.ctrlKey||e.metaKey)&&!e.altKey){if(s(t,"a")){i.selectAll();i._destroyToolBar();return true}else if(s(t,"z")){i.undo();i._destroyToolBar();return true}else if(s(t,"y")){i.redo();i._destroyToolBar();return true}else if(s(t,"c")){i.copy();i._destroyToolBar()}else if(s(t,"x")){i.cut();i._destroyToolBar()}else if(s(t,"v")){i.paste();i._destroyToolBar()}else if(s(t,"l")){i.layout();i._destroyToolBar()}else if(s(t,"d")){i._destroyToolBar();i.copy();i.paste()}}else if(t===46||t===8){var n=this.diagram._triggerRemove(i.select());if(n.length){this.diagram.remove(n,true);this.diagram._syncChanges();this.diagram._destroyToolBar()}return true}else if(t===27){this._discardNewConnection();i.deselect();i._destroyToolBar();return true}},wheel:function(t,e){var i=this.diagram,n=e.delta,s=i.zoom(),r=i.options,o=r.zoomRate,a={point:t,meta:e,zoom:s};if(i.trigger(A,a))return;if(n<0)s+=o;else s-=o;s=h.dataviz.round(Math.max(r.zoomMin,Math.min(r.zoomMax,s)),2);a.zoom=s;i.zoom(s,a);i.trigger(U,a);return true},setTool:function(t,e){t.toolService=this;this.tools[e]=t},selectSingle:function(t,e){var i=this.diagram;var n=i.options.selectable;if(n&&!t.isSelected&&t.options.selectable!==false){var s=e.ctrlKey&&n.multiple!==false;i.select(t,{addToSelection:s})}},_discardNewConnection:function(){if(this.newConnection){this.diagram.remove(this.newConnection);this.newConnection=o}},_activateTool:function(t,e){for(var i=0;i<this.tools.length;i++){var n=this.tools[i];if(n.tryActivate(t,e)){this.activeTool=n;break}}},_updateCursor:function(t){var e=this.diagram.element;var i=this.activeTool?this.activeTool.getCursor(t):this.hoveredAdorner?this.hoveredAdorner._getCursor(t):this.hoveredItem?this.hoveredItem._getCursor(t):n.arrow;e.css({cursor:i})},_connectionManipulation:function(t,e,i){this.activeConnection=t;this.disabledShape=e;if(i)this.newConnection=this.activeConnection;else this.newConnection=o},_updateHoveredItem:function(t){var e=this._hitTest(t);var i=this.diagram;if(e!=this.hoveredItem&&(!this.disabledShape||e!=this.disabledShape)){if(this.hoveredItem){i.trigger(O,{item:this.hoveredItem});this.hoveredItem._hover(false)}if(e&&e.options.enable){i.trigger(N,{item:e});this.hoveredItem=e;this.hoveredItem._hover(true)}else this.hoveredItem=o}},_removeHover:function(){if(this.hoveredItem){this.hoveredItem._hover(false);this.hoveredItem=o}},_hitTest:function(t){var e,i=this.diagram,n,s;if(this._hoveredConnector){this._hoveredConnector._hover(false);this._hoveredConnector=o}if(i._connectorsAdorner._visible){e=i._connectorsAdorner._hitTest(t);if(e)return e}e=this.diagram._resizingAdorner._hitTest(t);if(e){this.hoveredAdorner=i._resizingAdorner;if(e.x!==0||e.y!==0)return;e=o}else this.hoveredAdorner=o;if(!this.activeTool||this.activeTool.type!=="ConnectionTool"){var r=[];for(s=0;s<i._selectedItems.length;s++){n=i._selectedItems[s];if(n instanceof c.Connection)r.push(n)}e=this._hitTestItems(r,t)}return e||this._hitTestElements(t)},_hitTestElements:function(t){var e=this.diagram;var i=this._hitTestItems(e.shapes,t);var n=this._hitTestItems(e.connections,t);var s;if((!this.activeTool||this.activeTool.type!="ConnectionTool")&&i&&n&&!Lt(i,t)){var r=e.mainLayer;var o=m(i.visual,r.children);var a=m(n.visual,r.children);s=o>a?i:n}return s||i||n},_hitTestItems:function(t,e){var i,n,s;for(i=t.length-1;i>=0;i--){n=t[i];s=n._hitTest(e);if(s)return s}}}),yt=h.Class.extend({init:function(){}}),wt=yt.extend({init:function(t){var e=this;yt.fn.init.call(e);this.connection=t},hitTest:function(t){var e=this.getBounds().inflate(_);if(!e.contains(t))return false;return c.Geometry.distanceToPolyline(t,this.connection.allPoints())<_},getBounds:function(){var t=this.connection.allPoints(),e=t[0],i=t[t.length-1],n=Math.max(e.x,i.x),s=Math.min(e.x,i.x),r=Math.min(e.y,i.y),o=Math.max(e.y,i.y);for(var a=1;a<t.length-1;++a){n=Math.max(n,t[a].x);s=Math.min(s,t[a].x);r=Math.min(r,t[a].y);o=Math.max(o,t[a].y)}return new y(s,r,n-s,o-r)}}),xt=wt.extend({init:function(t){var e=this;wt.fn.init.call(e);this.connection=t},route:function(){}}),bt=wt.extend({SAME_SIDE_DISTANCE_RATIO:5,init:function(t){var e=this;wt.fn.init.call(e);this.connection=t},routePoints:function(t,e,i,n){var s;if(i&&n)s=this._connectorPoints(t,e,i,n);else s=this._floatingPoints(t,e,i);return s},route:function(){var t=this.connection._resolvedSourceConnector;var e=this.connection._resolvedTargetConnector;var i=this.connection.sourcePoint();var n=this.connection.targetPoint();var s=this.routePoints(i,n,t,e);this.connection.points(s)},_connectorSides:[{name:"Top",axis:"y",boundsPoint:"topLeft",secondarySign:1},{name:"Left",axis:"x",boundsPoint:"topLeft",secondarySign:1},{name:"Bottom",axis:"y",boundsPoint:"bottomRight",secondarySign:-1},{name:"Right",axis:"x",boundsPoint:"bottomRight",secondarySign:-1}],_connectorSide:function(t,e){var i=t.position();var n=t.shape.bounds(X);var l={topLeft:n.topLeft(),bottomRight:n.bottomRight()};var d=this._connectorSides;var s=v.MAX_NUM;var r;var o;var a;var h;for(var c=0;c<d.length;c++){h=d[c];a=h.axis;r=Math.round(Math.abs(i[a]-l[h.boundsPoint][a]));if(r<s){s=r;o=h}else if(r===s&&(i[a]-e[a])*h.secondarySign>(i[o.axis]-e[o.axis])*o.secondarySign)o=h}return o.name},_sameSideDistance:function(t){var e=t.shape.bounds(X);return Math.min(e.width,e.height)/this.SAME_SIDE_DISTANCE_RATIO},_connectorPoints:function(t,e,i,l){var n=this._connectorSide(i,e);var s=this._connectorSide(l,t);var d=e.x-t.x;var r=e.y-t.y;var o=this._sameSideDistance(i);var a=[];var h,c;if(n===C||n==T)if(s==C||s==T)if(n==s){if(n==C)c=Math.min(t.y,e.y)-o;else c=Math.max(t.y,e.y)+o;a=[new w(t.x,c),new w(e.x,c)]}else a=[new w(t.x,t.y+r/2),new w(e.x,t.y+r/2)];else a=[new w(t.x,e.y)];else if(s==k||s==S)if(n==s){if(n==k)h=Math.min(t.x,e.x)-o;else h=Math.max(t.x,e.x)+o;a=[new w(h,t.y),new w(h,e.y)]}else a=[new w(t.x+d/2,t.y),new w(t.x+d/2,t.y+r)];else a=[new w(e.x,t.y)];return a},_floatingPoints:function(t,e,i){var l=i?this._connectorSide(i,e):null;var n=this._startHorizontal(t,e,l);var s=[t,t,e,e];var r=e.x-t.x;var d=e.y-t.y;var o=s.length;var a;var h;for(var c=1;c<o-1;++c){if(n)if(c%2!==0){a=r/(o/2);h=0}else{a=0;h=d/((o-1)/2)}else if(c%2!==0){a=0;h=d/(o/2)}else{a=r/((o-1)/2);h=0}s[c]=new w(s[c-1].x+a,s[c-1].y+h)}c--;if(n&&c%2!==0||!n&&c%2===0)s[o-2]=new w(s[o-1].x,s[o-2].y);else s[o-2]=new w(s[o-2].x,s[o-1].y);return[s[1],s[2]]},_startHorizontal:function(t,e,i){var n;if(i!==null&&(i===S||i===k))n=true;else n=Math.abs(t.x-e.x)>Math.abs(t.y-e.y);return n}}),Ct=t.extend({init:function(t,e){var i=this;i.diagram=t;i.options=a({},i.options,e);i.visual=new d;i.diagram._adorners.push(i)},refresh:function(){}}),St=Ct.extend({init:function(t,e){var i=this,n;i.connection=t;n=i.connection.diagram;i._ts=n.toolService;Ct.fn.init.call(i,n,e);var s=i.connection.sourcePoint();var r=i.connection.targetPoint();i.spVisual=new p(a(i.options.handles,{center:s}));i.epVisual=new p(a(i.options.handles,{center:r}));i.visual.append(i.spVisual);i.visual.append(i.epVisual)},options:{handles:{}},_getCursor:function(){return n.move},start:function(t){this.handle=this._hitTest(t);this.startPoint=t;this._initialSource=this.connection.source();this._initialTarget=this.connection.target();switch(this.handle){case-1:if(this.connection.targetConnector)this._ts._connectionManipulation(this.connection,this.connection.targetConnector.shape);break;case 1:if(this.connection.sourceConnector)this._ts._connectionManipulation(this.connection,this.connection.sourceConnector.shape);break}},move:function(t,e){switch(t){case-1:this.connection.source(e);break;case 1:this.connection.target(e);break;default:var i=e.minus(this.startPoint);this.startPoint=e;if(!this.connection.sourceConnector)this.connection.source(this.connection.sourcePoint().plus(i));if(!this.connection.targetConnector)this.connection.target(this.connection.targetPoint().plus(i));break}this.refresh();return true},stop:function(t){var e=this.diagram.toolService,i=e.hoveredItem,n;if(e._hoveredConnector)n=e._hoveredConnector._c;else if(i&&i instanceof c.Shape)n=i.getConnector(b)||i.getConnector(t);else n=t;if(this.handle===-1)this.connection.source(n);else if(this.handle===1)this.connection.target(n);this.handle=o;this._ts._connectionManipulation();return new et(this.connection,this._initialSource,this._initialTarget)},_hitTest:function(t){var e=this.connection.sourcePoint();var i=this.connection.targetPoint();var n=this.options.handles.width/2+_;var s=this.options.handles.height/2+_;var r=e.distanceTo(t);var o=i.distanceTo(t);var a=new y(e.x,e.y).inflate(n,s).contains(t);var h=new y(i.x,i.y).inflate(n,s).contains(t);var c=0;if(a&&(!h||r<o))c=-1;else if(h&&(!a||o<r))c=1;return c},refresh:function(){this.spVisual.redraw({center:this.diagram.modelToLayer(this.connection.sourcePoint())});this.epVisual.redraw({center:this.diagram.modelToLayer(this.connection.targetPoint())})}}),kt=Ct.extend({init:function(t,e){var i=this;Ct.fn.init.call(i,t,e);i._refreshHandler=function(t){if(t.item==i.shape)i.refresh()}},show:function(t){var e=this,i,n,s;e._visible=true;e.shape=t;e.diagram.bind(z,e._refreshHandler);i=t.connectors.length;e.connectors=[];e._clearVisual();for(n=0;n<i;n++){s=new It(t.connectors[n]);e.connectors.push(s);e.visual.append(s.visual)}e.visual.visible(true);e.refresh()},_clearVisual:function(){var t=this;if(t.diagram._cachedTouchTarget)t._keepCachedTouchTarget();else t.visual.clear()},_keepCachedTouchTarget:function(){var t=this,e=t.visual.children;var i=e.length;var n=m(t.diagram._cachedTouchTarget,e);for(var s=i-1;s>=0;s--){if(s==n)continue;t.visual.remove(e[s])}},destroy:function(){var t=this;t.diagram.unbind(z,t._refreshHandler);t.shape=o;t._visible=o;t.visual.visible(false)},_hitTest:function(t){var e,i;for(i=0;i<this.connectors.length;i++){e=this.connectors[i];if(e._hitTest(t)){e._hover(true);this.diagram.toolService._hoveredConnector=e;break}}},refresh:function(){if(this.shape){var t=this.shape.bounds();t=this.diagram.modelToLayer(t);this.visual.position(t.topLeft());l.each(this.connectors,function(){this.refresh()})}}});function Tt(t,e){var i;if(t.x==-1&&t.y==-1)i=e.bottomRight();else if(t.x==1&&t.y==1)i=e.topLeft();else if(t.x==-1&&t.y==1)i=e.topRight();else if(t.x==1&&t.y==-1)i=e.bottomLeft();else if(t.x===0&&t.y==-1)i=e.bottom();else if(t.x===0&&t.y==1)i=e.top();else if(t.x==1&&t.y===0)i=e.left();else if(t.x==-1&&t.y===0)i=e.right();return i}var Mt=Ct.extend({init:function(t,e){var i=this;Ct.fn.init.call(i,t,e);i._manipulating=false;i.map=[];i.shapes=[];i._initSelection();i._createHandles();i.redraw();i.diagram.bind("select",function(t){i._initialize(t.selected)});i._refreshHandler=function(){if(!i._internalChange){i.refreshBounds();i.refresh()}};i._rotatedHandler=function(){if(i.shapes.length==1)i._angle=i.shapes[0].rotate().angle;i._refreshHandler()};i.diagram.bind(z,i._refreshHandler).bind(E,i._rotatedHandler);i.refreshBounds();i.refresh()},options:{handles:{fill:{color:"#fff"},stroke:{color:"#282828"},height:7,width:7,hover:{fill:{color:"#282828"},stroke:{color:"#282828"}}},selectable:{stroke:{color:"#778899",width:1,dashType:"dash"},fill:{color:K}},offset:10},_initSelection:function(){var t=this;var e=t.diagram;var i=e.options.selectable;var n=a({},t.options.selectable,i);t.rect=new u(n);t.visual.append(t.rect)},_resizable:function(){return this.options.editable&&this.options.editable.resize!==false},_handleOptions:function(){return(this.options.editable.resize||{}).handles||this.options.handles},_createHandles:function(){var t,e,i,n;if(this._resizable()){t=this._handleOptions();for(n=-1;n<=1;n++)for(i=-1;i<=1;i++)if(n!==0||i!==0){e=new u(t);e.drawingElement._hover=this._hover.bind(this);this.map.push({x:n,y:i,visual:e});this.visual.append(e)}}},bounds:function(t){if(t){this._innerBounds=t.clone();this._bounds=this.diagram.modelToLayer(t).inflate(this.options.offset,this.options.offset)}else return this._bounds},_hitTest:function(t){var e=this.diagram.modelToLayer(t),i,n,s,r=this.map.length,o;if(this._angle)e=e.clone().rotate(this._bounds.center(),this._angle);if(this._resizable())for(i=0;i<r;i++){o=this.map[i];n=new w(o.x,o.y);s=this._getHandleBounds(n);s.offset(this._bounds.x,this._bounds.y);if(s.contains(e))return n}if(this._bounds.contains(e))return new w(0,0)},_getHandleBounds:function(t){if(this._resizable()){var e=this._handleOptions(),i=e.width,n=e.height,s=new y(0,0,i,n);if(t.x<0)s.x=-i/2;else if(t.x===0)s.x=Math.floor(this._bounds.width/2)-i/2;else if(t.x>0)s.x=this._bounds.width+1-i/2;if(t.y<0)s.y=-n/2;else if(t.y===0)s.y=Math.floor(this._bounds.height/2)-n/2;else if(t.y>0)s.y=this._bounds.height+1-n/2;return s}},_getCursor:function(t){var e=this._hitTest(t);if(e&&e.x>=-1&&e.x<=1&&e.y>=-1&&e.y<=1&&this._resizable()){var i=this._angle;if(i){i=360-i;e.rotate(new w(0,0),i);e=new w(Math.round(e.x),Math.round(e.y))}if(e.x==-1&&e.y==-1)return"nw-resize";if(e.x==1&&e.y==1)return"se-resize";if(e.x==-1&&e.y==1)return"sw-resize";if(e.x==1&&e.y==-1)return"ne-resize";if(e.x===0&&e.y==-1)return"n-resize";if(e.x===0&&e.y==1)return"s-resize";if(e.x==1&&e.y===0)return"e-resize";if(e.x==-1&&e.y===0)return"w-resize"}return this._manipulating?n.move:n.select},_initialize:function(){var t=this,e,i,n=t.diagram.select();t.shapes=[];for(e=0;e<n.length;e++){i=n[e];if(i instanceof c.Shape){t.shapes.push(i);i._rotationOffset=new w}}t._angle=t.shapes.length==1?t.shapes[0].rotate().angle:0;t._startAngle=t._angle;t._rotates();t._positions();t.refreshBounds();t.refresh();t.redraw()},_rotates:function(){var t=this,e,i;t.initialRotates=[];for(e=0;e<t.shapes.length;e++){i=t.shapes[e];t.initialRotates.push(i.rotate().angle)}},_positions:function(){var t=this,e,i;t.initialStates=[];for(e=0;e<t.shapes.length;e++){i=t.shapes[e];t.initialStates.push(i.bounds())}},_hover:function(t,e){if(this._resizable()){var i=this._handleOptions(),n=i.hover,s=i.stroke,r=i.fill;if(t&&x.isDefined(n.stroke))s=a({},s,n.stroke);if(t&&x.isDefined(n.fill))r=n.fill;e.stroke(s.color,s.width,s.opacity);e.fill(r.color,r.opacity)}},start:function(t){this._sp=t;this._cp=t;this._lp=t;this._manipulating=true;this._internalChange=true;this.shapeStates=[];for(var e=0;e<this.shapes.length;e++){var i=this.shapes[e];this.shapeStates.push(i.bounds())}},redraw:function(){var t,e,i=this._resizable();for(t=0;t<this.map.length;t++){e=this.map[t];e.visual.visible(i)}},angle:function(t){if(r(t))this._angle=t;return this._angle},rotate:function(){var t=this._innerBounds.center();var e=this.angle();this._internalChange=true;for(var i=0;i<this.shapes.length;i++){var n=this.shapes[i];e=(e+this.initialRotates[i]-this._startAngle)%360;n.rotate(e,t)}this.refresh()},move:function(t,e){var i,n,s=new w,r=new w,o,l,a,h,d,c,u=0,f,p,g;if(t.y===-2&&t.x===-1){l=this._innerBounds.center();this._angle=this._truncateAngle(x.findAngle(l,e));for(h=0;h<this.shapes.length;h++){a=this.shapes[h];d=(this._angle+this.initialRotates[h]-this._startAngle)%360;a.rotate(d,l);if(a.hasOwnProperty("layout"))a.layout(a);this._rotating=true}this.refresh()}else{if(this.shouldSnap()){var v=this._truncateDistance(e.minus(this._lp));if(v.x===0&&v.y===0){this._cp=e;return}i=v;this._lp=new w(this._lp.x+v.x,this._lp.y+v.y)}else i=e.minus(this._cp);if(this.isDragHandle(t)){r=s=i;n=true}else{if(this._angle)i.rotate(new w(0,0),this._angle);if(t.x==-1)s.x=i.x;else if(t.x==1)r.x=i.x;if(t.y==-1)s.y=i.y;else if(t.y==1)r.y=i.y}if(!n){f=Tt(t,this._innerBounds);p=(this._innerBounds.width+i.x*t.x)/this._innerBounds.width;g=(this._innerBounds.height+i.y*t.y)/this._innerBounds.height}for(h=0;h<this.shapes.length;h++){a=this.shapes[h];o=a.bounds();if(n){if(!Pt(a))continue;c=this._displaceBounds(o,s,r,n)}else{c=o.clone();c.scale(p,g,f,this._innerBounds.center(),a.rotate().angle);var m=c.center();m.rotate(o.center(),-this._angle);c=new y(m.x-c.width/2,m.y-c.height/2,c.width,c.height)}if(c.width>=a.options.minWidth&&c.height>=a.options.minHeight){var _=o;a.bounds(c);if(a.hasOwnProperty("layout"))a.layout(a,_,c);if(_.width!==c.width||_.height!==c.height)a.rotate(a.rotate().angle);u+=1}}if(u){if(u==h){c=this._displaceBounds(this._innerBounds,s,r,n);this.bounds(c)}else this.refreshBounds();this.refresh()}this._positions()}this._cp=e},isDragHandle:function(t){return t.x===0&&t.y===0},cancel:function(){var t=this.shapes;var e=this.shapeStates;for(var i=0;i<t.length;i++)t[i].bounds(e[i]);this.refreshBounds();this.refresh();this._manipulating=o;this._internalChange=o;this._rotating=o},_truncatePositionToGuides:function(t){if(this.diagram.ruler)return this.diagram.ruler.truncatePositionToGuides(t);return t},_truncateSizeToGuides:function(t){if(this.diagram.ruler)return this.diagram.ruler.truncateSizeToGuides(t);return t},_truncateAngle:function(t){var e=this.snapOptions();var i=Math.max(e.angle||D,R);return e?Math.floor(t%360/i)*i:t%360},_truncateDistance:function(t){if(t instanceof c.Point)return new c.Point(this._truncateDistance(t.x),this._truncateDistance(t.y));else{var e=this.snapOptions()||{};var i=Math.max(e.size||M,B);return e?Math.floor(t/i)*i:t}},snapOptions:function(){var t=this.diagram.options.editable;var e=((t||{}).drag||{}).snap||{};return e},shouldSnap:function(){var t=this.diagram.options.editable;var e=(t||{}).drag;var i=(e||{}).snap;return t!==false&&e!==false&&i!==false},_displaceBounds:function(t,e,i,n){var s=t.topLeft().plus(e),r=t.bottomRight().plus(i),o=y.fromPoints(s,r),a;if(!n){a=o.center();a.rotate(t.center(),-this._angle);o=new y(a.x-o.width/2,a.y-o.height/2,o.width,o.height)}return o},stop:function(){var t,e,i;if(this._cp!=this._sp)if(this._rotating){t=new ht(this,this.shapes,this.initialRotates);this._rotating=false}else if(this._diffStates()){if(this.diagram.ruler)for(e=0;e<this.shapes.length;e++){i=this.shapes[e];var n=i.bounds();n=this._truncateSizeToGuides(this._truncatePositionToGuides(n));i.bounds(n);this.refreshBounds();this.refresh()}for(e=0;e<this.shapes.length;e++){i=this.shapes[e];i.updateModel()}t=new st(this.shapes,this.shapeStates,this);this.diagram._syncShapeChanges()}this._manipulating=o;this._internalChange=o;this._rotating=o;return t},_diffStates:function(){var t=this.shapes;var e=this.shapeStates;for(var i=0;i<t.length;i++)if(!t[i].bounds().equals(e[i]))return true;return false},refreshBounds:function(){var t=this.shapes.length==1?this.shapes[0].bounds().clone():this.diagram.boundingBox(this.shapes,true);this.bounds(t)},refresh:function(){var t=this,e,i;if(this.shapes.length>0){i=this.bounds();this.visual.visible(true);this.visual.position(i.topLeft());l.each(this.map,function(){e=t._getHandleBounds(new w(this.x,this.y));this.visual.position(e.topLeft())});this.visual.position(i.topLeft());var n=new w(i.width/2,i.height/2);this.visual.rotate(this._angle,n);this.rect.redraw({width:i.width,height:i.height});if(this.rotationThumb){var s=this.options.editable.rotate.thumb;this._rotationThumbBounds=new y(i.center().x,i.y+s.y,0,0).inflate(s.width);this.rotationThumb.redraw({x:i.width/2-s.width/2})}}else this.visual.visible(false)}}),Dt=t.extend({init:function(t){var e=t.options.selectable;this.options=a({},this.options,e);this.visual=new u(this.options);this.diagram=t},options:{stroke:{color:"#778899",width:1,dashType:"dash"},fill:{color:K}},start:function(t){this._sp=this._ep=t;this.refresh();this.diagram._adorn(this,true)},end:function(){this._sp=this._ep=o;this.diagram._adorn(this,false)},bounds:function(t){if(t)this._bounds=t;return this._bounds},move:function(t){this._ep=t;this.refresh()},refresh:function(){if(this._sp){var t=y.fromPoints(this.diagram.modelToLayer(this._sp),this.diagram.modelToLayer(this._ep));this.bounds(y.fromPoints(this._sp,this._ep));this.visual.position(t.topLeft());this.visual.redraw({height:t.height+1,width:t.width+1})}}}),It=t.extend({init:function(t){this.options=a({},t.options);this._c=t;this.visual=new p(this.options);this.refresh()},_hover:function(t){var e=this.options,i=e.hover,n=e.stroke,s=e.fill;if(t&&x.isDefined(i.stroke))n=a({},n,i.stroke);if(t&&x.isDefined(i.fill))s=i.fill;this.visual.redraw({stroke:n,fill:s})},refresh:function(){var t=this._c.shape.diagram.modelToView(this._c.position()),e=t.minus(this._c.shape.bounds("transformed").topLeft()),i=new y(t.x,t.y,0,0);i.inflate(this.options.width/2,this.options.height/2);this._visualBounds=i;this.visual.redraw({center:new w(e.x,e.y)})},_hitTest:function(t){var e=this._c.shape.diagram.modelToView(t);return this._visualBounds.contains(e)}});function Pt(t){var e=t.options.editable;return e&&e.drag!==false}function Lt(t,e){var i,n,s;for(var r=0;r<t.connectors.length;r++){i=t.connectors[r];n=i.position();s=new y(n.x,n.y);s.inflate(_,_);if(s.contains(e))return i}}function Et(t){return t.ctrlKey===false&&t.altKey===false&&t.shiftKey===false}a(c,{CompositeUnit:$,TransformUnit:st,PanUndoUnit:at,AddShapeUnit:ot,AddConnectionUnit:rt,DeleteShapeUnit:nt,DeleteConnectionUnit:it,ConnectionEditAdorner:St,ConnectionTool:vt,ConnectorVisual:It,UndoRedoService:dt,ResizingAdorner:Mt,Selector:Dt,ToolService:_t,ConnectorsAdorner:kt,LayoutUndoUnit:Z,ConnectionEditUnit:tt,ToFrontUnit:ct,ToBackUnit:lt,ConnectionRouterBase:yt,PolylineRouter:xt,CascadingRouter:bt,SelectionTool:gt,ScrollerTool:ft,PointerTool:pt,ConnectionEditTool:mt,RotateUnit:ht})})}("function"==typeof define&&define.amd?define:function(t,e,i){(i||e)()}),function(define){define("dataviz/diagram/layout.min",["./math.min"],function(){var t=window.kendo.jQuery,n=void 0,e=window.kendo,l=e.dataviz.diagram,s=l.Graph,w=l.Node,x=l.Link,r=e.deepExtend,u=l.Size,f=l.Rect,D=l.Dictionary,d=l.Set,o=l.Graph,I=l.Utils,v=l.Point,p=1e-6,a=Math.PI/180,g=I.contains,h=t.grep,i=e.Class.extend({defaultOptions:{type:"Tree",subtype:"Down",roots:null,animate:false,limitToView:false,friction:.9,nodeDistance:50,iterations:300,horizontalSeparation:90,verticalSeparation:50,underneathVerticalTopOffset:15,underneathHorizontalOffset:15,underneathVerticalSeparation:15,grid:{width:1500,offsetX:50,offsetY:50,componentSpacingX:20,componentSpacingY:20},layerSeparation:50,layeredIterations:2,startRadialAngle:0,endRadialAngle:360,radialSeparation:150,radialFirstLevelSeparation:200,keepComponentsInOneRadialLayout:false,ignoreContainers:true,layoutContainerChildren:false,ignoreInvisible:true,animateTransitions:false},init:function(){},gridLayoutComponents:function(t){if(!t)throw"No components supplied.";I.forEach(t,function(t){t.calcBounds()});t.sort(function(t,e){return e.bounds.width-t.bounds.width});var l=this.options.grid.width,d=this.options.grid.componentSpacingX,u=this.options.grid.componentSpacingY,e=0,i=this.options.grid.offsetX,f=this.options.grid.offsetY,n=i,s=f,r,o=[],p=[];while(t.length>0){if(n>=l){n=i;s+=e+u;e=0}var a=t.pop();this.moveToOffset(a,new v(n,s));for(r=0;r<a.nodes.length;r++)p.push(a.nodes[r]);for(r=0;r<a.links.length;r++)o.push(a.links[r]);var g=a.bounds;var h=g.height;if(h<=0||isNaN(h))h=0;var c=g.width;if(c<=0||isNaN(c))c=0;if(h>=e)e=h;n+=c+d}return{nodes:p,links:o}},moveToOffset:function(t,e){var i,n,s=t.bounds,r=e.x-s.x,o=e.y-s.y;for(i=0;i<t.nodes.length;i++){var l=t.nodes[i];var a=l.bounds();if(a.width===0&&a.height===0&&a.x===0&&a.y===0)a=new f(0,0,0,0);a.x+=r;a.y+=o;l.bounds(a)}for(i=0;i<t.links.length;i++){var h=t.links[i];if(h.points){var d=[];var u=h.points;for(n=0;n<u.length;n++){var c=u[n];c.x+=r;c.y+=o;d.push(c)}h.points=d}}this.currentHorizontalOffset+=s.width+this.options.grid.offsetX;return new v(r,o)},transferOptions:function(t){this.options=e.deepExtend({},this.defaultOptions);if(I.isUndefined(t))return;this.options=e.deepExtend(this.options,t||{})}}),c=e.Class.extend({init:function(t){this.nodeMap=new D;this.shapeMap=new D;this.nodes=[];this.edges=[];this.edgeMap=new D;this.finalNodes=[];this.finalLinks=[];this.ignoredConnections=[];this.ignoredShapes=[];this.hyperMap=new D;this.hyperTree=new s;this.finalGraph=null;this.diagram=t},convert:function(t){if(I.isUndefined(this.diagram))throw"No diagram to convert.";this.options=e.deepExtend({ignoreInvisible:true,ignoreContainers:true,layoutContainerChildren:false},t||{});this.clear();this._renormalizeShapes();this._renormalizeConnections();this.finalNodes=new D(this.nodes);this.finalLinks=new D(this.edges);this.finalGraph=new s;this.finalNodes.forEach(function(t){this.finalGraph.addNode(t)},this);this.finalLinks.forEach(function(t){this.finalGraph.addExistingLink(t)},this);return this.finalGraph},mapConnection:function(t){return this.edgeMap.get(t.id)},mapShape:function(t){return this.nodeMap.get(t.id)},getEdge:function(e,i){return I.first(e.links,function(t){return t.getComplement(e)===i})},clear:function(){this.finalGraph=null;this.hyperTree=!this.options.ignoreContainers&&this.options.layoutContainerChildren?new o:null;this.hyperMap=!this.options.ignoreContainers&&this.options.layoutContainerChildren?new D:null;this.nodeMap=new D;this.shapeMap=new D;this.nodes=[];this.edges=[];this.edgeMap=new D;this.ignoredConnections=[];this.ignoredShapes=[];this.finalNodes=[];this.finalLinks=[]},listToRoot:function(t){var e=[];var i=t.container;if(!i)return e;e.push(i);while(i.parentContainer){i=i.parentContainer;e.push(i)}e.reverse();return e},firstNonIgnorableContainer:function(t){if(t.isContainer&&!this._isIgnorableItem(t))return t;return!t.parentContainer?null:this.firstNonIgnorableContainer(t.parentContainer)},isContainerConnection:function(t,e){if(t.isContainer&&this.isDescendantOf(t,e))return true;return e.isContainer&&this.isDescendantOf(e,t)},isDescendantOf:function(t,e){if(!t.isContainer)throw"Expecting a container.";if(t===e)return false;if(g(t.children,e))return true;var i=[];for(var n=0,s=t.children.length;n<s;n++){var r=t.children[n];if(r.isContainer&&this.isDescendantOf(r,e))i.push(r)}return i.length>0},isIgnorableItem:function(t){if(this.options.ignoreInvisible){if(t.isCollapsed&&this._isVisible(t))return false;if(!t.isCollapsed&&this._isVisible(t))return false;return true}else return t.isCollapsed&&!this._isTop(t)},isShapeMapped:function(t){return t.isCollapsed&&!this._isVisible(t)&&!this._isTop(t)},leastCommonAncestor:function(t,e){if(!t)throw"Parameter should not be null.";if(!e)throw"Parameter should not be null.";if(!this.hyperTree)throw"No hypertree available.";var i=this.listToRoot(t);var n=this.listToRoot(e);var s=null;if(I.isEmpty(i)||I.isEmpty(n))return this.hyperTree.root.data;var r=i[0];var o=n[0];var a=0;while(r===o){s=i[a];a++;if(a>=i.length||a>=n.length)break;r=i[a];o=n[a]}if(!s)return this.hyperTree.root.data;else return h(this.hyperTree.nodes,function(t){return t.data.container===s})},_isTop:function(t){return!t.parentContainer},_isVisible:function(t){if(!t.visible())return false;return!t.parentContainer?t.visible():this._isVisible(t.parentContainer)},_isCollapsed:function(t){if(t.isContainer&&t.isCollapsed)return true;return t.parentContainer&&this._isCollapsed(t.parentContainer)},_renormalizeShapes:function(){if(this.options.ignoreContainers)for(var t=0,e=this.diagram.shapes.length;t<e;t++){var i=this.diagram.shapes[t];if(this.options.ignoreInvisible&&!this._isVisible(i)||i.isContainer){this.ignoredShapes.push(i);continue}var n=new w(i.id,i);n.isVirtual=false;this.nodeMap.add(i.id,n);this.nodes.push(n)}else throw"Containers are not supported yet, but stay tuned."},_renormalizeConnections:function(){if(this.diagram.connections.length===0)return;for(var t=0,e=this.diagram.connections.length;t<e;t++){var i=this.diagram.connections[t];if(this.isIgnorableItem(i)){this.ignoredConnections.push(i);continue}var n=!i.sourceConnector?null:i.sourceConnector.shape;var s=!i.targetConnector?null:i.targetConnector.shape;if(!n||!s){this.ignoredConnections.push(i);continue}if(g(this.ignoredShapes,n)&&!this.shapeMap.containsKey(n)){this.ignoredConnections.push(i);continue}if(g(this.ignoredShapes,s)&&!this.shapeMap.containsKey(s)){this.ignoredConnections.push(i);continue}if(this.shapeMap.containsKey(n))n=this.shapeMap[n];if(this.shapeMap.containsKey(s))s=this.shapeMap[s];var r=this.mapShape(n);var o=this.mapShape(s);if(r===o||this.areConnectedAlready(r,o)){this.ignoredConnections.push(i);continue}if(r===null||o===null)throw"A shape was not mapped to a node.";if(this.options.ignoreContainers){if(r.isVirtual||o.isVirtual){this.ignoredConnections.push(i);continue}var a=new x(r,o,i.id,i);this.edgeMap.add(i.id,a);this.edges.push(a)}else throw"Containers are not supported yet, but stay tuned."}},areConnectedAlready:function(e,i){return I.any(this.edges,function(t){return t.source===e&&t.target===i||t.source===i&&t.target===e})}}),m=i.extend({init:function(t){var e=this;i.fn.init.call(e);if(I.isUndefined(t))throw"Diagram is not specified.";this.diagram=t},layout:function(t){this.transferOptions(t);var e=new c(this.diagram);var i=e.convert(t);if(i.isEmpty())return;var n=i.getConnectedComponents();if(I.isEmpty(n))return;for(var s=0;s<n.length;s++){var r=n[s];this.layoutGraph(r,t)}var o=this.gridLayoutComponents(n);return new l.LayoutState(this.diagram,o)},layoutGraph:function(t,e){if(I.isDefined(e))this.transferOptions(e);this.graph=t;var i=this.options.nodeDistance*9;this.temperature=i;var n=this._expectedBounds();this.width=n.width;this.height=n.height;for(var s=0;s<this.options.iterations;s++){this.refineStage=s>=this.options.iterations*5/6;this.tick();this.temperature=this.refineStage?i/30:i*(1-s/(2*this.options.iterations))}},tick:function(){var t;for(t=0;t<this.graph.nodes.length;t++)this._repulsion(this.graph.nodes[t]);for(t=0;t<this.graph.links.length;t++)this._attraction(this.graph.links[t]);for(t=0;t<this.graph.nodes.length;t++){var e=this.graph.nodes[t];var i=Math.sqrt(e.dx*e.dx+e.dy*e.dy);if(i===0)return;e.x+=Math.min(i,this.temperature)*e.dx/i;e.y+=Math.min(i,this.temperature)*e.dy/i;if(this.options.limitToView){e.x=Math.min(this.width,Math.max(e.width/2,e.x));e.y=Math.min(this.height,Math.max(e.height/2,e.y))}}},_shake:function(t){var e=Math.random()*this.options.nodeDistance/4;var i=Math.random()*2*Math.PI;t.x+=e*Math.cos(i);t.y-=e*Math.sin(i)},_InverseSquareForce:function(t,e,i){var n;if(!this.refineStage)n=Math.pow(t,2)/Math.pow(this.options.nodeDistance,2);else{var s=e.x-i.x;var r=e.y-i.y;var o=e.width/2;var a=e.height/2;var h=i.width/2;var c=i.height/2;n=Math.pow(s,2)/Math.pow(o+h+this.options.nodeDistance,2)+Math.pow(r,2)/Math.pow(a+c+this.options.nodeDistance,2)}return n*4/3},_SquareForce:function(t,e,i){return 1/this._InverseSquareForce(t,e,i)},_repulsion:function(r){r.dx=0;r.dy=0;I.forEach(this.graph.nodes,function(t){if(t===r)return;while(r.x===t.x&&r.y===t.y)this._shake(t);var e=r.x-t.x;var i=r.y-t.y;var n=Math.sqrt(e*e+i*i);var s=this._SquareForce(n,r,t)*2;r.dx+=e/n*s;r.dy+=i/n*s},this)},_attraction:function(t){var e=t.target;var i=t.source;if(i===e)return;while(i.x===e.x&&i.y===e.y)this._shake(e);var n=i.x-e.x;var s=i.y-e.y;var r=Math.sqrt(n*n+s*s);var o=this._InverseSquareForce(r,i,e)*5;var a=n/r*o;var h=s/r*o;e.dx+=a;e.dy+=h;i.dx-=a;i.dy-=h},_expectedBounds:function(){var t,e=this.graph.nodes.length,i=1.5,n=4;if(e===0)return t;t=I.fold(this.graph.nodes,function(t,e){var i=e.width*e.height;if(i>0){t+=Math.sqrt(i);return t}return 0},0,this);var s=t/e;var r=s*Math.ceil(Math.sqrt(e));var o=r*Math.sqrt(i);var a=r/Math.sqrt(i);return{width:o*n,height:a*n}}}),_=e.Class.extend({init:function(t){this.center=null;this.options=t},layout:function(t,e){this.graph=t;if(!this.graph.nodes||this.graph.nodes.length===0)return;if(!g(this.graph.nodes,e))throw"The given root is not in the graph.";this.center=e;this.graph.cacheRelationships();this.layoutSwitch()},layoutLeft:function(t){this.setChildrenDirection(this.center,"Left",false);this.setChildrenLayout(this.center,"Default",false);var e=0,i=0,n,s,r;for(s=0;s<t.length;s++){r=t[s];r.TreeDirection="Left";var o=this.measure(r,u.Empty);i=Math.max(i,o.Width);e+=o.height+this.options.verticalSeparation}e-=this.options.verticalSeparation;var a=this.center.x-this.options.horizontalSeparation;n=this.center.y+(this.center.height-e)/2;for(s=0;s<t.length;s++){r=t[s];var h=new v(a-r.Size.width,n);this.arrange(r,h);n+=r.Size.height+this.options.verticalSeparation}},layoutRight:function(t){this.setChildrenDirection(this.center,"Right",false);this.setChildrenLayout(this.center,"Default",false);var e=0,i=0,n,s,r;for(s=0;s<t.length;s++){r=t[s];r.TreeDirection="Right";var o=this.measure(r,u.Empty);i=Math.max(i,o.Width);e+=o.height+this.options.verticalSeparation}e-=this.options.verticalSeparation;var a=this.center.x+this.options.horizontalSeparation+this.center.width;n=this.center.y+(this.center.height-e)/2;for(s=0;s<t.length;s++){r=t[s];var h=new v(a,n);this.arrange(r,h);n+=r.Size.height+this.options.verticalSeparation}},layoutUp:function(t){this.setChildrenDirection(this.center,"Up",false);this.setChildrenLayout(this.center,"Default",false);var e=0,i,n,s;for(s=0;s<t.length;s++){n=t[s];n.TreeDirection="Up";var r=this.measure(n,u.Empty);e+=r.width+this.options.horizontalSeparation}e-=this.options.horizontalSeparation;var o=this.center.x+this.center.width/2-e/2;for(s=0;s<t.length;s++){n=t[s];i=this.center.y-this.options.verticalSeparation-n.Size.height;var a=new v(o,i);this.arrange(n,a);o+=n.Size.width+this.options.horizontalSeparation}},layoutDown:function(t){var e,i;this.setChildrenDirection(this.center,"Down",false);this.setChildrenLayout(this.center,"Default",false);var n=0,s;for(i=0;i<t.length;i++){e=t[i];e.treeDirection="Down";var r=this.measure(e,u.Empty);n+=r.width+this.options.horizontalSeparation}n-=this.options.horizontalSeparation;var o=this.center.x+this.center.width/2-n/2;s=this.center.y+this.options.verticalSeparation+this.center.height;for(i=0;i<t.length;i++){e=t[i];var a=new v(o,s);this.arrange(e,a);o+=e.Size.width+this.options.horizontalSeparation}},layoutRadialTree:function(){this.setChildrenDirection(this.center,"Radial",false);this.setChildrenLayout(this.center,"Default",false);this.previousRoot=null;var t=this.options.startRadialAngle*a;var e=this.options.endRadialAngle*a;if(e<=t)throw"Final angle should not be less than the start angle.";this.maxDepth=0;this.origin=new v(this.center.x,this.center.y);this.calculateAngularWidth(this.center,0);if(this.maxDepth>0)this.radialLayout(this.center,this.options.radialFirstLevelSeparation,t,e);this.center.Angle=e-t},tipOverTree:function(t,e){if(I.isUndefined(e))e=0;this.setChildrenDirection(this.center,"Down",false);this.setChildrenLayout(this.center,"Default",false);this.setChildrenLayout(this.center,"Underneath",false,e);var i=0,n,s,r;for(r=0;r<t.length;r++){s=t[r];s.TreeDirection="Down";var o=this.measure(s,u.Empty);i+=o.width+this.options.horizontalSeparation}i-=this.options.horizontalSeparation;i-=t[t.length-1].width;i+=t[t.length-1].associatedShape.bounds().width;var a=this.center.x+this.center.width/2-i/2;n=this.center.y+this.options.verticalSeparation+this.center.height;for(r=0;r<t.length;r++){s=t[r];var h=new v(a,n);this.arrange(s,h);a+=s.Size.width+this.options.horizontalSeparation}},calculateAngularWidth:function(t,e){if(e>this.maxDepth)this.maxDepth=e;var i=0,n=1e3,s=1e3,r=e===0?0:Math.sqrt(n*n+s*s)/e;if(t.children.length>0){for(var o=0,a=t.children.length;o<a;o++){var h=t.children[o];i+=this.calculateAngularWidth(h,e+1)}i=Math.max(r,i)}else i=r;t.sectorAngle=i;return i},sortChildren:function(t){var e=0,i;if(t.parents.length>1)throw"Node is not part of a tree.";var n=t.parents[0];if(n){var s=new v(n.x,n.y);var r=new v(t.x,t.y);e=this.normalizeAngle(Math.atan2(s.y-r.y,s.x-r.x))}var o=t.children.length;if(o===0)return null;var a=[];var h=[];for(i=0;i<o;++i){var l=t.children[i];var c=new v(l.x,l.y);h[i]=i;a[i]=this.normalizeAngle(-e+Math.atan2(c.y-c.y,c.x-c.x))}I.bisort(a,h);var d=[];var u=t.children;for(i=0;i<o;++i)d.push(u[h[i]]);return d},normalizeAngle:function(t){while(t>Math.PI*2)t-=2*Math.PI;while(t<0)t+=Math.PI*2;return t},radialLayout:function(t,e,i,l){var n=l-i;var d=n/2;var u=t.sectorAngle;var s=0;var r=this.sortChildren(t);for(var o=0,f=r.length;o<f;o++){var a=r[o];var h=a;var c=h.sectorAngle/u;if(a.children.length>0)this.radialLayout(a,e+this.options.radialSeparation,i+s*n,i+(s+c)*n);this.setPolarLocation(a,e,i+s*n+c*d);h.angle=c*n;s+=c}},setPolarLocation:function(t,e,i){t.x=this.origin.x+e*Math.cos(i);t.y=this.origin.y+e*Math.sin(i);t.BoundingRectangle=new f(t.x,t.y,t.width,t.height)},setChildrenDirection:function(t,e,i){var n=t.treeDirection;this.graph.depthFirstTraversal(t,function(t){t.treeDirection=e});if(!i)t.treeDirection=n},setChildrenLayout:function(t,e,i,n){if(I.isUndefined(n))n=0;var s=t.childrenLayout;if(n>0){this.graph.assignLevels(t);this.graph.depthFirstTraversal(t,function(t){if(t.level>=n+1)t.childrenLayout=e})}else{this.graph.depthFirstTraversal(t,function(t){t.childrenLayout=e});if(!i)t.childrenLayout=s}},measure:function(t,e){var i=0,n=0,s;var r=new u(0,0);if(!t)throw"";var l=t.associatedShape.bounds();var o=l.width;var a=l.height;if(t.parents.length!==1)throw"Node not in a spanning tree.";var d=t.parents[0];if(t.treeDirection==="Undefined")t.treeDirection=d.treeDirection;if(I.isEmpty(t.children))r=new u(Math.abs(o)<p?50:o,Math.abs(a)<p?25:a);else if(t.children.length===1){switch(t.treeDirection){case"Radial":s=this.measure(t.children[0],e);i=o+this.options.radialSeparation*Math.cos(t.AngleToParent)+s.width;n=a+Math.abs(this.options.radialSeparation*Math.sin(t.AngleToParent))+s.height;break;case"Left":case"Right":switch(t.childrenLayout){case"TopAlignedWithParent":break;case"BottomAlignedWithParent":break;case"Underneath":s=this.measure(t.children[0],e);i=o+s.width+this.options.underneathHorizontalOffset;n=a+this.options.underneathVerticalTopOffset+s.height;break;case"Default":s=this.measure(t.children[0],e);i=o+this.options.horizontalSeparation+s.width;n=Math.max(a,s.height);break;default:throw"Unhandled TreeDirection in the Radial layout measuring."}break;case"Up":case"Down":switch(t.childrenLayout){case"TopAlignedWithParent":case"BottomAlignedWithParent":break;case"Underneath":s=this.measure(t.children[0],e);i=Math.max(o,s.width+this.options.underneathHorizontalOffset);n=a+this.options.underneathVerticalTopOffset+s.height;break;case"Default":s=this.measure(t.children[0],e);n=a+this.options.verticalSeparation+s.height;i=Math.max(o,s.width);break;default:throw"Unhandled TreeDirection in the Down layout measuring."}break;default:throw"Unhandled TreeDirection in the layout measuring."}r=new u(i,n)}else{var h,c;switch(t.treeDirection){case"Left":case"Right":switch(t.childrenLayout){case"TopAlignedWithParent":case"BottomAlignedWithParent":break;case"Underneath":i=o;n=a+this.options.underneathVerticalTopOffset;for(h=0;h<t.children.length;h++){c=t.children[h];s=this.measure(c,e);i=Math.max(i,s.width+this.options.underneathHorizontalOffset);n+=s.height+this.options.underneathVerticalSeparation}n-=this.options.underneathVerticalSeparation;break;case"Default":i=o;n=0;for(h=0;h<t.children.length;h++){c=t.children[h];s=this.measure(c,e);i=Math.max(i,o+this.options.horizontalSeparation+s.width);n+=s.height+this.options.verticalSeparation}n-=this.options.verticalSeparation;break;default:throw"Unhandled TreeDirection in the Right layout measuring."}break;case"Up":case"Down":switch(t.childrenLayout){case"TopAlignedWithParent":case"BottomAlignedWithParent":break;case"Underneath":i=o;n=a+this.options.underneathVerticalTopOffset;for(h=0;h<t.children.length;h++){c=t.children[h];s=this.measure(c,e);i=Math.max(i,s.width+this.options.underneathHorizontalOffset);n+=s.height+this.options.underneathVerticalSeparation}n-=this.options.underneathVerticalSeparation;break;case"Default":i=0;n=0;for(h=0;h<t.children.length;h++){c=t.children[h];s=this.measure(c,e);i+=s.width+this.options.horizontalSeparation;n=Math.max(n,s.height+this.options.verticalSeparation+a)}i-=this.options.horizontalSeparation;break;default:throw"Unhandled TreeDirection in the Down layout measuring."}break;default:throw"Unhandled TreeDirection in the layout measuring."}r=new u(i,n)}t.SectorAngle=Math.sqrt(i*i/4+n*n/4);t.Size=r;return r},arrange:function(t,e){var i,n,l,s,r,d=t.associatedShape.bounds();var o=d.width;var u=d.height;if(I.isEmpty(t.children)){t.x=e.x;t.y=e.y;t.BoundingRectangle=new f(e.x,e.y,o,u)}else{var a,h;var c;switch(t.treeDirection){case"Left":switch(t.childrenLayout){case"TopAlignedWithParent":case"BottomAlignedWithParent":break;case"Underneath":c=e;t.x=c.x;t.y=c.y;t.BoundingRectangle=new f(t.x,t.y,t.width,t.height);h=e.y+u+this.options.underneathVerticalTopOffset;for(i=0;i<s.children.length;i++){s=s.children[i];a=c.x-s.associatedShape.width-this.options.underneathHorizontalOffset;n=new v(a,h);this.arrange(s,n);h+=s.Size.height+this.options.underneathVerticalSeparation}break;case"Default":c=new v(e.x+t.Size.width-o,e.y+(t.Size.height-u)/2);t.x=c.x;t.y=c.y;t.BoundingRectangle=new f(t.x,t.y,t.width,t.height);a=c.x-this.options.horizontalSeparation;h=e.y;for(i=0;i<t.children.length;i++){s=t.children[i];n=new v(a-s.Size.width,h);this.arrange(s,n);h+=s.Size.height+this.options.verticalSeparation}break;default:throw"Unsupported TreeDirection"}break;case"Right":switch(t.childrenLayout){case"TopAlignedWithParent":case"BottomAlignedWithParent":break;case"Underneath":c=e;t.x=c.x;t.y=c.y;t.BoundingRectangle=new f(t.x,t.y,t.width,t.height);a=e.x+o+this.options.underneathHorizontalOffset;h=e.y+u+this.options.underneathVerticalTopOffset;for(i=0;i<t.children.length;i++){s=t.children[i];n=new v(a,h);this.arrange(s,n);h+=s.Size.height+this.options.underneathVerticalSeparation}break;case"Default":c=new v(e.x,e.y+(t.Size.height-u)/2);t.x=c.x;t.y=c.y;t.BoundingRectangle=new f(t.x,t.y,t.width,t.height);a=e.x+o+this.options.horizontalSeparation;h=e.y;for(i=0;i<t.children.length;i++){s=t.children[i];n=new v(a,h);this.arrange(s,n);h+=s.Size.height+this.options.verticalSeparation}break;default:throw"Unsupported TreeDirection"}break;case"Up":c=new v(e.x+(t.Size.width-o)/2,e.y+t.Size.height-u);t.x=c.x;t.y=c.y;t.BoundingRectangle=new f(t.x,t.y,t.width,t.height);if(Math.abs(c.x-e.x)<p){r=0;for(i=0;i<t.children.length;i++){l=t.children[i];r+=l.Size.width+this.options.horizontalSeparation}r-=this.options.horizontalSeparation;a=e.x+(o-r)/2}else a=e.x;for(i=0;i<t.children.length;i++){s=t.children[i];h=c.y-this.options.verticalSeparation-s.Size.height;n=new v(a,h);this.arrange(s,n);a+=s.Size.width+this.options.horizontalSeparation}break;case"Down":switch(t.childrenLayout){case"TopAlignedWithParent":case"BottomAlignedWithParent":break;case"Underneath":c=e;t.x=c.x;t.y=c.y;t.BoundingRectangle=new f(t.x,t.y,t.width,t.height);a=e.x+this.options.underneathHorizontalOffset;h=e.y+u+this.options.underneathVerticalTopOffset;for(i=0;i<t.children.length;i++){s=t.children[i];n=new v(a,h);this.arrange(s,n);h+=s.Size.height+this.options.underneathVerticalSeparation}break;case"Default":c=new v(e.x+(t.Size.width-o)/2,e.y);t.x=c.x;t.y=c.y;t.BoundingRectangle=new f(t.x,t.y,t.width,t.height);if(Math.abs(c.x-e.x)<p){r=0;for(i=0;i<t.children.length;i++){l=t.children[i];r+=l.Size.width+this.options.horizontalSeparation}r-=this.options.horizontalSeparation;a=e.x+(o-r)/2}else a=e.x;for(i=0;i<t.children.length;i++){s=t.children[i];h=c.y+this.options.verticalSeparation+u;n=new v(a,h);this.arrange(s,n);a+=s.Size.width+this.options.horizontalSeparation}break;default:throw"Unsupported TreeDirection"}break;case"None":break;default:throw"Unsupported TreeDirection"}}},layoutSwitch:function(){if(!this.center)return;if(I.isEmpty(this.center.children))return;var t=this.options.subtype;if(I.isUndefined(t))t="Down";var e,i,n,s;var r=this.center.children;switch(t.toLowerCase()){case"radial":case"radialtree":this.layoutRadialTree();break;case"mindmaphorizontal":case"mindmap":e=this.center.children;if(this.center.children.length===1)this.layoutRight(e);else{s=r.length/2;i=h(this.center.children,function(t){return I.indexOf(r,t)<s});n=h(this.center.children,function(t){return I.indexOf(r,t)>=s});this.layoutLeft(i);this.layoutRight(n)}break;case"mindmapvertical":e=this.center.children;if(this.center.children.length===1)this.layoutDown(e);else{s=r.length/2;i=h(this.center.children,function(t){return I.indexOf(r,t)<s});n=h(this.center.children,function(t){return I.indexOf(r,t)>=s});this.layoutUp(i);this.layoutDown(n)}break;case"right":this.layoutRight(this.center.children);break;case"left":this.layoutLeft(this.center.children);break;case"up":case"bottom":this.layoutUp(this.center.children);break;case"down":case"top":this.layoutDown(this.center.children);break;case"tipover":case"tipovertree":if(this.options.tipOverTreeStartLevel<0)throw"The tip-over level should be a positive integer.";this.tipOverTree(this.center.children,this.options.tipOverTreeStartLevel);break;case"undefined":case"none":break}}}),y=i.extend({init:function(t){var e=this;i.fn.init.call(e);if(I.isUndefined(t))throw"No diagram specified.";this.diagram=t},layout:function(t){this.transferOptions(t);var e=new c(this.diagram);this.graph=e.convert();var i=this.layoutComponents();return new l.LayoutState(this.diagram,i)},layoutComponents:function(){if(this.graph.isEmpty())return;var t=this.graph.getConnectedComponents();if(I.isEmpty(t))return;var e=new _(this.options);var i=[];for(var n=0;n<t.length;n++){var s=t[n];var r=this.getTree(s);if(!r)throw"Failed to find a spanning tree for the component.";var o=r.root;var a=r.tree;e.layout(a,o);i.push(a)}return this.gridLayoutComponents(i)},getTree:function(t){var e=null;if(this.options.roots&&this.options.roots.length>0)for(var i=0,n=t.nodes.length;i<n;i++){var s=t.nodes[i];for(var r=0;r<this.options.roots.length;r++){var o=this.options.roots[r];if(o===s.associatedShape){e=s;break}}}if(!e){e=t.root();if(!e)throw"Unable to find a root for the tree."}return this.getTreeForRoot(t,e)},getTreeForRoot:function(t,e){var i=t.getSpanningTree(e);if(I.isUndefined(i)||i.isEmpty())return null;return{tree:i,root:i.root}}}),b=i.extend({init:function(t){var e=this;i.fn.init.call(e);if(I.isUndefined(t))throw"Diagram is not specified.";this.diagram=t},layout:function(t){this.transferOptions(t);var e=new c(this.diagram);var i=e.convert(t);if(i.isEmpty())return;var n=i.getConnectedComponents();if(I.isEmpty(n))return;for(var s=0;s<n.length;s++){var r=n[s];this.layoutGraph(r,t)}var o=this.gridLayoutComponents(n);return new l.LayoutState(this.diagram,o)},_initRuntimeProperties:function(){for(var t=0;t<this.graph.nodes.length;t++){var e=this.graph.nodes[t];e.layer=-1;e.downstreamLinkCount=0;e.upstreamLinkCount=0;e.isVirtual=false;e.uBaryCenter=0;e.dBaryCenter=0;e.upstreamPriority=0;e.downstreamPriority=0;e.gridPosition=0}},_prepare:function(l){var e=[],t,i,n;var s=new D;var d=0;var r,o,a;I.forEach(l.nodes,function(t){if(t.incoming.length===0){s.set(t,0);e.push(t)}});while(e.length>0){o=e.shift();for(t=0;t<o.outgoing.length;t++){n=o.outgoing[t];a=n.target;if(s.containsKey(a))r=Math.max(s.get(o)+1,s.get(a));else r=s.get(o)+1;s.set(a,r);if(r>d)d=r;if(!g(e,a))e.push(a)}}var u=s.keys();u.sort(function(t,e){var i=s.get(t);var n=s.get(e);return I.sign(n-i)});for(var f=0;f<u.length;++f){var h=u[f];var p=Number.MAX_VALUE;if(h.outgoing.length===0)continue;for(i=0;i<h.outgoing.length;++i){n=h.outgoing[i];p=Math.min(p,s.get(n.target))}if(p>1)s.set(h,p-1)}this.layers=[];var c;for(t=0;t<d+1;t++){c=[];c.linksTo={};this.layers.push(c)}s.forEach(function(t,e){t.layer=e;this.layers[e].push(t)},this);for(i=0;i<this.layers.length;i++){c=this.layers[i];for(t=0;t<c.length;t++)c[t].gridPosition=t}},layoutGraph:function(t,e){if(I.isUndefined(t))throw"No graph given or graph analysis of the diagram failed.";if(I.isDefined(e))this.transferOptions(e);this.graph=t;t.setItemIndices();var i=t.makeAcyclic();this._initRuntimeProperties();this._prepare(t,e);this._dummify();this._optimizeCrossings();this._swapPairs();this.arrangeNodes();this._moveThingsAround();this._dedummify();I.forEach(i,function(t){if(t.points)t.points.reverse()})},setMinDist:function(t,e,i){var n=t.layer;var s=t.layerIndex;this.minDistances[n][s]=i},getMinDist:function(t,e){var i=0,n=t.layerIndex,s=e.layerIndex,r=t.layer,o=Math.min(n,s),a=Math.max(n,s);for(var h=o;h<a;++h)i+=this.minDistances[r][h];return i},placeLeftToRight:function(l){var t=new D,e,i;for(var n=0;n<this.layers.length;++n){var s=l[n];if(!s)continue;for(e=0;e<s.length;e++){i=s[e];if(!t.containsKey(i))this.placeLeft(i,t,n)}var r=Number.POSITIVE_INFINITY;for(e=0;e<s.length;e++){i=s[e];var o=this.rightSibling(i);if(o&&this.nodeLeftClass.get(o)!==n)r=Math.min(r,t.get(o)-t.get(i)-this.getMinDist(i,o))}if(r===Number.POSITIVE_INFINITY){var a=[];for(e=0;e<s.length;e++){i=s[e];var h=[];I.addRange(h,this.upNodes.get(i));I.addRange(h,this.downNodes.get(i));for(var c=0;c<h.length;c++){var d=h[c];if(this.nodeLeftClass.get(d)<n)a.push(t.get(d)-t.get(i))}}a.sort();if(a.length===0)r=0;else if(a.length%2===1)r=a[this.intDiv(a.length,2)];else r=(a[this.intDiv(a.length,2)-1]+a[this.intDiv(a.length,2)])/2}for(e=0;e<s.length;e++){i=s[e];t.set(i,t.get(i)+r)}}return t},placeRightToLeft:function(l){var t=new D,e,i;for(var n=0;n<this.layers.length;++n){var s=l[n];if(!s)continue;for(e=0;e<s.length;e++){i=s[e];if(!t.containsKey(i))this.placeRight(i,t,n)}var r=Number.NEGATIVE_INFINITY;for(e=0;e<s.length;e++){i=s[e];var o=this.leftSibling(i);if(o&&this.nodeRightClass.get(o)!==n)r=Math.max(r,t.get(o)-t.get(i)+this.getMinDist(o,i))}if(r===Number.NEGATIVE_INFINITY){var a=[];for(e=0;e<s.length;e++){i=s[e];var h=[];I.addRange(h,this.upNodes.get(i));I.addRange(h,this.downNodes.get(i));for(var c=0;c<h.length;c++){var d=h[c];if(this.nodeRightClass.get(d)<n)a.push(t.get(i)-t.get(d))}}a.sort();if(a.length===0)r=0;else if(a.length%2===1)r=a[this.intDiv(a.length,2)];else r=(a[this.intDiv(a.length,2)-1]+a[this.intDiv(a.length,2)])/2}for(e=0;e<s.length;e++){i=s[e];t.set(i,t.get(i)+r)}}return t},_getLeftWing:function(){var t={value:null};var e=this.computeClasses(t,1);this.nodeLeftClass=t.value;return e},_getRightWing:function(){var t={value:null};var e=this.computeClasses(t,-1);this.nodeRightClass=t.value;return e},computeClasses:function(l,t){var e=0,i=l.value=new D;for(var n=0;n<this.layers.length;++n){e=n;var s=this.layers[n];for(var r=t===1?0:s.length-1;r>=0&&r<s.length;r+=t){var o=s[r];if(!i.containsKey(o)){i.set(o,e);if(o.isVirtual){var a=this._nodesInLink(o);for(var h=0;h<a.length;h++){var d=a[h];i.set(d,e)}}}else e=i.get(o)}}var c=[];for(var u=0;u<this.layers.length;u++)c.push(null);i.forEach(function(t,e){if(c[e]===null)c[e]=[];c[e].push(t)});return c},_isVerticalLayout:function(){return this.options.subtype.toLowerCase()==="up"||this.options.subtype.toLowerCase()==="down"||this.options.subtype.toLowerCase()==="vertical"},_isHorizontalLayout:function(){return this.options.subtype.toLowerCase()==="right"||this.options.subtype.toLowerCase()==="left"||this.options.subtype.toLowerCase()==="horizontal"},_isIncreasingLayout:function(){return this.options.subtype.toLowerCase()==="right"||this.options.subtype.toLowerCase()==="down"},_moveThingsAround:function(){var c,t,e,i,n,s;for(t=0;t<this.layers.length;++t){i=this.layers[t];i.sort(this._gridPositionComparer)}this.minDistances=[];for(t=0;t<this.layers.length;++t){i=this.layers[t];this.minDistances[t]=[];for(n=0;n<i.length;++n){e=i[n];e.layerIndex=n;this.minDistances[t][n]=this.options.nodeDistance;if(n<i.length-1)if(this._isVerticalLayout())this.minDistances[t][n]+=(e.width+i[n+1].width)/2;else this.minDistances[t][n]+=(e.height+i[n+1].height)/2}}this.downNodes=new D;this.upNodes=new D;I.forEach(this.graph.nodes,function(t){this.downNodes.set(t,[]);this.upNodes.set(t,[])},this);I.forEach(this.graph.links,function(t){var e=t.source;var i=t.target;var n=null,s=null;if(e.layer>i.layer){n=t.source;s=t.target}else{s=t.source;n=t.target}this.downNodes.get(s).push(n);this.upNodes.get(n).push(s)},this);this.downNodes.forEachValue(function(t){t.sort(this._gridPositionComparer)},this);this.upNodes.forEachValue(function(t){t.sort(this._gridPositionComparer)},this);for(t=0;t<this.layers.length-1;++t){i=this.layers[t];for(s=0;s<i.length-1;s++){var h=i[s];if(!h.isVirtual)continue;var r=this.downNodes.get(h)[0];if(!r.isVirtual)continue;for(n=s+1;n<i.length;++n){e=i[n];if(!e.isVirtual)continue;var o=this.downNodes.get(e)[0];if(!o.isVirtual)continue;if(r.gridPosition>o.gridPosition){var d=r.gridPosition;r.gridPosition=o.gridPosition;o.gridPosition=d;var u=r.layerIndex;var f=o.layerIndex;this.layers[t+1][u]=o;this.layers[t+1][f]=r;r.layerIndex=f;o.layerIndex=u}}}}var p=this._getLeftWing();var g=this._getRightWing();var v=this.placeLeftToRight(p);var m=this.placeRightToLeft(g);var l=new D;I.forEach(this.graph.nodes,function(t){l.set(t,(v.get(t)+m.get(t))/2)});var _=new D;var y=new D;for(t=0;t<this.layers.length;++t){i=this.layers[t];var a=-1,w=-1;for(n=0;n<i.length;++n){e=i[n];_.set(e,0);y.set(e,false);if(e.isVirtual)if(a===-1)a=n;else if(a===n-1)a=n;else{w=n;_.set(i[a],0);if(l.get(e)-l.get(i[a])===this.getMinDist(i[a],e))y.set(i[a],true);else y.set(i[a],false);a=n}}}var x=[1,-1];I.forEach(x,function(t){var e=t===1?0:this.layers.length-1;for(var i=e;i>=0&&i<this.layers.length;i+=t){var n=this.layers[i];var s=this._firstVirtualNode(n);var r=null;var o=null;if(s!==-1){r=n[s];o=[];for(c=0;c<s;c++)o.push(n[c])}else{r=null;o=n}if(o.length>0){this._sequencer(l,null,r,t,o);for(c=0;c<o.length-1;++c)this.setMinDist(o[c],o[c+1],l.get(o[c+1])-l.get(o[c]));if(r)this.setMinDist(o[o.length-1],r,l.get(r)-l.get(o[o.length-1]))}while(r){var a=this.nextVirtualNode(n,r);if(!a){s=r.layerIndex;o=[];for(c=s+1;c<n.length;c++)o.push(n[c]);if(o.length>0){this._sequencer(l,r,null,t,o);for(c=0;c<o.length-1;++c)this.setMinDist(o[c],o[c+1],l.get(o[c+1])-l.get(o[c]));this.setMinDist(r,o[0],l.get(o[0])-l.get(r))}}else if(_.get(r)===t){s=r.layerIndex;var h=a.layerIndex;o=[];for(c=s+1;c<h;c++)o.push(n[c]);if(o.length>0)this._sequencer(l,r,a,t,o);y.set(r,true)}r=a}this.adjustDirections(i,t,_,y)}},this);var b=this._isIncreasingLayout()?0:this.layers.length-1;var C=function(t,e){if(e._isIncreasingLayout())return t<e.layers.length;else return t>=0};var S=this._isIncreasingLayout()?+1:-1,k=0;function T(t,e){var i=Number.MIN_VALUE;for(var n=0;n<t.length;++n){var s=t[n];if(e._isVerticalLayout())i=Math.max(i,s.height);else i=Math.max(i,s.width)}return i}for(c=b;C(c,this);c+=S){i=this.layers[c];var M=T(i,this);for(n=0;n<i.length;++n){e=i[n];if(this._isVerticalLayout()){e.x=l.get(e);e.y=k+M/2}else{e.x=k+M/2;e.y=l.get(e)}}k+=this.options.layerSeparation+M}},adjustDirections:function(t,e,l,d){if(t+e<0||t+e>=this.layers.length)return;var i=null,n=null;var s=this.layers[t+e];for(var r=0;r<s.length;++r){var o=s[r];if(o.isVirtual){var a=this.getNeighborOnLayer(o,t);if(a.isVirtual){if(i){var u=d.get(n);var f=this.layers[t];var p=n.layerIndex;var g=a.layerIndex;for(var h=p+1;h<g;++h)if(f[h].isVirtual)u=u&&d.get(f[h]);if(u){l.set(i,e);var v=i.layerIndex;var m=o.layerIndex;for(var c=v+1;c<m;++c)if(s[c].isVirtual)l.set(s[c],e)}}i=o;n=a}}}},getNeighborOnLayer:function(t,e){var i=this.upNodes.get(t)[0];if(i.layer===e)return i;i=this.downNodes.get(t)[0];if(i.layer===e)return i;return null},_sequencer:function(t,e,i,n,s){if(s.length===1)this._sequenceSingle(t,e,i,n,s[0]);if(s.length>1){var r=s.length,o=this.intDiv(r,2);this._sequencer(t,e,i,n,s.slice(0,o));this._sequencer(t,e,i,n,s.slice(o));this.combineSequences(t,e,i,n,s)}},_sequenceSingle:function(t,e,i,n,s){var r=n===-1?this.downNodes.get(s):this.upNodes.get(s);var o=r.length;if(o!==0){if(o%2===1)t.set(s,t.get(r[this.intDiv(o,2)]));else t.set(s,(t.get(r[this.intDiv(o,2)-1])+t.get(r[this.intDiv(o,2)]))/2);if(e)t.set(s,Math.max(t.get(s),t.get(e)+this.getMinDist(e,s)));if(i)t.set(s,Math.min(t.get(s),t.get(i)-this.getMinDist(s,i)))}},combineSequences:function(t,l,d,u,e){var f=e.length,i=this.intDiv(f,2);var n=[],s,r,o,a,h,c;for(s=0;s<i;++s){r=0;a=u===-1?this.downNodes.get(e[s]):this.upNodes.get(e[s]);for(o=0;o<a.length;++o){h=a[o];if(t.get(h)>=t.get(e[s]))r++;else{r--;n.push({k:t.get(h)+this.getMinDist(e[s],e[i-1]),v:2})}}n.push({k:t.get(e[s])+this.getMinDist(e[s],e[i-1]),v:r})}if(l)n.push({k:t.get(l)+this.getMinDist(l,e[i-1]),v:Number.MAX_VALUE});n.sort(this._positionDescendingComparer);var p=[];for(s=i;s<f;++s){r=0;a=u===-1?this.downNodes.get(e[s]):this.upNodes.get(e[s]);for(o=0;o<a.length;++o){h=a[o];if(t.get(h)<=t.get(e[s]))r++;else{r--;p.push({k:t.get(h)-this.getMinDist(e[s],e[i]),v:2})}}p.push({k:t.get(e[s])-this.getMinDist(e[s],e[i]),v:r})}if(d)p.push({k:t.get(d)-this.getMinDist(d,e[i]),v:Number.MAX_VALUE});p.sort(this._positionAscendingComparer);var g=0,v=0;var m=this.getMinDist(e[i-1],e[i]);while(t.get(e[i])-t.get(e[i-1])<m)if(g<v)if(n.length===0){t.set(e[i-1],t.get(e[i])-m);break}else{c=n.shift();g=g+c.v;t.set(e[i-1],c.k);t.set(e[i-1],Math.max(t.get(e[i-1]),t.get(e[i])-m))}else if(p.length===0){t.set(e[i],t.get(e[i-1])+m);break}else{c=p.shift();v=v+c.v;t.set(e[i],c.k);t.set(e[i],Math.min(t.get(e[i]),t.get(e[i-1])+m))}for(s=i-2;s>=0;s--)t.set(e[s],Math.min(t.get(e[s]),t.get(e[i-1])-this.getMinDist(e[s],e[i-1])));for(s=i+1;s<f;s++)t.set(e[s],Math.max(t.get(e[s]),t.get(e[i])+this.getMinDist(e[s],e[i])))},placeLeft:function(t,i,n){var s=Number.NEGATIVE_INFINITY;I.forEach(this._getComposite(t),function(t){var e=this.leftSibling(t);if(e&&this.nodeLeftClass.get(e)===this.nodeLeftClass.get(t)){if(!i.containsKey(e))this.placeLeft(e,i,n);s=Math.max(s,i.get(e)+this.getMinDist(e,t))}},this);if(s===Number.NEGATIVE_INFINITY)s=0;I.forEach(this._getComposite(t),function(t){i.set(t,s)})},placeRight:function(t,i,n){var s=Number.POSITIVE_INFINITY;I.forEach(this._getComposite(t),function(t){var e=this.rightSibling(t);if(e&&this.nodeRightClass.get(e)===this.nodeRightClass.get(t)){if(!i.containsKey(e))this.placeRight(e,i,n);s=Math.min(s,i.get(e)-this.getMinDist(t,e))}},this);if(s===Number.POSITIVE_INFINITY)s=0;I.forEach(this._getComposite(t),function(t){i.set(t,s)})},leftSibling:function(t){var e=this.layers[t.layer],i=t.layerIndex;return i===0?null:e[i-1]},rightSibling:function(t){var e=this.layers[t.layer];var i=t.layerIndex;return i===e.length-1?null:e[i+1]},_getComposite:function(t){return t.isVirtual?this._nodesInLink(t):[t]},arrangeNodes:function(){var t,e,i,n,s;for(e=0;e<this.layers.length;e++){n=this.layers[e];for(i=0;i<n.length;i++){s=n[i];s.upstreamPriority=s.upstreamLinkCount;s.downstreamPriority=s.downstreamLinkCount}}var r=2;for(var o=0;o<r;o++){for(t=this.layers.length-1;t>=1;t--)this.layoutLayer(false,t);for(t=0;t<this.layers.length-1;t++)this.layoutLayer(true,t)}var a=Number.MAX_VALUE;for(e=0;e<this.layers.length;e++){n=this.layers[e];for(i=0;i<n.length;i++){s=n[i];a=Math.min(a,s.gridPosition)}}if(a<0)for(e=0;e<this.layers.length;e++){n=this.layers[e];for(i=0;i<n.length;i++){s=n[i];s.gridPosition=s.gridPosition-a}}},layoutLayer:function(t,e){var i;var s;if(t)s=this.layers[i=e+1];else s=this.layers[i=e-1];var n=[];for(var r=0;r<s.length;r++)n.push(s[r]);n.sort(function(t,e){var i=(t.upstreamPriority+t.downstreamPriority)/2;var n=(e.upstreamPriority+e.downstreamPriority)/2;if(Math.abs(i-n)<1e-4)return 0;if(i<n)return 1;return-1});I.forEach(n,function(t){var e=t.gridPosition;var i=this.calcBaryCenter(t);var n=(t.upstreamPriority+t.downstreamPriority)/2;if(Math.abs(e-i)<1e-4)return;if(Math.abs(e-i)<.25+1e-4)return;if(e<i)while(e<i){if(!this.moveRight(t,s,n))break;e=t.gridPosition}else while(e>i){if(!this.moveLeft(t,s,n))break;e=t.gridPosition}},this);if(i>0)this.calcDownData(i-1);if(i<this.layers.length-1)this.calcUpData(i+1)},moveRight:function(t,e,i){var n=I.indexOf(e,t);if(n===e.length-1){t.gridPosition=t.gridPosition+.5;return true}var s=e[n+1];var r=(s.upstreamPriority+s.downstreamPriority)/2;if(s.gridPosition>t.gridPosition+1){t.gridPosition=t.gridPosition+.5;return true}if(r>i||Math.abs(r-i)<1e-4)return false;if(this.moveRight(s,e,i)){t.gridPosition=t.gridPosition+.5;return true}return false},moveLeft:function(t,e,i){var n=I.indexOf(e,t);if(n===0){t.gridPosition=t.gridPosition-.5;return true}var s=e[n-1];var r=(s.upstreamPriority+s.downstreamPriority)/2;if(s.gridPosition<t.gridPosition-1){t.gridPosition=t.gridPosition-.5;return true}if(r>i||Math.abs(r-i)<1e-4)return false;if(this.moveLeft(s,e,i)){t.gridPosition=t.gridPosition-.5;return true}return false},mapVirtualNode:function(t,e){this.nodeToLinkMap.set(t,e);if(!this.linkToNodeMap.containsKey(e))this.linkToNodeMap.set(e,[]);this.linkToNodeMap.get(e).push(t)},_nodesInLink:function(t){return this.linkToNodeMap.get(this.nodeToLinkMap.get(t))},_dummify:function(){this.linkToNodeMap=new D;this.nodeToLinkMap=new D;var t,e,i,l,d,n,s,u,f=this.graph.links.slice(0);var r=this.layers;var p=function(t,e,i){r[t].linksTo[e]=r[t].linksTo[e]||[];r[t].linksTo[e].push(i)};for(u=0;u<f.length;u++){var o=f[u];var a=o.source;var g=o.target;var h=a.layer;var c=g.layer;var v=a.gridPosition;var m=g.gridPosition;var _=(m-v)/Math.abs(c-h);var y=a;if(h-c>1){for(s=h-1;s>c;s--){i=new w;i.x=a.x;i.y=a.y;i.width=a.width/100;i.height=a.height/100;t=r[s];e=(s-c)*_+v;if(e>t.length)e=t.length;if(v>=r[h].length-1&&m>=r[c].length-1)e=t.length;else if(v===0&&m===0)e=0;i.layer=s;i.uBaryCenter=0;i.dBaryCenter=0;i.upstreamLinkCount=0;i.downstreamLinkCount=0;i.gridPosition=e;i.isVirtual=true;I.insert(t,i,e);for(d=e+1;d<t.length;d++){l=t[d];l.gridPosition=l.gridPosition+1}n=new x(y,i);n.depthOfDumminess=0;p(s-1,s,n);y=i;this.graph._addNode(i);this.graph.addLink(n);i.index=this.graph.nodes.length-1;this.mapVirtualNode(i,o)}p(c-1,c,n);o.changeSource(y);o.depthOfDumminess=h-c-1}else if(h-c<-1){for(s=h+1;s<c;s++){i=new w;i.x=a.x;i.y=a.y;i.width=a.width/100;i.height=a.height/100;t=r[s];e=(s-h)*_+v;if(e>t.length)e=t.length;if(v>=r[h].length-1&&m>=r[c].length-1)e=t.length;else if(v===0&&m===0)e=0;i.layer=s;i.uBaryCenter=0;i.dBaryCenter=0;i.upstreamLinkCount=0;i.downstreamLinkCount=0;i.gridPosition=e;i.isVirtual=true;e&=e;I.insert(t,i,e);for(d=e+1;d<t.length;d++){l=t[d];l.gridPosition=l.gridPosition+1}n=new x(y,i);n.depthOfDumminess=0;p(s-1,s,n);y=i;this.graph._addNode(i);this.graph.addLink(n);i.index=this.graph.nodes.length-1;this.mapVirtualNode(i,o)}p(c-1,c,o);o.changeSource(y);o.depthOfDumminess=c-h-1}else p(h,c,o)}},_dedummify:function(){var t=true;while(t){t=false;for(var e=0;e<this.graph.links.length;e++){var i=this.graph.links[e];if(!i.depthOfDumminess)continue;var n=[];n.unshift({x:i.target.x,y:i.target.y});n.unshift({x:i.source.x,y:i.source.y});var s=i;var r=i.depthOfDumminess;for(var o=0;o<r;o++){var a=s.source;var h=a.incoming[0];n.unshift({x:h.source.x,y:h.source.y});s=h}i.changeSource(s.source);i.depthOfDumminess=0;if(n.length>2){n.splice(0,1);n.splice(n.length-1);i.points=n}else i.points=[];t=true;break}}},_optimizeCrossings:function(){var t=-1,e;var i=3;var n=0;while(t!==0){if(n++>i)break;t=0;for(e=this.layers.length-1;e>=1;e--)t+=this.optimizeLayerCrossings(false,e);for(e=0;e<this.layers.length-1;e++)t+=this.optimizeLayerCrossings(true,e)}},calcUpData:function(t){if(t===0)return;var e=this.layers[t],i,n,s;var r=new d;var o=this.layers[t-1];for(i=0;i<o.length;i++)r.add(o[i]);for(i=0;i<e.length;i++){var a=e[i];var h=0;var c=0;for(n=0;n<a.incoming.length;n++){s=a.incoming[n];if(r.contains(s.source)){c++;h+=s.source.gridPosition}}for(n=0;n<a.outgoing.length;n++){s=a.outgoing[n];if(r.contains(s.target)){c++;h+=s.target.gridPosition}}if(c>0){a.uBaryCenter=h/c;a.upstreamLinkCount=c}else{a.uBaryCenter=i;a.upstreamLinkCount=0}}},calcDownData:function(t){if(t===this.layers.length-1)return;var e=this.layers[t],i,n,s;var r=new d;var o=this.layers[t+1];for(i=0;i<o.length;i++)r.add(o[i]);for(i=0;i<e.length;i++){var a=e[i];var h=0;var c=0;for(n=0;n<a.incoming.length;n++){s=a.incoming[n];if(r.contains(s.source)){c++;h+=s.source.gridPosition}}for(n=0;n<a.outgoing.length;n++){s=a.outgoing[n];if(r.contains(s.target)){c++;h+=s.target.gridPosition}}if(c>0){a.dBaryCenter=h/c;a.downstreamLinkCount=c}else{a.dBaryCenter=i;a.downstreamLinkCount=0}}},optimizeLayerCrossings:function(t,e){var i;var n;if(t)n=this.layers[i=e+1];else n=this.layers[i=e-1];var s=n.slice(0);if(t)this.calcUpData(i);else this.calcDownData(i);var r=this;n.sort(function(t,e){var i=r.calcBaryCenter(t),n=r.calcBaryCenter(e);if(Math.abs(i-n)<1e-4){if(t.degree()===e.degree())return r.compareByIndex(t,e);else if(t.degree()<e.degree())return 1;return-1}var s=(n-i)*1e3;if(s>0)return-1;else if(s<0)return 1;return r.compareByIndex(t,e)});var o,a=0;for(o=0;o<n.length;o++)if(n[o]!==s[o])a++;if(a>0){var h=0;for(o=0;o<n.length;o++){var c=n[o];c.gridPosition=h++}}return a},_swapPairs:function(){var l=this.options.layeredIterations;var t=0;while(true){if(t++>l)break;var e=t%4<=1;var d=t%4===1;for(var i=e?0:this.layers.length-1;e?i<=this.layers.length-1:i>=0;i+=e?1:-1){var n=this.layers[i];var u=false;var f=true;var p=0;for(var s=0;s<n.length-1;s++){var r=0;var o=0;var a=0;if(f){if(i!==0)r=this.countLinksCrossingBetweenTwoLayers(i-1,i);if(i!==this.layers.length-1)o=this.countLinksCrossingBetweenTwoLayers(i,i+1);if(e)r*=2;else o*=2;a=r+o}else a=p;if(a===0)continue;var h=n[s];var c=n[s+1];var g=h.gridPosition;var v=c.gridPosition;n[s]=c;n[s+1]=h;h.gridPosition=v;c.gridPosition=g;r=0;if(i!==0)r=this.countLinksCrossingBetweenTwoLayers(i-1,i);o=0;if(i!==this.layers.length-1)o=this.countLinksCrossingBetweenTwoLayers(i,i+1);if(e)r*=2;else o*=2;var m=r+o;var _=false;if(d)_=m>=a;else _=m>a;if(_){h=n[s];c=n[s+1];g=h.gridPosition;v=c.gridPosition;n[s]=c;n[s+1]=h;h.gridPosition=v;c.gridPosition=g;p=a;f=false}else{u=true;f=true}}if(u){if(i!==this.layers.length-1)this.calcUpData(i+1);if(i!==0)this.calcDownData(i-1)}}}},countLinksCrossingBetweenTwoLayers:function(l,t){var e=this.layers[l].linksTo[t];var i,n,s,r,o,a,h,c;var d=0;var u=e.length;for(h=0;h<u;h++){i=e[h];for(c=h+1;c<u;c++){n=e[c];if(i.target.layer===t){s=i.source;r=i.target}else{s=i.target;r=i.source}if(n.target.layer===t){o=n.source;a=n.target}else{o=n.target;a=n.source}var f=s.gridPosition;var p=r.gridPosition;var g=o.gridPosition;var v=a.gridPosition;if((f-g)*(p-v)<0)d++}}return d},calcBaryCenter:function(t){var e=t.upstreamLinkCount;var i=t.downstreamLinkCount;var n=t.uBaryCenter;var s=t.dBaryCenter;if(e>0&&i>0)return(n+s)/2;if(e>0)return n;if(i>0)return s;return 0},_gridPositionComparer:function(t,e){if(t.gridPosition<e.gridPosition)return-1;if(t.gridPosition>e.gridPosition)return 1;return 0},_positionAscendingComparer:function(t,e){return t.k<e.k?-1:t.k>e.k?1:0},_positionDescendingComparer:function(t,e){return t.k<e.k?1:t.k>e.k?-1:0},_firstVirtualNode:function(t){for(var e=0;e<t.length;e++)if(t[e].isVirtual)return e;return-1},compareByIndex:function(t,e){var i=t.index;var n=e.index;if(i<n)return 1;if(i>n)return-1;return 0},intDiv:function(t,e){return(t-t%e)/e},nextVirtualNode:function(t,e){var i=e.layerIndex;for(var n=i+1;n<t.length;++n)if(t[n].isVirtual)return t[n];return null}}),C=e.Class.extend({init:function(t,e){if(I.isUndefined(t))throw"No diagram given";this.diagram=t;this.nodeMap=new D;this.linkMap=new D;this.capture(e?e:t)},capture:function(t){var e,i,n,s,r,o,a;if(t instanceof l.Graph){for(s=0;s<t.nodes.length;s++){e=t.nodes[s];n=e.associatedShape;this.nodeMap.set(n.visual.id,new f(e.x,e.y,e.width,e.height))}for(s=0;s<t.links.length;s++){o=t.links[s];r=o.associatedConnection;this.linkMap.set(r.visual.id,o.points())}}else if(t instanceof Array){i=t;for(s=0;s<i.length;s++){e=i[s];n=e.associatedShape;if(n)this.nodeMap.set(n.visual.id,new f(e.x,e.y,e.width,e.height))}}else if(t.hasOwnProperty("links")&&t.hasOwnProperty("nodes")){i=t.nodes;a=t.links;for(s=0;s<i.length;s++){e=i[s];n=e.associatedShape;if(n)this.nodeMap.set(n.visual.id,new f(e.x,e.y,e.width,e.height))}for(s=0;s<a.length;s++){o=a[s];r=o.associatedConnection;if(r)this.linkMap.set(r.visual.id,o.points)}}else{var h=this.diagram.shapes;var c=this.diagram.connections;for(s=0;s<h.length;s++){n=h[s];this.nodeMap.set(n.visual.id,n.bounds())}for(s=0;s<c.length;s++){r=c[s];this.linkMap.set(r.visual.id,r.points())}}}});r(l,{init:function(t){e.init(t,l.ui)},SpringLayout:m,TreeLayout:y,GraphAdapter:c,LayeredLayout:b,LayoutBase:i,LayoutState:C})})}("function"==typeof define&&define.amd?define:function(t,e,i){(i||e)()}),function(define){define("dataviz/diagram/dom.min",["kendo.data.min","kendo.draganddrop.min","kendo.toolbar.min","kendo.editable.min","kendo.window.min","kendo.dropdownlist.min","kendo.dataviz.core.min","kendo.dataviz.themes.min","./svg.min","./services.min","./layout.min"],function(){var s=window.kendo.jQuery,f=void 0,p=kendo.dataviz,_=kendo.drawing,a=kendo.geometry,h=p.diagram,n=kendo.ui.Widget,t=kendo.Class,c=kendo.deepExtend,g=kendo._outerWidth,y=kendo._outerHeight,r=s.extend,w=kendo.data.HierarchicalDataSource,x=h.Canvas,b=h.Group,C=h.Rectangle,S=h.Circle,k=h.CompositeTransform,u=h.Rect,T=h.Path,M=h.DeleteShapeUnit,D=h.DeleteConnectionUnit,I=h.TextBlock,P=h.Image,v=h.Point,L=h.Intersect,E=h.ConnectionEditAdorner,e=h.UndoRedoService,z=h.ToolService,B=h.Selector,R=h.ResizingAdorner,N=h.ConnectorsAdorner,O=h.Cursors,l=h.Utils,A=kendo.Observable,U=h.ToBackUnit,V=h.ToFrontUnit,H=h.PolylineRouter,F=h.CascadingRouter,G=l.isUndefined,q=l.isDefined,o=_.util.defined,K=Array.isArray,W=kendo.isFunction,X=l.isString,Y=s.isPlainObject,m=Math,i=".kendoDiagram",j="cascading",J="itemBoundsChange",Q="change",Z="click",$="drag",tt="dragEnd",et="dragStart",it="mouseEnter",nt="mouseLeave",st="error",rt="Auto",ot,at,ht,ct,lt=9007199254740992,dt="select",ut="itemRotate",ft="pan",pt="zoomStart",gt="zoomEnd",vt="none",mt=600,_t=600,yt="rectangle",wt=100,xt=100,bt=20,Ct=20,St=0,kt="Yellow",Tt=Number.MAX_VALUE,Mt=-Number.MAX_VALUE,Dt="absolute",It="transformed",Pt="rotated",Lt="transparent",Et="width",zt="height",Bt="x",Rt="y",Nt="DOMMouseScroll"+i+" mousewheel"+i,Ot=.05,At=5,Ut='<a class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base #=className#" href="\\#">'+'<span class="k-button-icon #=iconClass# #=imageClass#"></span>'+'<span class="k-button-text">#=text#</span>'+"</a>",Vt=5,Ht=(h.DefaultConnectors=[{name:"Top"},{name:"Bottom"},{name:"Left"},{name:"Right"},{name:rt,position:function(t){return t.getPosition("center")}}],{cancel:{text:"Cancel",imageClass:"k-i-cancel",className:"k-diagram-cancel",iconClass:"k-icon"},update:{text:"Update",imageClass:"k-i-checkmark",className:"k-diagram-update",iconClass:"k-icon"}});function Ft(t){var e=t.originalEvent,i=0;if(e.wheelDelta){i=-e.wheelDelta/40;i=i>0?m.ceil(i):m.floor(i)}else if(e.detail)i=e.detail;return i}function Gt(t){return t.options.name.toLowerCase()===rt.toLowerCase()}function qt(t,e){var i=lt,n,s;for(var r=0;r<e.length;r++){s=e[r];if(!Gt(s)){var o=t.distanceTo(s.position());if(o<i){i=o;n=s}}}return n}function Kt(t,e){var i,n=[],s;var r=t.drawingContainer().children;var o=r.length;for(i=0;i<e.length;i++){s=e[i];for(var a=0;a<o;a++)if(r[a]==s.drawingContainer()){n.push(a);break}}return n}h.shapeDefaults=function(t){var e={type:yt,path:"",autoSize:true,visual:null,x:St,y:St,minWidth:bt,minHeight:Ct,width:wt,height:xt,hover:{},editable:{connect:true,tools:[]},connectors:h.DefaultConnectors,rotation:{angle:0}};l.simpleExtend(e,t);return e};var Wt=A.extend({init:function(t){var e=this;e.dataItem=(t||{}).dataItem;A.fn.init.call(e);e.options=c({id:h.randomId()},e.options,t);e.isSelected=false;e.visual=new b({id:e.options.id,autoSize:e.options.autoSize});e.id=e.options.id;e._template()},options:{hover:{},cursor:O.grip,content:{align:"center middle"},selectable:true,serializable:true,enable:true},_getCursor:function(t){if(this.adorner)return this.adorner._getCursor(t);return this.options.cursor},visible:function(t){if(G(t))return this.visual.visible();else this.visual.visible(t)},bounds:function(){},refresh:function(){this.visual.redraw()},position:function(t){this.options.x=t.x;this.options.y=t.y;this.visual.position(t)},toString:function(){return this.options.id},serialize:function(){var t=c({},{options:this.options});if(this.dataItem)t.dataItem=this.dataItem.toString();return t},_content:function(t){if(t!==f){var e=this.options;if(h.Utils.isString(t))e.content.text=t;else c(e.content,t);var i=e.content;var n=this._contentVisual;if(!n)this._createContentVisual(i);else this._updateContentVisual(i)}return this.options.content.text},_createContentVisual:function(t){if(t.text){this._contentVisual=new I(t);this._contentVisual._includeInBBox=false;this.visual.append(this._contentVisual)}},_updateContentVisual:function(t){this._contentVisual.redraw(t)},_hitTest:function(t){var e=this.bounds();return this.visible()&&e.contains(t)&&this.options.enable},_template:function(){var t=this;if(t.options.content.template){var e=t.dataItem||{},i=kendo.template(t.options.content.template,{paramName:"dataItem"});t.options.content.text=i(e)}},_canSelect:function(){return this.options.selectable!==false},toJSON:function(){return{id:this.options.id}}}),Xt=t.extend({init:function(t,e){this.options=c({},this.options,e);this.connections=[];this.shape=t},options:{width:7,height:7,fill:{color:kt},hover:{}},position:function(){if(this.options.position)return this.options.position(this.shape);else return this.shape.getPosition(this.options.name)},toJSON:function(){return{shapeId:this.shape.toString(),connector:this.options.name}}}),d=(Xt.parse=function(t,e){var i=e.split(":"),n=i[0],s=i[1]||rt;for(var r=0;r<t.shapes.length;r++){var o=t.shapes[r];if(o.options.id==n)return o.getConnector(s.trim())}},Wt.extend({init:function(t,e){var i=this;Wt.fn.init.call(i,t);this.diagram=e;this.updateOptionsFromModel();t=i.options;i.connectors=[];i.type=t.type;i.createShapeVisual();i.updateBounds();i.content(i.content());i._createConnectors()},options:h.shapeDefaults(),_setOptionsFromModel:function(t){var e=Jt(t||this.dataItem);this.options=c({},this.options,e);this.redrawVisual()},updateOptionsFromModel:function(t,e){if(this.diagram&&this.diagram._isEditable){var i=Jt(t||this.dataItem);if(t&&e)if(!p.inArray(e,["x","y","width","height"])){if(this.options.visual)this._redrawVisual();else if(i.type){this.options=c({},this.options,i);this._redrawVisual()}if(this.options.content){this._template();this.content(this.options.content)}}else{var n=this.bounds();n[e]=t[e];this.bounds(n)}else this.options=c({},this.options,i)}},_redrawVisual:function(){this.visual.clear();this._contentVisual=null;this.options.dataItem=this.dataItem;this.createShapeVisual();this.updateBounds()},redrawVisual:function(){this._redrawVisual();if(this.options.content){this._template();this.content(this.options.content)}},updateModel:function(t){var e=this.diagram;if(e&&e._isEditable){var i=this._bounds;var n=this.dataItem;if(n){e._suspendModelRefresh();if(o(n.x)&&i.x!==n.x)n.set("x",i.x);if(o(n.y)&&i.y!==n.y)n.set("y",i.y);if(o(n.width)&&i.width!==n.width)n.set("width",i.width);if(o(n.height)&&i.height!==n.height)n.set("height",i.height);this.dataItem=n;e._resumeModelRefresh();if(t)e._syncShapeChanges()}}},updateBounds:function(){var t=this.visual._measure(true);var e=this.options;this.bounds(new u(e.x,e.y,t.width,t.height));this._rotate();this._alignContent()},content:function(t){var e=this._content(t);this._alignContent();return e},_alignContent:function(){var t=this.options.content||{};var e=this._contentVisual;if(e&&t.align){var i=this.visual._measure();var n=new h.RectAlign(i);var s=e.drawingElement.bbox(null);var r=new u(0,0,s.width(),s.height());var o=n.align(r,t.align);e.position(o.topLeft())}},_createConnectors:function(){var t=this.options,e=t.connectors.length,i=t.connectorDefaults,n,s;for(s=0;s<e;s++){n=new Xt(this,c({},i,t.connectors[s]));this.connectors.push(n)}},bounds:function(t){var e;if(t)if(X(t))switch(t){case It:e=this._transformedBounds();break;case Dt:e=this._transformedBounds();var i=this.diagram._pan;e.x+=i.x;e.y+=i.y;break;case Pt:e=this._rotatedBounds();break;default:e=this._bounds}else{this._setBounds(t);this._triggerBoundsChange();if(!(this.diagram&&this.diagram._layouting))this.refreshConnections()}else e=this._bounds;return e},_setBounds:function(t){var e=this.options;var i=t.topLeft();var n=e.x=i.x;var s=e.y=i.y;var r=e.width=m.max(t.width,e.minWidth);var o=e.height=m.max(t.height,e.minHeight);this._bounds=new u(n,s,r,o);this.visual.redraw({x:n,y:s,width:r,height:o})},position:function(t){if(t)this.bounds(new u(t.x,t.y,this._bounds.width,this._bounds.height));else return this._bounds.topLeft()},clone:function(){var t=this.serialize();t.options.id=h.randomId();if(this.diagram&&this.diagram._isEditable&&o(this.dataItem))t.options.dataItem=ae(this.dataItem);return new d(t.options)},select:function(t){var e=this.diagram,i,n;if(G(t))t=true;if(this._canSelect())if(this.isSelected!=t){i=[];n=[];this.isSelected=t;if(this.isSelected){e._selectedItems.push(this);i.push(this)}else{l.remove(e._selectedItems,this);n.push(this)}if(!e._internalSelection)e._selectionChanged(i,n);return true}},rotate:function(t,e,i){var n=this.visual.rotate();if(t!==f){if(i!==false&&this.diagram&&this.diagram.undoRedoService&&t!==n.angle)this.diagram.undoRedoService.add(new h.RotateUnit(this.diagram._resizingAdorner,[this],[n.angle]),false);var s=this.bounds(),r=new v(s.width/2,s.height/2),o,a;if(e){o=t-n.angle;a=s.center().rotate(e,360-o).minus(r);this._rotationOffset=this._rotationOffset.plus(a.minus(s.topLeft()));this.position(a)}this.visual.rotate(t,r);this.options.rotation.angle=t;if(this.diagram&&this.diagram._connectorsAdorner)this.diagram._connectorsAdorner.refresh();this.refreshConnections();if(this.diagram)this.diagram.trigger(ut,{item:this})}return n},connections:function(t){var e=[],i,n,s,r,o;for(i=0;i<this.connectors.length;i++){o=this.connectors[i];r=o.connections;for(n=0,r;n<r.length;n++){s=r[n];if(t=="out"){var a=s.source();if(a.shape&&a.shape==this)e.push(s)}else if(t=="in"){var h=s.target();if(h.shape&&h.shape==this)e.push(s)}else e.push(s)}}return e},refreshConnections:function(){s.each(this.connections(),function(){this.refresh()})},getConnector:function(t){var e,i;if(X(t)){t=t.toLocaleLowerCase();for(e=0;e<this.connectors.length;e++){i=this.connectors[e];if(i.options.name.toLocaleLowerCase()==t)return i}}else if(t instanceof v)return qt(t,this.connectors);else return this.connectors.length?this.connectors[0]:null},getPosition:function(t){var e=this.bounds(),i=t.charAt(0).toLowerCase()+t.slice(1);if(W(e[i]))return this._transformPoint(e[i]());return e.center()},redraw:function(t){if(t){var e=this.options;var i;this.shapeVisual.redraw(this._visualOptions(t));if(this._diffNumericOptions(t,[Et,zt,Bt,Rt])){this.bounds(new u(e.x,e.y,e.width,e.height));i=true}if(t.connectors){e.connectors=t.connectors;this._updateConnectors()}e=c(e,t);if(t.rotation||i)this._rotate();if(e.content)this.content(e.content)}},_updateConnectors:function(){var t=this.connections();this.connectors=[];this._createConnectors();var e;var i;var n;for(var s=0;s<t.length;s++){e=t[s];i=e.source();n=e.target();if(i.shape&&i.shape===this)e.source(this.getConnector(i.options.name)||null);else if(n.shape&&n.shape===this)e.target(this.getConnector(n.options.name)||null);e.updateModel()}},_diffNumericOptions:h.diffNumericOptions,_visualOptions:function(t){return{data:t.path,source:t.source,hover:t.hover,fill:t.fill,stroke:t.stroke}},_triggerBoundsChange:function(){if(this.diagram)this.diagram.trigger(J,{item:this,bounds:this._bounds.clone()})},_transformPoint:function(t){var e=this.rotate(),i=this.bounds(),n=i.topLeft();if(e.angle)t.rotate(e.center().plus(n),360-e.angle);return t},_transformedBounds:function(){var t=this.bounds(),e=t.topLeft(),i=t.bottomRight();return u.fromPoints(this.diagram.modelToView(e),this.diagram.modelToView(i))},_rotatedBounds:function(){var t=this.bounds().rotatedBounds(this.rotate().angle),e=t.topLeft(),i=t.bottomRight();return u.fromPoints(e,i)},_rotate:function(){var t=this.options.rotation;if(t&&t.angle)this.rotate(t.angle);this._rotationOffset=new v},_hover:function(t){var e=this.options,i=e.hover,n=e.stroke,s=e.fill;if(t&&q(i.stroke))n=c({},n,i.stroke);if(t&&q(i.fill))s=i.fill;this.shapeVisual.redraw({stroke:n,fill:s});if(e.editable&&e.editable.connect)this.diagram._showConnectors(this,t)},_hitTest:function(t){if(this.visible()){var e=this.bounds(),i,n=this.rotate().angle;if(t.isEmpty&&!t.isEmpty())return L.rects(t,e,n?n:0);else{i=t.clone().rotate(e.center(),n);if(e.contains(i))return this}}},toJSON:function(){return{shapeId:this.options.id}},createShapeVisual:function(){var t=this.options;var e=this._visualOptions(t);var i=t.visual;var n=(t.type+"").toLocaleLowerCase();var s;e.width=t.width;e.height=t.height;if(W(i))s=i.call(this,t);else if(e.data){s=new T(e);ue(s)}else if(n=="rectangle")s=new C(e);else if(n=="circle")s=new S(e);else if(n=="text")s=new I(e);else if(n=="image")s=new P(e);else s=new T(e);this.shapeVisual=s;this.visual.append(this.shapeVisual)}})),Yt=Wt.extend({init:function(t,e,i){var n=this;Wt.fn.init.call(n,i);this.updateOptionsFromModel();this._initRouter();n.path=new h.Polyline(n.options);n.path.fill(Lt);n.visual.append(n.path);n._sourcePoint=n._targetPoint=new v;n._setSource(t);n._setTarget(e);n.content(n.options.content);n.definers=[];if(o(i)&&i.points)n.points(i.points)},options:{hover:{stroke:{}},startCap:vt,endCap:vt,points:[],selectable:true,fromConnector:rt,toConnector:rt},_setOptionsFromModel:function(t){this.updateOptionsFromModel(t||this.dataItem)},updateOptionsFromModel:function(t){if(this.diagram&&this.diagram._isEditable){var e=this.diagram._dataMap;var i=Qt(t||this.dataItem);if(t){if(o(i.from)){var n=e[i.from];if(n&&o(i.fromConnector))n=n.getConnector(i.fromConnector);this.source(n)}else if(o(i.fromX)&&o(i.fromY))this.source(new v(i.fromX,i.fromY));if(o(i.to)){var s=e[i.to];if(s&&o(i.toConnector))s=s.getConnector(i.toConnector);this.target(s)}else if(o(i.toX)&&o(i.toY))this.target(new v(i.toX,i.toY));if(o(i.type)&&this.type()!==i.type){this.points([]);this.type(i.type)}this.dataItem=t;this._template();this.redraw(this.options)}else this.options=c({},i,this.options)}},updateModel:function(t){if(this.diagram&&this.diagram._isEditable)if(this.diagram.connectionsDataSource){var e=this.diagram.connectionsDataSource.getByUid(this.dataItem.uid);if(e){this.diagram._suspendModelRefresh();if(o(this.options.fromX)&&this.options.fromX!==null){le("from",e);le("fromConnector",e);e.set("fromX",this.options.fromX);e.set("fromY",this.options.fromY)}else{e.set("from",this.options.from);if(o(e.fromConnector))e.set("fromConnector",this.sourceConnector?this.sourceConnector.options.name:null);le("fromX",e);le("fromY",e)}if(o(this.options.toX)&&this.options.toX!==null){le("to",e);le("toConnector",e);e.set("toX",this.options.toX);e.set("toY",this.options.toY)}else{e.set("to",this.options.to);if(o(e.toConnector))e.set("toConnector",this.targetConnector?this.targetConnector.options.name:null);le("toX",e);le("toY",e)}if(o(this.options.type)&&o(e.type))e.set("type",this.options.type);this.dataItem=e;this.diagram._resumeModelRefresh();if(t)this.diagram._syncConnectionChanges()}}},sourcePoint:function(){return this._resolvedSourceConnector?this._resolvedSourceConnector.position():this._sourcePoint},_setSource:function(t){var e=t instanceof d;var i=this.options.fromConnector||rt;var n;if(e&&!t.getConnector(i))return;if(t!==f)this.from=t;this._removeFromSourceConnector();if(t===null){if(this.sourceConnector){this._sourcePoint=(this._resolvedSourceConnector||this.sourceConnector).position();this._clearSourceConnector();this._setFromOptions(null,this._sourcePoint)}}else if(t instanceof Xt){n=t.shape.dataItem;if(n)this._setFromOptions(n.id);this.sourceConnector=t;this.sourceConnector.connections.push(this)}else if(t instanceof v){this._setFromOptions(null,t);this._sourcePoint=t;if(this.sourceConnector)this._clearSourceConnector()}else if(e){n=t.dataItem;if(n)this._setFromOptions(n.id);this.sourceConnector=t.getConnector(i);this.sourceConnector.connections.push(this)}},source:function(t,e){if(q(t)){if(e&&this.diagram)this.diagram.undoRedoService.addCompositeItem(new h.ConnectionEditUnit(this,t));this._setSource(t);this.refresh()}return this.sourceConnector?this.sourceConnector:this._sourcePoint},_setFromOptions:function(t,e){this.options.from=t;if(e){this.options.fromX=e.x;this.options.fromY=e.y}else{this.options.fromX=null;this.options.fromY=null}},sourceDefiner:function(t){if(t)if(t instanceof h.PathDefiner){t.left=null;this._sourceDefiner=t;this.source(t.point)}else throw"The sourceDefiner needs to be a PathDefiner.";else{if(!this._sourceDefiner)this._sourceDefiner=new h.PathDefiner(this.sourcePoint(),null,null);return this._sourceDefiner}},targetPoint:function(){return this._resolvedTargetConnector?this._resolvedTargetConnector.position():this._targetPoint},_setTarget:function(t){var e=t instanceof d;var i=this.options.toConnector||rt;var n;if(e&&!t.getConnector(i))return;if(t!==f)this.to=t;this._removeFromTargetConnector();if(t===null){if(this.targetConnector){this._targetPoint=(this._resolvedTargetConnector||this.targetConnector).position();this._clearTargetConnector();this._setToOptions(null,this._targetPoint)}}else if(t instanceof Xt){n=t.shape.dataItem;if(n)this._setToOptions(n.id);this.targetConnector=t;this.targetConnector.connections.push(this)}else if(t instanceof v){this._setToOptions(null,t);this._targetPoint=t;if(this.targetConnector)this._clearTargetConnector()}else if(e){n=t.dataItem;if(n)this._setToOptions(n.id);this.targetConnector=t.getConnector(i);this.targetConnector.connections.push(this)}},target:function(t,e){if(q(t)){if(e&&this.diagram)this.diagram.undoRedoService.addCompositeItem(new h.ConnectionEditUnit(this,f,t));this._setTarget(t);this.refresh()}return this.targetConnector?this.targetConnector:this._targetPoint},_setToOptions:function(t,e){this.options.to=t;if(e){this.options.toX=e.x;this.options.toY=e.y}else{this.options.toX=null;this.options.toY=null}},targetDefiner:function(t){if(t)if(t instanceof h.PathDefiner){t.right=null;this._targetDefiner=t;this.target(t.point)}else throw"The sourceDefiner needs to be a PathDefiner.";else{if(!this._targetDefiner)this._targetDefiner=new h.PathDefiner(this.targetPoint(),null,null);return this._targetDefiner}},_updateConnectors:function(){this._updateConnector(this.source(),"source");this._updateConnector(this.target(),"target")},_updateConnector:function(e,i){var n=this;var s=n.diagram;if(e instanceof Xt&&!s.getShapeById(e.shape.id)){var r=e.shape.dataItem;var o=e.options.name;var t=function(){var t=s._dataMap[r.id];e=t.getConnector(o);n[i](e,false);n.updateModel()};if(s._dataMap[r.id])t();else{var a=s._inactiveShapeItems.getByUid(r.uid);if(a)s._deferredConnectionUpdates.push(a.onActivate(t))}}else n[i](e,false)},content:function(t){var e=this._content(t);if(o(t))this._alignContent();return e},_createContentVisual:function(t){var e;if(W(t.visual))e=t.visual.call(this,t);else if(t.text)e=new I(t);if(e){this._contentVisual=e;e._includeInBBox=false;this.visual.append(e)}return e},_updateContentVisual:function(t){if(W(t.visual)){this.visual.remove(this._contentVisual);this._createContentVisual(t)}else this._contentVisual.redraw(t)},_alignContent:function(){if(this._contentVisual){var t=Vt;var e=this.allPoints();var i=m.floor(e.length/2);var n=i-1;while(n>0&&e[n].equals(e[i])){n--;i++}var s=e[i];var r=e[n];var o=this._contentVisual._measure();var l=o.width;var a=o.height;var d=e.length%2===0;var u=r.distanceTo(s);if(d&&e.length>2&&u>0&&(r.y===s.y&&u<l||r.x===s.x&&u<a)){d=false;t=0}var h;if(d){var c=_.util.deg(m.atan2(s.y-r.y,s.x-r.x));h=new v((s.x-r.x)/2+r.x,(s.y-r.y)/2+r.y);if(m.abs(c)===90){h.x+=t;h.y-=a/2}else if(c%180===0){h.x-=l/2;h.y-=a+t}else if(c<-90||0<c&&c<90)h.y-=a;else if(c<0||c>90){h.x-=l;h.y-=a}}else{var f=m.floor(e.length/2);h=e[f].clone();r=e[f-1];s=e[f+1];var p=r.x<=h.x&&s.x<=h.x?t:-o.width-t;var g=r.y<=h.y&&s.y<=h.y?t:-o.height-t;h.x+=p;h.y+=g}this._contentVisual.position(h)}},select:function(t){var e=this.diagram,i,n;if(this._canSelect())if(this.isSelected!==t){this.isSelected=t;i=[];n=[];if(this.isSelected){this.adorner=new E(this,this.options.selection);e._adorn(this.adorner,true);e._selectedItems.push(this);i.push(this)}else if(this.adorner){e._adorn(this.adorner,false);l.remove(e._selectedItems,this);this.adorner=f;n.push(this)}if(this.adorner)this.adorner.refresh();if(!e._internalSelection)e._selectionChanged(i,n);return true}},bounds:function(t){if(t&&!X(t))this._bounds=t;else return this._bounds},type:function(t){var e=this.options;if(t){if(t!==e.type){e.type=t;this._initRouter();this.refresh()}}else return e.type},_initRouter:function(){var t=(this.options.type||"").toLowerCase();if(t==j)this._router=new F(this);else this._router=new H(this)},points:function(t){if(t){this.definers=[];for(var e=0;e<t.length;e++){var i=t[e];if(i instanceof h.Point)this.definers.push(new h.PathDefiner(i));else if(i.hasOwnProperty("x")&&i.hasOwnProperty("y"))this.definers.push(new h.PathDefiner(new v(i.x,i.y)));else throw"A Connection point needs to be a Point or an object with x and y properties."}}else{var n=[];if(q(this.definers))for(var s=0;s<this.definers.length;s++)n.push(this.definers[s].point);return n}},allPoints:function(){var t=[this.sourcePoint()];if(this.definers)for(var e=0;e<this.definers.length;e++)t.push(this.definers[e].point);t.push(this.targetPoint());return t},refresh:function(){this._resolveConnectors();this._refreshPath();this._alignContent();if(this.adorner)this.adorner.refresh()},_resolveConnectors:function(){var t=this,e,i,n,s,r=t.source(),o=t.target();if(r instanceof v)e=r;else if(r instanceof Xt)if(Gt(r))n=r.shape.connectors;else n=[r];if(o instanceof v)i=o;else if(o instanceof Xt)if(Gt(o))s=o.shape.connectors;else s=[o];if(e){if(s)t._resolvedTargetConnector=qt(e,s)}else if(n)if(i)t._resolvedSourceConnector=qt(i,n);else if(s)this._resolveAutoConnectors(n,s)},_resolveAutoConnectors:function(l,d){var u=lt;var f=lt;var t,p;var e,i;var n,s;var r,o;var a,h;var c;for(a=0;a<l.length;a++){r=l[a];if(!Gt(r)){e=r.position();for(h=0;h<d.length;h++){o=d[h];if(!Gt(o)){i=o.position();c=m.round(e.distanceTo(i));if(c<u&&this.diagram&&this._testRoutePoints(e,i,r,o)){u=c;t=r;p=o}if(c<f){n=r;s=o;f=c}}}}}if(t){n=t;s=p}this._resolvedSourceConnector=n;this._resolvedTargetConnector=s},_testRoutePoints:function(t,e,i,n){var s=this._router;var l=true;if(s instanceof F){var r=s.routePoints(t,e,i,n),o,a,h,d;d=this._getRouteExclude(t,e,i.shape,n.shape);r.unshift(t);r.push(e);for(var c=1;c<r.length;c++){o=r[c-1];a=r[c];h=new u(m.min(o.x,a.x),m.min(o.y,a.y),m.abs(o.x-a.x),m.abs(o.y-a.y));if(h.width>0){h.x++;h.width-=2}if(h.height>0){h.y++;h.height-=2}if(!h.isEmpty()&&this.diagram._shapesQuadTree.hitTestRect(h,d)){l=false;break}}}return l},_getRouteExclude:function(t,e,i,n){var s=[];if(this._isPointInsideShape(t,i))s.push(i);if(this._isPointInsideShape(e,n))s.push(n);return s},_isPointInsideShape:function(t,e){var i=e.bounds(),n,s=e.rotate().angle,r,o,a=i.x,h=i.y;n=t.clone().rotate(i.center(),s);r=n.x;o=n.y;return r>a&&r<a+i.width&&o>h&&o<h+i.height},redraw:function(t){if(t){this.options=c({},this.options,t);var e=this.options.points;if(o(e)&&e.length>0){this.points(e);this._refreshPath()}if(t&&t.content||t.text)this.content(t.content);this.path.redraw({fill:t.fill,stroke:t.stroke,startCap:t.startCap,endCap:t.endCap})}},clone:function(){var t=this.serialize();if(this.diagram&&this.diagram._isEditable&&o(this.dataItem))t.options.dataItem=ae(this.dataItem);return new Yt(this.from,this.to,t.options)},serialize:function(){var t=this.from.toJSON?this.from.toJSON:this.from.toString(),e=this.to.toJSON?this.to.toJSON:this.to.toString();var i=c({},{options:this.options,from:t,to:e});if(o(this.dataItem))i.dataItem=this.dataItem.toString();i.options.points=this.points();return i},_hitTest:function(t){if(this.visible()){var e=new v(t.x,t.y),i=this.sourcePoint(),n=this.targetPoint();if(t.isEmpty&&!t.isEmpty()&&t.contains(i)&&t.contains(n))return this;if(this._router.hitTest(e))return this}},_hover:function(t){var e=(this.options.stroke||{}).color;if(t&&q(this.options.hover.stroke.color))e=this.options.hover.stroke.color;this.path.redraw({stroke:{color:e}})},_refreshPath:function(){if(!o(this.path))return;this._drawPath();this.bounds(this._router.getBounds())},_drawPath:function(){if(this._router)this._router.route();var t=this.sourcePoint();var e=this.targetPoint();var i=this.points();this.path.redraw({points:[t].concat(i,[e])})},_clearSourceConnector:function(){this.sourceConnector=f;this._resolvedSourceConnector=f},_clearTargetConnector:function(){this.targetConnector=f;this._resolvedTargetConnector=f},_removeFromSourceConnector:function(){if(this.sourceConnector)l.remove(this.sourceConnector.connections,this)},_removeFromTargetConnector:function(){if(this.targetConnector)l.remove(this.targetConnector.connections,this)},toJSON:function(){var t=this;var e,i,n;if(t.from&&t.from.toJSON)e=t.from.toJSON();else{n=t._sourcePoint;e={x:n.x,y:n.y}}if(t.to&&t.to.toJSON)i=t.to.toJSON();else{n=t._targetPoint;i={x:n.x,y:n.y}}return{from:e,to:i}}}),jt=n.extend({init:function(t,e){var i=this;kendo.destroy(t);n.fn.init.call(i,t,e);i._initTheme();i._initElements();i._extendLayoutOptions(i.options);i._initDefaults(e);i._interactionDefaults();i._initCanvas();i.mainLayer=new b({id:"main-layer"});i.canvas.append(i.mainLayer);i._shapesQuadTree=new oe(i);i._pan=new v;i._adorners=[];i.adornerLayer=new b({id:"adorner-layer"});i.canvas.append(i.adornerLayer);i._createHandlers();i._initialize();i._resizingAdorner=new R(i,{editable:i.options.editable});i._connectorsAdorner=new N(i);i._adorn(i._resizingAdorner,true);i._adorn(i._connectorsAdorner,true);i.selector=new B(i);i._clipboard=[];i.pauseMouseHandlers=false;i._fetchFreshData();i._createGlobalToolBar();i._createOptionElements();i.zoom(i.options.zoom);i.canvas.draw()},options:{name:"Diagram",theme:"default",layout:"",zoomRate:.1,zoom:1,zoomMin:0,zoomMax:2,dataSource:{},draggable:true,template:"",autoBind:true,editable:{rotate:{},resize:{},text:true,tools:[],drag:{snap:{size:10,angle:10}},remove:true},pannable:{},selectable:{key:"none"},tooltip:{enabled:true,format:"{0}"},copy:{enabled:true,offsetX:20,offsetY:20},shapeDefaults:h.shapeDefaults({undoable:true}),connectionDefaults:{editable:{tools:[]},type:j},shapes:[],connections:[]},events:[gt,pt,ft,dt,ut,J,Q,Z,it,nt,"toolBarClick","save","cancel","edit","remove","add","dataBound",et,$,tt],items:function(){return s()},_createGlobalToolBar:function(){var t=this.options.editable;if(t){var e=t.tools;if(this._isEditable&&e!==false&&(!e||e.length===0))e=["createShape","undo","redo","rotateClockwise","rotateAnticlockwise"];if(e&&e.length){this.toolBar=new Zt(this,{tools:e||{},click:this._toolBarClick.bind(this),modal:false});this.toolBar.element.css({textAlign:"left"});this.element.prepend(this.toolBar.element);this._resize()}}},createShape:function(){if(this.editor&&this.editor.end()||!this.editor){var t=this.dataSource;var e=t.view()||[];var i=e.length;var n=ce(t,{});var s=this._createShape(n,{});if(!this.trigger("add",{shape:s})){t.insert(i,n);var r=this._inactiveShapeItems.getByUid(n.uid);r.element=s;this.edit(s)}}},_createShape:function(t,e){e=c({},this.options.shapeDefaults,e);e.dataItem=t;var i=new d(e,this);return i},createConnection:function(){if(this.editor&&this.editor.end()||!this.editor){var t=this.connectionsDataSource;var e=t.view()||[];var i=e.length;var n=ce(t,{});var s=this._createConnection(n);if(!this.trigger("add",{connection:s})){this._connectionsDataMap[n.uid]=s;t.insert(i,n);this.addConnection(s,false);this.edit(s)}}},_createConnection:function(t,e,i){var n=c({},this.options.connectionDefaults);n.dataItem=t;var s=new Yt(e||new v,i||new v,n);return s},editModel:function(t,e){this.cancelEdit();var i,n;var s=this.options.editable;if(e=="shape"){i=s.shapeEditors;n=s.shapeTemplate}else if(e=="connection"){var r=ee.bind(this);i=c({},{from:r,to:r},s.connectionEditors);n=s.connectionTemplate}else return;this.editor=new te(this.element,{update:this._update.bind(this),cancel:this._cancel.bind(this),model:t,type:e,target:this,editors:i,template:n});this.trigger("edit",this._editArgs())},edit:function(t){if(t.dataItem){var e=t instanceof d?"shape":"connection";this.editModel(t.dataItem,e)}},cancelEdit:function(){if(this.editor){this._getEditDataSource().cancelChanges(this.editor.model);this._destroyEditor()}},saveEdit:function(){if(this.editor&&this.editor.end()&&!this.trigger("save",this._editArgs()))this._getEditDataSource().sync()},_update:function(){if(this.editor&&this.editor.end()&&!this.trigger("save",this._editArgs())){this._getEditDataSource().sync();this._destroyEditor()}},_cancel:function(){if(this.editor&&!this.trigger("cancel",this._editArgs())){var t=this.editor.model;this._getEditDataSource().cancelChanges(t);var e=this._connectionsDataMap[t.uid]||this._dataMap[t.id];if(e)e._setOptionsFromModel(t);this._destroyEditor()}},_getEditDataSource:function(){return this.editor.options.type==="shape"?this.dataSource:this.connectionsDataSource},_editArgs:function(){var t={container:this.editor.wrapper};t[this.editor.options.type]=this.editor.model;return t},_destroyEditor:function(){if(this.editor){this.editor.close();this.editor=null}},_initElements:function(){this.wrapper=this.element.empty().css("position","relative").attr("tabindex",0).addClass("k-widget k-diagram");this.scrollable=s("<div />").appendTo(this.element)},_initDefaults:function(t){var e=this.options;var i=e.editable;var n=e.shapeDefaults;var s=e.connectionDefaults;var r=(t||{}).shapeDefaults;if(i===false){n.editable=false;s.editable=false}else{de(i,n.editable,["drag","remove","connect"]);de(i,s.editable,["drag","remove"])}if(r&&r.connectors)e.shapeDefaults.connectors=r.connectors},_interactionDefaults:function(){var t=this.options;var e=t.selectable;var i=t.pannable;var n=kendo.support.mobileOS;if(e&&!o(e.multiple))t.selectable=c({multiple:n?false:true},t.selectable);if(i&&!o(i.key))t.pannable=c({key:n?"none":"ctrl"},t.pannable)},_initCanvas:function(){var t=s("<div class='k-layer'></div>").appendTo(this.scrollable)[0];var e=this.viewport();this.canvas=new x(t,{width:e.width||mt,height:e.height||_t})},_createHandlers:function(){var t=this;var e=t.element;e.on(Nt,t._wheel.bind(t)).on("keydown"+i,t._keydown.bind(t));t._userEvents=new kendo.UserEvents(this.scrollable,{multiTouch:true,fastTap:true,tap:t._tap.bind(t),start:t._dragStart.bind(t),move:t._drag.bind(t),end:t._dragEnd.bind(t),gesturestart:t._gestureStart.bind(t),gesturechange:t._gestureChange.bind(t),gestureend:t._gestureEnd.bind(t),doubleTap:t._doubleTap.bind(t),supportDoubleTap:true});t.toolService=new z(t);this.scrollable.on("mouseover"+i,t._mouseover.bind(t)).on("mouseout"+i,t._mouseout.bind(t)).on("mousemove"+i,t._mouseMove.bind(t)).on("mousedown"+i,t._mouseDown.bind(t)).on("mouseup"+i,t._mouseUp.bind(t));this._syncHandler=t._syncChanges.bind(t);t._resizeHandler=t.resize.bind(t,false);kendo.onResize(t._resizeHandler);this.bind(pt,t._destroyToolBar.bind(t));this.bind(ft,t._destroyToolBar.bind(t))},_dragStart:function(t){this._pauseMouseHandlers=true;var e=this._eventPositions(t,true);var i=t.event;if(this.toolService.start(e,this._meta(i))){this._destroyToolBar();i.preventDefault()}},_drag:function(t){var e=this._eventPositions(t);var i=t.event;if(this.toolService.move(e,this._meta(i)))i.preventDefault()},_dragEnd:function(t){this._pauseMouseHandlers=false;var e=this._eventPositions(t);var i=t.event;if(this.toolService.end(e,this._meta(i))){this._createToolBar();i.preventDefault()}},_mouseMove:function(t){if(!this._pauseMouseHandlers){var e=this._eventPositions(t);this.toolService._updateHoveredItem(e);this.toolService._updateCursor(e)}},_mouseDown:function(){this._pauseMouseHandlers=true},_mouseUp:function(){this._pauseMouseHandlers=false},_tap:function(t){var e=this.toolService;var i=this.options.selectable;var n=this._eventPositions(t);var s=this.focus();e._updateHoveredItem(n);if(e.hoveredItem){var r=e.hoveredItem;this.trigger("click",{item:r,point:n,meta:this._meta(t.event)});if(i&&r.options.selectable!==false){var o=i.multiple!==false;var a=kendo.support.mobileOS||this._meta(t.event).ctrlKey;if(r.isSelected)if(a){this._destroyToolBar();r.select(false)}else this._createToolBar(s);else{this._destroyToolBar();this.select(r,{addToSelection:o&&a});this._createToolBar(s)}}}else if(i){this._destroyToolBar();this.deselect()}},_keydown:function(t){if(this.toolService.keyDown(t.keyCode,this._meta(t)))t.preventDefault()},_wheel:function(t){var e=Ft(t),i=this._eventPositions(t),n=c(this._meta(t),{delta:e});if(this.toolService.wheel(i,n))t.preventDefault()},_meta:function(t){return{ctrlKey:t.ctrlKey,metaKey:t.metaKey,altKey:t.altKey,shiftKey:t.shiftKey,type:t.type}},_eventPositions:function(t,e){var i;if(t.touch){var n=e?"startLocation":"location";i=new v(t.x[n],t.y[n])}else{var s=t.originalEvent;i=new v(s.pageX,s.pageY)}return this.documentToModel(i)},_gestureStart:function(t){this._destroyToolBar();this.scroller.disable();var e=this.documentToModel(new v(t.center.x,t.center.y));var i={point:e,zoom:this.zoom()};if(this.trigger(pt,i))return;this._gesture=t;this._initialCenter=e},_gestureChange:function(t){var e=this._gesture;var i=this._initialCenter;var n=this.documentToView(new v(t.center.x,t.center.y));var s=t.distance/e.distance;var r=this._zoom;var o=false;if(m.abs(s-1)>=Ot){this._zoom=r=this._getValidZoom(r*s);this.options.zoom=r;this._gesture=t;o=true}var a=i.times(r);var h=n.minus(a);if(o||this._pan.distanceTo(h)>=At){this._panTransform(h);this._updateAdorners()}t.preventDefault()},_doubleTap:function(t){var e=this;var i=this._eventPositions(t);var n=e.options;var s=n.zoomRate;var r=e.zoom()+s;var o=this._meta(t);var a={point:i,meta:o,zoom:r};if(e.trigger(pt,a))return;r=kendo.dataviz.round(Math.max(n.zoomMin,Math.min(n.zoomMax,r)),2);a.zoom=r;e.zoom(r,a);e.trigger(gt,a)},_gestureEnd:function(){if(this.options.pannable!==false)this.scroller.enable();this.trigger(gt,{point:this._initialCenter,zoom:this.zoom()})},_resize:function(){var t=this.viewport();if(this.canvas)this.canvas.size(t);if(this.scrollable&&this.toolBar)this.scrollable.height(t.height)},_mouseover:function(t){var e=t.target._kendoNode;if(e&&e.srcElement._hover)e.srcElement._hover(true,e.srcElement)},_mouseout:function(t){var e=t.target._kendoNode;if(e&&e.srcElement._hover)e.srcElement._hover(false,e.srcElement)},_initTheme:function(){var t=this;var e=((t.options||{}).theme||"").toLowerCase();var i=p.ui.themes||{};var n;if(p.SASS_THEMES.indexOf(e)!=-1)n=p.autoTheme().diagram;else n=(i[e]||{}).diagram;t.options=c({},n,t.options);if(t.options.editable===true)c(t.options,{editable:(n||{}).editable})},_createOptionElements:function(){var t=this.options;var e=t.shapes.length;if(e)this._createShapes();if(t.connections.length)this._createConnections();if(e&&t.layout)this.layout(t.layout)},_createShapes:function(){var t=this,e=t.options,i=e.shapes,n,s;for(s=0;s<i.length;s++){n=i[s];t.addShape(n)}},_createConnections:function(){var t=this,e=t.options,i=e.connectionDefaults,n=e.connections,s,r,o,a;for(a=0;a<n.length;a++){s=n[a];r=t._findConnectionTarget(s.from);o=t._findConnectionTarget(s.to);t.connect(r,o,c({},i,s))}},_findConnectionTarget:function(t){t=t||{};var e=this;var i=X(t)?t:t.shapeId||t.id;var n;if(i){n=e.getShapeById(i);if(t.connector)n=n.getConnector(t.connector)}else n=new v(t.x||0,t.y||0);return n},destroy:function(){var t=this;n.fn.destroy.call(t);if(this._userEvents)this._userEvents.destroy();kendo.unbindResize(t._resizeHandler);t.clear();t.element.off(i);t.scroller.wrapper.off(i);t.canvas.destroy(true);t.canvas=f;t._destroyEditor();t.destroyScroller();t._destroyGlobalToolBar();t._destroyToolBar()},destroyScroller:function(){var t=this.scroller;if(!t)return;t.destroy();t.element.remove();this.scroller=null},save:function(){var t={shapes:[],connections:[]};var e,i,n;for(e=0;e<this.shapes.length;e++){n=this.shapes[e];if(n.options.serializable)t.shapes.push(n.options)}for(e=0;e<this.connections.length;e++){i=this.connections[e];t.connections.push(c({},i.options,i.toJSON()))}return t},focus:function(){if(!this.element.is(kendo._activeElement())){var t=this.element,e=t[0],i=[],n=[],s=document.documentElement,r;do{e=e.parentNode;if(e.scrollHeight>e.clientHeight){i.push(e);n.push(e.scrollTop)}}while(e!=s);t.trigger("focus");for(r=0;r<i.length;r++)i[r].scrollTop=n[r];return true}},load:function(t){this.clear();this.setOptions(t);this._createShapes();this._createConnections()},setOptions:function(t){c(this.options,t)},clear:function(){var t=this;t.select(false);t.mainLayer.clear();t._shapesQuadTree.clear();t._initialize()},connect:function(t,e,i){var n;if(this.connectionsDataSource&&this._isEditable){var s=this.connectionsDataSource.add({});n=this._connectionsDataMap[s.uid];n.source(t);n.target(e);n.redraw(i);n.updateModel()}else{n=new Yt(t,e,c({},this.options.connectionDefaults,i));this.addConnection(n)}return n},connected:function(t,e){for(var i=0;i<this.connections.length;i++){var n=this.connections[i];if(n.from==t&&n.to==e)return true}return false},addConnection:function(t,e){if(e!==false)this.undoRedoService.add(new h.AddConnectionUnit(t,this),false);t.diagram=this;t._setOptionsFromModel();t.refresh();this.mainLayer.append(t.visual);this.connections.push(t);this.trigger(Q,{added:[t],removed:[]});return t},_addConnection:function(t,e){var i=this.connectionsDataSource;var n;if(i&&this._isEditable){n=ce(i,ae(t.dataItem));t.dataItem=n;t.updateModel();if(!this.trigger("add",{connection:t})){this._connectionsDataMap[n.uid]=t;i.add(n);this.addConnection(t,e);t._updateConnectors();return t}}else if(!this.trigger("add",{connection:t})){this.addConnection(t,e);t._updateConnectors();return t}},addShape:function(t,e){var i,n=this.options.shapeDefaults;if(t instanceof d){i=t;this._parseBounds(i.bounds())}else if(!(t instanceof kendo.Class)){n=c({},n,t||{});i=new d(n,this);this._parseBounds(i.bounds())}else return;if(e!==false)this.undoRedoService.add(new h.AddShapeUnit(i,this),false);this.shapes.push(i);if(i.diagram!==this){this._shapesQuadTree.insert(i);i.diagram=this}this.mainLayer.append(i.visual);this.trigger(Q,{added:[i],removed:[]});return i},_addShape:function(t,e){var i=this;var n=i.dataSource;var s;if(n&&this._isEditable){s=ce(n,ae(t.dataItem));t.dataItem=s;t.updateModel();if(!this.trigger("add",{shape:t})){this.dataSource.add(s);var r=this._inactiveShapeItems.getByUid(s.uid);r.element=t;r.undoable=e;return t}}else if(!this.trigger("add",{shape:t}))return this.addShape(t,e)},_parseBounds:function(t){t.x=typeof t.x=="string"?parseFloat(t.x):t.x;t.y=typeof t.y=="string"?parseFloat(t.y):t.y},remove:function(t,e){t=K(t)?t.slice(0):[t];var i=he(t);var n=i.shapes;var s=i.connections;var r;if(!o(e))e=true;if(e)this.undoRedoService.begin();this._suspendModelRefresh();for(r=n.length-1;r>=0;r--)this._removeItem(n[r],e,s);for(r=s.length-1;r>=0;r--)this._removeItem(s[r],e);this._resumeModelRefresh();if(e)this.undoRedoService.commit(false);this.trigger(Q,{added:[],removed:t})},_removeShapeDataItem:function(t){if(this._isEditable){this.dataSource.remove(t.dataItem);delete this._dataMap[t.dataItem.id]}},_removeConnectionDataItem:function(t){if(this._isEditable){this.connectionsDataSource.remove(t.dataItem);delete this._connectionsDataMap[t.dataItem.uid]}},_triggerRemove:function(t){var e=[];var i,n,s;for(var r=0;r<t.length;r++){i=t[r];s=i.options.editable;if(i instanceof d)n={shape:i};else n={connection:i};if(s&&s.remove!==false&&!this.trigger("remove",n))e.push(i)}return e},undo:function(){this.undoRedoService.undo()},redo:function(){this.undoRedoService.redo()},select:function(t,e){if(q(t)){e=c({addToSelection:false},e);var i=e.addToSelection,n=[],s=[],r,o;if(!i)this.deselect();this._internalSelection=true;if(t instanceof Array)n=t;else if(t instanceof Wt)n=[t];for(r=0;r<n.length;r++){o=n[r];if(o.select(true))s.push(o)}this._selectionChanged(s,[]);this._internalSelection=false}else return this._selectedItems},selectAll:function(){this.select(this.shapes.concat(this.connections))},selectArea:function(t){var e,i,n;this._internalSelection=true;var s=[];if(t instanceof u){i=this.shapes.concat(this.connections);for(e=0;e<i.length;e++){n=i[e];if((!t||n._hitTest(t))&&n.options.enable)if(n.select(true))s.push(n)}}this._selectionChanged(s,[]);this._internalSelection=false},deselect:function(t){this._internalSelection=true;var e=[],i=[],n,s;if(t instanceof Array)i=t;else if(t instanceof Wt)i.push(t);else if(!q(t))i=this._selectedItems.slice(0);for(s=0;s<i.length;s++){n=i[s];if(n.select(false))e.push(n)}this._selectionChanged([],e);this._internalSelection=false},toFront:function(t,e){if(!t)t=this._selectedItems.slice();var i=this._getDiagramItems(t),n;if(!o(e)||e){n=Kt(this.mainLayer,i.visuals);var s=new V(this,t,n);this.undoRedoService.add(s)}else{this.mainLayer.toFront(i.visuals);this._fixOrdering(i,true)}},toBack:function(t,e){if(!t)t=this._selectedItems.slice();var i=this._getDiagramItems(t),n;if(!o(e)||e){n=Kt(this.mainLayer,i.visuals);var s=new U(this,t,n);this.undoRedoService.add(s)}else{this.mainLayer.toBack(i.visuals);this._fixOrdering(i,false)}},bringIntoView:function(t,e){var i=this.viewport();var n=new h.RectAlign(i);var s,r,o,a;if(i.width===0||i.height===0)return;e=c({animate:false,align:"center middle"},e);if(e.align=="none")e.align="center middle";if(t instanceof Wt)r=t.bounds(It);else if(K(t))r=this.boundingBox(t);else if(t instanceof u)r=t.clone();o=r.clone();r.zoom(this._zoom);if(r.width>i.width||r.height>i.height){this._zoom=this._getValidZoom(m.min(i.width/o.width,i.height/o.height));r=o.clone().zoom(this._zoom)}this._zoomMainLayer();s=r.clone();n.align(r,e.align);a=r.topLeft().minus(s.topLeft());this.pan(a.times(-1),e.animate)},alignShapes:function(t){if(G(t))t="Left";var e=this.select(),i,n,s;if(e.length===0)return;switch(t.toLowerCase()){case"left":case"top":i=Tt;break;case"right":case"bottom":i=Mt;break}for(s=0;s<e.length;s++){n=e[s];if(n instanceof d)switch(t.toLowerCase()){case"left":i=m.min(i,n.options.x);break;case"top":i=m.min(i,n.options.y);break;case"right":i=m.max(i,n.options.x);break;case"bottom":i=m.max(i,n.options.y);break}}var r=[];var o=[];for(s=0;s<e.length;s++){n=e[s];if(n instanceof d){o.push(n);r.push(n.bounds());switch(t.toLowerCase()){case"left":case"right":n.position(new v(i,n.options.y));break;case"top":case"bottom":n.position(new v(n.options.x,i));break}}}var a=new h.TransformUnit(o,r);this.undoRedoService.add(a,false)},zoom:function(t,e){if(t){var i=e?e.point:new h.Point(0,0);t=this._zoom=this._getValidZoom(t);if(!G(i)){i=new h.Point(m.round(i.x),m.round(i.y));var n=i.times(t);var s=this.modelToView(i);var r=s.minus(n);this._storePan(new h.Point(m.round(r.x),m.round(r.y)))}if(e)e.zoom=t;this._panTransform();this.canvas.surface.hideTooltip();this._updateAdorners()}return this._zoom},_getPan:function(t){var e=this.canvas;if(!e.translate)t=t.plus(this._pan);return t},pan:function(t,e){if(t instanceof v){var i=this;var n=i.scroller;t=i._getPan(t);t=t.times(-1);if(e)n.animatedScrollTo(t.x,t.y,function(){i._updateAdorners()});else{n.scrollTo(t.x,t.y);i._updateAdorners()}}else return this._pan.times(-1)},viewport:function(){var t=this.element;var e=t.width();var i=t.height();if(this.toolBar)i-=y(this.toolBar.element);return new u(0,0,e,i)},copy:function(){if(this.options.copy.enabled){this._clipboard=[];this._copyOffset=1;for(var t=0;t<this._selectedItems.length;t++){var e=this._selectedItems[t];this._clipboard.push(e)}}},cut:function(){if(this.options.copy.enabled){this._clipboard=[];this._copyOffset=0;for(var t=0;t<this._selectedItems.length;t++){var e=this._selectedItems[t];this._clipboard.push(e)}this.remove(this._clipboard,true)}},paste:function(){if(this._clipboard.length>0){var t,e,i;var n={};var s=he(this._clipboard);var r=s.connections;var o=s.shapes;var a={x:this._copyOffset*this.options.copy.offsetX,y:this._copyOffset*this.options.copy.offsetY};this.deselect();for(i=0;i<o.length;i++){t=o[i];e=t.clone();n[t.id]=e;e.position(new v(t.options.x+a.x,t.options.y+a.y));e.diagram=this;e=this._addShape(e);if(e)e.select()}for(i=0;i<r.length;i++){t=r[i];e=this._addConnection(t.clone());if(e){this._updateCopiedConnection(e,t,"source",n,a);this._updateCopiedConnection(e,t,"target",n,a);e.select(true);e.updateModel()}}this._syncChanges();this._copyOffset+=1}},_updateCopiedConnection:function(e,t,i,n,s){var r,o,a;var h=t[i]();var c=this;if(h instanceof Xt&&n[h.shape.id]){a=n[h.shape.id];if(c.getShapeById(a.id))e[i](a.getConnector(h.options.name));else{o=c._inactiveShapeItems.getByUid(a.dataItem.uid);if(o){r=function(t){a=c._dataMap[t.id];e[i](a.getConnector(h.options.name));e.updateModel()};c._deferredConnectionUpdates.push(o.onActivate(r))}}}else e[i](new v(t[i+"Point"]().x+s.x,t[i+"Point"]().y+s.y))},boundingBox:function(t,e){var i=u.empty(),n,s=q(t)?this._getDiagramItems(t):{shapes:this.shapes};if(s.shapes.length>0){var r=s.shapes[0];i=r.bounds(Pt);for(var o=1;o<s.shapes.length;o++){r=s.shapes[o];n=r.bounds(Pt);if(e===true){n.x-=r._rotationOffset.x;n.y-=r._rotationOffset.y}i=i.union(n)}}return i},_containerOffset:function(){var t=this.element.offset();if(this.toolBar)t.top+=y(this.toolBar.element);return t},documentToView:function(t){var e=this._containerOffset();return new v(t.x-e.left,t.y-e.top)},viewToDocument:function(t){var e=this._containerOffset();return new v(t.x+e.left,t.y+e.top)},viewToModel:function(t){return this._transformWithMatrix(t,this._matrixInvert)},modelToView:function(t){return this._transformWithMatrix(t,this._matrix)},modelToLayer:function(t){return this._transformWithMatrix(t,this._layerMatrix)},layerToModel:function(t){return this._transformWithMatrix(t,this._layerMatrixInvert)},documentToModel:function(t){var e=this.documentToView(t);if(!this.canvas.translate){e.x=e.x+this.scroller.scrollLeft;e.y=e.y+this.scroller.scrollTop}return this.viewToModel(e)},modelToDocument:function(t){return this.viewToDocument(this.modelToView(t))},_transformWithMatrix:function(t,e){var i=t;if(t instanceof v){if(e)i=e.apply(t)}else{var n=this._transformWithMatrix(t.topLeft(),e),s=this._transformWithMatrix(t.bottomRight(),e);i=u.fromPoints(n,s)}return i},setDataSource:function(t){this.options.dataSource=t;this._dataSource();if(this.options.autoBind)this.dataSource.fetch()},setConnectionsDataSource:function(t){this.options.connectionsDataSource=t;this._connectionDataSource();if(this.options.autoBind)this.connectionsDataSource.fetch()},layout:function(t){this._layouting=true;var e;if(G(t))t=this.options.layout;if(G(t)||G(t.type))e="Tree";else e=t.type;var i;switch(e.toLowerCase()){case"tree":i=new h.TreeLayout(this);break;case"layered":i=new h.LayeredLayout(this);break;case"forcedirected":case"force":case"spring":case"springembedder":i=new h.SpringLayout(this);break;default:throw"Layout algorithm '"+e+"' is not supported."}var n=new h.LayoutState(this);var s=i.layout(t);if(s){var r=new h.LayoutUndoUnit(n,s,t?t.animate:null);this.undoRedoService.add(r)}this._layouting=false;this._redrawConnections()},getShapeById:function(e){var t;t=l.first(this.shapes,function(t){return t.visual.id===e});if(t)return t;t=l.first(this.connections,function(t){return t.visual.id===e});return t},getShapeByModelId:function(e){var t;if(this._isEditable)t=this._dataMap[e];else t=l.first(this.shapes,function(t){return(t.dataItem||{}).id===e});return t},getShapeByModelUid:function(e){var t;if(this._isEditable)t=l.first(this.shapes,function(t){return(t.dataItem||{}).uid===e});else t=this._dataMap[e];return t},getConnectionByModelId:function(e){var t;if(this.connectionsDataSource)t=l.first(this.connections,function(t){return(t.dataItem||{}).id===e});return t},getConnectionByModelUid:function(t){var e;if(this.connectionsDataSource)e=this._connectionsDataMap[t];return e},_extendLayoutOptions:function(t){if(t.layout)t.layout=c({},h.LayoutBase.fn.defaultOptions||{},t.layout)},_selectionChanged:function(t,e){if(t.length||e.length)this.trigger(dt,{selected:t,deselected:e})},_getValidZoom:function(t){return m.min(m.max(t,this.options.zoomMin),this.options.zoomMax)},_panTransform:function(t){var e=this,i=t||e._pan;if(e.canvas.translate){e.scroller.scrollTo(i.x,i.y);e._zoomMainLayer()}else{e._storePan(i);e._transformMainLayer()}},_finishPan:function(){this.trigger(ft,{total:this._pan,delta:Number.NaN})},_storePan:function(t){this._pan=t;this._storeViewMatrix()},_zoomMainLayer:function(){var t=this._zoom;var e=new k(0,0,t,t);e.render(this.mainLayer);this._storeLayerMatrix(e);this._storeViewMatrix()},_transformMainLayer:function(){var t=this._pan,e=this._zoom;var i=new k(t.x,t.y,e,e);i.render(this.mainLayer);this._storeLayerMatrix(i);this._storeViewMatrix()},_storeLayerMatrix:function(t){this._layerMatrix=t.toMatrix();this._layerMatrixInvert=t.invert().toMatrix()},_storeViewMatrix:function(){var t=this._pan,e=this._zoom;var i=new k(t.x,t.y,e,e);this._matrix=i.toMatrix();this._matrixInvert=i.invert().toMatrix()},_toIndex:function(t,e){var i=this._getDiagramItems(t);this.mainLayer.toIndex(i.visuals,e);this._fixOrdering(i,false)},_fixOrdering:function(t,e){var i=e?this.shapes.length-1:0,n=e?this.connections.length-1:0,s,r;for(s=0;s<t.shapes.length;s++){r=t.shapes[s];l.remove(this.shapes,r);l.insert(this.shapes,r,i)}for(s=0;s<t.cons.length;s++){r=t.cons[s];l.remove(this.connections,r);l.insert(this.connections,r,n)}},_getDiagramItems:function(t){var e,i={},n=t;i.visuals=[];i.shapes=[];i.cons=[];if(!t)n=this._selectedItems.slice();else if(!K(t))n=[t];for(e=0;e<n.length;e++){var s=n[e];if(s instanceof d){i.shapes.push(s);i.visuals.push(s.visual)}else if(s instanceof Yt){i.cons.push(s);i.visuals.push(s.visual)}}return i},_removeItem:function(t,e,i){t.select(false);if(t instanceof d){this._removeShapeDataItem(t);this._removeShape(t,e,i)}else if(t instanceof Yt){this._removeConnectionDataItem(t);this._removeConnection(t,e)}this.mainLayer.remove(t.visual)},_removeShape:function(t,e,i){var n,s,r,o=[],a=[];this.toolService._removeHover();if(e)this.undoRedoService.addCompositeItem(new M(t));l.remove(this.shapes,t);this._shapesQuadTree.remove(t);for(n=0;n<t.connectors.length;n++){r=t.connectors[n];for(var h=0;h<r.connections.length;h++){s=r.connections[h];if(!i||!p.inArray(s,i))if(s.sourceConnector==r)o.push(s);else if(s.targetConnector==r)a.push(s)}}for(n=0;n<o.length;n++){o[n].source(null,e);o[n].updateModel()}for(n=0;n<a.length;n++){a[n].target(null,e);a[n].updateModel()}},_removeConnection:function(t,e){if(t.sourceConnector)l.remove(t.sourceConnector.connections,t);if(t.targetConnector)l.remove(t.targetConnector.connections,t);if(e)this.undoRedoService.addCompositeItem(new D(t));l.remove(this.connections,t)},_removeDataItems:function(t,e){var i,n,s,r;t=K(t)?t:[t];while(t.length){i=t.shift();s=this._dataMap[i.uid];if(s){this._removeShapeConnections(s);this._removeItem(s,false);delete this._dataMap[i.uid];if(e&&i.hasChildren&&i.loaded()){n=i.children.data();for(r=0;r<n.length;r++)t.push(n[r])}}}},_removeShapeConnections:function(t){var e=t.connections();var i;if(e)for(i=0;i<e.length;i++)this._removeItem(e[i],false)},_addDataItem:function(t,e){if(!o(t))return;var i=this._dataMap[t.id];if(i)return i;var n=c({},this.options.shapeDefaults);n.dataItem=t;i=new d(n,this);this.addShape(i,e!==false);this._dataMap[t.id]=i;return i},_addDataItemByUid:function(t){if(!o(t))return;var e=this._dataMap[t.uid];if(e)return e;var i=c({},this.options.shapeDefaults);i.dataItem=t;e=new d(i,this);this.addShape(e);this._dataMap[t.uid]=e;return e},_addDataItems:function(t,e){var i,n,s,r,o;for(n=0;n<t.length;n++){i=t[n];s=this._addDataItemByUid(i);r=this._addDataItemByUid(e);if(r&&!this.connected(r,s))o=this.connect(r,s)}},_refreshSource:function(t){var e=this,i=t.node,n=t.action,s=t.items,r=e.options,o,a;if(t.field){for(o=0;o<s.length;o++)if(this._dataMap[s[o].uid])this._dataMap[s[o].uid].redrawVisual();return}if(n=="remove")this._removeDataItems(t.items,true);else{if((!n||n==="itemloaded")&&!this._bindingRoots){this._bindingRoots=true;a=true}if(!n&&!i)e.clear();this._addDataItems(s,i);for(o=0;o<s.length;o++)s[o].load()}if(r.layout&&(a||n=="remove"||n=="add"))e.layout(r.layout);if(a){this.trigger("dataBound");this._bindingRoots=false}},_addItem:function(t){if(t instanceof d)this.addShape(t);else if(t instanceof Yt)this.addConnection(t)},_createToolBar:function(l){var t=this.toolService.diagram;if(!this.singleToolBar&&t.select().length===1){var e=t.select()[0];if(e&&e.options.editable!==false){var i=e.options.editable;var n=i.tools;if(this._isEditable&&n.length===0){if(e instanceof d)n=["edit","rotateClockwise","rotateAnticlockwise"];else if(e instanceof Yt)n=["edit"];if(i&&i.remove!==false)n.push("delete")}if(n&&n.length){var s=20;var r;this.singleToolBar=new Zt(t,{tools:n,click:this._toolBarClick.bind(this),modal:true,popupZIndex:parseInt(t.element.closest(".k-window").css("zIndex"),10)+10});var o=g(this.singleToolBar._popup.element);var a=y(this.singleToolBar._popup.element);if(e instanceof d){var h=this.modelToView(e.bounds(Pt));r=new v(h.x,h.y).minus(new v((o-h.width)/2,a+s))}else if(e instanceof Yt){var c=this.modelToView(e.bounds());r=new v(c.x,c.y).minus(new v((o-c.width-20)/2,a+s))}if(r){if(!this.canvas.translate)r=r.minus(new v(this.scroller.scrollLeft,this.scroller.scrollTop));r=this.viewToDocument(r);r=new v(m.max(r.x,0),m.max(r.y,0));this.singleToolBar.showAt(r);if(l)this.singleToolBar._popup.one("close",fe)}else this._destroyToolBar()}}}},_toolBarClick:function(t){this.trigger("toolBarClick",t);this._destroyToolBar()},_normalizePointZoom:function(t){return t.times(1/this.zoom())},_initialize:function(){this.shapes=[];this._selectedItems=[];this.connections=[];this._dataMap={};this._connectionsDataMap={};this._inactiveShapeItems=new ne;this._deferredConnectionUpdates=[];this.undoRedoService=new e({undone:this._syncHandler,redone:this._syncHandler});this.id=h.randomId()},_fetchFreshData:function(){var t=this;t._dataSource();if(t._isEditable)t._connectionDataSource();if(t.options.autoBind)if(t._isEditable){this._loadingShapes=true;this._loadingConnections=true;t.dataSource.fetch();t.connectionsDataSource.fetch()}else t.dataSource.fetch()},_dataSource:function(){if(o(this.options.connectionsDataSource)){this._isEditable=true;var t=this.options.dataSource||{};var e=K(t)?{data:t}:t;if(this.dataSource&&this._shapesRefreshHandler)this.dataSource.unbind("change",this._shapesRefreshHandler).unbind("requestStart",this._shapesRequestStartHandler).unbind("error",this._shapesErrorHandler);else{this._shapesRefreshHandler=this._refreshShapes.bind(this);this._shapesRequestStartHandler=this._shapesRequestStart.bind(this);this._shapesErrorHandler=this._error.bind(this)}this.dataSource=kendo.data.DataSource.create(e).bind("change",this._shapesRefreshHandler).bind("requestStart",this._shapesRequestStartHandler).bind("error",this._shapesErrorHandler)}else{this._treeDataSource();this._isEditable=false}},_connectionDataSource:function(){var t=this.options.connectionsDataSource;if(t){var e=K(t)?{data:t}:t;if(this.connectionsDataSource&&this._connectionsRefreshHandler)this.connectionsDataSource.unbind("change",this._connectionsRefreshHandler).unbind("requestStart",this._connectionsRequestStartHandler).unbind("error",this._connectionsErrorHandler);else{this._connectionsRefreshHandler=this._refreshConnections.bind(this);this._connectionsRequestStartHandler=this._connectionsRequestStart.bind(this);this._connectionsErrorHandler=this._connectionsError.bind(this)}this.connectionsDataSource=kendo.data.DataSource.create(e).bind("change",this._connectionsRefreshHandler).bind("requestStart",this._connectionsRequestStartHandler).bind("error",this._connectionsErrorHandler)}},_shapesRequestStart:function(t){if(t.type=="read")this._loadingShapes=true},_connectionsRequestStart:function(t){if(t.type=="read")this._loadingConnections=true},_error:function(){this._loadingShapes=false},_connectionsError:function(){this._loadingConnections=false},_refreshShapes:function(t){if(t.action==="remove"){if(this._shouldRefresh())this._removeShapes(t.items)}else if(t.action==="itemchange"){if(this._shouldRefresh())this._updateShapes(t.items,t.field)}else if(t.action==="add")this._inactiveShapeItems.add(t.items);else if(t.action==="sync")this._syncShapes(t.items);else this.refresh()},_shouldRefresh:function(){return!this._suspended},_suspendModelRefresh:function(){this._suspended=(this._suspended||0)+1},_resumeModelRefresh:function(){this._suspended=m.max((this._suspended||0)-1,0)},refresh:function(){this._loadingShapes=false;if(!this._loadingConnections)this._rebindShapesAndConnections()},_rebindShapesAndConnections:function(){this.clear();this._addShapes(this.dataSource.view());if(this.connectionsDataSource)this._addConnections(this.connectionsDataSource.view(),false);if(this.options.layout)this.layout(this.options.layout);else this._redrawConnections();this.trigger("dataBound")},refreshConnections:function(){this._loadingConnections=false;if(!this._loadingShapes)this._rebindShapesAndConnections()},_redrawConnections:function(){var t=this.connections;for(var e=0;e<t.length;e++)t[e].refresh()},_removeShapes:function(t){var e=this._dataMap;var i,n;for(n=0;n<t.length;n++){i=t[n];if(e[i.id]){this.remove(e[i.id],false);e[i.id]=null}}},_syncShapes:function(){var n=this;var s=n._inactiveShapeItems;s.forEach(function(t){var e=t.dataItem;var i=t.element;if(!e.isNew()){if(i){i._setOptionsFromModel();n.addShape(i,t.undoable);n._dataMap[e.id]=i}else n._addDataItem(e);t.activate();s.remove(e)}})},_updateShapes:function(t,e){for(var i=0;i<t.length;i++){var n=t[i];var s=this._dataMap[n.id];if(s)s.updateOptionsFromModel(n,e)}},_addShapes:function(t){for(var e=0;e<t.length;e++)this._addDataItem(t[e],false)},_refreshConnections:function(t){if(t.action==="remove"){if(this._shouldRefresh())this._removeConnections(t.items)}else if(t.action==="add")this._addConnections(t.items);else if(t.action==="sync");else if(t.action==="itemchange"){if(this._shouldRefresh())this._updateConnections(t.items)}else this.refreshConnections()},_removeConnections:function(t){for(var e=0;e<t.length;e++){this.remove(this._connectionsDataMap[t[e].uid],false);this._connectionsDataMap[t[e].uid]=null}},_updateConnections:function(t){for(var e=0;e<t.length;e++){var i=t[e];var n=this._connectionsDataMap[i.uid];n.updateOptionsFromModel(i)}},_addConnections:function(t,e){var i=t.length;for(var n=0;n<i;n++){var s=t[n];this._addConnectionDataItem(s,e)}},_addConnectionDataItem:function(t,e){if(!this._connectionsDataMap[t.uid]){var i=this._validateConnector(t.from);if(!o(i)||i===null)i=new v(t.fromX,t.fromY);var n=this._validateConnector(t.to);if(!o(n)||n===null)n=new v(t.toX,t.toY);if(o(i)&&o(n)){var s=c({},this.options.connectionDefaults);s.dataItem=t;var r=new Yt(i,n,s);this._connectionsDataMap[t.uid]=r;this.addConnection(r,e)}}},_validateConnector:function(t){var e;if(o(t)&&t!==null)e=this._dataMap[t];return e},_treeDataSource:function(){var t=this,e=t.options,i=e.dataSource;i=K(i)?{data:i}:i;if(i instanceof kendo.data.DataSource&&!(i instanceof kendo.data.HierarchicalDataSource))throw new Error("Incorrect DataSource type. If a single dataSource instance is set to the diagram then it should be a HierarchicalDataSource. You should set only the options instead of an instance or a HierarchicalDataSource instance or supply connectionsDataSource as well.");if(!i.fields)i.fields=[{field:"text"},{field:"url"},{field:"spriteCssClass"},{field:"imageUrl"}];if(t.dataSource&&t._refreshHandler)t._unbindDataSource();t._refreshHandler=t._refreshSource.bind(t);t._errorHandler=t._error.bind(t);t.dataSource=w.create(i).bind(Q,t._refreshHandler).bind(st,t._errorHandler)},_unbindDataSource:function(){var t=this;t.dataSource.unbind(Q,t._refreshHandler).unbind(st,t._errorHandler)},_adorn:function(t,e){if(e!==f&&t)if(e){this._adorners.push(t);this.adornerLayer.append(t.visual)}else{l.remove(this._adorners,t);this.adornerLayer.remove(t.visual)}},_showConnectors:function(t,e){if(e)this._connectorsAdorner.show(t);else this._connectorsAdorner.destroy()},_updateAdorners:function(){var t=this._adorners;for(var e=0;e<t.length;e++){var i=t[e];if(i.refreshBounds)i.refreshBounds();i.refresh()}},_refresh:function(){for(var t=0;t<this.connections.length;t++)this.connections[t].refresh()},_destroyToolBar:function(){if(this.singleToolBar){this.singleToolBar.hide();this.singleToolBar.destroy();this.singleToolBar=null}},_destroyGlobalToolBar:function(){if(this.toolBar){this.toolBar.hide();this.toolBar.destroy();this.toolBar=null}},exportDOMVisual:function(){var t=this.canvas._viewBox;var e=a.transform().translate(-t.x,-t.y);var i=new a.Rect([0,0],[t.width,t.height]);var n=_.Path.fromRect(i);var s=new _.Group({transform:e});var r=new _.Group({clip:n});var o=this.canvas.drawingElement.children[0];r.append(s);s.children.push(o);return r},exportVisual:function(){var t=a.transform().scale(1/this._zoom);var e=new _.Group({transform:t});var i=this.mainLayer.drawingElement;e.children.push(i);return e},_syncChanges:function(){this._syncShapeChanges();this._syncConnectionChanges()},_syncShapeChanges:function(){if(this.dataSource&&this._isEditable)this.dataSource.sync()},_syncConnectionChanges:function(){var t=this;if(t.connectionsDataSource&&t._isEditable){s.when.apply(s,t._deferredConnectionUpdates).then(function(){t.connectionsDataSource.sync()});t.deferredConnectionUpdates=[]}}});if(p.ExportMixin.extend(jt.fn,true),kendo.PDFMixin)kendo.PDFMixin.extend(jt.fn);function Jt(t){var e={};t=t||{};if(o(t.text)&&t.text!==null)e.text=t.text;if(o(t.x)&&t.x!==null)e.x=t.x;if(o(t.y)&&t.y!==null)e.y=t.y;if(o(t.width)&&t.width!==null)e.width=t.width;if(o(t.height)&&t.height!==null)e.height=t.height;if(o(t.type)&&t.type!==null)e.type=t.type;return e}function Qt(t){var e={};t=t||{};if(o(t.text)&&t.text!==null)e.content=t.text;if(o(t.type)&&t.type!==null)e.type=t.type;if(o(t.from)&&t.from!==null)e.from=t.from;if(o(t.fromConnector)&&t.fromConnector!==null)e.fromConnector=t.fromConnector;if(o(t.fromX)&&t.fromX!==null)e.fromX=t.fromX;if(o(t.fromY)&&t.fromY!==null)e.fromY=t.fromY;if(o(t.to)&&t.to!==null)e.to=t.to;if(o(t.toConnector)&&t.toConnector!==null)e.toConnector=t.toConnector;if(o(t.toX)&&t.toX!==null)e.toX=t.toX;if(o(t.toY)&&t.toY!==null)e.toY=t.toY;return e}var Zt=kendo.Observable.extend({init:function(t,e){kendo.Observable.fn.init.call(this);this.diagram=t;this.options=c({},this.options,e);this._tools=[];this.createToolBar();this.createTools();this.appendTools();if(this.options.modal)this.createPopup();this.bind(this.events,e)},events:["click"],createPopup:function(){this.container=s("<div/>").append(this.element);this._popup=this.container.kendoPopup({}).getKendoPopup()},appendTools:function(){for(var t=0;t<this._tools.length;t++){var e=this._tools[t];if(e.buttons&&e.buttons.length||!o(e.buttons))this._toolBar.add(e)}},createToolBar:function(){this.element=s("<div/>");this._toolBar=this.element.kendoToolBar({click:this.click.bind(this),resizable:false}).getKendoToolBar();this.element.css("border","none")},createTools:function(){for(var t=0;t<this.options.tools.length;t++)this.createTool(this.options.tools[t])},createTool:function(t){if(!Y(t))t={name:t};var e=t.name+"Tool";if(this[e])this[e](t);else this._tools.push(c({},t,{attributes:this._setAttributes({action:t.name})}))},showAt:function(t){var e=parseInt(this.options.popupZIndex,10);if(this._popup){this._popup.open(t.x,t.y);if(e)this._popup.wrapper.css("zIndex",e)}},hide:function(){if(this._popup)this._popup.close()},newGroup:function(){return{type:"buttonGroup",buttons:[]}},editTool:function(){this._tools.push({icon:"edit",showText:"overflow",type:"button",text:"Edit",attributes:this._setAttributes({action:"edit"})})},deleteTool:function(){this._tools.push({icon:"close",showText:"overflow",type:"button",text:"Delete",attributes:this._setAttributes({action:"delete"})})},rotateAnticlockwiseTool:function(t){this._appendGroup("rotate");this._rotateGroup.buttons.push({icon:"rotate-left",showText:"overflow",text:"RotateAnticlockwise",group:"rotate",attributes:this._setAttributes({action:"rotateAnticlockwise",step:t.step})})},rotateClockwiseTool:function(t){this._appendGroup("rotate");this._rotateGroup.buttons.push({icon:"rotate-right",attributes:this._setAttributes({action:"rotateClockwise",step:t.step}),showText:"overflow",text:"RotateClockwise",group:"rotate"})},createShapeTool:function(){this._appendGroup("create");this._createGroup.buttons.push({icon:"shape",showText:"overflow",text:"CreateShape",group:"create",attributes:this._setAttributes({action:"createShape"})})},createConnectionTool:function(){this._appendGroup("create");this._createGroup.buttons.push({icon:"connector",showText:"overflow",text:"CreateConnection",group:"create",attributes:this._setAttributes({action:"createConnection"})})},undoTool:function(){this._appendGroup("history");this._historyGroup.buttons.push({icon:"undo",showText:"overflow",text:"Undo",group:"history",attributes:this._setAttributes({action:"undo"})})},redoTool:function(){this._appendGroup("history");this._historyGroup.buttons.push({icon:"redo",showText:"overflow",text:"Redo",group:"history",attributes:this._setAttributes({action:"redo"})})},_appendGroup:function(t){var e="_"+t+"Group";if(!this[e]){this[e]=this.newGroup();this._tools.push(this[e])}},_setAttributes:function(t){var e={};if(t.action)e[kendo.attr("action")]=t.action;if(t.step)e[kendo.attr("step")]=t.step;return e},_getAttributes:function(t){var e={};var i=t.attr(kendo.attr("action"));if(i)e.action=i;var n=t.attr(kendo.attr("step"));if(n)e.step=n;return e},click:function(t){var e=this._getAttributes(s(t.target));var i=e.action;if(i&&this[i])this[i](e);this.trigger("click",this.eventData(i,t.target))},eventData:function(t,e){var i=this.selectedElements(),n=i.length,s=[],r=[],o;for(var a=0;a<n;a++){o=i[a];if(o instanceof d)s.push(o);else r.push(o)}return{shapes:s,connections:r,action:t,target:e}},delete:function(){var t=this.diagram;var e=t._triggerRemove(this.selectedElements());if(e.length){this.diagram.remove(e,true);this.diagram._syncChanges()}},edit:function(){var t=this.selectedElements();if(t.length===1)this.diagram.edit(t[0])},rotateClockwise:function(t){var e=parseFloat(t.step||90);this._rotate(e)},rotateAnticlockwise:function(t){var e=parseFloat(t.step||90);this._rotate(-e)},_rotate:function(t){var e=this.diagram._resizingAdorner;e.angle(e.angle()+t);e.rotate()},selectedElements:function(){return this.diagram.select()},createShape:function(){this.diagram.createShape()},createConnection:function(){this.diagram.createConnection()},undo:function(){this.diagram.undo()},redo:function(){this.diagram.redo()},destroy:function(){this.diagram=null;this.element=null;this.options=null;if(this._toolBar)this._toolBar.destroy();if(this._popup)this._popup.destroy()}}),$t=kendo.Observable.extend({init:function(t,e){kendo.Observable.fn.init.call(this);this.options=r(true,{},this.options,e);this.element=t;this.model=this.options.model;this.fields=this._getFields();this._initContainer();this.createEditable()},options:{editors:{}},_initContainer:function(){this.wrapper=this.element},createEditable:function(){var t=this.options;this.editable=new kendo.ui.Editable(this.wrapper,{fields:this.fields,target:t.target,clearContainer:false,model:this.model})},_isEditable:function(t){return this.model.editable&&this.model.editable(t)},_getFields:function(){var t=[];var e=this.model.fields;for(var i in e){var n={};if(this._isEditable(i)){var s=this.options.editors[i];if(s)n.editor=s;n.field=i;t.push(n)}}return t},end:function(){return this.editable.end()},destroy:function(){this.editable.destroy();this.editable.element.find("["+kendo.attr("container-for")+"]").empty();this.model=this.wrapper=this.element=this.columns=this.editable=null}}),te=$t.extend({init:function(t,e){$t.fn.init.call(this,t,e);this.bind(this.events,this.options);this.open()},events:["update","cancel"],options:{window:{modal:true,resizable:false,draggable:true,title:"Edit",visible:false}},_initContainer:function(){var e=this;this.wrapper=s('<div class="k-popup-edit-form"/>').attr(kendo.attr("uid"),this.model.uid);var t="";if(this.options.template){t+=this._renderTemplate();this.fields=[]}else t+=this._renderFields();t+=this._renderButtons();this.wrapper.append(s('<div class="k-edit-form-container"/>').append(t));this.window=new kendo.ui.Window(this.wrapper.appendTo(this.element),this.options.window);this.window.bind("close",function(t){if(t.userTriggered){t.sender.element.trigger("focus");e._cancelClick(t)}});this._attachButtonEvents()},_renderTemplate:function(){var t=this.options.template;if(typeof t==="string")t=kendo.unescape(t);t=kendo.template(t)(this.model);return t},_renderFields:function(){var t="";for(var e=0;e<this.fields.length;e++){var i=this.fields[e];t+='<div class="k-edit-label"><label for="'+i.field+'">'+(i.field||"")+"</label></div>";if(this._isEditable(i.field))t+="<div "+kendo.attr("container-for")+'="'+i.field+'" class="k-edit-field"></div>'}return t},_renderButtons:function(){var t='<div class="k-edit-buttons">';t+=this._createButton("update");t+=this._createButton("cancel");t+="</div>";return t},_createButton:function(t){return kendo.template(Ut)(Ht[t])},_attachButtonEvents:function(){this._cancelClickHandler=this._cancelClick.bind(this);this.window.element.on(Z+i,"a.k-diagram-cancel",this._cancelClickHandler);this._updateClickHandler=this._updateClick.bind(this);this.window.element.on(Z+i,"a.k-diagram-update",this._updateClickHandler)},_updateClick:function(t){t.preventDefault();this.trigger("update")},_cancelClick:function(t){t.preventDefault();this.trigger("cancel")},open:function(){this.window.center().open()},close:function(){this.window.bind("deactivate",this.destroy.bind(this)).close()},destroy:function(){this.window.close().destroy();this.window.element.off(Z+i,"a.k-diagram-cancel",this._cancelClickHandler);this.window.element.off(Z+i,"a.k-diagram-update",this._updateClickHandler);this._cancelClickHandler=null;this._editUpdateClickHandler=null;this.window=null;$t.fn.destroy.call(this)}});function ee(t,e){var i=this.dataSource.reader.model;if(i){var n=i.fn.fields.text?"text":i.idField;s("<input name='"+e.field+"' />").appendTo(t).kendoDropDownList({dataValueField:i.idField,dataTextField:n,dataSource:this.dataSource.data().toJSON(),optionLabel:" ",valuePrimitive:true})}}function ie(t){this.dataItem=t;this.callbacks=[]}function ne(){this.items={}}ie.fn=ie.prototype={onActivate:function(t){var e=s.Deferred();this.callbacks.push({callback:t,deferred:e});return e},activate:function(){var t=this.callbacks;var e;for(var i=0;i<t.length;i++){e=this.callbacks[i];e.callback(this.dataItem);e.deferred.resolve()}this.callbacks=[]}},ne.fn=ne.prototype={add:function(t){for(var e=0;e<t.length;e++)this.items[t[e].uid]=new ie(t[e])},forEach:function(t){for(var e in this.items)t(this.items[e])},getByUid:function(t){return this.items[t]},remove:function(t){delete this.items[t.uid]}};var se=t.extend({init:function(){this.shapes=[]},_add:function(t,e){this.shapes.push({bounds:e,shape:t});t._quadNode=this},insert:function(t,e){this._add(t,e)},remove:function(t){var e=this.shapes;var i=e.length;for(var n=0;n<i;n++)if(e[n].shape===t){e.splice(n,1);break}},hitTestRect:function(t,e){var i=this.shapes;var n=i.length;for(var s=0;s<n;s++)if(this._testRect(i[s].shape,t)&&!p.inArray(i[s].shape,e))return true},_testRect:function(t,e){var i=t.rotate().angle;var n=t.bounds();var s;if(!i)s=n.overlaps(e);else s=L.rects(e,n,-i);return s}}),re=se.extend({init:function(t){se.fn.init.call(this);this.children=[];this.rect=t},inBounds:function(t){var e=this.rect;var i=e.bottomRight();var n=t.bottomRight();var s=e.x<=t.x&&e.y<=t.y&&n.x<=i.x&&n.y<=i.y;return s},overlapsBounds:function(t){return this.rect.overlaps(t)},insert:function(t,e){var i=false;var n=this.children;var s=n.length;if(this.inBounds(e)){if(!s&&this.shapes.length<4)this._add(t,e);else{if(!s)this._initChildren();for(var r=0;r<n.length;r++)if(n[r].insert(t,e)){i=true;break}if(!i)this._add(t,e)}i=true}return i},_initChildren:function(){var t=this.rect,e=this.children,i=this.shapes,n=t.center(),s=t.width/2,r=t.height/2,o,a;e.push(new re(new u(t.x,t.y,s,r)),new re(new u(n.x,t.y,s,r)),new re(new u(t.x,n.y,s,r)),new re(new u(n.x,n.y,s,r)));for(a=i.length-1;a>=0;a--)for(o=0;o<e.length;o++)if(e[o].insert(i[a].shape,i[a].bounds)){i.splice(a,1);break}},hitTestRect:function(t,e){var i;var n=this.children;var s=n.length;var r=false;if(this.overlapsBounds(t))if(se.fn.hitTestRect.call(this,t,e))r=true;else for(i=0;i<s;i++)if(n[i].hitTestRect(t,e)){r=true;break}return r}}),oe=t.extend({ROOT_SIZE:1e3,init:function(t){var e=this._boundsChange.bind(this);t.bind(J,e);t.bind(ut,e);this.initRoots()},initRoots:function(){this.rootMap={};this.root=new se},clear:function(){this.initRoots()},_boundsChange:function(t){if(t.item._quadNode)t.item._quadNode.remove(t.item);this.insert(t.item)},insert:function(t){var e=t.bounds(Pt);var i=this.ROOT_SIZE;var n=this.getSectors(e);var s=n[0][0];var r=n[1][0];if(this.inRoot(n))this.root.insert(t,e);else{if(!this.rootMap[s])this.rootMap[s]={};if(!this.rootMap[s][r])this.rootMap[s][r]=new re(new u(s*i,r*i,i,i));this.rootMap[s][r].insert(t,e)}},remove:function(t){if(t._quadNode)t._quadNode.remove(t)},inRoot:function(t){return t[0].length>1||t[1].length>1},getSectors:function(t){var e=this.ROOT_SIZE;var i=t.bottomRight();var n=m.floor(i.x/e);var s=m.floor(i.y/e);var r=[[],[]];for(var o=m.floor(t.x/e);o<=n;o++)r[0].push(o);for(var a=m.floor(t.y/e);a<=s;a++)r[1].push(a);return r},hitTestRect:function(t,e){var i=this.getSectors(t);var n,s,r,o;var a;if(this.root.hitTestRect(t,e))return true;for(n=0;n<i[0].length;n++){r=i[0][n];for(s=0;s<i[1].length;s++){o=i[1][s];a=(this.rootMap[r]||{})[o];if(a&&a.hitTestRect(t,e))return true}}return false}});function ae(t){var e=t;if(t instanceof kendo.data.Model){e=t.toJSON();e[t.idField]=t._defaultId}return e}function he(t){var e=[];var i=[];var n,s;for(s=0;s<t.length;s++){n=t[s];if(n instanceof d)i.push(n);else e.push(n)}return{shapes:i,connections:e}}function ce(t,e){if(t.reader.model)return new t.reader.model(e);return new kendo.data.ObservableObject(e)}function le(t,e){if(o(e[t]))e.set(t,null)}function de(t,e,i){var n;for(var s=0;s<i.length;s++){n=i[s];if(e&&!o(e[n]))e[n]=t[n]}}function ue(t){var e=t.drawingContainer().clippedBBox(null);if(e.origin.x!==0||e.origin.y!==0)t.position(-e.origin.x,-e.origin.y)}function fe(t){t.preventDefault()}p.ui.plugin(jt),c(h,{Shape:d,Connection:Yt,Connector:Xt,DiagramToolBar:Zt,QuadNode:re,QuadRoot:se,ShapesQuadTree:oe,PopupEditor:te})})}("function"==typeof define&&define.amd?define:function(t,e,i){(i||e)()}),function(define){define("kendo.dataviz.diagram.min",["kendo.data.min","kendo.draganddrop.min","kendo.userevents.min","kendo.mobile.scroller.min","kendo.drawing.min","./dataviz/diagram/utils.min","./dataviz/diagram/math.min","./dataviz/diagram/svg.min","./dataviz/diagram/services.min","./dataviz/diagram/layout.min","./dataviz/diagram/dom.min"],function(){var t={id:"dataviz.diagram",name:"Diagram",category:"dataviz",description:"The Kendo DataViz Diagram ",depends:["data","userevents","mobile.scroller","draganddrop","drawing","dataviz.core","dataviz.themes","toolbar"],features:[{id:"dataviz.diagram-pdf-export",name:"PDF export",description:"Export Diagram as PDF",depends:["pdf"]},{id:"dataviz.diagram-editing",name:"Editing",description:"Support for model editing",depends:["editable","window","dropdownlist"]}]};return window.kendo})}("function"==typeof define&&define.amd?define:function(t,e,i){(i||e)()});
//# sourceMappingURL=kendo.dataviz.diagram.min.js.map
