﻿/// <reference path="jquery-3.6.1.min.js" />

(function ($) {
    jQuery.sessionTimeout = function (options) {
        var settings = {
            timeout: 30,
            title: 'Expirace přihlášení',
            message: 'Vaše přihlášení vyprší do 1 minuty. Poté dojde k automatickému odhlášení. Neuložené změny budou ztraceny!',
            valueElementId: null,
            appRootUrl: 'http://localhost/ksportal',
            keepAlivePageMethod: '/Public/KeepAlive.aspx/GetSessionTimeout',
            logoutUrl: '/Public/Logout.aspx',
            stayButtonText: 'Zůstat přihlášen',
            logoutButtonText: 'Odhlásit se'
        }
        $.extend(settings, options);

        var timeout = settings.timeout;
        var refresh = 60000;
        var refreshInterval;
        var expCookName = "exr";

        // Create timeout warning dialog
        $('body').append('<div id="sessionTimeout-dialog">' + settings.message + '</div>');
        $("#sessionTimeout-dialog").dialog({
            autoOpen: false,
            modal: true,
            resizable: false,
            draggable: false,
            closeOnEscape: false,
            open: function (event, ui) { $(".ui-dialog-titlebar-close").hide(); },
            title: settings.title,
            buttons: [
            {
                //"Stay In" button
                text: settings.stayButtonText,
                click: function () {
                    $(this).dialog('close');

                    // Restart session timer
                    TimeoutReset();
                }
            },
            {
                //"Log Out" button
                text: settings.logoutButtonText,
                click: function () {
                    Logout();
                }
            }
            ]
        });

        //private methods
        function RefreshValueElement() {
            if (settings.valueElementId) {
                var valueElement = '#' + settings.valueElementId;
                if ($(valueElement).length > 0) {
                    $(valueElement).text(timeout);
                }
            }
        }

        function TimeoutDecrement() {
            /*
            timeout--;
            RefreshValueElement();         
            if (timeout == 1) {
                $('#sessionTimeout-dialog').dialog('open');
            }
            else if (timeout < 1) {
                Logout();
            }
            */

            //PH 21.8.2019 ---------------------------------        
            var d = new Date(KSMaster.getCookie(expCookName));
            var akt_d = new Date();          
            timeout = d.diffMinutes(akt_d);

            RefreshValueElement();
            if (timeout == 1) {
                $('#sessionTimeout-dialog').dialog('open');
            }
            else if (timeout < 1) {
                Logout();
            }
            else if ($('#sessionTimeout-dialog').dialog('isOpen'))
            {               
                $('#sessionTimeout-dialog').dialog('close');
            }
            //---------------------------------------------
        }

        function TimeoutReset() {
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + settings.keepAlivePageMethod,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (result) {
                    timeout = result.d;                   
                    RefreshValueElement();
                    //PH 21.8.2019----------
                    var d = new Date();
                    d = d.addMinutes(timeout);
                    KSMaster.setCookie(expCookName, d);
                    //----------------------
                }
            });

            window.clearInterval(refreshInterval)
            refreshInterval = setInterval(function () { TimeoutDecrement() }, refresh);
        }


        function Logout() {
            var url = KSMaster.baseUrl + settings.logoutUrl;

            // similar behavior as an HTTP redirect
            window.location.replace(url);

            // similar behavior as clicking on a link
            //window.location.href = url;
        }

        //public methods
        this.initialize = function () {
            RefreshValueElement();
            refreshInterval = setInterval(function () { TimeoutDecrement() }, refresh);
            return this;
        };
        this.reset = function () {
            TimeoutReset();
        };

        return this.initialize();
    };
})(jQuery);