/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.timepicker.min",["kendo.popup.min","kendo.dateinput.min","kendo.html.button.min"],function(){var e={id:"timepicker",name:"TimePicker",category:"web",description:"The TimePicker widget allows the end user to select a value from a list of predefined values or to type a new value.",depends:["popup","html.button"]},c=window.kendo.jQuery,d=void 0,w=window.kendo,f=w.keys,a=w.html,u=w.parseDate,i=w._activeElement,n=w._extractFormat,s=w.support,r=s.browser,v=w.ui,_=v.Widget,g="open",k="close",l="change",h=".kendoTimePicker",o="click"+h,x="disabled",T="readonly",S="li",M="<span></span>",V="k-focus",C="k-hover",D="mouseenter"+h+" mouseleave"+h,H="mousedown"+h,L=6e4,I=864e5,R="k-selected",P="k-disabled",A="aria-selected",F="aria-expanded",z="aria-hidden",O="aria-disabled",E="aria-readonly",q="aria-activedescendant",B="id",N=Array.isArray,Y=c.extend,b=Date,W=/d{1,2}|E{1,6}|e{1,6}|c{3,6}|c{1}|M{1,5}|L{1,5}|y{1,4}|H{1,2}|h{1,2}|k{1,2}|K{1,2}|m{1,2}|a{1,5}|s{1,2}|S{1,3}|z{1,4}|Z{1,5}|x{1,5}|X{1,5}|G{1,5}|q{1,5}|Q{1,5}|"[^"]*"|'[^']*'/g,K="literal",t="month",G="hour",j="zone",Q="weekday",U="quarter",X={G:"era",y:"year",q:U,Q:U,M:t,L:t,d:"day",E:Q,c:Q,e:Q,h:G,H:G,k:G,K:G,m:"minute",s:"second",a:"dayperiod",x:j,X:j,z:j,Z:j},Z={month:{type:"months",minLength:3,standAlone:"L"},quarter:{type:"quarters",minLength:3,standAlone:"q"},weekday:{type:"days",minLength:{E:0,c:3,e:3},standAlone:"c"},dayperiod:{type:"dayPeriods",minLength:0},era:{type:"eras",minLength:0}},p=new b,J='<div tabindex="0" class="k-timeselector #=mainSize#">'+'<div class="k-time-header">'+'<span class="k-title"></span>'+'<button class="k-button #=buttonSize# k-rounded-md k-button-flat k-button-flat-base k-time-now" title="Select now" aria-label="Select now"><span class="k-button-text">#=messages.now#</span></button>'+"</div>"+'<div class="k-time-list-container">'+'<span class="k-time-highlight"></span>'+"</div>"+"</div>",$='<div class="k-time-footer k-action-buttons">'+'<button class="k-button #=buttonSize# k-rounded-md k-button-solid k-button-solid-base k-time-cancel" title="Cancel changes" aria-label="Cancel changes"><span class="k-button-text">#=messages.cancel#</span></button>'+'<button class="k-time-accept k-button #=buttonSize# k-rounded-md k-button-solid k-button-solid-primary" title="Set time" aria-label="Set time"><span class="k-button-text">#=messages.set#</span></button>'+"</div>",ee='<span class="k-time-highlight"></span>',te=(p=new Date(p.getFullYear(),p.getMonth(),p.getDate(),0,0,0),function(e){var t=this,i=e.id;t.options=e;t._dates=[];t._createList(e.timeView&&e.timeView.list==="scroll");if(i){t._timeViewID=i+"_timeview";t._optionID=i+"_option_selected";t.ul.attr(B,t._timeViewID)}t._heightHandler=t._height.bind(t);t._popup()});function ie(){var e=new b,t=new b(e.getFullYear(),e.getMonth(),e.getDate(),0,0,0),i=new b(e.getFullYear(),e.getMonth(),e.getDate(),12,0,0);return-1*(t.getTimezoneOffset()-i.getTimezoneOffset())}function y(e){return e.getHours()*60*L+e.getMinutes()*L+e.getSeconds()*1e3+e.getMilliseconds()}function ne(e){var t=new Date(2100,0,1);t.setMinutes(-e);return t}function ae(e,t,i){var n=y(t),a=y(i),s;if(!e||n==a)return true;s=y(e);if(n>s)s+=I;if(a<n)a+=I;return s>=n&&s<=a}te.prototype={_createList:function(e){if(e)this._createScrollList();else this._createClassicRenderingList()},_createScrollList:function(){var e=c.extend({},this.options,{mainSize:w.getValidCssClass("k-timeselector-","size",this.options.size||"medium"),buttonSize:w.getValidCssClass("k-button-","size",this.options.size||"medium")});this.list=c(w.template(J)(e)).on(H,le);if(!this.options.omitPopup)this.list.append(w.template($)(e));this.ul=this.list.find(".k-time-list-container");this.list.on("click"+h,".k-time-header button.k-time-now",this._nowClickHandler.bind(this));this.list.on("click"+h,".k-time-footer button.k-time-cancel",this._cancelClickHandler.bind(this));this.list.on("click"+h,".k-time-footer button.k-time-accept",this._setClickHandler.bind(this));this.list.on("mouseover"+h,".k-time-list-wrapper",this._mouseOverHandler.bind(this));this.list.on("keydown"+h,this._scrollerKeyDownHandler.bind(this))},_scrollerKeyDownHandler:function(e){var t=this,i=e.keyCode,n=c(e.currentTarget).find(".k-time-list-wrapper.k-focus"),a=t.list.find(".k-time-list-wrapper"),s=a.length,r=a.index(n),l=w.support.isRtl(t.wrapper),o=m(n.find(".k-item:visible").eq(0)),u=n.find(".k-time-container.k-content.k-scrollable");if(!n.length)return;if(i==f.RIGHT&&!l||i==f.LEFT&&l){if(r+1<s)t._focusList(a.eq(r+1))}else if(i==f.LEFT&&!l||i==f.RIGHT&&l){if(r-1>=0)t._focusList(a.eq(r-1))}else if(i==f.UP){u.scrollTop(u.scrollTop()-o);e.preventDefault()}else if(i==f.DOWN){u.scrollTop(u.scrollTop()+o);e.preventDefault()}else if(i===f.ENTER)t._setClickHandler();else if(i===f.ESC)t._cancelClickHandler()},_mouseOverHandler:function(e){this._focusList(c(e.currentTarget))},_focusList:function(e){this.list.find(".k-time-list-wrapper").removeClass(V);e.addClass(V);this.list.trigger("focus");this._scrollTop=e.find(".k-scrollable").scrollTop()},_createClassicRenderingList:function(){var e=this;var t=c('<div class="k-list '+w.getValidCssClass("k-list-","size",e.options.size)+'"><ul tabindex="-1" role="listbox" aria-hidden="true" unselectable="on" class="k-list-ul"/></div>');e.ul=t.find("ul").css({overflow:s.kineticScrollNeeded?"":"auto"}).on(o,S,e._click.bind(e)).on("mouseenter"+h,S,function(){c(this).addClass(C)}).on("mouseleave"+h,S,function(){c(this).removeClass(C)});e.list=c("<div class='k-list-container k-list-scroller' unselectable='on'/>").append(t).on(H,le);e.template=w.template('<li tabindex="-1" role="option" class="k-list-item" unselectable="on"><span class="k-list-item-text">#=data#</span></li>',{useWithBlock:false})},current:function(e){var t=this,i=t.options.active;if(e!==d){if(t._current){t._current.removeClass(R);if(t._current&&t._current.length){t._current[0].removeAttribute(B);t._current[0].removeAttribute(A)}}if(e){e=c(e).addClass(R).attr(B,t._optionID).attr(A,true);t.scroll(e[0])}t._current=e;if(i)i(e)}else return t._current},_updateTitle:function(){this.list.find(".k-time-header > .k-title").html(w.toString(this._value,this.options.format,this.options.culture))},applyValue:function(e){if(!e)return;var t=pe(this.options.format.toLowerCase(),"t");var i=e.getHours();var n=e.getMinutes();var c=e.getSeconds();var a;var s=w.attr("index");var r=this.ul.find("["+s+'="1"]');var l=this.ul.find("["+s+'="2"]');var o=this.ul.find("["+s+'="3"]');var u=this.ul.find("["+s+'="4"]');if(t)if(i>=12){a="PM";if(i>12)i-=12}else{a="AM";if(i===0)i=12}this._internalScroll=true;if(r.length)this._scrollListToPosition(r,i);if(l.length)this._scrollListToPosition(l,n);if(o.length)this._scrollListToPosition(o,c);if(u.length)this._scrollListToPosition(u,a);this._internalScroll=false},_scrollListToPosition:function(e,t){var i=e.find('.k-item[data-value="'+ve(t)+'"]');var n=m(i);e.scrollTop(e.find(".k-item:visible").index(i)*n)},close:function(){this.popup.close()},destroy:function(){var e=this;e.ul.off(h);e.list.off(h);if(this.popup)e.popup.destroy()},open:function(){var e=this;var t;if(!e.ul[0].firstChild||e.ul.find("li").length<1)e.bind();t=e.popup._hovered;e.popup._hovered=true;e.popup.open();setTimeout(function(){e.popup._hovered=t},1);if(e._current)e.scroll(e._current[0])},dataBind:function(e){var t=this,i=t.options,n=i.format,a=w.toString,s=t.template,r=e.length,l=0,o,u="";for(;l<r;l++){o=e[l];if(ae(o,i.min,i.max))u+=s(a(o,n,i.culture))}t._html(u)},refresh:function(){var e=this,t=e.options,i=t.format,n=ie(),c=n<0,a=w.parseDate(e._value),d=a?oe(a,t.min):oe(new Date,t.min),f=t.min,h=t.max,s=y(f),r=y(h),p=y(ne(t.interval)),l=t.interval*L,m=w.toString,v=e.template,_=t.useValueToRender?d:new Date(+t.min),g=new b(_),k,o,u="";if(c)o=(I+n*L)/l;else o=I/l;if(s!=r||p===r){if(s>r)r+=I;o=(r-s)/l+1}if(t.timeView&&t.timeView.list==="scroll")u=e._createListContent(me(i));else e.getDatesInRange(k,r,g,h,l,_).forEach(function(e){u+=v(m(e,i,t.culture))});e._html(u)},_showAllHiddenItems:function(){var e=this.list.find(".k-time-container");var t=e.length;var i;for(var n=0;n<t;n++){i=c(e[n]);i.find(".k-item:hidden").show();this._updateListBottomOffset(i)}},_updateListBottomOffset:function(e){var t=m(e.find(".k-item:visible").eq(0));var i=e.outerHeight();var n=i-t;e.find(".k-scrollable-placeholder").css({height:e.find("ul").height()+n})},_updateHoursRange:function(){var n=this;var e=w.attr("index");var t=this.ul.find("["+e+'="1"]');var a=this._minHours;var s=this._maxHours;var i=pe(this.options.format.toLowerCase(),"t");var r;var l;var o=this._findSelectedValue(this.ul.find("["+e+'="4"]'));if(!t.length)return;if(i&&o){if(o==="AM"){if(a<12)l=true;if(s<12)r=true}else if(o==="PM"){if(a>12){l=true;a-=12}if(s>12){r=true;s-=12}}t.find(".k-item").each(function(e,t){t=c(t);var i=+t.attr("data-value");if(n._validateMin&&l&&i<a||n._validateMax&&r&&i>s)t.hide();else t.show()})}else t.find(".k-item").each(function(e,t){t=c(t);var i=+t.attr("data-value");if(n._validateMin&&i<a||n._validateMax&&i>s)t.hide();else t.show()});this._updateListBottomOffset(t)},_updateMinutesRange:function(){var n=this;var e=w.attr("index");var t=this.ul.find("["+e+'="2"]');var a=this._minHours;var s=this._maxHours;var r=this._minMinutes;var l=this._maxMinutes;var o=+this._findSelectedValue(this.ul.find("["+e+'="1"]'));var i=pe(this.options.format.toLowerCase(),"t");var u=this._findSelectedValue(this.ul.find("["+e+'="4"]'));if(i&&u==="PM")o+=12;if(!t.length)return;t.find(".k-item").each(function(e,t){t=c(t);var i=+t.attr("data-value");if(n._validateMin&&i<r&&a&&o===a||n._validateMax&&i>l&&s&&o===s)t.hide();else t.show()});this._updateListBottomOffset(t)},_updateSecondsRange:function(){var n=this;var e=w.attr("index");var t=this.ul.find("["+e+'="3"]');var a=this._minSeconds;var s=this._minSeconds;var r=this._minMinutes;var l=this._maxMinutes;var o=+this._findSelectedValue(this.ul.find("["+e+'="2"]'));if(!t.length)return;t.find(".k-item").each(function(e,t){t=c(t);var i=+t.attr("data-value");if(n._validateMin&&i<a&&r&&o===r||n._validateMax&&i>s&&l&&o===l)t.hide();else t.show()});this._updateListBottomOffset(t)},_updateDesignatorRange:function(){var e=this._minHours;var t=this._maxHours;var i=w.attr("index");var n=this.ul.find("["+i+'="4"]');if(!n.length)return;if(this._validateMin&&e>=12)n.find('.k-item[data-value="AM"]').hide();else n.find('.k-item[data-value="AM"]').show();if(this._validateMax&&t<12)n.find('.k-item[data-value="PM"]').hide();else n.find('.k-item[data-value="PM"]').show()},_updateRanges:function(){if(!this.options.specifiedRange)return;if(!this._currentlySelected)this._currentlySelected=new Date;var e=this.options.max;var t=this.options.min;if(this.options.validateDate){if(e.getFullYear()===this._currentlySelected.getFullYear()&&e.getMonth()===this._currentlySelected.getMonth()&&e.getDate()===this._currentlySelected.getDate())this._validateMax=true;else this._validateMax=false;if(t.getFullYear()===this._currentlySelected.getFullYear()&&t.getMonth()===this._currentlySelected.getMonth()&&t.getDate()===this._currentlySelected.getDate())this._validateMin=true;else this._validateMin=false;if(!this._validateMax&&!this._validateMin){this._showAllHiddenItems();return}}else{this._validateMax=true;this._validateMin=true}this._minMinutes=t.getMinutes();this._maxMinutes=e.getMinutes();this._minHours=t.getHours();this._maxHours=e.getHours();this._minSeconds=t.getSeconds();this._maxSeconds=e.getSeconds();this._updateDesignatorRange();this._updateHoursRange();this._updateMinutesRange();this._updateSecondsRange()},addTranslate:function(){var e=this.ul.find(".k-time-container.k-content.k-scrollable");var t=e.length;var i;var n;var a;var s;var r;var l;for(var o=0;o<t;o++){i=e.eq(o);n=m(i.find(".k-item:visible").eq(0));a=i.outerHeight();s=(a-n)/2;r="translateY("+s+"px)";l=a-n;i.find("ul").css({transform:r,"-ms-transform":r});i.find(".k-scrollable-placeholder").css({height:i.find("ul").height()+l});i.off(h).on("click"+h,".k-item",this._itemClickHandler.bind(this)).on("scroll"+h,this._listScrollHandler.bind(this))}},_nowClickHandler:function(e){e.preventDefault();var t=new Date;this.value(t);this.options.change(w.toString(t,this.options.format,this.options.culture),true)},_cancelClickHandler:function(e){e.preventDefault();this.value(this._value);this.popup.close()},_setClickHandler:function(e){e.preventDefault();this._value=new Date(this._currentlySelected);this.options.change(w.toString(this._currentlySelected,this.options.format,this.options.culture),true);this.popup.close()},_listScrollHandler:function(e){var t=this;var i=m(c(e.currentTarget).find(".k-item:visible").eq(0));if(t._internalScroll)return;if(t._scrollingTimeout)clearTimeout(t._scrollingTimeout);t._scrollingTimeout=setTimeout(function(){if(e.currentTarget.scrollTop%i>1)e.currentTarget.scrollTop+=i-e.currentTarget.scrollTop%i;t._scrollTop=e.currentTarget.scrollTop;t._updateCurrentlySelected();t._updateRanges()},100)},_updateCurrentlySelected:function(){var e=pe(this.options.format.toLowerCase(),"t");var t=w.attr("index");var i=this.ul.find("["+t+'="1"]');var n=this.ul.find("["+t+'="2"]');var a=this.ul.find("["+t+'="3"]');var s=this.ul.find("["+t+'="4"]');var r;var l;var o;var u;if(!this.ul.is(":visible"))return;if(!this._currentlySelected)this._currentlySelected=this._value?new Date(this._value):new Date;if(i.length)r=+this._findSelectedValue(i);if(n.length)l=+this._findSelectedValue(n);if(a.length)o=+this._findSelectedValue(a);if(s.length)u=this._findSelectedValue(s);if(e){if(u=="PM"){r+=12;if(r==24)r=12}if(u==="AM"&&r===12)r=0}if(r!==d)this._currentlySelected.setHours(r);if(l!==d)this._currentlySelected.setMinutes(l);if(o!==d)this._currentlySelected.setSeconds(o)},_findSelectedValue:function(e){var t=_e(e.scrollTop(),m(e.find(".k-item:visible").eq(0)));return e.find(".k-item:visible").eq(t).attr("data-value")},_itemClickHandler:function(e){var t=c(e.originalEvent.currentTarget);var i=t.find(".k-item:visible").index(c(e.currentTarget));var n=m(t.find(".k-item:visible").eq(0));t.scrollTop(i*n)},getDatesInRange:function(e,t,i,n,a,s){var r=[];while(true){if(t&&(y(s)>=t||i.getDate()!=s.getDate())){e=y(s);if(i<s)e+=I;if(e>t)s=new b(+n);if(y(s)>0)r.push(new Date(s));break}if(i.getDate()!=s.getDate())break;r.push(new Date(s));s.setTime(s.getTime()+a);if(!t&&this.options.maxSet)break}return r},_createListContent:function(e){var t=e.length;var i="";var n;var a;for(var s=0;s<t;s++){n=e[s];if(n.type==="literal")i+=this._literalTemplate(n);else{a=this._getValues(n,true);i+=this._itemTemplate(a.values,n,this.options.messages[n.type],a.index)}}return i},_itemTemplate:function(e,t,i,n){var a="";var s=e.length;var r=w.attr("index");a+='<div class="k-time-list-wrapper" role="presentation">'+'<span class="k-title">'+(i||t.type)+"</span>"+'<div class="k-time-list">'+'<div class="k-time-container k-content k-scrollable" role="presentation" '+r+'="'+n+'">'+'<ul class="k-reset">';for(var l=0;l<s;l++)a+='<li class="k-item" data-value="'+e[l]+'">'+"<span>"+e[l]+"</span>"+"</li>";a+="</ul>"+'<div class="k-scrollable-placeholder"></div>'+"</div>"+"</div>"+"</div>";return a},_getValues:function(e,t){var i=[];var n;var a=0;var s;if(e.type==="hour"){a=e.hour12?1:0;n=1;s=e.hour12?12:23}else if(e.type==="minute"){n=2;s=59}else if(e.type==="second"){n=3;s=59}for(;a<=s;a++)i.push(t?ve(a):a);return{values:i,index:n}},_literalTemplate:function(e){var t='<div class="k-time-separator">'+(e.pattern===" tt"?":":e.pattern)+"</div>";if(e.pattern===" tt")t+=this._itemTemplate(["AM","PM"],e,"AM/PM",4);return t},bind:function(){var e=this,t=e.options.dates;if(t&&t[0])e.dataBind(t);else e.refresh()},_html:function(e){var t=this;if(t.options.timeView&&t.options.timeView.list==="scroll"){e=ee+e;t.ul.html(e)}else{t.ul[0].innerHTML=e;t.popup.unbind(g,t._heightHandler);t.popup.one(g,t._heightHandler);t.current(null);t.select(t._value)}},scroll:function(e){if(!e)return;if(e.scrollIntoViewIfNeeded)e.scrollIntoViewIfNeeded();else ge(e)},select:function(t){var e=this,i=e.options,n=e._current,a;if(t instanceof Date)t=w.toString(t,i.format,i.culture);if(typeof t==="string")if(!n||n.text()!==t){t=c.grep(e.ul[0].childNodes,function(e){return(e.textContent||e.innerText)==t});t=t[0]?t:null}else t=n;a=e._distinctSelection(t);e.current(a)},_distinctSelection:function(e){var t=this,i,n;if(e&&e.length>1){i=y(t._value);n=c.inArray(i,t._dates);e=t.ul.children()[n]}return e},setOptions:function(e){var t=this.options;e.min=u(e.min);e.max=u(e.max);this.options=Y(t,e,{active:t.active,change:t.change,close:t.close,open:t.open});this.bind()},toggle:function(){var e=this;if(e.popup.visible())e.close();else e.open()},value:function(e){var t=this;t._value=e;if(t.ul[0].firstChild)if(t.options.timeView&&t.options.timeView.list==="scroll")t.applyValue(e);else t.select(e)},_click:function(e){var t=this,i=c(e.currentTarget),n=i.text(),a=t.options.dates;if(a&&a.length>0)n=a[i.index()];if(!e.isDefaultPrevented()){t.select(i);t.options.change(n,true);t.close()}},_height:function(){var e=this;var t=e.list;var i=t.parent(".k-animation-container");var n=e.options.height;if(e.ul[0].children.length)t.add(i).show().height(e.ul[0].scrollHeight>n?n:"auto").hide()},_parse:function(e){var t=this,i=t.options,n=y(i.min)!=y(p)?i.min:null,a=y(i.max)!=y(p)?i.max:null,s=t._value||n||a||p;if(e instanceof b)return e;e=u(e,i.parseFormats,i.culture);if(e)e=new b(s.getFullYear(),s.getMonth(),s.getDate(),e.getHours(),e.getMinutes(),e.getSeconds(),e.getMilliseconds());return e},_adjustListWidth:function(){var e=this.list,t=e[0].style.width,i=this.options.anchor,n,a,s=w._outerWidth;if(!e.data("width")&&t)return;n=window.getComputedStyle?window.getComputedStyle(i[0],null):0;a=n?parseFloat(n.width):s(i);if(n&&(r.mozilla||r.msie))a+=parseFloat(n.paddingLeft)+parseFloat(n.paddingRight)+parseFloat(n.borderLeftWidth)+parseFloat(n.borderRightWidth);t=a-(s(e)-e.width());e.css({fontFamily:i.css("font-family"),width:t}).data("width",t)},_popup:function(){var e=this,t=e.list,i=e.options,n=i.anchor;if(!this.options.omitPopup)e.popup=new v.Popup(t,Y(i.popup,{anchor:n,open:i.open,close:i.close,animation:i.animation,isRtl:s.isRtl(i.anchor),activate:function(){if(e.options.timeView&&e.options.timeView.list==="scroll"){e.addTranslate();if(e._value)e.applyValue(e._value);else e._updateCurrentlySelected();e._updateRanges();e._focusList(e.list.find(".k-time-list-wrapper").eq(0))}}}));else t.appendTo(i.timeDiv)},move:function(e){var t=this,i=e.keyCode,n=t.ul[0],a=t._current,s=i===f.DOWN;if(i===f.UP||s){if(e.altKey){t.toggle(s);return}else if(s)a=a?a[0].nextSibling:n.firstChild;else a=a?a[0].previousSibling:n.lastChild;if(a)t.select(a);t.options.change(t._current.text());e.preventDefault()}else if(i===f.ENTER||i===f.TAB||i===f.ESC){e.preventDefault();if(a)t.options.change(a.text(),true);t.close()}}},te.getMilliseconds=y,w.TimeView=te;var se=_.extend({init:function(i,e){var n=this,t,a,s;e=e||{};e.componentType=e.componentType||"classic";_.fn.init.call(n,i,e);i=n.element;e=n.options;e.min=u(i.attr("min"))||u(e.min);e.max=u(i.attr("max"))||u(e.max);if(+e.max!=+p||+e.min!=+p)this._specifiedRange=true;re(e);n._initialOptions=Y({},e);n._wrapper();if(n.options.timeView&&n.options.timeView.list==="scroll")n.options.height=null;n.timeView=a=new te(Y({},e,{id:i.attr(B),anchor:n.wrapper,format:e.format,change:function(e,t){if(t)n._change(e);else i.val(e)},open:function(e){if(n.options.timeView&&n.options.timeView.list!=="scroll")n.timeView._adjustListWidth();else n.timeView._updateTitle();if(n.trigger(g))e.preventDefault();else{i.attr(F,true);t.attr(z,false);if(a.current())i.attr(q,a._optionID)}},close:function(e){if(n.trigger(k))e.preventDefault();else{i.attr(F,false);t.attr(z,true);i[0].removeAttribute(q)}},active:function(e){if(i&&i.length)i[0].removeAttribute(q);if(e)i.attr(q,a._optionID)},specifiedRange:n._specifiedRange,maxSet:+e.max!=+p}));t=a.ul;n._ariaLabel(t);n._icon();n._reset();try{i[0].setAttribute("type","text")}catch(e){i[0].type="text"}i.addClass("k-input-inner").attr({role:"combobox","aria-expanded":false,"aria-controls":a._timeViewID,autocomplete:"off"});s=i.is("[disabled]")||c(n.element).parents("fieldset").is(":disabled");if(s)n.enable(false);else n.readonly(i.is("[readonly]"));if(e.dateInput){var r=e.min;var l=e.max;var o=new b;if(y(r)==y(l)){r=new b(o.getFullYear(),o.getMonth(),o.getDate(),0,0,0);l=new b(o.getFullYear(),o.getMonth(),o.getDate(),24,0,0)}n._dateInput=new v.DateInput(i,{culture:e.culture,format:e.format,min:r,max:l,value:e.value,interval:e.interval,size:e.size,fillMode:e.fillMode,rounded:e.rounded})}n._old=n._update(e.value||n.element.val());n._oldText=i.val();n._applyCssClasses();w.notify(n)},options:{name:"TimePicker",min:p,max:p,format:"",dates:[],parseFormats:[],value:null,interval:30,height:200,animation:{},dateInput:false,messages:{set:"Set",cancel:"Cancel",hour:"hour",minute:"minute",second:"second",millisecond:"millisecond",now:"Now"},componentType:"classic",size:"medium",fillMode:"solid",rounded:"medium"},events:[g,k,l],componentTypes:{classic:{timeView:{list:"list"}},modern:{timeView:{list:"scroll"}}},setOptions:function(e){var t=this;var i=t._value;_.fn.setOptions.call(t,e);e=t.options;if(+e.max!=+p||+e.min!=+p)this._specifiedRange=true;t._arrow.off(h);t._arrow.remove();re(e);t.timeView.setOptions(e);t._icon();t._editable(e);if(i)t.element.val(w.toString(i,e.format,e.culture))},dataBind:function(e){if(N(e))this.timeView.dataBind(e)},_editable:function(e){var t=this,i=e.disable,n=e.readonly,a=t._arrow.off(h),s=t.element.off(h),r=t.wrapper.off(h);if(t._dateInput)t._dateInput._unbindInput();if(!n&&!i){r.removeClass(P).on(D,t._toggleHover);if(s&&s.length){s[0].removeAttribute(x);s[0].removeAttribute(T)}s.attr(O,false).attr(E,false).on("keydown"+h,t._keydown.bind(t)).on("focusout"+h,t._blur.bind(t)).on("focus"+h,function(){t.wrapper.addClass(V)});if(t._dateInput)t._dateInput._bindInput();a.on(o,t._click.bind(t)).on(H,le)}else{r.addClass(i?P:"").removeClass(i?"":P);s.attr(x,i).attr(T,n).attr(O,i).attr(E,n)}},readonly:function(e){this._editable({readonly:e===d?true:e,disable:false})},enable:function(e){this._editable({readonly:false,disable:!(e=e===d?true:e)})},destroy:function(){var e=this;_.fn.destroy.call(e);e.timeView.destroy();e.element.off(h);e._arrow.off(h);e.wrapper.off(h);if(e._form)e._form.off("reset",e._resetHandler)},close:function(){this.timeView.close()},open:function(){this.timeView.open()},min:function(e){if(e)this._specifiedRange=true;return this._option("min",e)},max:function(e){if(e&&this.timeView){this._specifiedRange=true;this.timeView.options.maxSet=true}else if(this.timeView)this.timeView.options.maxSet=false;return this._option("max",e)},value:function(e){var t=this;if(e===d)return t._value;t._old=t._update(e);if(t._old===null)t.element.val("");t._oldText=t.element.val()},_blur:function(){var e=this,t=e.element.val();if(!(e.options.timeView&&e.options.timeView.list==="scroll"))e.close();if(t!==e._oldText)e._change(t);e.wrapper.removeClass(V)},_click:function(){var e=this,t=e.element;e.timeView.toggle();if(!s.touch&&t[0]!==i())t.trigger("focus")},_change:function(e){var t=this,i=t.element.val(),n;e=t._update(e);n=!w.calendar.isEqualDate(t._old,e);var a=n&&!t._typing;var s=i!==t.element.val();if(a||s)t.element.trigger(l);if(n){t._old=e;t._oldText=t.element.val();t.trigger(l)}t._typing=false},_icon:function(){var e=this,t=e.element,i=e.options,n;n=t.next("button.k-input-button");if(!n[0])n=c(a.renderButton('<button unselectable="on" tabindex="-1" class="k-input-button" aria-label="select"></button>',{icon:"clock",size:i.size,fillMode:i.fillMode,shape:"none",rounded:"none"})).insertAfter(t);e._arrow=n.attr({role:"button"})},_keydown:function(e){var t=this,i=e.keyCode,n=t.timeView,a=t.element.val();if(n.popup.visible()||e.altKey){n.move(e);if(t._dateInput&&e.stopImmediatePropagation)e.stopImmediatePropagation()}else if(i===f.ENTER&&a!==t._oldText)t._change(a);else t._typing=true},_option:function(e,t){var i=this,n=i.options;if(t===d)return n[e];t=i.timeView._parse(t);if(!t)return;t=new b(+t);n[e]=t;i.timeView.options[e]=t;i.timeView.bind()},_toggleHover:function(e){c(e.currentTarget).toggleClass(C,e.type==="mouseenter")},_update:function(e){var t=this,i=t.options,n=t.timeView,a=n._parse(e);if(!ae(a,i.min,i.max))a=null;t._value=a;t._currentlySelected=a;if(t._dateInput&&a)t._dateInput.value(a||e);else t.element.val(w.toString(a||e,i.format,i.culture));n.value(a);return a},_wrapper:function(){var e=this,t=e.element,i;i=t.parents(".k-timepicker");if(!i[0])i=t.wrap(M).parent();i[0].style.cssText=t[0].style.cssText;e.wrapper=i.addClass("k-timepicker k-input").addClass(t[0].className);t.css({height:t[0].style.height})},_reset:function(){var e=this,t=e.element,i=t.attr("form"),n=i?c("#"+i):t.closest("form");if(n[0]){e._resetHandler=function(){e.value(t[0].defaultValue);e.max(e._initialOptions.max);e.min(e._initialOptions.min)};e._form=n.on("reset",e._resetHandler)}}});function re(e){var t=e.parseFormats;e.format=n(e.format||w.getCulture(e.culture).calendars.standard.patterns.t);t=N(t)?t:[t];t.splice(0,0,e.format);e.parseFormats=t}function le(e){e.preventDefault()}function oe(e,t){return new Date(e.getFullYear(),e.getMonth(),e.getDate(),t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds())}function ue(e,t){var i=t.calendar;var n;if(typeof e==="string")if(i.patterns[e])n=i.patterns[e];else n=e;if(!n)n=i.patterns.d;return n}function ce(e,t){var i=e[e.length-1];if(i&&i.type==="LITERAL")i.pattern+=t;else e.push({type:K,pattern:t})}function de(e){return e==="h"||e==="K"}function fe(e){var t;if(e<=3)t="abbreviated";else if(e===4)t="wide";else if(e===5)t="narrow";else if(e===6)t="short";return t}function he(e,t,i){i=i||0;return e.indexOf(t,i)===i}function pe(e,t){var i=false;if(e.indexOf(t)!==-1)i=true;return i}function me(c){var d=w.culture();var e=ue(c,d);var t=[];var i=W.lastIndex=0;var n=W.exec(e);var a;var s;var r;var l;var f;var o;while(n){var u=n[0];if(i<n.index)ce(t,e.substring(i,n.index));if(he(u,'"')||he(u,"'"))ce(t,u);else{a=u[0];s=X[a];r={type:s,pattern:u};if(s==="hour")r.hour12=de(u);l=Z[s];if(l){f=typeof l.minLength==="number"?l.minLength:l.minLength[a];o=u.length;if(o>=f)r.names={type:l.type,nameType:fe(o),standAlone:l.standAlone===a}}t.push(r)}i=W.lastIndex;n=W.exec(e)}if(i<e.length)ce(t,e.substring(i));return t}function ve(e,t){var i=String(e);while(i.length<(t||2))i="0"+i;return i}function _e(e,t){return Math.max(Math.round(e/t),0)}function m(e){return e.length&&e[0].getBoundingClientRect().height}function ge(e,i){function t(e,t){return{start:e,length:t,end:e+t}}function n(e,t){if(i===false||t.start<e.end&&e.start<t.end)return Math.min(e.start,Math.max(t.start,e.end-t.length));return(e.start+e.end-t.length)/2}function s(n,a){return{x:n,y:a,translate:function e(t,i){return s(n+t,a+i)}}}function a(e,t){while(e){t=t.translate(e.offsetLeft,e.offsetTop);e=e.offsetParent}return t}var r=a(e,s(0,0)),l=s(e.offsetWidth,e.offsetHeight),o=e.parentNode,u;while(o instanceof HTMLElement){u=a(o,s(o.clientLeft,o.clientTop));o.scrollLeft=n(t(r.x-u.x,l.x),t(o.scrollLeft,o.clientWidth));o.scrollTop=n(t(r.y-u.y,l.y),t(o.scrollTop,o.clientHeight));r=r.translate(-o.scrollLeft,-o.scrollTop);o=o.parentNode}}return w.cssProperties.registerPrefix("TimePicker","k-input-"),w.cssProperties.registerValues("TimePicker",[{prop:"rounded",values:w.cssProperties.roundedValues.concat([["full","full"]])}]),v.plugin(se),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,i){(i||t)()});
//# sourceMappingURL=kendo.timepicker.min.js.map
