/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.timeline.min",["kendo.fx.min","kendo.data.min","kendo.draganddrop.min"],function(){var e={id:"timeline",name:"Timeline",category:"web",description:"The Kendo Timeline widget display events over time",depends:["userevents"]},p=window.kendo.jQuery,n=void 0,s=window.kendo,t,r=s.ui.Widget,d=s.data.DataSource,f=s.effects.Transition,l=s.keys,o=Array.isArray,a=-1,c=0,v=1,i="vertical",u="transitionEnd",F=3,b="timeline-event",m="k-timeline-flag-wrap",k="k-timeline-track-item",h="k-timeline-scrollable-wrap",g=".kendoTimeline",w="change",x="# var titleField = data.titleField, subtitleField = data.subtitleField, descriptionField = data.descriptionField, imagesField = data.imagesField, actionsField = data.actionsField, altField = data.altField, data = data.data; #"+'<div class="k-card-inner">'+'<div class="k-card-header">'+"# if(data[titleField]) { #"+'<div class="k-card-title">#: data[titleField] #</div>'+"# }"+"if(data[subtitleField]) { #"+'<div class="k-card-subtitle">#: data[subtitleField] #</div>'+"# } #"+"</div>"+'<div class="k-card-body">'+'<div class="k-card-description">'+"# if(data[descriptionField]) { #"+"<p>#: data[descriptionField] #</p>"+"# }"+"if(data[imagesField] && data[imagesField].length > 0) { #"+'<img src="#: data[imagesField][0].src #"  #if(data[altField]){# alt="#:data[altField]#" #}# class="k-card-image" />'+"# } #"+"</div>"+"</div>"+"# if(data[actionsField] && data[actionsField].length > 0) { #"+'<div class="k-card-actions">'+"# for (var i = 0; i < data[actionsField].length; i++) { #"+'<a class="k-button k-button-md k-rounded-md k-button-flat k-button-flat-primary" href="#: data[actionsField][i].url ? data[actionsField][i].url : "\\#" #"><span class="k-button-text">#: data[actionsField][i].text #</span></a>'+"# } #"+"</div>"+"# } #"+"</div>",E="# var titleField = data.titleField, subtitleField = data.subtitleField, descriptionField = data.descriptionField, imagesField = data.imagesField, navigatable = data.navigatable, collapsibleEvents = data.collapsibleEvents, actionsField = data.actionsField, altField = data.altField, data = data.data; #"+'<div class="k-card-inner">'+'<div class="k-card-header">'+'<div class="k-card-title">'+"# if(data[titleField]) { #"+'<span class="k-event-title">#: data[titleField] #</span>'+"# } #"+'<span class="k-event-collapse k-button k-button-md k-rounded-md k-button-flat k-button-flat-base k-icon-button">'+'<span class="k-button-icon k-icon k-i-arrow-chevron-right"></span>'+"</span></div>"+"# if(data[subtitleField]) { #"+'<div class="k-card-subtitle">#: data[subtitleField] #</div>'+"# } #"+"</div>"+'<div class="k-card-body">'+'<div class="k-card-description">'+"# if(data[descriptionField]) { #"+"<p>#: data[descriptionField] #</p>"+"# } #"+"# if(data[imagesField] && data[imagesField].length > 0) { #"+'<img src="#: data[imagesField][0].src #" #if(data[altField]){# alt="#:data[altField]#" #}# class="k-card-image" />'+"# } #"+"</div>"+"</div>"+"# if(data[actionsField] && data[actionsField].length > 0) { #"+'<div class="k-card-actions">'+"# for (var i = 0; i < data[actionsField].length; i++) { #"+'<a class="k-button k-button-md k-rounded-md k-button-flat k-button-flat-primary" href="#: data[actionsField][i].url ? data[actionsField][i].url : "\\#" #"><span class="k-button-text">#: data[actionsField][i].text #</span></a>'+"# } #"+"</div>"+"# } #"+"</div>",I="# var itemTemplate = data.itemTemplate, dateField = data.dateField, dateFormat = data.dateFormat, showDateLabels = data.showDateLabels, data = data.data, year = 0; #"+"# for (var i = 0; i < data.length; i++) {"+"if(!(data[i][dateField] instanceof Date)) {"+"continue;"+"}"+"var currentYear = data[i][dateField].getFullYear();"+"if(year != currentYear) {"+"year = currentYear; #"+'<li class="k-timeline-track-item k-timeline-flag-wrap">'+'<span class="k-timeline-flag">#= year #</span>'+"</li>"+"# } #"+'<li class="k-timeline-track-item">'+'<div class="k-timeline-date-wrap">'+"# if(showDateLabels) { #"+'<span class="k-timeline-date">#= kendo.toString(data[i][dateField], dateFormat) #</span>'+"# } #"+"</div>"+'<a class="k-timeline-circle"></a>'+"</li>"+"# } #",T="# var itemTemplate = data.itemTemplate, dateField = data.dateField, titleField = data.titleField, descriptionField = data.descriptionField, subtitleField = data.subtitleField, imagesField = data.imagesField, actionsField = data.actionsField, alterMode = data.alterMode, collapsibleEvents = data.collapsibleEvents, dateFormat = data.dateFormat, showDateLabels = data.showDateLabels, navigatable = data.navigatable, altField = data.altField, data = data.data, counter = 0, year = 0, reverse = false;"+"for (var i = 0; i < data.length; i++) {"+"if(!(data[i][dateField] instanceof Date)) {"+"continue;"+"}"+"var currentYear = data[i][dateField].getFullYear();"+"if(currentYear != year) {"+"year = currentYear; #"+'<li class="k-timeline-flag-wrap">'+'<span class="k-timeline-flag">#= year #</span>'+"</li>"+"# } "+"reverse = counter % 2 === 0 && alterMode; #"+"<li class=\"#= reverse ? 'k-timeline-event k-reverse' : 'k-timeline-event' #\" data-uid=\"#: data[i].uid #\">"+'<div class="k-timeline-date-wrap">'+"# if(showDateLabels) { #"+'<div class="k-timeline-date-wrap">'+'<span id="#:data[i].uid#-date" class="k-timeline-date">#= kendo.toString(data[i][dateField], dateFormat) #</span>'+"</div>"+"# } #"+"</div>"+'<a class="k-timeline-circle"></a>'+"<div class=\"#= collapsibleEvents ? 'k-timeline-card k-collapsed' : 'k-timeline-card' #\">"+'<div class="k-card" #if (navigatable) {# aria-describedby="#:data[i].uid#-date" tabindex="0" role="button" aria-live="polite" aria-atomic="true"  #}#>'+"<span class=\"#= reverse ? 'k-timeline-card-callout k-card-callout k-callout-e' : 'k-timeline-card-callout k-card-callout k-callout-w' #\"></span>"+"#= itemTemplate({titleField: titleField, subtitleField: subtitleField, descriptionField: descriptionField, imagesField: imagesField, actionsField: actionsField, data: data[i], altField: altField, navigatable: navigatable, collapsibleEvents: collapsibleEvents}) #"+"</div>"+"</div>"+"</li>"+"# counter ++;"+"} #",C='<a class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-icon-button k-timeline-arrow k-timeline-arrow-left k-disabled" title="previous">'+'<span class="k-button-icon k-icon k-i-arrow-60-left"></span>'+"</a>"+'<a class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-icon-button k-timeline-arrow k-timeline-arrow-right k-disabled" title="next">'+'<span class="k-button-icon k-icon k-i-arrow-60-right"></span>'+"</a>";function y(e){return"k-"+e}function W(e){var t=e.css("transform");var a;var i;if(t!="none"){i=t.match(/-?[\d\.]+/g);a=i[4];return a/e.width()*100}else return 0}function _(e,t){return e.offset().left-t.offset().left+e.width()/2}function O(e,t,a){e.css(t,a)}var A=s.Class.extend({init:function(e){this.cardContainer=p("<div class='k-card' />");var t=p("<div class='k-timeline-card'></div>").append(this.cardContainer);this.element=p("<li class='"+y(b)+"'></li>").append(t);e.append(this.element)},content:function(e,t){var a=p("<span class='k-timeline-card-callout k-card-callout k-callout-n'></span>");this.cardContainer.html(e);this.cardContainer.append(a);this.element.attr("data-uid",t)},position:function(e){this.element.css("transform","translate3d("+this.element.width()*e+"px, 0, 0)")},setPageCallout:function(e,t){var a=this.element;var i=a.find(".k-timeline-card-callout");i.css(e,t)},destroy:function(){var e=this;e.cardContainer=null;e.element.remove();e.element=null}}),M=s.Observable.extend({init:function(e,t){var a=this;s.Observable.fn.init.call(this);this.element=e;var i,n,r;i=new s.ui.Movable(a.element);n=new f({axis:"x",movable:i,onEnd:function(){a.trigger(u)}});r=[];p.extend(a,{duration:t&&t.duration||1,movable:i,transition:n,pages:r,eventTemplate:t.eventTemplate,eventHeight:t.eventHeight,dataFieldMappings:t.dataFieldMappings});this.bind([u],t)},initPages:function(){var e=this.pages,t=this.element,a;for(var i=0;i<F;i++){a=new A(t);e.push(a)}},repositionPages:function(){var e=this.pages;e[0].position(a);e[1].position(c);e[2].position(v)},setPageContent:function(e,t){var a=typeof this.eventTemplate===Function?this.eventTemplate:s.template(this.eventTemplate);var i=this.dataFieldMappings;var n;n=a({data:t,titleField:i.title,subtitleField:i.subtitle,descriptionField:i.description,imagesField:i.images,actionsField:i.actions,altField:i.altField});e.content(n,t.uid)},updatePage:function(e,t,a){var i=this.pages;var n=e===null?i[1]:e?i[i.length-1]:i[0];this.setPageContent(n,t);n.setPageCallout("left",a/n.element.width()*100+"%")},moveTo:function(e){this.movable.moveAxis("x",-e)},transitionTo:function(e,t){this.transition.moveTo({location:e,duration:this.duration,ease:t})},destroy:function(){var e=this;for(var t=0;t<e.pages.length;t++)e.pages[t].destroy();e.unbind();e.movable=e.transition=e.dataFieldMappings=e.eventTemplate=e.duration=e.pages=null}}),D=s.ui.Widget.extend({init:function(e,t){var n=this;var a=t.orientation||n.options.orientation;r.fn.init.call(this,e,t);this.element.addClass(a===i?"k-timeline k-widget k-timeline-vertical":"k-timeline k-widget k-timeline-horizontal");if(a!=i)n._horizontal();else n._vertical();this.element.on("click",".k-card-actions",function(e){var t=p(e.target);var a=p(e.target).closest(".k-timeline-event").data("uid");var i=n.dataSource.getByUid(a);n.trigger("actionClick",{sender:n,element:t,dataItem:i})});n.currentEventIndex=0;n._forward=null;n._eventPage=1;n._currentIndex=0;n._firstIndexInView=0;n._initDataFieldMappings();n.setDataSource(t.dataSource)},_horizontal:function(){var e=this;var t=this.element;var a=this.options;var i=p("<div />");var n=p("<div />");var r=p("<ul />");var l=p("<div />");var s=p("<ul />");e._trackWrap=i;e._trackEl=n;e._scrollableWrap=r;e._eventsWrap=l;e._eventsList=s;i.addClass("k-timeline-track-wrap");n.addClass("k-timeline-track");r.addClass("k-timeline-scrollable-wrap");l.addClass("k-timeline-events-list");s.addClass("k-timeline-scrollable-wrap");if(a.eventHeight)s.height(a.eventHeight);n.append(r);i.append(C);i.append(n);l.append(s);i.appendTo(t);l.appendTo(t)},_vertical:function(){var i=this;var e=this.options;var t=this.element;var a=i._eventsList=p("<ul />");var n=e.navigatable;var r=e.collapsibleEvents;i.element.append(a);if(e.alternatingMode)t.addClass("k-timeline-alternating");if(r){t.addClass("k-timeline-collapsible");this.element.on("click",".k-card-header",function(){var e=p(this).closest(".k-timeline-card");var t=e.parent();var a=i.dataSource.getByUid(t.data("uid"));if(e.hasClass("k-collapsed")){if(!i.trigger("expand",{sender:i,dataItem:a}))i.expand(t)}else if(!i.trigger("collapse",{sender:i,dataItem:a}))i.collapse(t)})}if(n)if(r)this.element.on("keydown"+g,i,function(e){if(e.keyCode==l.SPACEBAR||e.keyCode==l.ENTER){var t=p(e.target);var a=t.find(".k-card-header");if(a.length){e.preventDefault();a.trigger("click")}}})},_renderContentVertical:function(e){var t=this;var a=t.options;var i;var n;if(typeof a.eventTemplate===Function)n=a.eventTemplate;else n=a.eventTemplate?s.template(a.eventTemplate):s.template(E,{useWithBlock:false});var r=s.template(T,{useWithBlock:false});i=r({data:e,dateField:a.dataDateField,titleField:a.dataTitleField,subtitleField:a.dataSubtitleField,descriptionField:a.dataDescriptionField,imagesField:a.dataImagesField,actionsField:a.dataActionsField,itemTemplate:n,alterMode:a.alternatingMode,collapsibleEvents:a.collapsibleEvents,dateFormat:a.dateFormat,showDateLabels:a.showDateLabels,altField:a.dataImagesAltField,navigatable:a.navigatable});this._eventsList.html(i);if(a.eventWidth)t.element.find(".k-card").width(a.eventWidth)},_renderContentHorizontal:function(e){var t=this;var a=t.options;var i;var n;var r=t._dataFieldMappings;if(typeof a.eventTemplate===Function)n=a.eventTemplate;else n=a.eventTemplate?s.template(a.eventTemplate):s.template(x,{useWithBlock:false});var l=s.template(I,{useWithBlock:false});i=l({data:e,itemTemplate:n,dateFormat:a.dateFormat,dateField:a.dataDateField,showDateLabels:a.showDateLabels});if(a.initialEventIndex)t._trackWrap.append(p(i).find(".k-timeline-scrollable-wrap").css("transform","translateX(-100%)").parent());else t._scrollableWrap.html(i);if(t.pane)t.pane.destroy();t.pane=new M(t._eventsList,{transitionEnd:this._transitionEnd.bind(this),eventTemplate:n,dataFieldMappings:r,eventHeight:a.eventHeight})},_initDataFieldMappings:function(){var e=this;var t=e.options;e._dataFieldMappings={title:t.dataTitleField,subtitle:t.dataSubtitleField,date:t.dataDateField,description:t.dataDescriptionField,images:t.dataImagesField,actions:t.dataActionsField,altField:t.dataImagesAltField}},_transitionEnd:function(){if(this._forward)this.pane.pages.push(this.pane.pages.shift());else this.pane.pages.unshift(this.pane.pages.pop());this._forward=null;this.pane.repositionPages();this.pane.movable.moveAxis("x",0);if(this.options.navigatable){this._transition=null;this._eventsList.find(".k-card").removeAttr("id");this.pane.pages[1].cardContainer.attr("id",this._cardId);this._setCurrent(this._currentBullet)}this._animationInProgress=false},_setCurrentEvent:function(e){var t=this;var a=p(e.currentTarget);var i;var n=t.dataSource.view()[a.parent().children(":not(.k-timeline-flag-wrap)").index(a)];i=t._forward?t.pane.pages[2].element:t.pane.pages[0].element;if(!t.trigger("change",{eventContainer:i,dataItem:n}))t.open(a)},open:function(e){var t=this;var a=p(e);var i=a.find(".k-timeline-circle");var n=a.parent().children(":not(.k-timeline-flag-wrap)");var r=n.index(a);var l;if(this.options.navigatable){t._removeCurrent();n.attr("aria-selected",false);a.attr("aria-selected",true);t._currentBullet=a}var s=t.dataSource.view()[r];if(t.currentEventIndex===r)return;t._currentIndex=a.index();l=t._forward=t.currentEventIndex<r;t.currentEventIndex=r;t.pane.updatePage(l,s,_(i,t._trackWrap));if(t._forward){clearTimeout(t.navigateTimeOut);t.navigateTimeOut=setTimeout(function(){t.pane.transition.moveTo({location:-t.pane.pages[2].element.width(),duration:800,ease:f.easeOutExpo})},200)}else{clearTimeout(t.navigateTimeOut);t.navigateTimeOut=setTimeout(function(){t.pane.transition.moveTo({location:t.pane.pages[0].element.width(),duration:800,ease:f.easeOutExpo})},200)}t._repositionEvents()},_navigateToView:function(e){var t=this;var a=p(e.currentTarget).hasClass("k-timeline-arrow-right")?1:-1;if(!t.trigger("navigate",{sender:t,action:a>0?"next":"previous"})&&!t._animationInProgress){t._animationInProgress=true;if(a>0)t.next();else t.previous();t._updateArrows()}},_updateArrows:function(){var e=this;var t=e.element.find(".k-timeline-arrow");var a=t.filter(".k-timeline-arrow-left");var i=t.filter(".k-timeline-arrow-right");if(e._validateNavigation(false))a.addClass("k-disabled");else a.removeClass("k-disabled");if(e._validateNavigation(true))i.addClass("k-disabled");else i.removeClass("k-disabled")},_validateNavigation:function(e){var t=this;var a=t._end||0;if(e)return t._firstIndexInView+t.numOfEvents>=t.maxEvents;else return Math.abs(a)<=1},next:function(){var e=this;var t=e.options;if(!e._validateNavigation(true)&&t.orientation!=i){e._forward=true;e._navigate()}e._updateArrows()},_navigate:function(){var a=this;var e;var i;var t;var c;var n=a._forward;var r=W(this._trackWrap.find("."+h));var v=n?-p("."+h).width():p("."+h).width();var u=a._currentIndex;var l;var s=a._firstIndexInView;r=n?r-100:r+100;if(r>=0)r=0;a._end=r;c=a._tackItemWidth;l=Math.floor(u/a.numOfEvents);if(n)if(a.numOfEvents===1){e=s===0?1:s;i=this._trackWrap.find("."+k).eq(e).nextAll(":not(."+m+")").first();a._firstIndexInView=i.index()}else{e=s+a.numOfEvents-1;i=this._trackWrap.find("."+k).eq(e).nextAll(":not(."+m+")").first();a._firstIndexInView=s+a.numOfEvents}else if(a.numOfEvents===1){e=s;i=this._trackWrap.find("."+k).eq(e).prevAll(":not(."+m+")").first();a._firstIndexInView=i.index()}else{e=s;i=this._trackWrap.find("."+k).eq(e).prevAll(":not(."+m+")").first();i=i.length>0?i:this._trackWrap.find("."+k+":not(."+m+")").first();a._firstIndexInView=s-a.numOfEvents<0?0:s-a.numOfEvents}t=a.dataSource.view()[i.index("li[class='k-timeline-track-item']")];this._trackWrap.find("."+h).css("transform","translateX("+r+"%)");if(a._currentIndex!=i.index()){a.currentEventIndex=i.index("li[class='k-timeline-track-item']");a._currentIndex=i.index();a.pane.updatePage(a._forward,t,l===0&&!n?i.find(".k-timeline-circle").offset().left+15:_(i.find(".k-timeline-circle"),a._trackWrap)+v);clearTimeout(a.navigateTimeOut);a.navigateTimeOut=setTimeout(function(){if(n&&a.pane&&a.pane.pages.length>0)a.pane.transition.moveTo({location:-a.pane.pages[2].element.width(),duration:800,ease:f.easeOutExpo});else a.pane.transition.moveTo({location:a.pane.pages[0].element.width(),duration:800,ease:f.easeOutExpo})},200)}else{var d=this._trackWrap.find("."+h);var o=function(){if(a.numOfEvents!=1){var e=a.pane.pages[1];var t=_(i.find(".k-timeline-circle"),a._trackWrap);e.setPageCallout("left",t/e.element.width()*100+"%")}this._transition=null;d.off("transitionend"+g,o)};d.on("transitionend"+g,o)}},previous:function(){var e=this;var t=e.options;if(!e._validateNavigation(false)&&t.orientation!=i){e._forward=false;e._navigate()}e._updateArrows()},expand:function(e){var t=this.options,a=p(e).find(".k-timeline-card"),i=p(e).find(".k-card"),n=p(e).find(".k-card-body");if(!a.hasClass("k-collapsed"))return;if(t.navigatable&&t.collapsibleEvents)i.attr("aria-expanded",true);a.removeClass("k-collapsed");s.fx(n).expand("vertical").stop().play()},collapse:function(e){var t=this.options,a=p(e).find(".k-timeline-card"),i=p(e).find(".k-card"),n=p(e).find(".k-card-body");if(a.hasClass("k-collapsed"))return;if(t.navigatable&&t.collapsibleEvents)i.attr("aria-expanded",false);a.addClass("k-collapsed");s.fx(n).expand("vertical").stop().reverse()},items:function(){return this.element.find("li[data-uid]")},_resizeHandler:function(){var e=this;clearTimeout(e.resizeTimeOut);e.resizeTimeOut=setTimeout(function(){e._redrawEvents();e.pane.repositionPages()})},redraw:function(){var e=this.options;if(e.orientation!=i){this._redrawEvents();this.pane.repositionPages()}},_redrawEvents:function(){var e=this;var t=Math.floor(e.element.find(".k-timeline-scrollable-wrap").width()/150);var a;if(e.element.width()<=480){e.element.addClass("k-timeline-mobile");a=100;e.numOfEvents=1;e._tackItemWidth=a;e.element.find("li.k-timeline-track-item").css("flex","1 0 "+a+"%");e._repositionEvents()}else{e.element.removeClass("k-timeline-mobile");if(t!=e.numOfEvents){e.numOfEvents=t;a=100/t;O(e.element.find("li.k-timeline-track-item"),"flex","1 0 "+a+"%");e._tackItemWidth=a;e._repositionEvents()}}e._updateArrows()},_repositionEvents:function(){var i=this;var e=i._tackItemWidth;var t=i._forward===null?i.pane.pages[1]:i._forward?i.pane.pages[2]:i.pane.pages[0];var a=this._trackWrap.find("."+h);var n=W(a);var r;var l;var s;var d;if(i.numOfEvents===1)l=i.currentEventIndex*e;else l=i._currentIndex*e;if(t){if(i.numOfEvents===1){t.setPageCallout("left","50%");s=l;O(a,"transform","translateX(-"+s+"%)");i._firstIndexInView=i._currentIndex;i._updateArrows();return}if(l>=Math.abs(n)+100){s=Math.abs(n)+(l-(Math.abs(n)+100)+e);i._end=-s;O(a,"transform","translateX(-"+s+"%)");i._firstIndexInView=i._currentIndex-i.numOfEvents+1}else if(l<=Math.abs(n)){s=l;i._end=-s;O(a,"transform","translateX(-"+s+"%)");i._firstIndexInView=i._currentIndex}else{d=a.find("li.k-timeline-track-item").eq(i._currentIndex).find(".k-timeline-circle");r=_(d,i._trackWrap);t.setPageCallout("left",r/t.element.width()*100+"%");i._firstIndexInView=Math.round(Math.abs(n)/e)}var o=this._trackWrap.find("."+h);var c=function(){if(i.numOfEvents!=1){var e=i.pane.pages[1];var t=i._trackWrap.find("."+k).eq(i._currentIndex);var a=_(t.find(".k-timeline-circle"),i._trackWrap);e.setPageCallout("left",a/e.element.width()*100+"%")}o.off("transitionend"+g,c)};o.on("transitionend"+g,c)}i._updateArrows()},_initHorizontal:function(){var r=this;var e=r._trackWrap.find(".k-timeline-circle").first();var t=r.dataSource.view()[0];var a=r.options.navigatable;r.maxEvents=r._trackWrap.find(".k-timeline-track-item").length;r._currentIndex=1;r.pane.initPages();r.pane.repositionPages();r.pane.updatePage(r._forward,t,_(e,r._trackWrap));r._updateArrows();r._resizeHandlerBound=r._resizeHandler.bind(r);s.jQuery(window).on("resize"+g,r._resizeHandlerBound);r._trackWrap.on("click",".k-timeline-track-item:not(.k-timeline-flag-wrap)",r._setCurrentEvent.bind(r));r._trackWrap.on("click",".k-timeline-arrow:not(.k-disabled)",r._navigateToView.bind(r));if(a){r._trackWrap.find(".k-timeline-track-item.k-timeline-flag-wrap").attr("aria-hidden",true);r._trackWrap.find(".k-timeline-track-item:not(.k-timeline-flag-wrap)").attr("role","option").attr("aria-selected",false).first().attr("aria-selected",true);r._cardId=s.guid();r._scrollableWrap.attr("role","listbox").attr("aria-orientation","horizontal").attr("tabindex",0).on("focus"+g,function(){r.pane.pages[1].cardContainer.attr("id",r._cardId);r._setCurrent(r._scrollableWrap.find(".k-timeline-track-item").eq(r._currentIndex))}).on("focusout"+g,function(){r._removeCurrent()}).on("keydown"+g,function(e){var t;var a=r._currentBullet;var i;var n;if(r._transition)return;if(e.keyCode==l.LEFT){t=true;n=a.prevAll(".k-timeline-track-item:not(.k-timeline-flag-wrap)").first();if(n.length){i=_(n,r._trackWrap);if(i<0||i>n.parent().width()){r._transition=true;r._removeCurrent();r.previous();r.open(n)}else r._setCurrent(n)}}if(e.keyCode==l.RIGHT){t=true;n=a.nextAll(".k-timeline-track-item:not(.k-timeline-flag-wrap)").first();if(n.length){i=_(n,r._trackWrap);if(i<0||i>n.parent().width()){r._transition=true;r._removeCurrent();r.next();r.open(n)}else r._setCurrent(n)}}if(e.keyCode==l.SPACEBAR||e.keyCode==l.ENTER){t=true;r._currentBullet.trigger("click")}if(t)e.preventDefault()});r._ariaLabel(r._scrollableWrap)}},_setCurrent:function(e){if(!e)return;var t=s.guid();var a=this;a._removeCurrent();a._scrollableWrap.attr("aria-activedescendant",t);e.attr("id",t).addClass("k-focus");e.siblings().removeAttr("aria-describedby");if(e.attr("aria-selected")==="true")e.attr("aria-describedby",a._cardId);a._currentBullet=e},_removeCurrent:function(){if(this._currentBullet)this._currentBullet.removeClass("k-focus").removeAttr("id").removeAttr("aria-describedby");this._scrollableWrap.removeAttr("aria-activedescendant")},setDataSource:function(e){var t=this;var a=t.options;e=o(e)?{data:e}:e;if(t.dataSource&&t._refresh)t.dataSource.unbind(w,t._refresh);else this._refresh=t.refresh.bind(t);this.dataSource=d.create(e);if(this.dataSource._sort===n)this.dataSource._sort=[{field:a.dataDateField,dir:"asc"}];t.dataSource.bind(w,t._refresh);if(a.autoBind)this.dataSource.fetch()},refresh:function(){var e=this;var t=e.options;var a=this.dataSource.view();if(t.orientation!=i){e._trackWrap.empty().remove();e.element.find(".k-timeline-events-list").remove();e._horizontal()}e.currentEventIndex=0;e._forward=null;e._eventPage=1;e._currentIndex=0;e._firstIndexInView=0;e.numOfEvents=null;e._end=0;e._initDataFieldMappings();if(a.length)if(t.orientation==="horizontal"){e._renderContentHorizontal(a);e._redrawEvents();e._initHorizontal()}else e._renderContentVertical(a);e.trigger("dataBound",{sender:e})},destroy:function(){var e=this.options;r.fn.destroy.call(this);if(this.resizeTimeOut)clearTimeout(this.resizeTimeOut);if(this.navigateTimeOut)clearTimeout(this.navigateTimeOut);p(window).off("resize"+g,this._resizeHandlerBound);this._resizeHandlerBound=null;this.element.off();if(e.orientation!=i){if(this.pane)this.pane.destroy();this._trackWrap.find("."+h).off();this.element.find(".k-timeline-arrow").off();this._trackWrap.off();this.currentEventIndex=this.maxEvents=this.numOfEvents=this._currentIndex=this._eventPage=this._eventsList=this._eventsWrap=this.element=this._trackWrap=this.pane=null}s.destroy(this.element);this._dataFieldMappings=this.element=null},options:{autoBind:true,name:"Timeline",orientation:"vertical",dateFormat:"MMM d, yyyy",showDateLabels:true,collapsibleEvents:false,alternatingMode:false,dataTitleField:"title",dataDateField:"date",dataSubtitleField:"subtitle",dataDescriptionField:"description",dataImagesField:"images",dataActionsField:"actions",dataImagesAltField:"altField",navigatable:false},events:["collapse","dataBound","expand","actionClick","change","navigate"]});return s.ui.plugin(D),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,a){(a||t)()});
//# sourceMappingURL=kendo.timeline.min.js.map
