/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.progressbar.min",["kendo.core.min"],function(){var e={id:"progressbar",name:"ProgressBar",category:"web",description:"The ProgressBar offers rich functionality for displaying and tracking progress",depends:["core"]},t=window.kendo.jQuery,v=void 0,p=window.kendo,r,s=p.ui.Widget,l="horizontal",c="vertical",a,g,_,h,m="k-progressbar",w="k-progressbar-reverse",n="k-progressbar-indeterminate",k="k-complete",y="k-selected",P="k-progress-status",C,u="k-selected",b="k-disabled",o={VALUE:"value",PERCENT:"percent",CHUNK:"chunk"},S="change",x="complete",W="boolean",d=Math,A=t.extend,f=100,U=400,E=3,i={progressStatus:"<span class='k-progress-status-wrap "+"k-progress-end"+"'><span class='k-progress-status'></span></span>",announceElement:'<span aria-live="polite" class="k-sr-only k-progress-announce"></span>'},N=s.extend({init:function(e,r){var a=this;s.fn.init.call(this,e,r);r=a.options;a._progressProperty=r.orientation===l?"width":"height";a._fields();r.value=a._validateValue(r.value);a._validateType(r.type);a._wrapper();if(r.ariaRole)a._aria();a._progressAnimation();if(r.value!==r.min&&r.value!==false)a._updateProgress()},setOptions:function(e){var r=this,a=r.wrapper;s.fn.setOptions.call(r,e);if(e.hasOwnProperty("reverse"))a.toggleClass("k-progressbar-reverse",e.reverse);if(e.hasOwnProperty("enable"))r.enable(e.enable);if(e.ariaRole)r._aria();r._progressAnimation();r._validateValue();r._updateProgress()},events:[S,x],options:{name:"ProgressBar",orientation:l,reverse:false,min:0,max:100,value:0,enable:true,type:o.VALUE,chunkCount:5,showStatus:true,animation:{},label:null,labelId:null,ariaRole:false},_aria:function(){var e=this,r=e.options,a=e.wrapper;a.attr({role:"progressbar","aria-valuemin":r.min,"aria-valuemax":r.max});if(!!r.labelId)a.attr("aria-labelledby",r.labelId);else if(!!r.label)a.attr("aria-label",r.label);e.announce=t(i.announceElement);e.announce.appendTo(t("body"));if(r.value!==false){a.attr("aria-valuenow",r.value);e.announce.text(e._calculatePercentage().toFixed()+"%")}},_fields:function(){var e=this;e._isStarted=false;e.progressWrapper=e.progressStatus=t()},_validateType:function(a){var s=false;t.each(o,function(e,r){if(r===a){s=true;return false}});if(!s)throw new Error(p.format("Invalid ProgressBar type '{0}'",a))},_wrapper:function(){var e=this;var r=e.wrapper=e.element;var a=e.options;var s=a.orientation;var t=a.value!==false?a.value:a.min;r.addClass("k-widget "+m);r.addClass(m+"-"+(s===l?l:c));if(a.enable===false)r.addClass(b);if(a.reverse)r.addClass(w);if(a.value===false)r.addClass(n);if(a.type===o.CHUNK)e._addChunkProgressWrapper();else if(a.showStatus){e.progressStatus=e.wrapper.prepend(i.progressStatus).find("."+P);if(a.type===o.VALUE)e.progressStatus.text(t);else e.progressStatus.text(e._calculatePercentage(t).toFixed()+"%")}},value:function(e){return this._value(e)},_value:function(e){var r=this;var a=r.options;var s;if(e===v)return a.value;else if(typeof e!==W){e=r._roundValue(e);if(!isNaN(e)){s=r._validateValue(e);if(s!==a.value){r.wrapper.removeClass(n);a.value=s;r._isStarted=true;r._updateProgress()}}}else if(!e){r.wrapper.addClass(n);r.wrapper.removeAttr("aria-valuenow");a.value=false;if(r.announce)r.announce.text("")}},_roundValue:function(e){e=parseFloat(e);var r=d.pow(10,E);return p._round(e*r)/r},_validateValue:function(e){var r=this;var a=r.options;if(e!==false){if(e<=a.min||e===true)return a.min;else if(e>=a.max)return a.max}else if(e===false)return false;if(isNaN(r._roundValue(e)))return a.min;return e},_updateProgress:function(){var e=this;var r=e.options;var a=e._calculatePercentage();if(r.type===o.CHUNK){e._updateChunks(a);e._onProgressUpdateAlways(r.value)}else e._updateProgressWrapper(a);if(r.ariaRole){e.wrapper.attr("aria-valuenow",e.options.value);if(e.announce)e.announce.text(a.toFixed()+"%")}},_updateChunks:function(e){var r=this;var a=r.options;var s=a.chunkCount;var t=parseInt(f/s*100,10)/100;var n=parseInt(e*100,10)/100;var o=d.floor(n/t);var i;if(a.orientation===l&&!a.reverse||a.orientation===c&&a.reverse)i=r.wrapper.find("li.k-item").slice(0,o);else if(o===0)i=p.jQuery();else i=r.wrapper.find("li.k-item").slice(o*-1);r.wrapper.find("."+u).removeClass(u);i.addClass(u)},_updateProgressWrapper:function(e){var r=this;var a=r.options;var s=r.wrapper.find("."+y);var t=r._isStarted?r._animation.duration:0;var n={};if(s.length===0)r._addRegularProgressWrapper();n[r._progressProperty]=e+"%";r.progressWrapper.animate(n,{duration:t,start:r._onProgressAnimateStart.bind(r),progress:r._onProgressAnimate.bind(r),complete:r._onProgressAnimateComplete.bind(r,a.value),always:r._onProgressUpdateAlways.bind(r,a.value)})},_onProgressAnimateStart:function(){this.progressWrapper.show()},_onProgressAnimate:function(e){var r=this;var a=r.options;var s=parseFloat(e.elem.style[r._progressProperty],10);var t;if(a.showStatus){t=1e4/parseFloat(r.progressWrapper[0].style[r._progressProperty]);r.progressWrapper.find(".k-progress-status-wrap").css(r._progressProperty,t+"%")}if(a.type!==o.CHUNK&&s<=98)r.progressWrapper.removeClass(k)},_onProgressAnimateComplete:function(e){var r=this;var a=r.options;var s=parseFloat(r.progressWrapper[0].style[r._progressProperty]);var t;if(a.type!==o.CHUNK&&s>98)r.progressWrapper.addClass(k);if(a.showStatus){if(a.type===o.VALUE)t=e;else if(a.type==o.PERCENT)t=r._calculatePercentage(e).toFixed()+"%";else t=d.floor(r._calculatePercentage(e))+"%";r.progressStatus.text(t)}if(e===a.min)r.progressWrapper.hide()},_onProgressUpdateAlways:function(e){var r=this;var a=r.options;if(r._isStarted)r.trigger(S,{value:e});if(e===a.max&&r._isStarted)r.trigger(x,{value:a.max})},enable:function(e){var r=this;var a=r.options;a.enable=typeof e==="undefined"?true:e;r.wrapper.toggleClass(b,!a.enable)},destroy:function(){var e=this;if(e.announce)e.announce.remove();s.fn.destroy.call(e)},_addChunkProgressWrapper:function(){var e=this;var r=e.options;var a=e.wrapper;var s=f/r.chunkCount;var t="";if(r.chunkCount<=1)r.chunkCount=1;t+="<ul class='k-reset'>";for(var n=r.chunkCount-1;n>=0;n--)t+="<li class='k-item'></li>";t+="</ul>";a.append(t).find(".k-item").css(e._progressProperty,s+"%").first().addClass("k-first").end().last().addClass("k-last");e._normalizeChunkSize()},_normalizeChunkSize:function(){var e=this;var r=e.options;var a=e.wrapper.find(".k-item").last();var s=parseFloat(a[0].style[e._progressProperty]);var t=f-r.chunkCount*s;if(t>0)a.css(e._progressProperty,s+t+"%")},_addRegularProgressWrapper:function(){var e=this;e.progressWrapper=t("<div class='"+y+"'></div>").appendTo(e.wrapper);if(e.options.showStatus){e.progressWrapper.append(i.progressStatus);e.progressStatus=e.wrapper.find("."+P)}},_calculateChunkSize:function(){var e=this;var r=e.options.chunkCount;var a=e.wrapper.find("ul.k-reset");return(parseInt(a.css(e._progressProperty),10)-(r-1))/r},_calculatePercentage:function(e){var r=this;var a=r.options;var s=e!==v?e:a.value;var t=a.min;var n=a.max;r._onePercent=d.abs((n-t)/100);return d.abs((s-t)/r._onePercent)},_progressAnimation:function(){var e=this;var r=e.options;var a=r.animation;if(a===false)e._animation={duration:0};else e._animation=A({duration:U},r.animation)}});return p.ui.plugin(N),window.kendo})}("function"==typeof define&&define.amd?define:function(e,r,a){(a||r)()});
//# sourceMappingURL=kendo.progressbar.min.js.map
