/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.circularprogressbar.min",["kendo.dataviz.min","kendo.dataviz.themes.min"],function(){var t={id:"circularprogressBar",name:"CircularProgressBar",category:"web",description:"The Circular ProgressBar component represents an SVG loader",depends:["core"]},n=window.kendo.jQuery,l=void 0,c=(window.kendo.dataviz=window.kendo.dataviz||{},kendo.dataviz),h=c.interpolateValue,o=kendo.drawing,e=kendo.ui,r=e.Widget,d=o.Surface,s=kendo.geometry,v=o.Animation,f=o.Arc,g=c.limitValue,u=c.round,m=o.Group,p=200,_=180,i=0,a=100,w=5,C=150,y=200,A=800,k='<span aria-live="polite" class="k-sr-only k-progress-announce"></span>',b=v.extend({init:function(e,t){v.fn.init.call(this,e,t);var i=this.options;var r=t.endColor;var n=t.startColor;var a=Math.abs(i.newAngle-i.oldAngle)/i.duration*1e3;i.duration=g(a,C,A);this.element=e;if(n!==r){this.startColor=new kendo.Color(n);this.color=new kendo.Color(r)}},step:function(e){var t=this;var i=t.options;var r=t.startColor;var n=t.color;var a=h(i.oldAngle,i.newAngle,e);this.element.geometry().setEndAngle(a);if(n){var o=u(h(r.r,n.r,e));var s=u(h(r.g,n.g,e));var l=u(h(r.b,n.b,e));this.element.stroke(new kendo.Color(o,s,l).toHex())}}}),x=r.extend({init:function(e,t){var i=this;r.fn.init.call(i,e,t);this.theme=E(this.options);this._value=this.options.value;this.element.addClass("k-gauge");this.redraw();this._centerTemplate();this._aria()},options:{name:"CircularProgressBar",ariaRole:false,theme:"default",centerTemplate:"",color:"",colors:[],transitions:true,pointerWidth:5,indeterminate:false,label:null,labelId:null},events:[],value:function(e){var t=this;if(e===l)return t._value;e=t._restrictValue(e);t._centerSvgElements();t._pointerChange(t._value,e);t._value=e;t._centerTemplate();t._updateProgress()},redraw:function(){this._initSurface();this._buildVisual();this._draw()},resize:function(){var e=this.options.transitions;this.options.transitions=false;this._initSurface();this._buildVisual();this._draw();this._centerTemplate();this.options.transitions=e},destroy:function(){var e=this;if(e.announce)e.announce.remove();r.fn.destroy.call(e)},_aria:function(){var e=this,t=e.options,i=e.value()||0,r=e.element;if(!t.ariaRole)return;r.attr({role:"progressbar"});if(!t.indeterminate)r.attr({"aria-valuemin":0,"aria-valuemax":100});if(!!t.labelId)r.attr("aria-labelledby",t.labelId);else if(!!t.label)r.attr("aria-label",t.label);e.announce=n(k);e.announce.appendTo(n("body"));if(!t.indeterminate){r.attr("aria-valuenow",i);e.announce.text(i+"%")}else e.announce.text("Loading...")},_restrictValue:function(e){if(e<i)return i;if(e>a)return a;return e},_updateProgress:function(){var e=this;var t=e.options;var i=e.value()||0;if(t.ariaRole&&!t.indeterminate){e.element.attr("aria-valuenow",i);if(e.announce)e.announce.text(i+"%")}},_centerSvgElements:function(){var e=this._getCenter();if(this.circle._geometry.center.x!==e.x||this.circle._geometry.center.y!==e.y){this.circle._geometry.center.x=e.x;this.circle._geometry.center.y=e.y;this.arc._geometry.center.x=e.x;this.arc._geometry.center.y=e.y;this.circle.geometryChange();this.arc.geometryChange()}},_centerTemplate:function(){var e;var t;var i;if(this.options.centerTemplate){t=kendo.template(this.options.centerTemplate);i=this._getCenterElement();i.html(t({color:this._getColor(this.value()),value:this.value()}));e=this._centerTemplatePosition(i.width(),i.height());i.css(e)}else if(this._centerElement){this._centerElement.remove();this._centerElement=null}},_getCenterElement:function(){var e=this._centerElement;if(!e){e=this._centerElement=n("<div></div>").addClass("k-arcgauge-label");this.element.append(e)}return e},_pointerChange:function(e,t){var i;if(this.options.transitions){i=new b(this.arc,{oldAngle:this._slotAngle(e),startColor:this._getColor(e),newAngle:this._slotAngle(t),endColor:this._getColor(t)});i.play()}else{this.arc.stroke(this._getColor(t));this.arc.geometry().setEndAngle(this._slotAngle(t))}},_draw:function(){var e;var t;var i;var r=this.surface;r.clear();r.draw(this._visuals);if(this.options.indeterminate){e=r.element.find("path");t=this._getCenter();e[0].innerHTML=kendo.format('<animateTransform attributeName="transform" type="rotate" from="0 {0} {1}" to="360 {0} {1}" dur="1s" repeatCount="indefinite" />',t.x,t.y)}else if(this.options.transitions){i=new b(this.arc,{oldAngle:this._slotAngle(0),startColor:this._getColor(0),newAngle:this._slotAngle(this.value()),endColor:this._getColor(this.value())});i.play()}},_buildVisual:function(){var e=this._visuals=new m;var t=this._getCenter();var i=this._getColor(this.value())||this.theme.pointer.color;var r=Math.min(t.x,t.y)-w-this.options.pointerWidth;var n=new s.Circle([t.x,t.y],r+this.options.pointerWidth/2);var a=this.circle=new o.Circle(n,{fill:{color:"none"},stroke:{color:this.theme.scale.rangePlaceholderColor,width:this.options.pointerWidth}});e.append(a);if(this.options.indeterminate)this.arc=this._createArc(360,r,t,i);else this.arc=this._createArc(this._slotAngle(this.value()),r,t,i);e.append(this.arc)},_slotAngle:function(e){var t;t=(e-i)/a*360+90;return t+_},_getColor:function(e){var t=this.options;var i=t.colors;var r=t.color;var n=c.isNumber(e)?e:0;if(i)for(var a=0;a<i.length;a++){var o=i[a];var s=o.color;var l=o.from;if(l===void 0)l=0;var h=o.to;if(h===void 0)h=100;if(l<=n&&n<=h)return s}return r},_createArc:function(e,t,i,r){var n=this.options.pointerWidth;var a=new s.Arc([i.x,i.y],{radiusX:t+n/2,radiusY:t+n/2,startAngle:270,endAngle:e});return new f(a,{stroke:{width:n,color:this.options.color||r,opacity:this.options.opacity}})},_centerTemplatePosition:function(e,t){var i=this._getSize();var r=this._getCenter();var n=r.x-e/2;var a=r.y-t/2;var o;var s;if(e<i.width){o=n+e;n=Math.max(n,0);if(o>i.width)n-=o-i.width}if(t<i.height){s=a+t;if(s>i.height)a-=s-i.height}return{left:n,top:a}},_getCenter:function(){var e=this._getSize();return new c.Point(e.width/2,e.height/2)},_getSize:function(){var e=this.element;var t={width:y,height:p};var i=e[0].offsetWidth;var r=e[0].offsetHeight;if(!i)i=t.width;if(!r)r=t.height;return{width:i,height:r}},_surfaceElement:function(){if(!this.surfaceElement){this.surfaceElement=document.createElement("div");this.element[0].appendChild(this.surfaceElement)}return this.surfaceElement},_initSurface:function(){var e=this;var t=e.options;var i=e.surface;var r=this._surfaceElement();var n=this._getSize();c.elementSize(r,n);if(!i)this.surface=d.create(r,{type:t.renderAs});else{this.surface.clear();this.surface.resize()}}});function E(e){var t=c.ui.themes||{};var i=e.theme||"";var r=i.toLowerCase();if(c.SASS_THEMES.indexOf(r)!=-1)return c.autoTheme().gauge;return(t[i]||t[r]||{}).gauge}return e.plugin(x),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,i){(i||t)()});
//# sourceMappingURL=kendo.circularprogressbar.min.js.map
