﻿(function () {
    var KSValidator = window.KSValidator = window.KSValidator || {};

    KSValidator.getArgs = function () {
        return {
            value: "",
            newValue: ""
        };
    }

    KSValidator.validateCisloUctu = function (val) {
        var val = val.trim();
        var predcisli = "";
        var cislo = "";

        if (/^([0-9]{2,16})$/.test(val)) {
            if (val.length > 10) {
                predcisli = val.substring(0, val.length - 10);
                cislo = val.substring(val.length - 10, val.length)
            }
            else {
                cislo = val;
            }
        }
        else if (/^(([0-9]{0,6})-)?([0-9]{2,10})$/.test(val)) {
            parsed = /^(([0-9]{0,6})-)?([0-9]{2,10})$/.exec(val);
            predcisli = parsed[2];
            cislo = parsed[3];
        }
        else {
            return false;
        }

        predcisli = zeroPad(predcisli, 6);
        cislo = zeroPad(cislo, 10);

        isOkpredcisli = (10 * predcisli[0]
            + 5 * predcisli[1]
            + 8 * predcisli[2]
            + 4 * predcisli[3]
            + 2 * predcisli[4]
            + 1 * predcisli[5]) % 11 == 0;

        if (!isOkpredcisli) {
            return false;
        }

        isOkcislo = (6 * cislo[0]
            + 3 * cislo[1]
            + 7 * cislo[2]
            + 9 * cislo[3]
            + 10 * cislo[4]
            + 5 * cislo[5]
            + 8 * cislo[6]
            + 4 * cislo[7]
            + 2 * cislo[8]
            + 1 * cislo[9]) % 11 == 0;

        if (!isOkcislo) {
            return false;
        }

        return true;
    };

    KSValidator.validateIban = function (val) {
        var val = val.trim();

        return IBAN.isValid(val);
    }

    KSValidator.validateEmail = function (val) {
        var val = val.trim();
        var ret = "";

        if (/([a-zA-Z0-9_\-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9\-]+\.)+))([a-zA-Z]{2,}|[0-9]{1,3})/.test(val))
            ret = /([a-zA-Z0-9_\-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9\-]+\.)+))([a-zA-Z]{2,}|[0-9]{1,3})/.exec(val);

        if (ret[0] == val)
            return true;
        else
            return false;
    };

    KSValidator.validateTelefon = function (val, args, regionprefix) {
        var val = val.trim();
        if (val.startsWith("+")) {
            val = val.substring(1, val.length);
        }

        if (args)
            args.value = val;

        if (val.length < 9) {
            return false;
        }

        if (val.length == 9) {
            val = regionprefix.concat(val);
            if (args)
                args.newValue = val;
        }

        if (val.length < 11 || val.length > 13) {
            return false;
        }

        var val_test = val.replace("+", "").replace(" ", "");
        var regions = KSValidator.regions;
       
        for (var i = 0; i < regions.length; i = i + 1) {
            var localcode = regions[i][4];
            if (val_test.startsWith(localcode)) {
                val = "+" + regions[i][3] + " " + val_test.substring(regions[i][3].length);
                if (args)
                    args.newValue = val;
                return true;
            }
        }
        return false;
    };

    KSValidator.regions = null; //plní se v Main.Master v initMaster()

    KSValidator.validateRodneCislo = function (val) { 
        var val = val.trim();
        var year, month, day, ext, c, mod;
        var parsed = /(\d\d)(\d\d)(\d\d)[ /]*(\d\d\d)(\d?)/.exec(val);
        if (parsed) {
            year = parsed[1];
            month = parsed[2];
            day = parsed[3];
            ext = parsed[4];
            c = parsed[5];
        }
        else {
            return false;
        }

        var aktYear = new Date().getFullYear();
        var aktYears = aktYear % 100;
        var aktCent = aktYear - aktYears;

        if (c === '') {
            year = year <= aktYears ? (parseInt(year) + aktCent) : (parseInt(year) + aktCent - 100);
        }
        else {
            // kontrolní číslice
            mod = (year + month + day + ext) % 11;
            modc = (year + month + day + ext + c) % 11;
            year = year <= aktYears ? (parseInt(year) + aktCent) : (parseInt(year) + aktCent - 100);

            // do roku 1985 platilo jiné pravidlo pro kontrolní číslici
            if (year <= 1985) {
                if (mod === 10) mod = 0;
                if (mod !== parseInt(c)) {
                    return false;
                }
            }
            else if (modc !== 0) {
                    return false;
            }
        }

        // PMEJ 20.06.2025 - zakomentováno, lidé chtějí pracovat i po 80
        //čísla starší než 80 let jsou pravděpodobněji překlep 
        //if ((aktYear - year) > 80)
        //    return false;

        // k měsíci může být připočteno 20, 50 nebo 70
        if (month > 70 && year > 2003) {
            month = parseInt(month) - 70;
        }
        else if (month > 50) {
            month = parseInt(month) - 50;
        }
        else if (month > 20 && year > 2003) {
            month = parseInt(month) - 20;
        }

        // dále již jen kontrola datumu i pro MS IE 
        if (parseInt(month) < 1 || parseInt(month) > 12 || parseInt(day) < 1 || parseInt(day) > 31) {
            return false;
        }

        var date = new Date(year + "/" + month + "/" + day);

        if (!date.getDate()) {
            return false;
        }

        if (date.getFullYear() != parseInt(year) || (date.getMonth() + 1) != parseInt(month) || date.getDate() != parseInt(day)) {
            return false;
        }

        return true;
    }

    function zeroPad(num, places) {
        var zero = places - num.length + 1;
        return Array(+(zero > 0 && zero)).join("0") + num;
    }

}());