/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.drawer.min",["kendo.userevents.min"],function(){var e={id:"drawer",name:"Drawer",category:"web",description:"The Kendo Drawer widget provides slide to reveal sidebar",depends:["userevents"]},d=window.kendo.jQuery,t=void 0,n=window.kendo,r,a=n.ui.Widget,m,f,i=".kendoDrawer",s="k-focus",o=n.keys,w,u="tabIndex",l="push",h="overlay",v="left",p="right",c=n.ui.Widget.extend({init:function(e,t){var r=this;var i;a.fn.init.call(this,e,t);t=r.options;r._element(e);r._wrapper(e);r._navigatable();r.position();r._mode();if(t.mini)r._miniMode();r._initDrawerItems();if(t.mini&&t.mode!=l)r._setBodyOffset();i=this.userEvents=new n.UserEvents(t.mode!=l?d(document.body):this.drawerContainer,{fastTap:true,allowSelection:true});r.tap=function(e){if(d.contains(r.drawerItemsWrapper[0],e.event.target))r._itemClick(e);if(t.autoCollapse&&r.visible&&!r.trigger("hide",{sender:this})){r.hide();e.preventDefault()}};if(this.options.swipeToOpen){i.bind("start",function(e){r._start(e)});i.bind("move",function(e){r._update(e)});i.bind("end",function(e){r._end(e)});i.bind("tap",r.tap)}else i.bind("press",r.tap);if(t.minHeight&&t.mode==l)r.drawerContainer.css("min-height",t.minHeight)},_element:function(){var e=this;var t=e.element;var r=e.options;e.contentElement=t.children().wrapAll("<div class='k-drawer-content'></div>").parent();e.drawerElement=d(r.template);t.addClass("k-widget k-drawer")},_navigatable:function(){if(!this.options.navigatable)return;var e=this;var t=e.element;var r=t.find("[data-role='drawer-item']");t.find("[data-role='drawer-separator']").attr("aria-hidden",true);r.attr("role","tab");r.first().parent().attr("role","tablist").attr("aria-orientation","vertical");t.attr(u,0).on("focus"+i,e._focus.bind(e)).on("focusout"+i,e._blur.bind(e)).on("keydown"+i,e,e._keyDown.bind(e))},_blur:function(){var e=this;if(e._current)e._current.removeClass(s)},_focus:function(){var e=this;e._setCurrent(e._current?e._current:e.drawerItemsWrapper.find("[data-role='drawer-item']").eq(0))},_setCurrent:function(e){var t=this;var r=n.guid();var i=d(e);if(t._current){d(t._current).removeClass(s).removeAttr("id");t.element.removeAttr("aria-activedescendant")}i.attr("id",r).addClass(s);t.element.attr("aria-activedescendant",r);t._current=i},_keyDown:function(e){var t=this;var r=false;var i=t._current;var a;if(e.keyCode==o.UP){r=true;a=i.prevAll("[data-role='drawer-item']").first();if(a.length)t._setCurrent(a);else t._setCurrent(i.parent().find("[data-role='drawer-item']").last())}if(e.keyCode==o.DOWN){r=true;a=i.nextAll("[data-role='drawer-item']").first();if(a.length)t._setCurrent(a);else t._setCurrent(i.parent().find("[data-role='drawer-item']").first())}if(e.keyCode==o.HOME){r=true;t._setCurrent(t.drawerItemsWrapper.find("[data-role='drawer-item']").eq(0))}if(e.keyCode==o.END){r=true;t._setCurrent(t.drawerItemsWrapper.find("[data-role='drawer-item']").last())}if(e.keyCode==o.SPACEBAR||e.keyCode==o.ENTER){r=true;t.tap({event:{target:i[0]},preventDefault:d.noop})}if(e.keyCode==o.ESC){r=true;t.hide()}if(r)e.preventDefault()},_wrapper:function(){var e=this.options;var t=this.drawerElement;var r=this.element;var i=this.contentElement;var a=this.drawerItemsWrapper=t.wrapAll("<div class='k-drawer-items'></div>").parent();var s=this.drawerWrapper=a.wrap("<div class='k-drawer-wrapper'></div>").parent();var n=this.drawerContainer=r.wrap("<div class='k-drawer-container'></div>").parent();if(e.mini){if(e.mini.width)s.width(e.mini.width)}else s.width(0);if(e.mode===l)n.append(i);else if(e.mode===h){n.after(i);d(document.body).prepend(n)}r.append(s)},_setBodyOffset:function(){var e=this.element.outerWidth();if(this.leftPositioned)d(document.body).css("padding-left",e);else d(document.body).css("padding-right",e)},_initDrawerItems:function(){var e=this.drawerItemsWrapper;var t=e.find("[data-role='drawer-item']");var r=e.find("[data-role='drawer-separator']");t.addClass("k-drawer-item");r.addClass("k-drawer-item k-drawer-separator");if(this._selectedItemIndex>=0){t.removeClass("k-selected");t.eq(this._selectedItemIndex).addClass("k-selected")}if(this.options.navigatable)t.attr("aria-selected",false)},_mode:function(){var e=this.options;var t=this.drawerContainer;var r;if(e.mode==l)t.addClass("k-drawer-"+l);else{t.addClass("k-drawer-"+h);r=this.overlayContainer=d('<div class="k-overlay"></div>');r.hide();t.prepend(r)}},_miniMode:function(){var e=this.options;var t=this.drawerContainer;var r=e.mini.width;var i=this._miniTemplate=e.mini.template&&d(e.mini.template);var a=this.drawerItemsWrapper;var s=this.drawerWrapper;t.addClass("k-drawer-mini");if(i)a.html(i);if(r)s.width(r);this.minWidth=e.mini.width||this.drawerWrapper.width()},show:function(){var e=this.drawerWrapper;var t=this.drawerContainer;var r=this.options;var i=t.hasClass("k-drawer-expanded");var a=this._miniTemplate;var s=this.drawerElement;var n=this.drawerItemsWrapper;if(!i){t.addClass("k-drawer-expanded");this.visible=true}if(a){n.html(s);this._initDrawerItems();this._selectItem()}e.width(r.width);if(r.mode===h){this.overlayContainer.show();this.visible=true}},hide:function(){var e=this;var t=e.drawerWrapper;var r=e.drawerContainer;var i=this.options;var a=this.drawerItemsWrapper;var s=this._miniTemplate;var n=i.mini&&i.mini.width;if(this._miniTemplate){a.html(s);e._initDrawerItems();this._selectItem()}if(i.mini)if(n)t.width(n);else t.width("");else t.width(0);if(this.visible){r.removeClass("k-drawer-expanded");this.visible=false}if(i.mode===h)this.overlayContainer.hide()},position:function(e){var t=this;var r=t.options;var i=e||r.position;var a=t.drawerContainer;if(i==p){a.removeClass("k-drawer-"+v);a.addClass("k-drawer-"+p)}else{a.removeClass("k-drawer-"+p);a.addClass("k-drawer-"+v)}this.leftPositioned=i===v},_start:function(e){var t=this;var r=this.options;var i=this.drawerWrapper;var a=this.drawerItemsWrapper;var s=e.sender;if(Math.abs(e.x.velocity)<Math.abs(e.y.velocity)||n.triggeredByInput(e.event)){s.cancel();return}if(this.drawerMini)a.html(t.drawerElement);i.css("transition","none");if(r.mode!=l)this.overlayContainer.show()},_update:function(e){var t=this.options;var r=t.mode;if(r==l)this._push(e);else this._overlay(e)},_end:function(e){var t=e.x.velocity;var r=this.options;var i=this.drawerWrapper;var a=i.width();var s=a>r.width/2;var n=.8;var d;i.css("transition","all .3s ease-out");if(this.leftPositioned)d=t>-n&&(t>n||s);else d=t<n&&(t<-n||s);if(d)if(this.trigger("show",{sender:this})){e.preventDefault();this.hide()}else this.show();else if(this.trigger("hide",{sender:this})){e.preventDefault();this.show()}else this.hide()},_overlay:function(e){var t=this.options;var r=t.mini&&t.mini.width||this.minWidth||0;var i=this.drawerWrapper;var a=i.width();var s;var n;n=a+(this.leftPositioned?e.x.delta:-e.x.delta);s=Math.min(Math.max(n,r),t.width);e.event.preventDefault();e.event.stopPropagation();i.width(s)},_push:function(e){var t=this.options;var r=t.mini&&t.mini.width||this.minWidth||0;var i=this.drawerWrapper;var a=i.width();var s;var n;n=a+(this.leftPositioned?e.x.delta:-e.x.delta);s=Math.min(Math.max(n,r),t.width);e.event.preventDefault();e.event.stopPropagation();i.width(s)},_selectItem:function(e){var t;if(e){e.addClass("k-selected");this.trigger("itemClick",{item:e,sender:this});this._selectedItemIndex=e.index();return}t=this._selectedItemIndex;if(t)this.drawerItemsWrapper.find("[data-role='drawer-item']").eq(t).addClass("k-selected")},_itemClick:function(e){var t=this;var r;var i;if(d(e.event.target).find(".k-drawer-item").length>0)r=d(e.event.target).find(".k-drawer-item");else if(d(e.event.target).closest(".k-drawer-item").length>0)r=d(e.event.target).closest(".k-drawer-item");else if(d(e.event.target).hasClass(".k-drawer-item"))r=d(e.event.target);i=t.drawerItemsWrapper.find(".k-drawer-item").removeClass("k-selected");t._selectItem(r);if(t.options.navigatable){i.attr("aria-selected",false);r.attr("aria-selected",true);t._setCurrent(r)}},destroy:function(){var e=this.options;if(e.mode!=l)if(this.leftPositioned)d(document.body).css("padding-left",0);else d(document.body).css("padding-right",0);a.fn.destroy.call(this);this.userEvents.destroy();n.destroy(this.element);this.element=this.drawerWrapper=this.drawerElement=this.drawerContainer=this.drawerItemsWrapper=this._miniTemplate=null},options:{name:"Drawer",autoCollapse:true,position:v,mode:"overlay",swipeToOpen:true,width:280,mini:false,navigatable:false,template:""},events:["hide","show","itemClick"]});return n.ui.plugin(c),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,r){(r||t)()});
//# sourceMappingURL=kendo.drawer.min.js.map
